import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageObjectAclConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl#bucket StorageObjectAcl#bucket}
    */
    readonly bucket: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl#object StorageObjectAcl#object}
    */
    readonly object: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl#predefined_acl StorageObjectAcl#predefined_acl}
    */
    readonly predefinedAcl?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl#role_entity StorageObjectAcl#role_entity}
    */
    readonly roleEntity?: string[];
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl google_storage_object_acl}
*/
export declare class StorageObjectAcl extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_object_acl";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_object_acl google_storage_object_acl} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageObjectAclConfig
    */
    constructor(scope: Construct, id: string, config: StorageObjectAclConfig);
    private _bucket?;
    get bucket(): string;
    set bucket(value: string);
    get bucketInput(): string | undefined;
    get id(): string;
    private _object?;
    get object(): string;
    set object(value: string);
    get objectInput(): string | undefined;
    private _predefinedAcl?;
    get predefinedAcl(): string;
    set predefinedAcl(value: string);
    resetPredefinedAcl(): void;
    get predefinedAclInput(): string | undefined;
    private _roleEntity?;
    get roleEntity(): string[];
    set roleEntity(value: string[]);
    resetRoleEntity(): void;
    get roleEntityInput(): string[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
