import { ApiObject, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
import * as k8s from './imports/k8s';
export * as k8s from './imports/k8s';
/**
 * @experimental
 */
export interface ApplicationSource {
    /**
     * @experimental
     */
    readonly repoURL?: string;
    /**
     * @experimental
     */
    readonly targetRevision?: string;
    /**
     * @experimental
     */
    readonly path?: string;
    /**
     * @experimental
     */
    readonly directory?: ApplicationDirectory;
    /**
     * @experimental
     */
    readonly plugin?: ApplicationPlugin;
}
/**
 * @experimental
 */
export interface ApplicationDirectory {
    /**
     * @experimental
     */
    readonly recurse?: boolean;
}
/**
 * @experimental
 */
export interface ApplicationPlugin {
    /**
     * @experimental
     */
    readonly name?: string;
    /**
     * @experimental
     */
    readonly env?: k8s.EnvVar;
}
/**
 * @experimental
 */
export interface ApplicationDestination {
    /**
     * @experimental
     */
    readonly server?: string;
    /**
     * @experimental
     */
    readonly namespace?: string;
}
/**
 * @experimental
 */
export interface SyncPolicyAutomated {
    /**
     * @experimental
     */
    readonly prune?: boolean;
    /**
     * @experimental
     */
    readonly selfHeal?: boolean;
    /**
     * @experimental
     */
    readonly allowEmpty?: boolean;
}
/**
 * @experimental
 */
export interface RetryBackoff {
    /**
     * @experimental
     */
    readonly duration?: string;
    /**
     * @experimental
     */
    readonly factor?: number;
    /**
     * @experimental
     */
    readonly maxDuration?: string;
}
/**
 * @experimental
 */
export interface SyncRetry {
    /**
     * @experimental
     */
    readonly limit?: number;
    /**
     * @experimental
     */
    readonly backoff?: RetryBackoff;
}
/**
 * @experimental
 */
export interface ApplicationSyncPolicy {
    /**
     * @experimental
     */
    readonly automated?: SyncPolicyAutomated;
    /**
     * @experimental
     */
    readonly syncOptions?: string[];
    /**
     * @experimental
     */
    readonly retry?: SyncRetry;
}
/**
 * @experimental
 */
export interface ArgoCdApplicationSpec {
    /**
     * @experimental
     */
    readonly project?: string;
    /**
     * @experimental
     */
    readonly source?: ApplicationSource;
    /**
     * @experimental
     */
    readonly destination?: ApplicationDestination;
    /**
     * @experimental
     */
    readonly syncPolicy?: ApplicationSyncPolicy;
}
/**
 * @experimental
 */
export interface ProjectRoles {
    /**
     * @experimental
     */
    readonly name?: string;
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly policies?: string[];
    /**
     * @experimental
     */
    readonly groups?: string[];
}
/**
 * @experimental
 */
export interface ResourceRef {
    /**
     * @experimental
     */
    readonly group?: string;
    /**
     * @experimental
     */
    readonly kind?: string;
}
/**
 * @experimental
 */
export interface ArgoCdProjectSpec {
    /**
     * @experimental
     */
    readonly description?: string;
    /**
     * @experimental
     */
    readonly sourceRepos?: string[];
    /**
     * @experimental
     */
    readonly destination?: ApplicationDestination[];
    /**
     * @experimental
     */
    readonly clusterResourceWhiteList?: ResourceRef[];
    /**
     * @experimental
     */
    readonly namespaceResourceBlacklist?: ResourceRef[];
    /**
     * @experimental
     */
    readonly namespaceResourceWhitelist?: ResourceRef[];
    /**
     * @experimental
     */
    readonly roles?: ProjectRoles[];
}
/**
 * @experimental
 */
export interface ArgoCdApplicationProps {
    /**
     * @experimental
     */
    readonly metadata?: k8s.ObjectMeta;
    /**
     * @experimental
     */
    readonly spec?: ArgoCdApplicationSpec;
}
/**
 * @experimental
 */
export interface ArgoCdProjectProps {
    /**
     * @experimental
     */
    readonly metadata?: k8s.ObjectMeta;
    /**
     * @experimental
     */
    readonly spec?: ArgoCdProjectSpec;
}
/**
 * @experimental
 */
export declare class ArgoCdProject extends ApiObject {
    /**
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: ArgoCdProjectProps): any;
    /**
     * (experimental) Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ArgoCdProjectProps);
}
/**
 * @experimental
 */
export declare class ArgoCdApplication extends ApiObject {
    /**
     * @experimental
     */
    static readonly GVK: GroupVersionKind;
    /**
     * (experimental) Renders a Kubernetes manifest for an ingress object. https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props.
     * @experimental
     */
    static manifest(props: ArgoCdApplicationProps): any;
    /**
     * (experimental) Defines an "extentions" API object for AWS Load Balancer Controller - https://github.com/kubernetes-sigs/aws-load-balancer-controller.
     *
     * @param scope the scope in which to define this object.
     * @param id a scope-local name for the object.
     * @param props initialization props.
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ArgoCdApplicationProps);
}
