"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*! Copyright [Amazon.com](http://amazon.com/), Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0 */
const render_options_1 = require("projen/lib/javascript/render-options");
const synth_1 = require("projen/lib/util/synth");
const src_1 = require("../src");
describe("PDK Pipeline Py Unit Tests", () => {
    it("Defaults", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "Defaults",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("projenrc synth correctly", () => {
        const project = new src_1.PDKPipelinePyProject(render_options_1.renderProjenInitOptions("@aws-prototyping-sdk/pipeline.PDKPipelinePyProject", {
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "defaults",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "ProjenRc",
        }));
        expect(synth_1.synthSnapshot(project)[".projenrc.py"]).toMatchSnapshot();
    });
    it("With Context", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "with_context",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "WithContext",
            context: {
                sonarqubeScannerConfig: {
                    sonarqubeEndpoint: "https://my.endpoint",
                    sonarqubeAuthorizedGroup: "group",
                    sonarqubeDefaultProfileOrGateName: "default",
                    sonarqubeSpecificProfileOrGateName: "specific",
                    sonarqubeProjectName: "WithContext",
                    sonarqubeTags: ["sample"],
                    preArchiveCommands: ["echo here"],
                },
            },
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
    it("Custom AppEntrypoint", () => {
        const project = new src_1.PDKPipelinePyProject({
            authorEmail: "test@test.com",
            authorName: "test",
            moduleName: "custom_app_entrypoint",
            version: "0.0.0",
            cdkVersion: "2.0.0",
            name: "CustomAppEntrypoint",
            appEntrypoint: "updated.py",
        });
        expect(sanitizeOutput(synth_1.synthSnapshot(project))).toMatchSnapshot();
    });
});
function sanitizeOutput(output) {
    Object.keys(output)
        .filter((k) => k.includes("__pycache__"))
        .forEach((k) => delete output[k]);
    return output;
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGRrLXBpcGVsaW5lLXB5LXByb2plY3QudGVzdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBkay1waXBlbGluZS1weS1wcm9qZWN0LnRlc3QudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQTtzQ0FDc0M7QUFDdEMseUVBQStFO0FBQy9FLGlEQUFtRTtBQUNuRSxnQ0FBOEM7QUFFOUMsUUFBUSxDQUFDLDRCQUE0QixFQUFFLEdBQUcsRUFBRTtJQUMxQyxFQUFFLENBQUMsVUFBVSxFQUFFLEdBQUcsRUFBRTtRQUNsQixNQUFNLE9BQU8sR0FBRyxJQUFJLDBCQUFvQixDQUFDO1lBQ3ZDLFdBQVcsRUFBRSxlQUFlO1lBQzVCLFVBQVUsRUFBRSxNQUFNO1lBQ2xCLFVBQVUsRUFBRSxVQUFVO1lBQ3RCLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFVBQVUsRUFBRSxPQUFPO1lBQ25CLElBQUksRUFBRSxVQUFVO1NBQ2pCLENBQUMsQ0FBQztRQUNILE1BQU0sQ0FBQyxjQUFjLENBQUMscUJBQWEsQ0FBQyxPQUFPLENBQUMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7SUFDbkUsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsMEJBQTBCLEVBQUUsR0FBRyxFQUFFO1FBQ2xDLE1BQU0sT0FBTyxHQUFHLElBQUksMEJBQW9CLENBQ3RDLHdDQUF1QixDQUNyQixvREFBb0QsRUFDcEQ7WUFDRSxXQUFXLEVBQUUsZUFBZTtZQUM1QixVQUFVLEVBQUUsTUFBTTtZQUNsQixVQUFVLEVBQUUsVUFBVTtZQUN0QixPQUFPLEVBQUUsT0FBTztZQUNoQixVQUFVLEVBQUUsT0FBTztZQUNuQixJQUFJLEVBQUUsVUFBVTtTQUNqQixDQUNGLENBQ0YsQ0FBQztRQUNGLE1BQU0sQ0FBQyxxQkFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLGNBQWMsQ0FBQyxDQUFDLENBQUMsZUFBZSxFQUFFLENBQUM7SUFDbkUsQ0FBQyxDQUFDLENBQUM7SUFFSCxFQUFFLENBQUMsY0FBYyxFQUFFLEdBQUcsRUFBRTtRQUN0QixNQUFNLE9BQU8sR0FBRyxJQUFJLDBCQUFvQixDQUFDO1lBQ3ZDLFdBQVcsRUFBRSxlQUFlO1lBQzVCLFVBQVUsRUFBRSxNQUFNO1lBQ2xCLFVBQVUsRUFBRSxjQUFjO1lBQzFCLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFVBQVUsRUFBRSxPQUFPO1lBQ25CLElBQUksRUFBRSxhQUFhO1lBQ25CLE9BQU8sRUFBRTtnQkFDUCxzQkFBc0IsRUFBRTtvQkFDdEIsaUJBQWlCLEVBQUUscUJBQXFCO29CQUN4Qyx3QkFBd0IsRUFBRSxPQUFPO29CQUNqQyxpQ0FBaUMsRUFBRSxTQUFTO29CQUM1QyxrQ0FBa0MsRUFBRSxVQUFVO29CQUM5QyxvQkFBb0IsRUFBRSxhQUFhO29CQUNuQyxhQUFhLEVBQUUsQ0FBQyxRQUFRLENBQUM7b0JBQ3pCLGtCQUFrQixFQUFFLENBQUMsV0FBVyxDQUFDO2lCQUNsQzthQUNGO1NBQ0YsQ0FBQyxDQUFDO1FBRUgsTUFBTSxDQUFDLGNBQWMsQ0FBQyxxQkFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztJQUNuRSxDQUFDLENBQUMsQ0FBQztJQUVILEVBQUUsQ0FBQyxzQkFBc0IsRUFBRSxHQUFHLEVBQUU7UUFDOUIsTUFBTSxPQUFPLEdBQUcsSUFBSSwwQkFBb0IsQ0FBQztZQUN2QyxXQUFXLEVBQUUsZUFBZTtZQUM1QixVQUFVLEVBQUUsTUFBTTtZQUNsQixVQUFVLEVBQUUsdUJBQXVCO1lBQ25DLE9BQU8sRUFBRSxPQUFPO1lBQ2hCLFVBQVUsRUFBRSxPQUFPO1lBQ25CLElBQUksRUFBRSxxQkFBcUI7WUFDM0IsYUFBYSxFQUFFLFlBQVk7U0FDNUIsQ0FBQyxDQUFDO1FBQ0gsTUFBTSxDQUFDLGNBQWMsQ0FBQyxxQkFBYSxDQUFDLE9BQU8sQ0FBQyxDQUFDLENBQUMsQ0FBQyxlQUFlLEVBQUUsQ0FBQztJQUNuRSxDQUFDLENBQUMsQ0FBQztBQUNMLENBQUMsQ0FBQyxDQUFDO0FBRUgsU0FBUyxjQUFjLENBQUMsTUFBbUI7SUFDekMsTUFBTSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUM7U0FDaEIsTUFBTSxDQUFDLENBQUMsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQyxDQUFDO1NBQ3hDLE9BQU8sQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMsT0FBTyxNQUFNLENBQUMsQ0FBQyxDQUFDLENBQUMsQ0FBQztJQUVwQyxPQUFPLE1BQU0sQ0FBQztBQUNoQixDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLyohIENvcHlyaWdodCBbQW1hem9uLmNvbV0oaHR0cDovL2FtYXpvbi5jb20vKSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wICovXG5pbXBvcnQgeyByZW5kZXJQcm9qZW5Jbml0T3B0aW9ucyB9IGZyb20gXCJwcm9qZW4vbGliL2phdmFzY3JpcHQvcmVuZGVyLW9wdGlvbnNcIjtcbmltcG9ydCB7IFN5bnRoT3V0cHV0LCBzeW50aFNuYXBzaG90IH0gZnJvbSBcInByb2plbi9saWIvdXRpbC9zeW50aFwiO1xuaW1wb3J0IHsgUERLUGlwZWxpbmVQeVByb2plY3QgfSBmcm9tIFwiLi4vc3JjXCI7XG5cbmRlc2NyaWJlKFwiUERLIFBpcGVsaW5lIFB5IFVuaXQgVGVzdHNcIiwgKCkgPT4ge1xuICBpdChcIkRlZmF1bHRzXCIsICgpID0+IHtcbiAgICBjb25zdCBwcm9qZWN0ID0gbmV3IFBES1BpcGVsaW5lUHlQcm9qZWN0KHtcbiAgICAgIGF1dGhvckVtYWlsOiBcInRlc3RAdGVzdC5jb21cIixcbiAgICAgIGF1dGhvck5hbWU6IFwidGVzdFwiLFxuICAgICAgbW9kdWxlTmFtZTogXCJkZWZhdWx0c1wiLFxuICAgICAgdmVyc2lvbjogXCIwLjAuMFwiLFxuICAgICAgY2RrVmVyc2lvbjogXCIyLjAuMFwiLFxuICAgICAgbmFtZTogXCJEZWZhdWx0c1wiLFxuICAgIH0pO1xuICAgIGV4cGVjdChzYW5pdGl6ZU91dHB1dChzeW50aFNuYXBzaG90KHByb2plY3QpKSkudG9NYXRjaFNuYXBzaG90KCk7XG4gIH0pO1xuXG4gIGl0KFwicHJvamVucmMgc3ludGggY29ycmVjdGx5XCIsICgpID0+IHtcbiAgICBjb25zdCBwcm9qZWN0ID0gbmV3IFBES1BpcGVsaW5lUHlQcm9qZWN0KFxuICAgICAgcmVuZGVyUHJvamVuSW5pdE9wdGlvbnMoXG4gICAgICAgIFwiQGF3cy1wcm90b3R5cGluZy1zZGsvcGlwZWxpbmUuUERLUGlwZWxpbmVQeVByb2plY3RcIixcbiAgICAgICAge1xuICAgICAgICAgIGF1dGhvckVtYWlsOiBcInRlc3RAdGVzdC5jb21cIixcbiAgICAgICAgICBhdXRob3JOYW1lOiBcInRlc3RcIixcbiAgICAgICAgICBtb2R1bGVOYW1lOiBcImRlZmF1bHRzXCIsXG4gICAgICAgICAgdmVyc2lvbjogXCIwLjAuMFwiLFxuICAgICAgICAgIGNka1ZlcnNpb246IFwiMi4wLjBcIixcbiAgICAgICAgICBuYW1lOiBcIlByb2plblJjXCIsXG4gICAgICAgIH1cbiAgICAgIClcbiAgICApO1xuICAgIGV4cGVjdChzeW50aFNuYXBzaG90KHByb2plY3QpW1wiLnByb2plbnJjLnB5XCJdKS50b01hdGNoU25hcHNob3QoKTtcbiAgfSk7XG5cbiAgaXQoXCJXaXRoIENvbnRleHRcIiwgKCkgPT4ge1xuICAgIGNvbnN0IHByb2plY3QgPSBuZXcgUERLUGlwZWxpbmVQeVByb2plY3Qoe1xuICAgICAgYXV0aG9yRW1haWw6IFwidGVzdEB0ZXN0LmNvbVwiLFxuICAgICAgYXV0aG9yTmFtZTogXCJ0ZXN0XCIsXG4gICAgICBtb2R1bGVOYW1lOiBcIndpdGhfY29udGV4dFwiLFxuICAgICAgdmVyc2lvbjogXCIwLjAuMFwiLFxuICAgICAgY2RrVmVyc2lvbjogXCIyLjAuMFwiLFxuICAgICAgbmFtZTogXCJXaXRoQ29udGV4dFwiLFxuICAgICAgY29udGV4dDoge1xuICAgICAgICBzb25hcnF1YmVTY2FubmVyQ29uZmlnOiB7XG4gICAgICAgICAgc29uYXJxdWJlRW5kcG9pbnQ6IFwiaHR0cHM6Ly9teS5lbmRwb2ludFwiLFxuICAgICAgICAgIHNvbmFycXViZUF1dGhvcml6ZWRHcm91cDogXCJncm91cFwiLFxuICAgICAgICAgIHNvbmFycXViZURlZmF1bHRQcm9maWxlT3JHYXRlTmFtZTogXCJkZWZhdWx0XCIsXG4gICAgICAgICAgc29uYXJxdWJlU3BlY2lmaWNQcm9maWxlT3JHYXRlTmFtZTogXCJzcGVjaWZpY1wiLFxuICAgICAgICAgIHNvbmFycXViZVByb2plY3ROYW1lOiBcIldpdGhDb250ZXh0XCIsXG4gICAgICAgICAgc29uYXJxdWJlVGFnczogW1wic2FtcGxlXCJdLFxuICAgICAgICAgIHByZUFyY2hpdmVDb21tYW5kczogW1wiZWNobyBoZXJlXCJdLFxuICAgICAgICB9LFxuICAgICAgfSxcbiAgICB9KTtcblxuICAgIGV4cGVjdChzYW5pdGl6ZU91dHB1dChzeW50aFNuYXBzaG90KHByb2plY3QpKSkudG9NYXRjaFNuYXBzaG90KCk7XG4gIH0pO1xuXG4gIGl0KFwiQ3VzdG9tIEFwcEVudHJ5cG9pbnRcIiwgKCkgPT4ge1xuICAgIGNvbnN0IHByb2plY3QgPSBuZXcgUERLUGlwZWxpbmVQeVByb2plY3Qoe1xuICAgICAgYXV0aG9yRW1haWw6IFwidGVzdEB0ZXN0LmNvbVwiLFxuICAgICAgYXV0aG9yTmFtZTogXCJ0ZXN0XCIsXG4gICAgICBtb2R1bGVOYW1lOiBcImN1c3RvbV9hcHBfZW50cnlwb2ludFwiLFxuICAgICAgdmVyc2lvbjogXCIwLjAuMFwiLFxuICAgICAgY2RrVmVyc2lvbjogXCIyLjAuMFwiLFxuICAgICAgbmFtZTogXCJDdXN0b21BcHBFbnRyeXBvaW50XCIsXG4gICAgICBhcHBFbnRyeXBvaW50OiBcInVwZGF0ZWQucHlcIixcbiAgICB9KTtcbiAgICBleHBlY3Qoc2FuaXRpemVPdXRwdXQoc3ludGhTbmFwc2hvdChwcm9qZWN0KSkpLnRvTWF0Y2hTbmFwc2hvdCgpO1xuICB9KTtcbn0pO1xuXG5mdW5jdGlvbiBzYW5pdGl6ZU91dHB1dChvdXRwdXQ6IFN5bnRoT3V0cHV0KSB7XG4gIE9iamVjdC5rZXlzKG91dHB1dClcbiAgICAuZmlsdGVyKChrKSA9PiBrLmluY2x1ZGVzKFwiX19weWNhY2hlX19cIikpXG4gICAgLmZvckVhY2goKGspID0+IGRlbGV0ZSBvdXRwdXRba10pO1xuXG4gIHJldHVybiBvdXRwdXQ7XG59XG4iXX0=