"""
Django settings for dashboard project.

Generated by 'django-admin startproject' using Django 2.2.7.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""

import os

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = os.environ.get('ALGE_APP_SECRET_KEY', '4dbgj9((dey#0-$ipt!1ie@spppfbvj!2av6s1-16)1xp73pjr')

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = os.environ.get('ALLOWED_HOSTS').split(',') if os.environ.get('ALLOWED_HOSTS') else ['0.0.0.0',
                                                                                                    os.environ.get('ALGE_PUBLIC_ENDPOINT')]


# Application definition

INSTALLED_APPS = [
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.messages',
    'django.contrib.staticfiles',
    'django_extensions',
    'django_jinja',
    'crispy_forms',
    'mathfilters',
    'app',
]

MIDDLEWARE = [
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'alge.urls'

TEMPLATES = [
    {
        "BACKEND": "django_jinja.backend.Jinja2",
        "APP_DIRS": True,
        "OPTIONS": {
            "match_extension": ".jinja",
        }
    },
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [os.path.join(BASE_DIR, 'templates')],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]


WSGI_APPLICATION = 'alge.wsgi.application'


# Database
# https://docs.djangoproject.com/en/2.2/ref/settings/#databases
if os.getenv('ALGE_GC_RUN'):
    ENGINE = 'django.db.backends.postgresql'
    NAME = os.getenv('ALGE_DB_USER')
    USER = os.getenv('ALGE_DB_USER')
    PASSWORD = os.getenv('ALGE_DB_PASSWORD')
    PORT = os.getenv('ALGE_DB_PORT')
    HOST = os.getenv('ALGE_HOST')

    DATABASES = {
        'default': {
            'ENGINE': ENGINE,
            'NAME': NAME,
            'USER': USER,
            'PASSWORD': PASSWORD,
            'PORT': PORT,
            'HOST': HOST
        }
    }
    TABLES_PATH = f'gs://{os.getenv("ALGE_DB_TABLES")}'
    STATIC_ROOT = os.path.join(BASE_DIR, 'static')
    STATIC_URL = f'https://storage.googleapis.com/{os.getenv("ALGE_APP_STATIC_FILES_BUCKET")}/static/'

elif os.getenv('ALGE_LOCAL_RUN'):
    DATABASES = {
            'default': {
                'ENGINE': 'django.db.backends.sqlite3',
                'NAME': os.path.join(BASE_DIR, 'db/db.models'),
            }
    }
    TABLES_PATH = os.path.join(BASE_DIR, 'db/tables')
    STATIC_URL = os.path.join(BASE_DIR, 'static/')
    STATIC_ROOT = os.path.join(BASE_DIR, 'static')
else:
    raise Exception('Please define `ALGE_GC_RUN` or `ALGE_LOCAL_RUN`')



# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en-us'

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


LOGIN_REDIRECT_URL = '/'
LOGOUT_REDIRECT_URL = '/login'

CRISPY_TEMPLATE_PACK = 'bootstrap4'