# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ytdl', 'ytdl.utils']

package_data = \
{'': ['*']}

modules = \
['ytdl_entrypoint']
install_requires = \
['bella>=2.1.3,<3.0.0',
 'fire>=0.3.1,<0.4.0',
 'python-youtube>=0.6.0,<0.7.0',
 'pytube3>=9.6.4,<10.0.0']

entry_points = \
{'console_scripts': ['ytdl = ytdl_entrypoint:init']}

setup_kwargs = {
    'name': 'ytdl',
    'version': '1.0.0rc2',
    'description': '',
    'long_description': '# ytdl\n\nYet another CLI based YouTube downloader tool for linux.\n\n\n[![PyPI version](https://badge.fury.io/py/ytdl.svg)](https://badge.fury.io/py/ytdl)\n[![Build Status](https://travis-ci.org/ndaidong/ytdl.svg?branch=master)](https://travis-ci.org/ndaidong/ytdl)\n[![Coverage Status](https://coveralls.io/repos/github/ndaidong/ytdl/badge.svg?branch=master)](https://coveralls.io/github/ndaidong/ytdl?branch=master)\n\n\n### Features:\n\n- Download only neccessary stream, not the whole video\n- Download all videos or audios belong to a playlist\n- Download with custom name and bounding\n\nJust gather your favourite videos into a playlist, then let\'s `ytdl` download them overnight.\n\n\n## Prerequisites\n\n- Fedora 32+, Ubuntu 20+, Debian 10+\n- [python](https://www.python.org/) 3.6.5 or newer\n- [ffmpeg](https://ffmpeg.org/) 4.0 or newer\n- [YouTube API key](https://developers.google.com/youtube/registering_an_application)\n\n\n## Install\n\n\nRecommend to use [pipx](https://pipxproject.github.io/pipx/):\n\n```bash\npipx install ytdl\nytdl config\n```\n\nHowever, `pip` may work too:\n\n\n```bash\npip install ytdl\n\n# don\'t\nsudo pip install ytdl\n```\n\nBuild from source requires [poetry](https://python-poetry.org/):\n\n```bash\ngit clone git@github.com:ndaidong/ytdl.git && cd ytdl\npoetry install\n\n# use raw script\npoetry run python main.py info\npoetry run python main.py [command] [arguments]\n\n# build wheel to `./dist` folder\npoetry build\n\n# then install it\npipx install dist/ytdl-VERSION-py3-none-any.whl\n\n# test it\nytdl info\n```\n\n\n## CLIs\n\n### Basic commands\n\n| Command | Description | Shortcut |\n|--|--|--|\n| `ytdl config KEY VALUE` | Set config value | `c` |\n| `ytdl config KEY` | Show config property |\n| `ytdl playlist PLAYLIST_URL` | Get playlist index | `p` |\n| `ytdl video VIDEO_URL` | Download a video | `v` |\n| `ytdl audio VIDEO_URL` | Download audio only | `a` |\n\nAlmost cases, `VIDEO_URL` and `PLAYLIST_URL` can be replaced with video ID or playlist ID.\n\n\n### Advanced usage\n\n\n#### Config\n\nThere are 2 properties to configure: `api_key` and `store_dir`.\nAt the first time, `api_key` is empty and you have to set it before using other features.\n\n```bash\n# set new `api_key`\nytdl config api_key YOUR_OWN_YOUTUBE_API_KEY\n\n# change `store_dir` to new path\nytdl config store_dir /storage/downloads/youtube\n\n# get the current value of `api_key`\nytdl config api_key\n\n# show all\nytdl config\n```\n\nBy default, `store_dir` is being set to `/home/{YOUR_USER_NAME}/ytdl_files`, you should change it to more appropriate place.\n\n\n#### Playlist\n\nNote that this command does not download actual video/audio, but a list of indexed items.\n\n```bash\n# get playlist metadata into `{store_dir}/{title}.json`\n# this file contains a list of videos with their ID and title to download later\nytdl playlist https://www.youtube.com/playlist?list=PLAYLIST_ID\n\n# get playlist metadata into `{store_dir}/my_custom_playlist_name.json`\nytdl playlist https://www.youtube.com/playlist?list=PLAYLIST_ID my_custom_playlist_name\n```\n\nFor example if we download the playlist [Linux Tips and Tricks](https://www.youtube.com/playlist?list=PLSmXPSsgkZLsw-vEwve1O7w-Row9TIVqi)\n\nThe indexed file looks like below:\n\n![](https://imgshare.io/images/2020/08/31/playlist-indexed.png)\n\nThen we will have some powerful ways to download the videos in this list with `ytdl video` or `ytdl audio`.\n\n\n#### Video\n\nDownload a single video file.\n\n```bash\n# download a video file to `{store_dir}/video/{VIDEO_TITLE}.mp4`\nytdl video https://www.youtube.com/watch?v=VIDEO_ID\n\n# custom name\nytdl video https://www.youtube.com/watch?v=VIDEO_ID my_custom_video_name\n\n```\n\nTo download multi items from indexed playlist, please refer the following arguments:\n\n- `--index_file`: path to playlist index file (required)\n- `--since`: video ID of the video where you want to start downloading from\n- `--limit`: number of items to download, count from `since` or the begining of the list\n- `--prefix_name`: to auto naming downloaded file\n- `--prefix_num`: to auto naming downloaded file\n\nExamples:\n\n```bash\n# download all videos from saved playlist index file above\n# these video files will be stored in `{store_dir}/video`\nytdl video --index_file "/path/to/Linux Tips and Tricks.json"\n\n# download 5 videos from saved playlist index file above, since first item\nytdl video --index_file "/path/to/Linux Tips and Tricks.json" --limit 5\n\n# download 5 videos from saved playlist index file above, with prefix name\nytdl video --index_file "/path/to/Linux Tips and Tricks.json" --limit 5 --prefix_name "Linux Tutorial"\n# downloaded videos should look like "Linux Tutorial - 1.mp4", "Linux Tutorial - 2.mp4" and so on\n# prefix_name will be useful when you want to put these files into an already created list for your different purpose\n\n# download 5 videos from saved playlist index file above, with prefix name and prefix number\nytdl video --index_file "/path/to/Linux Tips and Tricks.json" --limit 5 --prefix_name "Linux Tutorial" --prefix_num 25\n# this will be useful for the playlists those are splited to multi parts\n# in this case, your serie "Linux Tutorial" had already 24 items before, now count from 25 onwards\n# downloaded videos should look like "Linux Tutorial - 25.mp4", "Linux Tutorial - 26.mp4" and so on\n\n# similar to above command, but start from given item\nytdl video --index_file "/path/to/Linux Tips and Tricks.json" --since VIDEO_ID --limit 5 --prefix_name "Linux Tutorial" --prefix_num 25\n```\n\nWhile downloading video, the stream with highest `resolution` will be selected.\n\n\n#### Audio\n\nThis is similar to `ytdl video`, but only download audio file.\nWhile downloading, the stream with highest `abr` (average bitrate) will be selected.\n\n\n\n```bash\n# download a audio file to `{store_dir}/audio/{VIDEO_TITLE}.mp3`\nytdl audio https://www.youtube.com/watch?v=VIDEO_ID\n\n# custom name\nytdl audio https://www.youtube.com/watch?v=VIDEO_ID my_custom_audio_name\n```\n\nTo download multi items from indexed playlist, please refer the following arguments:\n\n- `--index_file`: path to playlist index file (required)\n- `--since`: video ID of the video where you want to start downloading from\n- `--limit`: number of items to download, count from `since` or the begining of the list\n- `--prefix_name`: to auto naming downloaded file\n- `--prefix_num`: to auto naming downloaded file\n\n\nExamples:\n\n```bash\n# download all audios from saved playlist index file above\n# these audio files will be stored in `{store_dir}/audio`\nytdl audio --index_file "/path/to/Linux Tips and Tricks.json"\n\n# download 5 audios from saved playlist index file above, since first item\nytdl audio --index_file "/path/to/Linux Tips and Tricks.json" --limit 5\n\n# download 5 audios from saved playlist index file above, with prefix name\nytdl audio --index_file "/path/to/Linux Tips and Tricks.json" --limit 5 --prefix_name "Linux Tutorial"\n# downloaded audios should look like "Linux Tutorial - 1.mp3", "Linux Tutorial - 2.mp3" and so on\n# prefix_name will be useful when you want to put these files into an already created list for your different purpose\n\n# download 5 audios from saved playlist index file above, with prefix name and prefix number\nytdl audio --index_file "/path/to/Linux Tips and Tricks.json" --limit 5 --prefix_name "Linux Tutorial" --prefix_num 25\n# this will be useful for the playlists those are splited to multi parts\n# in this case, your serie "Linux Tutorial" had already 24 items before, now count from 25 onwards\n# downloaded audios should look like "Linux Tutorial - 25.mp3", "Linux Tutorial - 26.mp3" and so on\n\n# similar to above command, but start from given item\nytdl audio --index_file "/path/to/Linux Tips and Tricks.json" --since VIDEO_ID --limit 5 --prefix_name "Linux Tutorial" --prefix_num 25\n```\n\nDownloaded stream will be convert to .mp3 with `ffmpeg`.\n\n\n## Dependencies\n\nThis lib was built on top of the following packages:\n\n| Dependency | License |\n|--|--|\n| [pytube3](https://github.com/get-pytube/pytube3) | MIT |\n| [python-youtube](https://github.com/sns-sdks/python-youtube) | MIT |\n| [python-fire](https://github.com/google/python-fire) | Apache License v2 |\n\n\n## Test\n\n```bash\ngit clone git@github.com:ndaidong/ytdl.git && cd ytdl\npoetry install\n./run_test.sh\n```\n\n\n# License\n\nThe MIT License (MIT)\n',
    'author': 'Dong Nguyen',
    'author_email': 'ndaidong@gmail.com',
    'maintainer': 'Dong Nguyen',
    'maintainer_email': 'ndaidong@gmail.com',
    'url': 'https://pypi.org/project/ytdl',
    'packages': packages,
    'package_data': package_data,
    'py_modules': modules,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
