"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehosePutRecordAction = exports.FirehoseRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * Record Separator to be used to separate records.
 */
var FirehoseRecordSeparator;
(function (FirehoseRecordSeparator) {
    /**
     * Separate by a new line
     */
    FirehoseRecordSeparator["NEWLINE"] = "\n";
    /**
     * Separate by a tab
     */
    FirehoseRecordSeparator["TAB"] = "\t";
    /**
     * Separate by a windows new line
     */
    FirehoseRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    /**
     * Separate by a comma
     */
    FirehoseRecordSeparator["COMMA"] = ",";
})(FirehoseRecordSeparator || (exports.FirehoseRecordSeparator = FirehoseRecordSeparator = {}));
/**
 * The action to put the record from an MQTT message to the Amazon Data Firehose stream.
 */
class FirehosePutRecordAction {
    /**
     * @param stream The Amazon Data Firehose stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_FirehosePutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FirehosePutRecordAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
exports.FirehosePutRecordAction = FirehosePutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
FirehosePutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.FirehosePutRecordAction", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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