import * as iot from '@aws-cdk/aws-iot-alpha';
import * as opensearch from 'aws-cdk-lib/aws-opensearchservice';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for Open Search.
 */
export interface OpenSearchActionProps extends CommonActionProps {
    /**
     * The unique identifier for the document you are storing.
     */
    readonly id: string;
    /**
     * The OpenSearch index where you want to store your data.
     */
    readonly index: string;
    /**
     * The type of document you are storing.
     */
    readonly type: string;
}
/**
 * The action to write data to an Amazon OpenSearch Service domain.
 */
export declare class OpenSearchAction implements iot.IAction {
    private readonly domain;
    private readonly props;
    constructor(domain: opensearch.Domain, props: OpenSearchActionProps);
    /**
     * @internal
     */
    _bind(rule: iot.ITopicRule): iot.ActionConfig;
}
