"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.OpenSearchAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to write data to an Amazon OpenSearch Service domain.
 */
class OpenSearchAction {
    constructor(domain, props) {
        this.domain = domain;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_OpenSearchActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, OpenSearchAction);
            }
            throw error;
        }
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.props.role ?? (0, role_1.singletonActionRole)(rule);
        // According to CloudFormation documentation, we only need 'es:ESHttpPut' permission
        // https://docs.aws.amazon.com/iot/latest/developerguide/opensearch-rule-action.html#opensearch-rule-action-requirements
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['es:ESHttpPut'],
            resources: [this.domain.domainArn, `${this.domain.domainArn}/*`],
        }));
        return {
            configuration: {
                openSearch: {
                    endpoint: `https://${this.domain.domainEndpoint}`,
                    id: this.props.id,
                    index: this.props.index,
                    type: this.props.type,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.OpenSearchAction = OpenSearchAction;
_a = JSII_RTTI_SYMBOL_1;
OpenSearchAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.OpenSearchAction", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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