"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnsTopicAction = exports.SnsActionMessageFormat = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * SNS topic action message format options.
 */
var SnsActionMessageFormat;
(function (SnsActionMessageFormat) {
    /**
     * RAW message format.
     */
    SnsActionMessageFormat["RAW"] = "RAW";
    /**
     * JSON message format.
     */
    SnsActionMessageFormat["JSON"] = "JSON";
})(SnsActionMessageFormat || (exports.SnsActionMessageFormat = SnsActionMessageFormat = {}));
/**
 * The action to write the data from an MQTT message to an Amazon SNS topic.
 *
 * @see https://docs.aws.amazon.com/iot/latest/developerguide/sns-rule-action.html
 */
class SnsTopicAction {
    /**
     * @param topic The Amazon SNS topic to publish data on. Must not be a FIFO topic.
     * @param props Properties to configure the action.
     */
    constructor(topic, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_SnsTopicActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SnsTopicAction);
            }
            throw error;
        }
        if (topic.fifo) {
            throw Error('IoT Rule actions cannot be used with FIFO SNS Topics, please pass a non-FIFO Topic instead');
        }
        this.topic = topic;
        this.role = props.role;
        this.messageFormat = props.messageFormat;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        this.topic.grantPublish(role);
        return {
            configuration: {
                sns: {
                    targetArn: this.topic.topicArn,
                    roleArn: role.roleArn,
                    messageFormat: this.messageFormat,
                },
            },
        };
    }
}
exports.SnsTopicAction = SnsTopicAction;
_a = JSII_RTTI_SYMBOL_1;
SnsTopicAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.SnsTopicAction", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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