"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SqsQueueAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon SQS queue.
 */
class SqsQueueAction {
    /**
     * @param queue The Amazon SQS queue to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(queue, props = {}) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_SqsQueueActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, SqsQueueAction);
            }
            throw error;
        }
        this.queue = queue;
        this.role = props.role;
        this.useBase64 = props.useBase64;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? (0, role_1.singletonActionRole)(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['sqs:SendMessage'],
            resources: [this.queue.queueArn],
        }));
        return {
            configuration: {
                sqs: {
                    queueUrl: this.queue.queueUrl,
                    useBase64: this.useBase64,
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.SqsQueueAction = SqsQueueAction;
_a = JSII_RTTI_SYMBOL_1;
SqsQueueAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.SqsQueueAction", version: "2.204.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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