import * as iot from '@aws-cdk/aws-iot-alpha';
import * as stepfunctions from 'aws-cdk-lib/aws-stepfunctions';
import { CommonActionProps } from './common-action-props';
/**
 * Configuration properties of an action for the Step Functions State Machine.
 */
export interface StepFunctionsStateMachineActionProps extends CommonActionProps {
    /**
     * Name of the state machine execution prefix.
     * The name given to the state machine execution consists of this prefix followed by a UUID. Step Functions creates a unique name for each state machine execution if one is not provided.
     *
     * @see https://docs.aws.amazon.com/iot/latest/developerguide/stepfunctions-rule-action.html#stepfunctions-rule-action-parameters
     *
     * @default: None - Step Functions creates a unique name for each state machine execution if one is not provided.
     */
    readonly executionNamePrefix?: string;
}
/**
 * The action to put the record from an MQTT message to the Step Functions State Machine.
 */
export declare class StepFunctionsStateMachineAction implements iot.IAction {
    private readonly stateMachine;
    private readonly executionNamePrefix?;
    private readonly role?;
    /**
     * @param stateMachine The Step Functions Start Machine which should be executed.
     * @param props Optional properties to not use default
     */
    constructor(stateMachine: stepfunctions.IStateMachine, props?: StepFunctionsStateMachineActionProps);
    /**
     * @internal
     */
    _bind(rule: iot.ITopicRule): iot.ActionConfig;
}
