"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SesSmtpCredentials = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SesSmtpCredentials extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const secretName = `${aws_cdk_lib_1.Names.uniqueId(this)}${props.iamUserName}`;
        const sesSendPolicy = new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'SesSendPolicy', {
            statements: [
                new aws_cdk_lib_1.aws_iam.PolicyStatement({
                    effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                    sid: 'SesAllowSendPolicy',
                    actions: ['ses:SendRawEmail'],
                    resources: ['*'],
                }),
            ],
        });
        this.iamUser = new aws_cdk_lib_1.aws_iam.User(this, 'User', {
            userName: props.iamUserName,
            managedPolicies: [
                sesSendPolicy,
            ],
        });
        aws_cdk_lib_1.Tags.of(this.iamUser).add('CfnStackIdForSesCredLibrary', aws_cdk_lib_1.Stack.of(this).stackId);
        const role = new aws_cdk_lib_1.aws_iam.Role(this, 'Role', {
            assumedBy: new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com'),
            managedPolicies: [
                new aws_cdk_lib_1.aws_iam.ManagedPolicy(this, 'SecretsManagerPolicy', {
                    statements: [
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            sid: 'SecretsManagerPolicy',
                            actions: [
                                'secretsmanager:PutSecretValue',
                                'secretsmanager:CreateSecret',
                                'secretsmanager:DeleteSecret',
                                'secretsmanager:UpdateSecret',
                                'secretsmanager:TagResource',
                            ],
                            resources: [`arn:aws:secretsmanager:${aws_cdk_lib_1.Stack.of(this).region}:${aws_cdk_lib_1.Stack.of(this).account}:secret:${secretName}-*`],
                        }),
                        new aws_cdk_lib_1.aws_iam.PolicyStatement({
                            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
                            sid: 'IamAllowKeyManagementPolicy',
                            actions: [
                                'iam:CreateAccessKey',
                                'iam:DeleteAccessKey',
                                'iam:ListAccessKeys',
                            ],
                            resources: ['*'],
                            conditions: {
                                StringEquals: {
                                    'iam:ResourceTag/CfnStackIdForSesCredLibrary': aws_cdk_lib_1.Stack.of(this).stackId,
                                },
                            },
                        }),
                    ],
                }),
            ],
        });
        const onEventHandler = new aws_cdk_lib_1.aws_lambda.Function(this, 'OnEventHandler', {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_9,
            handler: 'index.on_event',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, '../lambda')),
            timeout: aws_cdk_lib_1.Duration.seconds(30),
            role,
        });
        const provider = new aws_cdk_lib_1.custom_resources.Provider(this, 'Provider', {
            onEventHandler,
        });
        const secret = new aws_cdk_lib_1.CustomResource(this, 'SecretArn', {
            serviceToken: provider.serviceToken,
            properties: {
                UserName: props.iamUserName,
                SecretName: secretName,
                Region: aws_cdk_lib_1.Stack.of(this).region,
                Override: 'true',
            },
        });
        secret.node.addDependency(this.iamUser);
        this.secret = aws_cdk_lib_1.aws_secretsmanager.Secret.fromSecretCompleteArn(this, 'Secret', secret.getAttString('SecretArn'));
    }
}
exports.SesSmtpCredentials = SesSmtpCredentials;
_a = JSII_RTTI_SYMBOL_1;
SesSmtpCredentials[_a] = { fqn: "@renovosolutions/cdk-library-aws-ses-smtp-credentials.SesSmtpCredentials", version: "0.0.0" };
//# sourceMappingURL=data:application/json;base64,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