/**
 *  Copyright 2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 *  Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance
 *  with the License. A copy of the License is located at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  or in the 'license' file accompanying this file. This file is distributed on an 'AS IS' BASIS, WITHOUT WARRANTIES
 *  OR CONDITIONS OF ANY KIND, express or implied. See the License for the specific language governing permissions
 *  and limitations under the License.
 */
import * as s3 from '@aws-cdk/aws-s3';
import * as iot from '@aws-cdk/aws-iot';
import * as iam from '@aws-cdk/aws-iam';
import { Construct } from '@aws-cdk/core';
/**
 * @summary The properties for the IotToS3 class.
 */
export interface IotToS3Props {
    /**
     * Existing S3 Bucket interface, providing both this and `bucketProps` will cause an error.
     *
     * @default - None
     */
    readonly existingBucketInterface?: s3.IBucket;
    /**
     * User provided props to override the default props for the S3 Bucket.
     *
     * @default - Default props are used.
     */
    readonly bucketProps?: s3.BucketProps;
    /**
     * User provided CfnTopicRuleProps to override the defaults
     *
     * @default - Default props are used. S3ActionProperty with S3 Key '${topic()}/${timestamp()}' is used.
     */
    readonly iotTopicRuleProps: iot.CfnTopicRuleProps;
    /**
     * Optional user provided props to override the default props for the S3 Logging Bucket.
     *
     * @default - Default props are used
     */
    readonly loggingBucketProps?: s3.BucketProps;
    /**
     * Optional user provided value to override the default S3Key for IoTRule S3 Action.
     *
     * @default - Default value '${topic()}/${timestamp()}' is used
     */
    readonly s3Key?: string;
    /**
     * Whether to turn on Access Logs for the S3 bucket with the associated storage costs.
     * Enabling Access Logging is a best practice.
     *
     * @default - true
     */
    readonly logS3AccessLogs?: boolean;
}
export declare class IotToS3 extends Construct {
    readonly s3Bucket?: s3.Bucket;
    readonly s3BucketInterface: s3.IBucket;
    readonly s3LoggingBucket?: s3.Bucket;
    readonly iotActionsRole: iam.Role;
    readonly iotTopicRule: iot.CfnTopicRule;
    /**
     * @summary Constructs a new instance of the IotToSqs class.
     * @param {cdk.App} scope - represents the scope for all the resources.
     * @param {string} id - this is a a scope-unique id.
     * @param {IotToS3Props} props - user provided props for the construct
     * @access public
     */
    constructor(scope: Construct, id: string, props: IotToS3Props);
}
