import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeEndpointAttachmentConfig extends cdktf.TerraformMetaArguments {
    /**
    * ID of the endpoint attachment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#endpoint_attachment_id ApigeeEndpointAttachment#endpoint_attachment_id}
    */
    readonly endpointAttachmentId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#id ApigeeEndpointAttachment#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Location of the endpoint attachment.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#location ApigeeEndpointAttachment#location}
    */
    readonly location: string;
    /**
    * The Apigee Organization associated with the Apigee instance,
  in the format 'organizations/{{org_name}}'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#org_id ApigeeEndpointAttachment#org_id}
    */
    readonly orgId: string;
    /**
    * Format: projects/*\/regions/*\/serviceAttachments/*
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#service_attachment ApigeeEndpointAttachment#service_attachment}
    */
    readonly serviceAttachment: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#timeouts ApigeeEndpointAttachment#timeouts}
    */
    readonly timeouts?: ApigeeEndpointAttachmentTimeouts;
}
export interface ApigeeEndpointAttachmentTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#create ApigeeEndpointAttachment#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment#delete ApigeeEndpointAttachment#delete}
    */
    readonly delete?: string;
}
export declare function apigeeEndpointAttachmentTimeoutsToTerraform(struct?: ApigeeEndpointAttachmentTimeoutsOutputReference | ApigeeEndpointAttachmentTimeouts | cdktf.IResolvable): any;
export declare class ApigeeEndpointAttachmentTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeEndpointAttachmentTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeEndpointAttachmentTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment google_apigee_endpoint_attachment}
*/
export declare class ApigeeEndpointAttachment extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_endpoint_attachment";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_endpoint_attachment google_apigee_endpoint_attachment} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeEndpointAttachmentConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeEndpointAttachmentConfig);
    private _endpointAttachmentId?;
    get endpointAttachmentId(): string;
    set endpointAttachmentId(value: string);
    get endpointAttachmentIdInput(): string | undefined;
    get host(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _orgId?;
    get orgId(): string;
    set orgId(value: string);
    get orgIdInput(): string | undefined;
    private _serviceAttachment?;
    get serviceAttachment(): string;
    set serviceAttachment(value: string);
    get serviceAttachmentInput(): string | undefined;
    private _timeouts;
    get timeouts(): ApigeeEndpointAttachmentTimeoutsOutputReference;
    putTimeouts(value: ApigeeEndpointAttachmentTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeEndpointAttachmentTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
