import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ApigeeOrganizationConfig extends cdktf.TerraformMetaArguments {
    /**
    * Primary GCP region for analytics data storage. For valid values, see [Create an Apigee organization](https://cloud.google.com/apigee/docs/api-platform/get-started/create-org).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#analytics_region ApigeeOrganization#analytics_region}
    */
    readonly analyticsRegion?: string;
    /**
    * Compute Engine network used for Service Networking to be peered with Apigee runtime instances.
  See [Getting started with the Service Networking API](https://cloud.google.com/service-infrastructure/docs/service-networking/getting-started).
  Valid only when 'RuntimeType' is set to CLOUD. The value can be updated only when there are no runtime instances. For example: "default".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#authorized_network ApigeeOrganization#authorized_network}
    */
    readonly authorizedNetwork?: string;
    /**
    * Billing type of the Apigee organization. See [Apigee pricing](https://cloud.google.com/apigee/pricing).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#billing_type ApigeeOrganization#billing_type}
    */
    readonly billingType?: string;
    /**
    * Description of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#description ApigeeOrganization#description}
    */
    readonly description?: string;
    /**
    * The display name of the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#display_name ApigeeOrganization#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#id ApigeeOrganization#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The project ID associated with the Apigee organization.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#project_id ApigeeOrganization#project_id}
    */
    readonly projectId: string;
    /**
    * Cloud KMS key name used for encrypting the data that is stored and replicated across runtime instances.
  Update is not allowed after the organization is created.
  If not specified, a Google-Managed encryption key will be used.
  Valid only when 'RuntimeType' is CLOUD. For example: 'projects/foo/locations/us/keyRings/bar/cryptoKeys/baz'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#runtime_database_encryption_key_name ApigeeOrganization#runtime_database_encryption_key_name}
    */
    readonly runtimeDatabaseEncryptionKeyName?: string;
    /**
    * Runtime type of the Apigee organization based on the Apigee subscription purchased. Default value: "CLOUD" Possible values: ["CLOUD", "HYBRID"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#runtime_type ApigeeOrganization#runtime_type}
    */
    readonly runtimeType?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#timeouts ApigeeOrganization#timeouts}
    */
    readonly timeouts?: ApigeeOrganizationTimeouts;
}
export interface ApigeeOrganizationTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#create ApigeeOrganization#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#delete ApigeeOrganization#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/apigee_organization#update ApigeeOrganization#update}
    */
    readonly update?: string;
}
export declare function apigeeOrganizationTimeoutsToTerraform(struct?: ApigeeOrganizationTimeoutsOutputReference | ApigeeOrganizationTimeouts | cdktf.IResolvable): any;
export declare class ApigeeOrganizationTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ApigeeOrganizationTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ApigeeOrganizationTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/apigee_organization google_apigee_organization}
*/
export declare class ApigeeOrganization extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_apigee_organization";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/apigee_organization google_apigee_organization} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ApigeeOrganizationConfig
    */
    constructor(scope: Construct, id: string, config: ApigeeOrganizationConfig);
    private _analyticsRegion?;
    get analyticsRegion(): string;
    set analyticsRegion(value: string);
    resetAnalyticsRegion(): void;
    get analyticsRegionInput(): string | undefined;
    private _authorizedNetwork?;
    get authorizedNetwork(): string;
    set authorizedNetwork(value: string);
    resetAuthorizedNetwork(): void;
    get authorizedNetworkInput(): string | undefined;
    private _billingType?;
    get billingType(): string;
    set billingType(value: string);
    resetBillingType(): void;
    get billingTypeInput(): string | undefined;
    get caCertificate(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _projectId?;
    get projectId(): string;
    set projectId(value: string);
    get projectIdInput(): string | undefined;
    private _runtimeDatabaseEncryptionKeyName?;
    get runtimeDatabaseEncryptionKeyName(): string;
    set runtimeDatabaseEncryptionKeyName(value: string);
    resetRuntimeDatabaseEncryptionKeyName(): void;
    get runtimeDatabaseEncryptionKeyNameInput(): string | undefined;
    private _runtimeType?;
    get runtimeType(): string;
    set runtimeType(value: string);
    resetRuntimeType(): void;
    get runtimeTypeInput(): string | undefined;
    get subscriptionType(): string;
    private _timeouts;
    get timeouts(): ApigeeOrganizationTimeoutsOutputReference;
    putTimeouts(value: ApigeeOrganizationTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ApigeeOrganizationTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
