import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface BigqueryTableIamMemberConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#dataset_id BigqueryTableIamMember#dataset_id}
    */
    readonly datasetId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#id BigqueryTableIamMember#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#member BigqueryTableIamMember#member}
    */
    readonly member: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#project BigqueryTableIamMember#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#role BigqueryTableIamMember#role}
    */
    readonly role: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#table_id BigqueryTableIamMember#table_id}
    */
    readonly tableId: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#condition BigqueryTableIamMember#condition}
    */
    readonly condition?: BigqueryTableIamMemberCondition;
}
export interface BigqueryTableIamMemberCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#description BigqueryTableIamMember#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#expression BigqueryTableIamMember#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member#title BigqueryTableIamMember#title}
    */
    readonly title: string;
}
export declare function bigqueryTableIamMemberConditionToTerraform(struct?: BigqueryTableIamMemberConditionOutputReference | BigqueryTableIamMemberCondition): any;
export declare class BigqueryTableIamMemberConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): BigqueryTableIamMemberCondition | undefined;
    set internalValue(value: BigqueryTableIamMemberCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member google_bigquery_table_iam_member}
*/
export declare class BigqueryTableIamMember extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_bigquery_table_iam_member";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/bigquery_table_iam_member google_bigquery_table_iam_member} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options BigqueryTableIamMemberConfig
    */
    constructor(scope: Construct, id: string, config: BigqueryTableIamMemberConfig);
    private _datasetId?;
    get datasetId(): string;
    set datasetId(value: string);
    get datasetIdInput(): string | undefined;
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _member?;
    get member(): string;
    set member(value: string);
    get memberInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _tableId?;
    get tableId(): string;
    set tableId(value: string);
    get tableIdInput(): string | undefined;
    private _condition;
    get condition(): BigqueryTableIamMemberConditionOutputReference;
    putCondition(value: BigqueryTableIamMemberCondition): void;
    resetCondition(): void;
    get conditionInput(): BigqueryTableIamMemberCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
