import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateManagerCertificateMapEntryConfig extends cdktf.TerraformMetaArguments {
    /**
    * A set of Certificates defines for the given hostname.
  There can be defined up to fifteen certificates in each Certificate Map Entry.
  Each certificate must match pattern projects/*\/locations/*\/certificates/*.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#certificates CertificateManagerCertificateMapEntry#certificates}
    */
    readonly certificates: string[];
    /**
    * CertificateMapEntry is a list of certificate configurations,
  that have been issued for a particular hostname
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#description CertificateManagerCertificateMapEntry#description}
    */
    readonly description?: string;
    /**
    * A Hostname (FQDN, e.g. example.com) or a wildcard hostname expression (*.example.com)
  for a set of hostnames with common suffix. Used as Server Name Indication (SNI) for
  selecting a proper certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#hostname CertificateManagerCertificateMapEntry#hostname}
    */
    readonly hostname?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#id CertificateManagerCertificateMapEntry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of labels associated with a Certificate Map Entry.
  An object containing a list of "key": value pairs.
  Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#labels CertificateManagerCertificateMapEntry#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A map entry that is inputted into the cetrificate map
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#map CertificateManagerCertificateMapEntry#map}
    */
    readonly map: string;
    /**
    * A predefined matcher for particular cases, other than SNI selection Possible values: ["MATCHER_UNSPECIFIED", "PRIMARY"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#matcher CertificateManagerCertificateMapEntry#matcher}
    */
    readonly matcher?: string;
    /**
    * A user-defined name of the Certificate Map Entry. Certificate Map Entry
  names must be unique globally and match pattern
  'projects/*\/locations/*\/certificateMaps/*\/certificateMapEntries/*'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#name CertificateManagerCertificateMapEntry#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#project CertificateManagerCertificateMapEntry#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#timeouts CertificateManagerCertificateMapEntry#timeouts}
    */
    readonly timeouts?: CertificateManagerCertificateMapEntryTimeouts;
}
export interface CertificateManagerCertificateMapEntryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#create CertificateManagerCertificateMapEntry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#delete CertificateManagerCertificateMapEntry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry#update CertificateManagerCertificateMapEntry#update}
    */
    readonly update?: string;
}
export declare function certificateManagerCertificateMapEntryTimeoutsToTerraform(struct?: CertificateManagerCertificateMapEntryTimeoutsOutputReference | CertificateManagerCertificateMapEntryTimeouts | cdktf.IResolvable): any;
export declare class CertificateManagerCertificateMapEntryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateManagerCertificateMapEntryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateManagerCertificateMapEntryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry google_certificate_manager_certificate_map_entry}
*/
export declare class CertificateManagerCertificateMapEntry extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate_map_entry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate_map_entry google_certificate_manager_certificate_map_entry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateManagerCertificateMapEntryConfig
    */
    constructor(scope: Construct, id: string, config: CertificateManagerCertificateMapEntryConfig);
    private _certificates?;
    get certificates(): string[];
    set certificates(value: string[]);
    get certificatesInput(): string[] | undefined;
    get createTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _hostname?;
    get hostname(): string;
    set hostname(value: string);
    resetHostname(): void;
    get hostnameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _map?;
    get map(): string;
    set map(value: string);
    get mapInput(): string | undefined;
    private _matcher?;
    get matcher(): string;
    set matcher(value: string);
    resetMatcher(): void;
    get matcherInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    get updateTime(): string;
    private _timeouts;
    get timeouts(): CertificateManagerCertificateMapEntryTimeoutsOutputReference;
    putTimeouts(value: CertificateManagerCertificateMapEntryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CertificateManagerCertificateMapEntryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
