import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CertificateManagerCertificateConfig extends cdktf.TerraformMetaArguments {
    /**
    * A human-readable description of the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#description CertificateManagerCertificate#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#id CertificateManagerCertificate#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Set of label tags associated with the EdgeCache resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#labels CertificateManagerCertificate#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * A user-defined name of the certificate. Certificate names must be unique
  The name must be 1-64 characters long, and match the regular expression [a-zA-Z][a-zA-Z0-9_-]* which means the first character must be a letter,
  and all following characters must be a dash, underscore, letter or digit.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#name CertificateManagerCertificate#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#project CertificateManagerCertificate#project}
    */
    readonly project?: string;
    /**
    * The scope of the certificate.
  
  Certificates with default scope are served from core Google data centers.
  If unsure, choose this option.
  
  Certificates with scope EDGE_CACHE are special-purposed certificates,
  served from non-core Google data centers.
  Currently allowed only for managed certificates. Default value: "DEFAULT" Possible values: ["DEFAULT", "EDGE_CACHE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#scope CertificateManagerCertificate#scope}
    */
    readonly scope?: string;
    /**
    * managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#managed CertificateManagerCertificate#managed}
    */
    readonly managed?: CertificateManagerCertificateManaged;
    /**
    * self_managed block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#self_managed CertificateManagerCertificate#self_managed}
    */
    readonly selfManaged?: CertificateManagerCertificateSelfManaged;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#timeouts CertificateManagerCertificate#timeouts}
    */
    readonly timeouts?: CertificateManagerCertificateTimeouts;
}
export interface CertificateManagerCertificateManaged {
    /**
    * Authorizations that will be used for performing domain authorization
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#dns_authorizations CertificateManagerCertificate#dns_authorizations}
    */
    readonly dnsAuthorizations?: string[];
    /**
    * The domains for which a managed SSL certificate will be generated.
  Wildcard domains are only supported with DNS challenge resolution
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#domains CertificateManagerCertificate#domains}
    */
    readonly domains?: string[];
}
export declare function certificateManagerCertificateManagedToTerraform(struct?: CertificateManagerCertificateManagedOutputReference | CertificateManagerCertificateManaged): any;
export declare class CertificateManagerCertificateManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateManagerCertificateManaged | undefined;
    set internalValue(value: CertificateManagerCertificateManaged | undefined);
    private _dnsAuthorizations?;
    get dnsAuthorizations(): string[];
    set dnsAuthorizations(value: string[]);
    resetDnsAuthorizations(): void;
    get dnsAuthorizationsInput(): string[] | undefined;
    private _domains?;
    get domains(): string[];
    set domains(value: string[]);
    resetDomains(): void;
    get domainsInput(): string[] | undefined;
    get state(): string;
}
export interface CertificateManagerCertificateSelfManaged {
    /**
    * The certificate chain in PEM-encoded form.
  
  Leaf certificate comes first, followed by intermediate ones if any.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#certificate_pem CertificateManagerCertificate#certificate_pem}
    */
    readonly certificatePem: string;
    /**
    * The private key of the leaf certificate in PEM-encoded form.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#private_key_pem CertificateManagerCertificate#private_key_pem}
    */
    readonly privateKeyPem: string;
}
export declare function certificateManagerCertificateSelfManagedToTerraform(struct?: CertificateManagerCertificateSelfManagedOutputReference | CertificateManagerCertificateSelfManaged): any;
export declare class CertificateManagerCertificateSelfManagedOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateManagerCertificateSelfManaged | undefined;
    set internalValue(value: CertificateManagerCertificateSelfManaged | undefined);
    private _certificatePem?;
    get certificatePem(): string;
    set certificatePem(value: string);
    get certificatePemInput(): string | undefined;
    private _privateKeyPem?;
    get privateKeyPem(): string;
    set privateKeyPem(value: string);
    get privateKeyPemInput(): string | undefined;
}
export interface CertificateManagerCertificateTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#create CertificateManagerCertificate#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#delete CertificateManagerCertificate#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate#update CertificateManagerCertificate#update}
    */
    readonly update?: string;
}
export declare function certificateManagerCertificateTimeoutsToTerraform(struct?: CertificateManagerCertificateTimeoutsOutputReference | CertificateManagerCertificateTimeouts | cdktf.IResolvable): any;
export declare class CertificateManagerCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): CertificateManagerCertificateTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: CertificateManagerCertificateTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate google_certificate_manager_certificate}
*/
export declare class CertificateManagerCertificate extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_certificate_manager_certificate";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/certificate_manager_certificate google_certificate_manager_certificate} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CertificateManagerCertificateConfig
    */
    constructor(scope: Construct, id: string, config: CertificateManagerCertificateConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _scope?;
    get scope(): string;
    set scope(value: string);
    resetScope(): void;
    get scopeInput(): string | undefined;
    private _managed;
    get managed(): CertificateManagerCertificateManagedOutputReference;
    putManaged(value: CertificateManagerCertificateManaged): void;
    resetManaged(): void;
    get managedInput(): CertificateManagerCertificateManaged | undefined;
    private _selfManaged;
    get selfManaged(): CertificateManagerCertificateSelfManagedOutputReference;
    putSelfManaged(value: CertificateManagerCertificateSelfManaged): void;
    resetSelfManaged(): void;
    get selfManagedInput(): CertificateManagerCertificateSelfManaged | undefined;
    private _timeouts;
    get timeouts(): CertificateManagerCertificateTimeoutsOutputReference;
    putTimeouts(value: CertificateManagerCertificateTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | CertificateManagerCertificateTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
