import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeBackendBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Cloud Storage bucket name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#bucket_name ComputeBackendBucket#bucket_name}
    */
    readonly bucketName: string;
    /**
    * Headers that the HTTP/S load balancer should add to proxied responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#custom_response_headers ComputeBackendBucket#custom_response_headers}
    */
    readonly customResponseHeaders?: string[];
    /**
    * An optional textual description of the resource; provided by the
  client when the resource is created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#description ComputeBackendBucket#description}
    */
    readonly description?: string;
    /**
    * The security policy associated with this backend bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#edge_security_policy ComputeBackendBucket#edge_security_policy}
    */
    readonly edgeSecurityPolicy?: string;
    /**
    * If true, enable Cloud CDN for this BackendBucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#enable_cdn ComputeBackendBucket#enable_cdn}
    */
    readonly enableCdn?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#id ComputeBackendBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035.  Specifically, the name must be 1-63 characters long and
  match the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means
  the first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the
  last character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#name ComputeBackendBucket#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#project ComputeBackendBucket#project}
    */
    readonly project?: string;
    /**
    * cdn_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#cdn_policy ComputeBackendBucket#cdn_policy}
    */
    readonly cdnPolicy?: ComputeBackendBucketCdnPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#timeouts ComputeBackendBucket#timeouts}
    */
    readonly timeouts?: ComputeBackendBucketTimeouts;
}
export interface ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders {
    /**
    * The header field name to match on when bypassing cache. Values are case-insensitive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#header_name ComputeBackendBucket#header_name}
    */
    readonly headerName?: string;
}
export declare function computeBackendBucketCdnPolicyBypassCacheOnRequestHeadersToTerraform(struct?: ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders | cdktf.IResolvable): any;
export declare class ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders | cdktf.IResolvable | undefined);
    private _headerName?;
    get headerName(): string;
    set headerName(value: string);
    resetHeaderName(): void;
    get headerNameInput(): string | undefined;
}
export declare class ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersOutputReference;
}
export interface ComputeBackendBucketCdnPolicyCacheKeyPolicy {
    /**
    * Allows HTTP request headers (by name) to be used in the
  cache key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#include_http_headers ComputeBackendBucket#include_http_headers}
    */
    readonly includeHttpHeaders?: string[];
    /**
    * Names of query string parameters to include in cache keys.
  Default parameters are always included. '&' and '=' will
  be percent encoded and not treated as delimiters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#query_string_whitelist ComputeBackendBucket#query_string_whitelist}
    */
    readonly queryStringWhitelist?: string[];
}
export declare function computeBackendBucketCdnPolicyCacheKeyPolicyToTerraform(struct?: ComputeBackendBucketCdnPolicyCacheKeyPolicyOutputReference | ComputeBackendBucketCdnPolicyCacheKeyPolicy): any;
export declare class ComputeBackendBucketCdnPolicyCacheKeyPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendBucketCdnPolicyCacheKeyPolicy | undefined;
    set internalValue(value: ComputeBackendBucketCdnPolicyCacheKeyPolicy | undefined);
    private _includeHttpHeaders?;
    get includeHttpHeaders(): string[];
    set includeHttpHeaders(value: string[]);
    resetIncludeHttpHeaders(): void;
    get includeHttpHeadersInput(): string[] | undefined;
    private _queryStringWhitelist?;
    get queryStringWhitelist(): string[];
    set queryStringWhitelist(value: string[]);
    resetQueryStringWhitelist(): void;
    get queryStringWhitelistInput(): string[] | undefined;
}
export interface ComputeBackendBucketCdnPolicyNegativeCachingPolicy {
    /**
    * The HTTP status code to define a TTL against. Only HTTP status codes 300, 301, 308, 404, 405, 410, 421, 451 and 501
  can be specified as values, and you cannot specify a status code more than once.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#code ComputeBackendBucket#code}
    */
    readonly code?: number;
    /**
    * The TTL (in seconds) for which to cache responses with the corresponding status code. The maximum allowed value is 1800s
  (30 minutes), noting that infrequently accessed objects may be evicted from the cache before the defined TTL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#ttl ComputeBackendBucket#ttl}
    */
    readonly ttl?: number;
}
export declare function computeBackendBucketCdnPolicyNegativeCachingPolicyToTerraform(struct?: ComputeBackendBucketCdnPolicyNegativeCachingPolicy | cdktf.IResolvable): any;
export declare class ComputeBackendBucketCdnPolicyNegativeCachingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ComputeBackendBucketCdnPolicyNegativeCachingPolicy | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeBackendBucketCdnPolicyNegativeCachingPolicy | cdktf.IResolvable | undefined);
    private _code?;
    get code(): number;
    set code(value: number);
    resetCode(): void;
    get codeInput(): number | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
}
export declare class ComputeBackendBucketCdnPolicyNegativeCachingPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ComputeBackendBucketCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ComputeBackendBucketCdnPolicyNegativeCachingPolicyOutputReference;
}
export interface ComputeBackendBucketCdnPolicy {
    /**
    * Specifies the cache setting for all responses from this backend.
  The possible values are: USE_ORIGIN_HEADERS, FORCE_CACHE_ALL and CACHE_ALL_STATIC Possible values: ["USE_ORIGIN_HEADERS", "FORCE_CACHE_ALL", "CACHE_ALL_STATIC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#cache_mode ComputeBackendBucket#cache_mode}
    */
    readonly cacheMode?: string;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#client_ttl ComputeBackendBucket#client_ttl}
    */
    readonly clientTtl?: number;
    /**
    * Specifies the default TTL for cached content served by this origin for responses
  that do not have an existing valid TTL (max-age or s-max-age).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#default_ttl ComputeBackendBucket#default_ttl}
    */
    readonly defaultTtl?: number;
    /**
    * Specifies the maximum allowed TTL for cached content served by this origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#max_ttl ComputeBackendBucket#max_ttl}
    */
    readonly maxTtl?: number;
    /**
    * Negative caching allows per-status code TTLs to be set, in order to apply fine-grained caching for common errors or redirects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#negative_caching ComputeBackendBucket#negative_caching}
    */
    readonly negativeCaching?: boolean | cdktf.IResolvable;
    /**
    * If true then Cloud CDN will combine multiple concurrent cache fill requests into a small number of requests to the origin.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#request_coalescing ComputeBackendBucket#request_coalescing}
    */
    readonly requestCoalescing?: boolean | cdktf.IResolvable;
    /**
    * Serve existing content from the cache (if available) when revalidating content with the origin, or when an error is encountered when refreshing the cache.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#serve_while_stale ComputeBackendBucket#serve_while_stale}
    */
    readonly serveWhileStale?: number;
    /**
    * Maximum number of seconds the response to a signed URL request will
  be considered fresh. After this time period,
  the response will be revalidated before being served.
  When serving responses to signed URL requests,
  Cloud CDN will internally behave as though
  all responses from this backend had a "Cache-Control: public,
  max-age=[TTL]" header, regardless of any existing Cache-Control
  header. The actual headers served in responses will not be altered.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#signed_url_cache_max_age_sec ComputeBackendBucket#signed_url_cache_max_age_sec}
    */
    readonly signedUrlCacheMaxAgeSec?: number;
    /**
    * bypass_cache_on_request_headers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#bypass_cache_on_request_headers ComputeBackendBucket#bypass_cache_on_request_headers}
    */
    readonly bypassCacheOnRequestHeaders?: ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders[] | cdktf.IResolvable;
    /**
    * cache_key_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#cache_key_policy ComputeBackendBucket#cache_key_policy}
    */
    readonly cacheKeyPolicy?: ComputeBackendBucketCdnPolicyCacheKeyPolicy;
    /**
    * negative_caching_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#negative_caching_policy ComputeBackendBucket#negative_caching_policy}
    */
    readonly negativeCachingPolicy?: ComputeBackendBucketCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable;
}
export declare function computeBackendBucketCdnPolicyToTerraform(struct?: ComputeBackendBucketCdnPolicyOutputReference | ComputeBackendBucketCdnPolicy): any;
export declare class ComputeBackendBucketCdnPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendBucketCdnPolicy | undefined;
    set internalValue(value: ComputeBackendBucketCdnPolicy | undefined);
    private _cacheMode?;
    get cacheMode(): string;
    set cacheMode(value: string);
    resetCacheMode(): void;
    get cacheModeInput(): string | undefined;
    private _clientTtl?;
    get clientTtl(): number;
    set clientTtl(value: number);
    resetClientTtl(): void;
    get clientTtlInput(): number | undefined;
    private _defaultTtl?;
    get defaultTtl(): number;
    set defaultTtl(value: number);
    resetDefaultTtl(): void;
    get defaultTtlInput(): number | undefined;
    private _maxTtl?;
    get maxTtl(): number;
    set maxTtl(value: number);
    resetMaxTtl(): void;
    get maxTtlInput(): number | undefined;
    private _negativeCaching?;
    get negativeCaching(): boolean | cdktf.IResolvable;
    set negativeCaching(value: boolean | cdktf.IResolvable);
    resetNegativeCaching(): void;
    get negativeCachingInput(): boolean | cdktf.IResolvable | undefined;
    private _requestCoalescing?;
    get requestCoalescing(): boolean | cdktf.IResolvable;
    set requestCoalescing(value: boolean | cdktf.IResolvable);
    resetRequestCoalescing(): void;
    get requestCoalescingInput(): boolean | cdktf.IResolvable | undefined;
    private _serveWhileStale?;
    get serveWhileStale(): number;
    set serveWhileStale(value: number);
    resetServeWhileStale(): void;
    get serveWhileStaleInput(): number | undefined;
    private _signedUrlCacheMaxAgeSec?;
    get signedUrlCacheMaxAgeSec(): number;
    set signedUrlCacheMaxAgeSec(value: number);
    resetSignedUrlCacheMaxAgeSec(): void;
    get signedUrlCacheMaxAgeSecInput(): number | undefined;
    private _bypassCacheOnRequestHeaders;
    get bypassCacheOnRequestHeaders(): ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeadersList;
    putBypassCacheOnRequestHeaders(value: ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders[] | cdktf.IResolvable): void;
    resetBypassCacheOnRequestHeaders(): void;
    get bypassCacheOnRequestHeadersInput(): cdktf.IResolvable | ComputeBackendBucketCdnPolicyBypassCacheOnRequestHeaders[] | undefined;
    private _cacheKeyPolicy;
    get cacheKeyPolicy(): ComputeBackendBucketCdnPolicyCacheKeyPolicyOutputReference;
    putCacheKeyPolicy(value: ComputeBackendBucketCdnPolicyCacheKeyPolicy): void;
    resetCacheKeyPolicy(): void;
    get cacheKeyPolicyInput(): ComputeBackendBucketCdnPolicyCacheKeyPolicy | undefined;
    private _negativeCachingPolicy;
    get negativeCachingPolicy(): ComputeBackendBucketCdnPolicyNegativeCachingPolicyList;
    putNegativeCachingPolicy(value: ComputeBackendBucketCdnPolicyNegativeCachingPolicy[] | cdktf.IResolvable): void;
    resetNegativeCachingPolicy(): void;
    get negativeCachingPolicyInput(): cdktf.IResolvable | ComputeBackendBucketCdnPolicyNegativeCachingPolicy[] | undefined;
}
export interface ComputeBackendBucketTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#create ComputeBackendBucket#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#delete ComputeBackendBucket#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket#update ComputeBackendBucket#update}
    */
    readonly update?: string;
}
export declare function computeBackendBucketTimeoutsToTerraform(struct?: ComputeBackendBucketTimeoutsOutputReference | ComputeBackendBucketTimeouts | cdktf.IResolvable): any;
export declare class ComputeBackendBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeBackendBucketTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeBackendBucketTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket google_compute_backend_bucket}
*/
export declare class ComputeBackendBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_backend_bucket";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_backend_bucket google_compute_backend_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeBackendBucketConfig
    */
    constructor(scope: Construct, id: string, config: ComputeBackendBucketConfig);
    private _bucketName?;
    get bucketName(): string;
    set bucketName(value: string);
    get bucketNameInput(): string | undefined;
    get creationTimestamp(): string;
    private _customResponseHeaders?;
    get customResponseHeaders(): string[];
    set customResponseHeaders(value: string[]);
    resetCustomResponseHeaders(): void;
    get customResponseHeadersInput(): string[] | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _edgeSecurityPolicy?;
    get edgeSecurityPolicy(): string;
    set edgeSecurityPolicy(value: string);
    resetEdgeSecurityPolicy(): void;
    get edgeSecurityPolicyInput(): string | undefined;
    private _enableCdn?;
    get enableCdn(): boolean | cdktf.IResolvable;
    set enableCdn(value: boolean | cdktf.IResolvable);
    resetEnableCdn(): void;
    get enableCdnInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get selfLink(): string;
    private _cdnPolicy;
    get cdnPolicy(): ComputeBackendBucketCdnPolicyOutputReference;
    putCdnPolicy(value: ComputeBackendBucketCdnPolicy): void;
    resetCdnPolicy(): void;
    get cdnPolicyInput(): ComputeBackendBucketCdnPolicy | undefined;
    private _timeouts;
    get timeouts(): ComputeBackendBucketTimeoutsOutputReference;
    putTimeouts(value: ComputeBackendBucketTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeBackendBucketTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
