import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeProjectDefaultNetworkTierConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier#id ComputeProjectDefaultNetworkTier#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The default network tier to be configured for the project. This field can take the following values: PREMIUM or STANDARD.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier#network_tier ComputeProjectDefaultNetworkTier#network_tier}
    */
    readonly networkTier: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier#project ComputeProjectDefaultNetworkTier#project}
    */
    readonly project?: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier#timeouts ComputeProjectDefaultNetworkTier#timeouts}
    */
    readonly timeouts?: ComputeProjectDefaultNetworkTierTimeouts;
}
export interface ComputeProjectDefaultNetworkTierTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier#create ComputeProjectDefaultNetworkTier#create}
    */
    readonly create?: string;
}
export declare function computeProjectDefaultNetworkTierTimeoutsToTerraform(struct?: ComputeProjectDefaultNetworkTierTimeoutsOutputReference | ComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable): any;
export declare class ComputeProjectDefaultNetworkTierTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeProjectDefaultNetworkTierTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier google_compute_project_default_network_tier}
*/
export declare class ComputeProjectDefaultNetworkTier extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_project_default_network_tier";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_project_default_network_tier google_compute_project_default_network_tier} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeProjectDefaultNetworkTierConfig
    */
    constructor(scope: Construct, id: string, config: ComputeProjectDefaultNetworkTierConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _networkTier?;
    get networkTier(): string;
    set networkTier(value: string);
    get networkTierInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _timeouts;
    get timeouts(): ComputeProjectDefaultNetworkTierTimeoutsOutputReference;
    putTimeouts(value: ComputeProjectDefaultNetworkTierTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeProjectDefaultNetworkTierTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
