import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ComputeRegionDiskConfig extends cdktf.TerraformMetaArguments {
    /**
    * An optional description of this resource. Provide this property when
  you create the resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#description ComputeRegionDisk#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#id ComputeRegionDisk#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Labels to apply to this disk.  A list of key->value pairs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#labels ComputeRegionDisk#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * Name of the resource. Provided by the client when the resource is
  created. The name must be 1-63 characters long, and comply with
  RFC1035. Specifically, the name must be 1-63 characters long and match
  the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
  first character must be a lowercase letter, and all following
  characters must be a dash, lowercase letter, or digit, except the last
  character, which cannot be a dash.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#name ComputeRegionDisk#name}
    */
    readonly name: string;
    /**
    * Physical block size of the persistent disk, in bytes. If not present
  in a request, a default value is used. Currently supported sizes
  are 4096 and 16384, other sizes may be added in the future.
  If an unsupported value is requested, the error message will list
  the supported values for the caller's project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#physical_block_size_bytes ComputeRegionDisk#physical_block_size_bytes}
    */
    readonly physicalBlockSizeBytes?: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#project ComputeRegionDisk#project}
    */
    readonly project?: string;
    /**
    * A reference to the region where the disk resides.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#region ComputeRegionDisk#region}
    */
    readonly region?: string;
    /**
    * URLs of the zones where the disk should be replicated to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#replica_zones ComputeRegionDisk#replica_zones}
    */
    readonly replicaZones: string[];
    /**
    * Size of the persistent disk, specified in GB. You can specify this
  field when creating a persistent disk using the sourceImage or
  sourceSnapshot parameter, or specify it alone to create an empty
  persistent disk.
  
  If you specify this field along with sourceImage or sourceSnapshot,
  the value of sizeGb must not be less than the size of the sourceImage
  or the size of the snapshot.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#size ComputeRegionDisk#size}
    */
    readonly size?: number;
    /**
    * The source snapshot used to create this disk. You can provide this as
  a partial or full URL to the resource. For example, the following are
  valid values:
  
  * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
  * 'projects/project/global/snapshots/snapshot'
  * 'global/snapshots/snapshot'
  * 'snapshot'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#snapshot ComputeRegionDisk#snapshot}
    */
    readonly snapshot?: string;
    /**
    * URL of the disk type resource describing which disk type to use to
  create the disk. Provide this when creating the disk.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#type ComputeRegionDisk#type}
    */
    readonly type?: string;
    /**
    * disk_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#disk_encryption_key ComputeRegionDisk#disk_encryption_key}
    */
    readonly diskEncryptionKey?: ComputeRegionDiskDiskEncryptionKey;
    /**
    * source_snapshot_encryption_key block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#source_snapshot_encryption_key ComputeRegionDisk#source_snapshot_encryption_key}
    */
    readonly sourceSnapshotEncryptionKey?: ComputeRegionDiskSourceSnapshotEncryptionKey;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#timeouts ComputeRegionDisk#timeouts}
    */
    readonly timeouts?: ComputeRegionDiskTimeouts;
}
export interface ComputeRegionDiskDiskEncryptionKey {
    /**
    * The name of the encryption key that is stored in Google Cloud KMS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#kms_key_name ComputeRegionDisk#kms_key_name}
    */
    readonly kmsKeyName?: string;
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#raw_key ComputeRegionDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeRegionDiskDiskEncryptionKeyToTerraform(struct?: ComputeRegionDiskDiskEncryptionKeyOutputReference | ComputeRegionDiskDiskEncryptionKey): any;
export declare class ComputeRegionDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionDiskDiskEncryptionKey | undefined;
    set internalValue(value: ComputeRegionDiskDiskEncryptionKey | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    resetKmsKeyName(): void;
    get kmsKeyNameInput(): string | undefined;
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeRegionDiskSourceSnapshotEncryptionKey {
    /**
    * Specifies a 256-bit customer-supplied encryption key, encoded in
  RFC 4648 base64 to either encrypt or decrypt this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#raw_key ComputeRegionDisk#raw_key}
    */
    readonly rawKey?: string;
}
export declare function computeRegionDiskSourceSnapshotEncryptionKeyToTerraform(struct?: ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference | ComputeRegionDiskSourceSnapshotEncryptionKey): any;
export declare class ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    set internalValue(value: ComputeRegionDiskSourceSnapshotEncryptionKey | undefined);
    private _rawKey?;
    get rawKey(): string;
    set rawKey(value: string);
    resetRawKey(): void;
    get rawKeyInput(): string | undefined;
    get sha256(): string;
}
export interface ComputeRegionDiskTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#create ComputeRegionDisk#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#delete ComputeRegionDisk#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#update ComputeRegionDisk#update}
    */
    readonly update?: string;
}
export declare function computeRegionDiskTimeoutsToTerraform(struct?: ComputeRegionDiskTimeoutsOutputReference | ComputeRegionDiskTimeouts | cdktf.IResolvable): any;
export declare class ComputeRegionDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ComputeRegionDiskTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ComputeRegionDiskTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk google_compute_region_disk}
*/
export declare class ComputeRegionDisk extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_compute_region_disk";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk google_compute_region_disk} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ComputeRegionDiskConfig
    */
    constructor(scope: Construct, id: string, config: ComputeRegionDiskConfig);
    get creationTimestamp(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get labelFingerprint(): string;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get lastAttachTimestamp(): string;
    get lastDetachTimestamp(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    get physicalBlockSizeBytes(): number;
    set physicalBlockSizeBytes(value: number);
    resetPhysicalBlockSizeBytes(): void;
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _replicaZones?;
    get replicaZones(): string[];
    set replicaZones(value: string[]);
    get replicaZonesInput(): string[] | undefined;
    get selfLink(): string;
    private _size?;
    get size(): number;
    set size(value: number);
    resetSize(): void;
    get sizeInput(): number | undefined;
    private _snapshot?;
    get snapshot(): string;
    set snapshot(value: string);
    resetSnapshot(): void;
    get snapshotInput(): string | undefined;
    get sourceSnapshotId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get users(): string[];
    private _diskEncryptionKey;
    get diskEncryptionKey(): ComputeRegionDiskDiskEncryptionKeyOutputReference;
    putDiskEncryptionKey(value: ComputeRegionDiskDiskEncryptionKey): void;
    resetDiskEncryptionKey(): void;
    get diskEncryptionKeyInput(): ComputeRegionDiskDiskEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey;
    get sourceSnapshotEncryptionKey(): ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference;
    putSourceSnapshotEncryptionKey(value: ComputeRegionDiskSourceSnapshotEncryptionKey): void;
    resetSourceSnapshotEncryptionKey(): void;
    get sourceSnapshotEncryptionKeyInput(): ComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts;
    get timeouts(): ComputeRegionDiskTimeoutsOutputReference;
    putTimeouts(value: ComputeRegionDiskTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ComputeRegionDiskTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
