import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataCatalogEntryConfig extends cdktf.TerraformMetaArguments {
    /**
    * Entry description, which can consist of several sentences or paragraphs that describe entry contents.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#description DataCatalogEntry#description}
    */
    readonly description?: string;
    /**
    * Display information such as title and description. A short name to identify the entry,
  for example, "Analytics Data - Jan 2011".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#display_name DataCatalogEntry#display_name}
    */
    readonly displayName?: string;
    /**
    * The name of the entry group this entry is in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#entry_group DataCatalogEntry#entry_group}
    */
    readonly entryGroup: string;
    /**
    * The id of the entry to create.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#entry_id DataCatalogEntry#entry_id}
    */
    readonly entryId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#id DataCatalogEntry#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The resource this metadata entry refers to.
  For Google Cloud Platform resources, linkedResource is the full name of the resource.
  For example, the linkedResource for a table resource from BigQuery is:
  //bigquery.googleapis.com/projects/projectId/datasets/datasetId/tables/tableId
  Output only when Entry is of type in the EntryType enum. For entries with userSpecifiedType,
  this field is optional and defaults to an empty string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#linked_resource DataCatalogEntry#linked_resource}
    */
    readonly linkedResource?: string;
    /**
    * Schema of the entry (e.g. BigQuery, GoogleSQL, Avro schema), as a json string. An entry might not have any schema
  attached to it. See
  https://cloud.google.com/data-catalog/docs/reference/rest/v1/projects.locations.entryGroups.entries#schema
  for what fields this schema can contain.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#schema DataCatalogEntry#schema}
    */
    readonly schema?: string;
    /**
    * The type of the entry. Only used for Entries with types in the EntryType enum.
  Currently, only FILESET enum value is allowed. All other entries created through Data Catalog must use userSpecifiedType. Possible values: ["FILESET"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#type DataCatalogEntry#type}
    */
    readonly type?: string;
    /**
    * This field indicates the entry's source system that Data Catalog does not integrate with.
  userSpecifiedSystem strings must begin with a letter or underscore and can only contain letters, numbers,
  and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#user_specified_system DataCatalogEntry#user_specified_system}
    */
    readonly userSpecifiedSystem?: string;
    /**
    * Entry type if it does not fit any of the input-allowed values listed in EntryType enum above.
  When creating an entry, users should check the enum values first, if nothing matches the entry
  to be created, then provide a custom value, for example "my_special_type".
  userSpecifiedType strings must begin with a letter or underscore and can only contain letters,
  numbers, and underscores; are case insensitive; must be at least 1 character and at most 64 characters long.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#user_specified_type DataCatalogEntry#user_specified_type}
    */
    readonly userSpecifiedType?: string;
    /**
    * gcs_fileset_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#gcs_fileset_spec DataCatalogEntry#gcs_fileset_spec}
    */
    readonly gcsFilesetSpec?: DataCatalogEntryGcsFilesetSpec;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#timeouts DataCatalogEntry#timeouts}
    */
    readonly timeouts?: DataCatalogEntryTimeouts;
}
export interface DataCatalogEntryBigqueryDateShardedSpec {
}
export declare function dataCatalogEntryBigqueryDateShardedSpecToTerraform(struct?: DataCatalogEntryBigqueryDateShardedSpec): any;
export declare class DataCatalogEntryBigqueryDateShardedSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogEntryBigqueryDateShardedSpec | undefined;
    set internalValue(value: DataCatalogEntryBigqueryDateShardedSpec | undefined);
    get dataset(): string;
    get shardCount(): number;
    get tablePrefix(): string;
}
export declare class DataCatalogEntryBigqueryDateShardedSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogEntryBigqueryDateShardedSpecOutputReference;
}
export interface DataCatalogEntryBigqueryTableSpecTableSpec {
}
export declare function dataCatalogEntryBigqueryTableSpecTableSpecToTerraform(struct?: DataCatalogEntryBigqueryTableSpecTableSpec): any;
export declare class DataCatalogEntryBigqueryTableSpecTableSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogEntryBigqueryTableSpecTableSpec | undefined;
    set internalValue(value: DataCatalogEntryBigqueryTableSpecTableSpec | undefined);
    get groupedEntry(): string;
}
export declare class DataCatalogEntryBigqueryTableSpecTableSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogEntryBigqueryTableSpecTableSpecOutputReference;
}
export interface DataCatalogEntryBigqueryTableSpecViewSpec {
}
export declare function dataCatalogEntryBigqueryTableSpecViewSpecToTerraform(struct?: DataCatalogEntryBigqueryTableSpecViewSpec): any;
export declare class DataCatalogEntryBigqueryTableSpecViewSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogEntryBigqueryTableSpecViewSpec | undefined;
    set internalValue(value: DataCatalogEntryBigqueryTableSpecViewSpec | undefined);
    get viewQuery(): string;
}
export declare class DataCatalogEntryBigqueryTableSpecViewSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogEntryBigqueryTableSpecViewSpecOutputReference;
}
export interface DataCatalogEntryBigqueryTableSpec {
}
export declare function dataCatalogEntryBigqueryTableSpecToTerraform(struct?: DataCatalogEntryBigqueryTableSpec): any;
export declare class DataCatalogEntryBigqueryTableSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogEntryBigqueryTableSpec | undefined;
    set internalValue(value: DataCatalogEntryBigqueryTableSpec | undefined);
    get tableSourceType(): string;
    private _tableSpec;
    get tableSpec(): DataCatalogEntryBigqueryTableSpecTableSpecList;
    private _viewSpec;
    get viewSpec(): DataCatalogEntryBigqueryTableSpecViewSpecList;
}
export declare class DataCatalogEntryBigqueryTableSpecList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogEntryBigqueryTableSpecOutputReference;
}
export interface DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs {
}
export declare function dataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsToTerraform(struct?: DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs): any;
export declare class DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs | undefined;
    set internalValue(value: DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecs | undefined);
    get filePath(): string;
    get sizeBytes(): number;
}
export declare class DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsOutputReference;
}
export interface DataCatalogEntryGcsFilesetSpec {
    /**
    * Patterns to identify a set of files in Google Cloud Storage.
  See [Cloud Storage documentation](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames)
  for more information. Note that bucket wildcards are currently not supported. Examples of valid filePatterns:
  
  * gs://bucket_name/dir/*: matches all files within bucket_name/dir directory.
  * gs://bucket_name/dir/**: matches all files in bucket_name/dir spanning all subdirectories.
  * gs://bucket_name/file*: matches files prefixed by file in bucket_name
  * gs://bucket_name/??.txt: matches files with two characters followed by .txt in bucket_name
  * gs://bucket_name/[aeiou].txt: matches files that contain a single vowel character followed by .txt in bucket_name
  * gs://bucket_name/[a-m].txt: matches files that contain a, b, ... or m followed by .txt in bucket_name
  * gs://bucket_name/a/*\/b: matches all files in bucket_name that match a/*\/b pattern, such as a/c/b, a/d/b
  * gs://another_bucket/a.txt: matches gs://another_bucket/a.txt
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#file_patterns DataCatalogEntry#file_patterns}
    */
    readonly filePatterns: string[];
}
export declare function dataCatalogEntryGcsFilesetSpecToTerraform(struct?: DataCatalogEntryGcsFilesetSpecOutputReference | DataCatalogEntryGcsFilesetSpec): any;
export declare class DataCatalogEntryGcsFilesetSpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogEntryGcsFilesetSpec | undefined;
    set internalValue(value: DataCatalogEntryGcsFilesetSpec | undefined);
    private _filePatterns?;
    get filePatterns(): string[];
    set filePatterns(value: string[]);
    get filePatternsInput(): string[] | undefined;
    private _sampleGcsFileSpecs;
    get sampleGcsFileSpecs(): DataCatalogEntryGcsFilesetSpecSampleGcsFileSpecsList;
}
export interface DataCatalogEntryTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#create DataCatalogEntry#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#delete DataCatalogEntry#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry#update DataCatalogEntry#update}
    */
    readonly update?: string;
}
export declare function dataCatalogEntryTimeoutsToTerraform(struct?: DataCatalogEntryTimeoutsOutputReference | DataCatalogEntryTimeouts | cdktf.IResolvable): any;
export declare class DataCatalogEntryTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataCatalogEntryTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataCatalogEntryTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry google_data_catalog_entry}
*/
export declare class DataCatalogEntry extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_data_catalog_entry";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/data_catalog_entry google_data_catalog_entry} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataCatalogEntryConfig
    */
    constructor(scope: Construct, id: string, config: DataCatalogEntryConfig);
    private _bigqueryDateShardedSpec;
    get bigqueryDateShardedSpec(): DataCatalogEntryBigqueryDateShardedSpecList;
    private _bigqueryTableSpec;
    get bigqueryTableSpec(): DataCatalogEntryBigqueryTableSpecList;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _entryGroup?;
    get entryGroup(): string;
    set entryGroup(value: string);
    get entryGroupInput(): string | undefined;
    private _entryId?;
    get entryId(): string;
    set entryId(value: string);
    get entryIdInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get integratedSystem(): string;
    private _linkedResource?;
    get linkedResource(): string;
    set linkedResource(value: string);
    resetLinkedResource(): void;
    get linkedResourceInput(): string | undefined;
    get name(): string;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    resetSchema(): void;
    get schemaInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    private _userSpecifiedSystem?;
    get userSpecifiedSystem(): string;
    set userSpecifiedSystem(value: string);
    resetUserSpecifiedSystem(): void;
    get userSpecifiedSystemInput(): string | undefined;
    private _userSpecifiedType?;
    get userSpecifiedType(): string;
    set userSpecifiedType(value: string);
    resetUserSpecifiedType(): void;
    get userSpecifiedTypeInput(): string | undefined;
    private _gcsFilesetSpec;
    get gcsFilesetSpec(): DataCatalogEntryGcsFilesetSpecOutputReference;
    putGcsFilesetSpec(value: DataCatalogEntryGcsFilesetSpec): void;
    resetGcsFilesetSpec(): void;
    get gcsFilesetSpecInput(): DataCatalogEntryGcsFilesetSpec | undefined;
    private _timeouts;
    get timeouts(): DataCatalogEntryTimeoutsOutputReference;
    putTimeouts(value: DataCatalogEntryTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataCatalogEntryTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
