import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocAutoscalingPolicyIamBindingConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#id DataprocAutoscalingPolicyIamBinding#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#location DataprocAutoscalingPolicyIamBinding#location}
    */
    readonly location?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#members DataprocAutoscalingPolicyIamBinding#members}
    */
    readonly members: string[];
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#policy_id DataprocAutoscalingPolicyIamBinding#policy_id}
    */
    readonly policyId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#project DataprocAutoscalingPolicyIamBinding#project}
    */
    readonly project?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#role DataprocAutoscalingPolicyIamBinding#role}
    */
    readonly role: string;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#condition DataprocAutoscalingPolicyIamBinding#condition}
    */
    readonly condition?: DataprocAutoscalingPolicyIamBindingCondition;
}
export interface DataprocAutoscalingPolicyIamBindingCondition {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#description DataprocAutoscalingPolicyIamBinding#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#expression DataprocAutoscalingPolicyIamBinding#expression}
    */
    readonly expression: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding#title DataprocAutoscalingPolicyIamBinding#title}
    */
    readonly title: string;
}
export declare function dataprocAutoscalingPolicyIamBindingConditionToTerraform(struct?: DataprocAutoscalingPolicyIamBindingConditionOutputReference | DataprocAutoscalingPolicyIamBindingCondition): any;
export declare class DataprocAutoscalingPolicyIamBindingConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocAutoscalingPolicyIamBindingCondition | undefined;
    set internalValue(value: DataprocAutoscalingPolicyIamBindingCondition | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _expression?;
    get expression(): string;
    set expression(value: string);
    get expressionInput(): string | undefined;
    private _title?;
    get title(): string;
    set title(value: string);
    get titleInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding google_dataproc_autoscaling_policy_iam_binding}
*/
export declare class DataprocAutoscalingPolicyIamBinding extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_autoscaling_policy_iam_binding";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_autoscaling_policy_iam_binding google_dataproc_autoscaling_policy_iam_binding} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocAutoscalingPolicyIamBindingConfig
    */
    constructor(scope: Construct, id: string, config: DataprocAutoscalingPolicyIamBindingConfig);
    get etag(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    resetLocation(): void;
    get locationInput(): string | undefined;
    private _members?;
    get members(): string[];
    set members(value: string[]);
    get membersInput(): string[] | undefined;
    private _policyId?;
    get policyId(): string;
    set policyId(value: string);
    get policyIdInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _role?;
    get role(): string;
    set role(value: string);
    get roleInput(): string | undefined;
    private _condition;
    get condition(): DataprocAutoscalingPolicyIamBindingConditionOutputReference;
    putCondition(value: DataprocAutoscalingPolicyIamBindingCondition): void;
    resetCondition(): void;
    get conditionInput(): DataprocAutoscalingPolicyIamBindingCondition | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
