import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataprocClusterConfig extends cdktf.TerraformMetaArguments {
    /**
    * The timeout duration which allows graceful decomissioning when you change the number of worker nodes directly through a terraform apply
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#graceful_decommission_timeout DataprocCluster#graceful_decommission_timeout}
    */
    readonly gracefulDecommissionTimeout?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#id DataprocCluster#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The list of labels (key/value pairs) to be applied to instances in the cluster. GCP generates some itself including goog-dataproc-cluster-name which is the name of the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#labels DataprocCluster#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The name of the cluster, unique within the project and zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#name DataprocCluster#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the cluster will exist. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#project DataprocCluster#project}
    */
    readonly project?: string;
    /**
    * The region in which the cluster and associated nodes will be created in. Defaults to global.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#region DataprocCluster#region}
    */
    readonly region?: string;
    /**
    * cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cluster_config DataprocCluster#cluster_config}
    */
    readonly clusterConfig?: DataprocClusterClusterConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#timeouts DataprocCluster#timeouts}
    */
    readonly timeouts?: DataprocClusterTimeouts;
    /**
    * virtual_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#virtual_cluster_config DataprocCluster#virtual_cluster_config}
    */
    readonly virtualClusterConfig?: DataprocClusterVirtualClusterConfig;
}
export interface DataprocClusterClusterConfigAutoscalingConfig {
    /**
    * The autoscaling policy used by the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#policy_uri DataprocCluster#policy_uri}
    */
    readonly policyUri: string;
}
export declare function dataprocClusterClusterConfigAutoscalingConfigToTerraform(struct?: DataprocClusterClusterConfigAutoscalingConfigOutputReference | DataprocClusterClusterConfigAutoscalingConfig): any;
export declare class DataprocClusterClusterConfigAutoscalingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigAutoscalingConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigAutoscalingConfig | undefined);
    private _policyUri?;
    get policyUri(): string;
    set policyUri(value: string);
    get policyUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigEncryptionConfig {
    /**
    * The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kms_key_name DataprocCluster#kms_key_name}
    */
    readonly kmsKeyName: string;
}
export declare function dataprocClusterClusterConfigEncryptionConfigToTerraform(struct?: DataprocClusterClusterConfigEncryptionConfigOutputReference | DataprocClusterClusterConfigEncryptionConfig): any;
export declare class DataprocClusterClusterConfigEncryptionConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigEncryptionConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigEncryptionConfig | undefined);
    private _kmsKeyName?;
    get kmsKeyName(): string;
    set kmsKeyName(value: string);
    get kmsKeyNameInput(): string | undefined;
}
export interface DataprocClusterClusterConfigEndpointConfig {
    /**
    * The flag to enable http access to specific ports on the cluster from external sources (aka Component Gateway). Defaults to false.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_http_port_access DataprocCluster#enable_http_port_access}
    */
    readonly enableHttpPortAccess: boolean | cdktf.IResolvable;
}
export declare function dataprocClusterClusterConfigEndpointConfigToTerraform(struct?: DataprocClusterClusterConfigEndpointConfigOutputReference | DataprocClusterClusterConfigEndpointConfig): any;
export declare class DataprocClusterClusterConfigEndpointConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigEndpointConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigEndpointConfig | undefined);
    private _enableHttpPortAccess?;
    get enableHttpPortAccess(): boolean | cdktf.IResolvable;
    set enableHttpPortAccess(value: boolean | cdktf.IResolvable);
    get enableHttpPortAccessInput(): boolean | cdktf.IResolvable | undefined;
    private _httpPorts;
    get httpPorts(): cdktf.StringMap;
}
export interface DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig {
    /**
    * Defines whether instances have integrity monitoring enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_integrity_monitoring DataprocCluster#enable_integrity_monitoring}
    */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have Secure Boot enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_secure_boot DataprocCluster#enable_secure_boot}
    */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
    /**
    * Defines whether instances have the vTPM enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_vtpm DataprocCluster#enable_vtpm}
    */
    readonly enableVtpm?: boolean | cdktf.IResolvable;
}
export declare function dataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigToTerraform(struct?: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference | DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): any;
export declare class DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    resetEnableIntegrityMonitoring(): void;
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    resetEnableSecureBoot(): void;
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
    private _enableVtpm?;
    get enableVtpm(): boolean | cdktf.IResolvable;
    set enableVtpm(value: boolean | cdktf.IResolvable);
    resetEnableVtpm(): void;
    get enableVtpmInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataprocClusterClusterConfigGceClusterConfig {
    /**
    * By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. If set to true, all instances in the cluster will only have internal IP addresses. Note: Private Google Access (also known as privateIpGoogleAccess) must be enabled on the subnetwork that the cluster will be launched in.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#internal_ip_only DataprocCluster#internal_ip_only}
    */
    readonly internalIpOnly?: boolean | cdktf.IResolvable;
    /**
    * A map of the Compute Engine metadata entries to add to all instances
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#metadata DataprocCluster#metadata}
    */
    readonly metadata?: {
        [key: string]: string;
    };
    /**
    * The name or self_link of the Google Compute Engine network to the cluster will be part of. Conflicts with subnetwork. If neither is specified, this defaults to the "default" network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#network DataprocCluster#network}
    */
    readonly network?: string;
    /**
    * The service account to be used by the Node VMs. If not specified, the "default" service account is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#service_account DataprocCluster#service_account}
    */
    readonly serviceAccount?: string;
    /**
    * The set of Google API scopes to be made available on all of the node VMs under the service_account specified. These can be either FQDNs, or scope aliases.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#service_account_scopes DataprocCluster#service_account_scopes}
    */
    readonly serviceAccountScopes?: string[];
    /**
    * The name or self_link of the Google Compute Engine subnetwork the cluster will be part of. Conflicts with network.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#subnetwork DataprocCluster#subnetwork}
    */
    readonly subnetwork?: string;
    /**
    * The list of instance tags applied to instances in the cluster. Tags are used to identify valid sources or targets for network firewalls.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#tags DataprocCluster#tags}
    */
    readonly tags?: string[];
    /**
    * The GCP zone where your data is stored and used (i.e. where the master and the worker nodes will be created in). If region is set to 'global' (default) then zone is mandatory, otherwise GCP is able to make use of Auto Zone Placement to determine this automatically for you. Note: This setting additionally determines and restricts which computing resources are available for use with other configs such as cluster_config.master_config.machine_type and cluster_config.worker_config.machine_type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#zone DataprocCluster#zone}
    */
    readonly zone?: string;
    /**
    * shielded_instance_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#shielded_instance_config DataprocCluster#shielded_instance_config}
    */
    readonly shieldedInstanceConfig?: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig;
}
export declare function dataprocClusterClusterConfigGceClusterConfigToTerraform(struct?: DataprocClusterClusterConfigGceClusterConfigOutputReference | DataprocClusterClusterConfigGceClusterConfig): any;
export declare class DataprocClusterClusterConfigGceClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigGceClusterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigGceClusterConfig | undefined);
    private _internalIpOnly?;
    get internalIpOnly(): boolean | cdktf.IResolvable;
    set internalIpOnly(value: boolean | cdktf.IResolvable);
    resetInternalIpOnly(): void;
    get internalIpOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _metadata?;
    get metadata(): {
        [key: string]: string;
    };
    set metadata(value: {
        [key: string]: string;
    });
    resetMetadata(): void;
    get metadataInput(): {
        [key: string]: string;
    } | undefined;
    private _network?;
    get network(): string;
    set network(value: string);
    resetNetwork(): void;
    get networkInput(): string | undefined;
    private _serviceAccount?;
    get serviceAccount(): string;
    set serviceAccount(value: string);
    resetServiceAccount(): void;
    get serviceAccountInput(): string | undefined;
    private _serviceAccountScopes?;
    get serviceAccountScopes(): string[];
    set serviceAccountScopes(value: string[]);
    resetServiceAccountScopes(): void;
    get serviceAccountScopesInput(): string[] | undefined;
    private _subnetwork?;
    get subnetwork(): string;
    set subnetwork(value: string);
    resetSubnetwork(): void;
    get subnetworkInput(): string | undefined;
    private _tags?;
    get tags(): string[];
    set tags(value: string[]);
    resetTags(): void;
    get tagsInput(): string[] | undefined;
    private _zone?;
    get zone(): string;
    set zone(value: string);
    resetZone(): void;
    get zoneInput(): string | undefined;
    private _shieldedInstanceConfig;
    get shieldedInstanceConfig(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfigOutputReference;
    putShieldedInstanceConfig(value: DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig): void;
    resetShieldedInstanceConfig(): void;
    get shieldedInstanceConfigInput(): DataprocClusterClusterConfigGceClusterConfigShieldedInstanceConfig | undefined;
}
export interface DataprocClusterClusterConfigInitializationAction {
    /**
    * The script to be executed during initialization of the cluster. The script must be a GCS file with a gs:// prefix.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#script DataprocCluster#script}
    */
    readonly script: string;
    /**
    * The maximum duration (in seconds) which script is allowed to take to execute its action. GCP will default to a predetermined computed value if not set (currently 300).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#timeout_sec DataprocCluster#timeout_sec}
    */
    readonly timeoutSec?: number;
}
export declare function dataprocClusterClusterConfigInitializationActionToTerraform(struct?: DataprocClusterClusterConfigInitializationAction | cdktf.IResolvable): any;
export declare class DataprocClusterClusterConfigInitializationActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocClusterClusterConfigInitializationAction | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocClusterClusterConfigInitializationAction | cdktf.IResolvable | undefined);
    private _script?;
    get script(): string;
    set script(value: string);
    get scriptInput(): string | undefined;
    private _timeoutSec?;
    get timeoutSec(): number;
    set timeoutSec(value: number);
    resetTimeoutSec(): void;
    get timeoutSecInput(): number | undefined;
}
export declare class DataprocClusterClusterConfigInitializationActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocClusterClusterConfigInitializationActionOutputReference;
}
export interface DataprocClusterClusterConfigLifecycleConfig {
    /**
    * The time when cluster will be auto-deleted. A timestamp in RFC3339 UTC "Zulu" format, accurate to nanoseconds. Example: "2014-10-02T15:01:23.045123456Z".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#auto_delete_time DataprocCluster#auto_delete_time}
    */
    readonly autoDeleteTime?: string;
    /**
    * The duration to keep the cluster alive while idling (no jobs running). After this TTL, the cluster will be deleted. Valid range: [10m, 14d].
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#idle_delete_ttl DataprocCluster#idle_delete_ttl}
    */
    readonly idleDeleteTtl?: string;
}
export declare function dataprocClusterClusterConfigLifecycleConfigToTerraform(struct?: DataprocClusterClusterConfigLifecycleConfigOutputReference | DataprocClusterClusterConfigLifecycleConfig): any;
export declare class DataprocClusterClusterConfigLifecycleConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigLifecycleConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigLifecycleConfig | undefined);
    private _autoDeleteTime?;
    get autoDeleteTime(): string;
    set autoDeleteTime(value: string);
    resetAutoDeleteTime(): void;
    get autoDeleteTimeInput(): string | undefined;
    private _idleDeleteTtl?;
    get idleDeleteTtl(): string;
    set idleDeleteTtl(value: string);
    resetIdleDeleteTtl(): void;
    get idleDeleteTtlInput(): string | undefined;
    get idleStartTime(): string;
}
export interface DataprocClusterClusterConfigMasterConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_count DataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_type DataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function dataprocClusterClusterConfigMasterConfigAcceleratorsToTerraform(struct?: DataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable): any;
export declare class DataprocClusterClusterConfigMasterConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocClusterClusterConfigMasterConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
}
export declare class DataprocClusterClusterConfigMasterConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocClusterClusterConfigMasterConfigAcceleratorsOutputReference;
}
export interface DataprocClusterClusterConfigMasterConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigMasterConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference | DataprocClusterClusterConfigMasterConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigMasterConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigMasterConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_uri DataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#machine_type DataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_cpu_platform DataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerators DataprocCluster#accelerators}
    */
    readonly accelerators?: DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigMasterConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigMasterConfigToTerraform(struct?: DataprocClusterClusterConfigMasterConfigOutputReference | DataprocClusterClusterConfigMasterConfig): any;
export declare class DataprocClusterClusterConfigMasterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigMasterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigMasterConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators;
    get accelerators(): DataprocClusterClusterConfigMasterConfigAcceleratorsList;
    putAccelerators(value: DataprocClusterClusterConfigMasterConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocClusterClusterConfigMasterConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigMasterConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigMasterConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigMasterConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigMetastoreConfig {
    /**
    * Resource name of an existing Dataproc Metastore service.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#dataproc_metastore_service DataprocCluster#dataproc_metastore_service}
    */
    readonly dataprocMetastoreService: string;
}
export declare function dataprocClusterClusterConfigMetastoreConfigToTerraform(struct?: DataprocClusterClusterConfigMetastoreConfigOutputReference | DataprocClusterClusterConfigMetastoreConfig): any;
export declare class DataprocClusterClusterConfigMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigMetastoreConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigMetastoreConfig | undefined);
    private _dataprocMetastoreService?;
    get dataprocMetastoreService(): string;
    set dataprocMetastoreService(value: string);
    get dataprocMetastoreServiceInput(): string | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each preemptible worker node, specified in GB. The smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each preemptible worker node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each preemptible worker node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference | DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigPreemptibleWorkerConfig {
    /**
    * Specifies the number of preemptible nodes to create. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * Specifies the preemptibility of the secondary nodes. Defaults to PREEMPTIBLE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#preemptibility DataprocCluster#preemptibility}
    */
    readonly preemptibility?: string;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigPreemptibleWorkerConfigToTerraform(struct?: DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference | DataprocClusterClusterConfigPreemptibleWorkerConfig): any;
export declare class DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined);
    get instanceNames(): string[];
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _preemptibility?;
    get preemptibility(): string;
    set preemptibility(value: string);
    resetPreemptibility(): void;
    get preemptibilityInput(): string | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfigKerberosConfig {
    /**
    * The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_admin_server DataprocCluster#cross_realm_trust_admin_server}
    */
    readonly crossRealmTrustAdminServer?: string;
    /**
    * The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_kdc DataprocCluster#cross_realm_trust_kdc}
    */
    readonly crossRealmTrustKdc?: string;
    /**
    * The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_realm DataprocCluster#cross_realm_trust_realm}
    */
    readonly crossRealmTrustRealm?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster
  Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#cross_realm_trust_shared_password_uri DataprocCluster#cross_realm_trust_shared_password_uri}
    */
    readonly crossRealmTrustSharedPasswordUri?: string;
    /**
    * Flag to indicate whether to Kerberize the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#enable_kerberos DataprocCluster#enable_kerberos}
    */
    readonly enableKerberos?: boolean | cdktf.IResolvable;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kdc_db_key_uri DataprocCluster#kdc_db_key_uri}
    */
    readonly kdcDbKeyUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#key_password_uri DataprocCluster#key_password_uri}
    */
    readonly keyPasswordUri?: string;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing
  the password to the user provided keystore. For the self-signed certificate, this password is generated
  by Dataproc
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#keystore_password_uri DataprocCluster#keystore_password_uri}
    */
    readonly keystorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#keystore_uri DataprocCluster#keystore_uri}
    */
    readonly keystoreUri?: string;
    /**
    * The uri of the KMS key used to encrypt various sensitive files.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kms_key_uri DataprocCluster#kms_key_uri}
    */
    readonly kmsKeyUri: string;
    /**
    * The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#realm DataprocCluster#realm}
    */
    readonly realm?: string;
    /**
    * The cloud Storage URI of a KMS encrypted file containing the root principal password.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#root_principal_password_uri DataprocCluster#root_principal_password_uri}
    */
    readonly rootPrincipalPasswordUri: string;
    /**
    * The lifetime of the ticket granting ticket, in hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#tgt_lifetime_hours DataprocCluster#tgt_lifetime_hours}
    */
    readonly tgtLifetimeHours?: number;
    /**
    * The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#truststore_password_uri DataprocCluster#truststore_password_uri}
    */
    readonly truststorePasswordUri?: string;
    /**
    * The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#truststore_uri DataprocCluster#truststore_uri}
    */
    readonly truststoreUri?: string;
}
export declare function dataprocClusterClusterConfigSecurityConfigKerberosConfigToTerraform(struct?: DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference | DataprocClusterClusterConfigSecurityConfigKerberosConfig): any;
export declare class DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined);
    private _crossRealmTrustAdminServer?;
    get crossRealmTrustAdminServer(): string;
    set crossRealmTrustAdminServer(value: string);
    resetCrossRealmTrustAdminServer(): void;
    get crossRealmTrustAdminServerInput(): string | undefined;
    private _crossRealmTrustKdc?;
    get crossRealmTrustKdc(): string;
    set crossRealmTrustKdc(value: string);
    resetCrossRealmTrustKdc(): void;
    get crossRealmTrustKdcInput(): string | undefined;
    private _crossRealmTrustRealm?;
    get crossRealmTrustRealm(): string;
    set crossRealmTrustRealm(value: string);
    resetCrossRealmTrustRealm(): void;
    get crossRealmTrustRealmInput(): string | undefined;
    private _crossRealmTrustSharedPasswordUri?;
    get crossRealmTrustSharedPasswordUri(): string;
    set crossRealmTrustSharedPasswordUri(value: string);
    resetCrossRealmTrustSharedPasswordUri(): void;
    get crossRealmTrustSharedPasswordUriInput(): string | undefined;
    private _enableKerberos?;
    get enableKerberos(): boolean | cdktf.IResolvable;
    set enableKerberos(value: boolean | cdktf.IResolvable);
    resetEnableKerberos(): void;
    get enableKerberosInput(): boolean | cdktf.IResolvable | undefined;
    private _kdcDbKeyUri?;
    get kdcDbKeyUri(): string;
    set kdcDbKeyUri(value: string);
    resetKdcDbKeyUri(): void;
    get kdcDbKeyUriInput(): string | undefined;
    private _keyPasswordUri?;
    get keyPasswordUri(): string;
    set keyPasswordUri(value: string);
    resetKeyPasswordUri(): void;
    get keyPasswordUriInput(): string | undefined;
    private _keystorePasswordUri?;
    get keystorePasswordUri(): string;
    set keystorePasswordUri(value: string);
    resetKeystorePasswordUri(): void;
    get keystorePasswordUriInput(): string | undefined;
    private _keystoreUri?;
    get keystoreUri(): string;
    set keystoreUri(value: string);
    resetKeystoreUri(): void;
    get keystoreUriInput(): string | undefined;
    private _kmsKeyUri?;
    get kmsKeyUri(): string;
    set kmsKeyUri(value: string);
    get kmsKeyUriInput(): string | undefined;
    private _realm?;
    get realm(): string;
    set realm(value: string);
    resetRealm(): void;
    get realmInput(): string | undefined;
    private _rootPrincipalPasswordUri?;
    get rootPrincipalPasswordUri(): string;
    set rootPrincipalPasswordUri(value: string);
    get rootPrincipalPasswordUriInput(): string | undefined;
    private _tgtLifetimeHours?;
    get tgtLifetimeHours(): number;
    set tgtLifetimeHours(value: number);
    resetTgtLifetimeHours(): void;
    get tgtLifetimeHoursInput(): number | undefined;
    private _truststorePasswordUri?;
    get truststorePasswordUri(): string;
    set truststorePasswordUri(value: string);
    resetTruststorePasswordUri(): void;
    get truststorePasswordUriInput(): string | undefined;
    private _truststoreUri?;
    get truststoreUri(): string;
    set truststoreUri(value: string);
    resetTruststoreUri(): void;
    get truststoreUriInput(): string | undefined;
}
export interface DataprocClusterClusterConfigSecurityConfig {
    /**
    * kerberos_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kerberos_config DataprocCluster#kerberos_config}
    */
    readonly kerberosConfig: DataprocClusterClusterConfigSecurityConfigKerberosConfig;
}
export declare function dataprocClusterClusterConfigSecurityConfigToTerraform(struct?: DataprocClusterClusterConfigSecurityConfigOutputReference | DataprocClusterClusterConfigSecurityConfig): any;
export declare class DataprocClusterClusterConfigSecurityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSecurityConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSecurityConfig | undefined);
    private _kerberosConfig;
    get kerberosConfig(): DataprocClusterClusterConfigSecurityConfigKerberosConfigOutputReference;
    putKerberosConfig(value: DataprocClusterClusterConfigSecurityConfigKerberosConfig): void;
    get kerberosConfigInput(): DataprocClusterClusterConfigSecurityConfigKerberosConfig | undefined;
}
export interface DataprocClusterClusterConfigSoftwareConfig {
    /**
    * The Cloud Dataproc image version to use for the cluster - this controls the sets of software versions installed onto the nodes when you create clusters. If not specified, defaults to the latest version.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_version DataprocCluster#image_version}
    */
    readonly imageVersion?: string;
    /**
    * The set of optional components to activate on the cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#optional_components DataprocCluster#optional_components}
    */
    readonly optionalComponents?: string[];
    /**
    * A list of override and additional properties (key/value pairs) used to modify various aspects of the common configuration files used when creating a cluster.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#override_properties DataprocCluster#override_properties}
    */
    readonly overrideProperties?: {
        [key: string]: string;
    };
}
export declare function dataprocClusterClusterConfigSoftwareConfigToTerraform(struct?: DataprocClusterClusterConfigSoftwareConfigOutputReference | DataprocClusterClusterConfigSoftwareConfig): any;
export declare class DataprocClusterClusterConfigSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigSoftwareConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigSoftwareConfig | undefined);
    private _imageVersion?;
    get imageVersion(): string;
    set imageVersion(value: string);
    resetImageVersion(): void;
    get imageVersionInput(): string | undefined;
    private _optionalComponents?;
    get optionalComponents(): string[];
    set optionalComponents(value: string[]);
    resetOptionalComponents(): void;
    get optionalComponentsInput(): string[] | undefined;
    private _overrideProperties?;
    get overrideProperties(): {
        [key: string]: string;
    };
    set overrideProperties(value: {
        [key: string]: string;
    });
    resetOverrideProperties(): void;
    get overridePropertiesInput(): {
        [key: string]: string;
    } | undefined;
    private _properties;
    get properties(): cdktf.StringMap;
}
export interface DataprocClusterClusterConfigWorkerConfigAccelerators {
    /**
    * The number of the accelerator cards of this type exposed to this instance. Often restricted to one of 1, 2, 4, or 8.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_count DataprocCluster#accelerator_count}
    */
    readonly acceleratorCount: number;
    /**
    * The short name of the accelerator type to expose to this instance. For example, nvidia-tesla-k80.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerator_type DataprocCluster#accelerator_type}
    */
    readonly acceleratorType: string;
}
export declare function dataprocClusterClusterConfigWorkerConfigAcceleratorsToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable): any;
export declare class DataprocClusterClusterConfigWorkerConfigAcceleratorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocClusterClusterConfigWorkerConfigAccelerators | cdktf.IResolvable | undefined);
    private _acceleratorCount?;
    get acceleratorCount(): number;
    set acceleratorCount(value: number);
    get acceleratorCountInput(): number | undefined;
    private _acceleratorType?;
    get acceleratorType(): string;
    set acceleratorType(value: string);
    get acceleratorTypeInput(): string | undefined;
}
export declare class DataprocClusterClusterConfigWorkerConfigAcceleratorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocClusterClusterConfigWorkerConfigAcceleratorsOutputReference;
}
export interface DataprocClusterClusterConfigWorkerConfigDiskConfig {
    /**
    * Size of the primary disk attached to each node, specified in GB. The primary disk contains the boot volume and system libraries, and the smallest allowed disk size is 10GB. GCP will default to a predetermined computed value if not set (currently 500GB). Note: If SSDs are not attached, it also contains the HDFS data blocks and Hadoop working directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_size_gb DataprocCluster#boot_disk_size_gb}
    */
    readonly bootDiskSizeGb?: number;
    /**
    * The disk type of the primary disk attached to each node. Such as "pd-ssd" or "pd-standard". Defaults to "pd-standard".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#boot_disk_type DataprocCluster#boot_disk_type}
    */
    readonly bootDiskType?: string;
    /**
    * The amount of local SSD disks that will be attached to each master cluster node. Defaults to 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_local_ssds DataprocCluster#num_local_ssds}
    */
    readonly numLocalSsds?: number;
}
export declare function dataprocClusterClusterConfigWorkerConfigDiskConfigToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference | DataprocClusterClusterConfigWorkerConfigDiskConfig): any;
export declare class DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined);
    private _bootDiskSizeGb?;
    get bootDiskSizeGb(): number;
    set bootDiskSizeGb(value: number);
    resetBootDiskSizeGb(): void;
    get bootDiskSizeGbInput(): number | undefined;
    private _bootDiskType?;
    get bootDiskType(): string;
    set bootDiskType(value: string);
    resetBootDiskType(): void;
    get bootDiskTypeInput(): string | undefined;
    private _numLocalSsds?;
    get numLocalSsds(): number;
    set numLocalSsds(value: number);
    resetNumLocalSsds(): void;
    get numLocalSsdsInput(): number | undefined;
}
export interface DataprocClusterClusterConfigWorkerConfig {
    /**
    * The URI for the image to use for this master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#image_uri DataprocCluster#image_uri}
    */
    readonly imageUri?: string;
    /**
    * The name of a Google Compute Engine machine type to create for the master/worker
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#machine_type DataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * The name of a minimum generation of CPU family for the master/worker. If not specified, GCP will default to a predetermined computed value for each zone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_cpu_platform DataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Specifies the number of master/worker nodes to create. If not specified, GCP will default to a predetermined computed value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#num_instances DataprocCluster#num_instances}
    */
    readonly numInstances?: number;
    /**
    * accelerators block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#accelerators DataprocCluster#accelerators}
    */
    readonly accelerators?: DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable;
    /**
    * disk_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#disk_config DataprocCluster#disk_config}
    */
    readonly diskConfig?: DataprocClusterClusterConfigWorkerConfigDiskConfig;
}
export declare function dataprocClusterClusterConfigWorkerConfigToTerraform(struct?: DataprocClusterClusterConfigWorkerConfigOutputReference | DataprocClusterClusterConfigWorkerConfig): any;
export declare class DataprocClusterClusterConfigWorkerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfigWorkerConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfigWorkerConfig | undefined);
    private _imageUri?;
    get imageUri(): string;
    set imageUri(value: string);
    resetImageUri(): void;
    get imageUriInput(): string | undefined;
    get instanceNames(): string[];
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _numInstances?;
    get numInstances(): number;
    set numInstances(value: number);
    resetNumInstances(): void;
    get numInstancesInput(): number | undefined;
    private _accelerators;
    get accelerators(): DataprocClusterClusterConfigWorkerConfigAcceleratorsList;
    putAccelerators(value: DataprocClusterClusterConfigWorkerConfigAccelerators[] | cdktf.IResolvable): void;
    resetAccelerators(): void;
    get acceleratorsInput(): cdktf.IResolvable | DataprocClusterClusterConfigWorkerConfigAccelerators[] | undefined;
    private _diskConfig;
    get diskConfig(): DataprocClusterClusterConfigWorkerConfigDiskConfigOutputReference;
    putDiskConfig(value: DataprocClusterClusterConfigWorkerConfigDiskConfig): void;
    resetDiskConfig(): void;
    get diskConfigInput(): DataprocClusterClusterConfigWorkerConfigDiskConfig | undefined;
}
export interface DataprocClusterClusterConfig {
    /**
    * The Cloud Storage staging bucket used to stage files, such as Hadoop jars, between client machines and the cluster. Note: If you don't explicitly specify a staging_bucket then GCP will auto create / assign one for you. However, you are not guaranteed an auto generated bucket which is solely dedicated to your cluster; it may be shared with other clusters in the same region/zone also choosing to use the auto generation option.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#staging_bucket DataprocCluster#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * The Cloud Storage temp bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. Note: If you don't explicitly specify a temp_bucket then GCP will auto create / assign one for you.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#temp_bucket DataprocCluster#temp_bucket}
    */
    readonly tempBucket?: string;
    /**
    * autoscaling_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#autoscaling_config DataprocCluster#autoscaling_config}
    */
    readonly autoscalingConfig?: DataprocClusterClusterConfigAutoscalingConfig;
    /**
    * encryption_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#encryption_config DataprocCluster#encryption_config}
    */
    readonly encryptionConfig?: DataprocClusterClusterConfigEncryptionConfig;
    /**
    * endpoint_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#endpoint_config DataprocCluster#endpoint_config}
    */
    readonly endpointConfig?: DataprocClusterClusterConfigEndpointConfig;
    /**
    * gce_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#gce_cluster_config DataprocCluster#gce_cluster_config}
    */
    readonly gceClusterConfig?: DataprocClusterClusterConfigGceClusterConfig;
    /**
    * initialization_action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#initialization_action DataprocCluster#initialization_action}
    */
    readonly initializationAction?: DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable;
    /**
    * lifecycle_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#lifecycle_config DataprocCluster#lifecycle_config}
    */
    readonly lifecycleConfig?: DataprocClusterClusterConfigLifecycleConfig;
    /**
    * master_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#master_config DataprocCluster#master_config}
    */
    readonly masterConfig?: DataprocClusterClusterConfigMasterConfig;
    /**
    * metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#metastore_config DataprocCluster#metastore_config}
    */
    readonly metastoreConfig?: DataprocClusterClusterConfigMetastoreConfig;
    /**
    * preemptible_worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#preemptible_worker_config DataprocCluster#preemptible_worker_config}
    */
    readonly preemptibleWorkerConfig?: DataprocClusterClusterConfigPreemptibleWorkerConfig;
    /**
    * security_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#security_config DataprocCluster#security_config}
    */
    readonly securityConfig?: DataprocClusterClusterConfigSecurityConfig;
    /**
    * software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#software_config DataprocCluster#software_config}
    */
    readonly softwareConfig?: DataprocClusterClusterConfigSoftwareConfig;
    /**
    * worker_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#worker_config DataprocCluster#worker_config}
    */
    readonly workerConfig?: DataprocClusterClusterConfigWorkerConfig;
}
export declare function dataprocClusterClusterConfigToTerraform(struct?: DataprocClusterClusterConfigOutputReference | DataprocClusterClusterConfig): any;
export declare class DataprocClusterClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterClusterConfig | undefined;
    set internalValue(value: DataprocClusterClusterConfig | undefined);
    get bucket(): string;
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _tempBucket?;
    get tempBucket(): string;
    set tempBucket(value: string);
    resetTempBucket(): void;
    get tempBucketInput(): string | undefined;
    private _autoscalingConfig;
    get autoscalingConfig(): DataprocClusterClusterConfigAutoscalingConfigOutputReference;
    putAutoscalingConfig(value: DataprocClusterClusterConfigAutoscalingConfig): void;
    resetAutoscalingConfig(): void;
    get autoscalingConfigInput(): DataprocClusterClusterConfigAutoscalingConfig | undefined;
    private _encryptionConfig;
    get encryptionConfig(): DataprocClusterClusterConfigEncryptionConfigOutputReference;
    putEncryptionConfig(value: DataprocClusterClusterConfigEncryptionConfig): void;
    resetEncryptionConfig(): void;
    get encryptionConfigInput(): DataprocClusterClusterConfigEncryptionConfig | undefined;
    private _endpointConfig;
    get endpointConfig(): DataprocClusterClusterConfigEndpointConfigOutputReference;
    putEndpointConfig(value: DataprocClusterClusterConfigEndpointConfig): void;
    resetEndpointConfig(): void;
    get endpointConfigInput(): DataprocClusterClusterConfigEndpointConfig | undefined;
    private _gceClusterConfig;
    get gceClusterConfig(): DataprocClusterClusterConfigGceClusterConfigOutputReference;
    putGceClusterConfig(value: DataprocClusterClusterConfigGceClusterConfig): void;
    resetGceClusterConfig(): void;
    get gceClusterConfigInput(): DataprocClusterClusterConfigGceClusterConfig | undefined;
    private _initializationAction;
    get initializationAction(): DataprocClusterClusterConfigInitializationActionList;
    putInitializationAction(value: DataprocClusterClusterConfigInitializationAction[] | cdktf.IResolvable): void;
    resetInitializationAction(): void;
    get initializationActionInput(): cdktf.IResolvable | DataprocClusterClusterConfigInitializationAction[] | undefined;
    private _lifecycleConfig;
    get lifecycleConfig(): DataprocClusterClusterConfigLifecycleConfigOutputReference;
    putLifecycleConfig(value: DataprocClusterClusterConfigLifecycleConfig): void;
    resetLifecycleConfig(): void;
    get lifecycleConfigInput(): DataprocClusterClusterConfigLifecycleConfig | undefined;
    private _masterConfig;
    get masterConfig(): DataprocClusterClusterConfigMasterConfigOutputReference;
    putMasterConfig(value: DataprocClusterClusterConfigMasterConfig): void;
    resetMasterConfig(): void;
    get masterConfigInput(): DataprocClusterClusterConfigMasterConfig | undefined;
    private _metastoreConfig;
    get metastoreConfig(): DataprocClusterClusterConfigMetastoreConfigOutputReference;
    putMetastoreConfig(value: DataprocClusterClusterConfigMetastoreConfig): void;
    resetMetastoreConfig(): void;
    get metastoreConfigInput(): DataprocClusterClusterConfigMetastoreConfig | undefined;
    private _preemptibleWorkerConfig;
    get preemptibleWorkerConfig(): DataprocClusterClusterConfigPreemptibleWorkerConfigOutputReference;
    putPreemptibleWorkerConfig(value: DataprocClusterClusterConfigPreemptibleWorkerConfig): void;
    resetPreemptibleWorkerConfig(): void;
    get preemptibleWorkerConfigInput(): DataprocClusterClusterConfigPreemptibleWorkerConfig | undefined;
    private _securityConfig;
    get securityConfig(): DataprocClusterClusterConfigSecurityConfigOutputReference;
    putSecurityConfig(value: DataprocClusterClusterConfigSecurityConfig): void;
    resetSecurityConfig(): void;
    get securityConfigInput(): DataprocClusterClusterConfigSecurityConfig | undefined;
    private _softwareConfig;
    get softwareConfig(): DataprocClusterClusterConfigSoftwareConfigOutputReference;
    putSoftwareConfig(value: DataprocClusterClusterConfigSoftwareConfig): void;
    resetSoftwareConfig(): void;
    get softwareConfigInput(): DataprocClusterClusterConfigSoftwareConfig | undefined;
    private _workerConfig;
    get workerConfig(): DataprocClusterClusterConfigWorkerConfigOutputReference;
    putWorkerConfig(value: DataprocClusterClusterConfigWorkerConfig): void;
    resetWorkerConfig(): void;
    get workerConfigInput(): DataprocClusterClusterConfigWorkerConfig | undefined;
}
export interface DataprocClusterTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#create DataprocCluster#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#delete DataprocCluster#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#update DataprocCluster#update}
    */
    readonly update?: string;
}
export declare function dataprocClusterTimeoutsToTerraform(struct?: DataprocClusterTimeoutsOutputReference | DataprocClusterTimeouts | cdktf.IResolvable): any;
export declare class DataprocClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocClusterTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig {
    /**
    * The Hive Metastore configuration for this workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#dataproc_metastore_service DataprocCluster#dataproc_metastore_service}
    */
    readonly dataprocMetastoreService?: string;
}
export declare function dataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfigOutputReference | DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig): any;
export declare class DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig | undefined);
    private _dataprocMetastoreService?;
    get dataprocMetastoreService(): string;
    set dataprocMetastoreService(value: string);
    resetDataprocMetastoreService(): void;
    get dataprocMetastoreServiceInput(): string | undefined;
}
export interface DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig {
    /**
    * Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#dataproc_cluster DataprocCluster#dataproc_cluster}
    */
    readonly dataprocCluster?: string;
}
export declare function dataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfigOutputReference | DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig): any;
export declare class DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig | undefined);
    private _dataprocCluster?;
    get dataprocCluster(): string;
    set dataprocCluster(value: string);
    resetDataprocCluster(): void;
    get dataprocClusterInput(): string | undefined;
}
export interface DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig {
    /**
    * metastore_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#metastore_config DataprocCluster#metastore_config}
    */
    readonly metastoreConfig?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig;
    /**
    * spark_history_server_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#spark_history_server_config DataprocCluster#spark_history_server_config}
    */
    readonly sparkHistoryServerConfig?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig;
}
export declare function dataprocClusterVirtualClusterConfigAuxiliaryServicesConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigOutputReference | DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig): any;
export declare class DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig | undefined);
    private _metastoreConfig;
    get metastoreConfig(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfigOutputReference;
    putMetastoreConfig(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig): void;
    resetMetastoreConfig(): void;
    get metastoreConfigInput(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigMetastoreConfig | undefined;
    private _sparkHistoryServerConfig;
    get sparkHistoryServerConfig(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfigOutputReference;
    putSparkHistoryServerConfig(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig): void;
    resetSparkHistoryServerConfig(): void;
    get sparkHistoryServerConfigInput(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigSparkHistoryServerConfig | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling {
    /**
    * The maximum number of nodes in the node pool. Must be >= minNodeCount, and must be > 0.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#max_node_count DataprocCluster#max_node_count}
    */
    readonly maxNodeCount?: number;
    /**
    * The minimum number of nodes in the node pool. Must be >= 0 and <= maxNodeCount.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_node_count DataprocCluster#min_node_count}
    */
    readonly minNodeCount?: number;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscalingToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscalingOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling | undefined);
    private _maxNodeCount?;
    get maxNodeCount(): number;
    set maxNodeCount(value: number);
    resetMaxNodeCount(): void;
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    get minNodeCount(): number;
    set minNodeCount(value: number);
    resetMinNodeCount(): void;
    get minNodeCountInput(): number | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig {
    /**
    * The minimum number of nodes in the node pool. Must be >= 0 and <= maxNodeCount.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#local_ssd_count DataprocCluster#local_ssd_count}
    */
    readonly localSsdCount?: number;
    /**
    * The name of a Compute Engine machine type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#machine_type DataprocCluster#machine_type}
    */
    readonly machineType?: string;
    /**
    * Minimum CPU platform to be used by this instance. The instance may be scheduled on the specified or a newer CPU platform. Specify the friendly names of CPU platforms, such as "Intel Haswell" or "Intel Sandy Bridge".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#min_cpu_platform DataprocCluster#min_cpu_platform}
    */
    readonly minCpuPlatform?: string;
    /**
    * Whether the nodes are created as preemptible VM instances. Preemptible nodes cannot be used in a node pool with the CONTROLLER role or in the DEFAULT node pool if the CONTROLLER role is not assigned (the DEFAULT node pool will assume the CONTROLLER role).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#preemptible DataprocCluster#preemptible}
    */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
    * Spot flag for enabling Spot VM, which is a rebrand of the existing preemptible flag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#spot DataprocCluster#spot}
    */
    readonly spot?: boolean | cdktf.IResolvable;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfigOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig | undefined);
    private _localSsdCount?;
    get localSsdCount(): number;
    set localSsdCount(value: number);
    resetLocalSsdCount(): void;
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    get machineType(): string;
    set machineType(value: string);
    resetMachineType(): void;
    get machineTypeInput(): string | undefined;
    private _minCpuPlatform?;
    get minCpuPlatform(): string;
    set minCpuPlatform(value: string);
    resetMinCpuPlatform(): void;
    get minCpuPlatformInput(): string | undefined;
    private _preemptible?;
    get preemptible(): boolean | cdktf.IResolvable;
    set preemptible(value: boolean | cdktf.IResolvable);
    resetPreemptible(): void;
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _spot?;
    get spot(): boolean | cdktf.IResolvable;
    set spot(value: boolean | cdktf.IResolvable);
    resetSpot(): void;
    get spotInput(): boolean | cdktf.IResolvable | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig {
    /**
    * The list of Compute Engine zones where node pool nodes associated with a Dataproc on GKE virtual cluster will be located.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#locations DataprocCluster#locations}
    */
    readonly locations: string[];
    /**
    * autoscaling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#autoscaling DataprocCluster#autoscaling}
    */
    readonly autoscaling?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#config DataprocCluster#config}
    */
    readonly config?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig | undefined);
    private _locations?;
    get locations(): string[];
    set locations(value: string[]);
    get locationsInput(): string[] | undefined;
    private _autoscaling;
    get autoscaling(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscalingOutputReference;
    putAutoscaling(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling): void;
    resetAutoscaling(): void;
    get autoscalingInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigAutoscaling | undefined;
    private _config;
    get config(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfigOutputReference;
    putConfig(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig): void;
    resetConfig(): void;
    get configInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigConfig | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget {
    /**
    * The target GKE node pool. Format: 'projects/{project}/locations/{location}/clusters/{cluster}/nodePools/{nodePool}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#node_pool DataprocCluster#node_pool}
    */
    readonly nodePool: string;
    /**
    * The roles associated with the GKE node pool.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#roles DataprocCluster#roles}
    */
    readonly roles: string[];
    /**
    * node_pool_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#node_pool_config DataprocCluster#node_pool_config}
    */
    readonly nodePoolConfig?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget | cdktf.IResolvable): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget | cdktf.IResolvable | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget | cdktf.IResolvable | undefined);
    private _nodePool?;
    get nodePool(): string;
    set nodePool(value: string);
    get nodePoolInput(): string | undefined;
    private _roles?;
    get roles(): string[];
    set roles(value: string[]);
    get rolesInput(): string[] | undefined;
    private _nodePoolConfig;
    get nodePoolConfig(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfigOutputReference;
    putNodePoolConfig(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig): void;
    resetNodePoolConfig(): void;
    get nodePoolConfigInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetNodePoolConfig | undefined;
}
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetOutputReference;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig {
    /**
    * A target GKE cluster to deploy to. It must be in the same project and region as the Dataproc cluster (the GKE cluster can be zonal or regional). Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#gke_cluster_target DataprocCluster#gke_cluster_target}
    */
    readonly gkeClusterTarget?: string;
    /**
    * node_pool_target block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#node_pool_target DataprocCluster#node_pool_target}
    */
    readonly nodePoolTarget?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget[] | cdktf.IResolvable;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig | undefined);
    private _gkeClusterTarget?;
    get gkeClusterTarget(): string;
    set gkeClusterTarget(value: string);
    resetGkeClusterTarget(): void;
    get gkeClusterTargetInput(): string | undefined;
    private _nodePoolTarget;
    get nodePoolTarget(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTargetList;
    putNodePoolTarget(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget[] | cdktf.IResolvable): void;
    resetNodePoolTarget(): void;
    get nodePoolTargetInput(): cdktf.IResolvable | DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigNodePoolTarget[] | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig {
    /**
    * The components that should be installed in this Dataproc cluster. The key must be a string from the KubernetesComponent enumeration. The value is the version of the software to be installed.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#component_version DataprocCluster#component_version}
    */
    readonly componentVersion: {
        [key: string]: string;
    };
    /**
    * The properties to set on daemon config files. Property keys are specified in prefix:property format, for example spark:spark.kubernetes.container.image.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#properties DataprocCluster#properties}
    */
    readonly properties?: {
        [key: string]: string;
    };
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfigOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig | undefined);
    private _componentVersion?;
    get componentVersion(): {
        [key: string]: string;
    };
    set componentVersion(value: {
        [key: string]: string;
    });
    get componentVersionInput(): {
        [key: string]: string;
    } | undefined;
    private _properties?;
    get properties(): {
        [key: string]: string;
    };
    set properties(value: {
        [key: string]: string;
    });
    resetProperties(): void;
    get propertiesInput(): {
        [key: string]: string;
    } | undefined;
}
export interface DataprocClusterVirtualClusterConfigKubernetesClusterConfig {
    /**
    * A namespace within the Kubernetes cluster to deploy into. If this namespace does not exist, it is created. If it exists, Dataproc verifies that another Dataproc VirtualCluster is not installed into it. If not specified, the name of the Dataproc Cluster is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kubernetes_namespace DataprocCluster#kubernetes_namespace}
    */
    readonly kubernetesNamespace?: string;
    /**
    * gke_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#gke_cluster_config DataprocCluster#gke_cluster_config}
    */
    readonly gkeClusterConfig: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig;
    /**
    * kubernetes_software_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kubernetes_software_config DataprocCluster#kubernetes_software_config}
    */
    readonly kubernetesSoftwareConfig: DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig;
}
export declare function dataprocClusterVirtualClusterConfigKubernetesClusterConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigKubernetesClusterConfigOutputReference | DataprocClusterVirtualClusterConfigKubernetesClusterConfig): any;
export declare class DataprocClusterVirtualClusterConfigKubernetesClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfigKubernetesClusterConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfig | undefined);
    private _kubernetesNamespace?;
    get kubernetesNamespace(): string;
    set kubernetesNamespace(value: string);
    resetKubernetesNamespace(): void;
    get kubernetesNamespaceInput(): string | undefined;
    private _gkeClusterConfig;
    get gkeClusterConfig(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfigOutputReference;
    putGkeClusterConfig(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig): void;
    get gkeClusterConfigInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigGkeClusterConfig | undefined;
    private _kubernetesSoftwareConfig;
    get kubernetesSoftwareConfig(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfigOutputReference;
    putKubernetesSoftwareConfig(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig): void;
    get kubernetesSoftwareConfigInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigKubernetesSoftwareConfig | undefined;
}
export interface DataprocClusterVirtualClusterConfig {
    /**
    * A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#staging_bucket DataprocCluster#staging_bucket}
    */
    readonly stagingBucket?: string;
    /**
    * auxiliary_services_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#auxiliary_services_config DataprocCluster#auxiliary_services_config}
    */
    readonly auxiliaryServicesConfig?: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig;
    /**
    * kubernetes_cluster_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster#kubernetes_cluster_config DataprocCluster#kubernetes_cluster_config}
    */
    readonly kubernetesClusterConfig?: DataprocClusterVirtualClusterConfigKubernetesClusterConfig;
}
export declare function dataprocClusterVirtualClusterConfigToTerraform(struct?: DataprocClusterVirtualClusterConfigOutputReference | DataprocClusterVirtualClusterConfig): any;
export declare class DataprocClusterVirtualClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DataprocClusterVirtualClusterConfig | undefined;
    set internalValue(value: DataprocClusterVirtualClusterConfig | undefined);
    private _stagingBucket?;
    get stagingBucket(): string;
    set stagingBucket(value: string);
    resetStagingBucket(): void;
    get stagingBucketInput(): string | undefined;
    private _auxiliaryServicesConfig;
    get auxiliaryServicesConfig(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfigOutputReference;
    putAuxiliaryServicesConfig(value: DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig): void;
    resetAuxiliaryServicesConfig(): void;
    get auxiliaryServicesConfigInput(): DataprocClusterVirtualClusterConfigAuxiliaryServicesConfig | undefined;
    private _kubernetesClusterConfig;
    get kubernetesClusterConfig(): DataprocClusterVirtualClusterConfigKubernetesClusterConfigOutputReference;
    putKubernetesClusterConfig(value: DataprocClusterVirtualClusterConfigKubernetesClusterConfig): void;
    resetKubernetesClusterConfig(): void;
    get kubernetesClusterConfigInput(): DataprocClusterVirtualClusterConfigKubernetesClusterConfig | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster google_dataproc_cluster}
*/
export declare class DataprocCluster extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dataproc_cluster";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dataproc_cluster google_dataproc_cluster} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataprocClusterConfig
    */
    constructor(scope: Construct, id: string, config: DataprocClusterConfig);
    private _gracefulDecommissionTimeout?;
    get gracefulDecommissionTimeout(): string;
    set gracefulDecommissionTimeout(value: string);
    resetGracefulDecommissionTimeout(): void;
    get gracefulDecommissionTimeoutInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _clusterConfig;
    get clusterConfig(): DataprocClusterClusterConfigOutputReference;
    putClusterConfig(value: DataprocClusterClusterConfig): void;
    resetClusterConfig(): void;
    get clusterConfigInput(): DataprocClusterClusterConfig | undefined;
    private _timeouts;
    get timeouts(): DataprocClusterTimeoutsOutputReference;
    putTimeouts(value: DataprocClusterTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DataprocClusterTimeouts | undefined;
    private _virtualClusterConfig;
    get virtualClusterConfig(): DataprocClusterVirtualClusterConfigOutputReference;
    putVirtualClusterConfig(value: DataprocClusterVirtualClusterConfig): void;
    resetVirtualClusterConfig(): void;
    get virtualClusterConfigInput(): DataprocClusterVirtualClusterConfig | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
