import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsManagedZoneConfig extends cdktf.TerraformMetaArguments {
    /**
    * A textual description field. Defaults to 'Managed by Terraform'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#description DnsManagedZone#description}
    */
    readonly description?: string;
    /**
    * The DNS name of this managed zone, for instance "example.com.".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#dns_name DnsManagedZone#dns_name}
    */
    readonly dnsName: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#force_destroy DnsManagedZone#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#id DnsManagedZone#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to this ManagedZone.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#labels DnsManagedZone#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * User assigned name for this resource.
  Must be unique within the project.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#name DnsManagedZone#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#project DnsManagedZone#project}
    */
    readonly project?: string;
    /**
    * The zone's visibility: public zones are exposed to the Internet,
  while private zones are visible only to Virtual Private Cloud resources. Default value: "public" Possible values: ["private", "public"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#visibility DnsManagedZone#visibility}
    */
    readonly visibility?: string;
    /**
    * dnssec_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#dnssec_config DnsManagedZone#dnssec_config}
    */
    readonly dnssecConfig?: DnsManagedZoneDnssecConfig;
    /**
    * forwarding_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#forwarding_config DnsManagedZone#forwarding_config}
    */
    readonly forwardingConfig?: DnsManagedZoneForwardingConfig;
    /**
    * peering_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#peering_config DnsManagedZone#peering_config}
    */
    readonly peeringConfig?: DnsManagedZonePeeringConfig;
    /**
    * private_visibility_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#private_visibility_config DnsManagedZone#private_visibility_config}
    */
    readonly privateVisibilityConfig?: DnsManagedZonePrivateVisibilityConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#timeouts DnsManagedZone#timeouts}
    */
    readonly timeouts?: DnsManagedZoneTimeouts;
}
export interface DnsManagedZoneDnssecConfigDefaultKeySpecs {
    /**
    * String mnemonic specifying the DNSSEC algorithm of this key Possible values: ["ecdsap256sha256", "ecdsap384sha384", "rsasha1", "rsasha256", "rsasha512"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#algorithm DnsManagedZone#algorithm}
    */
    readonly algorithm?: string;
    /**
    * Length of the keys in bits
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#key_length DnsManagedZone#key_length}
    */
    readonly keyLength?: number;
    /**
    * Specifies whether this is a key signing key (KSK) or a zone
  signing key (ZSK). Key signing keys have the Secure Entry
  Point flag set and, when active, will only be used to sign
  resource record sets of type DNSKEY. Zone signing keys do
  not have the Secure Entry Point flag set and will be used
  to sign all other types of resource record sets. Possible values: ["keySigning", "zoneSigning"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#key_type DnsManagedZone#key_type}
    */
    readonly keyType?: string;
    /**
    * Identifies what kind of resource this is
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#kind DnsManagedZone#kind}
    */
    readonly kind?: string;
}
export declare function dnsManagedZoneDnssecConfigDefaultKeySpecsToTerraform(struct?: DnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable): any;
export declare class DnsManagedZoneDnssecConfigDefaultKeySpecsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable | undefined;
    set internalValue(value: DnsManagedZoneDnssecConfigDefaultKeySpecs | cdktf.IResolvable | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _keyLength?;
    get keyLength(): number;
    set keyLength(value: number);
    resetKeyLength(): void;
    get keyLengthInput(): number | undefined;
    private _keyType?;
    get keyType(): string;
    set keyType(value: string);
    resetKeyType(): void;
    get keyTypeInput(): string | undefined;
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
}
export declare class DnsManagedZoneDnssecConfigDefaultKeySpecsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsManagedZoneDnssecConfigDefaultKeySpecsOutputReference;
}
export interface DnsManagedZoneDnssecConfig {
    /**
    * Identifies what kind of resource this is
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#kind DnsManagedZone#kind}
    */
    readonly kind?: string;
    /**
    * Specifies the mechanism used to provide authenticated denial-of-existence responses.
  non_existence can only be updated when the state is 'off'. Possible values: ["nsec", "nsec3"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#non_existence DnsManagedZone#non_existence}
    */
    readonly nonExistence?: string;
    /**
    * Specifies whether DNSSEC is enabled, and what mode it is in Possible values: ["off", "on", "transfer"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#state DnsManagedZone#state}
    */
    readonly state?: string;
    /**
    * default_key_specs block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#default_key_specs DnsManagedZone#default_key_specs}
    */
    readonly defaultKeySpecs?: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable;
}
export declare function dnsManagedZoneDnssecConfigToTerraform(struct?: DnsManagedZoneDnssecConfigOutputReference | DnsManagedZoneDnssecConfig): any;
export declare class DnsManagedZoneDnssecConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZoneDnssecConfig | undefined;
    set internalValue(value: DnsManagedZoneDnssecConfig | undefined);
    private _kind?;
    get kind(): string;
    set kind(value: string);
    resetKind(): void;
    get kindInput(): string | undefined;
    private _nonExistence?;
    get nonExistence(): string;
    set nonExistence(value: string);
    resetNonExistence(): void;
    get nonExistenceInput(): string | undefined;
    private _state?;
    get state(): string;
    set state(value: string);
    resetState(): void;
    get stateInput(): string | undefined;
    private _defaultKeySpecs;
    get defaultKeySpecs(): DnsManagedZoneDnssecConfigDefaultKeySpecsList;
    putDefaultKeySpecs(value: DnsManagedZoneDnssecConfigDefaultKeySpecs[] | cdktf.IResolvable): void;
    resetDefaultKeySpecs(): void;
    get defaultKeySpecsInput(): cdktf.IResolvable | DnsManagedZoneDnssecConfigDefaultKeySpecs[] | undefined;
}
export interface DnsManagedZoneForwardingConfigTargetNameServers {
    /**
    * Forwarding path for this TargetNameServer. If unset or 'default' Cloud DNS will make forwarding
  decision based on address ranges, i.e. RFC1918 addresses go to the VPC, Non-RFC1918 addresses go
  to the Internet. When set to 'private', Cloud DNS will always send queries through VPC for this target Possible values: ["default", "private"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#forwarding_path DnsManagedZone#forwarding_path}
    */
    readonly forwardingPath?: string;
    /**
    * IPv4 address of a target name server.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#ipv4_address DnsManagedZone#ipv4_address}
    */
    readonly ipv4Address: string;
}
export declare function dnsManagedZoneForwardingConfigTargetNameServersToTerraform(struct?: DnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable): any;
export declare class DnsManagedZoneForwardingConfigTargetNameServersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable | undefined;
    set internalValue(value: DnsManagedZoneForwardingConfigTargetNameServers | cdktf.IResolvable | undefined);
    private _forwardingPath?;
    get forwardingPath(): string;
    set forwardingPath(value: string);
    resetForwardingPath(): void;
    get forwardingPathInput(): string | undefined;
    private _ipv4Address?;
    get ipv4Address(): string;
    set ipv4Address(value: string);
    get ipv4AddressInput(): string | undefined;
}
export declare class DnsManagedZoneForwardingConfigTargetNameServersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsManagedZoneForwardingConfigTargetNameServersOutputReference;
}
export interface DnsManagedZoneForwardingConfig {
    /**
    * target_name_servers block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#target_name_servers DnsManagedZone#target_name_servers}
    */
    readonly targetNameServers: DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable;
}
export declare function dnsManagedZoneForwardingConfigToTerraform(struct?: DnsManagedZoneForwardingConfigOutputReference | DnsManagedZoneForwardingConfig): any;
export declare class DnsManagedZoneForwardingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZoneForwardingConfig | undefined;
    set internalValue(value: DnsManagedZoneForwardingConfig | undefined);
    private _targetNameServers;
    get targetNameServers(): DnsManagedZoneForwardingConfigTargetNameServersList;
    putTargetNameServers(value: DnsManagedZoneForwardingConfigTargetNameServers[] | cdktf.IResolvable): void;
    get targetNameServersInput(): cdktf.IResolvable | DnsManagedZoneForwardingConfigTargetNameServers[] | undefined;
}
export interface DnsManagedZonePeeringConfigTargetNetwork {
    /**
    * The id or fully qualified URL of the VPC network to forward queries to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#network_url DnsManagedZone#network_url}
    */
    readonly networkUrl: string;
}
export declare function dnsManagedZonePeeringConfigTargetNetworkToTerraform(struct?: DnsManagedZonePeeringConfigTargetNetworkOutputReference | DnsManagedZonePeeringConfigTargetNetwork): any;
export declare class DnsManagedZonePeeringConfigTargetNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
    set internalValue(value: DnsManagedZonePeeringConfigTargetNetwork | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export interface DnsManagedZonePeeringConfig {
    /**
    * target_network block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#target_network DnsManagedZone#target_network}
    */
    readonly targetNetwork: DnsManagedZonePeeringConfigTargetNetwork;
}
export declare function dnsManagedZonePeeringConfigToTerraform(struct?: DnsManagedZonePeeringConfigOutputReference | DnsManagedZonePeeringConfig): any;
export declare class DnsManagedZonePeeringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZonePeeringConfig | undefined;
    set internalValue(value: DnsManagedZonePeeringConfig | undefined);
    private _targetNetwork;
    get targetNetwork(): DnsManagedZonePeeringConfigTargetNetworkOutputReference;
    putTargetNetwork(value: DnsManagedZonePeeringConfigTargetNetwork): void;
    get targetNetworkInput(): DnsManagedZonePeeringConfigTargetNetwork | undefined;
}
export interface DnsManagedZonePrivateVisibilityConfigNetworks {
    /**
    * The id or fully qualified URL of the VPC network to bind to.
  This should be formatted like 'projects/{project}/global/networks/{network}' or
  'https://www.googleapis.com/compute/v1/projects/{project}/global/networks/{network}'
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#network_url DnsManagedZone#network_url}
    */
    readonly networkUrl: string;
}
export declare function dnsManagedZonePrivateVisibilityConfigNetworksToTerraform(struct?: DnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable): any;
export declare class DnsManagedZonePrivateVisibilityConfigNetworksOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable | undefined;
    set internalValue(value: DnsManagedZonePrivateVisibilityConfigNetworks | cdktf.IResolvable | undefined);
    private _networkUrl?;
    get networkUrl(): string;
    set networkUrl(value: string);
    get networkUrlInput(): string | undefined;
}
export declare class DnsManagedZonePrivateVisibilityConfigNetworksList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsManagedZonePrivateVisibilityConfigNetworksOutputReference;
}
export interface DnsManagedZonePrivateVisibilityConfig {
    /**
    * networks block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#networks DnsManagedZone#networks}
    */
    readonly networks: DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable;
}
export declare function dnsManagedZonePrivateVisibilityConfigToTerraform(struct?: DnsManagedZonePrivateVisibilityConfigOutputReference | DnsManagedZonePrivateVisibilityConfig): any;
export declare class DnsManagedZonePrivateVisibilityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZonePrivateVisibilityConfig | undefined;
    set internalValue(value: DnsManagedZonePrivateVisibilityConfig | undefined);
    private _networks;
    get networks(): DnsManagedZonePrivateVisibilityConfigNetworksList;
    putNetworks(value: DnsManagedZonePrivateVisibilityConfigNetworks[] | cdktf.IResolvable): void;
    get networksInput(): cdktf.IResolvable | DnsManagedZonePrivateVisibilityConfigNetworks[] | undefined;
}
export interface DnsManagedZoneTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#create DnsManagedZone#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#delete DnsManagedZone#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone#update DnsManagedZone#update}
    */
    readonly update?: string;
}
export declare function dnsManagedZoneTimeoutsToTerraform(struct?: DnsManagedZoneTimeoutsOutputReference | DnsManagedZoneTimeouts | cdktf.IResolvable): any;
export declare class DnsManagedZoneTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsManagedZoneTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: DnsManagedZoneTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone google_dns_managed_zone}
*/
export declare class DnsManagedZone extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_managed_zone";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_managed_zone google_dns_managed_zone} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsManagedZoneConfig
    */
    constructor(scope: Construct, id: string, config: DnsManagedZoneConfig);
    get creationTime(): string;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _dnsName?;
    get dnsName(): string;
    set dnsName(value: string);
    get dnsNameInput(): string | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    get managedZoneId(): number;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get nameServers(): string[];
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _visibility?;
    get visibility(): string;
    set visibility(value: string);
    resetVisibility(): void;
    get visibilityInput(): string | undefined;
    private _dnssecConfig;
    get dnssecConfig(): DnsManagedZoneDnssecConfigOutputReference;
    putDnssecConfig(value: DnsManagedZoneDnssecConfig): void;
    resetDnssecConfig(): void;
    get dnssecConfigInput(): DnsManagedZoneDnssecConfig | undefined;
    private _forwardingConfig;
    get forwardingConfig(): DnsManagedZoneForwardingConfigOutputReference;
    putForwardingConfig(value: DnsManagedZoneForwardingConfig): void;
    resetForwardingConfig(): void;
    get forwardingConfigInput(): DnsManagedZoneForwardingConfig | undefined;
    private _peeringConfig;
    get peeringConfig(): DnsManagedZonePeeringConfigOutputReference;
    putPeeringConfig(value: DnsManagedZonePeeringConfig): void;
    resetPeeringConfig(): void;
    get peeringConfigInput(): DnsManagedZonePeeringConfig | undefined;
    private _privateVisibilityConfig;
    get privateVisibilityConfig(): DnsManagedZonePrivateVisibilityConfigOutputReference;
    putPrivateVisibilityConfig(value: DnsManagedZonePrivateVisibilityConfig): void;
    resetPrivateVisibilityConfig(): void;
    get privateVisibilityConfigInput(): DnsManagedZonePrivateVisibilityConfig | undefined;
    private _timeouts;
    get timeouts(): DnsManagedZoneTimeoutsOutputReference;
    putTimeouts(value: DnsManagedZoneTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | DnsManagedZoneTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
