import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DnsRecordSetConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#id DnsRecordSet#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * The name of the zone in which this record set will reside.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#managed_zone DnsRecordSet#managed_zone}
    */
    readonly managedZone: string;
    /**
    * The DNS name this record set will apply to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#name DnsRecordSet#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#project DnsRecordSet#project}
    */
    readonly project?: string;
    /**
    * The string data for the records in this record set whose meaning depends on the DNS type. For TXT record, if the string data contains spaces, add surrounding \" if you don't want your string to get split on spaces. To specify a single record value longer than 255 characters such as a TXT record for DKIM, add \"\" inside the Terraform configuration string (e.g. "first255characters\"\"morecharacters").
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas?: string[];
    /**
    * The time-to-live of this record set (seconds).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#ttl DnsRecordSet#ttl}
    */
    readonly ttl?: number;
    /**
    * The DNS record set type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#type DnsRecordSet#type}
    */
    readonly type: string;
    /**
    * routing_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#routing_policy DnsRecordSet#routing_policy}
    */
    readonly routingPolicy?: DnsRecordSetRoutingPolicy;
}
export interface DnsRecordSetRoutingPolicyGeo {
    /**
    * The location name defined in Google Cloud.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#location DnsRecordSet#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas: string[];
}
export declare function dnsRecordSetRoutingPolicyGeoToTerraform(struct?: DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyGeoOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyGeo | cdktf.IResolvable | undefined);
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    get rrdatasInput(): string[] | undefined;
}
export declare class DnsRecordSetRoutingPolicyGeoList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyGeoOutputReference;
}
export interface DnsRecordSetRoutingPolicyWrr {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#rrdatas DnsRecordSet#rrdatas}
    */
    readonly rrdatas: string[];
    /**
    * The ratio of traffic routed to the target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#weight DnsRecordSet#weight}
    */
    readonly weight: number;
}
export declare function dnsRecordSetRoutingPolicyWrrToTerraform(struct?: DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable): any;
export declare class DnsRecordSetRoutingPolicyWrrOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicyWrr | cdktf.IResolvable | undefined);
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    get rrdatasInput(): string[] | undefined;
    private _weight?;
    get weight(): number;
    set weight(value: number);
    get weightInput(): number | undefined;
}
export declare class DnsRecordSetRoutingPolicyWrrList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): DnsRecordSetRoutingPolicyWrrOutputReference;
}
export interface DnsRecordSetRoutingPolicy {
    /**
    * geo block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#geo DnsRecordSet#geo}
    */
    readonly geo?: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable;
    /**
    * wrr block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/dns_record_set#wrr DnsRecordSet#wrr}
    */
    readonly wrr?: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable;
}
export declare function dnsRecordSetRoutingPolicyToTerraform(struct?: DnsRecordSetRoutingPolicyOutputReference | DnsRecordSetRoutingPolicy): any;
export declare class DnsRecordSetRoutingPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): DnsRecordSetRoutingPolicy | undefined;
    set internalValue(value: DnsRecordSetRoutingPolicy | undefined);
    private _geo;
    get geo(): DnsRecordSetRoutingPolicyGeoList;
    putGeo(value: DnsRecordSetRoutingPolicyGeo[] | cdktf.IResolvable): void;
    resetGeo(): void;
    get geoInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyGeo[] | undefined;
    private _wrr;
    get wrr(): DnsRecordSetRoutingPolicyWrrList;
    putWrr(value: DnsRecordSetRoutingPolicyWrr[] | cdktf.IResolvable): void;
    resetWrr(): void;
    get wrrInput(): cdktf.IResolvable | DnsRecordSetRoutingPolicyWrr[] | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/dns_record_set google_dns_record_set}
*/
export declare class DnsRecordSet extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_dns_record_set";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/dns_record_set google_dns_record_set} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DnsRecordSetConfig
    */
    constructor(scope: Construct, id: string, config: DnsRecordSetConfig);
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _managedZone?;
    get managedZone(): string;
    set managedZone(value: string);
    get managedZoneInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _rrdatas?;
    get rrdatas(): string[];
    set rrdatas(value: string[]);
    resetRrdatas(): void;
    get rrdatasInput(): string[] | undefined;
    private _ttl?;
    get ttl(): number;
    set ttl(value: number);
    resetTtl(): void;
    get ttlInput(): number | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _routingPolicy;
    get routingPolicy(): DnsRecordSetRoutingPolicyOutputReference;
    putRoutingPolicy(value: DnsRecordSetRoutingPolicy): void;
    resetRoutingPolicy(): void;
    get routingPolicyInput(): DnsRecordSetRoutingPolicy | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
