import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface IamWorkloadIdentityPoolProviderConfig extends cdktf.TerraformMetaArguments {
    /**
    * [A Common Expression Language](https://opensource.google/projects/cel) expression, in
  plain text, to restrict what otherwise valid authentication credentials issued by the
  provider should not be accepted.
  
  The expression must output a boolean representing whether to allow the federation.
  
  The following keywords may be referenced in the expressions:
    * 'assertion': JSON representing the authentication credential issued by the provider.
    * 'google': The Google attributes mapped from the assertion in the 'attribute_mappings'.
    * 'attribute': The custom attributes mapped from the assertion in the 'attribute_mappings'.
  
  The maximum length of the attribute condition expression is 4096 characters. If
  unspecified, all valid authentication credential are accepted.
  
  The following example shows how to only allow credentials with a mapped 'google.groups'
  value of 'admins':
  ```
  "'admins' in google.groups"
  ```
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#attribute_condition IamWorkloadIdentityPoolProvider#attribute_condition}
    */
    readonly attributeCondition?: string;
    /**
    * Maps attributes from authentication credentials issued by an external identity provider
  to Google Cloud attributes, such as 'subject' and 'segment'.
  
  Each key must be a string specifying the Google Cloud IAM attribute to map to.
  
  The following keys are supported:
    * 'google.subject': The principal IAM is authenticating. You can reference this value
      in IAM bindings. This is also the subject that appears in Cloud Logging logs.
      Cannot exceed 127 characters.
    * 'google.groups': Groups the external identity belongs to. You can grant groups
      access to resources using an IAM 'principalSet' binding; access applies to all
      members of the group.
  
  You can also provide custom attributes by specifying 'attribute.{custom_attribute}',
  where '{custom_attribute}' is the name of the custom attribute to be mapped. You can
  define a maximum of 50 custom attributes. The maximum length of a mapped attribute key
  is 100 characters, and the key may only contain the characters [a-z0-9_].
  
  You can reference these attributes in IAM policies to define fine-grained access for a
  workload to Google Cloud resources. For example:
    * 'google.subject':
      'principal://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/subject/{value}'
    * 'google.groups':
      'principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/group/{value}'
    * 'attribute.{custom_attribute}':
      'principalSet://iam.googleapis.com/projects/{project}/locations/{location}/workloadIdentityPools/{pool}/attribute.{custom_attribute}/{value}'
  
  Each value must be a [Common Expression Language](https://opensource.google/projects/cel)
  function that maps an identity provider credential to the normalized attribute specified
  by the corresponding map key.
  
  You can use the 'assertion' keyword in the expression to access a JSON representation of
  the authentication credential issued by the provider.
  
  The maximum length of an attribute mapping expression is 2048 characters. When evaluated,
  the total size of all mapped attributes must not exceed 8KB.
  
  For AWS providers, the following rules apply:
    - If no attribute mapping is defined, the following default mapping applies:
      ```
      {
        "google.subject":"assertion.arn",
        "attribute.aws_role":
          "assertion.arn.contains('assumed-role')"
          " ? assertion.arn.extract('{account_arn}assumed-role/')"
          "   + 'assumed-role/'"
          "   + assertion.arn.extract('assumed-role/{role_name}/')"
          " : assertion.arn",
      }
      ```
    - If any custom attribute mappings are defined, they must include a mapping to the
      'google.subject' attribute.
  
  For OIDC providers, the following rules apply:
    - Custom attribute mappings must be defined, and must include a mapping to the
      'google.subject' attribute. For example, the following maps the 'sub' claim of the
      incoming credential to the 'subject' attribute on a Google token.
      ```
      {"google.subject": "assertion.sub"}
      ```
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#attribute_mapping IamWorkloadIdentityPoolProvider#attribute_mapping}
    */
    readonly attributeMapping?: {
        [key: string]: string;
    };
    /**
    * A description for the provider. Cannot exceed 256 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#description IamWorkloadIdentityPoolProvider#description}
    */
    readonly description?: string;
    /**
    * Whether the provider is disabled. You cannot use a disabled provider to exchange tokens.
  However, existing tokens still grant access.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#disabled IamWorkloadIdentityPoolProvider#disabled}
    */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
    * A display name for the provider. Cannot exceed 32 characters.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#display_name IamWorkloadIdentityPoolProvider#display_name}
    */
    readonly displayName?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#id IamWorkloadIdentityPoolProvider#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#project IamWorkloadIdentityPoolProvider#project}
    */
    readonly project?: string;
    /**
    * The ID used for the pool, which is the final component of the pool resource name. This
  value should be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
  'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#workload_identity_pool_id IamWorkloadIdentityPoolProvider#workload_identity_pool_id}
    */
    readonly workloadIdentityPoolId: string;
    /**
    * The ID for the provider, which becomes the final component of the resource name. This
  value must be 4-32 characters, and may contain the characters [a-z0-9-]. The prefix
  'gcp-' is reserved for use by Google, and may not be specified.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#workload_identity_pool_provider_id IamWorkloadIdentityPoolProvider#workload_identity_pool_provider_id}
    */
    readonly workloadIdentityPoolProviderId: string;
    /**
    * aws block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#aws IamWorkloadIdentityPoolProvider#aws}
    */
    readonly aws?: IamWorkloadIdentityPoolProviderAws;
    /**
    * oidc block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#oidc IamWorkloadIdentityPoolProvider#oidc}
    */
    readonly oidc?: IamWorkloadIdentityPoolProviderOidc;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#timeouts IamWorkloadIdentityPoolProvider#timeouts}
    */
    readonly timeouts?: IamWorkloadIdentityPoolProviderTimeouts;
}
export interface IamWorkloadIdentityPoolProviderAws {
    /**
    * The AWS account ID.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#account_id IamWorkloadIdentityPoolProvider#account_id}
    */
    readonly accountId: string;
}
export declare function iamWorkloadIdentityPoolProviderAwsToTerraform(struct?: IamWorkloadIdentityPoolProviderAwsOutputReference | IamWorkloadIdentityPoolProviderAws): any;
export declare class IamWorkloadIdentityPoolProviderAwsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkloadIdentityPoolProviderAws | undefined;
    set internalValue(value: IamWorkloadIdentityPoolProviderAws | undefined);
    private _accountId?;
    get accountId(): string;
    set accountId(value: string);
    get accountIdInput(): string | undefined;
}
export interface IamWorkloadIdentityPoolProviderOidc {
    /**
    * Acceptable values for the 'aud' field (audience) in the OIDC token. Token exchange
  requests are rejected if the token audience does not match one of the configured
  values. Each audience may be at most 256 characters. A maximum of 10 audiences may
  be configured.
  
  If this list is empty, the OIDC token audience must be equal to the full canonical
  resource name of the WorkloadIdentityPoolProvider, with or without the HTTPS prefix.
  For example:
  ```
  //iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
  https://iam.googleapis.com/projects/<project-number>/locations/<location>/workloadIdentityPools/<pool-id>/providers/<provider-id>
  ```
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#allowed_audiences IamWorkloadIdentityPoolProvider#allowed_audiences}
    */
    readonly allowedAudiences?: string[];
    /**
    * The OIDC issuer URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#issuer_uri IamWorkloadIdentityPoolProvider#issuer_uri}
    */
    readonly issuerUri: string;
}
export declare function iamWorkloadIdentityPoolProviderOidcToTerraform(struct?: IamWorkloadIdentityPoolProviderOidcOutputReference | IamWorkloadIdentityPoolProviderOidc): any;
export declare class IamWorkloadIdentityPoolProviderOidcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkloadIdentityPoolProviderOidc | undefined;
    set internalValue(value: IamWorkloadIdentityPoolProviderOidc | undefined);
    private _allowedAudiences?;
    get allowedAudiences(): string[];
    set allowedAudiences(value: string[]);
    resetAllowedAudiences(): void;
    get allowedAudiencesInput(): string[] | undefined;
    private _issuerUri?;
    get issuerUri(): string;
    set issuerUri(value: string);
    get issuerUriInput(): string | undefined;
}
export interface IamWorkloadIdentityPoolProviderTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#create IamWorkloadIdentityPoolProvider#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#delete IamWorkloadIdentityPoolProvider#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider#update IamWorkloadIdentityPoolProvider#update}
    */
    readonly update?: string;
}
export declare function iamWorkloadIdentityPoolProviderTimeoutsToTerraform(struct?: IamWorkloadIdentityPoolProviderTimeoutsOutputReference | IamWorkloadIdentityPoolProviderTimeouts | cdktf.IResolvable): any;
export declare class IamWorkloadIdentityPoolProviderTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): IamWorkloadIdentityPoolProviderTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: IamWorkloadIdentityPoolProviderTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider google_iam_workload_identity_pool_provider}
*/
export declare class IamWorkloadIdentityPoolProvider extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_iam_workload_identity_pool_provider";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/iam_workload_identity_pool_provider google_iam_workload_identity_pool_provider} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options IamWorkloadIdentityPoolProviderConfig
    */
    constructor(scope: Construct, id: string, config: IamWorkloadIdentityPoolProviderConfig);
    private _attributeCondition?;
    get attributeCondition(): string;
    set attributeCondition(value: string);
    resetAttributeCondition(): void;
    get attributeConditionInput(): string | undefined;
    private _attributeMapping?;
    get attributeMapping(): {
        [key: string]: string;
    };
    set attributeMapping(value: {
        [key: string]: string;
    });
    resetAttributeMapping(): void;
    get attributeMappingInput(): {
        [key: string]: string;
    } | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _disabled?;
    get disabled(): boolean | cdktf.IResolvable;
    set disabled(value: boolean | cdktf.IResolvable);
    resetDisabled(): void;
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get name(): string;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _workloadIdentityPoolId?;
    get workloadIdentityPoolId(): string;
    set workloadIdentityPoolId(value: string);
    get workloadIdentityPoolIdInput(): string | undefined;
    private _workloadIdentityPoolProviderId?;
    get workloadIdentityPoolProviderId(): string;
    set workloadIdentityPoolProviderId(value: string);
    get workloadIdentityPoolProviderIdInput(): string | undefined;
    private _aws;
    get aws(): IamWorkloadIdentityPoolProviderAwsOutputReference;
    putAws(value: IamWorkloadIdentityPoolProviderAws): void;
    resetAws(): void;
    get awsInput(): IamWorkloadIdentityPoolProviderAws | undefined;
    private _oidc;
    get oidc(): IamWorkloadIdentityPoolProviderOidcOutputReference;
    putOidc(value: IamWorkloadIdentityPoolProviderOidc): void;
    resetOidc(): void;
    get oidcInput(): IamWorkloadIdentityPoolProviderOidc | undefined;
    private _timeouts;
    get timeouts(): IamWorkloadIdentityPoolProviderTimeoutsOutputReference;
    putTimeouts(value: IamWorkloadIdentityPoolProviderTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | IamWorkloadIdentityPoolProviderTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
