import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface KmsCryptoKeyConfig extends cdktf.TerraformMetaArguments {
    /**
    * The period of time that versions of this key spend in the DESTROY_SCHEDULED state before transitioning to DESTROYED.
  If not specified at creation time, the default duration is 24 hours.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#destroy_scheduled_duration KmsCryptoKey#destroy_scheduled_duration}
    */
    readonly destroyScheduledDuration?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#id KmsCryptoKey#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Whether this key may contain imported versions only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#import_only KmsCryptoKey#import_only}
    */
    readonly importOnly?: boolean | cdktf.IResolvable;
    /**
    * The KeyRing that this key belongs to.
  Format: ''projects/{{project}}/locations/{{location}}/keyRings/{{keyRing}}''.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#key_ring KmsCryptoKey#key_ring}
    */
    readonly keyRing: string;
    /**
    * Labels with user-defined metadata to apply to this resource.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#labels KmsCryptoKey#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The resource name for the CryptoKey.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#name KmsCryptoKey#name}
    */
    readonly name: string;
    /**
    * The immutable purpose of this CryptoKey. See the
  [purpose reference](https://cloud.google.com/kms/docs/reference/rest/v1/projects.locations.keyRings.cryptoKeys#CryptoKeyPurpose)
  for possible inputs. Default value: "ENCRYPT_DECRYPT" Possible values: ["ENCRYPT_DECRYPT", "ASYMMETRIC_SIGN", "ASYMMETRIC_DECRYPT", "MAC"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#purpose KmsCryptoKey#purpose}
    */
    readonly purpose?: string;
    /**
    * Every time this period passes, generate a new CryptoKeyVersion and set it as the primary.
  The first rotation will take place after the specified period. The rotation period has
  the format of a decimal number with up to 9 fractional digits, followed by the
  letter 's' (seconds). It must be greater than a day (ie, 86400).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#rotation_period KmsCryptoKey#rotation_period}
    */
    readonly rotationPeriod?: string;
    /**
    * If set to true, the request will create a CryptoKey without any CryptoKeyVersions.
  You must use the 'google_kms_key_ring_import_job' resource to import the CryptoKeyVersion.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#skip_initial_version_creation KmsCryptoKey#skip_initial_version_creation}
    */
    readonly skipInitialVersionCreation?: boolean | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#timeouts KmsCryptoKey#timeouts}
    */
    readonly timeouts?: KmsCryptoKeyTimeouts;
    /**
    * version_template block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#version_template KmsCryptoKey#version_template}
    */
    readonly versionTemplate?: KmsCryptoKeyVersionTemplate;
}
export interface KmsCryptoKeyTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#create KmsCryptoKey#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#delete KmsCryptoKey#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#update KmsCryptoKey#update}
    */
    readonly update?: string;
}
export declare function kmsCryptoKeyTimeoutsToTerraform(struct?: KmsCryptoKeyTimeoutsOutputReference | KmsCryptoKeyTimeouts | cdktf.IResolvable): any;
export declare class KmsCryptoKeyTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KmsCryptoKeyTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: KmsCryptoKeyTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface KmsCryptoKeyVersionTemplate {
    /**
    * The algorithm to use when creating a version based on this template.
  See the [algorithm reference](https://cloud.google.com/kms/docs/reference/rest/v1/CryptoKeyVersionAlgorithm) for possible inputs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#algorithm KmsCryptoKey#algorithm}
    */
    readonly algorithm: string;
    /**
    * The protection level to use when creating a version based on this template. Possible values include "SOFTWARE", "HSM", "EXTERNAL", "EXTERNAL_VPC". Defaults to "SOFTWARE".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key#protection_level KmsCryptoKey#protection_level}
    */
    readonly protectionLevel?: string;
}
export declare function kmsCryptoKeyVersionTemplateToTerraform(struct?: KmsCryptoKeyVersionTemplateOutputReference | KmsCryptoKeyVersionTemplate): any;
export declare class KmsCryptoKeyVersionTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): KmsCryptoKeyVersionTemplate | undefined;
    set internalValue(value: KmsCryptoKeyVersionTemplate | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    get algorithmInput(): string | undefined;
    private _protectionLevel?;
    get protectionLevel(): string;
    set protectionLevel(value: string);
    resetProtectionLevel(): void;
    get protectionLevelInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key google_kms_crypto_key}
*/
export declare class KmsCryptoKey extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_kms_crypto_key";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/kms_crypto_key google_kms_crypto_key} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options KmsCryptoKeyConfig
    */
    constructor(scope: Construct, id: string, config: KmsCryptoKeyConfig);
    private _destroyScheduledDuration?;
    get destroyScheduledDuration(): string;
    set destroyScheduledDuration(value: string);
    resetDestroyScheduledDuration(): void;
    get destroyScheduledDurationInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _importOnly?;
    get importOnly(): boolean | cdktf.IResolvable;
    set importOnly(value: boolean | cdktf.IResolvable);
    resetImportOnly(): void;
    get importOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyRing?;
    get keyRing(): string;
    set keyRing(value: string);
    get keyRingInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _purpose?;
    get purpose(): string;
    set purpose(value: string);
    resetPurpose(): void;
    get purposeInput(): string | undefined;
    private _rotationPeriod?;
    get rotationPeriod(): string;
    set rotationPeriod(value: string);
    resetRotationPeriod(): void;
    get rotationPeriodInput(): string | undefined;
    private _skipInitialVersionCreation?;
    get skipInitialVersionCreation(): boolean | cdktf.IResolvable;
    set skipInitialVersionCreation(value: boolean | cdktf.IResolvable);
    resetSkipInitialVersionCreation(): void;
    get skipInitialVersionCreationInput(): boolean | cdktf.IResolvable | undefined;
    private _timeouts;
    get timeouts(): KmsCryptoKeyTimeoutsOutputReference;
    putTimeouts(value: KmsCryptoKeyTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | KmsCryptoKeyTimeouts | undefined;
    private _versionTemplate;
    get versionTemplate(): KmsCryptoKeyVersionTemplateOutputReference;
    putVersionTemplate(value: KmsCryptoKeyVersionTemplate): void;
    resetVersionTemplate(): void;
    get versionTemplateInput(): KmsCryptoKeyVersionTemplate | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
