import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PrivatecaCertificateAuthorityConfig extends cdktf.TerraformMetaArguments {
    /**
    * The user provided Resource ID for this Certificate Authority.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#certificate_authority_id PrivatecaCertificateAuthority#certificate_authority_id}
    */
    readonly certificateAuthorityId: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#deletion_protection PrivatecaCertificateAuthority#deletion_protection}
    */
    readonly deletionProtection?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#desired_state PrivatecaCertificateAuthority#desired_state}
    */
    readonly desiredState?: string;
    /**
    * The name of a Cloud Storage bucket where this CertificateAuthority will publish content,
  such as the CA certificate and CRLs. This must be a bucket name, without any prefixes
  (such as 'gs://') or suffixes (such as '.googleapis.com'). For example, to use a bucket named
  my-bucket, you would simply specify 'my-bucket'. If not specified, a managed bucket will be
  created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#gcs_bucket PrivatecaCertificateAuthority#gcs_bucket}
    */
    readonly gcsBucket?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#id PrivatecaCertificateAuthority#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * This field allows the CA to be deleted even if the CA has active certs. Active certs include both unrevoked and unexpired certs.
  Use with care. Defaults to 'false'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ignore_active_certificates_on_deletion PrivatecaCertificateAuthority#ignore_active_certificates_on_deletion}
    */
    readonly ignoreActiveCertificatesOnDeletion?: boolean | cdktf.IResolvable;
    /**
    * Labels with user-defined metadata.
  
  An object containing a list of "key": value pairs. Example: { "name": "wrench", "mass":
  "1.3kg", "count": "3" }.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#labels PrivatecaCertificateAuthority#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The desired lifetime of the CA certificate. Used to create the "notBeforeTime" and
  "notAfterTime" fields inside an X.509 certificate. A duration in seconds with up to nine
  fractional digits, terminated by 's'. Example: "3.5s".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#lifetime PrivatecaCertificateAuthority#lifetime}
    */
    readonly lifetime?: string;
    /**
    * Location of the CertificateAuthority. A full list of valid locations can be found by
  running 'gcloud privateca locations list'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#location PrivatecaCertificateAuthority#location}
    */
    readonly location: string;
    /**
    * The signed CA certificate issued from the subordinated CA's CSR. This is needed when activating the subordiante CA with a third party issuer.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#pem_ca_certificate PrivatecaCertificateAuthority#pem_ca_certificate}
    */
    readonly pemCaCertificate?: string;
    /**
    * The name of the CaPool this Certificate Authority belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#pool PrivatecaCertificateAuthority#pool}
    */
    readonly pool: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#project PrivatecaCertificateAuthority#project}
    */
    readonly project?: string;
    /**
    * The Type of this CertificateAuthority.
  
  ~> **Note:** For 'SUBORDINATE' Certificate Authorities, they need to
  be activated before they can issue certificates. Default value: "SELF_SIGNED" Possible values: ["SELF_SIGNED", "SUBORDINATE"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#type PrivatecaCertificateAuthority#type}
    */
    readonly type?: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#config PrivatecaCertificateAuthority#config}
    */
    readonly config: PrivatecaCertificateAuthorityConfigA;
    /**
    * key_spec block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_spec PrivatecaCertificateAuthority#key_spec}
    */
    readonly keySpec: PrivatecaCertificateAuthorityKeySpec;
    /**
    * subordinate_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subordinate_config PrivatecaCertificateAuthority#subordinate_config}
    */
    readonly subordinateConfig?: PrivatecaCertificateAuthoritySubordinateConfig;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#timeouts PrivatecaCertificateAuthority#timeouts}
    */
    readonly timeouts?: PrivatecaCertificateAuthorityTimeouts;
}
export interface PrivatecaCertificateAuthorityAccessUrls {
}
export declare function privatecaCertificateAuthorityAccessUrlsToTerraform(struct?: PrivatecaCertificateAuthorityAccessUrls): any;
export declare class PrivatecaCertificateAuthorityAccessUrlsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCertificateAuthorityAccessUrls | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityAccessUrls | undefined);
    get caCertificateAccessUrl(): string;
    get crlAccessUrls(): string[];
}
export declare class PrivatecaCertificateAuthorityAccessUrlsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCertificateAuthorityAccessUrlsOutputReference;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubject {
    /**
    * The common name of the distinguished name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#common_name PrivatecaCertificateAuthority#common_name}
    */
    readonly commonName: string;
    /**
    * The country code of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#country_code PrivatecaCertificateAuthority#country_code}
    */
    readonly countryCode?: string;
    /**
    * The locality or city of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#locality PrivatecaCertificateAuthority#locality}
    */
    readonly locality?: string;
    /**
    * The organization of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#organization PrivatecaCertificateAuthority#organization}
    */
    readonly organization: string;
    /**
    * The organizational unit of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#organizational_unit PrivatecaCertificateAuthority#organizational_unit}
    */
    readonly organizationalUnit?: string;
    /**
    * The postal code of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#postal_code PrivatecaCertificateAuthority#postal_code}
    */
    readonly postalCode?: string;
    /**
    * The province, territory, or regional state of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#province PrivatecaCertificateAuthority#province}
    */
    readonly province?: string;
    /**
    * The street address of the subject.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#street_address PrivatecaCertificateAuthority#street_address}
    */
    readonly streetAddress?: string;
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigSubjectToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfigSubject): any;
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined);
    private _commonName?;
    get commonName(): string;
    set commonName(value: string);
    get commonNameInput(): string | undefined;
    private _countryCode?;
    get countryCode(): string;
    set countryCode(value: string);
    resetCountryCode(): void;
    get countryCodeInput(): string | undefined;
    private _locality?;
    get locality(): string;
    set locality(value: string);
    resetLocality(): void;
    get localityInput(): string | undefined;
    private _organization?;
    get organization(): string;
    set organization(value: string);
    get organizationInput(): string | undefined;
    private _organizationalUnit?;
    get organizationalUnit(): string;
    set organizationalUnit(value: string);
    resetOrganizationalUnit(): void;
    get organizationalUnitInput(): string | undefined;
    private _postalCode?;
    get postalCode(): string;
    set postalCode(value: string);
    resetPostalCode(): void;
    get postalCodeInput(): string | undefined;
    private _province?;
    get province(): string;
    set province(value: string);
    resetProvince(): void;
    get provinceInput(): string | undefined;
    private _streetAddress?;
    get streetAddress(): string;
    set streetAddress(value: string);
    resetStreetAddress(): void;
    get streetAddressInput(): string | undefined;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName {
    /**
    * Contains only valid, fully-qualified host names.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#dns_names PrivatecaCertificateAuthority#dns_names}
    */
    readonly dnsNames?: string[];
    /**
    * Contains only valid RFC 2822 E-mail addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#email_addresses PrivatecaCertificateAuthority#email_addresses}
    */
    readonly emailAddresses?: string[];
    /**
    * Contains only valid 32-bit IPv4 addresses or RFC 4291 IPv6 addresses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ip_addresses PrivatecaCertificateAuthority#ip_addresses}
    */
    readonly ipAddresses?: string[];
    /**
    * Contains only valid RFC 3986 URIs.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#uris PrivatecaCertificateAuthority#uris}
    */
    readonly uris?: string[];
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): any;
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined);
    private _dnsNames?;
    get dnsNames(): string[];
    set dnsNames(value: string[]);
    resetDnsNames(): void;
    get dnsNamesInput(): string[] | undefined;
    private _emailAddresses?;
    get emailAddresses(): string[];
    set emailAddresses(value: string[]);
    resetEmailAddresses(): void;
    get emailAddressesInput(): string[] | undefined;
    private _ipAddresses?;
    get ipAddresses(): string[];
    set ipAddresses(value: string[]);
    resetIpAddresses(): void;
    get ipAddressesInput(): string[] | undefined;
    private _uris?;
    get uris(): string[];
    set uris(value: string[]);
    resetUris(): void;
    get urisInput(): string[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigSubjectConfig {
    /**
    * subject block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject PrivatecaCertificateAuthority#subject}
    */
    readonly subject: PrivatecaCertificateAuthorityConfigSubjectConfigSubject;
    /**
    * subject_alt_name block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject_alt_name PrivatecaCertificateAuthority#subject_alt_name}
    */
    readonly subjectAltName?: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName;
}
export declare function privatecaCertificateAuthorityConfigSubjectConfigToTerraform(struct?: PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference | PrivatecaCertificateAuthorityConfigSubjectConfig): any;
export declare class PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigSubjectConfig | undefined);
    private _subject;
    get subject(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectOutputReference;
    putSubject(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubject): void;
    get subjectInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubject | undefined;
    private _subjectAltName;
    get subjectAltName(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltNameOutputReference;
    putSubjectAltName(value: PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName): void;
    resetSubjectAltName(): void;
    get subjectAltNameInput(): PrivatecaCertificateAuthorityConfigSubjectConfigSubjectAltName | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions {
    /**
    * Indicates whether or not this extension is critical (i.e., if the client does not know how to
  handle this extension, the client should consider this to be an error).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#critical PrivatecaCertificateAuthority#critical}
    */
    readonly critical: boolean | cdktf.IResolvable;
    /**
    * The value of this X.509 extension. A base64-encoded string.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#value PrivatecaCertificateAuthority#value}
    */
    readonly value: string;
    /**
    * object_id block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id PrivatecaCertificateAuthority#object_id}
    */
    readonly objectId: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions | cdktf.IResolvable | undefined);
    private _critical?;
    get critical(): boolean | cdktf.IResolvable;
    set critical(value: boolean | cdktf.IResolvable);
    get criticalInput(): boolean | cdktf.IResolvable | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    private _objectId;
    get objectId(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectIdOutputReference;
    putObjectId(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId): void;
    get objectIdInput(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsObjectId | undefined;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsOutputReference;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigCaOptions {
    /**
    * When true, the "CA" in Basic Constraints extension will be set to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#is_ca PrivatecaCertificateAuthority#is_ca}
    */
    readonly isCa: boolean | cdktf.IResolvable;
    /**
    * Refers to the "path length constraint" in Basic Constraints extension. For a CA certificate, this value describes the depth of
  subordinate CA certificates that are allowed. If this value is less than 0, the request will fail.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#max_issuer_path_length PrivatecaCertificateAuthority#max_issuer_path_length}
    */
    readonly maxIssuerPathLength?: number;
    /**
    * When true, the "CA" in Basic Constraints extension will be set to false.
  If both 'is_ca' and 'non_ca' are unset, the extension will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#non_ca PrivatecaCertificateAuthority#non_ca}
    */
    readonly nonCa?: boolean | cdktf.IResolvable;
    /**
    * When true, the "path length constraint" in Basic Constraints extension will be set to 0.
  if both 'max_issuer_path_length' and 'zero_max_issuer_path_length' are unset,
  the max path length will be omitted from the CA certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#zero_max_issuer_path_length PrivatecaCertificateAuthority#zero_max_issuer_path_length}
    */
    readonly zeroMaxIssuerPathLength?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigCaOptionsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigCaOptions): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined);
    private _isCa?;
    get isCa(): boolean | cdktf.IResolvable;
    set isCa(value: boolean | cdktf.IResolvable);
    get isCaInput(): boolean | cdktf.IResolvable | undefined;
    private _maxIssuerPathLength?;
    get maxIssuerPathLength(): number;
    set maxIssuerPathLength(value: number);
    resetMaxIssuerPathLength(): void;
    get maxIssuerPathLengthInput(): number | undefined;
    private _nonCa?;
    get nonCa(): boolean | cdktf.IResolvable;
    set nonCa(value: boolean | cdktf.IResolvable);
    resetNonCa(): void;
    get nonCaInput(): boolean | cdktf.IResolvable | undefined;
    private _zeroMaxIssuerPathLength?;
    get zeroMaxIssuerPathLength(): boolean | cdktf.IResolvable;
    set zeroMaxIssuerPathLength(value: boolean | cdktf.IResolvable);
    resetZeroMaxIssuerPathLength(): void;
    get zeroMaxIssuerPathLengthInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage {
    /**
    * The key may be used to sign certificates.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#cert_sign PrivatecaCertificateAuthority#cert_sign}
    */
    readonly certSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for cryptographic commitments. Note that this may also be referred to as "non-repudiation".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#content_commitment PrivatecaCertificateAuthority#content_commitment}
    */
    readonly contentCommitment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used sign certificate revocation lists.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#crl_sign PrivatecaCertificateAuthority#crl_sign}
    */
    readonly crlSign?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher data.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#data_encipherment PrivatecaCertificateAuthority#data_encipherment}
    */
    readonly dataEncipherment?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to decipher only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#decipher_only PrivatecaCertificateAuthority#decipher_only}
    */
    readonly decipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used for digital signatures.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#digital_signature PrivatecaCertificateAuthority#digital_signature}
    */
    readonly digitalSignature?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher only.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#encipher_only PrivatecaCertificateAuthority#encipher_only}
    */
    readonly encipherOnly?: boolean | cdktf.IResolvable;
    /**
    * The key may be used in a key agreement protocol.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_agreement PrivatecaCertificateAuthority#key_agreement}
    */
    readonly keyAgreement?: boolean | cdktf.IResolvable;
    /**
    * The key may be used to encipher other keys.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_encipherment PrivatecaCertificateAuthority#key_encipherment}
    */
    readonly keyEncipherment?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined);
    private _certSign?;
    get certSign(): boolean | cdktf.IResolvable;
    set certSign(value: boolean | cdktf.IResolvable);
    resetCertSign(): void;
    get certSignInput(): boolean | cdktf.IResolvable | undefined;
    private _contentCommitment?;
    get contentCommitment(): boolean | cdktf.IResolvable;
    set contentCommitment(value: boolean | cdktf.IResolvable);
    resetContentCommitment(): void;
    get contentCommitmentInput(): boolean | cdktf.IResolvable | undefined;
    private _crlSign?;
    get crlSign(): boolean | cdktf.IResolvable;
    set crlSign(value: boolean | cdktf.IResolvable);
    resetCrlSign(): void;
    get crlSignInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEncipherment?;
    get dataEncipherment(): boolean | cdktf.IResolvable;
    set dataEncipherment(value: boolean | cdktf.IResolvable);
    resetDataEncipherment(): void;
    get dataEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
    private _decipherOnly?;
    get decipherOnly(): boolean | cdktf.IResolvable;
    set decipherOnly(value: boolean | cdktf.IResolvable);
    resetDecipherOnly(): void;
    get decipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _digitalSignature?;
    get digitalSignature(): boolean | cdktf.IResolvable;
    set digitalSignature(value: boolean | cdktf.IResolvable);
    resetDigitalSignature(): void;
    get digitalSignatureInput(): boolean | cdktf.IResolvable | undefined;
    private _encipherOnly?;
    get encipherOnly(): boolean | cdktf.IResolvable;
    set encipherOnly(value: boolean | cdktf.IResolvable);
    resetEncipherOnly(): void;
    get encipherOnlyInput(): boolean | cdktf.IResolvable | undefined;
    private _keyAgreement?;
    get keyAgreement(): boolean | cdktf.IResolvable;
    set keyAgreement(value: boolean | cdktf.IResolvable);
    resetKeyAgreement(): void;
    get keyAgreementInput(): boolean | cdktf.IResolvable | undefined;
    private _keyEncipherment?;
    get keyEncipherment(): boolean | cdktf.IResolvable;
    set keyEncipherment(value: boolean | cdktf.IResolvable);
    resetKeyEncipherment(): void;
    get keyEnciphermentInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage {
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.2. Officially described as "TLS WWW client authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#client_auth PrivatecaCertificateAuthority#client_auth}
    */
    readonly clientAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.3. Officially described as "Signing of downloadable executable code client authentication".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#code_signing PrivatecaCertificateAuthority#code_signing}
    */
    readonly codeSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.4. Officially described as "Email protection".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#email_protection PrivatecaCertificateAuthority#email_protection}
    */
    readonly emailProtection?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.9. Officially described as "Signing OCSP responses".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ocsp_signing PrivatecaCertificateAuthority#ocsp_signing}
    */
    readonly ocspSigning?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.1. Officially described as "TLS WWW server authentication", though regularly used for non-WWW TLS.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#server_auth PrivatecaCertificateAuthority#server_auth}
    */
    readonly serverAuth?: boolean | cdktf.IResolvable;
    /**
    * Corresponds to OID 1.3.6.1.5.5.7.3.8. Officially described as "Binding the hash of an object to a time".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#time_stamping PrivatecaCertificateAuthority#time_stamping}
    */
    readonly timeStamping?: boolean | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined);
    private _clientAuth?;
    get clientAuth(): boolean | cdktf.IResolvable;
    set clientAuth(value: boolean | cdktf.IResolvable);
    resetClientAuth(): void;
    get clientAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _codeSigning?;
    get codeSigning(): boolean | cdktf.IResolvable;
    set codeSigning(value: boolean | cdktf.IResolvable);
    resetCodeSigning(): void;
    get codeSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _emailProtection?;
    get emailProtection(): boolean | cdktf.IResolvable;
    set emailProtection(value: boolean | cdktf.IResolvable);
    resetEmailProtection(): void;
    get emailProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _ocspSigning?;
    get ocspSigning(): boolean | cdktf.IResolvable;
    set ocspSigning(value: boolean | cdktf.IResolvable);
    resetOcspSigning(): void;
    get ocspSigningInput(): boolean | cdktf.IResolvable | undefined;
    private _serverAuth?;
    get serverAuth(): boolean | cdktf.IResolvable;
    set serverAuth(value: boolean | cdktf.IResolvable);
    resetServerAuth(): void;
    get serverAuthInput(): boolean | cdktf.IResolvable | undefined;
    private _timeStamping?;
    get timeStamping(): boolean | cdktf.IResolvable;
    set timeStamping(value: boolean | cdktf.IResolvable);
    resetTimeStamping(): void;
    get timeStampingInput(): boolean | cdktf.IResolvable | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesOutputReference;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage {
    /**
    * base_key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#base_key_usage PrivatecaCertificateAuthority#base_key_usage}
    */
    readonly baseKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage;
    /**
    * extended_key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#extended_key_usage PrivatecaCertificateAuthority#extended_key_usage}
    */
    readonly extendedKeyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage;
    /**
    * unknown_extended_key_usages block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#unknown_extended_key_usages PrivatecaCertificateAuthority#unknown_extended_key_usages}
    */
    readonly unknownExtendedKeyUsages?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigKeyUsageToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined);
    private _baseKeyUsage;
    get baseKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsageOutputReference;
    putBaseKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage): void;
    get baseKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageBaseKeyUsage | undefined;
    private _extendedKeyUsage;
    get extendedKeyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsageOutputReference;
    putExtendedKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage): void;
    get extendedKeyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageExtendedKeyUsage | undefined;
    private _unknownExtendedKeyUsages;
    get unknownExtendedKeyUsages(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsagesList;
    putUnknownExtendedKeyUsages(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | cdktf.IResolvable): void;
    resetUnknownExtendedKeyUsages(): void;
    get unknownExtendedKeyUsagesInput(): cdktf.IResolvable | PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageUnknownExtendedKeyUsages[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds {
    /**
    * An ObjectId specifies an object identifier (OID). These provide context and describe types in ASN.1 messages.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#object_id_path PrivatecaCertificateAuthority#object_id_path}
    */
    readonly objectIdPath: number[];
}
export declare function privatecaCertificateAuthorityConfigX509ConfigPolicyIdsToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds | cdktf.IResolvable | undefined);
    private _objectIdPath?;
    get objectIdPath(): number[];
    set objectIdPath(value: number[]);
    get objectIdPathInput(): number[] | undefined;
}
export declare class PrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsOutputReference;
}
export interface PrivatecaCertificateAuthorityConfigX509Config {
    /**
    * Describes Online Certificate Status Protocol (OCSP) endpoint addresses that appear in the
  "Authority Information Access" extension in the certificate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#aia_ocsp_servers PrivatecaCertificateAuthority#aia_ocsp_servers}
    */
    readonly aiaOcspServers?: string[];
    /**
    * additional_extensions block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#additional_extensions PrivatecaCertificateAuthority#additional_extensions}
    */
    readonly additionalExtensions?: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable;
    /**
    * ca_options block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#ca_options PrivatecaCertificateAuthority#ca_options}
    */
    readonly caOptions: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions;
    /**
    * key_usage block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#key_usage PrivatecaCertificateAuthority#key_usage}
    */
    readonly keyUsage: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage;
    /**
    * policy_ids block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#policy_ids PrivatecaCertificateAuthority#policy_ids}
    */
    readonly policyIds?: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable;
}
export declare function privatecaCertificateAuthorityConfigX509ConfigToTerraform(struct?: PrivatecaCertificateAuthorityConfigX509ConfigOutputReference | PrivatecaCertificateAuthorityConfigX509Config): any;
export declare class PrivatecaCertificateAuthorityConfigX509ConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigX509Config | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigX509Config | undefined);
    private _aiaOcspServers?;
    get aiaOcspServers(): string[];
    set aiaOcspServers(value: string[]);
    resetAiaOcspServers(): void;
    get aiaOcspServersInput(): string[] | undefined;
    private _additionalExtensions;
    get additionalExtensions(): PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensionsList;
    putAdditionalExtensions(value: PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | cdktf.IResolvable): void;
    resetAdditionalExtensions(): void;
    get additionalExtensionsInput(): cdktf.IResolvable | PrivatecaCertificateAuthorityConfigX509ConfigAdditionalExtensions[] | undefined;
    private _caOptions;
    get caOptions(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptionsOutputReference;
    putCaOptions(value: PrivatecaCertificateAuthorityConfigX509ConfigCaOptions): void;
    get caOptionsInput(): PrivatecaCertificateAuthorityConfigX509ConfigCaOptions | undefined;
    private _keyUsage;
    get keyUsage(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsageOutputReference;
    putKeyUsage(value: PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage): void;
    get keyUsageInput(): PrivatecaCertificateAuthorityConfigX509ConfigKeyUsage | undefined;
    private _policyIds;
    get policyIds(): PrivatecaCertificateAuthorityConfigX509ConfigPolicyIdsList;
    putPolicyIds(value: PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | cdktf.IResolvable): void;
    resetPolicyIds(): void;
    get policyIdsInput(): cdktf.IResolvable | PrivatecaCertificateAuthorityConfigX509ConfigPolicyIds[] | undefined;
}
export interface PrivatecaCertificateAuthorityConfigA {
    /**
    * subject_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#subject_config PrivatecaCertificateAuthority#subject_config}
    */
    readonly subjectConfig: PrivatecaCertificateAuthorityConfigSubjectConfig;
    /**
    * x509_config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#x509_config PrivatecaCertificateAuthority#x509_config}
    */
    readonly x509Config: PrivatecaCertificateAuthorityConfigX509Config;
}
export declare function privatecaCertificateAuthorityConfigAToTerraform(struct?: PrivatecaCertificateAuthorityConfigAOutputReference | PrivatecaCertificateAuthorityConfigA): any;
export declare class PrivatecaCertificateAuthorityConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityConfigA | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityConfigA | undefined);
    private _subjectConfig;
    get subjectConfig(): PrivatecaCertificateAuthorityConfigSubjectConfigOutputReference;
    putSubjectConfig(value: PrivatecaCertificateAuthorityConfigSubjectConfig): void;
    get subjectConfigInput(): PrivatecaCertificateAuthorityConfigSubjectConfig | undefined;
    private _x509Config;
    get x509Config(): PrivatecaCertificateAuthorityConfigX509ConfigOutputReference;
    putX509Config(value: PrivatecaCertificateAuthorityConfigX509Config): void;
    get x509ConfigInput(): PrivatecaCertificateAuthorityConfigX509Config | undefined;
}
export interface PrivatecaCertificateAuthorityKeySpec {
    /**
    * The algorithm to use for creating a managed Cloud KMS key for a for a simplified
  experience. All managed keys will be have their ProtectionLevel as HSM. Possible values: ["SIGN_HASH_ALGORITHM_UNSPECIFIED", "RSA_PSS_2048_SHA256", "RSA_PSS_3072_SHA256", "RSA_PSS_4096_SHA256", "RSA_PKCS1_2048_SHA256", "RSA_PKCS1_3072_SHA256", "RSA_PKCS1_4096_SHA256", "EC_P256_SHA256", "EC_P384_SHA384"]
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#algorithm PrivatecaCertificateAuthority#algorithm}
    */
    readonly algorithm?: string;
    /**
    * The resource name for an existing Cloud KMS CryptoKeyVersion in the format
  'projects/*\/locations/*\/keyRings/*\/cryptoKeys/*\/cryptoKeyVersions/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#cloud_kms_key_version PrivatecaCertificateAuthority#cloud_kms_key_version}
    */
    readonly cloudKmsKeyVersion?: string;
}
export declare function privatecaCertificateAuthorityKeySpecToTerraform(struct?: PrivatecaCertificateAuthorityKeySpecOutputReference | PrivatecaCertificateAuthorityKeySpec): any;
export declare class PrivatecaCertificateAuthorityKeySpecOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityKeySpec | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityKeySpec | undefined);
    private _algorithm?;
    get algorithm(): string;
    set algorithm(value: string);
    resetAlgorithm(): void;
    get algorithmInput(): string | undefined;
    private _cloudKmsKeyVersion?;
    get cloudKmsKeyVersion(): string;
    set cloudKmsKeyVersion(value: string);
    resetCloudKmsKeyVersion(): void;
    get cloudKmsKeyVersionInput(): string | undefined;
}
export interface PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain {
    /**
    * Expected to be in leaf-to-root order according to RFC 5246.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#pem_certificates PrivatecaCertificateAuthority#pem_certificates}
    */
    readonly pemCertificates?: string[];
}
export declare function privatecaCertificateAuthoritySubordinateConfigPemIssuerChainToTerraform(struct?: PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference | PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain): any;
export declare class PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined;
    set internalValue(value: PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined);
    private _pemCertificates?;
    get pemCertificates(): string[];
    set pemCertificates(value: string[]);
    resetPemCertificates(): void;
    get pemCertificatesInput(): string[] | undefined;
}
export interface PrivatecaCertificateAuthoritySubordinateConfig {
    /**
    * This can refer to a CertificateAuthority that was used to create a
  subordinate CertificateAuthority. This field is used for information
  and usability purposes only. The resource name is in the format
  'projects/*\/locations/*\/caPools/*\/certificateAuthorities/*'.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#certificate_authority PrivatecaCertificateAuthority#certificate_authority}
    */
    readonly certificateAuthority?: string;
    /**
    * pem_issuer_chain block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#pem_issuer_chain PrivatecaCertificateAuthority#pem_issuer_chain}
    */
    readonly pemIssuerChain?: PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain;
}
export declare function privatecaCertificateAuthoritySubordinateConfigToTerraform(struct?: PrivatecaCertificateAuthoritySubordinateConfigOutputReference | PrivatecaCertificateAuthoritySubordinateConfig): any;
export declare class PrivatecaCertificateAuthoritySubordinateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthoritySubordinateConfig | undefined;
    set internalValue(value: PrivatecaCertificateAuthoritySubordinateConfig | undefined);
    private _certificateAuthority?;
    get certificateAuthority(): string;
    set certificateAuthority(value: string);
    resetCertificateAuthority(): void;
    get certificateAuthorityInput(): string | undefined;
    private _pemIssuerChain;
    get pemIssuerChain(): PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChainOutputReference;
    putPemIssuerChain(value: PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain): void;
    resetPemIssuerChain(): void;
    get pemIssuerChainInput(): PrivatecaCertificateAuthoritySubordinateConfigPemIssuerChain | undefined;
}
export interface PrivatecaCertificateAuthorityTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#create PrivatecaCertificateAuthority#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#delete PrivatecaCertificateAuthority#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority#update PrivatecaCertificateAuthority#update}
    */
    readonly update?: string;
}
export declare function privatecaCertificateAuthorityTimeoutsToTerraform(struct?: PrivatecaCertificateAuthorityTimeoutsOutputReference | PrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable): any;
export declare class PrivatecaCertificateAuthorityTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): PrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: PrivatecaCertificateAuthorityTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority google_privateca_certificate_authority}
*/
export declare class PrivatecaCertificateAuthority extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_privateca_certificate_authority";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/privateca_certificate_authority google_privateca_certificate_authority} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PrivatecaCertificateAuthorityConfig
    */
    constructor(scope: Construct, id: string, config: PrivatecaCertificateAuthorityConfig);
    private _accessUrls;
    get accessUrls(): PrivatecaCertificateAuthorityAccessUrlsList;
    private _certificateAuthorityId?;
    get certificateAuthorityId(): string;
    set certificateAuthorityId(value: string);
    get certificateAuthorityIdInput(): string | undefined;
    get createTime(): string;
    private _deletionProtection?;
    get deletionProtection(): boolean | cdktf.IResolvable;
    set deletionProtection(value: boolean | cdktf.IResolvable);
    resetDeletionProtection(): void;
    get deletionProtectionInput(): boolean | cdktf.IResolvable | undefined;
    private _desiredState?;
    get desiredState(): string;
    set desiredState(value: string);
    resetDesiredState(): void;
    get desiredStateInput(): string | undefined;
    private _gcsBucket?;
    get gcsBucket(): string;
    set gcsBucket(value: string);
    resetGcsBucket(): void;
    get gcsBucketInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _ignoreActiveCertificatesOnDeletion?;
    get ignoreActiveCertificatesOnDeletion(): boolean | cdktf.IResolvable;
    set ignoreActiveCertificatesOnDeletion(value: boolean | cdktf.IResolvable);
    resetIgnoreActiveCertificatesOnDeletion(): void;
    get ignoreActiveCertificatesOnDeletionInput(): boolean | cdktf.IResolvable | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _lifetime?;
    get lifetime(): string;
    set lifetime(value: string);
    resetLifetime(): void;
    get lifetimeInput(): string | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    get name(): string;
    private _pemCaCertificate?;
    get pemCaCertificate(): string;
    set pemCaCertificate(value: string);
    resetPemCaCertificate(): void;
    get pemCaCertificateInput(): string | undefined;
    get pemCaCertificates(): string[];
    private _pool?;
    get pool(): string;
    set pool(value: string);
    get poolInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    get state(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    resetType(): void;
    get typeInput(): string | undefined;
    get updateTime(): string;
    private _config;
    get config(): PrivatecaCertificateAuthorityConfigAOutputReference;
    putConfig(value: PrivatecaCertificateAuthorityConfigA): void;
    get configInput(): PrivatecaCertificateAuthorityConfigA | undefined;
    private _keySpec;
    get keySpec(): PrivatecaCertificateAuthorityKeySpecOutputReference;
    putKeySpec(value: PrivatecaCertificateAuthorityKeySpec): void;
    get keySpecInput(): PrivatecaCertificateAuthorityKeySpec | undefined;
    private _subordinateConfig;
    get subordinateConfig(): PrivatecaCertificateAuthoritySubordinateConfigOutputReference;
    putSubordinateConfig(value: PrivatecaCertificateAuthoritySubordinateConfig): void;
    resetSubordinateConfig(): void;
    get subordinateConfigInput(): PrivatecaCertificateAuthoritySubordinateConfig | undefined;
    private _timeouts;
    get timeouts(): PrivatecaCertificateAuthorityTimeoutsOutputReference;
    putTimeouts(value: PrivatecaCertificateAuthorityTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | PrivatecaCertificateAuthorityTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
