import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface StorageBucketConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not to automatically apply an eventBasedHold to new objects added to the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#default_event_based_hold StorageBucket#default_event_based_hold}
    */
    readonly defaultEventBasedHold?: boolean | cdktf.IResolvable;
    /**
    * When deleting a bucket, this boolean option will delete all contained objects. If you try to delete a bucket that contains objects, Terraform will fail that run.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#force_destroy StorageBucket#force_destroy}
    */
    readonly forceDestroy?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#id StorageBucket#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * A set of key/value label pairs to assign to the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#labels StorageBucket#labels}
    */
    readonly labels?: {
        [key: string]: string;
    };
    /**
    * The Google Cloud Storage location
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#location StorageBucket#location}
    */
    readonly location: string;
    /**
    * The name of the bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#name StorageBucket#name}
    */
    readonly name: string;
    /**
    * The ID of the project in which the resource belongs. If it is not provided, the provider project is used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#project StorageBucket#project}
    */
    readonly project?: string;
    /**
    * Enables Requester Pays on a storage bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#requester_pays StorageBucket#requester_pays}
    */
    readonly requesterPays?: boolean | cdktf.IResolvable;
    /**
    * The Storage Class of the new bucket. Supported values include: STANDARD, MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#storage_class StorageBucket#storage_class}
    */
    readonly storageClass?: string;
    /**
    * Enables uniform bucket-level access on a bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#uniform_bucket_level_access StorageBucket#uniform_bucket_level_access}
    */
    readonly uniformBucketLevelAccess?: boolean | cdktf.IResolvable;
    /**
    * cors block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#cors StorageBucket#cors}
    */
    readonly cors?: StorageBucketCors[] | cdktf.IResolvable;
    /**
    * encryption block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#encryption StorageBucket#encryption}
    */
    readonly encryption?: StorageBucketEncryption;
    /**
    * lifecycle_rule block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#lifecycle_rule StorageBucket#lifecycle_rule}
    */
    readonly lifecycleRule?: StorageBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * logging block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#logging StorageBucket#logging}
    */
    readonly logging?: StorageBucketLogging;
    /**
    * retention_policy block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#retention_policy StorageBucket#retention_policy}
    */
    readonly retentionPolicy?: StorageBucketRetentionPolicy;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#timeouts StorageBucket#timeouts}
    */
    readonly timeouts?: StorageBucketTimeouts;
    /**
    * versioning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#versioning StorageBucket#versioning}
    */
    readonly versioning?: StorageBucketVersioning;
    /**
    * website block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#website StorageBucket#website}
    */
    readonly website?: StorageBucketWebsite;
}
export interface StorageBucketCors {
    /**
    * The value, in seconds, to return in the Access-Control-Max-Age header used in preflight responses.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#max_age_seconds StorageBucket#max_age_seconds}
    */
    readonly maxAgeSeconds?: number;
    /**
    * The list of HTTP methods on which to include CORS response headers, (GET, OPTIONS, POST, etc) Note: "*" is permitted in the list of methods, and means "any method".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#method StorageBucket#method}
    */
    readonly method?: string[];
    /**
    * The list of Origins eligible to receive CORS response headers. Note: "*" is permitted in the list of origins, and means "any Origin".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#origin StorageBucket#origin}
    */
    readonly origin?: string[];
    /**
    * The list of HTTP headers other than the simple response headers to give permission for the user-agent to share across domains.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#response_header StorageBucket#response_header}
    */
    readonly responseHeader?: string[];
}
export declare function storageBucketCorsToTerraform(struct?: StorageBucketCors | cdktf.IResolvable): any;
export declare class StorageBucketCorsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageBucketCors | cdktf.IResolvable | undefined;
    set internalValue(value: StorageBucketCors | cdktf.IResolvable | undefined);
    private _maxAgeSeconds?;
    get maxAgeSeconds(): number;
    set maxAgeSeconds(value: number);
    resetMaxAgeSeconds(): void;
    get maxAgeSecondsInput(): number | undefined;
    private _method?;
    get method(): string[];
    set method(value: string[]);
    resetMethod(): void;
    get methodInput(): string[] | undefined;
    private _origin?;
    get origin(): string[];
    set origin(value: string[]);
    resetOrigin(): void;
    get originInput(): string[] | undefined;
    private _responseHeader?;
    get responseHeader(): string[];
    set responseHeader(value: string[]);
    resetResponseHeader(): void;
    get responseHeaderInput(): string[] | undefined;
}
export declare class StorageBucketCorsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageBucketCors[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageBucketCorsOutputReference;
}
export interface StorageBucketEncryption {
    /**
    * A Cloud KMS key that will be used to encrypt objects inserted into this bucket, if no encryption method is specified. You must pay attention to whether the crypto key is available in the location that this bucket is created in. See the docs for more details.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#default_kms_key_name StorageBucket#default_kms_key_name}
    */
    readonly defaultKmsKeyName: string;
}
export declare function storageBucketEncryptionToTerraform(struct?: StorageBucketEncryptionOutputReference | StorageBucketEncryption): any;
export declare class StorageBucketEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketEncryption | undefined;
    set internalValue(value: StorageBucketEncryption | undefined);
    private _defaultKmsKeyName?;
    get defaultKmsKeyName(): string;
    set defaultKmsKeyName(value: string);
    get defaultKmsKeyNameInput(): string | undefined;
}
export interface StorageBucketLifecycleRuleAction {
    /**
    * The target Storage Class of objects affected by this Lifecycle Rule. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#storage_class StorageBucket#storage_class}
    */
    readonly storageClass?: string;
    /**
    * The type of the action of this Lifecycle Rule. Supported values include: Delete and SetStorageClass.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#type StorageBucket#type}
    */
    readonly type: string;
}
export declare function storageBucketLifecycleRuleActionToTerraform(struct?: StorageBucketLifecycleRuleActionOutputReference | StorageBucketLifecycleRuleAction): any;
export declare class StorageBucketLifecycleRuleActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketLifecycleRuleAction | undefined;
    set internalValue(value: StorageBucketLifecycleRuleAction | undefined);
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface StorageBucketLifecycleRuleCondition {
    /**
    * Minimum age of an object in days to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#age StorageBucket#age}
    */
    readonly age?: number;
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#created_before StorageBucket#created_before}
    */
    readonly createdBefore?: string;
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#custom_time_before StorageBucket#custom_time_before}
    */
    readonly customTimeBefore?: string;
    /**
    * Number of days elapsed since the user-specified timestamp set on an object.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#days_since_custom_time StorageBucket#days_since_custom_time}
    */
    readonly daysSinceCustomTime?: number;
    /**
    * Number of days elapsed since the noncurrent timestamp of an object. This
                                          condition is relevant only for versioned objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#days_since_noncurrent_time StorageBucket#days_since_noncurrent_time}
    */
    readonly daysSinceNoncurrentTime?: number;
    /**
    * One or more matching name prefixes to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#matches_prefix StorageBucket#matches_prefix}
    */
    readonly matchesPrefix?: string[];
    /**
    * Storage Class of objects to satisfy this condition. Supported values include: MULTI_REGIONAL, REGIONAL, NEARLINE, COLDLINE, ARCHIVE, STANDARD, DURABLE_REDUCED_AVAILABILITY.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#matches_storage_class StorageBucket#matches_storage_class}
    */
    readonly matchesStorageClass?: string[];
    /**
    * One or more matching name suffixes to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#matches_suffix StorageBucket#matches_suffix}
    */
    readonly matchesSuffix?: string[];
    /**
    * Creation date of an object in RFC 3339 (e.g. 2017-06-13) to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#noncurrent_time_before StorageBucket#noncurrent_time_before}
    */
    readonly noncurrentTimeBefore?: string;
    /**
    * Relevant only for versioned objects. The number of newer versions of an object to satisfy this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#num_newer_versions StorageBucket#num_newer_versions}
    */
    readonly numNewerVersions?: number;
    /**
    * Match to live and/or archived objects. Unversioned buckets have only live objects. Supported values include: "LIVE", "ARCHIVED", "ANY".
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#with_state StorageBucket#with_state}
    */
    readonly withState?: string;
}
export declare function storageBucketLifecycleRuleConditionToTerraform(struct?: StorageBucketLifecycleRuleConditionOutputReference | StorageBucketLifecycleRuleCondition): any;
export declare class StorageBucketLifecycleRuleConditionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketLifecycleRuleCondition | undefined;
    set internalValue(value: StorageBucketLifecycleRuleCondition | undefined);
    private _age?;
    get age(): number;
    set age(value: number);
    resetAge(): void;
    get ageInput(): number | undefined;
    private _createdBefore?;
    get createdBefore(): string;
    set createdBefore(value: string);
    resetCreatedBefore(): void;
    get createdBeforeInput(): string | undefined;
    private _customTimeBefore?;
    get customTimeBefore(): string;
    set customTimeBefore(value: string);
    resetCustomTimeBefore(): void;
    get customTimeBeforeInput(): string | undefined;
    private _daysSinceCustomTime?;
    get daysSinceCustomTime(): number;
    set daysSinceCustomTime(value: number);
    resetDaysSinceCustomTime(): void;
    get daysSinceCustomTimeInput(): number | undefined;
    private _daysSinceNoncurrentTime?;
    get daysSinceNoncurrentTime(): number;
    set daysSinceNoncurrentTime(value: number);
    resetDaysSinceNoncurrentTime(): void;
    get daysSinceNoncurrentTimeInput(): number | undefined;
    private _matchesPrefix?;
    get matchesPrefix(): string[];
    set matchesPrefix(value: string[]);
    resetMatchesPrefix(): void;
    get matchesPrefixInput(): string[] | undefined;
    private _matchesStorageClass?;
    get matchesStorageClass(): string[];
    set matchesStorageClass(value: string[]);
    resetMatchesStorageClass(): void;
    get matchesStorageClassInput(): string[] | undefined;
    private _matchesSuffix?;
    get matchesSuffix(): string[];
    set matchesSuffix(value: string[]);
    resetMatchesSuffix(): void;
    get matchesSuffixInput(): string[] | undefined;
    private _noncurrentTimeBefore?;
    get noncurrentTimeBefore(): string;
    set noncurrentTimeBefore(value: string);
    resetNoncurrentTimeBefore(): void;
    get noncurrentTimeBeforeInput(): string | undefined;
    private _numNewerVersions?;
    get numNewerVersions(): number;
    set numNewerVersions(value: number);
    resetNumNewerVersions(): void;
    get numNewerVersionsInput(): number | undefined;
    private _withState?;
    get withState(): string;
    set withState(value: string);
    resetWithState(): void;
    get withStateInput(): string | undefined;
}
export interface StorageBucketLifecycleRule {
    /**
    * action block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#action StorageBucket#action}
    */
    readonly action: StorageBucketLifecycleRuleAction;
    /**
    * condition block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#condition StorageBucket#condition}
    */
    readonly condition: StorageBucketLifecycleRuleCondition;
}
export declare function storageBucketLifecycleRuleToTerraform(struct?: StorageBucketLifecycleRule | cdktf.IResolvable): any;
export declare class StorageBucketLifecycleRuleOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): StorageBucketLifecycleRule | cdktf.IResolvable | undefined;
    set internalValue(value: StorageBucketLifecycleRule | cdktf.IResolvable | undefined);
    private _action;
    get action(): StorageBucketLifecycleRuleActionOutputReference;
    putAction(value: StorageBucketLifecycleRuleAction): void;
    get actionInput(): StorageBucketLifecycleRuleAction | undefined;
    private _condition;
    get condition(): StorageBucketLifecycleRuleConditionOutputReference;
    putCondition(value: StorageBucketLifecycleRuleCondition): void;
    get conditionInput(): StorageBucketLifecycleRuleCondition | undefined;
}
export declare class StorageBucketLifecycleRuleList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: StorageBucketLifecycleRule[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): StorageBucketLifecycleRuleOutputReference;
}
export interface StorageBucketLogging {
    /**
    * The bucket that will receive log objects.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#log_bucket StorageBucket#log_bucket}
    */
    readonly logBucket: string;
    /**
    * The object prefix for log objects. If it's not provided, by default Google Cloud Storage sets this to this bucket's name.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#log_object_prefix StorageBucket#log_object_prefix}
    */
    readonly logObjectPrefix?: string;
}
export declare function storageBucketLoggingToTerraform(struct?: StorageBucketLoggingOutputReference | StorageBucketLogging): any;
export declare class StorageBucketLoggingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketLogging | undefined;
    set internalValue(value: StorageBucketLogging | undefined);
    private _logBucket?;
    get logBucket(): string;
    set logBucket(value: string);
    get logBucketInput(): string | undefined;
    private _logObjectPrefix?;
    get logObjectPrefix(): string;
    set logObjectPrefix(value: string);
    resetLogObjectPrefix(): void;
    get logObjectPrefixInput(): string | undefined;
}
export interface StorageBucketRetentionPolicy {
    /**
    * If set to true, the bucket will be locked and permanently restrict edits to the bucket's retention policy.  Caution: Locking a bucket is an irreversible action.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#is_locked StorageBucket#is_locked}
    */
    readonly isLocked?: boolean | cdktf.IResolvable;
    /**
    * The period of time, in seconds, that objects in the bucket must be retained and cannot be deleted, overwritten, or archived. The value must be less than 3,155,760,000 seconds.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#retention_period StorageBucket#retention_period}
    */
    readonly retentionPeriod: number;
}
export declare function storageBucketRetentionPolicyToTerraform(struct?: StorageBucketRetentionPolicyOutputReference | StorageBucketRetentionPolicy): any;
export declare class StorageBucketRetentionPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketRetentionPolicy | undefined;
    set internalValue(value: StorageBucketRetentionPolicy | undefined);
    private _isLocked?;
    get isLocked(): boolean | cdktf.IResolvable;
    set isLocked(value: boolean | cdktf.IResolvable);
    resetIsLocked(): void;
    get isLockedInput(): boolean | cdktf.IResolvable | undefined;
    private _retentionPeriod?;
    get retentionPeriod(): number;
    set retentionPeriod(value: number);
    get retentionPeriodInput(): number | undefined;
}
export interface StorageBucketTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#create StorageBucket#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#read StorageBucket#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#update StorageBucket#update}
    */
    readonly update?: string;
}
export declare function storageBucketTimeoutsToTerraform(struct?: StorageBucketTimeoutsOutputReference | StorageBucketTimeouts | cdktf.IResolvable): any;
export declare class StorageBucketTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: StorageBucketTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
export interface StorageBucketVersioning {
    /**
    * While set to true, versioning is fully enabled for this bucket.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#enabled StorageBucket#enabled}
    */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function storageBucketVersioningToTerraform(struct?: StorageBucketVersioningOutputReference | StorageBucketVersioning): any;
export declare class StorageBucketVersioningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketVersioning | undefined;
    set internalValue(value: StorageBucketVersioning | undefined);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface StorageBucketWebsite {
    /**
    * Behaves as the bucket's directory index where missing objects are treated as potential directories.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#main_page_suffix StorageBucket#main_page_suffix}
    */
    readonly mainPageSuffix?: string;
    /**
    * The custom object to return when a requested resource is not found.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/storage_bucket#not_found_page StorageBucket#not_found_page}
    */
    readonly notFoundPage?: string;
}
export declare function storageBucketWebsiteToTerraform(struct?: StorageBucketWebsiteOutputReference | StorageBucketWebsite): any;
export declare class StorageBucketWebsiteOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): StorageBucketWebsite | undefined;
    set internalValue(value: StorageBucketWebsite | undefined);
    private _mainPageSuffix?;
    get mainPageSuffix(): string;
    set mainPageSuffix(value: string);
    resetMainPageSuffix(): void;
    get mainPageSuffixInput(): string | undefined;
    private _notFoundPage?;
    get notFoundPage(): string;
    set notFoundPage(value: string);
    resetNotFoundPage(): void;
    get notFoundPageInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/google/r/storage_bucket google_storage_bucket}
*/
export declare class StorageBucket extends cdktf.TerraformResource {
    static readonly tfResourceType = "google_storage_bucket";
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/google/r/storage_bucket google_storage_bucket} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options StorageBucketConfig
    */
    constructor(scope: Construct, id: string, config: StorageBucketConfig);
    private _defaultEventBasedHold?;
    get defaultEventBasedHold(): boolean | cdktf.IResolvable;
    set defaultEventBasedHold(value: boolean | cdktf.IResolvable);
    resetDefaultEventBasedHold(): void;
    get defaultEventBasedHoldInput(): boolean | cdktf.IResolvable | undefined;
    private _forceDestroy?;
    get forceDestroy(): boolean | cdktf.IResolvable;
    set forceDestroy(value: boolean | cdktf.IResolvable);
    resetForceDestroy(): void;
    get forceDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _labels?;
    get labels(): {
        [key: string]: string;
    };
    set labels(value: {
        [key: string]: string;
    });
    resetLabels(): void;
    get labelsInput(): {
        [key: string]: string;
    } | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _project?;
    get project(): string;
    set project(value: string);
    resetProject(): void;
    get projectInput(): string | undefined;
    private _requesterPays?;
    get requesterPays(): boolean | cdktf.IResolvable;
    set requesterPays(value: boolean | cdktf.IResolvable);
    resetRequesterPays(): void;
    get requesterPaysInput(): boolean | cdktf.IResolvable | undefined;
    get selfLink(): string;
    private _storageClass?;
    get storageClass(): string;
    set storageClass(value: string);
    resetStorageClass(): void;
    get storageClassInput(): string | undefined;
    private _uniformBucketLevelAccess?;
    get uniformBucketLevelAccess(): boolean | cdktf.IResolvable;
    set uniformBucketLevelAccess(value: boolean | cdktf.IResolvable);
    resetUniformBucketLevelAccess(): void;
    get uniformBucketLevelAccessInput(): boolean | cdktf.IResolvable | undefined;
    get url(): string;
    private _cors;
    get cors(): StorageBucketCorsList;
    putCors(value: StorageBucketCors[] | cdktf.IResolvable): void;
    resetCors(): void;
    get corsInput(): cdktf.IResolvable | StorageBucketCors[] | undefined;
    private _encryption;
    get encryption(): StorageBucketEncryptionOutputReference;
    putEncryption(value: StorageBucketEncryption): void;
    resetEncryption(): void;
    get encryptionInput(): StorageBucketEncryption | undefined;
    private _lifecycleRule;
    get lifecycleRule(): StorageBucketLifecycleRuleList;
    putLifecycleRule(value: StorageBucketLifecycleRule[] | cdktf.IResolvable): void;
    resetLifecycleRule(): void;
    get lifecycleRuleInput(): cdktf.IResolvable | StorageBucketLifecycleRule[] | undefined;
    private _logging;
    get logging(): StorageBucketLoggingOutputReference;
    putLogging(value: StorageBucketLogging): void;
    resetLogging(): void;
    get loggingInput(): StorageBucketLogging | undefined;
    private _retentionPolicy;
    get retentionPolicy(): StorageBucketRetentionPolicyOutputReference;
    putRetentionPolicy(value: StorageBucketRetentionPolicy): void;
    resetRetentionPolicy(): void;
    get retentionPolicyInput(): StorageBucketRetentionPolicy | undefined;
    private _timeouts;
    get timeouts(): StorageBucketTimeoutsOutputReference;
    putTimeouts(value: StorageBucketTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | StorageBucketTimeouts | undefined;
    private _versioning;
    get versioning(): StorageBucketVersioningOutputReference;
    putVersioning(value: StorageBucketVersioning): void;
    resetVersioning(): void;
    get versioningInput(): StorageBucketVersioning | undefined;
    private _website;
    get website(): StorageBucketWebsiteOutputReference;
    putWebsite(value: StorageBucketWebsite): void;
    resetWebsite(): void;
    get websiteInput(): StorageBucketWebsite | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
