# nanoget
This module provides functions to extract useful metrics from Oxford Nanopore sequencing reads and alignments.  

[![Twitter URL](https://img.shields.io/twitter/url/https/twitter.com/wouter_decoster.svg?style=social&label=Follow%20%40wouter_decoster)](https://twitter.com/wouter_decoster)
[![install with conda](https://anaconda.org/bioconda/nanoget/badges/installer/conda.svg)](https://anaconda.org/bioconda/nanoget)
[![Build Status](https://travis-ci.org/wdecoster/nanoget.svg?branch=master)](https://travis-ci.org/wdecoster/nanoget)


## FUNCTIONS
Data can be presented in the following formats, using the following functions:  
- A sorted bam file `process_bam(bamfile, threads)`  
- A standard fastq file `process_fastq_plain(fastqfile, 'threads')`  
- A fastq file with metadata from MinKNOW or Albacore `process_fastq_rich(fastqfile)`  
- A sequencing_summary file generated by Albacore `process_summary(sequencing_summary.txt, 'readtype')`  

Fastq files can be compressed using gzip, bzip2 or bgzip. The data is returned as a pandas DataFrame with standardized headernames for convenient extraction. The functions perform logging while being called and extracting data.


## INSTALLATION
```bash
pip install nanoget
```
or  
[![install with conda](https://anaconda.org/bioconda/nanoget/badges/installer/conda.svg)](https://anaconda.org/bioconda/nanoget)
```
conda install -c bioconda nanoget
```
