#-*- coding: utf-8 -*-
"""
@author:Bengali.AI
"""
from __future__ import print_function
#--------------------------------------------------------------------------------------------------------------------------------------------
# language classes
#--------------------------------------------------------------------------------------------------------------------------------------------
class english:
    lower                  =    ["a","b","c","d","e","f","g","h","i","j","k","l","m","n","o","p","q","r","s","t","u","v","w","x","y","z"]
    upper                  =    ["A","B","C","D","E","F","G","H","I","J","K","L","M","N","O","P","Q","R","S","T","U","V","W","X","Y","Z"]
    punctuations           =    ['!', '"', '#', '$', '%', '&', "'", '(', ')', '*', '+', ',', '-', '.', '/', ':', ';', '<', '=', '>', '?', 
                                 '@', '[', '\\', ']', '^', '_', '`','{', '|', '}', '~']
    numbers                =    ["0","1","2","3","4","5","6","7","8","9"]

    valid                  =    sorted(lower+upper+numbers+punctuations)
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
class bangla:
    '''
        * vowel and consonant division according to : http://bn.wikipedia.org/wiki/%E0%A7%8E
        * consonant conjuncts according to: http://bn.wiktionary.org/wiki/উইকিঅভিধান:বাংলা_যুক্তবর্ণের_তালিকা
        * punctuations according to: https://bn.wikipedia.org/wiki/যতিচিহ্ন
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =    "bangla"
    nukta                  =   '়'
    vowels                 =   ['অ', 'আ', 'ই', 'ঈ', 'উ', 'ঊ', 'ঋ', 'এ', 'ঐ', 'ও', 'ঔ']
    consonants             =   ['ক', 'খ', 'গ', 'ঘ', 'ঙ', 'চ', 'ছ','জ', 'ঝ', 'ঞ', 'ট', 'ঠ', 'ড', 'ঢ', 'ণ', 'ত', 'থ', 'দ', 'ধ', 'ন', 
                                'প', 'ফ', 'ব', 'ভ', 'ম', 'য', 'র', 'ল', 'শ', 'ষ', 'স', 'হ','ড়', 'ঢ়', 'য়','ৎ']
    vowel_diacritics       =   ['া', 'ি', 'ী', 'ু', 'ূ', 'ৃ', 'ে', 'ৈ', 'ো', 'ৌ']
    consonant_diacritics   =   ['ঁ', 'ং', 'ঃ']
    numbers                =   ['০', '১', '২', '৩', '৪', '৫', '৬', '৭', '৮', '৯']
    punctuations           =   [',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-']
    symbols                =   ['৳']
    connector              =   '্'
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0984', '\u098d','\u098e','\u0991','\u0992','\u09a9','\u09b1','\u09b3','\u09b4','\u09b5',
                                '\u09ba','\u09bb', '\u09c5','\u09c6','\u09c9','\u09ca','\u09cf','\u09d0','\u09d1','\u09d2',
                                '\u09d3','\u09d4','\u09d5','\u09d6', '\u09d8','\u09d9','\u09da','\u09db','\u09de', '\u09e4',
                                '\u09e5', 'ৼ','৽','৾','\u09ff']
    legacy_symbols         =   ['৺','৻','ঀ','ঌ','ৡ','ঽ','ৠ','৲','৴','৵','৶','৷','৸','৹']
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   ['এ্য','অ্য','ক্ক','ক্ট','ক্ট্য','ক্ট্র','ক্ত','ক্ত্র','ক্ব','ক্ম','ক্য','ক্র','ক্র্য','ক্ল','ক্ল্য','ক্ষ','ক্ষ্ণ','ক্ষ্ব','ক্ষ্ম','ক্ষ্ম্য','ক্ষ্য',
                                'ক্স','ক্স্য','খ্য','খ্র','গ্ণ','গ্ধ','গ্ধ্য','গ্ধ্র','গ্ন','গ্ন্য','গ্ব','গ্ম','গ্য','গ্র','গ্র্য','গ্ল','গ্ল্য','ঘ্ন','ঘ্য','ঘ্র',
                                'ঙ্ক','ঙ্ক্ত','ঙ্ক্য','ঙ্ক্ষ','ঙ্খ','ঙ্খ্য','ঙ্গ','ঙ্গ্য','ঙ্ঘ','ঙ্ঘ্য','ঙ্ঘ্র','ঙ্ম','চ্চ','চ্ছ','চ্ছ্ব','চ্ছ্র','চ্ঞ','চ্ব','চ্য','জ্জ',
                                'জ্জ্ব','জ্ঝ','জ্ঞ','জ্ব','জ্য','জ্র','ঞ্চ','ঞ্ছ','ঞ্জ','ঞ্ঝ','ট্ট','ট্ব','ট্ম','ট্য','ট্র','ট্র্য','ড্ড','ড্ব','ড্য','ড্র',
                                'ড্র্য','ঢ্য','ঢ্র','ণ্ট','ণ্ঠ','ণ্ঠ্য','ণ্ড','ণ্ড্য','ণ্ড্র','ণ্ঢ','ণ্ণ','ণ্ব','ণ্ম','ণ্য','ত্ত','ত্ত্ব','ত্ত্য','ত্থ','ত্ন','ত্ব',
                                'ত্ম','ত্ম্য','ত্য','ত্র','ত্র্য','থ্ব','থ্য','থ্র','থ্র্য','দ্গ','দ্ঘ','দ্দ','দ্দ্ব','দ্ধ','দ্ব','দ্ভ','দ্ভ্র','দ্ম','দ্য','দ্র',
                                'দ্র্য','ধ্ন','ধ্ব','ধ্ম','ধ্য','ধ্র','ন্ক','ন্ট','ন্ট্য','ন্ট্র','ন্ট্র্য','ন্ঠ','ন্ড','ন্ড্ব','ন্ড্য','ন্ড্র','ন্ত','ন্ত্ব','ন্ত্য','ন্ত্র',
                                'ন্ত্র্য','ন্থ','ন্থ্য','ন্থ্র','ন্দ','ন্দ্ব','ন্দ্য','ন্দ্র','ন্ধ','ন্ধ্য','ন্ধ্র','ন্ন','ন্ব','ন্ম','ন্য','ন্শ্য','ন্স','ন্স্য','প্ট','প্ট্য',
                                'প্ত','প্ন','প্প','প্য','প্র','প্র্য','প্ল','প্ল্য','প্স','ফ্য','ফ্র','ফ্র্য','ফ্ল','ফ্ল্য','ব্জ','ব্দ','ব্ধ','ব্ব','ব্য','ব্র',
                                'ব্র্য','ব্ল','ভ্ব','ভ্য','ভ্র','ম্ন','ম্ন্য','ম্প','ম্প্য','ম্প্র','ম্ফ','ম্ব','ম্ব্র','ম্ভ','ম্ভ্র','ম্ম','ম্য','ম্র','ম্ল','য্য',
                                'র্ক','র্ক্ট','র্ক্য','র্খ','র্গ','র্গ্য','র্গ্র','র্ঘ','র্ঘ্য','র্চ','র্চ্য','র্ছ','র্জ','র্জ্ঞ','র্জ্য','র্ঝ','র্ট','র্ট্য','র্ট্র','র্ড',
                                'র্ড্র','র্ঢ্য','র্ণ','র্ণ্য','র্ত','র্ত্ম','র্ত্য','র্ত্র','র্থ','র্থ্য','র্দ','র্দ্ব','র্দ্র','র্ধ','র্ধ্ব','র্ন','র্ন্ড','র্প','র্প্ট','র্প্ল',
                                'র্ফ','র্ব','র্ব্য','র্ভ','র্ম','র্ম্থ','র্ম্প','র্ম্য','র্য','র্ল','র্ল্ড','র্ল্য','র্শ','র্শ্ব','র্শ্য','র্ষ','র্ষ্য','র্স','র্স','র্স্ট',
                                'র্স্ম','র্স্য','র্হ','র্হ্য','র্হ্য','র‍্য','ল্ক','ল্ক্য','ল্গ','ল্চ','ল্ট','ল্ট্য','ল্ট্র','ল্ড','ল্ড্য','ল্ড্র','ল্প','ল্ফ','ল্ব','ল্ব্য',
                                'ল্ভ','ল্ম','ল্য','ল্ল','শ্চ','শ্ছ','শ্ন','শ্ব','শ্ম','শ্য','শ্র','শ্র্য','শ্ল','ষ্ক','ষ্ক্র','ষ্ট','ষ্ট্য','ষ্ট্র','ষ্ঠ','ষ্ঠ্য',
                                'ষ্ণ','ষ্প','ষ্প্র','ষ্ফ','ষ্ব','ষ্ম','ষ্য','স্ক','স্ক্য','স্ক্র','স্ক্র্য','স্খ','স্চ','স্ট','স্ট্য','স্ট্র','স্ট্র্য','স্ত','স্ত্ব','স্ত্য',
                                'স্ত্র','স্থ','স্থ্য','স্ন','স্ন্য','স্প','স্প্য','স্প্র','স্প্র্য','স্প্ল','স্প্ল্য','স্ফ','স্ব','স্ম','স্ম্য','স্য','স্র','স্ল','স্ল্য','হ্ণ',
                                'হ্ন','হ্ব','হ্ম','হ্য','হ্র','হ্ল','য়্য','ব্ল্য','র্ন্ত','ঠ্য','ভ্ল']
    
    # this is a customizeable map : this map is purely based on visual similiarity 
    legacy_maps             =   {'ঀ':'৭',
                                'ঌ':'৯',
                                'ৡ':'৯',
                                '৵':'৯',
                                '৻':'ৎ',
                                'ৠ':'ঋ',
                                'ঽ':'ই'}
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
    nukta_map              =   {'য':'য়',
                                'ব':'র',
                                'ড':'ড়',
                                'ঢ':'ঢ়'}
    diacritic_map           =   {'ো':'ো',
                                'ৌ':'ৌ',
                                'অা':'আ',
                                'ৄ':'ৃ'}
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
            * khondo to
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+['ৎ']+numbers+punctuations)       
    
class devanagari:
    '''
        * vowel and consonant division according to :https://unicode-table.com/en/blocks/devanagari/
        * consonant conjuncts according to: https://en.wikipedia.org/wiki/Devanagari_conjuncts
        * punctuations according to: https://www.learnsanskrit.org/guide/devanagari/numerals-and-punctuation/ 
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "devanagari"
    nukta                  =   '़'
    vowels                 =   ['ऄ', 'अ', 'आ', 'इ', 'ई', 'उ', 'ऊ', 'ऋ', 'ऌ', 'ऍ', 'ऎ', 'ए', 'ऐ', 'ऑ', 'ऒ', 'ओ', 'औ','ॠ', 'ॡ', 'ॢ', 'ॣ','ॲ','ॳ', 'ॴ', 'ॵ','ॶ', 'ॷ']
    consonants             =   ['क', 'ख', 'ग', 'घ', 'ङ', 'च', 'छ', 'ज', 'झ', 'ञ', 'ट', 'ठ', 'ड', 'ढ', 'ण', 'त', 'थ', 'द', 'ध', 'न', 'ऩ', 'प', 'फ', 'ब', 
                                'भ', 'म', 'य', 'र', 'ऱ', 'ल', 'ळ', 'ऴ', 'व', 'श', 'ष', 'स', 'ह','क़', 'ख़', 'ग़', 'ज़', 'ड़', 'ढ़', 'फ़', 'य़','ॸ', 'ॹ', 'ॺ']

    vowel_diacritics       =   ['ऺ', 'ऻ','ा', 'ि', 'ी', 'ु', 'ू', 'ृ', 'ॄ', 'ॅ', 'ॆ', 'े', 'ै', 'ॉ', 'ॊ', 'ो', 'ौ','ॎ', 'ॏ','ॕ','ॖ', 'ॗ']

    
    consonant_diacritics   =   ['ऀ', 'ँ', 'ं', 'ः']

    numbers                =   ['०', '१', '२', '३', '४', '५', '६', '७', '८', '९'] 
    punctuations           =   ['।', '॥', ':', ';', '!', '—', '?', 'ऽ']
    symbols                =   []  
    connector              =   '्'
    
    
    non_gylph_unicodes     =   [] 

    legacy_symbols         =   []      
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
   
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    conjuncts              =   ['क्क','क्ख','क्ग','क्घ','क्ङ','क्च','क्छ','क्ज','क्झ','क्ञ','क्ट','क्ठ','क्ड','क्ढ','क्ण','क्त','क्थ','क्द','क्ध','क्न',
                                'क्प','क्फ','क्ब','क्भ','क्म','क्य','क्र','क्ल','क्व','क्श','क्ष','क्स','क्ह','क्ळ','क्क्ष','क्ज्ञ','ख्क','ख्ख','ख्ग','ख्घ',
                                'ख्ङ','ख्च','ख्छ','ख्ज','ख्झ','ख्ञ','ख्ट','ख्ठ','ख्ड','ख्ढ','ख्ण','ख्त','ख्थ','ख्द','ख्ध','ख्न','ख्प','ख्फ','ख्ब','ख्भ',
                                'ख्म','ख्य','ख्र','ख्ल','ख्व','ख्श','ख्ष','ख्स','ख्ह','ख्ळ','ख्क्ष','ख्ज्ञ','ग्क','ग्ख','ग्ग','ग्घ','ग्ङ','ग्च','ग्छ','ग्ज',
                                'ग्झ','ग्ञ','ग्ट','ग्ठ','ग्ड','ग्ढ','ग्ण','ग्त','ग्थ','ग्द','ग्ध','ग्न','ग्प','ग्फ','ग्ब','ग्भ','ग्म','ग्य','ग्र','ग्ल',
                                'ग्व','ग्श','ग्ष','ग्स','ग्ह','ग्ळ','ग्क्ष','ग्ज्ञ','घ्क','घ्ख','घ्ग','घ्घ','घ्ङ','घ्च','घ्छ','घ्ज','घ्झ','घ्ञ','घ्ट','घ्ठ',
                                'घ्ड','घ्ढ','घ्ण','घ्त','घ्थ','घ्द','घ्ध','घ्न','घ्प','घ्फ','घ्ब','घ्भ','घ्म','घ्य','घ्र','घ्ल','घ्व','घ्श','घ्ष','घ्स',
                                'घ्ह','घ्ळ','घ्क्ष','घ्ज्ञ','ङ्क','ङ्ख','ङ्ग','ङ्घ','ङ्ङ','ङ्च','ङ्छ','ङ्ज','ङ्झ','ङ्ञ','ङ्ट','ङ्ठ','ङ्ड','ङ्ढ','ङ्ण','ङ्त',
                                'ङ्थ','ङ्द','ङ्ध','ङ्न','ङ्प','ङ्फ','ङ्ब','ङ्भ','ङ्म','ङ्य','ङ्र','ङ्ल','ङ्व','ङ्श','ङ्ष','ङ्स','ङ्ह','ङ्ळ','ङ्क्ष','ङ्ज्ञ',
                                'च्क','च्ख','च्ग','च्घ','च्ङ','च्च','च्छ','च्ज','च्झ','च्ञ','च्ट','च्ठ','च्ड','च्ढ','च्ण','च्त','च्थ','च्द','च्ध','च्न',
                                'च्प','च्फ','च्ब','च्भ','च्म','च्य','च्र','च्ल','च्व','च्श','च्ष','च्स','च्ह','च्ळ','च्क्ष','च्ज्ञ','छ्क','छ्ख','छ्ग','छ्घ',
                                'छ्ङ','छ्च','छ्छ','छ्ज','छ्झ','छ्ञ','छ्ट','छ्ठ','छ्ड','छ्ढ','छ्ण','छ्त','छ्थ','छ्द','छ्ध','छ्न','छ्प','छ्फ','छ्ब','छ्भ',
                                'छ्म','छ्य','छ्र','छ्ल','छ्व','छ्श','छ्ष','छ्स','छ्ह','छ्ळ','छ्क्ष','छ्ज्ञ','ज्क','ज्ख','ज्ग','ज्घ','ज्ङ','ज्च','ज्छ','ज्ज',
                                'ज्झ','ज्ञ','ज्ट','ज्ठ','ज्ड','ज्ढ','ज्ण','ज्त','ज्थ','ज्द','ज्ध','ज्न','ज्प','ज्फ','ज्ब','ज्भ','ज्म','ज्य','ज्र','ज्ल',
                                'ज्व','ज्श','ज्ष','ज्स','ज्ह','ज्ळ','ज्क्ष','ज्ज्ञ','झ्क','झ्ख','झ्ग','झ्घ','झ्ङ','झ्च','झ्छ','झ्ज','झ्झ','झ्ञ','झ्ट','झ्ठ',
                                'झ्ड','झ्ढ','झ्ण','झ्त','झ्थ','झ्द','झ्ध','झ्न','झ्प','झ्फ','झ्ब','झ्भ','झ्म','झ्य','झ्र','झ्ल','झ्व','झ्श','झ्ष','झ्स',
                                'झ्ह','झ्ळ','झ्क्ष','झ्ज्ञ','ञ्क','ञ्ख','ञ्ग','ञ्घ','ञ्ङ','ञ्च','ञ्छ','ञ्ज','ञ्झ','ञ्ञ','ञ्ट','ञ्ठ','ञ्ड','ञ्ढ','ञ्ण','ञ्त',
                                'ञ्थ','ञ्द','ञ्ध','ञ्न','ञ्प','ञ्फ','ञ्ब','ञ्भ','ञ्म','ञ्य','ञ्र','ञ्ल','ञ्व','ञ्श','ञ्ष','ञ्स','ञ्ह','ञ्ळ','ञ्क्ष','ञ्ज्ञ',
                                'ट्क','ट्ख','ट्ग','ट्घ','ट्ङ','ट्च','ट्छ','ट्ज','ट्झ','ट्ञ','ट्ट','ट्ठ','ट्ड','ट्ढ','ट्ण','ट्त','ट्थ','ट्द','ट्ध','ट्न',
                                'ट्प','ट्फ','ट्ब','ट्भ','ट्म','ट्य','ट्र','ट्ल','ट्व','ट्श','ट्ष','ट्स','ट्ह','ट्ळ','ट्क्ष','ट्ज्ञ','ठ्क','ठ्ख','ठ्ग','ठ्घ',
                                'ठ्ङ','ठ्च','ठ्छ','ठ्ज','ठ्झ','ठ्ञ','ठ्ट','ठ्ठ','ठ्ड','ठ्ढ','ठ्ण','ठ्त','ठ्थ','ठ्द','ठ्ध','ठ्न','ठ्प','ठ्फ','ठ्ब','ठ्भ',
                                'ठ्म','ठ्य','ठ्र','ठ्ल','ठ्व','ठ्श','ठ्ष','ठ्स','ठ्ह','ठ्ळ','ठ्क्ष','ठ्ज्ञ','ड्क','ड्ख','ड्ग','ड्घ','ड्ङ','ड्च','ड्छ','ड्ज',
                                'ड्झ','ड्ञ','ड्ट','ड्ठ','ड्ड','ड्ढ','ड्ण','ड्त','ड्थ','ड्द','ड्ध','ड्न','ड्प','ड्फ','ड्ब','ड्भ','ड्म','ड्य','ड्र','ड्ल',
                                'ड्व','ड्श','ड्ष','ड्स','ड्ह','ड्ळ','ड्क्ष','ड्ज्ञ','ढ्क','ढ्ख','ढ्ग','ढ्घ','ढ्ङ','ढ्च','ढ्छ','ढ्ज','ढ्झ','ढ्ञ','ढ्ट','ढ्ठ',
                                'ढ्ड','ढ्ढ','ढ्ण','ढ्त','ढ्थ','ढ्द','ढ्ध','ढ्न','ढ्प','ढ्फ','ढ्ब','ढ्भ','ढ्म','ढ्य','ढ्र','ढ्ल','ढ्व','ढ्श','ढ्ष','ढ्स',
                                'ढ्ह','ढ्ळ','ढ्क्ष','ढ्ज्ञ','ण्क','ण्ख','ण्ग','ण्घ','ण्ङ','ण्च','ण्छ','ण्ज','ण्झ','ण्ञ','ण्ट','ण्ठ','ण्ड','ण्ढ','ण्ण','ण्त',
                                'ण्थ','ण्द','ण्ध','ण्न','ण्प','ण्फ','ण्ब','ण्भ','ण्म','ण्य','ण्र','ण्ल','ण्व','ण्श','ण्ष','ण्स','ण्ह','ण्ळ','ण्क्ष','ण्ज्ञ',
                                'त्क','त्ख','त्ग','त्घ','त्ङ','त्च','त्छ','त्ज','त्झ','त्ञ','त्ट','त्ठ','त्ड','त्ढ','त्ण','त्त','त्थ','त्द','त्ध','त्न',
                                'त्प','त्फ','त्ब','त्भ','त्म','त्य','त्र','त्ल','त्व','त्श','त्ष','त्स','त्ह','त्ळ','त्क्ष','त्ज्ञ','थ्क','थ्ख','थ्ग','थ्घ',
                                'थ्ङ','थ्च','थ्छ','थ्ज','थ्झ','थ्ञ','थ्ट','थ्ठ','थ्ड','थ्ढ','थ्ण','थ्त','थ्थ','थ्द','थ्ध','थ्न','थ्प','थ्फ','थ्ब','थ्भ',
                                'थ्म','थ्य','थ्र','थ्ल','थ्व','थ्श','थ्ष','थ्स','थ्ह','थ्ळ','थ्क्ष','थ्ज्ञ','द्क','द्ख','द्ग','द्घ','द्ङ','द्च','द्छ','द्ज',
                                'द्झ','द्ञ','द्ट','द्ठ','द्ड','द्ढ','द्ण','द्त','द्थ','द्द','द्ध','द्न','द्प','द्फ','द्ब','द्भ','द्म','द्य','द्र','द्ल',
                                'द्व','द्श','द्ष','द्स','द्ह','द्ळ','द्क्ष','द्ज्ञ','ध्क','ध्ख','ध्ग','ध्घ','ध्ङ','ध्च','ध्छ','ध्ज','ध्झ','ध्ञ','ध्ट','ध्ठ',
                                'ध्ड','ध्ढ','ध्ण','ध्त','ध्थ','ध्द','ध्ध','ध्न','ध्प','ध्फ','ध्ब','ध्भ','ध्म','ध्य','ध्र','ध्ल','ध्व','ध्श','ध्ष','ध्स',
                                'ध्ह','ध्ळ','ध्क्ष','ध्ज्ञ','न्क','न्ख','न्ग','न्घ','न्ङ','न्च','न्छ','न्ज','न्झ','न्ञ','न्ट','न्ठ','न्ड','न्ढ','न्ण','न्त',
                                'न्थ','न्द','न्ध','न्न','न्प','न्फ','न्ब','न्भ','न्म','न्य','न्र','न्ल','न्व','न्श','न्ष','न्स','न्ह','न्ळ','न्क्ष','न्ज्ञ',
                                'प्क','प्ख','प्ग','प्घ','प्ङ','प्च','प्छ','प्ज','प्झ','प्ञ','प्ट','प्ठ','प्ड','प्ढ','प्ण','प्त','प्थ','प्द','प्ध','प्न',
                                'प्प','प्फ','प्ब','प्भ','प्म','प्य','प्र','प्ल','प्व','प्श','प्ष','प्स','प्ह','प्ळ','प्क्ष','प्ज्ञ','फ्क','फ्ख','फ्ग','फ्घ',
                                'फ्ङ','फ्च','फ्छ','फ्ज','फ्झ','फ्ञ','फ्ट','फ्ठ','फ्ड','फ्ढ','फ्ण','फ्त','फ्थ','फ्द','फ्ध','फ्न','फ्प','फ्फ','फ्ब','फ्भ',
                                'फ्म','फ्य','फ्र','फ्ल','फ्व','फ्श','फ्ष','फ्स','फ्ह','फ्ळ','फ्क्ष','फ्ज्ञ','ब्क','ब्ख','ब्ग','ब्घ','ब्ङ','ब्च','ब्छ','ब्ज',
                                'ब्झ','ब्ञ','ब्ट','ब्ठ','ब्ड','ब्ढ','ब्ण','ब्त','ब्थ','ब्द','ब्ध','ब्न','ब्प','ब्फ','ब्ब','ब्भ','ब्म','ब्य','ब्र','ब्ल',
                                'ब्व','ब्श','ब्ष','ब्स','ब्ह','ब्ळ','ब्क्ष','ब्ज्ञ','भ्क','भ्ख','भ्ग','भ्घ','भ्ङ','भ्च','भ्छ','भ्ज','भ्झ','भ्ञ','भ्ट','भ्ठ',
                                'भ्ड','भ्ढ','भ्ण','भ्त','भ्थ','भ्द','भ्ध','भ्न','भ्प','भ्फ','भ्ब','भ्भ','भ्म','भ्य','भ्र','भ्ल','भ्व','भ्श','भ्ष','भ्स',
                                'भ्ह','भ्ळ','भ्क्ष','भ्ज्ञ','म्क','म्ख','म्ग','म्घ','म्ङ','म्च','म्छ','म्ज','म्झ','म्ञ','म्ट','म्ठ','म्ड','म्ढ','म्ण','म्त',
                                'म्थ','म्द','म्ध','म्न','म्प','म्फ','म्ब','म्भ','म्म','म्य','म्र','म्ल','म्व','म्श','म्ष','म्स','म्ह','म्ळ','म्क्ष','म्ज्ञ',
                                'य्क','य्ख','य्ग','य्घ','य्ङ','य्च','य्छ','य्ज','य्झ','य्ञ','य्ट','य्ठ','य्ड','य्ढ','य्ण','य्त','य्थ','य्द','य्ध','य्न',
                                'य्प','य्फ','य्ब','य्भ','य्म','य्य','य्र','य्ल','य्व','य्श','य्ष','य्स','य्ह','य्ळ','य्क्ष','य्ज्ञ','र्क','र्ख','र्ग','र्घ',
                                'र्ङ','र्च','र्छ','र्ज','र्झ','र्ञ','र्ट','र्ठ','र्ड','र्ढ','र्ण','र्त','र्थ','र','द','र्ध','र्न','र्प','र्फ','र्ब',
                                'र्भ','र्म','र्य','र्र','र्ल','र्व','र्श','र्ष','र्स','र्ह','र्ळ','र्क','ष','र्ज्ञ','ल्क','ल्ख','ल्ग','ल्घ','ल्ङ','ल्च',
                                'ल्छ','ल्ज','ल्झ','ल्ञ','ल्ट','ल्ठ','ल्ड','ल्ढ','ल्ण','ल्त','ल्थ','ल्द','ल्ध','ल्न','ल्प','ल्फ','ल्ब','ल्भ','ल्म','ल्य',
                                'ल्र','ल्ल','ल्व','ल्श','ल्ष','ल्स','ल्ह','ल्ळ','ल्क्ष','ल्ज्ञ','व्क','व्ख','व्ग','व्घ','व्ङ','व्च','व्छ','व्ज','व्झ','व्ञ',
                                'व्ट','व्ठ','व्ड','व्ढ','व्ण','व्त','व्थ','व्द','व्ध','व्न','व्प','व्फ','व्ब','व्भ','व्म','व्य','व्र','व्ल','व्व','व्श',
                                'व्ष','व्स','व्ह','व्ळ','व्क्ष','व्ज्ञ','श्क','श्ख','श्ग','श्घ','श्ङ','श्च','श्छ','श्ज','श्झ','श्ञ','श्ट','श्ठ','श्ड','श्ढ',
                                'श्ण','श्त','श्थ','श्द','श्ध','श्न','श्प','श्फ','श्ब','श्भ','श्म','श्य','श्र','श्ल','श्व','श्श','श्ष','श्स','श्ह','श्ळ',
                                'श्क्ष','श्ज्ञ','ष्क','ष्ख','ष्ग','ष्घ','ष्ङ','ष्च','ष्छ','ष्ज','ष्झ','ष्ञ','ष्ट','ष्ठ','ष्ड','ष्ढ','ष्ण','ष्त','ष्थ','ष्द',
                                'ष्ध','ष्न','ष्प','ष्फ','ष्ब','ष्भ','ष्म','ष्य','ष्र','ष्ल','ष्व','ष्श','ष्ष','ष्स','ष्ह','ष्ळ','ष्क्ष','ष्ज्ञ','स्क','स्ख',
                                'स्ग','स्घ','स्ङ','स्च','स्छ','स्ज','स्झ','स्ञ','स्ट','स्ठ','स्ड','स्ढ','स्ण','स्त','स्थ','स्द','स्ध','स्न','स्प','स्फ',
                                'स्ब','स्भ','स्म','स्य','स्र','स्ल','स्व','स्श','स्ष','स्स','स्ह','स्ळ','स्क्ष','स्ज्ञ','ह्क','ह्ख','ह्ग','ह्घ','ह्ङ','ह्च',
                                'ह्छ','ह्ज','ह्झ','ह्ञ','ह्ट','ह्ठ','ह्ड','ह्ढ','ह्ण','ह्त','ह्थ','ह्द','ह्ध','ह्न','ह्प','ह्फ','ह्ब','ह्भ','ह्म','ह्य',
                                'ह्र','ह्ल','ह्व','ह्श','ह्ष','ह्स','ह्ह','ह्ळ','ह्क्ष','ह्ज्ञ','ळ्क','ळ्ख','ळ्ग','ळ्घ','ळ्ङ','ळ्च','ळ्छ','ळ्ज','ळ्झ','ळ्ञ',
                                'ळ्ट','ळ्ठ','ळ्ड','ळ्ढ','ळ्ण','ळ्त','ळ्थ','ळ्द','ळ्ध','ळ्न','ळ्प','ळ्फ','ळ्ब','ळ्भ','ळ्म','ळ्य','ळ्र','ळ्ल','ळ्व','ळ्श',
                                'ळ्ष','ळ्स','ळ्ह','ळ्ळ','ळ्क्ष','ळ्ज्ञ']
    # this is a customizeable map : this map is purely based on visual similiarity 
  
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------

    nukta_map              =   {'क':'क़',
                                'ख':'ख़',
                                'ग':'ग़',
                                'ज':'ज़',
                                'ड':'ड़',
                                'ढ':'ढ़',
                                'फ':'फ़',
                                'य':'य़',
                                'ळ':'ऴ',
                                'न':'ऩ'}
  
    diacritic_map          =   {}
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
class gujarati:
    '''
        * vowel and consonant division according to : https://unicode-table.com/en/blocks/gujarati/
        * consonant conjuncts according to: https://en.wikipedia.org/wiki/Gujarati_script
        * punctuations according to: https://github.com/BengaliAI/syntheticWords/blob/main/coreLib/languages.py
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "gujarati"
    nukta                  =   '઼'
    vowels                 =   ['અ', 'આ', 'ઇ', 'ઈ', 'ઉ', 'ઊ', 'ઋ', 'ઌ', 'ઍ', 'એ', 'ઐ', 'ઑ', 'ઓ', 'ઔ','ૠ', 'ૡ', 'ૢ', 'ૣ']
    consonants             =   ['ક', 'ખ', 'ગ', 'ઘ', 'ઙ', 'ચ', 'છ', 'જ', 'ઝ', 'ઞ', 'ટ', 'ઠ', 'ડ', 'ઢ', 'ણ', 'ત', 'થ', 'દ', 'ધ', 'ન', 'પ', 'ફ', 'બ', 'ભ', 'મ', 'ય', 'ર', 'લ', 'ળ', 'વ', 'શ', 'ષ', 'સ', 'હ','ૹ']
    vowel_diacritics       =   ['ા', 'િ', 'ી', 'ુ', 'ૂ', 'ૃ', 'ૄ', 'ૅ', 'ે', 'ૈ', 'ૉ', 'ો', 'ૌ']
    consonant_diacritics   =   ['ઁ', 'ં', 'ઃ']
    numbers                =   ['૦', '૧', '૨', '૩', '૪', '૫', '૬', '૭', '૮', '૯']
    punctuations           =   ['ઽ',',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-'] 
    symbols                =   ['૱']
    connector              =   '્'
    
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0a80', '\u0a84', '\u0aa9', '\u0ab1', '\u0ab4', '\u0aba', '\u0abb', '\u0ac6', '\u0aca', '\u0ace', '\u0acf', 
                                '\u0ad1', '\u0ad2', '\u0ad3', '\u0ad4', '\u0ad5', '\u0ad6', '\u0ad7', '\u0ad8', '\u0ad9', '\u0ada', '\u0adb', 
                                '\u0adc', '\u0add', '\u0ade', '\u0adf', '\u0ae4', '\u0ae5', '\u0af1', '\u0af2', '\u0af3', '\u0af4', '\u0af5', 
                                '\u0af6', '\u0af7', '\u0af8']

    legacy_symbols         =   []  
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   ['ક્ક','ક્ખ','ક્ગ','ક્ઘ','ક્ઙ','ક્ચ','ક્છ','ક્જ','ક્ઝ','ક્ઞ','ક્ટ','ક્ઠ','ક્ડ','ક્ઢ','ક્ણ','ક્ત','ક્થ','ક્દ','ક્ધ','ક્ન',
                                'ક્પ','ક્ફ','ક્બ','ક્ભ','ક્મ','ક્ય','ક્ર','ક્લ','ક્ળ','ક્વ','ક્શ','ક્ષ','ક્સ','ક્હ','ખ્ક','ખ્ખ','ખ્ગ','ખ્ઘ','ખ્ઙ','ખ્ચ',
                                'ખ્છ','ખ્જ','ખ્ઝ','ખ્ઞ','ખ્ટ','ખ્ઠ','ખ્ડ','ખ્ઢ','ખ્ણ','ખ્ત','ખ્થ','ખ્દ','ખ્ધ','ખ્ન','ખ્પ','ખ્ફ','ખ્બ','ખ્ભ','ખ્મ','ખ્ય',
                                'ખ્ર','ખ્લ','ખ્ળ','ખ્વ','ખ્શ','ખ્ષ','ખ્સ','ખ્હ','ગ્ક','ગ્ખ','ગ્ગ','ગ્ઘ','ગ્ઙ','ગ્ચ','ગ્છ','ગ્જ','ગ્ઝ','ગ્ઞ','ગ્ટ','ગ્ઠ',
                                'ગ્ડ','ગ્ઢ','ગ્ણ','ગ્ત','ગ્થ','ગ્દ','ગ્ધ','ગ્ન','ગ્પ','ગ્ફ','ગ્બ','ગ્ભ','ગ્મ','ગ્ય','ગ્ર','ગ્લ','ગ્ળ','ગ્વ','ગ્શ','ગ્ષ',
                                'ગ્સ','ગ્હ','ઘ્ક','ઘ્ખ','ઘ્ગ','ઘ્ઘ','ઘ્ઙ','ઘ્ચ','ઘ્છ','ઘ્જ','ઘ્ઝ','ઘ્ઞ','ઘ્ટ','ઘ્ઠ','ઘ્ડ','ઘ્ઢ','ઘ્ણ','ઘ્ત','ઘ્થ','ઘ્દ',
                                'ઘ્ધ','ઘ્ન','ઘ્પ','ઘ્ફ','ઘ્બ','ઘ્ભ','ઘ્મ','ઘ્ય','ઘ્ર','ઘ્લ','ઘ્ળ','ઘ્વ','ઘ્શ','ઘ્ષ','ઘ્સ','ઘ્હ','ઙ્ક','ઙ્ખ','ઙ્ગ','ઙ્ઘ',
                                'ઙ્ઙ','ઙ્ચ','ઙ્છ','ઙ્જ','ઙ્ઝ','ઙ્ઞ','ઙ્ટ','ઙ્ઠ','ઙ્ડ','ઙ્ઢ','ઙ્ણ','ઙ્ત','ઙ્થ','ઙ્દ','ઙ્ધ','ઙ્ન','ઙ્પ','ઙ્ફ','ઙ્બ','ઙ્ભ',
                                'ઙ્મ','ઙ્ય','ઙ્ર','ઙ્લ','ઙ્ળ','ઙ્વ','ઙ્શ','ઙ્ષ','ઙ્સ','ઙ્હ','ચ્ક','ચ્ખ','ચ્ગ','ચ્ઘ','ચ્ઙ','ચ્ચ','ચ્છ','ચ્જ','ચ્ઝ','ચ્ઞ',
                                'ચ્ટ','ચ્ઠ','ચ્ડ','ચ્ઢ','ચ્ણ','ચ્ત','ચ્થ','ચ્દ','ચ્ધ','ચ્ન','ચ્પ','ચ્ફ','ચ્બ','ચ્ભ','ચ્મ','ચ્ય','ચ્ર','ચ્લ','ચ્ળ','ચ્વ',
                                'ચ્શ','ચ્ષ','ચ્સ','ચ્હ','છ્ક','છ્ખ','છ્ગ','છ્ઘ','છ્ઙ','છ્ચ','છ્છ','છ્જ','છ્ઝ','છ્ઞ','છ્ટ','છ્ઠ','છ્ડ','છ્ઢ','છ્ણ','છ્ત',
                                'છ્થ','છ્દ','છ્ધ','છ્ન','છ્પ','છ્ફ','છ્બ','છ્ભ','છ્મ','છ્ય','છ્ર','છ્લ','છ્ળ','છ્વ','છ્શ','છ્ષ','છ્સ','છ્હ','જ્ક','જ્ખ',
                                'જ્ગ','જ્ઘ','જ્ઙ','જ્ચ','જ્છ','જ્જ','જ્ઝ','જ્ઞ','જ્ટ','જ્ઠ','જ્ડ','જ્ઢ','જ્ણ','જ્ત','જ્થ','જ્દ','જ્ધ','જ્ન','જ્પ','જ્ફ',
                                'જ્બ','જ્ભ','જ્મ','જ્ય','જ્ર','જ્લ','જ્ળ','જ્વ','જ્શ','જ્ષ','જ્સ','જ્હ','ઝ્ક','ઝ્ખ','ઝ્ગ','ઝ્ઘ','ઝ્ઙ','ઝ્ચ','ઝ્છ','ઝ્જ',
                                'ઝ્ઝ','ઝ્ઞ','ઝ્ટ','ઝ્ઠ','ઝ્ડ','ઝ્ઢ','ઝ્ણ','ઝ્ત','ઝ્થ','ઝ્દ','ઝ્ધ','ઝ્ન','ઝ્પ','ઝ્ફ','ઝ્બ','ઝ્ભ','ઝ્મ','ઝ્ય','ઝ્ર','ઝ્લ',
                                'ઝ્ળ','ઝ્વ','ઝ્શ','ઝ્ષ','ઝ્સ','ઝ્હ','ઞ્ક','ઞ્ખ','ઞ્ગ','ઞ્ઘ','ઞ્ઙ','ઞ્ચ','ઞ્છ','ઞ્જ','ઞ્ઝ','ઞ્ઞ','ઞ્ટ','ઞ્ઠ','ઞ્ડ','ઞ્ઢ',
                                'ઞ્ણ','ઞ્ત','ઞ્થ','ઞ્દ','ઞ્ધ','ઞ્ન','ઞ્પ','ઞ્ફ','ઞ્બ','ઞ્ભ','ઞ્મ','ઞ્ય','ઞ્ર','ઞ્લ','ઞ્ળ','ઞ્વ','ઞ્શ','ઞ્ષ','ઞ્સ','ઞ્હ',
                                'ટ્ક','ટ્ખ','ટ્ગ','ટ્ઘ','ટ્ઙ','ટ્ચ','ટ્છ','ટ્જ','ટ્ઝ','ટ્ઞ','ટ્ટ','ટ્ઠ','ટ્ડ','ટ્ઢ','ટ્ણ','ટ્ત','ટ્થ','ટ્દ','ટ્ધ','ટ્ન',
                                'ટ્પ','ટ્ફ','ટ્બ','ટ્ભ','ટ્મ','ટ્ય','ટ્ર','ટ્લ','ટ્ળ','ટ્વ','ટ્શ','ટ્ષ','ટ્સ','ટ્હ','ઠ્ક','ઠ્ખ','ઠ્ગ','ઠ્ઘ','ઠ્ઙ','ઠ્ચ',
                                'ઠ્છ','ઠ્જ','ઠ્ઝ','ઠ્ઞ','ઠ્ટ','ઠ્ઠ','ઠ્ડ','ઠ્ઢ','ઠ્ણ','ઠ્ત','ઠ્થ','ઠ્દ','ઠ્ધ','ઠ્ન','ઠ્પ','ઠ્ફ','ઠ્બ','ઠ્ભ','ઠ્મ','ઠ્ય',
                                'ઠ્ર','ઠ્લ','ઠ્ળ','ઠ્વ','ઠ્શ','ઠ્ષ','ઠ્સ','ઠ્હ','ડ્ક','ડ્ખ','ડ્ગ','ડ્ઘ','ડ્ઙ','ડ્ચ','ડ્છ','ડ્જ','ડ્ઝ','ડ્ઞ','ડ્ટ','ડ્ઠ',
                                'ડ્ડ','ડ્ઢ','ડ્ણ','ડ્ત','ડ્થ','ડ્દ','ડ્ધ','ડ્ન','ડ્પ','ડ્ફ','ડ્બ','ડ્ભ','ડ્મ','ડ્ય','ડ્ર','ડ્લ','ડ્ળ','ડ્વ','ડ્શ','ડ્ષ',
                                'ડ્સ','ડ્હ','ઢ્ક','ઢ્ખ','ઢ્ગ','ઢ્ઘ','ઢ્ઙ','ઢ્ચ','ઢ્છ','ઢ્જ','ઢ્ઝ','ઢ્ઞ','ઢ્ટ','ઢ્ઠ','ઢ્ડ','ઢ્ઢ','ઢ્ણ','ઢ્ત','ઢ્થ','ઢ્દ',
                                'ઢ્ધ','ઢ્ન','ઢ્પ','ઢ્ફ','ઢ્બ','ઢ્ભ','ઢ્મ','ઢ્ય','ઢ્ર','ઢ્લ','ઢ્ળ','ઢ્વ','ઢ્શ','ઢ્ષ','ઢ્સ','ઢ્હ','ણ્ક','ણ્ખ','ણ્ગ','ણ્ઘ',
                                'ણ્ઙ','ણ્ચ','ણ્છ','ણ્જ','ણ્ઝ','ણ્ઞ','ણ્ટ','ણ્ઠ','ણ્ડ','ણ્ઢ','ણ્ણ','ણ્ત','ણ્થ','ણ્દ','ણ્ધ','ણ્ન','ણ્પ','ણ્ફ','ણ્બ','ણ્ભ',
                                'ણ્મ','ણ્ય','ણ્ર','ણ્લ','ણ્ળ','ણ્વ','ણ્શ','ણ્ષ','ણ્સ','ણ્હ','ત્ક','ત્ખ','ત્ગ','ત્ઘ','ત્ઙ','ત્ચ','ત્છ','ત્જ','ત્ઝ','ત્ઞ',
                                'ત્ટ','ત્ઠ','ત્ડ','ત્ઢ','ત્ણ','ત્ત','ત્થ','ત્દ','ત્ધ','ત્ન','ત્પ','ત્ફ','ત્બ','ત્ભ','ત્મ','ત્ય','ત્ર','ત્લ','ત્ળ','ત્વ',
                                'ત્શ','ત્ષ','ત્સ','ત્હ','થ્ક','થ્ખ','થ્ગ','થ્ઘ','થ્ઙ','થ્ચ','થ્છ','થ્જ','થ્ઝ','થ્ઞ','થ્ટ','થ્ઠ','થ્ડ','થ્ઢ','થ્ણ','થ્ત',
                                'થ્થ','થ્દ','થ્ધ','થ્ન','થ્પ','થ્ફ','થ્બ','થ્ભ','થ્મ','થ્ય','થ્ર','થ્લ','થ્ળ','થ્વ','થ્શ','થ્ષ','થ્સ','થ્હ','દ્ક','દ્ખ',
                                'દ્ગ','દ્ઘ','દ્ઙ','દ્ચ','દ્છ','દ્જ','દ્ઝ','દ્ઞ','દ્ટ','દ્ઠ','દ્ડ','દ્ઢ','દ્ણ','દ્ત','દ્થ','દ્દ','દ્ધ','દ્ન','દ્પ','દ્ફ',
                                'દ્બ','દ્ભ','દ્મ','દ્ય','દ્ર','દ્લ','દ્ળ','દ્વ','દ્શ','દ્ષ','દ્સ','દ્હ','ધ્ક','ધ્ખ','ધ્ગ','ધ્ઘ','ધ્ઙ','ધ્ચ','ધ્છ','ધ્જ',
                                'ધ્ઝ','ધ્ઞ','ધ્ટ','ધ્ઠ','ધ્ડ','ધ્ઢ','ધ્ણ','ધ્ત','ધ્થ','ધ્દ','ધ્ધ','ધ્ન','ધ્પ','ધ્ફ','ધ્બ','ધ્ભ','ધ્મ','ધ્ય','ધ્ર','ધ્લ',
                                'ધ્ળ','ધ્વ','ધ્શ','ધ્ષ','ધ્સ','ધ્હ','ન્ક','ન્ખ','ન્ગ','ન્ઘ','ન્ઙ','ન્ચ','ન્છ','ન્જ','ન્ઝ','ન્ઞ','ન્ટ','ન્ઠ','ન્ડ','ન્ઢ',
                                'ન્ણ','ન્ત','ન્થ','ન્દ','ન્ધ','ન્ન','ન્પ','ન્ફ','ન્બ','ન્ભ','ન્મ','ન્ય','ન્ર','ન્લ','ન્ળ','ન્વ','ન્શ','ન્ષ','ન્સ','ન્હ',
                                'પ્ક','પ્ખ','પ્ગ','પ્ઘ','પ્ઙ','પ્ચ','પ્છ','પ્જ','પ્ઝ','પ્ઞ','પ્ટ','પ્ઠ','પ્ડ','પ્ઢ','પ્ણ','પ્ત','પ્થ','પ્દ','પ્ધ','પ્ન',
                                'પ્પ','પ્ફ','પ્બ','પ્ભ','પ્મ','પ્ય','પ્ર','પ્લ','પ્ળ','પ્વ','પ્શ','પ્ષ','પ્સ','પ્હ','ફ્ક','ફ્ખ','ફ્ગ','ફ્ઘ','ફ્ઙ','ફ્ચ',
                                'ફ્છ','ફ્જ','ફ્ઝ','ફ્ઞ','ફ્ટ','ફ્ઠ','ફ્ડ','ફ્ઢ','ફ્ણ','ફ્ત','ફ્થ','ફ્દ','ફ્ધ','ફ્ન','ફ્પ','ફ્ફ','ફ્બ','ફ્ભ','ફ્મ','ફ્ય',
                                'ફ્ર','ફ્લ','ફ્ળ','ફ્વ','ફ્શ','ફ્ષ','ફ્સ','ફ્હ','બ્ક','બ્ખ','બ્ગ','બ્ઘ','બ્ઙ','બ્ચ','બ્છ','બ્જ','બ્ઝ','બ્ઞ','બ્ટ','બ્ઠ',
                                'બ્ડ','બ્ઢ','બ્ણ','બ્ત','બ્થ','બ્દ','બ્ધ','બ્ન','બ્પ','બ્ફ','બ્બ','બ્ભ','બ્મ','બ્ય','બ્ર','બ્લ','બ્ળ','બ્વ','બ્શ','બ્ષ',
                                'બ્સ','બ્હ','ભ્ક','ભ્ખ','ભ્ગ','ભ્ઘ','ભ્ઙ','ભ્ચ','ભ્છ','ભ્જ','ભ્ઝ','ભ્ઞ','ભ્ટ','ભ્ઠ','ભ્ડ','ભ્ઢ','ભ્ણ','ભ્ત','ભ્થ','ભ્દ',
                                'ભ્ધ','ભ્ન','ભ્પ','ભ્ફ','ભ્બ','ભ્ભ','ભ્મ','ભ્ય','ભ્ર','ભ્લ','ભ્ળ','ભ્વ','ભ્શ','ભ્ષ','ભ્સ','ભ્હ','મ્ક','મ્ખ','મ્ગ','મ્ઘ',
                                'મ્ઙ','મ્ચ','મ્છ','મ્જ','મ્ઝ','મ્ઞ','મ્ટ','મ્ઠ','મ્ડ','મ્ઢ','મ્ણ','મ્ત','મ્થ','મ્દ','મ્ધ','મ્ન','મ્પ','મ્ફ','મ્બ','મ્ભ',
                                'મ્મ','મ્ય','મ્ર','મ્લ','મ્ળ','મ્વ','મ્શ','મ્ષ','મ્સ','મ્હ','ય્ક','ય્ખ','ય્ગ','ય્ઘ','ય્ઙ','ય્ચ','ય્છ','ય્જ','ય્ઝ','ય્ઞ',
                                'ય્ટ','ય્ઠ','ય્ડ','ય્ઢ','ય્ણ','ય્ત','ય્થ','ય્દ','ય્ધ','ય્ન','ય્પ','ય્ફ','ય્બ','ય્ભ','ય્મ','ય્ય','ય્ર','ય્લ','ય્ળ','ય્વ',
                                'ય્શ','ય્ષ','ય્સ','ય્હ','ર્ક','ર્ખ','ર્ગ','ર્ઘ','ર્ઙ','ર્ચ','ર્છ','ર્જ','ર્ઝ','ર્ઞ','ર્ટ','ર્ઠ','ર્ડ','ર્ઢ','ર્ણ','ર્ત',
                                'ર્થ','ર્દ','ર્ધ','ર્ન','ર્પ','ર્ફ','ર્બ','ર્ભ','ર્મ','ર્ય','ર્ર','ર્લ','ર્ળ','ર્વ','ર્શ','ર્ષ','ર્સ','ર્હ','લ્ક','લ્ખ',
                                'લ્ગ','લ્ઘ','લ્ઙ','લ્ચ','લ્છ','લ્જ','લ્ઝ','લ્ઞ','લ્ટ','લ્ઠ','લ્ડ','લ્ઢ','લ્ણ','લ્ત','લ્થ','લ્દ','લ્ધ','લ્ન','લ્પ','લ્ફ',
                                'લ્બ','લ્ભ','લ્મ','લ્ય','લ્ર','લ્લ','લ્ળ','લ્વ','લ્શ','લ્ષ','લ્સ','લ્હ','ળ્ક','ળ્ખ','ળ્ગ','ળ્ઘ','ળ્ઙ','ળ્ચ','ળ્છ','ળ્જ',
                                'ળ્ઝ','ળ્ઞ','ળ્ટ','ળ્ઠ','ળ્ડ','ળ્ઢ','ળ્ણ','ળ્ત','ળ્થ','ળ્દ','ળ્ધ','ળ્ન','ળ્પ','ળ્ફ','ળ્બ','ળ્ભ','ળ્મ','ળ્ય','ળ્ર','ળ્લ',
                                'ળ્ળ','ળ્વ','ળ્શ','ળ્ષ','ળ્સ','ળ્હ','વ્ક','વ્ખ','વ્ગ','વ્ઘ','વ્ઙ','વ્ચ','વ્છ','વ્જ','વ્ઝ','વ્ઞ','વ્ટ','વ્ઠ','વ્ડ','વ્ઢ',
                                'વ્ણ','વ્ત','વ્થ','વ્દ','વ્ધ','વ્ન','વ્પ','વ્ફ','વ્બ','વ્ભ','વ્મ','વ્ય','વ્ર','વ્લ','વ્ળ','વ્વ','વ્શ','વ્ષ','વ્સ','વ્હ',
                                'શ્ક','શ્ખ','શ્ગ','શ્ઘ','શ્ઙ','શ્ચ','શ્છ','શ્જ','શ્ઝ','શ્ઞ','શ્ટ','શ્ઠ','શ્ડ','શ્ઢ','શ્ણ','શ્ત','શ્થ','શ્દ','શ્ધ','શ્ન',
                                'શ્પ','શ્ફ','શ્બ','શ્ભ','શ્મ','શ્ય','શ્ર','શ્લ','શ્ળ','શ્વ','શ્શ','શ્ષ','શ્સ','શ્હ','ષ્ક','ષ્ખ','ષ્ગ','ષ્ઘ','ષ્ઙ','ષ્ચ',
                                'ષ્છ','ષ્જ','ષ્ઝ','ષ્ઞ','ષ્ટ','ષ્ઠ','ષ્ડ','ષ્ઢ','ષ્ણ','ષ્ત','ષ્થ','ષ્દ','ષ્ધ','ષ્ન','ષ્પ','ષ્ફ','ષ્બ','ષ્ભ','ષ્મ','ષ્ય',
                                'ષ્ર','ષ્લ','ષ્ળ','ષ્વ','ષ્શ','ષ્ષ','ષ્સ','ષ્હ','સ્ક','સ્ખ','સ્ગ','સ્ઘ','સ્ઙ','સ્ચ','સ્છ','સ્જ','સ્ઝ','સ્ઞ','સ્ટ','સ્ઠ',
                                'સ્ડ','સ્ઢ','સ્ણ','સ્ત','સ્થ','સ્દ','સ્ધ','સ્ન','સ્પ','સ્ફ','સ્બ','સ્ભ','સ્મ','સ્ય','સ્ર','સ્લ','સ્ળ','સ્વ','સ્શ','સ્ષ',
                                'સ્સ','સ્હ','હ્ક','હ્ખ','હ્ગ','હ્ઘ','હ્ઙ','હ્ચ','હ્છ','હ્જ','હ્ઝ','હ્ઞ','હ્ટ','હ્ઠ','હ્ડ','હ્ઢ','હ્ણ','હ્ત','હ્થ','હ્દ',
                                'હ્ધ','હ્ન','હ્પ','હ્ફ','હ્બ','હ્ભ','હ્મ','હ્ય','હ્ર','હ્લ','હ્ળ','હ્વ','હ્શ','હ્ષ','હ્સ','હ્હ']
    # this is a customizeable map : this map is purely based on visual similiarity 

   
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
    
    nukta_map              =   {} # Can not find nukta added letter

    diacritic_map          =   {} # Can not find nukta added double sided diacritic
    #---------------------------------------------------normalization maps---------------------------------------------------------
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
class odiya:
    '''
        * vowel and consonant division according to : https://unicode-table.com/en/blocks/oriya/
        * consonant conjuncts according to: https://en.wikipedia.org/wiki/Odia_script
        * punctuations according to: https://github.com/BengaliAI/syntheticWords/blob/main/coreLib/languages.py
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "odiya"
    nukta                  =   '଼'
    vowels                 =   ['ଅ', 'ଆ', 'ଇ', 'ଈ', 'ଉ', 'ଊ', 'ଋ', 'ଌ', 'ଏ', 'ଐ', 'ଓ', 'ଔ','ୠ', 'ୡ']
    consonants             =   ['କ', 'ଖ', 'ଗ', 'ଘ', 'ଙ', 'ଚ', 'ଛ', 'ଜ', 'ଝ', 'ଞ', 'ଟ', 'ଠ', 'ଡ', 'ଢ', 'ଣ', 
                                'ତ', 'ଥ', 'ଦ', 'ଧ', 'ନ', 'ପ', 'ଫ', 'ବ', 'ଭ', 'ମ', 'ଯ', 'ର', 'ଲ', 'ଳ', 'ଵ', 
                                'ଶ', 'ଷ', 'ସ', 'ହ','ଡ଼', 'ଢ଼', 'ୟ','ୱ']
    vowel_diacritics       =   ['ା', 'ି', 'ୀ', 'ୁ', 'ୂ', 'ୃ', 'ୄ', 'େ', 'ୈ','ୋ', 'ୌ','ୢ', 'ୣ']
    consonant_diacritics   =   ['ଁ', 'ଂ', 'ଃ']
    numbers                =   ['୦', '୧', '୨', '୩', '୪', '୫', '୬', '୭', '୮', '୯']
    punctuations           =   [',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-'] 
    symbols                =   ['୲', '୳', '୴', '୵', '୶', '୷']
    connector              =   '୍'
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0b00', '\u0b04', '\u0b0d', '\u0b0e', '\u0b11', '\u0b12', '\u0b29', '\u0b31', '\u0b34', '\u0b3a', '\u0b3b', 
                                '\u0b45', '\u0b46', '\u0b49', '\u0b4a', '\u0b4e', '\u0b4f', '\u0b50', '\u0b51', '\u0b52', '\u0b53', '\u0b54', 
                                '\u0b58', '\u0b59', '\u0b5a', '\u0b5b', '\u0b5e', '\u0b64', '\u0b65', '\u0b78', '\u0b79', '\u0b7a', '\u0b7b', 
                                '\u0b7c', '\u0b7d', '\u0b7e', '\u0b7f']
    legacy_symbols         =   []  
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   ['କ୍କ','କ୍ଖ','କ୍ଗ','କ୍ଘ','କ୍ଙ','କ୍ଚ','କ୍ଛ','କ୍ଜ','କ୍ଝ','କ୍ଞ','କ୍ଟ','କ୍ଠ','କ୍ଡ','କ୍ଢ','କ୍ଣ','କ୍ତ','କ୍ଥ','କ୍ଦ','କ୍ଧ','କ୍ନ',
                                'କ୍ପ','କ୍ଫ','କ୍ବ','କ୍ଭ','କ୍ମ','କ୍ଯ','କ୍ୟ','କ୍ର','କ୍ଲ','କ୍ଳ','କ୍ୱ','କ୍ଶ','କ୍ଷ','କ୍ସ','କ୍ହ','ଖ୍କ','ଖ୍ଖ','ଖ୍ଗ','ଖ୍ଘ','ଖ୍ଙ',
                                'ଖ୍ଚ','ଖ୍ଛ','ଖ୍ଜ','ଖ୍ଝ','ଖ୍ଞ','ଖ୍ଟ','ଖ୍ଠ','ଖ୍ଡ','ଖ୍ଢ','ଖ୍ଣ','ଖ୍ତ','ଖ୍ଥ','ଖ୍ଦ','ଖ୍ଧ','ଖ୍ନ','ଖ୍ପ','ଖ୍ଫ','ଖ୍ବ','ଖ୍ଭ','ଖ୍ମ',
                                'ଖ୍ଯ','ଖ୍ୟ','ଖ୍ର','ଖ୍ଲ','ଖ୍ଳ','ଖ୍ୱ','ଖ୍ଶ','ଖ୍ଷ','ଖ୍ସ','ଖ୍ହ','ଗ୍କ','ଗ୍ଖ','ଗ୍ଗ','ଗ୍ଘ','ଗ୍ଙ','ଗ୍ଚ','ଗ୍ଛ','ଗ୍ଜ','ଗ୍ଝ','ଗ୍ଞ',
                                'ଗ୍ଟ','ଗ୍ଠ','ଗ୍ଡ','ଗ୍ଢ','ଗ୍ଣ','ଗ୍ତ','ଗ୍ଥ','ଗ୍ଦ','ଗ୍ଧ','ଗ୍ନ','ଗ୍ପ','ଗ୍ଫ','ଗ୍ବ','ଗ୍ଭ','ଗ୍ମ','ଗ୍ଯ','ଗ୍ୟ','ଗ୍ର','ଗ୍ଲ','ଗ୍ଳ',
                                'ଗ୍ୱ','ଗ୍ଶ','ଗ୍ଷ','ଗ୍ସ','ଗ୍ହ','ଘ୍କ','ଘ୍ଖ','ଘ୍ଗ','ଘ୍ଘ','ଘ୍ଙ','ଘ୍ଚ','ଘ୍ଛ','ଘ୍ଜ','ଘ୍ଝ','ଘ୍ଞ','ଘ୍ଟ','ଘ୍ଠ','ଘ୍ଡ','ଘ୍ଢ','ଘ୍ଣ',
                                'ଘ୍ତ','ଘ୍ଥ','ଘ୍ଦ','ଘ୍ଧ','ଘ୍ନ','ଘ୍ପ','ଘ୍ଫ','ଘ୍ବ','ଘ୍ଭ','ଘ୍ମ','ଘ୍ଯ','ଘ୍ୟ','ଘ୍ର','ଘ୍ଲ','ଘ୍ଳ','ଘ୍ୱ','ଘ୍ଶ','ଘ୍ଷ','ଘ୍ସ','ଘ୍ହ',
                                'ଙ୍କ','ଙ୍ଖ','ଙ୍ଗ','ଙ୍ଘ','ଙ୍ଙ','ଙ୍ଚ','ଙ୍ଛ','ଙ୍ଜ','ଙ୍ଝ','ଙ୍ଞ','ଙ୍ଟ','ଙ୍ଠ','ଙ୍ଡ','ଙ୍ଢ','ଙ୍ଣ','ଙ୍ତ','ଙ୍ଥ','ଙ୍ଦ','ଙ୍ଧ','ଙ୍ନ',
                                'ଙ୍ପ','ଙ୍ଫ','ଙ୍ବ','ଙ୍ଭ','ଙ୍ମ','ଙ୍ଯ','ଙ୍ୟ','ଙ୍ର','ଙ୍ଲ','ଙ୍ଳ','ଙ୍ୱ','ଙ୍ଶ','ଙ୍ଷ','ଙ୍ସ','ଙ୍ହ','ଚ୍କ','ଚ୍ଖ','ଚ୍ଗ','ଚ୍ଘ','ଚ୍ଙ',
                                'ଚ୍ଚ','ଚ୍ଛ','ଚ୍ଜ','ଚ୍ଝ','ଚ୍ଞ','ଚ୍ଟ','ଚ୍ଠ','ଚ୍ଡ','ଚ୍ଢ','ଚ୍ଣ','ଚ୍ତ','ଚ୍ଥ','ଚ୍ଦ','ଚ୍ଧ','ଚ୍ନ','ଚ୍ପ','ଚ୍ଫ','ଚ୍ବ','ଚ୍ଭ','ଚ୍ମ',
                                'ଚ୍ଯ','ଚ୍ୟ','ଚ୍ର','ଚ୍ଲ','ଚ୍ଳ','ଚ୍ୱ','ଚ୍ଶ','ଚ୍ଷ','ଚ୍ସ','ଚ୍ହ','ଛ୍କ','ଛ୍ଖ','ଛ୍ଗ','ଛ୍ଘ','ଛ୍ଙ','ଛ୍ଚ','ଛ୍ଛ','ଛ୍ଜ','ଛ୍ଝ','ଛ୍ଞ',
                                'ଛ୍ଟ','ଛ୍ଠ','ଛ୍ଡ','ଛ୍ଢ','ଛ୍ଣ','ଛ୍ତ','ଛ୍ଥ','ଛ୍ଦ','ଛ୍ଧ','ଛ୍ନ','ଛ୍ପ','ଛ୍ଫ','ଛ୍ବ','ଛ୍ଭ','ଛ୍ମ','ଛ୍ଯ','ଛ୍ୟ','ଛ୍ର','ଛ୍ଲ','ଛ୍ଳ',
                                'ଛ୍ୱ','ଛ୍ଶ','ଛ୍ଷ','ଛ୍ସ','ଛ୍ହ','ଜ୍କ','ଜ୍ଖ','ଜ୍ଗ','ଜ୍ଘ','ଜ୍ଙ','ଜ୍ଚ','ଜ୍ଛ','ଜ୍ଜ','ଜ୍ଝ','ଜ୍ଞ','ଜ୍ଟ','ଜ୍ଠ','ଜ୍ଡ','ଜ୍ଢ','ଜ୍ଣ',
                                'ଜ୍ତ','ଜ୍ଥ','ଜ୍ଦ','ଜ୍ଧ','ଜ୍ନ','ଜ୍ପ','ଜ୍ଫ','ଜ୍ବ','ଜ୍ଭ','ଜ୍ମ','ଜ୍ଯ','ଜ୍ୟ','ଜ୍ର','ଜ୍ଲ','ଜ୍ଳ','ଜ୍ୱ','ଜ୍ଶ','ଜ୍ଷ','ଜ୍ସ','ଜ୍ହ',
                                'ଝ୍କ','ଝ୍ଖ','ଝ୍ଗ','ଝ୍ଘ','ଝ୍ଙ','ଝ୍ଚ','ଝ୍ଛ','ଝ୍ଜ','ଝ୍ଝ','ଝ୍ଞ','ଝ୍ଟ','ଝ୍ଠ','ଝ୍ଡ','ଝ୍ଢ','ଝ୍ଣ','ଝ୍ତ','ଝ୍ଥ','ଝ୍ଦ','ଝ୍ଧ','ଝ୍ନ',
                                'ଝ୍ପ','ଝ୍ଫ','ଝ୍ବ','ଝ୍ଭ','ଝ୍ମ','ଝ୍ଯ','ଝ୍ୟ','ଝ୍ର','ଝ୍ଲ','ଝ୍ଳ','ଝ୍ୱ','ଝ୍ଶ','ଝ୍ଷ','ଝ୍ସ','ଝ୍ହ','ଞ୍କ','ଞ୍ଖ','ଞ୍ଗ','ଞ୍ଘ','ଞ୍ଙ',
                                'ଞ୍ଚ','ଞ୍ଛ','ଞ୍ଜ','ଞ୍ଝ','ଞ୍ଞ','ଞ୍ଟ','ଞ୍ଠ','ଞ୍ଡ','ଞ୍ଢ','ଞ୍ଣ','ଞ୍ତ','ଞ୍ଥ','ଞ୍ଦ','ଞ୍ଧ','ଞ୍ନ','ଞ୍ପ','ଞ୍ଫ','ଞ୍ବ','ଞ୍ଭ','ଞ୍ମ',
                                'ଞ୍ଯ','ଞ୍ୟ','ଞ୍ର','ଞ୍ଲ','ଞ୍ଳ','ଞ୍ୱ','ଞ୍ଶ','ଞ୍ଷ','ଞ୍ସ','ଞ୍ହ','ଟ୍କ','ଟ୍ଖ','ଟ୍ଗ','ଟ୍ଘ','ଟ୍ଙ','ଟ୍ଚ','ଟ୍ଛ','ଟ୍ଜ','ଟ୍ଝ','ଟ୍ଞ',
                                'ଟ୍ଟ','ଟ୍ଠ','ଟ୍ଡ','ଟ୍ଢ','ଟ୍ଣ','ଟ୍ତ','ଟ୍ଥ','ଟ୍ଦ','ଟ୍ଧ','ଟ୍ନ','ଟ୍ପ','ଟ୍ଫ','ଟ୍ବ','ଟ୍ଭ','ଟ୍ମ','ଟ୍ଯ','ଟ୍ୟ','ଟ୍ର','ଟ୍ଲ','ଟ୍ଳ',
                                'ଟ୍ୱ','ଟ୍ଶ','ଟ୍ଷ','ଟ୍ସ','ଟ୍ହ','ଠ୍କ','ଠ୍ଖ','ଠ୍ଗ','ଠ୍ଘ','ଠ୍ଙ','ଠ୍ଚ','ଠ୍ଛ','ଠ୍ଜ','ଠ୍ଝ','ଠ୍ଞ','ଠ୍ଟ','ଠ୍ଠ','ଠ୍ଡ','ଠ୍ଢ','ଠ୍ଣ',
                                'ଠ୍ତ','ଠ୍ଥ','ଠ୍ଦ','ଠ୍ଧ','ଠ୍ନ','ଠ୍ପ','ଠ୍ଫ','ଠ୍ବ','ଠ୍ଭ','ଠ୍ମ','ଠ୍ଯ','ଠ୍ୟ','ଠ୍ର','ଠ୍ଲ','ଠ୍ଳ','ଠ୍ୱ','ଠ୍ଶ','ଠ୍ଷ','ଠ୍ସ','ଠ୍ହ',
                                'ଡ୍କ','ଡ୍ଖ','ଡ୍ଗ','ଡ୍ଘ','ଡ୍ଙ','ଡ୍ଚ','ଡ୍ଛ','ଡ୍ଜ','ଡ୍ଝ','ଡ୍ଞ','ଡ୍ଟ','ଡ୍ଠ','ଡ୍ଡ','ଡ୍ଢ','ଡ୍ଣ','ଡ୍ତ','ଡ୍ଥ','ଡ୍ଦ','ଡ୍ଧ','ଡ୍ନ',
                                'ଡ୍ପ','ଡ୍ଫ','ଡ୍ବ','ଡ୍ଭ','ଡ୍ମ','ଡ୍ଯ','ଡ୍ୟ','ଡ୍ର','ଡ୍ଲ','ଡ୍ଳ','ଡ୍ୱ','ଡ୍ଶ','ଡ୍ଷ','ଡ୍ସ','ଡ୍ହ','ଢ୍କ','ଢ୍ଖ','ଢ୍ଗ','ଢ୍ଘ','ଢ୍ଙ',
                                'ଢ୍ଚ','ଢ୍ଛ','ଢ୍ଜ','ଢ୍ଝ','ଢ୍ଞ','ଢ୍ଟ','ଢ୍ଠ','ଢ୍ଡ','ଢ୍ଢ','ଢ୍ଣ','ଢ୍ତ','ଢ୍ଥ','ଢ୍ଦ','ଢ୍ଧ','ଢ୍ନ','ଢ୍ପ','ଢ୍ଫ','ଢ୍ବ','ଢ୍ଭ','ଢ୍ମ',
                                'ଢ୍ଯ','ଢ୍ୟ','ଢ୍ର','ଢ୍ଲ','ଢ୍ଳ','ଢ୍ୱ','ଢ୍ଶ','ଢ୍ଷ','ଢ୍ସ','ଢ୍ହ','ଣ୍କ','ଣ୍ଖ','ଣ୍ଗ','ଣ୍ଘ','ଣ୍ଙ','ଣ୍ଚ','ଣ୍ଛ','ଣ୍ଜ','ଣ୍ଝ','ଣ୍ଞ',
                                'ଣ୍ଟ','ଣ୍ଠ','ଣ୍ଡ','ଣ୍ଢ','ଣ୍ଣ','ଣ୍ତ','ଣ୍ଥ','ଣ୍ଦ','ଣ୍ଧ','ଣ୍ନ','ଣ୍ପ','ଣ୍ଫ','ଣ୍ବ','ଣ୍ଭ','ଣ୍ମ','ଣ୍ଯ','ଣ୍ୟ','ଣ୍ର','ଣ୍ଲ','ଣ୍ଳ',
                                'ଣ୍ୱ','ଣ୍ଶ','ଣ୍ଷ','ଣ୍ସ','ଣ୍ହ','ତ୍କ','ତ୍ଖ','ତ୍ଗ','ତ୍ଘ','ତ୍ଙ','ତ୍ଚ','ତ୍ଛ','ତ୍ଜ','ତ୍ଝ','ତ୍ଞ','ତ୍ଟ','ତ୍ଠ','ତ୍ଡ','ତ୍ଢ','ତ୍ଣ',
                                'ତ୍ତ','ତ୍ଥ','ତ୍ଦ','ତ୍ଧ','ତ୍ନ','ତ୍ପ','ତ୍ଫ','ତ୍ବ','ତ୍ଭ','ତ୍ମ','ତ୍ଯ','ତ୍ୟ','ତ୍ର','ତ୍ଲ','ତ୍ଳ','ତ୍ୱ','ତ୍ଶ','ତ୍ଷ','ତ୍ସ','ତ୍ହ',
                                'ଥ୍କ','ଥ୍ଖ','ଥ୍ଗ','ଥ୍ଘ','ଥ୍ଙ','ଥ୍ଚ','ଥ୍ଛ','ଥ୍ଜ','ଥ୍ଝ','ଥ୍ଞ','ଥ୍ଟ','ଥ୍ଠ','ଥ୍ଡ','ଥ୍ଢ','ଥ୍ଣ','ଥ୍ତ','ଥ୍ଥ','ଥ୍ଦ','ଥ୍ଧ','ଥ୍ନ',
                                'ଥ୍ପ','ଥ୍ଫ','ଥ୍ବ','ଥ୍ଭ','ଥ୍ମ','ଥ୍ଯ','ଥ୍ୟ','ଥ୍ର','ଥ୍ଲ','ଥ୍ଳ','ଥ୍ୱ','ଥ୍ଶ','ଥ୍ଷ','ଥ୍ସ','ଥ୍ହ','ଦ୍କ','ଦ୍ଖ','ଦ୍ଗ','ଦ୍ଘ','ଦ୍ଙ',
                                'ଦ୍ଚ','ଦ୍ଛ','ଦ୍ଜ','ଦ୍ଝ','ଦ୍ଞ','ଦ୍ଟ','ଦ୍ଠ','ଦ୍ଡ','ଦ୍ଢ','ଦ୍ଣ','ଦ୍ତ','ଦ୍ଥ','ଦ୍ଦ','ଦ୍ଧ','ଦ୍ନ','ଦ୍ପ','ଦ୍ଫ','ଦ୍ବ','ଦ୍ଭ','ଦ୍ମ',
                                'ଦ୍ଯ','ଦ୍ୟ','ଦ୍ର','ଦ୍ଲ','ଦ୍ଳ','ଦ୍ୱ','ଦ୍ଶ','ଦ୍ଷ','ଦ୍ସ','ଦ୍ହ','ଧ୍କ','ଧ୍ଖ','ଧ୍ଗ','ଧ୍ଘ','ଧ୍ଙ','ଧ୍ଚ','ଧ୍ଛ','ଧ୍ଜ','ଧ୍ଝ','ଧ୍ଞ',
                                'ଧ୍ଟ','ଧ୍ଠ','ଧ୍ଡ','ଧ୍ଢ','ଧ୍ଣ','ଧ୍ତ','ଧ୍ଥ','ଧ୍ଦ','ଧ୍ଧ','ଧ୍ନ','ଧ୍ପ','ଧ୍ଫ','ଧ୍ବ','ଧ୍ଭ','ଧ୍ମ','ଧ୍ଯ','ଧ୍ୟ','ଧ୍ର','ଧ୍ଲ','ଧ୍ଳ',
                                'ଧ୍ୱ','ଧ୍ଶ','ଧ୍ଷ','ଧ୍ସ','ଧ୍ହ','ନ୍କ','ନ୍ଖ','ନ୍ଗ','ନ୍ଘ','ନ୍ଙ','ନ୍ଚ','ନ୍ଛ','ନ୍ଜ','ନ୍ଝ','ନ୍ଞ','ନ୍ଟ','ନ୍ଠ','ନ୍ଡ','ନ୍ଢ','ନ୍ଣ',
                                'ନ୍ତ','ନ୍ଥ','ନ୍ଦ','ନ୍ଧ','ନ୍ନ','ନ୍ପ','ନ୍ଫ','ନ୍ବ','ନ୍ଭ','ନ୍ମ','ନ୍ଯ','ନ୍ୟ','ନ୍ର','ନ୍ଲ','ନ୍ଳ','ନ୍ୱ','ନ୍ଶ','ନ୍ଷ','ନ୍ସ','ନ୍ହ',
                                'ପ୍କ','ପ୍ଖ','ପ୍ଗ','ପ୍ଘ','ପ୍ଙ','ପ୍ଚ','ପ୍ଛ','ପ୍ଜ','ପ୍ଝ','ପ୍ଞ','ପ୍ଟ','ପ୍ଠ','ପ୍ଡ','ପ୍ଢ','ପ୍ଣ','ପ୍ତ','ପ୍ଥ','ପ୍ଦ','ପ୍ଧ','ପ୍ନ',
                                'ପ୍ପ','ପ୍ଫ','ପ୍ବ','ପ୍ଭ','ପ୍ମ','ପ୍ଯ','ପ୍ୟ','ପ୍ର','ପ୍ଲ','ପ୍ଳ','ପ୍ୱ','ପ୍ଶ','ପ୍ଷ','ପ୍ସ','ପ୍ହ','ଫ୍କ','ଫ୍ଖ','ଫ୍ଗ','ଫ୍ଘ','ଫ୍ଙ',
                                'ଫ୍ଚ','ଫ୍ଛ','ଫ୍ଜ','ଫ୍ଝ','ଫ୍ଞ','ଫ୍ଟ','ଫ୍ଠ','ଫ୍ଡ','ଫ୍ଢ','ଫ୍ଣ','ଫ୍ତ','ଫ୍ଥ','ଫ୍ଦ','ଫ୍ଧ','ଫ୍ନ','ଫ୍ପ','ଫ୍ଫ','ଫ୍ବ','ଫ୍ଭ','ଫ୍ମ',
                                'ଫ୍ଯ','ଫ୍ୟ','ଫ୍ର','ଫ୍ଲ','ଫ୍ଳ','ଫ୍ୱ','ଫ୍ଶ','ଫ୍ଷ','ଫ୍ସ','ଫ୍ହ','ବ୍କ','ବ୍ଖ','ବ୍ଗ','ବ୍ଘ','ବ୍ଙ','ବ୍ଚ','ବ୍ଛ','ବ୍ଜ','ବ୍ଝ','ବ୍ଞ',
                                'ବ୍ଟ','ବ୍ଠ','ବ୍ଡ','ବ୍ଢ','ବ୍ଣ','ବ୍ତ','ବ୍ଥ','ବ୍ଦ','ବ୍ଧ','ବ୍ନ','ବ୍ପ','ବ୍ଫ','ବ୍ବ','ବ୍ଭ','ବ୍ମ','ବ୍ଯ','ବ୍ୟ','ବ୍ର','ବ୍ଲ','ବ୍ଳ',
                                'ବ୍ୱ','ବ୍ଶ','ବ୍ଷ','ବ୍ସ','ବ୍ହ','ଭ୍କ','ଭ୍ଖ','ଭ୍ଗ','ଭ୍ଘ','ଭ୍ଙ','ଭ୍ଚ','ଭ୍ଛ','ଭ୍ଜ','ଭ୍ଝ','ଭ୍ଞ','ଭ୍ଟ','ଭ୍ଠ','ଭ୍ଡ','ଭ୍ଢ','ଭ୍ଣ',
                                'ଭ୍ତ','ଭ୍ଥ','ଭ୍ଦ','ଭ୍ଧ','ଭ୍ନ','ଭ୍ପ','ଭ୍ଫ','ଭ୍ବ','ଭ୍ଭ','ଭ୍ମ','ଭ୍ଯ','ଭ୍ୟ','ଭ୍ର','ଭ୍ଲ','ଭ୍ଳ','ଭ୍ୱ','ଭ୍ଶ','ଭ୍ଷ','ଭ୍ସ','ଭ୍ହ',
                                'ମ୍କ','ମ୍ଖ','ମ୍ଗ','ମ୍ଘ','ମ୍ଙ','ମ୍ଚ','ମ୍ଛ','ମ୍ଜ','ମ୍ଝ','ମ୍ଞ','ମ୍ଟ','ମ୍ଠ','ମ୍ଡ','ମ୍ଢ','ମ୍ଣ','ମ୍ତ','ମ୍ଥ','ମ୍ଦ','ମ୍ଧ','ମ୍ନ',
                                'ମ୍ପ','ମ୍ଫ','ମ୍ବ','ମ୍ଭ','ମ୍ମ','ମ୍ଯ','ମ୍ୟ','ମ୍ର','ମ୍ଲ','ମ୍ଳ','ମ୍ୱ','ମ୍ଶ','ମ୍ଷ','ମ୍ସ','ମ୍ହ','ଯ୍କ','ଯ୍ଖ','ଯ୍ଗ','ଯ୍ଘ','ଯ୍ଙ',
                                'ଯ୍ଚ','ଯ୍ଛ','ଯ୍ଜ','ଯ୍ଝ','ଯ୍ଞ','ଯ୍ଟ','ଯ୍ଠ','ଯ୍ଡ','ଯ୍ଢ','ଯ୍ଣ','ଯ୍ତ','ଯ୍ଥ','ଯ୍ଦ','ଯ୍ଧ','ଯ୍ନ','ଯ୍ପ','ଯ୍ଫ','ଯ୍ବ','ଯ୍ଭ','ଯ୍ମ',
                                'ଯ୍ଯ','ଯ୍ୟ','ଯ୍ର','ଯ୍ଲ','ଯ୍ଳ','ଯ୍ୱ','ଯ୍ଶ','ଯ୍ଷ','ଯ୍ସ','ଯ୍ହ','ୟ୍କ','ୟ୍ଖ','ୟ୍ଗ','ୟ୍ଘ','ୟ୍ଙ','ୟ୍ଚ','ୟ୍ଛ','ୟ୍ଜ','ୟ୍ଝ','ୟ୍ଞ',
                                'ୟ୍ଟ','ୟ୍ଠ','ୟ୍ଡ','ୟ୍ଢ','ୟ୍ଣ','ୟ୍ତ','ୟ୍ଥ','ୟ୍ଦ','ୟ୍ଧ','ୟ୍ନ','ୟ୍ପ','ୟ୍ଫ','ୟ୍ବ','ୟ୍ଭ','ୟ୍ମ','ୟ୍ଯ','ୟ୍ୟ','ୟ୍ର','ୟ୍ଲ','ୟ୍ଳ',
                                'ୟ୍ୱ','ୟ୍ଶ','ୟ୍ଷ','ୟ୍ସ','ୟ୍ହ','ର୍କ','ର୍ଖ','ର୍ଗ','ର୍ଘ','ର୍ଙ','ର୍ଚ','ର୍ଛ','ର୍ଜ','ର୍ଝ','ର୍ଞ','ର୍ଟ','ର୍ଠ','ର୍ଡ','ର୍ଢ','ର୍ଣ',
                                'ର୍ତ','ର୍ଥ','ର୍ଦ','ର୍ଧ','ର୍ନ','ର୍ପ','ର୍ଫ','ର୍ବ','ର୍ଭ','ର୍ମ','ର୍ଯ','ର୍ୟ','ର୍ର','ର୍ଲ','ର୍ଳ','ର୍ୱ','ର୍ଶ','ର୍ଷ','ର୍ସ','ର୍ହ',
                                'ଲ୍କ','ଲ୍ଖ','ଲ୍ଗ','ଲ୍ଘ','ଲ୍ଙ','ଲ୍ଚ','ଲ୍ଛ','ଲ୍ଜ','ଲ୍ଝ','ଲ୍ଞ','ଲ୍ଟ','ଲ୍ଠ','ଲ୍ଡ','ଲ୍ଢ','ଲ୍ଣ','ଲ୍ତ','ଲ୍ଥ','ଲ୍ଦ','ଲ୍ଧ','ଲ୍ନ',
                                'ଲ୍ପ','ଲ୍ଫ','ଲ୍ବ','ଲ୍ଭ','ଲ୍ମ','ଲ୍ଯ','ଲ୍ୟ','ଲ୍ର','ଲ୍ଲ','ଲ୍ଳ','ଲ୍ୱ','ଲ୍ଶ','ଲ୍ଷ','ଲ୍ସ','ଲ୍ହ','ଳ୍କ','ଳ୍ଖ','ଳ୍ଗ','ଳ୍ଘ','ଳ୍ଙ',
                                'ଳ୍ଚ','ଳ୍ଛ','ଳ୍ଜ','ଳ୍ଝ','ଳ୍ଞ','ଳ୍ଟ','ଳ୍ଠ','ଳ୍ଡ','ଳ୍ଢ','ଳ୍ଣ','ଳ୍ତ','ଳ୍ଥ','ଳ୍ଦ','ଳ୍ଧ','ଳ୍ନ','ଳ୍ପ','ଳ୍ଫ','ଳ୍ବ','ଳ୍ଭ','ଳ୍ମ',
                                'ଳ୍ଯ','ଳ୍ୟ','ଳ୍ର','ଳ୍ଲ','ଳ୍ଳ','ଳ୍ୱ','ଳ୍ଶ','ଳ୍ଷ','ଳ୍ସ','ଳ୍ହ','ୱ୍କ','ୱ୍ଖ','ୱ୍ଗ','ୱ୍ଘ','ୱ୍ଙ','ୱ୍ଚ','ୱ୍ଛ','ୱ୍ଜ','ୱ୍ଝ','ୱ୍ଞ',
                                'ୱ୍ଟ','ୱ୍ଠ','ୱ୍ଡ','ୱ୍ଢ','ୱ୍ଣ','ୱ୍ତ','ୱ୍ଥ','ୱ୍ଦ','ୱ୍ଧ','ୱ୍ନ','ୱ୍ପ','ୱ୍ଫ','ୱ୍ବ','ୱ୍ଭ','ୱ୍ମ','ୱ୍ଯ','ୱ୍ୟ','ୱ୍ର','ୱ୍ଲ','ୱ୍ଳ',
                                'ୱ୍ୱ','ୱ୍ଶ','ୱ୍ଷ','ୱ୍ସ','ୱ୍ହ','ଶ୍କ','ଶ୍ଖ','ଶ୍ଗ','ଶ୍ଘ','ଶ୍ଙ','ଶ୍ଚ','ଶ୍ଛ','ଶ୍ଜ','ଶ୍ଝ','ଶ୍ଞ','ଶ୍ଟ','ଶ୍ଠ','ଶ୍ଡ','ଶ୍ଢ','ଶ୍ଣ',
                                'ଶ୍ତ','ଶ୍ଥ','ଶ୍ଦ','ଶ୍ଧ','ଶ୍ନ','ଶ୍ପ','ଶ୍ଫ','ଶ୍ବ','ଶ୍ଭ','ଶ୍ମ','ଶ୍ଯ','ଶ୍ୟ','ଶ୍ର','ଶ୍ଲ','ଶ୍ଳ','ଶ୍ୱ','ଶ୍ଶ','ଶ୍ଷ','ଶ୍ସ','ଶ୍ହ',
                                'ଷ୍କ','ଷ୍ଖ','ଷ୍ଗ','ଷ୍ଘ','ଷ୍ଙ','ଷ୍ଚ','ଷ୍ଛ','ଷ୍ଜ','ଷ୍ଝ','ଷ୍ଞ','ଷ୍ଟ','ଷ୍ଠ','ଷ୍ଡ','ଷ୍ଢ','ଷ୍ଣ','ଷ୍ତ','ଷ୍ଥ','ଷ୍ଦ','ଷ୍ଧ','ଷ୍ନ',
                                'ଷ୍ପ','ଷ୍ଫ','ଷ୍ବ','ଷ୍ଭ','ଷ୍ମ','ଷ୍ଯ','ଷ୍ୟ','ଷ୍ର','ଷ୍ଲ','ଷ୍ଳ','ଷ୍ୱ','ଷ୍ଶ','ଷ୍ଷ','ଷ୍ସ','ଷ୍ହ','ସ୍କ','ସ୍ଖ','ସ୍ଗ','ସ୍ଘ','ସ୍ଙ',
                                'ସ୍ଚ','ସ୍ଛ','ସ୍ଜ','ସ୍ଝ','ସ୍ଞ','ସ୍ଟ','ସ୍ଠ','ସ୍ଡ','ସ୍ଢ','ସ୍ଣ','ସ୍ତ','ସ୍ଥ','ସ୍ଦ','ସ୍ଧ','ସ୍ନ','ସ୍ପ','ସ୍ଫ','ସ୍ବ','ସ୍ଭ','ସ୍ମ',
                                'ସ୍ଯ','ସ୍ୟ','ସ୍ର','ସ୍ଲ','ସ୍ଳ','ସ୍ୱ','ସ୍ଶ','ସ୍ଷ','ସ୍ସ','ସ୍ହ','ହ୍କ','ହ୍ଖ','ହ୍ଗ','ହ୍ଘ','ହ୍ଙ','ହ୍ଚ','ହ୍ଛ','ହ୍ଜ','ହ୍ଝ','ହ୍ଞ',
                                'ହ୍ଟ','ହ୍ଠ','ହ୍ଡ','ହ୍ଢ','ହ୍ଣ','ହ୍ତ','ହ୍ଥ','ହ୍ଦ','ହ୍ଧ','ହ୍ନ','ହ୍ପ','ହ୍ଫ','ହ୍ବ','ହ୍ଭ','ହ୍ମ','ହ୍ଯ','ହ୍ୟ','ହ୍ର','ହ୍ଲ','ହ୍ଳ',
                                'ହ୍ୱ','ହ୍ଶ','ହ୍ଷ','ହ୍ସ','ହ୍ହ']
    
    # this is a customizeable map : this map is purely based on visual similiarity 
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
    nukta_map              =   {'ଡ':'ଡ଼',
                                'ଢ':'ଢ଼'}
     
    diacritic_map          =   {'ୋ':'ୋ',
                                'ୈା':'ୌ'}
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
        
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------

class tamil:
    '''
        * vowel and consonant division according to : https://unicode-table.com/en/blocks/tamil/
        * consonant conjuncts according to: https://en.wikipedia.org/wiki/Tamil_script
        * punctuations according to: https://github.com/BengaliAI/syntheticWords/blob/main/coreLib/languages.py
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "tamil"
    nukta                  =   ''  
    vowels                 =   ['அ', 'ஆ', 'இ', 'ஈ', 'உ', 'ஊ', 'எ', 'ஏ', 'ஐ', 'ஒ', 'ஓ', 'ஔ']
    consonants             =   ['க', 'ங', 'ச', 'ஜ', 'ஞ', 'ட', 'ண', 'த', 'ந', 'ன', 'ப', 'ம', 'ய', 'ர', 'ற', 'ல', 'ள', 'ழ', 'வ', 'ஶ', 'ஷ', 'ஸ', 'ஹ']
    vowel_diacritics       =   ['ா', 'ி', 'ீ', 'ு', 'ூ', 'ெ', 'ே', 'ை','ொ', 'ோ', 'ௌ']
    consonant_diacritics   =   ['ஂ', 'ஃ']
    numbers                =   ['௦', '௧', '௨', '௩', '௪', '௫', '௬', '௭', '௮', '௯','௰', '௱', '௲']
    punctuations           =   [',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-']
    symbols                =   ['௳', '௴', '௵','௹','௶', '௷', '௸','௺']
    connector              =   '்' 
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0b80', '\u0b81', '\u0b84', '\u0b8b', '\u0b8c', '\u0b8d', '\u0b91', '\u0b96', '\u0b97', '\u0b98', '\u0b9b', 
                                '\u0b9d', '\u0ba0', '\u0ba1', '\u0ba2', '\u0ba5', '\u0ba6', '\u0ba7', '\u0bab', '\u0bac', '\u0bad', '\u0bba', 
                                '\u0bbb', '\u0bbc', '\u0bbd', '\u0bc3', '\u0bc4', '\u0bc5', '\u0bc9', '\u0bce', '\u0bcf', '\u0bd8', '\u0bd9', 
                                '\u0bda', '\u0bdb', '\u0bdc', '\u0bdd', '\u0bde', '\u0bdf', '\u0be0', '\u0be1', '\u0be2', '\u0be3', '\u0bd1', 
                                '\u0bd2', '\u0bd3', '\u0bd4', '\u0bd5', '\u0bd6', '\u0bd8', '\u0bd9', '\u0bda', '\u0bdb', '\u0bdc', '\u0bdd', 
                                '\u0bde', '\u0bdf', '\u0be0', '\u0be1', '\u0be2', '\u0be3', '\u0be4', '\u0be5', '\u0bfb', '\u0bfc', '\u0bfd', 
                                '\u0bfe', '\u0bff']
    legacy_symbols         =   []  
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   ['க்','க','கா','கி','கீ','கு','கூ','கெ','கே','கை','கொ','கோ','கௌ','ங்','ங','ஙா','ஙி','ஙீ','ஙு','ஙூ',
                                'ஙெ','ஙே','ஙை','ஙொ','ஙோ','ஙௌ','ச்','ச','சா','சி','சீ','சு','சூ','செ','சே','சை','சொ','சோ','சௌ','ஞ்',
                                'ஞ','ஞா','ஞி','ஞீ','ஞு','ஞூ','ஞெ','ஞே','ஞை','ஞொ','ஞோ','ஞௌ','ட்','ட','டா','டி','டீ','டு','டூ','டெ',
                                'டே','டை','டொ','டோ','டௌ','ண்','ண','ணா','ணி','ணீ','ணு','ணூ','ணெ','ணே','ணை','ணொ','ணோ','ணௌ','த்','த',
                                'தா','தி','தீ','து','தூ','தெ','தே','தை','தொ','தோ','தௌ','ந்','ந','நா','நி','நீ','நு','நூ','நெ','நே',
                                'நை','நொ','நோ','நௌ','ப்','ப','பா','பி','பீ','பு','பூ','பெ','பே','பை','பொ','போ','பௌ','ம்','ம','மா',
                                'மி','மீ','மு','மூ','மெ','மே','மை','மொ','மோ','மௌ','ய்','ய','யா','யி','யீ','யு','யூ','யெ','யே','யை',
                                'யொ','யோ','யௌ','ர்','ர','ரா','ரி','ரீ','ரு','ரூ','ரெ','ரே','ரை','ரொ','ரோ','ரௌ','ல்','ல','லா','லி',
                                'லீ','லு','லூ','லெ','லே','லை','லொ','லோ','லௌ','வ்','வ','வா','வி','வீ','வு','வூ','வெ','வே','வை','வொ',
                                'வோ','வௌ','ழ்','ழ','ழா','ழி','ழீ','ழு','ழூ','ழெ','ழே','ழை','ழொ','ழோ','ழௌ','ள்','ள','ளா','ளி','ளீ',
                                'ளு','ளூ','ளெ','ளே','ளை','ளொ','ளோ','ளௌ','ற்','ற','றா','றி','றீ','று','றூ','றெ','றே','றை','றொ','றோ',
                                'றௌ','ன்','ன','னா','னி','னீ','னு','னூ','னெ','னே','னை','னொ','னோ','னௌ','ஶ்','ஶ','ஶா','ஶி','ஶீ','ஶு',
                                'ஶூ','ஶெ','ஶே','ஶை','ஶொ','ஶோ','ஶௌ','ஜ்','ஜ','ஜா','ஜி','ஜீ','ஜு','ஜூ','ஜெ','ஜே','ஜை','ஜொ','ஜோ','ஜௌ',
                                'ஷ்','ஷ','ஷா','ஷி','ஷீ','ஷு','ஷூ','ஷெ','ஷே','ஷை','ஷொ','ஷோ','ஷௌ','ஸ்','ஸ','ஸா','ஸி','ஸீ','ஸு','ஸூ',
                                'ஸெ','ஸே','ஸை','ஸொ','ஸோ','ஸௌ','ஹ்','ஹ','ஹா','ஹி','ஹீ','ஹு','ஹூ','ஹெ','ஹே','ஹை','ஹொ','ஹோ','ஹௌ','க்ஷ்',
                                'க்ஷ','க்ஷா','க்ஷி','க்ஷீ','க்ஷு','க்ஷூ','க்ஷெ','க்ஷே','க்ஷை','க்ஷொ','க்ஷோ','க்ஷெள']
    # this is a customizeable map : this map is purely based on visual similiarity 
     
    legacy_maps            =   {}
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
     
    nukta_map              =   {}
     
    diacritic_map          =   {'ொ':'ொ',
                                "ோ":'ோ'} 
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
        
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
class panjabi:
    '''
        * vowel and consonant division according to : https://unicode-table.com/en/blocks/gurmukhi/
        * consonant conjuncts according to: NOT USED
        * punctuations according to: https://github.com/BengaliAI/syntheticWords/blob/main/coreLib/languages.py
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "panjabi"
    nukta                  =   '਼'
    vowels                 =   ['ਅ', 'ਆ', 'ਇ', 'ਈ', 'ਉ', 'ਊ', 'ਏ', 'ਐ', 'ਓ', 'ਔ','ੲ', 'ੳ']
    consonants             =   ['ਕ', 'ਖ', 'ਗ', 'ਘ', 'ਙ', 'ਚ', 'ਛ', 'ਜ', 'ਝ', 'ਞ', 'ਟ', 'ਠ', 'ਡ', 'ਢ', 'ਣ', 'ਤ', 'ਥ', 
                                'ਦ', 'ਧ', 'ਨ', 'ਪ', 'ਫ', 'ਬ', 'ਭ', 'ਮ', 'ਯ', 'ਰ', 'ਲ', 'ਲ਼', 'ਵ', 'ਸ਼', 'ਸ', 'ਹ','ਖ਼', 
                                'ਗ਼', 'ਜ਼', 'ੜ', 'ਫ਼']
    vowel_diacritics       =   ['ਾ', 'ਿ', 'ੀ', 'ੁ', 'ੂ', 'ੇ', 'ੈ', 'ੋ', 'ੌ']
    consonant_diacritics   =   ['ਁ', 'ਂ', 'ਃ'] # Not found!
    numbers                =   ['੦', '੧', '੨', '੩', '੪', '੫', '੬', '੭', '੮', '੯']
    punctuations           =   [',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-']
    symbols                =   []
    connector              =   '੍'
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0a00', '\u0a04', '\u0a0b', '\u0a0c', '\u0a0d', '\u0a0e', '\u0a11', '\u0a12', '\u0a29', '\u0a31', 
                                '\u0a34', '\u0a37', '\u0a3a', '\u0a3b', '\u0a3d', '\u0a43', '\u0a44', '\u0a45', '\u0a46', '\u0a49', 
                                '\u0a4a', '\u0a4e', '\u0a4f', '\u0a50', '\u0a52', '\u0a53', '\u0a54', '\u0a55', '\u0a56', '\u0a57', 
                                '\u0a58', '\u0a5d', '\u0a5f', '\u0a60', '\u0a61', '\u0a62', '\u0a63', '\u0a64', '\u0a65', '\u0a76', 
                                '\u0a77', '\u0a78', '\u0a79', '\u0a7a', '\u0a7b', '\u0a7c', '\u0a7d', '\u0a7e', '\u0a7f']
    legacy_symbols         =   []
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   []
    
    # this is a customizeable map : this map is purely based on visual similiarity 
    legacy_maps            =   {}
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
    nukta_map              =   {'ਖ':'ਖ਼',
                                'ਗ':'ਗ਼',
                                'ਜ':'ਜ਼',
                                'ਲ':'ਲ਼',
                                'ਸ':'ਸ਼',
                                'ਫ':'ਫ਼'
                                }
    diacritic_map          =   {}
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
        
        
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
class malayalam:
    '''
        * vowel and consonant division according to: https://unicode-table.com/en/blocks/malayalam/
        * consonant conjuncts according to: Self Generated
        * punctuations according to: https://github.com/BengaliAI/syntheticWords/blob/main/coreLib/languages.py
    '''
    
    #-----------------------------------------------------basic-------------------------------------------------------------------
    iden                   =   "malayalam"
    nukta                  =   '়'
    vowels                 =   ['അ', 'ആ', 'ഇ', 'ഈ', 'ഉ', 'ഊ', 'ഋ', 'ഌ', 'എ', 'ഏ', 'ഐ', 'ഒ', 'ഓ', 'ഔ','ൠ', 'ൡ'] 
    consonants             =   ['ക', 'ഖ', 'ഗ', 'ഘ', 'ങ', 'ച', 'ഛ', 'ജ', 'ഝ', 'ഞ', 'ട', 'ഠ', 'ഡ', 'ഢ', 'ണ', 'ത', 'ഥ', 
                                'ദ', 'ധ', 'ന', 'ഩ', 'പ', 'ഫ', 'ബ', 'ഭ', 'മ', 'യ', 'ര', 'റ', 'ല', 'ള', 'ഴ', 'വ', 'ശ', 'ഷ', 
                                'സ', 'ഹ', 'ഺ']
    vowel_diacritics       =   ['ാ', 'ി', 'ീ', 'ു', 'ൂ', 'ൃ', 'ൄ',     'െ', 'േ', 'ൈ','ൊ', 'ോ', 'ൌ','ൗ','ൢ', 'ൣ']
    consonant_diacritics   =   ['ഀ', 'ഁ', 'ം', 'ഃ', 'ഄ']
    numbers                =   ['൦', '൧', '൨', '൩', '൪', '൫', '൬', '൭', '൮', '൯','൘', '൙', '൚', '൛', '൜', '൝', '൞','൰', '൱', '൲','൳', '൴', '൵', '൶', '൷', '൸']
    punctuations           =    [',',';','।','?','!',':','—',':-',"'",'”','(', ')','{', '}','[',']','√','<','>','=','...','.','-']
    symbols                =   ['ഽ', '൏', '൹']

    
    
    connector              =   '്' # There are two other this shit '഻', '഼'
    
    # based on unicode range : \u0980-\u09FF
    non_gylph_unicodes     =   ['\u0d64', '\u0d65', '\u0d50', '\u0d51', '\u0d52', '\u0d53', '\u0d49', '\u0d45', '\u0d11', '\u0d0d']
    legacy_symbols         =   ['ൟ']
    
    non_chars              =   numbers+punctuations+symbols+non_gylph_unicodes+legacy_symbols
    #-----------------------------------------------------basic-------------------------------------------------------------------
    
    #---------------------------------------------------changeables----------------------------------------------------------------
    conjuncts              =   ['ഡ്വ','ബ്ല','സ്ബ','ദ്ഷ','ഗ്ഗ','ഹ്മ','സ്ഥ','ശ്ല','ബ്പ','റ്റ്ബ്യ','ഗ്ദ്ധ','ഹ്റ്റ','ഫ്ത','ത്വ','ന്ദ','ഡ്ക','ദ്വ','ങ്ങ','മ്പ്ര','ന്ധ്ര',
                                'ഷ്ര്ട','സ്റ്റ','ക്ഷ','ഫ്ജ','ന്ത്വ','ഫ്ട','ല്ല്യ','ജ്മ','ച്ച്ഡ','ഡ്ജ','്ഛ','ജ്ജ','ഗ്ല','ശ്മ','ഫ്ര','ത്ര','ശ്യ','ക്ക്ല','ക്ഷ്ണ','ട്ട്ബ',
                                'ത്ത്വ','ത്ത്ത','ഷ്ട്ര','ച്ച','ജ്ഭ','ക്ഷ്യ','സ്റ്റ്യ','ത്സ','ണ്ട','ഠ്യ','ഗ്ധ്യ','ട്ട','ഷ്ഠ','ത്ത്പ','ന്ദ്യ','ന്ന്യ','ന്റ','ഡ്ഡ','ദ്ദ','ന്ധ',
                                'ഗ്ദ','ര്യ','ക്ബ','ദ്യ','മ്മ്യ','ക്ക','ഥ്യ','ശ്ബ','ഗ്ന','ഗ്വ','ദ്ധ','ന്ജ','ക്ട്ര','ദ്ഭ','യ്ച്ച','ഴ്ന്ന','ക്ഷ്മ','പ്ല','ജ്വ','ജ്യ',
                                'ജ്ജ്വ','സ്ഗ','ജ്പ്ര','ല്പ','സ്സ്-','സ്മ','യ്പ','ഷ്ണ','ജ്പ','ജ്ര','ങ്ക','വ്ര','ധ്ര','ച്യ','പ്യ','ബ്ജ','സ്ത്യ','ഴ്സ','യ്മ','ഭ്യ',
                                'ന്വ','ദ്ഗ','ഞ്ച്വ','ജ്ക','ഷ്പ','ബ്ബ','റ്മ','ഡ്യ','പ്ത','ട്വ','ദ്ധ്യ','ഹ്യ','സ്ഫ','പ്പ','ന്ധ്യ','സ്ജ','പ്പ്മ','ഷ്പ്പ','ശ്വ','യ്ഹ',
                                'ണ്ഡ','ഡ്ബ','ഗ്ധ','റ്റ്വ','ഡ്ജ്മ','സ്ര','ണ്ട്-','ഗ്ര','ള്ള','ശ്ശ','ത്ത','ഴ്ച','ണ്ണ','യ്സ്റ്റ','ല്ക്ക','ബ്ദ','സ്റ്റ്-','്വ','യ്യ','ത്പ',
                                'ങ്മ','സ്എ','ഭ്ര','ക്ഡ്ര','പ്ന','ക്ത','വ്യ','ഷ്മ','ഴ്ച്ച','ച്ഛ','ക്വ','ട്യ','ഗ്യ','്ക','ഹ്ര','ങ്ക്ര','ത്ഘ','പ്റ്റ','സ്ല','ത്ക്ക',
                                'ന്ദ്ര','്ക്ക','ദ്ര','വ്വ','സ്ന','ഞ്ഞ','ക്ര','ഫ്റ്റ','ന്ത്യ','ട്ട്യ','ഴ്ത്ത','ട്ര','ജ്ഞ','ദ്ക','യ്ക','ന്യ','മ്മ','യ്ത്ത','ല്ക','ക്മ',
                                'ശ്ച','ന്ത്ര്യ','റ്റ്-','ഹ്ല','പ്ര','സ്ഡ','സ്വ','റ്റ','ന്ത','യ്ഗ','ദ്അ','ഷ്ട','ഞ്ച','മ്പ','ഷ്വ','സ്ത്ര','യ്പ്പ','ഷ്യ','ത്മ','മ്യ',
                                'ക്ല','ന്ന','ല്ല','റ്റ്ഹ','സ്യ','ക്യ','യ്ഞ്ച','ത്ഭ','ത്യ','ധ്വ','ഡ്മ','ഗ്മ','ക്സ്റ്റ','ങ്ക്ല','ത്ത്യ','സ്റ്റ്ഓ','ത്ക','ണ്ഠ','ല്യ','ങ്ഷ',
                                'യ്ഡ','ഞ്ജ','മ്ര','യ്ക്ക','ക്ട','ദ്ര്യ','ദ്മ','സ്ഗ്ര','ഡ്ര','ഖ്യ','സ്-','സ്റ്റ്ജ','ന്ഥ','ഢ്യ','ദ്ഘ','ഫ്ല','ന്ത്ര','ന്മ','വ്ഗ','ത്സ്യ',
                                'ങ്ഹ','സ്ആ','്ത','ധ്യ','ബ്ര','സ്ട്ര','ണ്യ','ശ്ര','ണ്-','പ്ട','യ്ത','സ്ഹ','സ്ഇ','ബ്യ','ഹ്ന','ങ്ക്ബ','ര്ന','ട്ണ','സ്ത','മ്പ്യ',
                                'ക്റ്റ','ത്ഗ','സ്ട','സ്സ','ല്മ']
   
    #---------------------------------------------------changeables----------------------------------------------------------------
    
    #---------------------------------------------------normalization maps---------------------------------------------------------
    nukta_map              =   {}
    diacritic_map          =   {}
    #---------------------------------------------------normalization maps---------------------------------------------------------
    diacritics             =   sorted(vowel_diacritics+consonant_diacritics)
    used                   =   sorted(vowels+consonants+vowel_diacritics+consonant_diacritics+numbers)
    valid                  =   sorted([' ']+used+punctuations+[connector]+["\u200d","\u200c"])
    complex_roots          =   sorted([' ']+vowels+consonants+numbers+punctuations+symbols+conjuncts) 
    # these unicodes can not start a word
    invalid_starts         =   sorted(diacritics+[connector])
    # invalid connector cases
    '''
        a connector can not be sorrounded by/ can not come after or before:
            * the vowels
            * the diacritics
            * another connector [double consecutive hosonto]
             
    '''
    invalid_connectors     =    sorted(invalid_starts+vowels+numbers+punctuations)     
        
        
    
#--------------------------------------------------------------------------------------------------------------------------------------------
#############################################################################################################################################
#--------------------------------------------------------------------------------------------------------------------------------------------
languages={}
languages["english"]    =english
languages["bangla"]     =bangla
languages["devanagari"] =devanagari
languages["gujarati"]   =gujarati
languages["odiya"]      =odiya
languages["tamil"]      =tamil
languages["panjabi"]    =panjabi
languages["malayalam"]  =malayalam
