-- Join Standard Outputs
-- Pass Only Elements:
--   ['txn_count', 'account_id__customer_id__customer_name']
-- Aggregate Measures
-- Compute Metrics via Expressions
SELECT
  subq_18.customer_id__customer_name AS account_id__customer_id__customer_name
  , SUM(account_month_txns_src_10010.txn_count) AS txn_count
FROM ***************************.account_month_txns account_month_txns_src_10010
LEFT OUTER JOIN (
  -- Join Standard Outputs
  -- Pass Only Elements:
  --   ['account_id', 'ds_partitioned', 'customer_id__customer_name']
  SELECT
    bridge_table_src_10011.ds_partitioned AS ds_partitioned
    , bridge_table_src_10011.account_id AS account_id
    , customer_table_src_10013.customer_name AS customer_id__customer_name
  FROM ***************************.bridge_table bridge_table_src_10011
  LEFT OUTER JOIN
    ***************************.customer_table customer_table_src_10013
  ON
    (
      bridge_table_src_10011.customer_id = customer_table_src_10013.customer_id
    ) AND (
      bridge_table_src_10011.ds_partitioned = customer_table_src_10013.ds_partitioned
    )
) subq_18
ON
  (
    account_month_txns_src_10010.account_id = subq_18.account_id
  ) AND (
    account_month_txns_src_10010.ds_partitioned = subq_18.ds_partitioned
  )
GROUP BY
  account_id__customer_id__customer_name
