"""
VersionInfo - file ``version_info``
===================================

The version of the insights core and insights client that the archive used.

"""
from insights import JSONParser, parser
from insights.specs import Specs


@parser(Specs.version_info)
class VersionInfo(JSONParser):
    """
    This parser parses the ``version_info`` file generated by the
    ``insights-client`` command.

    Typical content of this file is::

        {"core_version": "3.0.203-1", "client_version": "3.1.1"}

    .. note::

        The :attr:`client_version` provided by this Parser is a short version
        only, to get the full version of the ``insights-client`` package,
        please use the :class:`insights.parsers.installed_rpms.InstalledRpms`
        Parser instead.

    Examples:
        >>> ver.core_version == '3.0.203-1'
        True
        >>> ver.client_version == '3.1.1'
        True
    """
    @property
    def core_version(self):
        """
        Returns:
            (str): The version of the insights core.
        """
        return self.data['core_version']

    @property
    def client_version(self):
        """
        Returns:
            (str): The version of the insights client.

        .. note::

            This attribute returns a short version of the insights client only,
            to get the full version of the ``insights-client`` package, please
            use the :class:`insights.parsers.installed_rpms.InstalledRpms` Parser
            instead.
        """
        return self.data['client_version']
