# Aluora

**Aluora** is a Python library for hallucination detection in text generated by large language models (LLMs). It integrates multiple detection methods to assess the risk that a given response is unsupported or fabricated relative to its context and question.

## 🔍 Features

- 🧠 **HalluDetect**: Dropout-based DenseNet model with MC Dropout and mutual information for uncertainty estimation.
- 📐 **HHEM**: Semantic consistency scoring using a pretrained transformer classifier.
- 🥬 **LettuceDetect**: Span-level hallucination detection using contextual lexical evaluation.
- 🧪 **JSON Output** for structured evaluation results.

## 🚀 Installation
```bash
pip install aluora
```

## 🧠 Example Usage
```python
from Aluora.core.extractor import hallucination_metrics

hallucination_metrics(
    context="The robot was built in 2023.",
    question="When was the robot built?",
    answer="The robot was built in 2023.",
    output_json_path="results.json"  # path to save output as JSON
)
```

## 📁 Output Structure
```json
{
  "halludetect": {
    "predicted_class": 0,
    "label": "🤖 Hallucination",
    "probability_class_1": 0.15,
    "mutual_information": 0.08
  },
  "hhem": {
    "prob_no_hallucination": 0.02,
    "risk_level": "🚨 HIGH"
  },
  "lettuce": {
    "detected_spans": [...],
    "estimated_risk": "⚠️ MEDIUM"
  }
}
```

## 📄 License
MIT License

## 👤 Author
Pedro Sarmiento — [GitHub](https://github.com/Pedro-Sarmiento)
