import { ApiObject, ApiObjectMetadata, GroupVersionKind } from 'cdk8s';
import { Construct } from 'constructs';
/**
 * Jenkins is the Schema for the jenkins API
 *
 * @schema Jenkins
 */
export declare class Jenkins extends ApiObject {
    /**
     * Returns the apiVersion and kind for "Jenkins"
     */
    static readonly GVK: GroupVersionKind;
    /**
     * Renders a Kubernetes manifest for "Jenkins".
     *
     * This can be used to inline resource manifests inside other objects (e.g. as templates).
     *
     * @param props initialization props
     */
    static manifest(props?: JenkinsProps): any;
    /**
     * Defines a "Jenkins" API object
     * @param scope the scope in which to define this object
     * @param id a scope-local name for the object
     * @param props initialization props
     */
    constructor(scope: Construct, id: string, props?: JenkinsProps);
    /**
     * Renders the object to Kubernetes JSON.
     */
    toJson(): any;
}
/**
 * Jenkins is the Schema for the jenkins API
 *
 * @schema Jenkins
 */
export interface JenkinsProps {
    /**
     * @schema Jenkins#metadata
     */
    readonly metadata?: ApiObjectMetadata;
    /**
     * Spec defines the desired state of the Jenkins
     *
     * @schema Jenkins#spec
     */
    readonly spec?: JenkinsSpec;
}
/**
 * Converts an object of type 'JenkinsProps' to JSON representation.
 */
export declare function toJson_JenkinsProps(obj: JenkinsProps | undefined): Record<string, any> | undefined;
/**
 * Spec defines the desired state of the Jenkins
 *
 * @schema JenkinsSpec
 */
export interface JenkinsSpec {
    /**
     * Backup defines configuration of Jenkins backup More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configure-backup-and-restore/
     *
     * @schema JenkinsSpec#backup
     */
    readonly backup?: JenkinsSpecBackup;
    /**
     * ConfigurationAsCode defines configuration of Jenkins customization via Configuration as Code Jenkins plugin
     *
     * @schema JenkinsSpec#configurationAsCode
     */
    readonly configurationAsCode?: JenkinsSpecConfigurationAsCode;
    /**
     * GroovyScripts defines configuration of Jenkins customization via groovy scripts
     *
     * @schema JenkinsSpec#groovyScripts
     */
    readonly groovyScripts?: JenkinsSpecGroovyScripts;
    /**
     * JenkinsAPISettings defines configuration used by the operator to gain admin access to the Jenkins API
     *
     * @schema JenkinsSpec#jenkinsAPISettings
     */
    readonly jenkinsApiSettings: JenkinsSpecJenkinsApiSettings;
    /**
     * Master represents Jenkins master pod properties and Jenkins plugins. Every single change here requires a pod restart.
     *
     * @schema JenkinsSpec#master
     */
    readonly master: JenkinsSpecMaster;
    /**
     * Notifications defines list of a services which are used to inform about Jenkins status Can be used to integrate chat services like Slack, Microsoft Teams or Mailgun
     *
     * @schema JenkinsSpec#notifications
     */
    readonly notifications?: JenkinsSpecNotifications[];
    /**
     * Backup defines configuration of Jenkins backup restore More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configure-backup-and-restore/
     *
     * @schema JenkinsSpec#restore
     */
    readonly restore?: JenkinsSpecRestore;
    /**
     * Roles defines list of extra RBAC roles for the Jenkins Master pod service account
     *
     * @schema JenkinsSpec#roles
     */
    readonly roles?: JenkinsSpecRoles[];
    /**
     * SeedJobs defines list of Jenkins Seed Job configurations More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configuration#configure-seed-jobs-and-pipelines
     *
     * @schema JenkinsSpec#seedJobs
     */
    readonly seedJobs?: JenkinsSpecSeedJobs[];
    /**
     * Service is Kubernetes service of Jenkins master HTTP pod Defaults to : port: 8080 type: ClusterIP
     *
     * @default port: 8080 type: ClusterIP
     * @schema JenkinsSpec#service
     */
    readonly service?: JenkinsSpecService;
    /**
     * ServiceAccount defines Jenkins master service account attributes
     *
     * @schema JenkinsSpec#serviceAccount
     */
    readonly serviceAccount?: JenkinsSpecServiceAccount;
    /**
     * Service is Kubernetes service of Jenkins slave pods Defaults to : port: 50000 type: ClusterIP
     *
     * @default port: 50000 type: ClusterIP
     * @schema JenkinsSpec#slaveService
     */
    readonly slaveService?: JenkinsSpecSlaveService;
    /**
     * ValidateSecurityWarnings enables or disables validating potential security warnings in Jenkins plugins via admission webhooks.
     *
     * @schema JenkinsSpec#validateSecurityWarnings
     */
    readonly validateSecurityWarnings?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpec' to JSON representation.
 */
export declare function toJson_JenkinsSpec(obj: JenkinsSpec | undefined): Record<string, any> | undefined;
/**
 * Backup defines configuration of Jenkins backup More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configure-backup-and-restore/
 *
 * @schema JenkinsSpecBackup
 */
export interface JenkinsSpecBackup {
    /**
     * Action defines action which performs backup in backup container sidecar
     *
     * @schema JenkinsSpecBackup#action
     */
    readonly action: JenkinsSpecBackupAction;
    /**
     * ContainerName is the container name responsible for backup operation
     *
     * @schema JenkinsSpecBackup#containerName
     */
    readonly containerName: string;
    /**
     * Interval tells how often make backup in seconds Defaults to 30.
     *
     * @default 30.
     * @schema JenkinsSpecBackup#interval
     */
    readonly interval: number;
    /**
     * MakeBackupBeforePodDeletion tells operator to make backup before Jenkins master pod deletion
     *
     * @schema JenkinsSpecBackup#makeBackupBeforePodDeletion
     */
    readonly makeBackupBeforePodDeletion: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecBackup' to JSON representation.
 */
export declare function toJson_JenkinsSpecBackup(obj: JenkinsSpecBackup | undefined): Record<string, any> | undefined;
/**
 * ConfigurationAsCode defines configuration of Jenkins customization via Configuration as Code Jenkins plugin
 *
 * @schema JenkinsSpecConfigurationAsCode
 */
export interface JenkinsSpecConfigurationAsCode {
    /**
     * @schema JenkinsSpecConfigurationAsCode#configurations
     */
    readonly configurations: JenkinsSpecConfigurationAsCodeConfigurations[];
    /**
     * SecretRef is reference to Kubernetes secret.
     *
     * @schema JenkinsSpecConfigurationAsCode#secret
     */
    readonly secret: JenkinsSpecConfigurationAsCodeSecret;
}
/**
 * Converts an object of type 'JenkinsSpecConfigurationAsCode' to JSON representation.
 */
export declare function toJson_JenkinsSpecConfigurationAsCode(obj: JenkinsSpecConfigurationAsCode | undefined): Record<string, any> | undefined;
/**
 * GroovyScripts defines configuration of Jenkins customization via groovy scripts
 *
 * @schema JenkinsSpecGroovyScripts
 */
export interface JenkinsSpecGroovyScripts {
    /**
     * @schema JenkinsSpecGroovyScripts#configurations
     */
    readonly configurations: JenkinsSpecGroovyScriptsConfigurations[];
    /**
     * SecretRef is reference to Kubernetes secret.
     *
     * @schema JenkinsSpecGroovyScripts#secret
     */
    readonly secret: JenkinsSpecGroovyScriptsSecret;
}
/**
 * Converts an object of type 'JenkinsSpecGroovyScripts' to JSON representation.
 */
export declare function toJson_JenkinsSpecGroovyScripts(obj: JenkinsSpecGroovyScripts | undefined): Record<string, any> | undefined;
/**
 * JenkinsAPISettings defines configuration used by the operator to gain admin access to the Jenkins API
 *
 * @schema JenkinsSpecJenkinsApiSettings
 */
export interface JenkinsSpecJenkinsApiSettings {
    /**
     * AuthorizationStrategy defines authorization strategy of the operator for the Jenkins API
     *
     * @schema JenkinsSpecJenkinsApiSettings#authorizationStrategy
     */
    readonly authorizationStrategy: string;
}
/**
 * Converts an object of type 'JenkinsSpecJenkinsApiSettings' to JSON representation.
 */
export declare function toJson_JenkinsSpecJenkinsApiSettings(obj: JenkinsSpecJenkinsApiSettings | undefined): Record<string, any> | undefined;
/**
 * Master represents Jenkins master pod properties and Jenkins plugins. Every single change here requires a pod restart.
 *
 * @schema JenkinsSpecMaster
 */
export interface JenkinsSpecMaster {
    /**
     * Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations
     *
     * @schema JenkinsSpecMaster#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * BasePlugins contains plugins required by operator Defaults to : - name: kubernetes version: "1.31.3" - name: workflow-job version: "1145.v7f2433caa07f" - name: workflow-aggregator version: "2.6" - name: git version: "4.10.3" - name: job-dsl version: "1.78.1" - name: configuration-as-code version: "1346.ve8cfa_3473c94" - name: kubernetes-credentials-provider version: "0.20"
     *
     * @default name: kubernetes version: "1.31.3" - name: workflow-job version: "1145.v7f2433caa07f" - name: workflow-aggregator version: "2.6" - name: git version: "4.10.3" - name: job-dsl version: "1.78.1" - name: configuration-as-code version: "1346.ve8cfa_3473c94" - name: kubernetes-credentials-provider version: "0.20"
     * @schema JenkinsSpecMaster#basePlugins
     */
    readonly basePlugins?: JenkinsSpecMasterBasePlugins[];
    /**
     * List of containers belonging to the pod. Containers cannot currently be added or removed. There must be at least one container in a Pod. Defaults to: - image: jenkins/jenkins:lts   imagePullPolicy: Always   livenessProbe:     failureThreshold: 12     httpGet:       path: /login       port: http       scheme: HTTP     initialDelaySeconds: 80     periodSeconds: 10     successThreshold: 1     timeoutSeconds: 5   name: jenkins-master   readinessProbe:     failureThreshold: 3     httpGet:       path: /login       port: http       scheme: HTTP     initialDelaySeconds: 30     periodSeconds: 10     successThreshold: 1     timeoutSeconds: 1   resources:     limits:       cpu: 1500m       memory: 3Gi     requests:       cpu: "1"       memory: 600Mi
     *
     * @default image: jenkins/jenkins:lts   imagePullPolicy: Always   livenessProbe:     failureThreshold: 12     httpGet:       path: /login       port: http       scheme: HTTP     initialDelaySeconds: 80     periodSeconds: 10     successThreshold: 1     timeoutSeconds: 5   name: jenkins-master   readinessProbe:     failureThreshold: 3     httpGet:       path: /login       port: http       scheme: HTTP     initialDelaySeconds: 30     periodSeconds: 10     successThreshold: 1     timeoutSeconds: 1   resources:     limits:       cpu: 1500m       memory: 3Gi     requests:       cpu: "1"       memory: 600Mi
     * @schema JenkinsSpecMaster#containers
     */
    readonly containers?: JenkinsSpecMasterContainers[];
    /**
     * DisableCSRFProtection allows you to toggle CSRF Protection on Jenkins
     *
     * @schema JenkinsSpecMaster#disableCSRFProtection
     */
    readonly disableCsrfProtection: boolean;
    /**
     * HostAliases for Jenkins master pod and SeedJob agent
     *
     * @schema JenkinsSpecMaster#hostAliases
     */
    readonly hostAliases?: JenkinsSpecMasterHostAliases[];
    /**
     * ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod
     *
     * @schema JenkinsSpecMaster#imagePullSecrets
     */
    readonly imagePullSecrets?: JenkinsSpecMasterImagePullSecrets[];
    /**
     * Map of string keys and values that can be used to organize and categorize (scope and select) objects. May match selectors of replication controllers and services. More info: http://kubernetes.io/docs/user-guide/labels
     *
     * @schema JenkinsSpecMaster#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/
     *
     * @schema JenkinsSpecMaster#nodeSelector
     */
    readonly nodeSelector?: {
        [key: string]: string;
    };
    /**
     * Plugins contains plugins required by user
     *
     * @schema JenkinsSpecMaster#plugins
     */
    readonly plugins?: JenkinsSpecMasterPlugins[];
    /**
     * PriorityClassName for Jenkins master pod
     *
     * @schema JenkinsSpecMaster#priorityClassName
     */
    readonly priorityClassName?: string;
    /**
     * SecurityContext that applies to all the containers of the Jenkins Master. As per kubernetes specification, it can be overridden for each container individually. Defaults to: runAsUser: 1000 fsGroup: 1000
     *
     * @default runAsUser: 1000 fsGroup: 1000
     * @schema JenkinsSpecMaster#securityContext
     */
    readonly securityContext?: JenkinsSpecMasterSecurityContext;
    /**
     * If specified, the pod's tolerations.
     *
     * @schema JenkinsSpecMaster#tolerations
     */
    readonly tolerations?: JenkinsSpecMasterTolerations[];
    /**
     * List of volumes that can be mounted by containers belonging to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes
     *
     * @schema JenkinsSpecMaster#volumes
     */
    readonly volumes?: JenkinsSpecMasterVolumes[];
}
/**
 * Converts an object of type 'JenkinsSpecMaster' to JSON representation.
 */
export declare function toJson_JenkinsSpecMaster(obj: JenkinsSpecMaster | undefined): Record<string, any> | undefined;
/**
 * Notification is a service configuration used to send notifications about Jenkins status.
 *
 * @schema JenkinsSpecNotifications
 */
export interface JenkinsSpecNotifications {
    /**
     * NotificationLevel defines the level of a Notification.
     *
     * @schema JenkinsSpecNotifications#level
     */
    readonly level: string;
    /**
     * Mailgun is handler for Mailgun email service notification channel.
     *
     * @schema JenkinsSpecNotifications#mailgun
     */
    readonly mailgun?: JenkinsSpecNotificationsMailgun;
    /**
     * @schema JenkinsSpecNotifications#name
     */
    readonly name: string;
    /**
     * Slack is handler for Slack notification channel.
     *
     * @schema JenkinsSpecNotifications#slack
     */
    readonly slack?: JenkinsSpecNotificationsSlack;
    /**
     * SMTP is handler for sending emails via this protocol.
     *
     * @schema JenkinsSpecNotifications#smtp
     */
    readonly smtp?: JenkinsSpecNotificationsSmtp;
    /**
     * MicrosoftTeams is handler for Microsoft MicrosoftTeams notification channel.
     *
     * @schema JenkinsSpecNotifications#teams
     */
    readonly teams?: JenkinsSpecNotificationsTeams;
    /**
     * @schema JenkinsSpecNotifications#verbose
     */
    readonly verbose: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecNotifications' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotifications(obj: JenkinsSpecNotifications | undefined): Record<string, any> | undefined;
/**
 * Backup defines configuration of Jenkins backup restore More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configure-backup-and-restore/
 *
 * @schema JenkinsSpecRestore
 */
export interface JenkinsSpecRestore {
    /**
     * Action defines action which performs restore backup in restore container sidecar
     *
     * @schema JenkinsSpecRestore#action
     */
    readonly action: JenkinsSpecRestoreAction;
    /**
     * ContainerName is the container name responsible for restore backup operation
     *
     * @schema JenkinsSpecRestore#containerName
     */
    readonly containerName: string;
    /**
     * GetLatestAction defines action which returns the latest backup number. If there is no backup "-1" should be returned.
     *
     * @schema JenkinsSpecRestore#getLatestAction
     */
    readonly getLatestAction?: JenkinsSpecRestoreGetLatestAction;
    /**
     * RecoveryOnce if want to restore specific backup set this field and then Jenkins will be restarted and desired backup will be restored
     *
     * @schema JenkinsSpecRestore#recoveryOnce
     */
    readonly recoveryOnce?: number;
}
/**
 * Converts an object of type 'JenkinsSpecRestore' to JSON representation.
 */
export declare function toJson_JenkinsSpecRestore(obj: JenkinsSpecRestore | undefined): Record<string, any> | undefined;
/**
 * RoleRef contains information that points to the role being used
 *
 * @schema JenkinsSpecRoles
 */
export interface JenkinsSpecRoles {
    /**
     * APIGroup is the group for the resource being referenced
     *
     * @schema JenkinsSpecRoles#apiGroup
     */
    readonly apiGroup: string;
    /**
     * Kind is the type of resource being referenced
     *
     * @schema JenkinsSpecRoles#kind
     */
    readonly kind: string;
    /**
     * Name is the name of resource being referenced
     *
     * @schema JenkinsSpecRoles#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecRoles' to JSON representation.
 */
export declare function toJson_JenkinsSpecRoles(obj: JenkinsSpecRoles | undefined): Record<string, any> | undefined;
/**
 * SeedJob defines configuration for seed job More info: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/configuration/#configure-seed-jobs-and-pipelines.
 *
 * @schema JenkinsSpecSeedJobs
 */
export interface JenkinsSpecSeedJobs {
    /**
     * AdditionalClasspath is setting for Job DSL API plugin to set Additional Classpath
     *
     * @schema JenkinsSpecSeedJobs#additionalClasspath
     */
    readonly additionalClasspath?: string;
    /**
     * BitbucketPushTrigger is used for Bitbucket web hooks
     *
     * @schema JenkinsSpecSeedJobs#bitbucketPushTrigger
     */
    readonly bitbucketPushTrigger?: boolean;
    /**
     * BuildPeriodically is setting for scheduled trigger
     *
     * @schema JenkinsSpecSeedJobs#buildPeriodically
     */
    readonly buildPeriodically?: string;
    /**
     * CredentialID is the Kubernetes secret name which stores repository access credentials
     *
     * @schema JenkinsSpecSeedJobs#credentialID
     */
    readonly credentialId?: string;
    /**
     * JenkinsCredentialType is the https://jenkinsci.github.io/kubernetes-credentials-provider-plugin/ credential type
     *
     * @schema JenkinsSpecSeedJobs#credentialType
     */
    readonly credentialType?: string;
    /**
     * Description is the description of the seed job
     *
     * @schema JenkinsSpecSeedJobs#description
     */
    readonly description?: string;
    /**
     * FailOnMissingPlugin is setting for Job DSL API plugin that fails job if required plugin is missing
     *
     * @schema JenkinsSpecSeedJobs#failOnMissingPlugin
     */
    readonly failOnMissingPlugin?: boolean;
    /**
     * GitHubPushTrigger is used for GitHub web hooks
     *
     * @schema JenkinsSpecSeedJobs#githubPushTrigger
     */
    readonly githubPushTrigger?: boolean;
    /**
     * ID is the unique seed job name
     *
     * @schema JenkinsSpecSeedJobs#id
     */
    readonly id?: string;
    /**
     * IgnoreMissingFiles is setting for Job DSL API plugin to ignore files that miss
     *
     * @schema JenkinsSpecSeedJobs#ignoreMissingFiles
     */
    readonly ignoreMissingFiles?: boolean;
    /**
     * PollSCM is setting for polling changes in SCM
     *
     * @schema JenkinsSpecSeedJobs#pollSCM
     */
    readonly pollScm?: string;
    /**
     * RepositoryBranch is the repository branch where are seed job definitions
     *
     * @schema JenkinsSpecSeedJobs#repositoryBranch
     */
    readonly repositoryBranch?: string;
    /**
     * RepositoryURL is the repository access URL. Can be SSH or HTTPS.
     *
     * @schema JenkinsSpecSeedJobs#repositoryUrl
     */
    readonly repositoryUrl?: string;
    /**
     * Targets is the repository path where are seed job definitions
     *
     * @schema JenkinsSpecSeedJobs#targets
     */
    readonly targets?: string;
    /**
     * UnstableOnDeprecation is setting for Job DSL API plugin that sets build status as unstable if build using deprecated features
     *
     * @schema JenkinsSpecSeedJobs#unstableOnDeprecation
     */
    readonly unstableOnDeprecation?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecSeedJobs' to JSON representation.
 */
export declare function toJson_JenkinsSpecSeedJobs(obj: JenkinsSpecSeedJobs | undefined): Record<string, any> | undefined;
/**
 * Service is Kubernetes service of Jenkins master HTTP pod Defaults to : port: 8080 type: ClusterIP
 *
 * @default port: 8080 type: ClusterIP
 * @schema JenkinsSpecService
 */
export interface JenkinsSpecService {
    /**
     * Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations
     *
     * @schema JenkinsSpecService#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     *
     * @schema JenkinsSpecService#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
     *
     * @schema JenkinsSpecService#loadBalancerIP
     */
    readonly loadBalancerIp?: string;
    /**
     * If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/administer-cluster/securing-a-cluster/#restricting-cloud-metadata-api-access
     *
     * @schema JenkinsSpecService#loadBalancerSourceRanges
     */
    readonly loadBalancerSourceRanges?: string[];
    /**
     * The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     *
     * @default to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     * @schema JenkinsSpecService#nodePort
     */
    readonly nodePort?: number;
    /**
     * The port that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @schema JenkinsSpecService#port
     */
    readonly port?: number;
    /**
     * Type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ExternalName" maps to the specified externalName. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types
     *
     * @default ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ExternalName" maps to the specified externalName. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types
     * @schema JenkinsSpecService#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'JenkinsSpecService' to JSON representation.
 */
export declare function toJson_JenkinsSpecService(obj: JenkinsSpecService | undefined): Record<string, any> | undefined;
/**
 * ServiceAccount defines Jenkins master service account attributes
 *
 * @schema JenkinsSpecServiceAccount
 */
export interface JenkinsSpecServiceAccount {
    /**
     * Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations
     *
     * @schema JenkinsSpecServiceAccount#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'JenkinsSpecServiceAccount' to JSON representation.
 */
export declare function toJson_JenkinsSpecServiceAccount(obj: JenkinsSpecServiceAccount | undefined): Record<string, any> | undefined;
/**
 * Service is Kubernetes service of Jenkins slave pods Defaults to : port: 50000 type: ClusterIP
 *
 * @default port: 50000 type: ClusterIP
 * @schema JenkinsSpecSlaveService
 */
export interface JenkinsSpecSlaveService {
    /**
     * Annotations is an unstructured key value map stored with a resource that may be set by external tools to store and retrieve arbitrary metadata. They are not queryable and should be preserved when modifying objects. More info: http://kubernetes.io/docs/user-guide/annotations
     *
     * @schema JenkinsSpecSlaveService#annotations
     */
    readonly annotations?: {
        [key: string]: string;
    };
    /**
     * Route service traffic to pods with label keys and values matching this selector. If empty or not present, the service is assumed to have an external process managing its endpoints, which Kubernetes will not modify. Only applies to types ClusterIP, NodePort, and LoadBalancer. Ignored if type is ExternalName. More info: https://kubernetes.io/docs/concepts/services-networking/service/
     *
     * @schema JenkinsSpecSlaveService#labels
     */
    readonly labels?: {
        [key: string]: string;
    };
    /**
     * Only applies to Service Type: LoadBalancer LoadBalancer will get created with the IP specified in this field. This feature depends on whether the underlying cloud-provider supports specifying the loadBalancerIP when a load balancer is created. This field will be ignored if the cloud-provider does not support the feature.
     *
     * @schema JenkinsSpecSlaveService#loadBalancerIP
     */
    readonly loadBalancerIp?: string;
    /**
     * If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature." More info: https://kubernetes.io/docs/tasks/administer-cluster/securing-a-cluster/#restricting-cloud-metadata-api-access
     *
     * @schema JenkinsSpecSlaveService#loadBalancerSourceRanges
     */
    readonly loadBalancerSourceRanges?: string[];
    /**
     * The port on each node on which this service is exposed when type=NodePort or LoadBalancer. Usually assigned by the system. If specified, it will be allocated to the service if unused or else creation of the service will fail. Default is to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     *
     * @default to auto-allocate a port if the ServiceType of this Service requires one. More info: https://kubernetes.io/docs/concepts/services-networking/service/#type-nodeport
     * @schema JenkinsSpecSlaveService#nodePort
     */
    readonly nodePort?: number;
    /**
     * The port that are exposed by this service. More info: https://kubernetes.io/docs/concepts/services-networking/service/#virtual-ips-and-service-proxies
     *
     * @schema JenkinsSpecSlaveService#port
     */
    readonly port?: number;
    /**
     * Type determines how the Service is exposed. Defaults to ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ExternalName" maps to the specified externalName. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types
     *
     * @default ClusterIP. Valid options are ExternalName, ClusterIP, NodePort, and LoadBalancer. "ExternalName" maps to the specified externalName. "ClusterIP" allocates a cluster-internal IP address for load-balancing to endpoints. Endpoints are determined by the selector or if that is not specified, by manual construction of an Endpoints object. If clusterIP is "None", no virtual IP is allocated and the endpoints are published as a set of endpoints rather than a stable IP. "NodePort" builds on ClusterIP and allocates a port on every node which routes to the clusterIP. "LoadBalancer" builds on NodePort and creates an external load-balancer (if supported in the current cloud) which routes to the clusterIP. More info: https://kubernetes.io/docs/concepts/services-networking/service/#publishing-services---service-types
     * @schema JenkinsSpecSlaveService#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'JenkinsSpecSlaveService' to JSON representation.
 */
export declare function toJson_JenkinsSpecSlaveService(obj: JenkinsSpecSlaveService | undefined): Record<string, any> | undefined;
/**
 * Action defines action which performs backup in backup container sidecar
 *
 * @schema JenkinsSpecBackupAction
 */
export interface JenkinsSpecBackupAction {
    /**
     * Exec specifies the action to take.
     *
     * @schema JenkinsSpecBackupAction#exec
     */
    readonly exec?: JenkinsSpecBackupActionExec;
}
/**
 * Converts an object of type 'JenkinsSpecBackupAction' to JSON representation.
 */
export declare function toJson_JenkinsSpecBackupAction(obj: JenkinsSpecBackupAction | undefined): Record<string, any> | undefined;
/**
 * ConfigMapRef is reference to Kubernetes ConfigMap.
 *
 * @schema JenkinsSpecConfigurationAsCodeConfigurations
 */
export interface JenkinsSpecConfigurationAsCodeConfigurations {
    /**
     * @schema JenkinsSpecConfigurationAsCodeConfigurations#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecConfigurationAsCodeConfigurations' to JSON representation.
 */
export declare function toJson_JenkinsSpecConfigurationAsCodeConfigurations(obj: JenkinsSpecConfigurationAsCodeConfigurations | undefined): Record<string, any> | undefined;
/**
 * SecretRef is reference to Kubernetes secret.
 *
 * @schema JenkinsSpecConfigurationAsCodeSecret
 */
export interface JenkinsSpecConfigurationAsCodeSecret {
    /**
     * @schema JenkinsSpecConfigurationAsCodeSecret#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecConfigurationAsCodeSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecConfigurationAsCodeSecret(obj: JenkinsSpecConfigurationAsCodeSecret | undefined): Record<string, any> | undefined;
/**
 * ConfigMapRef is reference to Kubernetes ConfigMap.
 *
 * @schema JenkinsSpecGroovyScriptsConfigurations
 */
export interface JenkinsSpecGroovyScriptsConfigurations {
    /**
     * @schema JenkinsSpecGroovyScriptsConfigurations#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecGroovyScriptsConfigurations' to JSON representation.
 */
export declare function toJson_JenkinsSpecGroovyScriptsConfigurations(obj: JenkinsSpecGroovyScriptsConfigurations | undefined): Record<string, any> | undefined;
/**
 * SecretRef is reference to Kubernetes secret.
 *
 * @schema JenkinsSpecGroovyScriptsSecret
 */
export interface JenkinsSpecGroovyScriptsSecret {
    /**
     * @schema JenkinsSpecGroovyScriptsSecret#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecGroovyScriptsSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecGroovyScriptsSecret(obj: JenkinsSpecGroovyScriptsSecret | undefined): Record<string, any> | undefined;
/**
 * Plugin defines Jenkins plugin.
 *
 * @schema JenkinsSpecMasterBasePlugins
 */
export interface JenkinsSpecMasterBasePlugins {
    /**
     * DownloadURL is the custom url from where plugin has to be downloaded.
     *
     * @schema JenkinsSpecMasterBasePlugins#downloadURL
     */
    readonly downloadUrl?: string;
    /**
     * Name is the name of Jenkins plugin
     *
     * @schema JenkinsSpecMasterBasePlugins#name
     */
    readonly name: string;
    /**
     * Version is the version of Jenkins plugin
     *
     * @schema JenkinsSpecMasterBasePlugins#version
     */
    readonly version: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterBasePlugins' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterBasePlugins(obj: JenkinsSpecMasterBasePlugins | undefined): Record<string, any> | undefined;
/**
 * Container defines Kubernetes container attributes.
 *
 * @schema JenkinsSpecMasterContainers
 */
export interface JenkinsSpecMasterContainers {
    /**
     * Arguments to the entrypoint. The docker image's CMD is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @schema JenkinsSpecMasterContainers#args
     */
    readonly args?: string[];
    /**
     * Entrypoint array. Not executed within a shell. The docker image's ENTRYPOINT is used if this is not provided. Variable references $(VAR_NAME) are expanded using the container's environment. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. More info: https://kubernetes.io/docs/tasks/inject-data-application/define-command-argument-container/#running-a-command-in-a-shell
     *
     * @schema JenkinsSpecMasterContainers#command
     */
    readonly command?: string[];
    /**
     * List of environment variables to set in the container.
     *
     * @schema JenkinsSpecMasterContainers#env
     */
    readonly env?: JenkinsSpecMasterContainersEnv[];
    /**
     * List of sources to populate environment variables in the container. The keys defined within a source must be a C_IDENTIFIER. All invalid keys will be reported as an event when the container is starting. When a key exists in multiple sources, the value associated with the last source will take precedence. Values defined by an Env with a duplicate key will take precedence.
     *
     * @schema JenkinsSpecMasterContainers#envFrom
     */
    readonly envFrom?: JenkinsSpecMasterContainersEnvFrom[];
    /**
     * Docker image name. More info: https://kubernetes.io/docs/concepts/containers/images
     *
     * @schema JenkinsSpecMasterContainers#image
     */
    readonly image: string;
    /**
     * Image pull policy. One of Always, Never, IfNotPresent. Defaults to Always.
     *
     * @default Always.
     * @schema JenkinsSpecMasterContainers#imagePullPolicy
     */
    readonly imagePullPolicy: string;
    /**
     * Actions that the management system should take in response to container lifecycle events.
     *
     * @schema JenkinsSpecMasterContainers#lifecycle
     */
    readonly lifecycle?: JenkinsSpecMasterContainersLifecycle;
    /**
     * Periodic probe of container liveness. Container will be restarted if the probe fails.
     *
     * @schema JenkinsSpecMasterContainers#livenessProbe
     */
    readonly livenessProbe?: JenkinsSpecMasterContainersLivenessProbe;
    /**
     * Name of the container specified as a DNS_LABEL. Each container in a pod must have a unique name (DNS_LABEL).
     *
     * @schema JenkinsSpecMasterContainers#name
     */
    readonly name: string;
    /**
     * List of ports to expose from the container. Exposing a port here gives the system additional information about the network connections a container uses, but is primarily informational. Not specifying a port here DOES NOT prevent that port from being exposed. Any port which is listening on the default "0.0.0.0" address inside a container will be accessible from the network.
     *
     * @schema JenkinsSpecMasterContainers#ports
     */
    readonly ports?: JenkinsSpecMasterContainersPorts[];
    /**
     * Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails.
     *
     * @schema JenkinsSpecMasterContainers#readinessProbe
     */
    readonly readinessProbe?: JenkinsSpecMasterContainersReadinessProbe;
    /**
     * Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     *
     * @schema JenkinsSpecMasterContainers#resources
     */
    readonly resources: JenkinsSpecMasterContainersResources;
    /**
     * Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
     *
     * @schema JenkinsSpecMasterContainers#securityContext
     */
    readonly securityContext?: JenkinsSpecMasterContainersSecurityContext;
    /**
     * Pod volumes to mount into the container's filesystem.
     *
     * @schema JenkinsSpecMasterContainers#volumeMounts
     */
    readonly volumeMounts?: JenkinsSpecMasterContainersVolumeMounts[];
    /**
     * Container's working directory. If not specified, the container runtime's default will be used, which might be configured in the container image.
     *
     * @schema JenkinsSpecMasterContainers#workingDir
     */
    readonly workingDir?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainers' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainers(obj: JenkinsSpecMasterContainers | undefined): Record<string, any> | undefined;
/**
 * HostAlias holds the mapping between IP and hostnames that will be injected as an entry in the pod's hosts file.
 *
 * @schema JenkinsSpecMasterHostAliases
 */
export interface JenkinsSpecMasterHostAliases {
    /**
     * Hostnames for the above IP address.
     *
     * @schema JenkinsSpecMasterHostAliases#hostnames
     */
    readonly hostnames?: string[];
    /**
     * IP address of the host file entry.
     *
     * @schema JenkinsSpecMasterHostAliases#ip
     */
    readonly ip?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterHostAliases' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterHostAliases(obj: JenkinsSpecMasterHostAliases | undefined): Record<string, any> | undefined;
/**
 * LocalObjectReference contains enough information to let you locate the referenced object inside the same namespace.
 *
 * @schema JenkinsSpecMasterImagePullSecrets
 */
export interface JenkinsSpecMasterImagePullSecrets {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterImagePullSecrets#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterImagePullSecrets' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterImagePullSecrets(obj: JenkinsSpecMasterImagePullSecrets | undefined): Record<string, any> | undefined;
/**
 * Plugin defines Jenkins plugin.
 *
 * @schema JenkinsSpecMasterPlugins
 */
export interface JenkinsSpecMasterPlugins {
    /**
     * DownloadURL is the custom url from where plugin has to be downloaded.
     *
     * @schema JenkinsSpecMasterPlugins#downloadURL
     */
    readonly downloadUrl?: string;
    /**
     * Name is the name of Jenkins plugin
     *
     * @schema JenkinsSpecMasterPlugins#name
     */
    readonly name: string;
    /**
     * Version is the version of Jenkins plugin
     *
     * @schema JenkinsSpecMasterPlugins#version
     */
    readonly version: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterPlugins' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterPlugins(obj: JenkinsSpecMasterPlugins | undefined): Record<string, any> | undefined;
/**
 * SecurityContext that applies to all the containers of the Jenkins Master. As per kubernetes specification, it can be overridden for each container individually. Defaults to: runAsUser: 1000 fsGroup: 1000
 *
 * @default runAsUser: 1000 fsGroup: 1000
 * @schema JenkinsSpecMasterSecurityContext
 */
export interface JenkinsSpecMasterSecurityContext {
    /**
     * A special supplemental group that applies to all containers in a pod. Some volume types allow the Kubelet to change the ownership of that volume to be owned by the pod:
     * 1. The owning GID will be the FSGroup 2. The setgid bit is set (new files created in the volume will be owned by FSGroup) 3. The permission bits are OR'd with rw-rw----
     * If unset, the Kubelet will not modify the ownership and permissions of any volume.
     *
     * @schema JenkinsSpecMasterSecurityContext#fsGroup
     */
    readonly fsGroup?: number;
    /**
     * fsGroupChangePolicy defines behavior of changing ownership and permission of the volume before being exposed inside Pod. This field will only apply to volume types which support fsGroup based ownership(and permissions). It will have no effect on ephemeral volume types such as: secret, configmaps and emptydir. Valid values are "OnRootMismatch" and "Always". If not specified, "Always" is used.
     *
     * @schema JenkinsSpecMasterSecurityContext#fsGroupChangePolicy
     */
    readonly fsGroupChangePolicy?: string;
    /**
     * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @schema JenkinsSpecMasterSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @default user specified in image metadata if unspecified. May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     * @schema JenkinsSpecMasterSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
     *
     * @schema JenkinsSpecMasterSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: JenkinsSpecMasterSecurityContextSeLinuxOptions;
    /**
     * The seccomp options to use by the containers in this pod.
     *
     * @schema JenkinsSpecMasterSecurityContext#seccompProfile
     */
    readonly seccompProfile?: JenkinsSpecMasterSecurityContextSeccompProfile;
    /**
     * A list of groups applied to the first process run in each container, in addition to the container's primary GID.  If unspecified, no groups will be added to any container.
     *
     * @schema JenkinsSpecMasterSecurityContext#supplementalGroups
     */
    readonly supplementalGroups?: number[];
    /**
     * Sysctls hold a list of namespaced sysctls used for the pod. Pods with unsupported sysctls (by the container runtime) might fail to launch.
     *
     * @schema JenkinsSpecMasterSecurityContext#sysctls
     */
    readonly sysctls?: JenkinsSpecMasterSecurityContextSysctls[];
    /**
     * The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterSecurityContext#windowsOptions
     */
    readonly windowsOptions?: JenkinsSpecMasterSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'JenkinsSpecMasterSecurityContext' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterSecurityContext(obj: JenkinsSpecMasterSecurityContext | undefined): Record<string, any> | undefined;
/**
 * The pod this Toleration is attached to tolerates any taint that matches the triple <key,value,effect> using the matching operator <operator>.
 *
 * @schema JenkinsSpecMasterTolerations
 */
export interface JenkinsSpecMasterTolerations {
    /**
     * Effect indicates the taint effect to match. Empty means match all taint effects. When specified, allowed values are NoSchedule, PreferNoSchedule and NoExecute.
     *
     * @schema JenkinsSpecMasterTolerations#effect
     */
    readonly effect?: string;
    /**
     * Key is the taint key that the toleration applies to. Empty means match all taint keys. If the key is empty, operator must be Exists; this combination means to match all values and all keys.
     *
     * @schema JenkinsSpecMasterTolerations#key
     */
    readonly key?: string;
    /**
     * Operator represents a key's relationship to the value. Valid operators are Exists and Equal. Defaults to Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
     *
     * @default Equal. Exists is equivalent to wildcard for value, so that a pod can tolerate all taints of a particular category.
     * @schema JenkinsSpecMasterTolerations#operator
     */
    readonly operator?: string;
    /**
     * TolerationSeconds represents the period of time the toleration (which must be of effect NoExecute, otherwise this field is ignored) tolerates the taint. By default, it is not set, which means tolerate the taint forever (do not evict). Zero and negative values will be treated as 0 (evict immediately) by the system.
     *
     * @schema JenkinsSpecMasterTolerations#tolerationSeconds
     */
    readonly tolerationSeconds?: number;
    /**
     * Value is the taint value the toleration matches to. If the operator is Exists, the value should be empty, otherwise just a regular string.
     *
     * @schema JenkinsSpecMasterTolerations#value
     */
    readonly value?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterTolerations' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterTolerations(obj: JenkinsSpecMasterTolerations | undefined): Record<string, any> | undefined;
/**
 * Volume represents a named volume in a pod that may be accessed by any container in the pod.
 *
 * @schema JenkinsSpecMasterVolumes
 */
export interface JenkinsSpecMasterVolumes {
    /**
     * AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @schema JenkinsSpecMasterVolumes#awsElasticBlockStore
     */
    readonly awsElasticBlockStore?: JenkinsSpecMasterVolumesAwsElasticBlockStore;
    /**
     * AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
     *
     * @schema JenkinsSpecMasterVolumes#azureDisk
     */
    readonly azureDisk?: JenkinsSpecMasterVolumesAzureDisk;
    /**
     * AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
     *
     * @schema JenkinsSpecMasterVolumes#azureFile
     */
    readonly azureFile?: JenkinsSpecMasterVolumesAzureFile;
    /**
     * CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
     *
     * @schema JenkinsSpecMasterVolumes#cephfs
     */
    readonly cephfs?: JenkinsSpecMasterVolumesCephfs;
    /**
     * Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @schema JenkinsSpecMasterVolumes#cinder
     */
    readonly cinder?: JenkinsSpecMasterVolumesCinder;
    /**
     * ConfigMap represents a configMap that should populate this volume
     *
     * @schema JenkinsSpecMasterVolumes#configMap
     */
    readonly configMap?: JenkinsSpecMasterVolumesConfigMap;
    /**
     * CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
     *
     * @schema JenkinsSpecMasterVolumes#csi
     */
    readonly csi?: JenkinsSpecMasterVolumesCsi;
    /**
     * DownwardAPI represents downward API about the pod that should populate this volume
     *
     * @schema JenkinsSpecMasterVolumes#downwardAPI
     */
    readonly downwardApi?: JenkinsSpecMasterVolumesDownwardApi;
    /**
     * EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
     *
     * @schema JenkinsSpecMasterVolumes#emptyDir
     */
    readonly emptyDir?: JenkinsSpecMasterVolumesEmptyDir;
    /**
     * Ephemeral represents a volume that is handled by a cluster storage driver (Alpha feature). The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
     * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity    tracking are needed, c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through    a PersistentVolumeClaim (see EphemeralVolumeSource for more    information on the connection between this volume type    and PersistentVolumeClaim).
     * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
     * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
     * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
     *
     * @schema JenkinsSpecMasterVolumes#ephemeral
     */
    readonly ephemeral?: JenkinsSpecMasterVolumesEphemeral;
    /**
     * FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
     *
     * @schema JenkinsSpecMasterVolumes#fc
     */
    readonly fc?: JenkinsSpecMasterVolumesFc;
    /**
     * FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
     *
     * @schema JenkinsSpecMasterVolumes#flexVolume
     */
    readonly flexVolume?: JenkinsSpecMasterVolumesFlexVolume;
    /**
     * Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
     *
     * @schema JenkinsSpecMasterVolumes#flocker
     */
    readonly flocker?: JenkinsSpecMasterVolumesFlocker;
    /**
     * GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @schema JenkinsSpecMasterVolumes#gcePersistentDisk
     */
    readonly gcePersistentDisk?: JenkinsSpecMasterVolumesGcePersistentDisk;
    /**
     * GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
     *
     * @schema JenkinsSpecMasterVolumes#gitRepo
     */
    readonly gitRepo?: JenkinsSpecMasterVolumesGitRepo;
    /**
     * Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
     *
     * @schema JenkinsSpecMasterVolumes#glusterfs
     */
    readonly glusterfs?: JenkinsSpecMasterVolumesGlusterfs;
    /**
     * HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath --- TODO(jonesdl) We need to restrict who can use host directory mounts and who can/can not mount host directories as read/write.
     *
     * @schema JenkinsSpecMasterVolumes#hostPath
     */
    readonly hostPath?: JenkinsSpecMasterVolumesHostPath;
    /**
     * ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
     *
     * @schema JenkinsSpecMasterVolumes#iscsi
     */
    readonly iscsi?: JenkinsSpecMasterVolumesIscsi;
    /**
     * Volume's name. Must be a DNS_LABEL and unique within the pod. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names
     *
     * @schema JenkinsSpecMasterVolumes#name
     */
    readonly name: string;
    /**
     * NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @schema JenkinsSpecMasterVolumes#nfs
     */
    readonly nfs?: JenkinsSpecMasterVolumesNfs;
    /**
     * PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     *
     * @schema JenkinsSpecMasterVolumes#persistentVolumeClaim
     */
    readonly persistentVolumeClaim?: JenkinsSpecMasterVolumesPersistentVolumeClaim;
    /**
     * PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
     *
     * @schema JenkinsSpecMasterVolumes#photonPersistentDisk
     */
    readonly photonPersistentDisk?: JenkinsSpecMasterVolumesPhotonPersistentDisk;
    /**
     * PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
     *
     * @schema JenkinsSpecMasterVolumes#portworxVolume
     */
    readonly portworxVolume?: JenkinsSpecMasterVolumesPortworxVolume;
    /**
     * Items for all in one resources secrets, configmaps, and downward API
     *
     * @schema JenkinsSpecMasterVolumes#projected
     */
    readonly projected?: JenkinsSpecMasterVolumesProjected;
    /**
     * Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
     *
     * @schema JenkinsSpecMasterVolumes#quobyte
     */
    readonly quobyte?: JenkinsSpecMasterVolumesQuobyte;
    /**
     * RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
     *
     * @schema JenkinsSpecMasterVolumes#rbd
     */
    readonly rbd?: JenkinsSpecMasterVolumesRbd;
    /**
     * ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
     *
     * @schema JenkinsSpecMasterVolumes#scaleIO
     */
    readonly scaleIo?: JenkinsSpecMasterVolumesScaleIo;
    /**
     * Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
     *
     * @schema JenkinsSpecMasterVolumes#secret
     */
    readonly secret?: JenkinsSpecMasterVolumesSecret;
    /**
     * StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
     *
     * @schema JenkinsSpecMasterVolumes#storageos
     */
    readonly storageos?: JenkinsSpecMasterVolumesStorageos;
    /**
     * VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
     *
     * @schema JenkinsSpecMasterVolumes#vsphereVolume
     */
    readonly vsphereVolume?: JenkinsSpecMasterVolumesVsphereVolume;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumes' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumes(obj: JenkinsSpecMasterVolumes | undefined): Record<string, any> | undefined;
/**
 * Mailgun is handler for Mailgun email service notification channel.
 *
 * @schema JenkinsSpecNotificationsMailgun
 */
export interface JenkinsSpecNotificationsMailgun {
    /**
     * SecretKeySelector selects a key of a Secret.
     *
     * @schema JenkinsSpecNotificationsMailgun#apiKeySecretKeySelector
     */
    readonly apiKeySecretKeySelector: JenkinsSpecNotificationsMailgunApiKeySecretKeySelector;
    /**
     * @schema JenkinsSpecNotificationsMailgun#domain
     */
    readonly domain: string;
    /**
     * @schema JenkinsSpecNotificationsMailgun#from
     */
    readonly from: string;
    /**
     * @schema JenkinsSpecNotificationsMailgun#recipient
     */
    readonly recipient: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsMailgun' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsMailgun(obj: JenkinsSpecNotificationsMailgun | undefined): Record<string, any> | undefined;
/**
 * Slack is handler for Slack notification channel.
 *
 * @schema JenkinsSpecNotificationsSlack
 */
export interface JenkinsSpecNotificationsSlack {
    /**
     * The web hook URL to Slack App
     *
     * @schema JenkinsSpecNotificationsSlack#webHookURLSecretKeySelector
     */
    readonly webHookUrlSecretKeySelector: JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSlack' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSlack(obj: JenkinsSpecNotificationsSlack | undefined): Record<string, any> | undefined;
/**
 * SMTP is handler for sending emails via this protocol.
 *
 * @schema JenkinsSpecNotificationsSmtp
 */
export interface JenkinsSpecNotificationsSmtp {
    /**
     * @schema JenkinsSpecNotificationsSmtp#from
     */
    readonly from: string;
    /**
     * SecretKeySelector selects a key of a Secret.
     *
     * @schema JenkinsSpecNotificationsSmtp#passwordSecretKeySelector
     */
    readonly passwordSecretKeySelector: JenkinsSpecNotificationsSmtpPasswordSecretKeySelector;
    /**
     * @schema JenkinsSpecNotificationsSmtp#port
     */
    readonly port: number;
    /**
     * @schema JenkinsSpecNotificationsSmtp#server
     */
    readonly server: string;
    /**
     * @schema JenkinsSpecNotificationsSmtp#tlsInsecureSkipVerify
     */
    readonly tlsInsecureSkipVerify?: boolean;
    /**
     * @schema JenkinsSpecNotificationsSmtp#to
     */
    readonly to: string;
    /**
     * SecretKeySelector selects a key of a Secret.
     *
     * @schema JenkinsSpecNotificationsSmtp#usernameSecretKeySelector
     */
    readonly usernameSecretKeySelector: JenkinsSpecNotificationsSmtpUsernameSecretKeySelector;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSmtp' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSmtp(obj: JenkinsSpecNotificationsSmtp | undefined): Record<string, any> | undefined;
/**
 * MicrosoftTeams is handler for Microsoft MicrosoftTeams notification channel.
 *
 * @schema JenkinsSpecNotificationsTeams
 */
export interface JenkinsSpecNotificationsTeams {
    /**
     * The web hook URL to MicrosoftTeams App
     *
     * @schema JenkinsSpecNotificationsTeams#webHookURLSecretKeySelector
     */
    readonly webHookUrlSecretKeySelector: JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsTeams' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsTeams(obj: JenkinsSpecNotificationsTeams | undefined): Record<string, any> | undefined;
/**
 * Action defines action which performs restore backup in restore container sidecar
 *
 * @schema JenkinsSpecRestoreAction
 */
export interface JenkinsSpecRestoreAction {
    /**
     * Exec specifies the action to take.
     *
     * @schema JenkinsSpecRestoreAction#exec
     */
    readonly exec?: JenkinsSpecRestoreActionExec;
}
/**
 * Converts an object of type 'JenkinsSpecRestoreAction' to JSON representation.
 */
export declare function toJson_JenkinsSpecRestoreAction(obj: JenkinsSpecRestoreAction | undefined): Record<string, any> | undefined;
/**
 * GetLatestAction defines action which returns the latest backup number. If there is no backup "-1" should be returned.
 *
 * @schema JenkinsSpecRestoreGetLatestAction
 */
export interface JenkinsSpecRestoreGetLatestAction {
    /**
     * Exec specifies the action to take.
     *
     * @schema JenkinsSpecRestoreGetLatestAction#exec
     */
    readonly exec?: JenkinsSpecRestoreGetLatestActionExec;
}
/**
 * Converts an object of type 'JenkinsSpecRestoreGetLatestAction' to JSON representation.
 */
export declare function toJson_JenkinsSpecRestoreGetLatestAction(obj: JenkinsSpecRestoreGetLatestAction | undefined): Record<string, any> | undefined;
/**
 * Exec specifies the action to take.
 *
 * @schema JenkinsSpecBackupActionExec
 */
export interface JenkinsSpecBackupActionExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecBackupActionExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecBackupActionExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecBackupActionExec(obj: JenkinsSpecBackupActionExec | undefined): Record<string, any> | undefined;
/**
 * EnvVar represents an environment variable present in a Container.
 *
 * @schema JenkinsSpecMasterContainersEnv
 */
export interface JenkinsSpecMasterContainersEnv {
    /**
     * Name of the environment variable. Must be a C_IDENTIFIER.
     *
     * @schema JenkinsSpecMasterContainersEnv#name
     */
    readonly name: string;
    /**
     * Variable references $(VAR_NAME) are expanded using the previous defined environment variables in the container and any service environment variables. If a variable cannot be resolved, the reference in the input string will be unchanged. The $(VAR_NAME) syntax can be escaped with a double $$, ie: $$(VAR_NAME). Escaped references will never be expanded, regardless of whether the variable exists or not. Defaults to "".
     *
     * @default .
     * @schema JenkinsSpecMasterContainersEnv#value
     */
    readonly value?: string;
    /**
     * Source for the environment variable's value. Cannot be used if value is not empty.
     *
     * @schema JenkinsSpecMasterContainersEnv#valueFrom
     */
    readonly valueFrom?: JenkinsSpecMasterContainersEnvValueFrom;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnv' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnv(obj: JenkinsSpecMasterContainersEnv | undefined): Record<string, any> | undefined;
/**
 * EnvFromSource represents the source of a set of ConfigMaps
 *
 * @schema JenkinsSpecMasterContainersEnvFrom
 */
export interface JenkinsSpecMasterContainersEnvFrom {
    /**
     * The ConfigMap to select from
     *
     * @schema JenkinsSpecMasterContainersEnvFrom#configMapRef
     */
    readonly configMapRef?: JenkinsSpecMasterContainersEnvFromConfigMapRef;
    /**
     * An optional identifier to prepend to each key in the ConfigMap. Must be a C_IDENTIFIER.
     *
     * @schema JenkinsSpecMasterContainersEnvFrom#prefix
     */
    readonly prefix?: string;
    /**
     * The Secret to select from
     *
     * @schema JenkinsSpecMasterContainersEnvFrom#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterContainersEnvFromSecretRef;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvFrom' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvFrom(obj: JenkinsSpecMasterContainersEnvFrom | undefined): Record<string, any> | undefined;
/**
 * Actions that the management system should take in response to container lifecycle events.
 *
 * @schema JenkinsSpecMasterContainersLifecycle
 */
export interface JenkinsSpecMasterContainersLifecycle {
    /**
     * PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
     *
     * @schema JenkinsSpecMasterContainersLifecycle#postStart
     */
    readonly postStart?: JenkinsSpecMasterContainersLifecyclePostStart;
    /**
     * PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
     *
     * @schema JenkinsSpecMasterContainersLifecycle#preStop
     */
    readonly preStop?: JenkinsSpecMasterContainersLifecyclePreStop;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecycle' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecycle(obj: JenkinsSpecMasterContainersLifecycle | undefined): Record<string, any> | undefined;
/**
 * Periodic probe of container liveness. Container will be restarted if the probe fails.
 *
 * @schema JenkinsSpecMasterContainersLivenessProbe
 */
export interface JenkinsSpecMasterContainersLivenessProbe {
    /**
     * One and only one of the following should be specified. Exec specifies the action to take.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbe#exec
     */
    readonly exec?: JenkinsSpecMasterContainersLivenessProbeExec;
    /**
     * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
     *
     * @default 3. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersLivenessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * HTTPGet specifies the http request to perform.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbe#httpGet
     */
    readonly httpGet?: JenkinsSpecMasterContainersLivenessProbeHttpGet;
    /**
     * Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @schema JenkinsSpecMasterContainersLivenessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
     *
     * @default 10 seconds. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersLivenessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
     *
     * @default 1. Must be 1 for liveness and startup. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersLivenessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
     *
     * @schema JenkinsSpecMasterContainersLivenessProbe#tcpSocket
     */
    readonly tcpSocket?: JenkinsSpecMasterContainersLivenessProbeTcpSocket;
    /**
     * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @default 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     * @schema JenkinsSpecMasterContainersLivenessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLivenessProbe' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLivenessProbe(obj: JenkinsSpecMasterContainersLivenessProbe | undefined): Record<string, any> | undefined;
/**
 * ContainerPort represents a network port in a single container.
 *
 * @schema JenkinsSpecMasterContainersPorts
 */
export interface JenkinsSpecMasterContainersPorts {
    /**
     * Number of port to expose on the pod's IP address. This must be a valid port number, 0 < x < 65536.
     *
     * @schema JenkinsSpecMasterContainersPorts#containerPort
     */
    readonly containerPort: number;
    /**
     * What host IP to bind the external port to.
     *
     * @schema JenkinsSpecMasterContainersPorts#hostIP
     */
    readonly hostIp?: string;
    /**
     * Number of port to expose on the host. If specified, this must be a valid port number, 0 < x < 65536. If HostNetwork is specified, this must match ContainerPort. Most containers do not need this.
     *
     * @schema JenkinsSpecMasterContainersPorts#hostPort
     */
    readonly hostPort?: number;
    /**
     * If specified, this must be an IANA_SVC_NAME and unique within the pod. Each named port in a pod must have a unique name. Name for the port that can be referred to by services.
     *
     * @schema JenkinsSpecMasterContainersPorts#name
     */
    readonly name?: string;
    /**
     * Protocol for port. Must be UDP, TCP, or SCTP. Defaults to "TCP".
     *
     * @default TCP".
     * @schema JenkinsSpecMasterContainersPorts#protocol
     */
    readonly protocol?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersPorts' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersPorts(obj: JenkinsSpecMasterContainersPorts | undefined): Record<string, any> | undefined;
/**
 * Periodic probe of container service readiness. Container will be removed from service endpoints if the probe fails.
 *
 * @schema JenkinsSpecMasterContainersReadinessProbe
 */
export interface JenkinsSpecMasterContainersReadinessProbe {
    /**
     * One and only one of the following should be specified. Exec specifies the action to take.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbe#exec
     */
    readonly exec?: JenkinsSpecMasterContainersReadinessProbeExec;
    /**
     * Minimum consecutive failures for the probe to be considered failed after having succeeded. Defaults to 3. Minimum value is 1.
     *
     * @default 3. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersReadinessProbe#failureThreshold
     */
    readonly failureThreshold?: number;
    /**
     * HTTPGet specifies the http request to perform.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbe#httpGet
     */
    readonly httpGet?: JenkinsSpecMasterContainersReadinessProbeHttpGet;
    /**
     * Number of seconds after the container has started before liveness probes are initiated. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @schema JenkinsSpecMasterContainersReadinessProbe#initialDelaySeconds
     */
    readonly initialDelaySeconds?: number;
    /**
     * How often (in seconds) to perform the probe. Default to 10 seconds. Minimum value is 1.
     *
     * @default 10 seconds. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersReadinessProbe#periodSeconds
     */
    readonly periodSeconds?: number;
    /**
     * Minimum consecutive successes for the probe to be considered successful after having failed. Defaults to 1. Must be 1 for liveness and startup. Minimum value is 1.
     *
     * @default 1. Must be 1 for liveness and startup. Minimum value is 1.
     * @schema JenkinsSpecMasterContainersReadinessProbe#successThreshold
     */
    readonly successThreshold?: number;
    /**
     * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
     *
     * @schema JenkinsSpecMasterContainersReadinessProbe#tcpSocket
     */
    readonly tcpSocket?: JenkinsSpecMasterContainersReadinessProbeTcpSocket;
    /**
     * Number of seconds after which the probe times out. Defaults to 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     *
     * @default 1 second. Minimum value is 1. More info: https://kubernetes.io/docs/concepts/workloads/pods/pod-lifecycle#container-probes
     * @schema JenkinsSpecMasterContainersReadinessProbe#timeoutSeconds
     */
    readonly timeoutSeconds?: number;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersReadinessProbe' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersReadinessProbe(obj: JenkinsSpecMasterContainersReadinessProbe | undefined): Record<string, any> | undefined;
/**
 * Compute Resources required by this container. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
 *
 * @schema JenkinsSpecMasterContainersResources
 */
export interface JenkinsSpecMasterContainersResources {
    /**
     * Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     *
     * @schema JenkinsSpecMasterContainersResources#limits
     */
    readonly limits?: {
        [key: string]: JenkinsSpecMasterContainersResourcesLimits;
    };
    /**
     * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     *
     * @schema JenkinsSpecMasterContainersResources#requests
     */
    readonly requests?: {
        [key: string]: JenkinsSpecMasterContainersResourcesRequests;
    };
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersResources' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersResources(obj: JenkinsSpecMasterContainersResources | undefined): Record<string, any> | undefined;
/**
 * Security options the pod should run with. More info: https://kubernetes.io/docs/concepts/policy/security-context/ More info: https://kubernetes.io/docs/tasks/configure-pod-container/security-context/
 *
 * @schema JenkinsSpecMasterContainersSecurityContext
 */
export interface JenkinsSpecMasterContainersSecurityContext {
    /**
     * AllowPrivilegeEscalation controls whether a process can gain more privileges than its parent process. This bool directly controls if the no_new_privs flag will be set on the container process. AllowPrivilegeEscalation is true always when the container is: 1) run as Privileged 2) has CAP_SYS_ADMIN
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#allowPrivilegeEscalation
     */
    readonly allowPrivilegeEscalation?: boolean;
    /**
     * The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.
     *
     * @default the default set of capabilities granted by the container runtime.
     * @schema JenkinsSpecMasterContainersSecurityContext#capabilities
     */
    readonly capabilities?: JenkinsSpecMasterContainersSecurityContextCapabilities;
    /**
     * Run container in privileged mode. Processes in privileged containers are essentially equivalent to root on the host. Defaults to false.
     *
     * @default false.
     * @schema JenkinsSpecMasterContainersSecurityContext#privileged
     */
    readonly privileged?: boolean;
    /**
     * procMount denotes the type of proc mount to use for the containers. The default is DefaultProcMount which uses the container runtime defaults for readonly paths and masked paths. This requires the ProcMountType feature flag to be enabled.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#procMount
     */
    readonly procMount?: string;
    /**
     * Whether this container has a read-only root filesystem. Default is false.
     *
     * @default false.
     * @schema JenkinsSpecMasterContainersSecurityContext#readOnlyRootFilesystem
     */
    readonly readOnlyRootFilesystem?: boolean;
    /**
     * The GID to run the entrypoint of the container process. Uses runtime default if unset. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#runAsGroup
     */
    readonly runAsGroup?: number;
    /**
     * Indicates that the container must run as a non-root user. If true, the Kubelet will validate the image at runtime to ensure that it does not run as UID 0 (root) and fail to start the container if it does. If unset or false, no such validation will be performed. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#runAsNonRoot
     */
    readonly runAsNonRoot?: boolean;
    /**
     * The UID to run the entrypoint of the container process. Defaults to user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @default user specified in image metadata if unspecified. May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     * @schema JenkinsSpecMasterContainersSecurityContext#runAsUser
     */
    readonly runAsUser?: number;
    /**
     * The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#seLinuxOptions
     */
    readonly seLinuxOptions?: JenkinsSpecMasterContainersSecurityContextSeLinuxOptions;
    /**
     * The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#seccompProfile
     */
    readonly seccompProfile?: JenkinsSpecMasterContainersSecurityContextSeccompProfile;
    /**
     * The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @schema JenkinsSpecMasterContainersSecurityContext#windowsOptions
     */
    readonly windowsOptions?: JenkinsSpecMasterContainersSecurityContextWindowsOptions;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersSecurityContext' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersSecurityContext(obj: JenkinsSpecMasterContainersSecurityContext | undefined): Record<string, any> | undefined;
/**
 * VolumeMount describes a mounting of a Volume within a container.
 *
 * @schema JenkinsSpecMasterContainersVolumeMounts
 */
export interface JenkinsSpecMasterContainersVolumeMounts {
    /**
     * Path within the container at which the volume should be mounted.  Must not contain ':'.
     *
     * @schema JenkinsSpecMasterContainersVolumeMounts#mountPath
     */
    readonly mountPath: string;
    /**
     * mountPropagation determines how mounts are propagated from the host to container and the other way around. When not set, MountPropagationNone is used. This field is beta in 1.10.
     *
     * @schema JenkinsSpecMasterContainersVolumeMounts#mountPropagation
     */
    readonly mountPropagation?: string;
    /**
     * This must match the Name of a Volume.
     *
     * @schema JenkinsSpecMasterContainersVolumeMounts#name
     */
    readonly name: string;
    /**
     * Mounted read-only if true, read-write otherwise (false or unspecified). Defaults to false.
     *
     * @default false.
     * @schema JenkinsSpecMasterContainersVolumeMounts#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Path within the volume from which the container's volume should be mounted. Defaults to "" (volume's root).
     *
     * @default volume's root).
     * @schema JenkinsSpecMasterContainersVolumeMounts#subPath
     */
    readonly subPath?: string;
    /**
     * Expanded path within the volume from which the container's volume should be mounted. Behaves similarly to SubPath but environment variable references $(VAR_NAME) are expanded using the container's environment. Defaults to "" (volume's root). SubPathExpr and SubPath are mutually exclusive.
     *
     * @default volume's root). SubPathExpr and SubPath are mutually exclusive.
     * @schema JenkinsSpecMasterContainersVolumeMounts#subPathExpr
     */
    readonly subPathExpr?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersVolumeMounts' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersVolumeMounts(obj: JenkinsSpecMasterContainersVolumeMounts | undefined): Record<string, any> | undefined;
/**
 * The SELinux context to be applied to all containers. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in SecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence for that container.
 *
 * @schema JenkinsSpecMasterSecurityContextSeLinuxOptions
 */
export interface JenkinsSpecMasterSecurityContextSeLinuxOptions {
    /**
     * Level is SELinux level label that applies to the container.
     *
     * @schema JenkinsSpecMasterSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * Role is a SELinux role label that applies to the container.
     *
     * @schema JenkinsSpecMasterSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * Type is a SELinux type label that applies to the container.
     *
     * @schema JenkinsSpecMasterSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * User is a SELinux user label that applies to the container.
     *
     * @schema JenkinsSpecMasterSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterSecurityContextSeLinuxOptions(obj: JenkinsSpecMasterSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * The seccomp options to use by the containers in this pod.
 *
 * @schema JenkinsSpecMasterSecurityContextSeccompProfile
 */
export interface JenkinsSpecMasterSecurityContextSeccompProfile {
    /**
     * localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is "Localhost".
     *
     * @schema JenkinsSpecMasterSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * type indicates which kind of seccomp profile will be applied. Valid options are:
     * Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
     *
     * @schema JenkinsSpecMasterSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterSecurityContextSeccompProfile(obj: JenkinsSpecMasterSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * Sysctl defines a kernel parameter to be set
 *
 * @schema JenkinsSpecMasterSecurityContextSysctls
 */
export interface JenkinsSpecMasterSecurityContextSysctls {
    /**
     * Name of a property to set
     *
     * @schema JenkinsSpecMasterSecurityContextSysctls#name
     */
    readonly name: string;
    /**
     * Value of a property to set
     *
     * @schema JenkinsSpecMasterSecurityContextSysctls#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterSecurityContextSysctls' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterSecurityContextSysctls(obj: JenkinsSpecMasterSecurityContextSysctls | undefined): Record<string, any> | undefined;
/**
 * The Windows specific settings applied to all containers. If unspecified, the options within a container's SecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
 *
 * @schema JenkinsSpecMasterSecurityContextWindowsOptions
 */
export interface JenkinsSpecMasterSecurityContextWindowsOptions {
    /**
     * GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
     *
     * @schema JenkinsSpecMasterSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * GMSACredentialSpecName is the name of the GMSA credential spec to use.
     *
     * @schema JenkinsSpecMasterSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @default the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     * @schema JenkinsSpecMasterSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterSecurityContextWindowsOptions(obj: JenkinsSpecMasterSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * AWSElasticBlockStore represents an AWS Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
 *
 * @schema JenkinsSpecMasterVolumesAwsElasticBlockStore
 */
export interface JenkinsSpecMasterVolumesAwsElasticBlockStore {
    /**
     * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore TODO: how do we prevent errors in the filesystem from compromising the machine
     *
     * @schema JenkinsSpecMasterVolumesAwsElasticBlockStore#fsType
     */
    readonly fsType?: string;
    /**
     * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty).
     *
     * @schema JenkinsSpecMasterVolumesAwsElasticBlockStore#partition
     */
    readonly partition?: number;
    /**
     * Specify "true" to force and set the ReadOnly property in VolumeMounts to "true". If omitted, the default is "false". More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @schema JenkinsSpecMasterVolumesAwsElasticBlockStore#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Unique ID of the persistent disk resource in AWS (Amazon EBS volume). More info: https://kubernetes.io/docs/concepts/storage/volumes#awselasticblockstore
     *
     * @schema JenkinsSpecMasterVolumesAwsElasticBlockStore#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesAwsElasticBlockStore' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesAwsElasticBlockStore(obj: JenkinsSpecMasterVolumesAwsElasticBlockStore | undefined): Record<string, any> | undefined;
/**
 * AzureDisk represents an Azure Data Disk mount on the host and bind mount to the pod.
 *
 * @schema JenkinsSpecMasterVolumesAzureDisk
 */
export interface JenkinsSpecMasterVolumesAzureDisk {
    /**
     * Host Caching mode: None, Read Only, Read Write.
     *
     * @schema JenkinsSpecMasterVolumesAzureDisk#cachingMode
     */
    readonly cachingMode?: string;
    /**
     * The Name of the data disk in the blob storage
     *
     * @schema JenkinsSpecMasterVolumesAzureDisk#diskName
     */
    readonly diskName: string;
    /**
     * The URI the data disk in the blob storage
     *
     * @schema JenkinsSpecMasterVolumesAzureDisk#diskURI
     */
    readonly diskUri: string;
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @schema JenkinsSpecMasterVolumesAzureDisk#fsType
     */
    readonly fsType?: string;
    /**
     * Expected values Shared: multiple blob disks per storage account  Dedicated: single blob disk per storage account  Managed: azure managed data disk (only in managed availability set). defaults to shared
     *
     * @schema JenkinsSpecMasterVolumesAzureDisk#kind
     */
    readonly kind?: string;
    /**
     * Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesAzureDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesAzureDisk' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesAzureDisk(obj: JenkinsSpecMasterVolumesAzureDisk | undefined): Record<string, any> | undefined;
/**
 * AzureFile represents an Azure File Service mount on the host and bind mount to the pod.
 *
 * @schema JenkinsSpecMasterVolumesAzureFile
 */
export interface JenkinsSpecMasterVolumesAzureFile {
    /**
     * Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesAzureFile#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * the name of secret that contains Azure Storage Account Name and Key
     *
     * @schema JenkinsSpecMasterVolumesAzureFile#secretName
     */
    readonly secretName: string;
    /**
     * Share Name
     *
     * @schema JenkinsSpecMasterVolumesAzureFile#shareName
     */
    readonly shareName: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesAzureFile' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesAzureFile(obj: JenkinsSpecMasterVolumesAzureFile | undefined): Record<string, any> | undefined;
/**
 * CephFS represents a Ceph FS mount on the host that shares a pod's lifetime
 *
 * @schema JenkinsSpecMasterVolumesCephfs
 */
export interface JenkinsSpecMasterVolumesCephfs {
    /**
     * Required: Monitors is a collection of Ceph monitors More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesCephfs#monitors
     */
    readonly monitors: string[];
    /**
     * Optional: Used as the mounted root, rather than the full Ceph tree, default is /
     *
     * @schema JenkinsSpecMasterVolumesCephfs#path
     */
    readonly path?: string;
    /**
     * Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesCephfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Optional: SecretFile is the path to key ring for User, default is /etc/ceph/user.secret More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesCephfs#secretFile
     */
    readonly secretFile?: string;
    /**
     * Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesCephfs#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesCephfsSecretRef;
    /**
     * Optional: User is the rados user name, default is admin More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesCephfs#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCephfs' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCephfs(obj: JenkinsSpecMasterVolumesCephfs | undefined): Record<string, any> | undefined;
/**
 * Cinder represents a cinder volume attached and mounted on kubelets host machine. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
 *
 * @schema JenkinsSpecMasterVolumesCinder
 */
export interface JenkinsSpecMasterVolumesCinder {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @schema JenkinsSpecMasterVolumesCinder#fsType
     */
    readonly fsType?: string;
    /**
     * Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     * @schema JenkinsSpecMasterVolumesCinder#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Optional: points to a secret object containing parameters used to connect to OpenStack.
     *
     * @schema JenkinsSpecMasterVolumesCinder#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesCinderSecretRef;
    /**
     * volume id used to identify the volume in cinder. More info: https://examples.k8s.io/mysql-cinder-pd/README.md
     *
     * @schema JenkinsSpecMasterVolumesCinder#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCinder' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCinder(obj: JenkinsSpecMasterVolumesCinder | undefined): Record<string, any> | undefined;
/**
 * ConfigMap represents a configMap that should populate this volume
 *
 * @schema JenkinsSpecMasterVolumesConfigMap
 */
export interface JenkinsSpecMasterVolumesConfigMap {
    /**
     * Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @default 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     * @schema JenkinsSpecMasterVolumesConfigMap#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
     *
     * @schema JenkinsSpecMasterVolumesConfigMap#items
     */
    readonly items?: JenkinsSpecMasterVolumesConfigMapItems[];
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesConfigMap#name
     */
    readonly name?: string;
    /**
     * Specify whether the ConfigMap or its keys must be defined
     *
     * @schema JenkinsSpecMasterVolumesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesConfigMap' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesConfigMap(obj: JenkinsSpecMasterVolumesConfigMap | undefined): Record<string, any> | undefined;
/**
 * CSI (Container Storage Interface) represents ephemeral storage that is handled by certain external CSI drivers (Beta feature).
 *
 * @schema JenkinsSpecMasterVolumesCsi
 */
export interface JenkinsSpecMasterVolumesCsi {
    /**
     * Driver is the name of the CSI driver that handles this volume. Consult with your admin for the correct name as registered in the cluster.
     *
     * @schema JenkinsSpecMasterVolumesCsi#driver
     */
    readonly driver: string;
    /**
     * Filesystem type to mount. Ex. "ext4", "xfs", "ntfs". If not provided, the empty value is passed to the associated CSI driver which will determine the default filesystem to apply.
     *
     * @schema JenkinsSpecMasterVolumesCsi#fsType
     */
    readonly fsType?: string;
    /**
     * NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
     *
     * @schema JenkinsSpecMasterVolumesCsi#nodePublishSecretRef
     */
    readonly nodePublishSecretRef?: JenkinsSpecMasterVolumesCsiNodePublishSecretRef;
    /**
     * Specifies a read-only configuration for the volume. Defaults to false (read/write).
     *
     * @default false (read/write).
     * @schema JenkinsSpecMasterVolumesCsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * VolumeAttributes stores driver-specific properties that are passed to the CSI driver. Consult your driver's documentation for supported values.
     *
     * @schema JenkinsSpecMasterVolumesCsi#volumeAttributes
     */
    readonly volumeAttributes?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCsi' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCsi(obj: JenkinsSpecMasterVolumesCsi | undefined): Record<string, any> | undefined;
/**
 * DownwardAPI represents downward API about the pod that should populate this volume
 *
 * @schema JenkinsSpecMasterVolumesDownwardApi
 */
export interface JenkinsSpecMasterVolumesDownwardApi {
    /**
     * Optional: mode bits to use on created files by default. Must be a Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @default 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     * @schema JenkinsSpecMasterVolumesDownwardApi#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * Items is a list of downward API volume file
     *
     * @schema JenkinsSpecMasterVolumesDownwardApi#items
     */
    readonly items?: JenkinsSpecMasterVolumesDownwardApiItems[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesDownwardApi' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesDownwardApi(obj: JenkinsSpecMasterVolumesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * EmptyDir represents a temporary directory that shares a pod's lifetime. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
 *
 * @schema JenkinsSpecMasterVolumesEmptyDir
 */
export interface JenkinsSpecMasterVolumesEmptyDir {
    /**
     * What type of storage medium should back this directory. The default is "" which means to use the node's default medium. Must be an empty string (default) or Memory. More info: https://kubernetes.io/docs/concepts/storage/volumes#emptydir
     *
     * @schema JenkinsSpecMasterVolumesEmptyDir#medium
     */
    readonly medium?: string;
    /**
     * Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
     *
     * @schema JenkinsSpecMasterVolumesEmptyDir#sizeLimit
     */
    readonly sizeLimit?: JenkinsSpecMasterVolumesEmptyDirSizeLimit;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEmptyDir' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEmptyDir(obj: JenkinsSpecMasterVolumesEmptyDir | undefined): Record<string, any> | undefined;
/**
 * Ephemeral represents a volume that is handled by a cluster storage driver (Alpha feature). The volume's lifecycle is tied to the pod that defines it - it will be created before the pod starts, and deleted when the pod is removed.
 * Use this if: a) the volume is only needed while the pod runs, b) features of normal volumes like restoring from snapshot or capacity    tracking are needed, c) the storage driver is specified through a storage class, and d) the storage driver supports dynamic volume provisioning through    a PersistentVolumeClaim (see EphemeralVolumeSource for more    information on the connection between this volume type    and PersistentVolumeClaim).
 * Use PersistentVolumeClaim or one of the vendor-specific APIs for volumes that persist for longer than the lifecycle of an individual pod.
 * Use CSI for light-weight local ephemeral volumes if the CSI driver is meant to be used that way - see the documentation of the driver for more information.
 * A pod can use both types of ephemeral volumes and persistent volumes at the same time.
 *
 * @schema JenkinsSpecMasterVolumesEphemeral
 */
export interface JenkinsSpecMasterVolumesEphemeral {
    /**
     * Specifies a read-only configuration for the volume. Defaults to false (read/write).
     *
     * @default false (read/write).
     * @schema JenkinsSpecMasterVolumesEphemeral#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).
     * An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.
     * This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.
     * Required, must not be nil.
     *
     * @schema JenkinsSpecMasterVolumesEphemeral#volumeClaimTemplate
     */
    readonly volumeClaimTemplate?: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeral' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeral(obj: JenkinsSpecMasterVolumesEphemeral | undefined): Record<string, any> | undefined;
/**
 * FC represents a Fibre Channel resource that is attached to a kubelet's host machine and then exposed to the pod.
 *
 * @schema JenkinsSpecMasterVolumesFc
 */
export interface JenkinsSpecMasterVolumesFc {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. TODO: how do we prevent errors in the filesystem from compromising the machine
     *
     * @schema JenkinsSpecMasterVolumesFc#fsType
     */
    readonly fsType?: string;
    /**
     * Optional: FC target lun number
     *
     * @schema JenkinsSpecMasterVolumesFc#lun
     */
    readonly lun?: number;
    /**
     * Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesFc#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Optional: FC target worldwide names (WWNs)
     *
     * @schema JenkinsSpecMasterVolumesFc#targetWWNs
     */
    readonly targetWwNs?: string[];
    /**
     * Optional: FC volume world wide identifiers (wwids) Either wwids or combination of targetWWNs and lun must be set, but not both simultaneously.
     *
     * @schema JenkinsSpecMasterVolumesFc#wwids
     */
    readonly wwids?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesFc' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesFc(obj: JenkinsSpecMasterVolumesFc | undefined): Record<string, any> | undefined;
/**
 * FlexVolume represents a generic volume resource that is provisioned/attached using an exec based plugin.
 *
 * @schema JenkinsSpecMasterVolumesFlexVolume
 */
export interface JenkinsSpecMasterVolumesFlexVolume {
    /**
     * Driver is the name of the driver to use for this volume.
     *
     * @schema JenkinsSpecMasterVolumesFlexVolume#driver
     */
    readonly driver: string;
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". The default filesystem depends on FlexVolume script.
     *
     * @schema JenkinsSpecMasterVolumesFlexVolume#fsType
     */
    readonly fsType?: string;
    /**
     * Optional: Extra command options if any.
     *
     * @schema JenkinsSpecMasterVolumesFlexVolume#options
     */
    readonly options?: {
        [key: string]: string;
    };
    /**
     * Optional: Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesFlexVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
     *
     * @schema JenkinsSpecMasterVolumesFlexVolume#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesFlexVolumeSecretRef;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesFlexVolume' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesFlexVolume(obj: JenkinsSpecMasterVolumesFlexVolume | undefined): Record<string, any> | undefined;
/**
 * Flocker represents a Flocker volume attached to a kubelet's host machine. This depends on the Flocker control service being running
 *
 * @schema JenkinsSpecMasterVolumesFlocker
 */
export interface JenkinsSpecMasterVolumesFlocker {
    /**
     * Name of the dataset stored as metadata -> name on the dataset for Flocker should be considered as deprecated
     *
     * @schema JenkinsSpecMasterVolumesFlocker#datasetName
     */
    readonly datasetName?: string;
    /**
     * UUID of the dataset. This is unique identifier of a Flocker dataset
     *
     * @schema JenkinsSpecMasterVolumesFlocker#datasetUUID
     */
    readonly datasetUuid?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesFlocker' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesFlocker(obj: JenkinsSpecMasterVolumesFlocker | undefined): Record<string, any> | undefined;
/**
 * GCEPersistentDisk represents a GCE Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
 *
 * @schema JenkinsSpecMasterVolumesGcePersistentDisk
 */
export interface JenkinsSpecMasterVolumesGcePersistentDisk {
    /**
     * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk TODO: how do we prevent errors in the filesystem from compromising the machine
     *
     * @schema JenkinsSpecMasterVolumesGcePersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * The partition in the volume that you want to mount. If omitted, the default is to mount by volume name. Examples: For volume /dev/sda1, you specify the partition as "1". Similarly, the volume partition for /dev/sda is "0" (or you can leave the property empty). More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @schema JenkinsSpecMasterVolumesGcePersistentDisk#partition
     */
    readonly partition?: number;
    /**
     * Unique name of the PD resource in GCE. Used to identify the disk in GCE. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @schema JenkinsSpecMasterVolumesGcePersistentDisk#pdName
     */
    readonly pdName: string;
    /**
     * ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     *
     * @default false. More info: https://kubernetes.io/docs/concepts/storage/volumes#gcepersistentdisk
     * @schema JenkinsSpecMasterVolumesGcePersistentDisk#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesGcePersistentDisk' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesGcePersistentDisk(obj: JenkinsSpecMasterVolumesGcePersistentDisk | undefined): Record<string, any> | undefined;
/**
 * GitRepo represents a git repository at a particular revision. DEPRECATED: GitRepo is deprecated. To provision a container with a git repo, mount an EmptyDir into an InitContainer that clones the repo using git, then mount the EmptyDir into the Pod's container.
 *
 * @schema JenkinsSpecMasterVolumesGitRepo
 */
export interface JenkinsSpecMasterVolumesGitRepo {
    /**
     * Target directory name. Must not contain or start with '..'.  If '.' is supplied, the volume directory will be the git repository.  Otherwise, if specified, the volume will contain the git repository in the subdirectory with the given name.
     *
     * @schema JenkinsSpecMasterVolumesGitRepo#directory
     */
    readonly directory?: string;
    /**
     * Repository URL
     *
     * @schema JenkinsSpecMasterVolumesGitRepo#repository
     */
    readonly repository: string;
    /**
     * Commit hash for the specified revision.
     *
     * @schema JenkinsSpecMasterVolumesGitRepo#revision
     */
    readonly revision?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesGitRepo' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesGitRepo(obj: JenkinsSpecMasterVolumesGitRepo | undefined): Record<string, any> | undefined;
/**
 * Glusterfs represents a Glusterfs mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/glusterfs/README.md
 *
 * @schema JenkinsSpecMasterVolumesGlusterfs
 */
export interface JenkinsSpecMasterVolumesGlusterfs {
    /**
     * EndpointsName is the endpoint name that details Glusterfs topology. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @schema JenkinsSpecMasterVolumesGlusterfs#endpoints
     */
    readonly endpoints: string;
    /**
     * Path is the Glusterfs volume path. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @schema JenkinsSpecMasterVolumesGlusterfs#path
     */
    readonly path: string;
    /**
     * ReadOnly here will force the Glusterfs volume to be mounted with read-only permissions. Defaults to false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     *
     * @default false. More info: https://examples.k8s.io/volumes/glusterfs/README.md#create-a-pod
     * @schema JenkinsSpecMasterVolumesGlusterfs#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesGlusterfs' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesGlusterfs(obj: JenkinsSpecMasterVolumesGlusterfs | undefined): Record<string, any> | undefined;
/**
 * HostPath represents a pre-existing file or directory on the host machine that is directly exposed to the container. This is generally used for system agents or other privileged things that are allowed to see the host machine. Most containers will NOT need this. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath --- TODO(jonesdl) We need to restrict who can use host directory mounts and who can/can not mount host directories as read/write.
 *
 * @schema JenkinsSpecMasterVolumesHostPath
 */
export interface JenkinsSpecMasterVolumesHostPath {
    /**
     * Path of the directory on the host. If the path is a symlink, it will follow the link to the real path. More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     *
     * @schema JenkinsSpecMasterVolumesHostPath#path
     */
    readonly path: string;
    /**
     * Type for HostPath Volume Defaults to "" More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     *
     * @default More info: https://kubernetes.io/docs/concepts/storage/volumes#hostpath
     * @schema JenkinsSpecMasterVolumesHostPath#type
     */
    readonly type?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesHostPath' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesHostPath(obj: JenkinsSpecMasterVolumesHostPath | undefined): Record<string, any> | undefined;
/**
 * ISCSI represents an ISCSI Disk resource that is attached to a kubelet's host machine and then exposed to the pod. More info: https://examples.k8s.io/volumes/iscsi/README.md
 *
 * @schema JenkinsSpecMasterVolumesIscsi
 */
export interface JenkinsSpecMasterVolumesIscsi {
    /**
     * whether support iSCSI Discovery CHAP authentication
     *
     * @schema JenkinsSpecMasterVolumesIscsi#chapAuthDiscovery
     */
    readonly chapAuthDiscovery?: boolean;
    /**
     * whether support iSCSI Session CHAP authentication
     *
     * @schema JenkinsSpecMasterVolumesIscsi#chapAuthSession
     */
    readonly chapAuthSession?: boolean;
    /**
     * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#iscsi TODO: how do we prevent errors in the filesystem from compromising the machine
     *
     * @schema JenkinsSpecMasterVolumesIscsi#fsType
     */
    readonly fsType?: string;
    /**
     * Custom iSCSI Initiator Name. If initiatorName is specified with iscsiInterface simultaneously, new iSCSI interface <target portal>:<volume name> will be created for the connection.
     *
     * @schema JenkinsSpecMasterVolumesIscsi#initiatorName
     */
    readonly initiatorName?: string;
    /**
     * Target iSCSI Qualified Name.
     *
     * @schema JenkinsSpecMasterVolumesIscsi#iqn
     */
    readonly iqn: string;
    /**
     * iSCSI Interface Name that uses an iSCSI transport. Defaults to 'default' (tcp).
     *
     * @default default' (tcp).
     * @schema JenkinsSpecMasterVolumesIscsi#iscsiInterface
     */
    readonly iscsiInterface?: string;
    /**
     * iSCSI Target Lun number.
     *
     * @schema JenkinsSpecMasterVolumesIscsi#lun
     */
    readonly lun: number;
    /**
     * iSCSI Target Portal List. The portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
     *
     * @schema JenkinsSpecMasterVolumesIscsi#portals
     */
    readonly portals?: string[];
    /**
     * ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false.
     *
     * @default false.
     * @schema JenkinsSpecMasterVolumesIscsi#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * CHAP Secret for iSCSI target and initiator authentication
     *
     * @schema JenkinsSpecMasterVolumesIscsi#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesIscsiSecretRef;
    /**
     * iSCSI Target Portal. The Portal is either an IP or ip_addr:port if the port is other than default (typically TCP ports 860 and 3260).
     *
     * @schema JenkinsSpecMasterVolumesIscsi#targetPortal
     */
    readonly targetPortal: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesIscsi' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesIscsi(obj: JenkinsSpecMasterVolumesIscsi | undefined): Record<string, any> | undefined;
/**
 * NFS represents an NFS mount on the host that shares a pod's lifetime More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
 *
 * @schema JenkinsSpecMasterVolumesNfs
 */
export interface JenkinsSpecMasterVolumesNfs {
    /**
     * Path that is exported by the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @schema JenkinsSpecMasterVolumesNfs#path
     */
    readonly path: string;
    /**
     * ReadOnly here will force the NFS export to be mounted with read-only permissions. Defaults to false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @default false. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     * @schema JenkinsSpecMasterVolumesNfs#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Server is the hostname or IP address of the NFS server. More info: https://kubernetes.io/docs/concepts/storage/volumes#nfs
     *
     * @schema JenkinsSpecMasterVolumesNfs#server
     */
    readonly server: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesNfs' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesNfs(obj: JenkinsSpecMasterVolumesNfs | undefined): Record<string, any> | undefined;
/**
 * PersistentVolumeClaimVolumeSource represents a reference to a PersistentVolumeClaim in the same namespace. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
 *
 * @schema JenkinsSpecMasterVolumesPersistentVolumeClaim
 */
export interface JenkinsSpecMasterVolumesPersistentVolumeClaim {
    /**
     * ClaimName is the name of a PersistentVolumeClaim in the same namespace as the pod using this volume. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#persistentvolumeclaims
     *
     * @schema JenkinsSpecMasterVolumesPersistentVolumeClaim#claimName
     */
    readonly claimName: string;
    /**
     * Will force the ReadOnly setting in VolumeMounts. Default false.
     *
     * @schema JenkinsSpecMasterVolumesPersistentVolumeClaim#readOnly
     */
    readonly readOnly?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesPersistentVolumeClaim' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesPersistentVolumeClaim(obj: JenkinsSpecMasterVolumesPersistentVolumeClaim | undefined): Record<string, any> | undefined;
/**
 * PhotonPersistentDisk represents a PhotonController persistent disk attached and mounted on kubelets host machine
 *
 * @schema JenkinsSpecMasterVolumesPhotonPersistentDisk
 */
export interface JenkinsSpecMasterVolumesPhotonPersistentDisk {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @schema JenkinsSpecMasterVolumesPhotonPersistentDisk#fsType
     */
    readonly fsType?: string;
    /**
     * ID that identifies Photon Controller persistent disk
     *
     * @schema JenkinsSpecMasterVolumesPhotonPersistentDisk#pdID
     */
    readonly pdId: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesPhotonPersistentDisk' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesPhotonPersistentDisk(obj: JenkinsSpecMasterVolumesPhotonPersistentDisk | undefined): Record<string, any> | undefined;
/**
 * PortworxVolume represents a portworx volume attached and mounted on kubelets host machine
 *
 * @schema JenkinsSpecMasterVolumesPortworxVolume
 */
export interface JenkinsSpecMasterVolumesPortworxVolume {
    /**
     * FSType represents the filesystem type to mount Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @schema JenkinsSpecMasterVolumesPortworxVolume#fsType
     */
    readonly fsType?: string;
    /**
     * Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesPortworxVolume#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * VolumeID uniquely identifies a Portworx volume
     *
     * @schema JenkinsSpecMasterVolumesPortworxVolume#volumeID
     */
    readonly volumeId: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesPortworxVolume' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesPortworxVolume(obj: JenkinsSpecMasterVolumesPortworxVolume | undefined): Record<string, any> | undefined;
/**
 * Items for all in one resources secrets, configmaps, and downward API
 *
 * @schema JenkinsSpecMasterVolumesProjected
 */
export interface JenkinsSpecMasterVolumesProjected {
    /**
     * Mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesProjected#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * list of volume projections
     *
     * @schema JenkinsSpecMasterVolumesProjected#sources
     */
    readonly sources?: JenkinsSpecMasterVolumesProjectedSources[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjected' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjected(obj: JenkinsSpecMasterVolumesProjected | undefined): Record<string, any> | undefined;
/**
 * Quobyte represents a Quobyte mount on the host that shares a pod's lifetime
 *
 * @schema JenkinsSpecMasterVolumesQuobyte
 */
export interface JenkinsSpecMasterVolumesQuobyte {
    /**
     * Group to map volume access to Default is no group
     *
     * @default no group
     * @schema JenkinsSpecMasterVolumesQuobyte#group
     */
    readonly group?: string;
    /**
     * ReadOnly here will force the Quobyte volume to be mounted with read-only permissions. Defaults to false.
     *
     * @default false.
     * @schema JenkinsSpecMasterVolumesQuobyte#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * Registry represents a single or multiple Quobyte Registry services specified as a string as host:port pair (multiple entries are separated with commas) which acts as the central registry for volumes
     *
     * @schema JenkinsSpecMasterVolumesQuobyte#registry
     */
    readonly registry: string;
    /**
     * Tenant owning the given Quobyte volume in the Backend Used with dynamically provisioned Quobyte volumes, value is set by the plugin
     *
     * @schema JenkinsSpecMasterVolumesQuobyte#tenant
     */
    readonly tenant?: string;
    /**
     * User to map volume access to Defaults to serivceaccount user
     *
     * @default serivceaccount user
     * @schema JenkinsSpecMasterVolumesQuobyte#user
     */
    readonly user?: string;
    /**
     * Volume is a string that references an already created Quobyte volume by name.
     *
     * @schema JenkinsSpecMasterVolumesQuobyte#volume
     */
    readonly volume: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesQuobyte' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesQuobyte(obj: JenkinsSpecMasterVolumesQuobyte | undefined): Record<string, any> | undefined;
/**
 * RBD represents a Rados Block Device mount on the host that shares a pod's lifetime. More info: https://examples.k8s.io/volumes/rbd/README.md
 *
 * @schema JenkinsSpecMasterVolumesRbd
 */
export interface JenkinsSpecMasterVolumesRbd {
    /**
     * Filesystem type of the volume that you want to mount. Tip: Ensure that the filesystem type is supported by the host operating system. Examples: "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified. More info: https://kubernetes.io/docs/concepts/storage/volumes#rbd TODO: how do we prevent errors in the filesystem from compromising the machine
     *
     * @schema JenkinsSpecMasterVolumesRbd#fsType
     */
    readonly fsType?: string;
    /**
     * The rados image name. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesRbd#image
     */
    readonly image: string;
    /**
     * Keyring is the path to key ring for RBDUser. Default is /etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default etc/ceph/keyring. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesRbd#keyring
     */
    readonly keyring?: string;
    /**
     * A collection of Ceph monitors. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @schema JenkinsSpecMasterVolumesRbd#monitors
     */
    readonly monitors: string[];
    /**
     * The rados pool name. Default is rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default rbd. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesRbd#pool
     */
    readonly pool?: string;
    /**
     * ReadOnly here will force the ReadOnly setting in VolumeMounts. Defaults to false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default false. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesRbd#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesRbd#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesRbdSecretRef;
    /**
     * The rados user name. Default is admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     *
     * @default admin. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
     * @schema JenkinsSpecMasterVolumesRbd#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesRbd' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesRbd(obj: JenkinsSpecMasterVolumesRbd | undefined): Record<string, any> | undefined;
/**
 * ScaleIO represents a ScaleIO persistent volume attached and mounted on Kubernetes nodes.
 *
 * @schema JenkinsSpecMasterVolumesScaleIo
 */
export interface JenkinsSpecMasterVolumesScaleIo {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Default is "xfs".
     *
     * @default xfs".
     * @schema JenkinsSpecMasterVolumesScaleIo#fsType
     */
    readonly fsType?: string;
    /**
     * The host address of the ScaleIO API Gateway.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#gateway
     */
    readonly gateway: string;
    /**
     * The name of the ScaleIO Protection Domain for the configured storage.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#protectionDomain
     */
    readonly protectionDomain?: string;
    /**
     * Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesScaleIo#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#secretRef
     */
    readonly secretRef: JenkinsSpecMasterVolumesScaleIoSecretRef;
    /**
     * Flag to enable/disable SSL communication with Gateway, default false
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#sslEnabled
     */
    readonly sslEnabled?: boolean;
    /**
     * Indicates whether the storage for a volume should be ThickProvisioned or ThinProvisioned. Default is ThinProvisioned.
     *
     * @default ThinProvisioned.
     * @schema JenkinsSpecMasterVolumesScaleIo#storageMode
     */
    readonly storageMode?: string;
    /**
     * The ScaleIO Storage Pool associated with the protection domain.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#storagePool
     */
    readonly storagePool?: string;
    /**
     * The name of the storage system as configured in ScaleIO.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#system
     */
    readonly system: string;
    /**
     * The name of a volume already created in the ScaleIO system that is associated with this volume source.
     *
     * @schema JenkinsSpecMasterVolumesScaleIo#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesScaleIo' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesScaleIo(obj: JenkinsSpecMasterVolumesScaleIo | undefined): Record<string, any> | undefined;
/**
 * Secret represents a secret that should populate this volume. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
 *
 * @schema JenkinsSpecMasterVolumesSecret
 */
export interface JenkinsSpecMasterVolumesSecret {
    /**
     * Optional: mode bits used to set permissions on created files by default. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. Defaults to 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @default 0644. Directories within the path are not affected by this setting. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     * @schema JenkinsSpecMasterVolumesSecret#defaultMode
     */
    readonly defaultMode?: number;
    /**
     * If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
     *
     * @schema JenkinsSpecMasterVolumesSecret#items
     */
    readonly items?: JenkinsSpecMasterVolumesSecretItems[];
    /**
     * Specify whether the Secret or its keys must be defined
     *
     * @schema JenkinsSpecMasterVolumesSecret#optional
     */
    readonly optional?: boolean;
    /**
     * Name of the secret in the pod's namespace to use. More info: https://kubernetes.io/docs/concepts/storage/volumes#secret
     *
     * @schema JenkinsSpecMasterVolumesSecret#secretName
     */
    readonly secretName?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesSecret(obj: JenkinsSpecMasterVolumesSecret | undefined): Record<string, any> | undefined;
/**
 * StorageOS represents a StorageOS volume attached and mounted on Kubernetes nodes.
 *
 * @schema JenkinsSpecMasterVolumesStorageos
 */
export interface JenkinsSpecMasterVolumesStorageos {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @schema JenkinsSpecMasterVolumesStorageos#fsType
     */
    readonly fsType?: string;
    /**
     * Defaults to false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     *
     * @default false (read/write). ReadOnly here will force the ReadOnly setting in VolumeMounts.
     * @schema JenkinsSpecMasterVolumesStorageos#readOnly
     */
    readonly readOnly?: boolean;
    /**
     * SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
     *
     * @schema JenkinsSpecMasterVolumesStorageos#secretRef
     */
    readonly secretRef?: JenkinsSpecMasterVolumesStorageosSecretRef;
    /**
     * VolumeName is the human-readable name of the StorageOS volume.  Volume names are only unique within a namespace.
     *
     * @schema JenkinsSpecMasterVolumesStorageos#volumeName
     */
    readonly volumeName?: string;
    /**
     * VolumeNamespace specifies the scope of the volume within StorageOS.  If no namespace is specified then the Pod's namespace will be used.  This allows the Kubernetes name scoping to be mirrored within StorageOS for tighter integration. Set VolumeName to any name to override the default behaviour. Set to "default" if you are not using namespaces within StorageOS. Namespaces that do not pre-exist within StorageOS will be created.
     *
     * @schema JenkinsSpecMasterVolumesStorageos#volumeNamespace
     */
    readonly volumeNamespace?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesStorageos' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesStorageos(obj: JenkinsSpecMasterVolumesStorageos | undefined): Record<string, any> | undefined;
/**
 * VsphereVolume represents a vSphere volume attached and mounted on kubelets host machine
 *
 * @schema JenkinsSpecMasterVolumesVsphereVolume
 */
export interface JenkinsSpecMasterVolumesVsphereVolume {
    /**
     * Filesystem type to mount. Must be a filesystem type supported by the host operating system. Ex. "ext4", "xfs", "ntfs". Implicitly inferred to be "ext4" if unspecified.
     *
     * @schema JenkinsSpecMasterVolumesVsphereVolume#fsType
     */
    readonly fsType?: string;
    /**
     * Storage Policy Based Management (SPBM) profile ID associated with the StoragePolicyName.
     *
     * @schema JenkinsSpecMasterVolumesVsphereVolume#storagePolicyID
     */
    readonly storagePolicyId?: string;
    /**
     * Storage Policy Based Management (SPBM) profile name.
     *
     * @schema JenkinsSpecMasterVolumesVsphereVolume#storagePolicyName
     */
    readonly storagePolicyName?: string;
    /**
     * Path that identifies vSphere volume vmdk
     *
     * @schema JenkinsSpecMasterVolumesVsphereVolume#volumePath
     */
    readonly volumePath: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesVsphereVolume' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesVsphereVolume(obj: JenkinsSpecMasterVolumesVsphereVolume | undefined): Record<string, any> | undefined;
/**
 * SecretKeySelector selects a key of a Secret.
 *
 * @schema JenkinsSpecNotificationsMailgunApiKeySecretKeySelector
 */
export interface JenkinsSpecNotificationsMailgunApiKeySecretKeySelector {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecNotificationsMailgunApiKeySecretKeySelector#key
     */
    readonly key: string;
    /**
     * The name of the secret in the pod's namespace to select from.
     *
     * @schema JenkinsSpecNotificationsMailgunApiKeySecretKeySelector#secret
     */
    readonly secret: JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsMailgunApiKeySecretKeySelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsMailgunApiKeySecretKeySelector(obj: JenkinsSpecNotificationsMailgunApiKeySecretKeySelector | undefined): Record<string, any> | undefined;
/**
 * The web hook URL to Slack App
 *
 * @schema JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector
 */
export interface JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector#key
     */
    readonly key: string;
    /**
     * The name of the secret in the pod's namespace to select from.
     *
     * @schema JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector#secret
     */
    readonly secret: JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector(obj: JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelector | undefined): Record<string, any> | undefined;
/**
 * SecretKeySelector selects a key of a Secret.
 *
 * @schema JenkinsSpecNotificationsSmtpPasswordSecretKeySelector
 */
export interface JenkinsSpecNotificationsSmtpPasswordSecretKeySelector {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecNotificationsSmtpPasswordSecretKeySelector#key
     */
    readonly key: string;
    /**
     * The name of the secret in the pod's namespace to select from.
     *
     * @schema JenkinsSpecNotificationsSmtpPasswordSecretKeySelector#secret
     */
    readonly secret: JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSmtpPasswordSecretKeySelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSmtpPasswordSecretKeySelector(obj: JenkinsSpecNotificationsSmtpPasswordSecretKeySelector | undefined): Record<string, any> | undefined;
/**
 * SecretKeySelector selects a key of a Secret.
 *
 * @schema JenkinsSpecNotificationsSmtpUsernameSecretKeySelector
 */
export interface JenkinsSpecNotificationsSmtpUsernameSecretKeySelector {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecNotificationsSmtpUsernameSecretKeySelector#key
     */
    readonly key: string;
    /**
     * The name of the secret in the pod's namespace to select from.
     *
     * @schema JenkinsSpecNotificationsSmtpUsernameSecretKeySelector#secret
     */
    readonly secret: JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSmtpUsernameSecretKeySelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSmtpUsernameSecretKeySelector(obj: JenkinsSpecNotificationsSmtpUsernameSecretKeySelector | undefined): Record<string, any> | undefined;
/**
 * The web hook URL to MicrosoftTeams App
 *
 * @schema JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector
 */
export interface JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector#key
     */
    readonly key: string;
    /**
     * The name of the secret in the pod's namespace to select from.
     *
     * @schema JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector#secret
     */
    readonly secret: JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector(obj: JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelector | undefined): Record<string, any> | undefined;
/**
 * Exec specifies the action to take.
 *
 * @schema JenkinsSpecRestoreActionExec
 */
export interface JenkinsSpecRestoreActionExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecRestoreActionExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecRestoreActionExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecRestoreActionExec(obj: JenkinsSpecRestoreActionExec | undefined): Record<string, any> | undefined;
/**
 * Exec specifies the action to take.
 *
 * @schema JenkinsSpecRestoreGetLatestActionExec
 */
export interface JenkinsSpecRestoreGetLatestActionExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecRestoreGetLatestActionExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecRestoreGetLatestActionExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecRestoreGetLatestActionExec(obj: JenkinsSpecRestoreGetLatestActionExec | undefined): Record<string, any> | undefined;
/**
 * Source for the environment variable's value. Cannot be used if value is not empty.
 *
 * @schema JenkinsSpecMasterContainersEnvValueFrom
 */
export interface JenkinsSpecMasterContainersEnvValueFrom {
    /**
     * Selects a key of a ConfigMap.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFrom#configMapKeyRef
     */
    readonly configMapKeyRef?: JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef;
    /**
     * Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFrom#fieldRef
     */
    readonly fieldRef?: JenkinsSpecMasterContainersEnvValueFromFieldRef;
    /**
     * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFrom#resourceFieldRef
     */
    readonly resourceFieldRef?: JenkinsSpecMasterContainersEnvValueFromResourceFieldRef;
    /**
     * Selects a key of a secret in the pod's namespace
     *
     * @schema JenkinsSpecMasterContainersEnvValueFrom#secretKeyRef
     */
    readonly secretKeyRef?: JenkinsSpecMasterContainersEnvValueFromSecretKeyRef;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvValueFrom' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvValueFrom(obj: JenkinsSpecMasterContainersEnvValueFrom | undefined): Record<string, any> | undefined;
/**
 * The ConfigMap to select from
 *
 * @schema JenkinsSpecMasterContainersEnvFromConfigMapRef
 */
export interface JenkinsSpecMasterContainersEnvFromConfigMapRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterContainersEnvFromConfigMapRef#name
     */
    readonly name?: string;
    /**
     * Specify whether the ConfigMap must be defined
     *
     * @schema JenkinsSpecMasterContainersEnvFromConfigMapRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvFromConfigMapRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvFromConfigMapRef(obj: JenkinsSpecMasterContainersEnvFromConfigMapRef | undefined): Record<string, any> | undefined;
/**
 * The Secret to select from
 *
 * @schema JenkinsSpecMasterContainersEnvFromSecretRef
 */
export interface JenkinsSpecMasterContainersEnvFromSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterContainersEnvFromSecretRef#name
     */
    readonly name?: string;
    /**
     * Specify whether the Secret must be defined
     *
     * @schema JenkinsSpecMasterContainersEnvFromSecretRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvFromSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvFromSecretRef(obj: JenkinsSpecMasterContainersEnvFromSecretRef | undefined): Record<string, any> | undefined;
/**
 * PostStart is called immediately after a container is created. If the handler fails, the container is terminated and restarted according to its restart policy. Other management of the container blocks until the hook completes. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStart
 */
export interface JenkinsSpecMasterContainersLifecyclePostStart {
    /**
     * One and only one of the following should be specified. Exec specifies the action to take.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStart#exec
     */
    readonly exec?: JenkinsSpecMasterContainersLifecyclePostStartExec;
    /**
     * HTTPGet specifies the http request to perform.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStart#httpGet
     */
    readonly httpGet?: JenkinsSpecMasterContainersLifecyclePostStartHttpGet;
    /**
     * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStart#tcpSocket
     */
    readonly tcpSocket?: JenkinsSpecMasterContainersLifecyclePostStartTcpSocket;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePostStart' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePostStart(obj: JenkinsSpecMasterContainersLifecyclePostStart | undefined): Record<string, any> | undefined;
/**
 * PreStop is called immediately before a container is terminated due to an API request or management event such as liveness/startup probe failure, preemption, resource contention, etc. The handler is not called if the container crashes or exits. The reason for termination is passed to the handler. The Pod's termination grace period countdown begins before the PreStop hooked is executed. Regardless of the outcome of the handler, the container will eventually terminate within the Pod's termination grace period. Other management of the container blocks until the hook completes or until the termination grace period is reached. More info: https://kubernetes.io/docs/concepts/containers/container-lifecycle-hooks/#container-hooks
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStop
 */
export interface JenkinsSpecMasterContainersLifecyclePreStop {
    /**
     * One and only one of the following should be specified. Exec specifies the action to take.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStop#exec
     */
    readonly exec?: JenkinsSpecMasterContainersLifecyclePreStopExec;
    /**
     * HTTPGet specifies the http request to perform.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStop#httpGet
     */
    readonly httpGet?: JenkinsSpecMasterContainersLifecyclePreStopHttpGet;
    /**
     * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStop#tcpSocket
     */
    readonly tcpSocket?: JenkinsSpecMasterContainersLifecyclePreStopTcpSocket;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePreStop' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePreStop(obj: JenkinsSpecMasterContainersLifecyclePreStop | undefined): Record<string, any> | undefined;
/**
 * One and only one of the following should be specified. Exec specifies the action to take.
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeExec
 */
export interface JenkinsSpecMasterContainersLivenessProbeExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLivenessProbeExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLivenessProbeExec(obj: JenkinsSpecMasterContainersLivenessProbeExec | undefined): Record<string, any> | undefined;
/**
 * HTTPGet specifies the http request to perform.
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet
 */
export interface JenkinsSpecMasterContainersLivenessProbeHttpGet {
    /**
     * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * Custom headers to set in the request. HTTP allows repeated headers.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders[];
    /**
     * Path to access on the HTTP server.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet#port
     */
    readonly port: JenkinsSpecMasterContainersLivenessProbeHttpGetPort;
    /**
     * Scheme to use for connecting to the host. Defaults to HTTP.
     *
     * @default HTTP.
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLivenessProbeHttpGet' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLivenessProbeHttpGet(obj: JenkinsSpecMasterContainersLivenessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeTcpSocket
 */
export interface JenkinsSpecMasterContainersLivenessProbeTcpSocket {
    /**
     * Optional: Host name to connect to, defaults to the pod IP.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeTcpSocket#port
     */
    readonly port: JenkinsSpecMasterContainersLivenessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLivenessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLivenessProbeTcpSocket(obj: JenkinsSpecMasterContainersLivenessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * One and only one of the following should be specified. Exec specifies the action to take.
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeExec
 */
export interface JenkinsSpecMasterContainersReadinessProbeExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersReadinessProbeExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersReadinessProbeExec(obj: JenkinsSpecMasterContainersReadinessProbeExec | undefined): Record<string, any> | undefined;
/**
 * HTTPGet specifies the http request to perform.
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet
 */
export interface JenkinsSpecMasterContainersReadinessProbeHttpGet {
    /**
     * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet#host
     */
    readonly host?: string;
    /**
     * Custom headers to set in the request. HTTP allows repeated headers.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet#httpHeaders
     */
    readonly httpHeaders?: JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders[];
    /**
     * Path to access on the HTTP server.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet#path
     */
    readonly path?: string;
    /**
     * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet#port
     */
    readonly port: JenkinsSpecMasterContainersReadinessProbeHttpGetPort;
    /**
     * Scheme to use for connecting to the host. Defaults to HTTP.
     *
     * @default HTTP.
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersReadinessProbeHttpGet' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersReadinessProbeHttpGet(obj: JenkinsSpecMasterContainersReadinessProbeHttpGet | undefined): Record<string, any> | undefined;
/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeTcpSocket
 */
export interface JenkinsSpecMasterContainersReadinessProbeTcpSocket {
    /**
     * Optional: Host name to connect to, defaults to the pod IP.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeTcpSocket#host
     */
    readonly host?: string;
    /**
     * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeTcpSocket#port
     */
    readonly port: JenkinsSpecMasterContainersReadinessProbeTcpSocketPort;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersReadinessProbeTcpSocket' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersReadinessProbeTcpSocket(obj: JenkinsSpecMasterContainersReadinessProbeTcpSocket | undefined): Record<string, any> | undefined;
/**
 * @schema JenkinsSpecMasterContainersResourcesLimits
 */
export declare class JenkinsSpecMasterContainersResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersResourcesLimits;
    static fromString(value: string): JenkinsSpecMasterContainersResourcesLimits;
    private constructor();
}
/**
 * @schema JenkinsSpecMasterContainersResourcesRequests
 */
export declare class JenkinsSpecMasterContainersResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersResourcesRequests;
    static fromString(value: string): JenkinsSpecMasterContainersResourcesRequests;
    private constructor();
}
/**
 * The capabilities to add/drop when running containers. Defaults to the default set of capabilities granted by the container runtime.
 *
 * @default the default set of capabilities granted by the container runtime.
 * @schema JenkinsSpecMasterContainersSecurityContextCapabilities
 */
export interface JenkinsSpecMasterContainersSecurityContextCapabilities {
    /**
     * Added capabilities
     *
     * @schema JenkinsSpecMasterContainersSecurityContextCapabilities#add
     */
    readonly add?: string[];
    /**
     * Removed capabilities
     *
     * @schema JenkinsSpecMasterContainersSecurityContextCapabilities#drop
     */
    readonly drop?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersSecurityContextCapabilities' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersSecurityContextCapabilities(obj: JenkinsSpecMasterContainersSecurityContextCapabilities | undefined): Record<string, any> | undefined;
/**
 * The SELinux context to be applied to the container. If unspecified, the container runtime will allocate a random SELinux context for each container.  May also be set in PodSecurityContext.  If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
 *
 * @schema JenkinsSpecMasterContainersSecurityContextSeLinuxOptions
 */
export interface JenkinsSpecMasterContainersSecurityContextSeLinuxOptions {
    /**
     * Level is SELinux level label that applies to the container.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeLinuxOptions#level
     */
    readonly level?: string;
    /**
     * Role is a SELinux role label that applies to the container.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeLinuxOptions#role
     */
    readonly role?: string;
    /**
     * Type is a SELinux type label that applies to the container.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeLinuxOptions#type
     */
    readonly type?: string;
    /**
     * User is a SELinux user label that applies to the container.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeLinuxOptions#user
     */
    readonly user?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersSecurityContextSeLinuxOptions' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersSecurityContextSeLinuxOptions(obj: JenkinsSpecMasterContainersSecurityContextSeLinuxOptions | undefined): Record<string, any> | undefined;
/**
 * The seccomp options to use by this container. If seccomp options are provided at both the pod & container level, the container options override the pod options.
 *
 * @schema JenkinsSpecMasterContainersSecurityContextSeccompProfile
 */
export interface JenkinsSpecMasterContainersSecurityContextSeccompProfile {
    /**
     * localhostProfile indicates a profile defined in a file on the node should be used. The profile must be preconfigured on the node to work. Must be a descending path, relative to the kubelet's configured seccomp profile location. Must only be set if type is "Localhost".
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeccompProfile#localhostProfile
     */
    readonly localhostProfile?: string;
    /**
     * type indicates which kind of seccomp profile will be applied. Valid options are:
     * Localhost - a profile defined in a file on the node should be used. RuntimeDefault - the container runtime default profile should be used. Unconfined - no profile should be applied.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextSeccompProfile#type
     */
    readonly type: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersSecurityContextSeccompProfile' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersSecurityContextSeccompProfile(obj: JenkinsSpecMasterContainersSecurityContextSeccompProfile | undefined): Record<string, any> | undefined;
/**
 * The Windows specific settings applied to all containers. If unspecified, the options from the PodSecurityContext will be used. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
 *
 * @schema JenkinsSpecMasterContainersSecurityContextWindowsOptions
 */
export interface JenkinsSpecMasterContainersSecurityContextWindowsOptions {
    /**
     * GMSACredentialSpec is where the GMSA admission webhook (https://github.com/kubernetes-sigs/windows-gmsa) inlines the contents of the GMSA credential spec named by the GMSACredentialSpecName field.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextWindowsOptions#gmsaCredentialSpec
     */
    readonly gmsaCredentialSpec?: string;
    /**
     * GMSACredentialSpecName is the name of the GMSA credential spec to use.
     *
     * @schema JenkinsSpecMasterContainersSecurityContextWindowsOptions#gmsaCredentialSpecName
     */
    readonly gmsaCredentialSpecName?: string;
    /**
     * The UserName in Windows to run the entrypoint of the container process. Defaults to the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     *
     * @default the user specified in image metadata if unspecified. May also be set in PodSecurityContext. If set in both SecurityContext and PodSecurityContext, the value specified in SecurityContext takes precedence.
     * @schema JenkinsSpecMasterContainersSecurityContextWindowsOptions#runAsUserName
     */
    readonly runAsUserName?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersSecurityContextWindowsOptions' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersSecurityContextWindowsOptions(obj: JenkinsSpecMasterContainersSecurityContextWindowsOptions | undefined): Record<string, any> | undefined;
/**
 * Optional: SecretRef is reference to the authentication secret for User, default is empty. More info: https://examples.k8s.io/volumes/cephfs/README.md#how-to-use-it
 *
 * @schema JenkinsSpecMasterVolumesCephfsSecretRef
 */
export interface JenkinsSpecMasterVolumesCephfsSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesCephfsSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCephfsSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCephfsSecretRef(obj: JenkinsSpecMasterVolumesCephfsSecretRef | undefined): Record<string, any> | undefined;
/**
 * Optional: points to a secret object containing parameters used to connect to OpenStack.
 *
 * @schema JenkinsSpecMasterVolumesCinderSecretRef
 */
export interface JenkinsSpecMasterVolumesCinderSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesCinderSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCinderSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCinderSecretRef(obj: JenkinsSpecMasterVolumesCinderSecretRef | undefined): Record<string, any> | undefined;
/**
 * Maps a string key to a path within a volume.
 *
 * @schema JenkinsSpecMasterVolumesConfigMapItems
 */
export interface JenkinsSpecMasterVolumesConfigMapItems {
    /**
     * The key to project.
     *
     * @schema JenkinsSpecMasterVolumesConfigMapItems#key
     */
    readonly key: string;
    /**
     * Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
     *
     * @schema JenkinsSpecMasterVolumesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesConfigMapItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesConfigMapItems(obj: JenkinsSpecMasterVolumesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * NodePublishSecretRef is a reference to the secret object containing sensitive information to pass to the CSI driver to complete the CSI NodePublishVolume and NodeUnpublishVolume calls. This field is optional, and  may be empty if no secret is required. If the secret object contains more than one secret, all secret references are passed.
 *
 * @schema JenkinsSpecMasterVolumesCsiNodePublishSecretRef
 */
export interface JenkinsSpecMasterVolumesCsiNodePublishSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesCsiNodePublishSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesCsiNodePublishSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesCsiNodePublishSecretRef(obj: JenkinsSpecMasterVolumesCsiNodePublishSecretRef | undefined): Record<string, any> | undefined;
/**
 * DownwardAPIVolumeFile represents information to create the file containing the pod field
 *
 * @schema JenkinsSpecMasterVolumesDownwardApiItems
 */
export interface JenkinsSpecMasterVolumesDownwardApiItems {
    /**
     * Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: JenkinsSpecMasterVolumesDownwardApiItemsFieldRef;
    /**
     * Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesDownwardApiItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesDownwardApiItems(obj: JenkinsSpecMasterVolumesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * Total amount of local storage required for this EmptyDir volume. The size limit is also applicable for memory medium. The maximum usage on memory medium EmptyDir would be the minimum value between the SizeLimit specified here and the sum of memory limits of all containers in a pod. The default is nil which means that the limit is undefined. More info: http://kubernetes.io/docs/user-guide/volumes#emptydir
 *
 * @schema JenkinsSpecMasterVolumesEmptyDirSizeLimit
 */
export declare class JenkinsSpecMasterVolumesEmptyDirSizeLimit {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterVolumesEmptyDirSizeLimit;
    static fromString(value: string): JenkinsSpecMasterVolumesEmptyDirSizeLimit;
    private constructor();
}
/**
 * Will be used to create a stand-alone PVC to provision the volume. The pod in which this EphemeralVolumeSource is embedded will be the owner of the PVC, i.e. the PVC will be deleted together with the pod.  The name of the PVC will be `<pod name>-<volume name>` where `<volume name>` is the name from the `PodSpec.Volumes` array entry. Pod validation will reject the pod if the concatenated name is not valid for a PVC (for example, too long).
 * An existing PVC with that name that is not owned by the pod will *not* be used for the pod to avoid using an unrelated volume by mistake. Starting the pod is then blocked until the unrelated PVC is removed. If such a pre-created PVC is meant to be used by the pod, the PVC has to updated with an owner reference to the pod once the pod exists. Normally this should not be necessary, but it may be useful when manually reconstructing a broken cluster.
 * This field is read-only and no changes will be made by Kubernetes to the PVC after it has been created.
 * Required, must not be nil.
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate {
    /**
     * May contain labels and annotations that will be copied into the PVC when creating it. No other fields are allowed and will be rejected during validation.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate#metadata
     */
    readonly metadata?: any;
    /**
     * The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate#spec
     */
    readonly spec: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplate | undefined): Record<string, any> | undefined;
/**
 * Optional: SecretRef is reference to the secret object containing sensitive information to pass to the plugin scripts. This may be empty if no secret object is specified. If the secret object contains more than one secret, all secrets are passed to the plugin scripts.
 *
 * @schema JenkinsSpecMasterVolumesFlexVolumeSecretRef
 */
export interface JenkinsSpecMasterVolumesFlexVolumeSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesFlexVolumeSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesFlexVolumeSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesFlexVolumeSecretRef(obj: JenkinsSpecMasterVolumesFlexVolumeSecretRef | undefined): Record<string, any> | undefined;
/**
 * CHAP Secret for iSCSI target and initiator authentication
 *
 * @schema JenkinsSpecMasterVolumesIscsiSecretRef
 */
export interface JenkinsSpecMasterVolumesIscsiSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesIscsiSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesIscsiSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesIscsiSecretRef(obj: JenkinsSpecMasterVolumesIscsiSecretRef | undefined): Record<string, any> | undefined;
/**
 * Projection that may be projected along with other supported volume types
 *
 * @schema JenkinsSpecMasterVolumesProjectedSources
 */
export interface JenkinsSpecMasterVolumesProjectedSources {
    /**
     * information about the configMap data to project
     *
     * @schema JenkinsSpecMasterVolumesProjectedSources#configMap
     */
    readonly configMap?: JenkinsSpecMasterVolumesProjectedSourcesConfigMap;
    /**
     * information about the downwardAPI data to project
     *
     * @schema JenkinsSpecMasterVolumesProjectedSources#downwardAPI
     */
    readonly downwardApi?: JenkinsSpecMasterVolumesProjectedSourcesDownwardApi;
    /**
     * information about the secret data to project
     *
     * @schema JenkinsSpecMasterVolumesProjectedSources#secret
     */
    readonly secret?: JenkinsSpecMasterVolumesProjectedSourcesSecret;
    /**
     * information about the serviceAccountToken data to project
     *
     * @schema JenkinsSpecMasterVolumesProjectedSources#serviceAccountToken
     */
    readonly serviceAccountToken?: JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSources' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSources(obj: JenkinsSpecMasterVolumesProjectedSources | undefined): Record<string, any> | undefined;
/**
 * SecretRef is name of the authentication secret for RBDUser. If provided overrides keyring. Default is nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 *
 * @default nil. More info: https://examples.k8s.io/volumes/rbd/README.md#how-to-use-it
 * @schema JenkinsSpecMasterVolumesRbdSecretRef
 */
export interface JenkinsSpecMasterVolumesRbdSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesRbdSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesRbdSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesRbdSecretRef(obj: JenkinsSpecMasterVolumesRbdSecretRef | undefined): Record<string, any> | undefined;
/**
 * SecretRef references to the secret for ScaleIO user and other sensitive information. If this is not provided, Login operation will fail.
 *
 * @schema JenkinsSpecMasterVolumesScaleIoSecretRef
 */
export interface JenkinsSpecMasterVolumesScaleIoSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesScaleIoSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesScaleIoSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesScaleIoSecretRef(obj: JenkinsSpecMasterVolumesScaleIoSecretRef | undefined): Record<string, any> | undefined;
/**
 * Maps a string key to a path within a volume.
 *
 * @schema JenkinsSpecMasterVolumesSecretItems
 */
export interface JenkinsSpecMasterVolumesSecretItems {
    /**
     * The key to project.
     *
     * @schema JenkinsSpecMasterVolumesSecretItems#key
     */
    readonly key: string;
    /**
     * Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
     *
     * @schema JenkinsSpecMasterVolumesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesSecretItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesSecretItems(obj: JenkinsSpecMasterVolumesSecretItems | undefined): Record<string, any> | undefined;
/**
 * SecretRef specifies the secret to use for obtaining the StorageOS API credentials.  If not specified, default values will be attempted.
 *
 * @schema JenkinsSpecMasterVolumesStorageosSecretRef
 */
export interface JenkinsSpecMasterVolumesStorageosSecretRef {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesStorageosSecretRef#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesStorageosSecretRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesStorageosSecretRef(obj: JenkinsSpecMasterVolumesStorageosSecretRef | undefined): Record<string, any> | undefined;
/**
 * The name of the secret in the pod's namespace to select from.
 *
 * @schema JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret
 */
export interface JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret(obj: JenkinsSpecNotificationsMailgunApiKeySecretKeySelectorSecret | undefined): Record<string, any> | undefined;
/**
 * The name of the secret in the pod's namespace to select from.
 *
 * @schema JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret
 */
export interface JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret(obj: JenkinsSpecNotificationsSlackWebHookUrlSecretKeySelectorSecret | undefined): Record<string, any> | undefined;
/**
 * The name of the secret in the pod's namespace to select from.
 *
 * @schema JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret
 */
export interface JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret(obj: JenkinsSpecNotificationsSmtpPasswordSecretKeySelectorSecret | undefined): Record<string, any> | undefined;
/**
 * The name of the secret in the pod's namespace to select from.
 *
 * @schema JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret
 */
export interface JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret(obj: JenkinsSpecNotificationsSmtpUsernameSecretKeySelectorSecret | undefined): Record<string, any> | undefined;
/**
 * The name of the secret in the pod's namespace to select from.
 *
 * @schema JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret
 */
export interface JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret {
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret#name
     */
    readonly name?: string;
}
/**
 * Converts an object of type 'JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret(obj: JenkinsSpecNotificationsTeamsWebHookUrlSecretKeySelectorSecret | undefined): Record<string, any> | undefined;
/**
 * Selects a key of a ConfigMap.
 *
 * @schema JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef
 */
export interface JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef {
    /**
     * The key to select.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef#key
     */
    readonly key: string;
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef#name
     */
    readonly name?: string;
    /**
     * Specify whether the ConfigMap or its key must be defined
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef(obj: JenkinsSpecMasterContainersEnvValueFromConfigMapKeyRef | undefined): Record<string, any> | undefined;
/**
 * Selects a field of the pod: supports metadata.name, metadata.namespace, `metadata.labels['<KEY>']`, `metadata.annotations['<KEY>']`, spec.nodeName, spec.serviceAccountName, status.hostIP, status.podIP, status.podIPs.
 *
 * @schema JenkinsSpecMasterContainersEnvValueFromFieldRef
 */
export interface JenkinsSpecMasterContainersEnvValueFromFieldRef {
    /**
     * Version of the schema the FieldPath is written in terms of, defaults to "v1".
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * Path of the field to select in the specified API version.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvValueFromFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvValueFromFieldRef(obj: JenkinsSpecMasterContainersEnvValueFromFieldRef | undefined): Record<string, any> | undefined;
/**
 * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, limits.ephemeral-storage, requests.cpu, requests.memory and requests.ephemeral-storage) are currently supported.
 *
 * @schema JenkinsSpecMasterContainersEnvValueFromResourceFieldRef
 */
export interface JenkinsSpecMasterContainersEnvValueFromResourceFieldRef {
    /**
     * Container name: required for volumes, optional for env vars
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * Specifies the output format of the exposed resources, defaults to "1"
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromResourceFieldRef#divisor
     */
    readonly divisor?: JenkinsSpecMasterContainersEnvValueFromResourceFieldRefDivisor;
    /**
     * Required: resource to select
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvValueFromResourceFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvValueFromResourceFieldRef(obj: JenkinsSpecMasterContainersEnvValueFromResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * Selects a key of a secret in the pod's namespace
 *
 * @schema JenkinsSpecMasterContainersEnvValueFromSecretKeyRef
 */
export interface JenkinsSpecMasterContainersEnvValueFromSecretKeyRef {
    /**
     * The key of the secret to select from.  Must be a valid secret key.
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromSecretKeyRef#key
     */
    readonly key: string;
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromSecretKeyRef#name
     */
    readonly name?: string;
    /**
     * Specify whether the Secret or its key must be defined
     *
     * @schema JenkinsSpecMasterContainersEnvValueFromSecretKeyRef#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersEnvValueFromSecretKeyRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersEnvValueFromSecretKeyRef(obj: JenkinsSpecMasterContainersEnvValueFromSecretKeyRef | undefined): Record<string, any> | undefined;
/**
 * One and only one of the following should be specified. Exec specifies the action to take.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartExec
 */
export interface JenkinsSpecMasterContainersLifecyclePostStartExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePostStartExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePostStartExec(obj: JenkinsSpecMasterContainersLifecyclePostStartExec | undefined): Record<string, any> | undefined;
/**
 * HTTPGet specifies the http request to perform.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet
 */
export interface JenkinsSpecMasterContainersLifecyclePostStartHttpGet {
    /**
     * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet#host
     */
    readonly host?: string;
    /**
     * Custom headers to set in the request. HTTP allows repeated headers.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet#httpHeaders
     */
    readonly httpHeaders?: JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders[];
    /**
     * Path to access on the HTTP server.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet#path
     */
    readonly path?: string;
    /**
     * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet#port
     */
    readonly port: JenkinsSpecMasterContainersLifecyclePostStartHttpGetPort;
    /**
     * Scheme to use for connecting to the host. Defaults to HTTP.
     *
     * @default HTTP.
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePostStartHttpGet' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePostStartHttpGet(obj: JenkinsSpecMasterContainersLifecyclePostStartHttpGet | undefined): Record<string, any> | undefined;
/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartTcpSocket
 */
export interface JenkinsSpecMasterContainersLifecyclePostStartTcpSocket {
    /**
     * Optional: Host name to connect to, defaults to the pod IP.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartTcpSocket#host
     */
    readonly host?: string;
    /**
     * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartTcpSocket#port
     */
    readonly port: JenkinsSpecMasterContainersLifecyclePostStartTcpSocketPort;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePostStartTcpSocket' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePostStartTcpSocket(obj: JenkinsSpecMasterContainersLifecyclePostStartTcpSocket | undefined): Record<string, any> | undefined;
/**
 * One and only one of the following should be specified. Exec specifies the action to take.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopExec
 */
export interface JenkinsSpecMasterContainersLifecyclePreStopExec {
    /**
     * Command is the command line to execute inside the container, the working directory for the command  is root ('/') in the container's filesystem. The command is simply exec'd, it is not run inside a shell, so traditional shell instructions ('|', etc) won't work. To use a shell, you need to explicitly call out to that shell. Exit status of 0 is treated as live/healthy and non-zero is unhealthy.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopExec#command
     */
    readonly command?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePreStopExec' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePreStopExec(obj: JenkinsSpecMasterContainersLifecyclePreStopExec | undefined): Record<string, any> | undefined;
/**
 * HTTPGet specifies the http request to perform.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet
 */
export interface JenkinsSpecMasterContainersLifecyclePreStopHttpGet {
    /**
     * Host name to connect to, defaults to the pod IP. You probably want to set "Host" in httpHeaders instead.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet#host
     */
    readonly host?: string;
    /**
     * Custom headers to set in the request. HTTP allows repeated headers.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet#httpHeaders
     */
    readonly httpHeaders?: JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders[];
    /**
     * Path to access on the HTTP server.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet#path
     */
    readonly path?: string;
    /**
     * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet#port
     */
    readonly port: JenkinsSpecMasterContainersLifecyclePreStopHttpGetPort;
    /**
     * Scheme to use for connecting to the host. Defaults to HTTP.
     *
     * @default HTTP.
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGet#scheme
     */
    readonly scheme?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePreStopHttpGet' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePreStopHttpGet(obj: JenkinsSpecMasterContainersLifecyclePreStopHttpGet | undefined): Record<string, any> | undefined;
/**
 * TCPSocket specifies an action involving a TCP port. TCP hooks not yet supported TODO: implement a realistic TCP lifecycle hook
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopTcpSocket
 */
export interface JenkinsSpecMasterContainersLifecyclePreStopTcpSocket {
    /**
     * Optional: Host name to connect to, defaults to the pod IP.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopTcpSocket#host
     */
    readonly host?: string;
    /**
     * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopTcpSocket#port
     */
    readonly port: JenkinsSpecMasterContainersLifecyclePreStopTcpSocketPort;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePreStopTcpSocket' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePreStopTcpSocket(obj: JenkinsSpecMasterContainersLifecyclePreStopTcpSocket | undefined): Record<string, any> | undefined;
/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders
 */
export interface JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders {
    /**
     * The header field name
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * The header field value
     *
     * @schema JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders(obj: JenkinsSpecMasterContainersLivenessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeHttpGetPort
 */
export declare class JenkinsSpecMasterContainersLivenessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLivenessProbeHttpGetPort;
    static fromString(value: string): JenkinsSpecMasterContainersLivenessProbeHttpGetPort;
    private constructor();
}
/**
 * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLivenessProbeTcpSocketPort
 */
export declare class JenkinsSpecMasterContainersLivenessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLivenessProbeTcpSocketPort;
    static fromString(value: string): JenkinsSpecMasterContainersLivenessProbeTcpSocketPort;
    private constructor();
}
/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders
 */
export interface JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders {
    /**
     * The header field name
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * The header field value
     *
     * @schema JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders(obj: JenkinsSpecMasterContainersReadinessProbeHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeHttpGetPort
 */
export declare class JenkinsSpecMasterContainersReadinessProbeHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersReadinessProbeHttpGetPort;
    static fromString(value: string): JenkinsSpecMasterContainersReadinessProbeHttpGetPort;
    private constructor();
}
/**
 * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersReadinessProbeTcpSocketPort
 */
export declare class JenkinsSpecMasterContainersReadinessProbeTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersReadinessProbeTcpSocketPort;
    static fromString(value: string): JenkinsSpecMasterContainersReadinessProbeTcpSocketPort;
    private constructor();
}
/**
 * Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
 *
 * @schema JenkinsSpecMasterVolumesDownwardApiItemsFieldRef
 */
export interface JenkinsSpecMasterVolumesDownwardApiItemsFieldRef {
    /**
     * Version of the schema the FieldPath is written in terms of, defaults to "v1".
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * Path of the field to select in the specified API version.
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesDownwardApiItemsFieldRef(obj: JenkinsSpecMasterVolumesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
 *
 * @schema JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef
 */
export interface JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef {
    /**
     * Container name: required for volumes, optional for env vars
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * Specifies the output format of the exposed resources, defaults to "1"
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * Required: resource to select
     *
     * @schema JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef(obj: JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * The specification for the PersistentVolumeClaim. The entire content is copied unchanged into the PVC that gets created from this template. The same fields as in a PersistentVolumeClaim are also valid here.
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec {
    /**
     * AccessModes contains the desired access modes the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#access-modes-1
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#accessModes
     */
    readonly accessModes?: string[];
    /**
     * This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#dataSource
     */
    readonly dataSource?: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource;
    /**
     * Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#resources
     */
    readonly resources?: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources;
    /**
     * A label query over volumes to consider for binding.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#selector
     */
    readonly selector?: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector;
    /**
     * Name of the StorageClass required by the claim. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#class-1
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#storageClassName
     */
    readonly storageClassName?: string;
    /**
     * volumeMode defines what type of volume is required by the claim. Value of Filesystem is implied when not included in claim spec.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#volumeMode
     */
    readonly volumeMode?: string;
    /**
     * VolumeName is the binding reference to the PersistentVolume backing this claim.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec#volumeName
     */
    readonly volumeName?: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpec | undefined): Record<string, any> | undefined;
/**
 * information about the configMap data to project
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMap
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesConfigMap {
    /**
     * If unspecified, each key-value pair in the Data field of the referenced ConfigMap will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the ConfigMap, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMap#items
     */
    readonly items?: JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems[];
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMap#name
     */
    readonly name?: string;
    /**
     * Specify whether the ConfigMap or its keys must be defined
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMap#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesConfigMap' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesConfigMap(obj: JenkinsSpecMasterVolumesProjectedSourcesConfigMap | undefined): Record<string, any> | undefined;
/**
 * information about the downwardAPI data to project
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApi
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesDownwardApi {
    /**
     * Items is a list of DownwardAPIVolume file
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApi#items
     */
    readonly items?: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesDownwardApi' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesDownwardApi(obj: JenkinsSpecMasterVolumesProjectedSourcesDownwardApi | undefined): Record<string, any> | undefined;
/**
 * information about the secret data to project
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesSecret
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesSecret {
    /**
     * If unspecified, each key-value pair in the Data field of the referenced Secret will be projected into the volume as a file whose name is the key and content is the value. If specified, the listed keys will be projected into the specified paths, and unlisted keys will not be present. If a key is specified which is not present in the Secret, the volume setup will error unless it is marked optional. Paths must be relative and may not contain the '..' path or start with '..'.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecret#items
     */
    readonly items?: JenkinsSpecMasterVolumesProjectedSourcesSecretItems[];
    /**
     * Name of the referent. More info: https://kubernetes.io/docs/concepts/overview/working-with-objects/names/#names TODO: Add other useful fields. apiVersion, kind, uid?
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecret#name
     */
    readonly name?: string;
    /**
     * Specify whether the Secret or its key must be defined
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecret#optional
     */
    readonly optional?: boolean;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesSecret' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesSecret(obj: JenkinsSpecMasterVolumesProjectedSourcesSecret | undefined): Record<string, any> | undefined;
/**
 * information about the serviceAccountToken data to project
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken {
    /**
     * Audience is the intended audience of the token. A recipient of a token must identify itself with an identifier specified in the audience of the token, and otherwise should reject the token. The audience defaults to the identifier of the apiserver.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken#audience
     */
    readonly audience?: string;
    /**
     * ExpirationSeconds is the requested duration of validity of the service account token. As the token approaches expiration, the kubelet volume plugin will proactively rotate the service account token. The kubelet will start trying to rotate the token if the token is older than 80 percent of its time to live or if the token is older than 24 hours.Defaults to 1 hour and must be at least 10 minutes.
     *
     * @default 1 hour and must be at least 10 minutes.
     * @schema JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken#expirationSeconds
     */
    readonly expirationSeconds?: number;
    /**
     * Path is the path relative to the mount point of the file to project the token into.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken(obj: JenkinsSpecMasterVolumesProjectedSourcesServiceAccountToken | undefined): Record<string, any> | undefined;
/**
 * Specifies the output format of the exposed resources, defaults to "1"
 *
 * @schema JenkinsSpecMasterContainersEnvValueFromResourceFieldRefDivisor
 */
export declare class JenkinsSpecMasterContainersEnvValueFromResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersEnvValueFromResourceFieldRefDivisor;
    static fromString(value: string): JenkinsSpecMasterContainersEnvValueFromResourceFieldRefDivisor;
    private constructor();
}
/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders
 */
export interface JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders {
    /**
     * The header field name
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * The header field value
     *
     * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders(obj: JenkinsSpecMasterContainersLifecyclePostStartHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartHttpGetPort
 */
export declare class JenkinsSpecMasterContainersLifecyclePostStartHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLifecyclePostStartHttpGetPort;
    static fromString(value: string): JenkinsSpecMasterContainersLifecyclePostStartHttpGetPort;
    private constructor();
}
/**
 * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePostStartTcpSocketPort
 */
export declare class JenkinsSpecMasterContainersLifecyclePostStartTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLifecyclePostStartTcpSocketPort;
    static fromString(value: string): JenkinsSpecMasterContainersLifecyclePostStartTcpSocketPort;
    private constructor();
}
/**
 * HTTPHeader describes a custom header to be used in HTTP probes
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders
 */
export interface JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders {
    /**
     * The header field name
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders#name
     */
    readonly name: string;
    /**
     * The header field value
     *
     * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders#value
     */
    readonly value: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders(obj: JenkinsSpecMasterContainersLifecyclePreStopHttpGetHttpHeaders | undefined): Record<string, any> | undefined;
/**
 * Name or number of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopHttpGetPort
 */
export declare class JenkinsSpecMasterContainersLifecyclePreStopHttpGetPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLifecyclePreStopHttpGetPort;
    static fromString(value: string): JenkinsSpecMasterContainersLifecyclePreStopHttpGetPort;
    private constructor();
}
/**
 * Number or name of the port to access on the container. Number must be in the range 1 to 65535. Name must be an IANA_SVC_NAME.
 *
 * @schema JenkinsSpecMasterContainersLifecyclePreStopTcpSocketPort
 */
export declare class JenkinsSpecMasterContainersLifecyclePreStopTcpSocketPort {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterContainersLifecyclePreStopTcpSocketPort;
    static fromString(value: string): JenkinsSpecMasterContainersLifecyclePreStopTcpSocketPort;
    private constructor();
}
/**
 * Specifies the output format of the exposed resources, defaults to "1"
 *
 * @schema JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): JenkinsSpecMasterVolumesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
/**
 * This field can be used to specify either: * An existing VolumeSnapshot object (snapshot.storage.k8s.io/VolumeSnapshot) * An existing PVC (PersistentVolumeClaim) * An existing custom resource that implements data population (Alpha) In order to use custom resource types that implement data population, the AnyVolumeDataSource feature gate must be enabled. If the provisioner or an external controller can support the specified data source, it will create a new volume based on the contents of the specified data source.
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource {
    /**
     * APIGroup is the group for the resource being referenced. If APIGroup is not specified, the specified Kind must be in the core API group. For any other third-party types, APIGroup is required.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource#apiGroup
     */
    readonly apiGroup?: string;
    /**
     * Kind is the type of resource being referenced
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource#kind
     */
    readonly kind: string;
    /**
     * Name is the name of resource being referenced
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource#name
     */
    readonly name: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecDataSource | undefined): Record<string, any> | undefined;
/**
 * Resources represents the minimum resources the volume should have. More info: https://kubernetes.io/docs/concepts/storage/persistent-volumes#resources
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources {
    /**
     * Limits describes the maximum amount of compute resources allowed. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources#limits
     */
    readonly limits?: {
        [key: string]: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    };
    /**
     * Requests describes the minimum amount of compute resources required. If Requests is omitted for a container, it defaults to Limits if that is explicitly specified, otherwise to an implementation-defined value. More info: https://kubernetes.io/docs/concepts/configuration/manage-compute-resources-container/
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources#requests
     */
    readonly requests?: {
        [key: string]: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    };
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResources | undefined): Record<string, any> | undefined;
/**
 * A label query over volumes to consider for binding.
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector {
    /**
     * matchExpressions is a list of label selector requirements. The requirements are ANDed.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector#matchExpressions
     */
    readonly matchExpressions?: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions[];
    /**
     * matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is "key", the operator is "In", and the values array contains only "value". The requirements are ANDed.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector#matchLabels
     */
    readonly matchLabels?: {
        [key: string]: string;
    };
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelector | undefined): Record<string, any> | undefined;
/**
 * Maps a string key to a path within a volume.
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems {
    /**
     * The key to project.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems#key
     */
    readonly key: string;
    /**
     * Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems#mode
     */
    readonly mode?: number;
    /**
     * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems(obj: JenkinsSpecMasterVolumesProjectedSourcesConfigMapItems | undefined): Record<string, any> | undefined;
/**
 * DownwardAPIVolumeFile represents information to create the file containing the pod field
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems {
    /**
     * Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems#fieldRef
     */
    readonly fieldRef?: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef;
    /**
     * Optional: mode bits used to set permissions on this file, must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems#mode
     */
    readonly mode?: number;
    /**
     * Required: Path is  the relative path name of the file to be created. Must not be absolute or contain the '..' path. Must be utf-8 encoded. The first item of the relative path must not start with '..'
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems#path
     */
    readonly path: string;
    /**
     * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems#resourceFieldRef
     */
    readonly resourceFieldRef?: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems(obj: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItems | undefined): Record<string, any> | undefined;
/**
 * Maps a string key to a path within a volume.
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesSecretItems
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesSecretItems {
    /**
     * The key to project.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecretItems#key
     */
    readonly key: string;
    /**
     * Optional: mode bits used to set permissions on this file. Must be an octal value between 0000 and 0777 or a decimal value between 0 and 511. YAML accepts both octal and decimal values, JSON requires decimal values for mode bits. If not specified, the volume defaultMode will be used. This might be in conflict with other options that affect the file mode, like fsGroup, and the result can be other mode bits set.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecretItems#mode
     */
    readonly mode?: number;
    /**
     * The relative path of the file to map the key to. May not be an absolute path. May not contain the path element '..'. May not start with the string '..'.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesSecretItems#path
     */
    readonly path: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesSecretItems' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesSecretItems(obj: JenkinsSpecMasterVolumesProjectedSourcesSecretItems | undefined): Record<string, any> | undefined;
/**
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits
 */
export declare class JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    static fromString(value: string): JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesLimits;
    private constructor();
}
/**
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests
 */
export declare class JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    static fromString(value: string): JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecResourcesRequests;
    private constructor();
}
/**
 * A label selector requirement is a selector that contains values, a key, and an operator that relates the key and values.
 *
 * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions
 */
export interface JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions {
    /**
     * key is the label key that the selector applies to.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#key
     */
    readonly key: string;
    /**
     * operator represents a key's relationship to a set of values. Valid operators are In, NotIn, Exists and DoesNotExist.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#operator
     */
    readonly operator: string;
    /**
     * values is an array of string values. If the operator is In or NotIn, the values array must be non-empty. If the operator is Exists or DoesNotExist, the values array must be empty. This array is replaced during a strategic merge patch.
     *
     * @schema JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions#values
     */
    readonly values?: string[];
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions(obj: JenkinsSpecMasterVolumesEphemeralVolumeClaimTemplateSpecSelectorMatchExpressions | undefined): Record<string, any> | undefined;
/**
 * Required: Selects a field of the pod: only annotations, labels, name and namespace are supported.
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef {
    /**
     * Version of the schema the FieldPath is written in terms of, defaults to "v1".
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef#apiVersion
     */
    readonly apiVersion?: string;
    /**
     * Path of the field to select in the specified API version.
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef#fieldPath
     */
    readonly fieldPath: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef(obj: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsFieldRef | undefined): Record<string, any> | undefined;
/**
 * Selects a resource of the container: only resources limits and requests (limits.cpu, limits.memory, requests.cpu and requests.memory) are currently supported.
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef
 */
export interface JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef {
    /**
     * Container name: required for volumes, optional for env vars
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#containerName
     */
    readonly containerName?: string;
    /**
     * Specifies the output format of the exposed resources, defaults to "1"
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#divisor
     */
    readonly divisor?: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    /**
     * Required: resource to select
     *
     * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef#resource
     */
    readonly resource: string;
}
/**
 * Converts an object of type 'JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef' to JSON representation.
 */
export declare function toJson_JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef(obj: JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRef | undefined): Record<string, any> | undefined;
/**
 * Specifies the output format of the exposed resources, defaults to "1"
 *
 * @schema JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor
 */
export declare class JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor {
    readonly value: any;
    static fromNumber(value: number): JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    static fromString(value: string): JenkinsSpecMasterVolumesProjectedSourcesDownwardApiItemsResourceFieldRefDivisor;
    private constructor();
}
