# -*- coding: mbcs -*-
# Created by makepy.py version 0.5.01
# By python version 3.8.10 (tags/v3.8.10:3d8993a, May  3 2021, 11:48:03) [MSC v.1928 64 bit (AMD64)]
# From type library 'FunctionBay.Post.ProcessNet.Interface.tlb'
# On Mon Feb  6 02:26:16 2023
''
makepy_version = '0.5.01'
python_version = 0x3080af0

import win32com.client.CLSIDToClass, pythoncom, pywintypes
import win32com.client.util
from pywintypes import IID
from win32com.client import Dispatch
from enum import IntEnum

# The following 3 lines may need tweaking for the particular server
# Candidates are pythoncom.Missing, .Empty and .ArgNotFound
defaultNamedOptArg=pythoncom.Empty
defaultNamedNotOptArg=pythoncom.Empty
defaultUnnamedArg=pythoncom.Empty

CLSID = IID('{48229206-85EB-4E70-BD62-C3650A0661C4}')
MajorVersion = 10
MinorVersion = 1
LibraryFlags = 8
LCID = 0x0

class AdditionalViewerType(IntEnum):
	'''
	AdditionalViewerType enumeration.
	'''
	AdditionalViewerType_None     =0         
	'''Constant value is 0.'''
	AdditionalViewerType_SectionViewer=1         
	'''Constant value is 1.'''
	AdditionalViewerType_SliceViewer=2         
	'''Constant value is 2.'''
class Alignment(IntEnum):
	'''
	Alignment enumeration.
	'''
	Alignment_Bottom              =1         
	'''Constant value is 1.'''
	Alignment_Center              =2         
	'''Constant value is 2.'''
	Alignment_Left                =3         
	'''Constant value is 3.'''
	Alignment_Right               =4         
	'''Constant value is 4.'''
	Alignment_Top                 =0         
	'''Constant value is 0.'''
class AnimationPlayType(IntEnum):
	'''
	AnimationPlayType enumeration.
	'''
	AnimationPlayType_Backward    =2         
	'''Constant value is 2.'''
	AnimationPlayType_FastBackward=3         
	'''Constant value is 3.'''
	AnimationPlayType_FastForward =1         
	'''Constant value is 1.'''
	AnimationPlayType_Forward     =0         
	'''Constant value is 0.'''
class AnimationStatus(IntEnum):
	'''
	AnimationStatus enumeration.
	'''
	AnimationStatus_Pause         =2         
	'''Constant value is 2.'''
	AnimationStatus_Play          =1         
	'''Constant value is 1.'''
	AnimationStatus_Stop          =0         
	'''Constant value is 0.'''
class AxisPlaneDrawLabelsMode(IntEnum):
	'''
	AxisPlaneDrawLabelsMode enumeration.
	'''
	AxisPlaneDrawLabelsMode_AxisPlaneDrawLabelsBoth=0         
	'''Constant value is 0.'''
	AxisPlaneDrawLabelsMode_AxisPlaneDrawLabelsHidden=1         
	'''Constant value is 1.'''
	AxisPlaneDrawLabelsMode_AxisPlaneDrawLabelsLocalX=2         
	'''Constant value is 2.'''
	AxisPlaneDrawLabelsMode_AxisPlaneDrawLabelsLocalY=3         
	'''Constant value is 3.'''
class AxisType(IntEnum):
	'''
	AxisType enumeration.
	'''
	AxisType_Linear               =0         
	'''Constant value is 0.'''
	AxisType_Logarithmic          =1         
	'''Constant value is 1.'''
class ButterWorthOption(IntEnum):
	'''
	ButterWorthOption enumeration.
	'''
	ButterWorthOption_BandPass    =2         
	'''Constant value is 2.'''
	ButterWorthOption_BandStop    =3         
	'''Constant value is 3.'''
	ButterWorthOption_HighPass    =1         
	'''Constant value is 1.'''
	ButterWorthOption_LowPass     =0         
	'''Constant value is 0.'''
class CampbellDataType(IntEnum):
	'''
	CampbellDataType enumeration.
	'''
	CampbellDataType_Campbell_Data_RPM=1         
	'''Constant value is 1.'''
	CampbellDataType_Campbell_Data_Signal=3         
	'''Constant value is 3.'''
	CampbellDataType_Campbell_Data_SignalFFT=4         
	'''Constant value is 4.'''
	CampbellDataType_Campbell_Data_Tacho=0         
	'''Constant value is 0.'''
	CampbellDataType_Campbell_Data_dRPM=2         
	'''Constant value is 2.'''
class Chart3DCampbellGraphType(IntEnum):
	'''
	Chart3DCampbellGraphType enumeration.
	'''
	Chart3DCampbellGraphType_RPMFrequency=0         
	'''Constant value is 0.'''
	Chart3DCampbellGraphType_RPMOrder=1         
	'''Constant value is 1.'''
class Chart3DDataSeriesType(IntEnum):
	'''
	Chart3DDataSeriesType enumeration.
	'''
	Chart3DDataSeriesType_CampbellData=1         
	'''Constant value is 1.'''
	Chart3DDataSeriesType_General =0         
	'''Constant value is 0.'''
class Chart3DViewType(IntEnum):
	'''
	Chart3DViewType enumeration.
	'''
	Chart3DViewType_Normal        =0         
	'''Constant value is 0.'''
	Chart3DViewType_OrthoView     =1         
	'''Constant value is 1.'''
class ChartXAxisAlignment(IntEnum):
	'''
	ChartXAxisAlignment enumeration.
	'''
	ChartXAxisAlignment_Bottom    =1         
	'''Constant value is 1.'''
	ChartXAxisAlignment_Top       =0         
	'''Constant value is 0.'''
class ChartYAxisAlignment(IntEnum):
	'''
	ChartYAxisAlignment enumeration.
	'''
	ChartYAxisAlignment_Left      =1         
	'''Constant value is 1.'''
	ChartYAxisAlignment_Right     =0         
	'''Constant value is 0.'''
class ContourLegendPosition(IntEnum):
	'''
	ContourLegendPosition enumeration.
	'''
	ContourLegendPosition_Bottom  =1         
	'''Constant value is 1.'''
	ContourLegendPosition_Left    =2         
	'''Constant value is 2.'''
	ContourLegendPosition_Right   =3         
	'''Constant value is 3.'''
	ContourLegendPosition_Top     =0         
	'''Constant value is 0.'''
class CoordinateSystem3D(IntEnum):
	'''
	CoordinateSystem3D enumeration.
	'''
	CoordinateSystem3D_LeftHanded =0         
	'''Constant value is 0.'''
	CoordinateSystem3D_RightHanded=1         
	'''Constant value is 1.'''
class DrawMeshAs(IntEnum):
	'''
	DrawMeshAs enumeration.
	'''
	DrawMeshAs_Contours           =3         
	'''Constant value is 3.'''
	DrawMeshAs_SolidMesh          =2         
	'''Constant value is 2.'''
	DrawMeshAs_SolidWireFrame     =0         
	'''Constant value is 0.'''
	DrawMeshAs_SolidWireframeWithContours=5         
	'''Constant value is 5.'''
	DrawMeshAs_SolidWithContours  =4         
	'''Constant value is 4.'''
	DrawMeshAs_Wireframe          =1         
	'''Constant value is 1.'''
class ExportImageType(IntEnum):
	'''
	ExportImageType enumeration.
	'''
	ExportImageType_Bmp           =2         
	'''Constant value is 2.'''
	ExportImageType_Jpg           =1         
	'''Constant value is 1.'''
	ExportImageType_Png           =0         
	'''Constant value is 0.'''
class FFTType(IntEnum):
	'''
	FFTType enumeration.
	'''
	FFTType_Magnitude             =0         
	'''Constant value is 0.'''
	FFTType_PSD                   =2         
	'''Constant value is 2.'''
	FFTType_Phase                 =1         
	'''Constant value is 1.'''
class FilterType(IntEnum):
	'''
	FilterType enumeration.
	'''
	FilterType_ButterWorth        =0         
	'''Constant value is 0.'''
	FilterType_TransferFunction   =1         
	'''Constant value is 1.'''
class FontStyleEx(IntEnum):
	'''
	FontStyleEx enumeration.
	'''
	FontStyleEx_Italic            =2         
	'''Constant value is 2.'''
	FontStyleEx_Normal            =0         
	'''Constant value is 0.'''
	FontStyleEx_Oblique           =1         
	'''Constant value is 1.'''
class FontWeightEx(IntEnum):
	'''
	FontWeightEx enumeration.
	'''
	FontWeightEx_Black            =12        
	'''Constant value is 12.'''
	FontWeightEx_Bold             =9         
	'''Constant value is 9.'''
	FontWeightEx_DemiBold         =7         
	'''Constant value is 7.'''
	FontWeightEx_ExtraBlack       =14        
	'''Constant value is 14.'''
	FontWeightEx_ExtraBold        =10        
	'''Constant value is 10.'''
	FontWeightEx_ExtraLight       =1         
	'''Constant value is 1.'''
	FontWeightEx_Heavy            =13        
	'''Constant value is 13.'''
	FontWeightEx_Light            =3         
	'''Constant value is 3.'''
	FontWeightEx_Medium           =6         
	'''Constant value is 6.'''
	FontWeightEx_Normal           =4         
	'''Constant value is 4.'''
	FontWeightEx_Regular          =5         
	'''Constant value is 5.'''
	FontWeightEx_SemiBold         =8         
	'''Constant value is 8.'''
	FontWeightEx_Thin             =0         
	'''Constant value is 0.'''
	FontWeightEx_UltraBlack       =15        
	'''Constant value is 15.'''
	FontWeightEx_UltraBold        =11        
	'''Constant value is 11.'''
	FontWeightEx_UltraLight       =2         
	'''Constant value is 2.'''
class HorizontalAlignmentEx(IntEnum):
	'''
	HorizontalAlignmentEx enumeration.
	'''
	HorizontalAlignmentEx_Center  =1         
	'''Constant value is 1.'''
	HorizontalAlignmentEx_Left    =0         
	'''Constant value is 0.'''
	HorizontalAlignmentEx_Right   =2         
	'''Constant value is 2.'''
class InterpolationType(IntEnum):
	'''
	InterpolationType enumeration.
	'''
	InterpolationType_Linear      =0         
	'''Constant value is 0.'''
	InterpolationType_Spline      =1         
	'''Constant value is 1.'''
class LabelAlignment(IntEnum):
	'''
	LabelAlignment enumeration.
	'''
	LabelAlignment_Center         =1         
	'''Constant value is 1.'''
	LabelAlignment_Left           =0         
	'''Constant value is 0.'''
	LabelAlignment_Right          =2         
	'''Constant value is 2.'''
class LabelPlacement(IntEnum):
	'''
	LabelPlacement enumeration.
	'''
	LabelPlacement_Axis           =8         
	'''Constant value is 8.'''
	LabelPlacement_Bottom         =3         
	'''Constant value is 3.'''
	LabelPlacement_BottomLeft     =6         
	'''Constant value is 6.'''
	LabelPlacement_BottomRight    =2         
	'''Constant value is 2.'''
	LabelPlacement_Left           =4         
	'''Constant value is 4.'''
	LabelPlacement_Right          =0         
	'''Constant value is 0.'''
	LabelPlacement_Top            =7         
	'''Constant value is 7.'''
	LabelPlacement_TopLeft        =5         
	'''Constant value is 5.'''
	LabelPlacement_TopRight       =1         
	'''Constant value is 1.'''
class LegendPosition(IntEnum):
	'''
	LegendPosition enumeration.
	'''
	LegendPosition_Bottom         =1         
	'''Constant value is 1.'''
	LegendPosition_Inside         =4         
	'''Constant value is 4.'''
	LegendPosition_Left           =2         
	'''Constant value is 2.'''
	LegendPosition_Right          =3         
	'''Constant value is 3.'''
	LegendPosition_Top            =0         
	'''Constant value is 0.'''
class LineStyle(IntEnum):
	'''
	LineStyle enumeration.
	'''
	LineStyle_Dash                =1         
	'''Constant value is 1.'''
	LineStyle_DashDot             =3         
	'''Constant value is 3.'''
	LineStyle_DashDotDot          =4         
	'''Constant value is 4.'''
	LineStyle_Dot                 =2         
	'''Constant value is 2.'''
	LineStyle_Solid               =0         
	'''Constant value is 0.'''
class MagnitudeType(IntEnum):
	'''
	MagnitudeType enumeration.
	'''
	MagnitudeType_Amplitude       =0         
	'''Constant value is 0.'''
	MagnitudeType_PowerSpectrum   =1         
	'''Constant value is 1.'''
	MagnitudeType_PowerSpectrumDensity=2         
	'''Constant value is 2.'''
class MessageType(IntEnum):
	'''
	MessageType enumeration.
	'''
	MessageType_Error             =3         
	'''Constant value is 3.'''
	MessageType_Info              =1         
	'''Constant value is 1.'''
	MessageType_None              =0         
	'''Constant value is 0.'''
	MessageType_Warning           =2         
	'''Constant value is 2.'''
class MouseDragAction(IntEnum):
	'''
	MouseDragAction enumeration.
	'''
	MouseDragAction_SelectSeries  =1         
	'''Constant value is 1.'''
	MouseDragAction_SelectZoom    =0         
	'''Constant value is 0.'''
class MultipleAxisDrawOption(IntEnum):
	'''
	MultipleAxisDrawOption enumeration.
	'''
	MultipleAxisDrawOption_AtCurrent=1         
	'''Constant value is 1.'''
	MultipleAxisDrawOption_AtNewAxis=2         
	'''Constant value is 2.'''
	MultipleAxisDrawOption_AtSameUnit=0         
	'''Constant value is 0.'''
class NumberOfPointsType(IntEnum):
	'''
	NumberOfPointsType enumeration.
	'''
	NumberOfPointsType_Auto       =0         
	'''Constant value is 0.'''
	NumberOfPointsType_Nth        =1         
	'''Constant value is 1.'''
class OrientationEx(IntEnum):
	'''
	OrientationEx enumeration.
	'''
	OrientationEx_Horizontal      =0         
	'''Constant value is 0.'''
	OrientationEx_Vertical        =1         
	'''Constant value is 1.'''
class PSDType(IntEnum):
	'''
	PSDType enumeration.
	'''
	PSDType_Density               =1         
	'''Constant value is 1.'''
	PSDType_Spectrum              =0         
	'''Constant value is 0.'''
class PaletteColorSetBy(IntEnum):
	'''
	PaletteColorSetBy enumeration.
	'''
	PaletteColorSetBy_Custom      =100       
	'''Constant value is 100.'''
	PaletteColorSetBy_Set1        =0         
	'''Constant value is 0.'''
	PaletteColorSetBy_Set10       =9         
	'''Constant value is 9.'''
	PaletteColorSetBy_Set2        =1         
	'''Constant value is 1.'''
	PaletteColorSetBy_Set3        =2         
	'''Constant value is 2.'''
	PaletteColorSetBy_Set4        =3         
	'''Constant value is 3.'''
	PaletteColorSetBy_Set5        =4         
	'''Constant value is 4.'''
	PaletteColorSetBy_Set6        =5         
	'''Constant value is 5.'''
	PaletteColorSetBy_Set7        =6         
	'''Constant value is 6.'''
	PaletteColorSetBy_Set8        =7         
	'''Constant value is 7.'''
	PaletteColorSetBy_Set9        =8         
	'''Constant value is 8.'''
class PaneType(IntEnum):
	'''
	PaneType enumeration.
	'''
	PaneType_Document             =0         
	'''Constant value is 0.'''
	PaneType_Other                =1         
	'''Constant value is 1.'''
class PointMarker3DType(IntEnum):
	'''
	PointMarker3DType enumeration.
	'''
	PointMarker3DType_Cube        =1         
	'''Constant value is 1.'''
	PointMarker3DType_Cylnder     =2         
	'''Constant value is 2.'''
	PointMarker3DType_Ellipse     =3         
	'''Constant value is 3.'''
	PointMarker3DType_None        =0         
	'''Constant value is 0.'''
	PointMarker3DType_Pixel       =4         
	'''Constant value is 4.'''
	PointMarker3DType_Pyramid     =5         
	'''Constant value is 5.'''
	PointMarker3DType_Quad        =6         
	'''Constant value is 6.'''
	PointMarker3DType_Sphere      =7         
	'''Constant value is 7.'''
	PointMarker3DType_Triangle    =8         
	'''Constant value is 8.'''
class PointMarkerType(IntEnum):
	'''
	PointMarkerType enumeration.
	'''
	PointMarkerType_Cross         =4         
	'''Constant value is 4.'''
	PointMarkerType_Ellipse       =1         
	'''Constant value is 1.'''
	PointMarkerType_InvertedTriangle=6         
	'''Constant value is 6.'''
	PointMarkerType_None          =0         
	'''Constant value is 0.'''
	PointMarkerType_Square        =2         
	'''Constant value is 2.'''
	PointMarkerType_Triangle      =3         
	'''Constant value is 3.'''
	PointMarkerType_XPoint        =5         
	'''Constant value is 5.'''
class PreviewModeMouseAction(IntEnum):
	'''
	PreviewModeMouseAction enumeration.
	'''
	PreviewModeMouseAction_DoubleClick=1         
	'''Constant value is 1.'''
	PreviewModeMouseAction_SingleClick=0         
	'''Constant value is 0.'''
class RPMComputeType(IntEnum):
	'''
	RPMComputeType enumeration.
	'''
	RPMComputeType_Average        =1         
	'''Constant value is 1.'''
	RPMComputeType_Maximum        =2         
	'''Constant value is 2.'''
	RPMComputeType_Minimum        =0         
	'''Constant value is 0.'''
class RibbonButtonSize(IntEnum):
	'''
	RibbonButtonSize enumeration.
	'''
	RibbonButtonSize_Large        =2         
	'''Constant value is 2.'''
	RibbonButtonSize_Medium       =1         
	'''Constant value is 1.'''
	RibbonButtonSize_Small        =0         
	'''Constant value is 0.'''
class SamplingMode(IntEnum):
	'''
	SamplingMode enumeration.
	'''
	SamplingMode_Auto             =6         
	'''Constant value is 6.'''
	SamplingMode_Max              =3         
	'''Constant value is 3.'''
	SamplingMode_Mid              =2         
	'''Constant value is 2.'''
	SamplingMode_Min              =4         
	'''Constant value is 4.'''
	SamplingMode_MinMax           =1         
	'''Constant value is 1.'''
	SamplingMode_MinMaxWithUnevenSpacing=5         
	'''Constant value is 5.'''
	SamplingMode_MinOrMax         =7         
	'''Constant value is 7.'''
	SamplingMode_None             =0         
	'''Constant value is 0.'''
class SeriesType(IntEnum):
	'''
	SeriesType enumeration.
	'''
	SeriesType_Bar                =2         
	'''Constant value is 2.'''
	SeriesType_Impulse            =4         
	'''Constant value is 4.'''
	SeriesType_Line               =0         
	'''Constant value is 0.'''
	SeriesType_Mountain           =3         
	'''Constant value is 3.'''
	SeriesType_Step               =1         
	'''Constant value is 1.'''
class ShowOrderNumberBy(IntEnum):
	'''
	ShowOrderNumberBy enumeration.
	'''
	ShowOrderNumberBy_Inside      =1         
	'''Constant value is 1.'''
	ShowOrderNumberBy_None        =0         
	'''Constant value is 0.'''
	ShowOrderNumberBy_Outside     =2         
	'''Constant value is 2.'''
class SignalOffset(IntEnum):
	'''
	SignalOffset enumeration.
	'''
	SignalOffset_FrameAveragetoZero=2         
	'''Constant value is 2.'''
	SignalOffset_None             =0         
	'''Constant value is 0.'''
	SignalOffset_SignalAveragetoZero=1         
	'''Constant value is 1.'''
class SourceMode(IntEnum):
	'''
	SourceMode enumeration.
	'''
	SourceMode_AllSeries          =0         
	'''Constant value is 0.'''
	SourceMode_AllVisibleSeries   =1         
	'''Constant value is 1.'''
	SourceMode_SelectedSeries     =2         
	'''Constant value is 2.'''
	SourceMode_UnselectedSeries   =3         
	'''Constant value is 3.'''
class SurfaceMesh2DContourType(IntEnum):
	'''
	SurfaceMesh2DContourType enumeration.
	'''
	SurfaceMesh2DContourType_ContourColorsOnBottom=4         
	'''Constant value is 4.'''
	SurfaceMesh2DContourType_ContourColorsOnTop=3         
	'''Constant value is 3.'''
	SurfaceMesh2DContourType_ContourLinesOnBottom=2         
	'''Constant value is 2.'''
	SurfaceMesh2DContourType_ContourLinesOnTop=1         
	'''Constant value is 1.'''
	SurfaceMesh2DContourType_None =0         
	'''Constant value is 0.'''
class TachometerType(IntEnum):
	'''
	TachometerType enumeration.
	'''
	TachometerType_RPM            =1         
	'''Constant value is 1.'''
	TachometerType_RadianPerSecond=2         
	'''Constant value is 2.'''
	TachometerType_Tacho          =0         
	'''Constant value is 0.'''
class TextAlignment3D(IntEnum):
	'''
	TextAlignment3D enumeration.
	'''
	TextAlignment3D_ScreenAutoRotated=1         
	'''Constant value is 1.'''
	TextAlignment3D_ScreenHorizontal=0         
	'''Constant value is 0.'''
class ThemeType(IntEnum):
	'''
	ThemeType enumeration.
	'''
	ThemeType_Blue                =2         
	'''Constant value is 2.'''
	ThemeType_Gray                =0         
	'''Constant value is 0.'''
	ThemeType_Green               =3         
	'''Constant value is 3.'''
	ThemeType_Red                 =1         
	'''Constant value is 1.'''
class TooltipPlacement(IntEnum):
	'''
	TooltipPlacement enumeration.
	'''
	TooltipPlacement_Left         =1         
	'''Constant value is 1.'''
	TooltipPlacement_Right        =0         
	'''Constant value is 0.'''
class TooltipStyle(IntEnum):
	'''
	TooltipStyle enumeration.
	'''
	TooltipStyle_Popup            =1         
	'''Constant value is 1.'''
	TooltipStyle_TooltipControl   =0         
	'''Constant value is 0.'''
class TranslateType(IntEnum):
	'''
	TranslateType enumeration.
	'''
	TranslateType_AlignToSeries   =2         
	'''Constant value is 2.'''
	TranslateType_MoveFirstPointTo=1         
	'''Constant value is 1.'''
	TranslateType_Offset          =0         
	'''Constant value is 0.'''
class UserControlPosition(IntEnum):
	'''
	UserControlPosition enumeration.
	'''
	UserControlPosition_Bottom    =1         
	'''Constant value is 1.'''
	UserControlPosition_Center    =2         
	'''Constant value is 2.'''
	UserControlPosition_Left      =3         
	'''Constant value is 3.'''
	UserControlPosition_Right     =4         
	'''Constant value is 4.'''
	UserControlPosition_Top       =0         
	'''Constant value is 0.'''
class VKFilterNumberOfPole(IntEnum):
	'''
	VKFilterNumberOfPole enumeration.
	'''
	VKFilterNumberOfPole_Three    =1         
	'''Constant value is 1.'''
	VKFilterNumberOfPole_Two      =0         
	'''Constant value is 0.'''
class VKInputType(IntEnum):
	'''
	VKInputType enumeration.
	'''
	VKInputType_BandWidth         =0         
	'''Constant value is 0.'''
	VKInputType_VKFWeight         =1         
	'''Constant value is 1.'''
class VerticalAlignmentEx(IntEnum):
	'''
	VerticalAlignmentEx enumeration.
	'''
	VerticalAlignmentEx_Bottom    =2         
	'''Constant value is 2.'''
	VerticalAlignmentEx_Center    =1         
	'''Constant value is 1.'''
	VerticalAlignmentEx_Top       =0         
	'''Constant value is 0.'''
class WindowMethod(IntEnum):
	'''
	WindowMethod enumeration.
	'''
	WindowMethod_Bartlett         =1         
	'''Constant value is 1.'''
	WindowMethod_Blackman         =5         
	'''Constant value is 5.'''
	WindowMethod_Hamming          =4         
	'''Constant value is 4.'''
	WindowMethod_Hanning          =3         
	'''Constant value is 3.'''
	WindowMethod_Square           =0         
	'''Constant value is 0.'''
	WindowMethod_Welch            =2         
	'''Constant value is 2.'''
class WindowType(IntEnum):
	'''
	WindowType enumeration.
	'''
	WindowType_Bartlett           =1         
	'''Constant value is 1.'''
	WindowType_Blackman           =5         
	'''Constant value is 5.'''
	WindowType_Hamming            =4         
	'''Constant value is 4.'''
	WindowType_Hanning            =3         
	'''Constant value is 3.'''
	WindowType_Square             =0         
	'''Constant value is 0.'''
	WindowType_Welch              =2         
	'''Constant value is 2.'''
class XAxisRegion(IntEnum):
	'''
	XAxisRegion enumeration.
	'''
	XAxisRegion_EntireRegionofXAxis=0         
	'''Constant value is 0.'''
	XAxisRegion_SpecifiedRegionofXAxis=1         
	'''Constant value is 1.'''
class XyDirection(IntEnum):
	'''
	XyDirection enumeration.
	'''
	XyDirection_XDirection        =0         
	'''Constant value is 0.'''
	XyDirection_XYDirection       =2         
	'''Constant value is 2.'''
	XyDirection_YDirection        =1         
	'''Constant value is 1.'''

from win32com.client import DispatchBaseClass
class IAnalysisFunctions(DispatchBaseClass):
	'''Defines interface for the AnalysisFunctions.'''
	CLSID = IID('{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def FFTMagnitude(self, arrCurveXData, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax):
		'''
		Executes the FFT (Magnitude) analyis function.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param enWindowType: WindowMethod
		:param iNumberofPoint: int
		:param dMin: float
		:param dMax: float
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743808, 1, (24, 0), ((8197, 1), (8197, 1), (3, 1), (3, 1), (5, 1), (5, 1), (24581, 2), (24581, 2)), 'FFTMagnitude', None,arrCurveXData
			, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax
			, pythoncom.Missing, pythoncom.Missing)


	def FFTPSD(self, arrCurveXData, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax, enPSDType):
		'''
		Executes the FFT (Power Spectral Density) analyis function.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param enWindowType: WindowMethod
		:param iNumberofPoint: int
		:param dMin: float
		:param dMax: float
		:param enPSDType: PSDType
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743810, 1, (24, 0), ((8197, 1), (8197, 1), (3, 1), (3, 1), (5, 1), (5, 1), (3, 1), (24581, 2), (24581, 2)), 'FFTPSD', None,arrCurveXData
			, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax
			, enPSDType, pythoncom.Missing, pythoncom.Missing)


	def FFTPhase(self, arrCurveXData, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax):
		'''
		Executes the FFT (Phase) analyis function.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param enWindowType: WindowMethod
		:param iNumberofPoint: int
		:param dMin: float
		:param dMax: float
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743809, 1, (24, 0), ((8197, 1), (8197, 1), (3, 1), (3, 1), (5, 1), (5, 1), (24581, 2), (24581, 2)), 'FFTPhase', None,arrCurveXData
			, arrCurveYData, enWindowType, iNumberofPoint, dMin, dMax
			, pythoncom.Missing, pythoncom.Missing)


	def FilterButterWorth(self, arrCurveXData, arrCurveYData, enButterWorthOption, iOrder, iCutoff, dLowCutoff, dHigtCutoff):
		'''
		Executes the Filter (Butter Worth) analyis function.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param enButterWorthOption: ButterWorthOption
		:param iOrder: int
		:param iCutoff: int
		:param dLowCutoff: float
		:param dHigtCutoff: float
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743811, 1, (24, 0), ((8197, 1), (8197, 1), (3, 1), (3, 1), (3, 1), (5, 1), (5, 1), (24581, 2), (24581, 2)), 'FilterButterWorth', None,arrCurveXData
			, arrCurveYData, enButterWorthOption, iOrder, iCutoff, dLowCutoff
			, dHigtCutoff, pythoncom.Missing, pythoncom.Missing)


	def FilterTransferFunction(self, arrCurveXData, arrCurveYData, dNumerator, dDenominator):
		'''
		Executes the Filter (Transfer Function) analyis function.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param dNumerator: list[float]
		:param dDenominator: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743812, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'FilterTransferFunction', None,arrCurveXData
			, arrCurveYData, dNumerator, dDenominator, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathAbsolute(self, arrCurveXData, arrCurveYData):
		'''
		xecutes the function to calculate the absolute value of each data.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743813, 1, (24, 0), ((8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathAbsolute', None,arrCurveXData
			, arrCurveYData, pythoncom.Missing, pythoncom.Missing)


	def SimpleMathDivide(self, arrCurve1XData, arrCurve1YData, arrCurve2XData, arrCurve2YData):
		'''
		Executes the function to find the division of two curve data.
		
		:param arrCurve1XData: list[float]
		:param arrCurve1YData: list[float]
		:param arrCurve2XData: list[float]
		:param arrCurve2YData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743814, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathDivide', None,arrCurve1XData
			, arrCurve1YData, arrCurve2XData, arrCurve2YData, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathMultiply(self, arrCurve1XData, arrCurve1YData, arrCurve2XData, arrCurve2YData):
		'''
		Executes the function to find the multiply of two curve data.
		
		:param arrCurve1XData: list[float]
		:param arrCurve1YData: list[float]
		:param arrCurve2XData: list[float]
		:param arrCurve2YData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743815, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathMultiply', None,arrCurve1XData
			, arrCurve1YData, arrCurve2XData, arrCurve2YData, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathScale(self, arrCurveXData, arrCurveYData, dScaleX, dScaleY):
		'''
		Executes the function to scale each data.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param dScaleX: float
		:param dScaleY: float
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743816, 1, (24, 0), ((8197, 1), (8197, 1), (5, 1), (5, 1), (24581, 2), (24581, 2)), 'SimpleMathScale', None,arrCurveXData
			, arrCurveYData, dScaleX, dScaleY, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathSubtract(self, arrCurve1XData, arrCurve1YData, arrCurve2XData, arrCurve2YData):
		'''
		Executes the function to find the subtraction of two curve data.
		
		:param arrCurve1XData: list[float]
		:param arrCurve1YData: list[float]
		:param arrCurve2XData: list[float]
		:param arrCurve2YData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743817, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathSubtract', None,arrCurve1XData
			, arrCurve1YData, arrCurve2XData, arrCurve2YData, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathSum(self, arrCurve1XData, arrCurve1YData, arrCurve2XData, arrCurve2YData):
		'''
		Executes the function to find the sum of two curve data.
		
		:param arrCurve1XData: list[float]
		:param arrCurve1YData: list[float]
		:param arrCurve2XData: list[float]
		:param arrCurve2YData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743818, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathSum', None,arrCurve1XData
			, arrCurve1YData, arrCurve2XData, arrCurve2YData, pythoncom.Missing, pythoncom.Missing
			)


	def SimpleMathTranslate(self, arrCurveXData, arrCurveYData, enTranslateType, dTransX, dTransY, arrCurveAlignXData, arrCurveAlignYData):
		'''
		Executes the function to translate the curve data.
		
		:param arrCurveXData: list[float]
		:param arrCurveYData: list[float]
		:param enTranslateType: TranslateType
		:param dTransX: float
		:param dTransY: float
		:param arrCurveAlignXData: list[float]
		:param arrCurveAlignYData: list[float]
		:rtype: (list[float], list[float])
		'''
		return self._ApplyTypes_(1610743819, 1, (24, 0), ((8197, 1), (8197, 1), (3, 1), (5, 1), (5, 1), (8197, 1), (8197, 1), (24581, 2), (24581, 2)), 'SimpleMathTranslate', None,arrCurveXData
			, arrCurveYData, enTranslateType, dTransX, dTransY, arrCurveAlignXData
			, arrCurveAlignYData, pythoncom.Missing, pythoncom.Missing)


	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IAnimation(DispatchBaseClass):
	'''Defines interface for the AnimationOperation. This Operation provides the animation control.'''
	CLSID = IID('{5812880C-C727-4800-8762-E3EA5CFD8797}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Pause(self):
		'''
		Pauses the animation.
		'''
		return self._oleobj_.InvokeTypes(1610743828, LCID, 1, (24, 0), (),)


	def Play(self):
		'''
		Plays the animation.
		'''
		return self._oleobj_.InvokeTypes(1610743827, LCID, 1, (24, 0), (),)


	def PrepareAnimation(self):
		'''
		Prepares the animation.
		'''
		return self._oleobj_.InvokeTypes(1610743831, LCID, 1, (24, 0), (),)


	def Stop(self):
		'''
		Stops the animation.
		'''
		return self._oleobj_.InvokeTypes(1610743829, LCID, 1, (24, 0), (),)


	def UpdateMaxFrame(self):
		'''
		Updates the maximum frame from all child documents that supports an animation.
		'''
		return self._oleobj_.InvokeTypes(1610743830, LCID, 1, (24, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_CurrentFrame(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "CurrentFrame", None))
	def _get_Delay(self):
		return self._ApplyTypes_(*(1610743825, 2, (3, 0), (), "Delay", None))
	def _get_EndFrame(self):
		return self._ApplyTypes_(*(1610743818, 2, (3, 0), (), "EndFrame", None))
	def _get_FrameStep(self):
		return self._ApplyTypes_(*(1610743823, 2, (3, 0), (), "FrameStep", None))
	def _get_MaxFrame(self):
		return self._ApplyTypes_(*(1610743820, 2, (3, 0), (), "MaxFrame", None))
	def _get_Model(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Model", '{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_PlayType(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "PlayType", '{04B148FE-B33A-33B2-9E24-767C75B8D748}'))
	def _get_StartFrame(self):
		return self._ApplyTypes_(*(1610743816, 2, (3, 0), (), "StartFrame", None))
	def _get_Status(self):
		return self._ApplyTypes_(*(1610743813, 2, (3, 0), (), "Status", '{4D37E22E-070C-3D14-83A7-A084CF15805A}'))
	def _get_UseCustomFrame(self):
		return self._ApplyTypes_(*(1610743814, 2, (11, 0), (), "UseCustomFrame", None))

	def _set_CurrentFrame(self, value):
		if "CurrentFrame" in self.__dict__: self.__dict__["CurrentFrame"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_Delay(self, value):
		if "Delay" in self.__dict__: self.__dict__["Delay"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_EndFrame(self, value):
		if "EndFrame" in self.__dict__: self.__dict__["EndFrame"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_FrameStep(self, value):
		if "FrameStep" in self.__dict__: self.__dict__["FrameStep"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_PlayType(self, value):
		if "PlayType" in self.__dict__: self.__dict__["PlayType"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))
	def _set_StartFrame(self, value):
		if "StartFrame" in self.__dict__: self.__dict__["StartFrame"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_UseCustomFrame(self, value):
		if "UseCustomFrame" in self.__dict__: self.__dict__["UseCustomFrame"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))

	CurrentFrame = property(_get_CurrentFrame, _set_CurrentFrame)
	'''
	Gets or sets the current frame.

	:type: int
	'''
	Delay = property(_get_Delay, _set_Delay)
	'''
	Gets or sets the animation delay.

	:type: int
	'''
	EndFrame = property(_get_EndFrame, _set_EndFrame)
	'''
	Gets or sets the end frame.

	:type: int
	'''
	FrameStep = property(_get_FrameStep, _set_FrameStep)
	'''
	Gets or sets the frame step.

	:type: int
	'''
	MaxFrame = property(_get_MaxFrame, None)
	'''
	Gets the maximum frame.

	:type: int
	'''
	Model = property(_get_Model, None)
	'''
	Gets the model related to this Operation.

	:type: recurdyn.Post.IEntityModel
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	PlayType = property(_get_PlayType, _set_PlayType)
	'''
	Gets or sets the animation play type.

	:type: recurdyn.Post.AnimationPlayType
	'''
	StartFrame = property(_get_StartFrame, _set_StartFrame)
	'''
	Gets or sets the start frame.

	:type: int
	'''
	Status = property(_get_Status, None)
	'''
	Gets or sets the animation status.

	:type: recurdyn.Post.AnimationStatus
	'''
	UseCustomFrame = property(_get_UseCustomFrame, _set_UseCustomFrame)
	'''
	Gets or sets a value whether the custome frame is used.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_CurrentFrame": _set_CurrentFrame,
		"_set_Delay": _set_Delay,
		"_set_EndFrame": _set_EndFrame,
		"_set_FrameStep": _set_FrameStep,
		"_set_PlayType": _set_PlayType,
		"_set_StartFrame": _set_StartFrame,
		"_set_UseCustomFrame": _set_UseCustomFrame,
	}
	_prop_map_get_ = {
		"CurrentFrame": (1610743821, 2, (3, 0), (), "CurrentFrame", None),
		"Delay": (1610743825, 2, (3, 0), (), "Delay", None),
		"EndFrame": (1610743818, 2, (3, 0), (), "EndFrame", None),
		"FrameStep": (1610743823, 2, (3, 0), (), "FrameStep", None),
		"MaxFrame": (1610743820, 2, (3, 0), (), "MaxFrame", None),
		"Model": (1610743810, 2, (9, 0), (), "Model", '{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"PlayType": (1610743811, 2, (3, 0), (), "PlayType", '{04B148FE-B33A-33B2-9E24-767C75B8D748}'),
		"StartFrame": (1610743816, 2, (3, 0), (), "StartFrame", None),
		"Status": (1610743813, 2, (3, 0), (), "Status", '{4D37E22E-070C-3D14-83A7-A084CF15805A}'),
		"UseCustomFrame": (1610743814, 2, (11, 0), (), "UseCustomFrame", None),
	}
	_prop_map_put_ = {
		"CurrentFrame": ((1610743821, LCID, 4, 0),()),
		"Delay": ((1610743825, LCID, 4, 0),()),
		"EndFrame": ((1610743818, LCID, 4, 0),()),
		"FrameStep": ((1610743823, LCID, 4, 0),()),
		"PlayType": ((1610743811, LCID, 4, 0),()),
		"StartFrame": ((1610743816, LCID, 4, 0),()),
		"UseCustomFrame": ((1610743814, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IAnimationFrame(DispatchBaseClass):
	'''Defines interface of the AnimationFrame.'''
	CLSID = IID('{49D0E38C-E5C3-4BFF-9478-E033FD4A4B53}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_CurrentFrame(self):
		return self._ApplyTypes_(*(1610743815, 2, (3, 0), (), "CurrentFrame", None))
	def _get_Entity(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "Entity", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743809, 2, (11, 0), (), "IsEnabled", None))
	def _get_MaxFrame(self):
		return self._ApplyTypes_(*(1610743813, 2, (3, 0), (), "MaxFrame", None))
	def _get_Status(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Status", '{4D37E22E-070C-3D14-83A7-A084CF15805A}'))

	def _set_CurrentFrame(self, value):
		if "CurrentFrame" in self.__dict__: self.__dict__["CurrentFrame"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743809, LCID, 4, 0) + (value,) + ()))
	def _set_MaxFrame(self, value):
		if "MaxFrame" in self.__dict__: self.__dict__["MaxFrame"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_Status(self, value):
		if "Status" in self.__dict__: self.__dict__["Status"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))

	CurrentFrame = property(_get_CurrentFrame, _set_CurrentFrame)
	'''
	Gets or sets the current frame.

	:type: int
	'''
	Entity = property(_get_Entity, None)
	'''
	Gets or sets the entity.

	:type: object
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this animation is enabled.

	:type: bool
	'''
	MaxFrame = property(_get_MaxFrame, _set_MaxFrame)
	'''
	Gets or sets the maximum frame.

	:type: int
	'''
	Status = property(_get_Status, _set_Status)
	'''
	Gets or sets the status of the animation.

	:type: recurdyn.Post.AnimationStatus
	'''

	_prop_map_set_function_ = {
		"_set_CurrentFrame": _set_CurrentFrame,
		"_set_IsEnabled": _set_IsEnabled,
		"_set_MaxFrame": _set_MaxFrame,
		"_set_Status": _set_Status,
	}
	_prop_map_get_ = {
		"CurrentFrame": (1610743815, 2, (3, 0), (), "CurrentFrame", None),
		"Entity": (1610743808, 2, (12, 0), (), "Entity", None),
		"IsEnabled": (1610743809, 2, (11, 0), (), "IsEnabled", None),
		"MaxFrame": (1610743813, 2, (3, 0), (), "MaxFrame", None),
		"Status": (1610743811, 2, (3, 0), (), "Status", '{4D37E22E-070C-3D14-83A7-A084CF15805A}'),
	}
	_prop_map_put_ = {
		"CurrentFrame": ((1610743815, LCID, 4, 0),()),
		"IsEnabled": ((1610743809, LCID, 4, 0),()),
		"MaxFrame": ((1610743813, LCID, 4, 0),()),
		"Status": ((1610743811, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IApplicationConfig(DispatchBaseClass):
	'''Defines interface for the ApplicationConfig'''
	CLSID = IID('{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_ApplicationOptions(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "ApplicationOptions", '{A3B76163-68FC-447A-99F3-DF40B08DFE1C}'))

	ApplicationOptions = property(_get_ApplicationOptions, None)
	'''
	Gets the application options.

	:type: recurdyn.Post.IApplicationOptions
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ApplicationOptions": (1610743808, 2, (9, 0), (), "ApplicationOptions", '{A3B76163-68FC-447A-99F3-DF40B08DFE1C}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IApplicationOptions(DispatchBaseClass):
	'''Defines interface for the ApplicationOptions'''
	CLSID = IID('{A3B76163-68FC-447A-99F3-DF40B08DFE1C}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Export(self, strFilepath):
		'''
		Exports this application options to the specified filepath.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743823, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def Import(self, strFilepath):
		'''
		Imports the application options from the specified filepath.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743824, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def RestoreOptions(self):
		'''
		Restores all options as the application based default.
		'''
		return self._oleobj_.InvokeTypes(1610743825, LCID, 1, (24, 0), (),)


	def _get_ActivateOutputWhenError(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "ActivateOutputWhenError", None))
	def _get_ActivateOutputWhenInformation(self):
		return self._ApplyTypes_(*(1610743821, 2, (11, 0), (), "ActivateOutputWhenInformation", None))
	def _get_ActivateOutputWhenWarning(self):
		return self._ApplyTypes_(*(1610743819, 2, (11, 0), (), "ActivateOutputWhenWarning", None))
	def _get_ApplicationOptionsChart(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "ApplicationOptionsChart", '{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}'))
	def _get_ApplicationOptionsDataEditor(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "ApplicationOptionsDataEditor", '{17603DE0-C898-401A-A841-F9CB908F5525}'))
	def _get_ApplicationOptionsExportSeriesData(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ApplicationOptionsExportSeriesData", '{926F0F68-9177-47F4-B0C3-788CBD50A011}'))
	def _get_MaximumFilteredCount(self):
		return self._ApplyTypes_(*(1610743815, 2, (3, 0), (), "MaximumFilteredCount", None))
	def _get_NewModelWhenStarting(self):
		return self._ApplyTypes_(*(1610743811, 2, (11, 0), (), "NewModelWhenStarting", None))
	def _get_NumberOfRecentFiles(self):
		return self._ApplyTypes_(*(1610743813, 2, (3, 0), (), "NumberOfRecentFiles", None))

	def _set_ActivateOutputWhenError(self, value):
		if "ActivateOutputWhenError" in self.__dict__: self.__dict__["ActivateOutputWhenError"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_ActivateOutputWhenInformation(self, value):
		if "ActivateOutputWhenInformation" in self.__dict__: self.__dict__["ActivateOutputWhenInformation"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_ActivateOutputWhenWarning(self, value):
		if "ActivateOutputWhenWarning" in self.__dict__: self.__dict__["ActivateOutputWhenWarning"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_MaximumFilteredCount(self, value):
		if "MaximumFilteredCount" in self.__dict__: self.__dict__["MaximumFilteredCount"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_NewModelWhenStarting(self, value):
		if "NewModelWhenStarting" in self.__dict__: self.__dict__["NewModelWhenStarting"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfRecentFiles(self, value):
		if "NumberOfRecentFiles" in self.__dict__: self.__dict__["NumberOfRecentFiles"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	ActivateOutputWhenError = property(_get_ActivateOutputWhenError, _set_ActivateOutputWhenError)
	'''
	Gets or sets the value indicates whether the output window is acitve or not if the error is occured.

	:type: bool
	'''
	ActivateOutputWhenInformation = property(_get_ActivateOutputWhenInformation, _set_ActivateOutputWhenInformation)
	'''
	Gets or sets the value indicates whether the output window is acitve or not if the information is occured.

	:type: bool
	'''
	ActivateOutputWhenWarning = property(_get_ActivateOutputWhenWarning, _set_ActivateOutputWhenWarning)
	'''
	Gets or sets the value indicates whether the output window is acitve or not if the warning is occured.

	:type: bool
	'''
	ApplicationOptionsChart = property(_get_ApplicationOptionsChart, None)
	'''
	Gets the application options about the chart.

	:type: recurdyn.Post.IApplicationOptionsChart
	'''
	ApplicationOptionsDataEditor = property(_get_ApplicationOptionsDataEditor, None)
	'''
	Gets application options about the data table.

	:type: recurdyn.Post.IApplicationOptionsDataEditor
	'''
	ApplicationOptionsExportSeriesData = property(_get_ApplicationOptionsExportSeriesData, None)
	'''
	Gets the application options about the export series data function.

	:type: recurdyn.Post.IApplicationOptionsExportSeriesData
	'''
	MaximumFilteredCount = property(_get_MaximumFilteredCount, _set_MaximumFilteredCount)
	'''
	Gets or sets the maximum filtered count in the datafile database.

	:type: int
	'''
	NewModelWhenStarting = property(_get_NewModelWhenStarting, _set_NewModelWhenStarting)
	'''
	Gets or sets value that indicates whether create new model when the application is starting.

	:type: bool
	'''
	NumberOfRecentFiles = property(_get_NumberOfRecentFiles, _set_NumberOfRecentFiles)
	'''
	 Gets or sets the maximum number of recent files.

	:type: int
	'''

	_prop_map_set_function_ = {
		"_set_ActivateOutputWhenError": _set_ActivateOutputWhenError,
		"_set_ActivateOutputWhenInformation": _set_ActivateOutputWhenInformation,
		"_set_ActivateOutputWhenWarning": _set_ActivateOutputWhenWarning,
		"_set_MaximumFilteredCount": _set_MaximumFilteredCount,
		"_set_NewModelWhenStarting": _set_NewModelWhenStarting,
		"_set_NumberOfRecentFiles": _set_NumberOfRecentFiles,
	}
	_prop_map_get_ = {
		"ActivateOutputWhenError": (1610743817, 2, (11, 0), (), "ActivateOutputWhenError", None),
		"ActivateOutputWhenInformation": (1610743821, 2, (11, 0), (), "ActivateOutputWhenInformation", None),
		"ActivateOutputWhenWarning": (1610743819, 2, (11, 0), (), "ActivateOutputWhenWarning", None),
		"ApplicationOptionsChart": (1610743808, 2, (9, 0), (), "ApplicationOptionsChart", '{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}'),
		"ApplicationOptionsDataEditor": (1610743810, 2, (9, 0), (), "ApplicationOptionsDataEditor", '{17603DE0-C898-401A-A841-F9CB908F5525}'),
		"ApplicationOptionsExportSeriesData": (1610743809, 2, (9, 0), (), "ApplicationOptionsExportSeriesData", '{926F0F68-9177-47F4-B0C3-788CBD50A011}'),
		"MaximumFilteredCount": (1610743815, 2, (3, 0), (), "MaximumFilteredCount", None),
		"NewModelWhenStarting": (1610743811, 2, (11, 0), (), "NewModelWhenStarting", None),
		"NumberOfRecentFiles": (1610743813, 2, (3, 0), (), "NumberOfRecentFiles", None),
	}
	_prop_map_put_ = {
		"ActivateOutputWhenError": ((1610743817, LCID, 4, 0),()),
		"ActivateOutputWhenInformation": ((1610743821, LCID, 4, 0),()),
		"ActivateOutputWhenWarning": ((1610743819, LCID, 4, 0),()),
		"MaximumFilteredCount": ((1610743815, LCID, 4, 0),()),
		"NewModelWhenStarting": ((1610743811, LCID, 4, 0),()),
		"NumberOfRecentFiles": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IApplicationOptionsChart(DispatchBaseClass):
	'''Defines interface of application chart options.'''
	CLSID = IID('{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_AutoFit(self):
		return self._ApplyTypes_(*(1610743810, 2, (11, 0), (), "AutoFit", None))
	def _get_EnableMouseDoubleClickFit(self):
		return self._ApplyTypes_(*(1610743824, 2, (11, 0), (), "EnableMouseDoubleClickFit", None))
	def _get_EnableMouseDragPanAction(self):
		return self._ApplyTypes_(*(1610743820, 2, (11, 0), (), "EnableMouseDragPanAction", None))
	def _get_EnableMouseWheelAction(self):
		return self._ApplyTypes_(*(1610743818, 2, (11, 0), (), "EnableMouseWheelAction", None))
	def _get_MouseDragAction(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "MouseDragAction", '{F840B6EE-855A-39DB-A57E-C31F3633F549}'))
	def _get_MouseDragPanActionFitYAxis(self):
		return self._ApplyTypes_(*(1610743822, 2, (11, 0), (), "MouseDragPanActionFitYAxis", None))
	def _get_PreviewModeMouseAction(self):
		return self._ApplyTypes_(*(1610743830, 2, (3, 0), (), "PreviewModeMouseAction", '{CA169CFB-510D-307A-B1D6-44EAD1BF1A3C}'))
	def _get_SelectZoomFitYAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "SelectZoomFitYAxis", None))
	def _get_SelectZoomXAxisOnly(self):
		return self._ApplyTypes_(*(1610743814, 2, (11, 0), (), "SelectZoomXAxisOnly", None))
	def _get_SelectedSeriesThickness(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "SelectedSeriesThickness", None))
	def _get_UseAutoDecimalPointsForAxisTickLabel(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "UseAutoDecimalPointsForAxisTickLabel", None))
	def _get_XyDirection(self):
		return self._ApplyTypes_(*(1610743826, 2, (3, 0), (), "XyDirection", '{D9E129D4-E0BB-38D7-B8A3-23CE1FB45903}'))

	def _set_AutoFit(self, value):
		if "AutoFit" in self.__dict__: self.__dict__["AutoFit"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))
	def _set_EnableMouseDoubleClickFit(self, value):
		if "EnableMouseDoubleClickFit" in self.__dict__: self.__dict__["EnableMouseDoubleClickFit"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_EnableMouseDragPanAction(self, value):
		if "EnableMouseDragPanAction" in self.__dict__: self.__dict__["EnableMouseDragPanAction"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_EnableMouseWheelAction(self, value):
		if "EnableMouseWheelAction" in self.__dict__: self.__dict__["EnableMouseWheelAction"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_MouseDragAction(self, value):
		if "MouseDragAction" in self.__dict__: self.__dict__["MouseDragAction"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_MouseDragPanActionFitYAxis(self, value):
		if "MouseDragPanActionFitYAxis" in self.__dict__: self.__dict__["MouseDragPanActionFitYAxis"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_PreviewModeMouseAction(self, value):
		if "PreviewModeMouseAction" in self.__dict__: self.__dict__["PreviewModeMouseAction"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_SelectZoomFitYAxis(self, value):
		if "SelectZoomFitYAxis" in self.__dict__: self.__dict__["SelectZoomFitYAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_SelectZoomXAxisOnly(self, value):
		if "SelectZoomXAxisOnly" in self.__dict__: self.__dict__["SelectZoomXAxisOnly"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_SelectedSeriesThickness(self, value):
		if "SelectedSeriesThickness" in self.__dict__: self.__dict__["SelectedSeriesThickness"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoDecimalPointsForAxisTickLabel(self, value):
		if "UseAutoDecimalPointsForAxisTickLabel" in self.__dict__: self.__dict__["UseAutoDecimalPointsForAxisTickLabel"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_XyDirection(self, value):
		if "XyDirection" in self.__dict__: self.__dict__["XyDirection"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))

	AutoFit = property(_get_AutoFit, _set_AutoFit)
	'''
	Gets or sets a value indicates whether chart is auto fit after drawing a series.

	:type: bool
	'''
	EnableMouseDoubleClickFit = property(_get_EnableMouseDoubleClickFit, _set_EnableMouseDoubleClickFit)
	'''
	Gets or sets a value indicating whether to fit with a double click of the mouse.

	:type: bool
	'''
	EnableMouseDragPanAction = property(_get_EnableMouseDragPanAction, _set_EnableMouseDragPanAction)
	'''
	Gets or sets a value indicates whether to use the mouse drag pan action.

	:type: bool
	'''
	EnableMouseWheelAction = property(_get_EnableMouseWheelAction, _set_EnableMouseWheelAction)
	'''
	Gets or sets a value indicates whether to use the mouse wheel action to zoom.

	:type: bool
	'''
	MouseDragAction = property(_get_MouseDragAction, _set_MouseDragAction)
	'''
	Gets or sets the mouse drag action.

	:type: recurdyn.Post.MouseDragAction
	'''
	MouseDragPanActionFitYAxis = property(_get_MouseDragPanActionFitYAxis, _set_MouseDragPanActionFitYAxis)
	'''
	Gets or sets a value indicates whether to fit the y-axis after mouse drag pan.

	:type: bool
	'''
	PreviewModeMouseAction = property(_get_PreviewModeMouseAction, _set_PreviewModeMouseAction)
	'''
	Gets or sets the preview mode mouse action.

	:type: recurdyn.Post.PreviewModeMouseAction
	'''
	SelectZoomFitYAxis = property(_get_SelectZoomFitYAxis, _set_SelectZoomFitYAxis)
	'''
	Gets or sets a value indicates whether to fit the y-axis after zooming.

	:type: bool
	'''
	SelectZoomXAxisOnly = property(_get_SelectZoomXAxisOnly, _set_SelectZoomXAxisOnly)
	'''
	Gets or sets a value indicates whether to zoom only the x-axis.

	:type: bool
	'''
	SelectedSeriesThickness = property(_get_SelectedSeriesThickness, _set_SelectedSeriesThickness)
	'''
	ionOptions

	:type: int
	'''
	UseAutoDecimalPointsForAxisTickLabel = property(_get_UseAutoDecimalPointsForAxisTickLabel, _set_UseAutoDecimalPointsForAxisTickLabel)
	'''
	Gets or sets a value indicates whether the decimal points is adjusted automatically in the axis tick label.

	:type: bool
	'''
	XyDirection = property(_get_XyDirection, _set_XyDirection)
	'''
	Gets or sets the xy direction when zoom /move pan.

	:type: recurdyn.Post.XyDirection
	'''

	_prop_map_set_function_ = {
		"_set_AutoFit": _set_AutoFit,
		"_set_EnableMouseDoubleClickFit": _set_EnableMouseDoubleClickFit,
		"_set_EnableMouseDragPanAction": _set_EnableMouseDragPanAction,
		"_set_EnableMouseWheelAction": _set_EnableMouseWheelAction,
		"_set_MouseDragAction": _set_MouseDragAction,
		"_set_MouseDragPanActionFitYAxis": _set_MouseDragPanActionFitYAxis,
		"_set_PreviewModeMouseAction": _set_PreviewModeMouseAction,
		"_set_SelectZoomFitYAxis": _set_SelectZoomFitYAxis,
		"_set_SelectZoomXAxisOnly": _set_SelectZoomXAxisOnly,
		"_set_SelectedSeriesThickness": _set_SelectedSeriesThickness,
		"_set_UseAutoDecimalPointsForAxisTickLabel": _set_UseAutoDecimalPointsForAxisTickLabel,
		"_set_XyDirection": _set_XyDirection,
	}
	_prop_map_get_ = {
		"AutoFit": (1610743810, 2, (11, 0), (), "AutoFit", None),
		"EnableMouseDoubleClickFit": (1610743824, 2, (11, 0), (), "EnableMouseDoubleClickFit", None),
		"EnableMouseDragPanAction": (1610743820, 2, (11, 0), (), "EnableMouseDragPanAction", None),
		"EnableMouseWheelAction": (1610743818, 2, (11, 0), (), "EnableMouseWheelAction", None),
		"MouseDragAction": (1610743828, 2, (3, 0), (), "MouseDragAction", '{F840B6EE-855A-39DB-A57E-C31F3633F549}'),
		"MouseDragPanActionFitYAxis": (1610743822, 2, (11, 0), (), "MouseDragPanActionFitYAxis", None),
		"PreviewModeMouseAction": (1610743830, 2, (3, 0), (), "PreviewModeMouseAction", '{CA169CFB-510D-307A-B1D6-44EAD1BF1A3C}'),
		"SelectZoomFitYAxis": (1610743816, 2, (11, 0), (), "SelectZoomFitYAxis", None),
		"SelectZoomXAxisOnly": (1610743814, 2, (11, 0), (), "SelectZoomXAxisOnly", None),
		"SelectedSeriesThickness": (1610743808, 2, (3, 0), (), "SelectedSeriesThickness", None),
		"UseAutoDecimalPointsForAxisTickLabel": (1610743812, 2, (11, 0), (), "UseAutoDecimalPointsForAxisTickLabel", None),
		"XyDirection": (1610743826, 2, (3, 0), (), "XyDirection", '{D9E129D4-E0BB-38D7-B8A3-23CE1FB45903}'),
	}
	_prop_map_put_ = {
		"AutoFit": ((1610743810, LCID, 4, 0),()),
		"EnableMouseDoubleClickFit": ((1610743824, LCID, 4, 0),()),
		"EnableMouseDragPanAction": ((1610743820, LCID, 4, 0),()),
		"EnableMouseWheelAction": ((1610743818, LCID, 4, 0),()),
		"MouseDragAction": ((1610743828, LCID, 4, 0),()),
		"MouseDragPanActionFitYAxis": ((1610743822, LCID, 4, 0),()),
		"PreviewModeMouseAction": ((1610743830, LCID, 4, 0),()),
		"SelectZoomFitYAxis": ((1610743816, LCID, 4, 0),()),
		"SelectZoomXAxisOnly": ((1610743814, LCID, 4, 0),()),
		"SelectedSeriesThickness": ((1610743808, LCID, 4, 0),()),
		"UseAutoDecimalPointsForAxisTickLabel": ((1610743812, LCID, 4, 0),()),
		"XyDirection": ((1610743826, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IApplicationOptionsDataEditor(DispatchBaseClass):
	'''Defines interface for the application data editor options.'''
	CLSID = IID('{17603DE0-C898-401A-A841-F9CB908F5525}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_NumberOfSignificantDigit(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "NumberOfSignificantDigit", None))

	def _set_NumberOfSignificantDigit(self, value):
		if "NumberOfSignificantDigit" in self.__dict__: self.__dict__["NumberOfSignificantDigit"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	NumberOfSignificantDigit = property(_get_NumberOfSignificantDigit, _set_NumberOfSignificantDigit)
	'''
	Gets or sets the number of significant digits displayed in the data table.

	:type: int
	'''

	_prop_map_set_function_ = {
		"_set_NumberOfSignificantDigit": _set_NumberOfSignificantDigit,
	}
	_prop_map_get_ = {
		"NumberOfSignificantDigit": (1610743808, 2, (3, 0), (), "NumberOfSignificantDigit", None),
	}
	_prop_map_put_ = {
		"NumberOfSignificantDigit": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IApplicationOptionsExportSeriesData(DispatchBaseClass):
	'''Defines interface for application export series data options.'''
	CLSID = IID('{926F0F68-9177-47F4-B0C3-788CBD50A011}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_IncludeTitleHeader(self):
		return self._ApplyTypes_(*(1610743808, 2, (11, 0), (), "IncludeTitleHeader", None))
	def _get_NumberOfSignificantDigit(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "NumberOfSignificantDigit", None))
	def _get_UseScientificNotation(self):
		return self._ApplyTypes_(*(1610743810, 2, (11, 0), (), "UseScientificNotation", None))

	def _set_IncludeTitleHeader(self, value):
		if "IncludeTitleHeader" in self.__dict__: self.__dict__["IncludeTitleHeader"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfSignificantDigit(self, value):
		if "NumberOfSignificantDigit" in self.__dict__: self.__dict__["NumberOfSignificantDigit"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseScientificNotation(self, value):
		if "UseScientificNotation" in self.__dict__: self.__dict__["UseScientificNotation"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))

	IncludeTitleHeader = property(_get_IncludeTitleHeader, _set_IncludeTitleHeader)
	'''
	Gets or sets a value indicates whether to include a title header when the series data is exported.

	:type: bool
	'''
	NumberOfSignificantDigit = property(_get_NumberOfSignificantDigit, _set_NumberOfSignificantDigit)
	'''
	Gets or sets the number of significant digits when the series data is exported.

	:type: int
	'''
	UseScientificNotation = property(_get_UseScientificNotation, _set_UseScientificNotation)
	'''
	Gets or sets a value indicates whether use scientific notation when the series data is exported.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_IncludeTitleHeader": _set_IncludeTitleHeader,
		"_set_NumberOfSignificantDigit": _set_NumberOfSignificantDigit,
		"_set_UseScientificNotation": _set_UseScientificNotation,
	}
	_prop_map_get_ = {
		"IncludeTitleHeader": (1610743808, 2, (11, 0), (), "IncludeTitleHeader", None),
		"NumberOfSignificantDigit": (1610743812, 2, (3, 0), (), "NumberOfSignificantDigit", None),
		"UseScientificNotation": (1610743810, 2, (11, 0), (), "UseScientificNotation", None),
	}
	_prop_map_put_ = {
		"IncludeTitleHeader": ((1610743808, LCID, 4, 0),()),
		"NumberOfSignificantDigit": ((1610743812, LCID, 4, 0),()),
		"UseScientificNotation": ((1610743810, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IAxisXCollection(DispatchBaseClass):
	'''Defines interface for the x axis collection.'''
	CLSID = IID('{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the x axis by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAxisX
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the x axis by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the x axis by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAxisX
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IAxisYCollection(DispatchBaseClass):
	'''Defines interface for the y axis collection.'''
	CLSID = IID('{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the y axis by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAxisY
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the y axis by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the y axis by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAxisY
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class ICampbellDiagram(DispatchBaseClass):
	'''Defines interface for the CampbellDiagramOperation. This Operation provides the management for the campbell data.'''
	CLSID = IID('{2C300492-3E47-49C4-9B4A-CF44F434A0F5}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def CampbellDataCalculate(self):
		'''
		Campbells the data calculate.
		
		:rtype: int
		'''
		return self._oleobj_.InvokeTypes(1610743898, LCID, 1, (3, 0), (),)


	def DrawCampbellDiagram(self):
		'''
		Draws the campbell diagram.
		'''
		return self._oleobj_.InvokeTypes(1610743899, LCID, 1, (24, 0), (),)


	def DrawCampbellSignalInfor(self, enCampbellDataType):
		'''
		Draws the campbell signal information.
		
		:param enCampbellDataType: CampbellDataType
		'''
		return self._oleobj_.InvokeTypes(1610743901, LCID, 1, (24, 0), ((3, 1),),enCampbellDataType
			)


	def GetCampbellProperties(self):
		'''
		Gets the campbell properties from the active plot3D document.
		'''
		return self._oleobj_.InvokeTypes(1610743900, LCID, 1, (24, 0), (),)


	def SetSignalComponent(self, strPath, iIndex):
		'''
		Sets the signal component for the campbell diagram.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743904, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def SetTachoComponent(self, strPath, iIndex):
		'''
		Sets the tacho component for the campbell diagram.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743903, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def SetTimeComponent(self, strPath, iIndex):
		'''
		Sets time component for the campbell diagram.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743902, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def UpdateFrameSettings(self):
		'''
		Updates the frame settings.
		
		:rtype: int
		'''
		return self._oleobj_.InvokeTypes(1610743897, LCID, 1, (3, 0), (),)


	def UpdateSignalData(self):
		'''
		Updates the signal data.
		
		:rtype: int
		'''
		return self._oleobj_.InvokeTypes(1610743896, LCID, 1, (3, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_ApplyWindowCorrectionFactor(self):
		return self._ApplyTypes_(*(1610743890, 2, (11, 0), (), "ApplyWindowCorrectionFactor", None))
	def _get_CalculateAllOrders(self):
		return self._ApplyTypes_(*(1610743886, 2, (11, 0), (), "CalculateAllOrders", None))
	def _get_CampbellDataType(self):
		return self._ApplyTypes_(*(1610743841, 2, (3, 0), (), "CampbellDataType", '{4E55A9C7-3A08-36EA-A47C-B698A2D3B24D}'))
	def _get_CampbellInputFile(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "CampbellInputFile", None))
	def _get_CampbellViewType(self):
		return self._ApplyTypes_(*(1610743865, 2, (3, 0), (), "CampbellViewType", '{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}'))
	def _get_CorrectionFactor(self):
		return self._ApplyTypes_(*(1610743894, 2, (5, 0), (), "CorrectionFactor", None))
	def _get_DecibelReferenceValue(self):
		return self._ApplyTypes_(*(1610743892, 2, (5, 0), (), "DecibelReferenceValue", None))
	def _get_DeltaFrequency(self):
		return self._ApplyTypes_(*(1610743858, 2, (5, 0), (), "DeltaFrequency", None))
	def _get_DeltaTime(self):
		return self._ApplyTypes_(*(1610743819, 2, (3, 0), (), "DeltaTime", None))
	def _get_Dt(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "Dt", None))
	def _get_EndFrame(self):
		return self._ApplyTypes_(*(1610743827, 2, (3, 0), (), "EndFrame", None))
	def _get_EndRPM(self):
		return self._ApplyTypes_(*(1610743852, 2, (5, 0), (), "EndRPM", None))
	def _get_EndTime(self):
		return self._ApplyTypes_(*(1610743847, 2, (5, 0), (), "EndTime", None))
	def _get_FrameLength(self):
		return self._ApplyTypes_(*(1610743855, 2, (5, 0), (), "FrameLength", None))
	def _get_FrameNumber(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "FrameNumber", None))
	def _get_FrameSize(self):
		return self._ApplyTypes_(*(1610743831, 2, (3, 0), (), "FrameSize", None))
	def _get_GraphOption(self):
		return self._ApplyTypes_(*(1610743867, 2, (3, 0), (), "GraphOption", '{CD553711-F6DF-3222-AB54-18337C5AA2E2}'))
	def _get_InterpolationType(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "InterpolationType", '{A5E96348-2158-376F-ADCA-5AD7E7CEF0B0}'))
	def _get_IsOrderLineVisible(self):
		return self._ApplyTypes_(*(1610743871, 2, (11, 0), (), "IsOrderLineVisible", None))
	def _get_IsSwapAxis(self):
		return self._ApplyTypes_(*(1610743869, 2, (11, 0), (), "IsSwapAxis", None))
	def _get_MagnitudeType(self):
		return self._ApplyTypes_(*(1610743863, 2, (3, 0), (), "MagnitudeType", '{78862260-3599-342E-B22D-EE54946796F6}'))
	def _get_MaxFrame(self):
		return self._ApplyTypes_(*(1610743845, 2, (3, 0), (), "MaxFrame", None))
	def _get_MaxFreq(self):
		return self._ApplyTypes_(*(1610743853, 2, (5, 0), (), "MaxFreq", None))
	def _get_MaxOrder(self):
		return self._ApplyTypes_(*(1610743854, 2, (3, 0), (), "MaxOrder", None))
	def _get_OrderLineColor(self):
		return self._ApplyTypes_(*(1610743875, 2, (9, 0), (), "OrderLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_OrderLineGap(self):
		return self._ApplyTypes_(*(1610743882, 2, (5, 0), (), "OrderLineGap", None))
	def _get_OrderLineMaxOrder(self):
		return self._ApplyTypes_(*(1610743878, 2, (5, 0), (), "OrderLineMaxOrder", None))
	def _get_OrderLineMinOrder(self):
		return self._ApplyTypes_(*(1610743880, 2, (5, 0), (), "OrderLineMinOrder", None))
	def _get_OrderLineThickness(self):
		return self._ApplyTypes_(*(1610743873, 2, (4, 0), (), "OrderLineThickness", None))
	def _get_OrderTextSize(self):
		return self._ApplyTypes_(*(1610743876, 2, (5, 0), (), "OrderTextSize", None))
	def _get_Overlap(self):
		return self._ApplyTypes_(*(1610743856, 2, (5, 0), (), "Overlap", None))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_PulsePerRev(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "PulsePerRev", None))
	def _get_RPMComputeType(self):
		return self._ApplyTypes_(*(1610743837, 2, (3, 0), (), "RPMComputeType", '{13B875A6-DEE2-3EC4-9DD2-1CE22CC66487}'))
	def _get_ResidualNumber(self):
		return self._ApplyTypes_(*(1610743857, 2, (3, 0), (), "ResidualNumber", None))
	def _get_Resolution(self):
		return self._ApplyTypes_(*(1610743884, 2, (3, 0), (), "Resolution", None))
	def _get_SamplingTime(self):
		return self._ApplyTypes_(*(1610743850, 2, (5, 0), (), "SamplingTime", None))
	def _get_SignalComponent(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "SignalComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_SignalOffset(self):
		return self._ApplyTypes_(*(1610743859, 2, (3, 0), (), "SignalOffset", '{15E07B49-D53C-34E5-AF1B-C596ACD9746F}'))
	def _get_StartFrame(self):
		return self._ApplyTypes_(*(1610743825, 2, (3, 0), (), "StartFrame", None))
	def _get_StartRPM(self):
		return self._ApplyTypes_(*(1610743851, 2, (5, 0), (), "StartRPM", None))
	def _get_StartTime(self):
		return self._ApplyTypes_(*(1610743846, 2, (5, 0), (), "StartTime", None))
	def _get_TachoComponent(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "TachoComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_TachometerType(self):
		return self._ApplyTypes_(*(1610743817, 2, (3, 0), (), "TachometerType", '{E183000B-6C78-38A9-884A-FC1C8A80DF74}'))
	def _get_TimeComponent(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "TimeComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_TimeZoneEndTime(self):
		return self._ApplyTypes_(*(1610743849, 2, (5, 0), (), "TimeZoneEndTime", None))
	def _get_TimeZoneStartTime(self):
		return self._ApplyTypes_(*(1610743848, 2, (5, 0), (), "TimeZoneStartTime", None))
	def _get_UseDecibelPlot(self):
		return self._ApplyTypes_(*(1610743888, 2, (11, 0), (), "UseDecibelPlot", None))
	def _get_UseInputFile(self):
		return self._ApplyTypes_(*(1610743810, 2, (11, 0), (), "UseInputFile", None))
	def _get_UseInterpolation(self):
		return self._ApplyTypes_(*(1610743835, 2, (11, 0), (), "UseInterpolation", None))
	def _get_UseRecommandedFrameSettings(self):
		return self._ApplyTypes_(*(1610743843, 2, (11, 0), (), "UseRecommandedFrameSettings", None))
	def _get_UseRecommandedTimeZone(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "UseRecommandedTimeZone", None))
	def _get_WindowType(self):
		return self._ApplyTypes_(*(1610743861, 2, (3, 0), (), "WindowType", '{7E83733E-DCF7-36FA-98F1-BA37423D3E5E}'))

	def _set_ApplyWindowCorrectionFactor(self, value):
		if "ApplyWindowCorrectionFactor" in self.__dict__: self.__dict__["ApplyWindowCorrectionFactor"] = value; return
		self._oleobj_.Invoke(*((1610743890, LCID, 4, 0) + (value,) + ()))
	def _set_CalculateAllOrders(self, value):
		if "CalculateAllOrders" in self.__dict__: self.__dict__["CalculateAllOrders"] = value; return
		self._oleobj_.Invoke(*((1610743886, LCID, 4, 0) + (value,) + ()))
	def _set_CampbellDataType(self, value):
		if "CampbellDataType" in self.__dict__: self.__dict__["CampbellDataType"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))
	def _set_CampbellInputFile(self, value):
		if "CampbellInputFile" in self.__dict__: self.__dict__["CampbellInputFile"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_CampbellViewType(self, value):
		if "CampbellViewType" in self.__dict__: self.__dict__["CampbellViewType"] = value; return
		self._oleobj_.Invoke(*((1610743865, LCID, 4, 0) + (value,) + ()))
	def _set_CorrectionFactor(self, value):
		if "CorrectionFactor" in self.__dict__: self.__dict__["CorrectionFactor"] = value; return
		self._oleobj_.Invoke(*((1610743894, LCID, 4, 0) + (value,) + ()))
	def _set_DecibelReferenceValue(self, value):
		if "DecibelReferenceValue" in self.__dict__: self.__dict__["DecibelReferenceValue"] = value; return
		self._oleobj_.Invoke(*((1610743892, LCID, 4, 0) + (value,) + ()))
	def _set_DeltaTime(self, value):
		if "DeltaTime" in self.__dict__: self.__dict__["DeltaTime"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_Dt(self, value):
		if "Dt" in self.__dict__: self.__dict__["Dt"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_EndFrame(self, value):
		if "EndFrame" in self.__dict__: self.__dict__["EndFrame"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_FrameNumber(self, value):
		if "FrameNumber" in self.__dict__: self.__dict__["FrameNumber"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_FrameSize(self, value):
		if "FrameSize" in self.__dict__: self.__dict__["FrameSize"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_GraphOption(self, value):
		if "GraphOption" in self.__dict__: self.__dict__["GraphOption"] = value; return
		self._oleobj_.Invoke(*((1610743867, LCID, 4, 0) + (value,) + ()))
	def _set_InterpolationType(self, value):
		if "InterpolationType" in self.__dict__: self.__dict__["InterpolationType"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_IsOrderLineVisible(self, value):
		if "IsOrderLineVisible" in self.__dict__: self.__dict__["IsOrderLineVisible"] = value; return
		self._oleobj_.Invoke(*((1610743871, LCID, 4, 0) + (value,) + ()))
	def _set_IsSwapAxis(self, value):
		if "IsSwapAxis" in self.__dict__: self.__dict__["IsSwapAxis"] = value; return
		self._oleobj_.Invoke(*((1610743869, LCID, 4, 0) + (value,) + ()))
	def _set_MagnitudeType(self, value):
		if "MagnitudeType" in self.__dict__: self.__dict__["MagnitudeType"] = value; return
		self._oleobj_.Invoke(*((1610743863, LCID, 4, 0) + (value,) + ()))
	def _set_OrderLineGap(self, value):
		if "OrderLineGap" in self.__dict__: self.__dict__["OrderLineGap"] = value; return
		self._oleobj_.Invoke(*((1610743882, LCID, 4, 0) + (value,) + ()))
	def _set_OrderLineMaxOrder(self, value):
		if "OrderLineMaxOrder" in self.__dict__: self.__dict__["OrderLineMaxOrder"] = value; return
		self._oleobj_.Invoke(*((1610743878, LCID, 4, 0) + (value,) + ()))
	def _set_OrderLineMinOrder(self, value):
		if "OrderLineMinOrder" in self.__dict__: self.__dict__["OrderLineMinOrder"] = value; return
		self._oleobj_.Invoke(*((1610743880, LCID, 4, 0) + (value,) + ()))
	def _set_OrderLineThickness(self, value):
		if "OrderLineThickness" in self.__dict__: self.__dict__["OrderLineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743873, LCID, 4, 0) + (value,) + ()))
	def _set_OrderTextSize(self, value):
		if "OrderTextSize" in self.__dict__: self.__dict__["OrderTextSize"] = value; return
		self._oleobj_.Invoke(*((1610743876, LCID, 4, 0) + (value,) + ()))
	def _set_PulsePerRev(self, value):
		if "PulsePerRev" in self.__dict__: self.__dict__["PulsePerRev"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_RPMComputeType(self, value):
		if "RPMComputeType" in self.__dict__: self.__dict__["RPMComputeType"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Resolution(self, value):
		if "Resolution" in self.__dict__: self.__dict__["Resolution"] = value; return
		self._oleobj_.Invoke(*((1610743884, LCID, 4, 0) + (value,) + ()))
	def _set_SignalOffset(self, value):
		if "SignalOffset" in self.__dict__: self.__dict__["SignalOffset"] = value; return
		self._oleobj_.Invoke(*((1610743859, LCID, 4, 0) + (value,) + ()))
	def _set_StartFrame(self, value):
		if "StartFrame" in self.__dict__: self.__dict__["StartFrame"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_TachometerType(self, value):
		if "TachometerType" in self.__dict__: self.__dict__["TachometerType"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_UseDecibelPlot(self, value):
		if "UseDecibelPlot" in self.__dict__: self.__dict__["UseDecibelPlot"] = value; return
		self._oleobj_.Invoke(*((1610743888, LCID, 4, 0) + (value,) + ()))
	def _set_UseInputFile(self, value):
		if "UseInputFile" in self.__dict__: self.__dict__["UseInputFile"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))
	def _set_UseInterpolation(self, value):
		if "UseInterpolation" in self.__dict__: self.__dict__["UseInterpolation"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))
	def _set_UseRecommandedFrameSettings(self, value):
		if "UseRecommandedFrameSettings" in self.__dict__: self.__dict__["UseRecommandedFrameSettings"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_UseRecommandedTimeZone(self, value):
		if "UseRecommandedTimeZone" in self.__dict__: self.__dict__["UseRecommandedTimeZone"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_WindowType(self, value):
		if "WindowType" in self.__dict__: self.__dict__["WindowType"] = value; return
		self._oleobj_.Invoke(*((1610743861, LCID, 4, 0) + (value,) + ()))

	ApplyWindowCorrectionFactor = property(_get_ApplyWindowCorrectionFactor, _set_ApplyWindowCorrectionFactor)
	'''
	Gets or sets a value indicating whether the window correction factor is applied to the campbell diagram.

	:type: bool
	'''
	CalculateAllOrders = property(_get_CalculateAllOrders, _set_CalculateAllOrders)
	'''
	Gets or sets a value indicating whether the all orders are calculated.

	:type: bool
	'''
	CampbellDataType = property(_get_CampbellDataType, _set_CampbellDataType)
	'''
	Gets or sets the type of the campbell data.

	:type: recurdyn.Post.CampbellDataType
	'''
	CampbellInputFile = property(_get_CampbellInputFile, _set_CampbellInputFile)
	'''
	Gets or sets the path of campbell user-input file.

	:type: str
	'''
	CampbellViewType = property(_get_CampbellViewType, _set_CampbellViewType)
	'''
	Gets or sets the type of the campbell view.

	:type: recurdyn.Post.Chart3DViewType
	'''
	CorrectionFactor = property(_get_CorrectionFactor, _set_CorrectionFactor)
	'''
	Gets or sets the correction factor.

	:type: float
	'''
	DecibelReferenceValue = property(_get_DecibelReferenceValue, _set_DecibelReferenceValue)
	'''
	Gets or sets the decibel reference value.

	:type: float
	'''
	DeltaFrequency = property(_get_DeltaFrequency, None)
	'''
	Gets the delta frequency.

	:type: float
	'''
	DeltaTime = property(_get_DeltaTime, _set_DeltaTime)
	'''
	Gets or sets the delta time.

	:type: int
	'''
	Dt = property(_get_Dt, _set_Dt)
	'''
	Gets or sets the dt.

	:type: float
	'''
	EndFrame = property(_get_EndFrame, _set_EndFrame)
	'''
	Gets or sets the end frame.

	:type: int
	'''
	EndRPM = property(_get_EndRPM, None)
	'''
	Gets the end RPM.

	:type: float
	'''
	EndTime = property(_get_EndTime, None)
	'''
	Gets the end time.

	:type: float
	'''
	FrameLength = property(_get_FrameLength, None)
	'''
	Gets the length of the frame.

	:type: float
	'''
	FrameNumber = property(_get_FrameNumber, _set_FrameNumber)
	'''
	Gets or sets the frame number.

	:type: int
	'''
	FrameSize = property(_get_FrameSize, _set_FrameSize)
	'''
	Gets or sets the size of the frame.

	:type: int
	'''
	GraphOption = property(_get_GraphOption, _set_GraphOption)
	'''
	Gets or sets the graph option.

	:type: recurdyn.Post.Chart3DCampbellGraphType
	'''
	InterpolationType = property(_get_InterpolationType, _set_InterpolationType)
	'''
	Gets or sets the type of the interpolation.

	:type: recurdyn.Post.InterpolationType
	'''
	IsOrderLineVisible = property(_get_IsOrderLineVisible, _set_IsOrderLineVisible)
	'''
	Gets or sets a value indicating whether the campbell diagram show order lines.

	:type: bool
	'''
	IsSwapAxis = property(_get_IsSwapAxis, _set_IsSwapAxis)
	'''
	Gets or sets a value indicating whether the campbell diagram is swap axis (x-axis and z-axis).

	:type: bool
	'''
	MagnitudeType = property(_get_MagnitudeType, _set_MagnitudeType)
	'''
	Gets or sets the type of the magnitude.

	:type: recurdyn.Post.MagnitudeType
	'''
	MaxFrame = property(_get_MaxFrame, None)
	'''
	Gets the maximum frame.

	:type: int
	'''
	MaxFreq = property(_get_MaxFreq, None)
	'''
	Gets the maximum frequency.

	:type: float
	'''
	MaxOrder = property(_get_MaxOrder, None)
	'''
	Gets the maximum order.

	:type: int
	'''
	OrderLineColor = property(_get_OrderLineColor, None)
	'''
	Gets or sets the color of the order line.

	:type: recurdyn.Post.IColor
	'''
	OrderLineGap = property(_get_OrderLineGap, _set_OrderLineGap)
	'''
	Gets or sets the gap between order lines in the campbell diagram.

	:type: float
	'''
	OrderLineMaxOrder = property(_get_OrderLineMaxOrder, _set_OrderLineMaxOrder)
	'''
	Gets or sets the maximum order.

	:type: float
	'''
	OrderLineMinOrder = property(_get_OrderLineMinOrder, _set_OrderLineMinOrder)
	'''
	Gets or sets the minimum order.

	:type: float
	'''
	OrderLineThickness = property(_get_OrderLineThickness, _set_OrderLineThickness)
	'''
	Gets or sets the order line thickness.

	:type: float
	'''
	OrderTextSize = property(_get_OrderTextSize, _set_OrderTextSize)
	'''
	Gets or sets the font size of the order text.

	:type: float
	'''
	Overlap = property(_get_Overlap, None)
	'''
	Gets the overlap.

	:type: float
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	PulsePerRev = property(_get_PulsePerRev, _set_PulsePerRev)
	'''
	Gets or sets the pulse per rev.

	:type: float
	'''
	RPMComputeType = property(_get_RPMComputeType, _set_RPMComputeType)
	'''
	Gets or sets the type of the RPM compute.

	:type: recurdyn.Post.RPMComputeType
	'''
	ResidualNumber = property(_get_ResidualNumber, None)
	'''
	Gets the residual number.

	:type: int
	'''
	Resolution = property(_get_Resolution, _set_Resolution)
	'''
	Gets or sets the resolution of the campbell diagram.

	:type: int
	'''
	SamplingTime = property(_get_SamplingTime, None)
	'''
	Gets the sampling time.

	:type: float
	'''
	SignalComponent = property(_get_SignalComponent, None)
	'''
	Gets or sets the signal component.

	:type: recurdyn.Post.IDataComponent
	'''
	SignalOffset = property(_get_SignalOffset, _set_SignalOffset)
	'''
	Gets or sets the signal off.

	:type: recurdyn.Post.SignalOffset
	'''
	StartFrame = property(_get_StartFrame, _set_StartFrame)
	'''
	Gets or sets the start frame.

	:type: int
	'''
	StartRPM = property(_get_StartRPM, None)
	'''
	Gets the start RPM.

	:type: float
	'''
	StartTime = property(_get_StartTime, None)
	'''
	Gets the start time.

	:type: float
	'''
	TachoComponent = property(_get_TachoComponent, None)
	'''
	Gets or sets the tacho component.

	:type: recurdyn.Post.IDataComponent
	'''
	TachometerType = property(_get_TachometerType, _set_TachometerType)
	'''
	Gets or sets the type of the tachometer.

	:type: recurdyn.Post.TachometerType
	'''
	TimeComponent = property(_get_TimeComponent, None)
	'''
	Gets or sets the time component.

	:type: recurdyn.Post.IDataComponent
	'''
	TimeZoneEndTime = property(_get_TimeZoneEndTime, None)
	'''
	Gets the time zone end time.

	:type: float
	'''
	TimeZoneStartTime = property(_get_TimeZoneStartTime, None)
	'''
	Gets the time zone start time.

	:type: float
	'''
	UseDecibelPlot = property(_get_UseDecibelPlot, _set_UseDecibelPlot)
	'''
	Gets or sets a value indicating whether the decibel plot is used. 

	:type: bool
	'''
	UseInputFile = property(_get_UseInputFile, _set_UseInputFile)
	'''
	Gets or sets a value indicating whether the campbell data is user-input file.

	:type: bool
	'''
	UseInterpolation = property(_get_UseInterpolation, _set_UseInterpolation)
	'''
	Gets or sets a value indicating whether interpolation is used when the campbell data calulate.

	:type: bool
	'''
	UseRecommandedFrameSettings = property(_get_UseRecommandedFrameSettings, _set_UseRecommandedFrameSettings)
	'''
	Gets or sets a value indicating whether the recommanded frame settings is used.

	:type: bool
	'''
	UseRecommandedTimeZone = property(_get_UseRecommandedTimeZone, _set_UseRecommandedTimeZone)
	'''
	Gets or sets a value indicating whether recommanded time zone is used.

	:type: bool
	'''
	WindowType = property(_get_WindowType, _set_WindowType)
	'''
	Gets or sets the type of the window.

	:type: recurdyn.Post.WindowType
	'''

	_prop_map_set_function_ = {
		"_set_ApplyWindowCorrectionFactor": _set_ApplyWindowCorrectionFactor,
		"_set_CalculateAllOrders": _set_CalculateAllOrders,
		"_set_CampbellDataType": _set_CampbellDataType,
		"_set_CampbellInputFile": _set_CampbellInputFile,
		"_set_CampbellViewType": _set_CampbellViewType,
		"_set_CorrectionFactor": _set_CorrectionFactor,
		"_set_DecibelReferenceValue": _set_DecibelReferenceValue,
		"_set_DeltaTime": _set_DeltaTime,
		"_set_Dt": _set_Dt,
		"_set_EndFrame": _set_EndFrame,
		"_set_FrameNumber": _set_FrameNumber,
		"_set_FrameSize": _set_FrameSize,
		"_set_GraphOption": _set_GraphOption,
		"_set_InterpolationType": _set_InterpolationType,
		"_set_IsOrderLineVisible": _set_IsOrderLineVisible,
		"_set_IsSwapAxis": _set_IsSwapAxis,
		"_set_MagnitudeType": _set_MagnitudeType,
		"_set_OrderLineGap": _set_OrderLineGap,
		"_set_OrderLineMaxOrder": _set_OrderLineMaxOrder,
		"_set_OrderLineMinOrder": _set_OrderLineMinOrder,
		"_set_OrderLineThickness": _set_OrderLineThickness,
		"_set_OrderTextSize": _set_OrderTextSize,
		"_set_PulsePerRev": _set_PulsePerRev,
		"_set_RPMComputeType": _set_RPMComputeType,
		"_set_Resolution": _set_Resolution,
		"_set_SignalOffset": _set_SignalOffset,
		"_set_StartFrame": _set_StartFrame,
		"_set_TachometerType": _set_TachometerType,
		"_set_UseDecibelPlot": _set_UseDecibelPlot,
		"_set_UseInputFile": _set_UseInputFile,
		"_set_UseInterpolation": _set_UseInterpolation,
		"_set_UseRecommandedFrameSettings": _set_UseRecommandedFrameSettings,
		"_set_UseRecommandedTimeZone": _set_UseRecommandedTimeZone,
		"_set_WindowType": _set_WindowType,
	}
	_prop_map_get_ = {
		"ApplyWindowCorrectionFactor": (1610743890, 2, (11, 0), (), "ApplyWindowCorrectionFactor", None),
		"CalculateAllOrders": (1610743886, 2, (11, 0), (), "CalculateAllOrders", None),
		"CampbellDataType": (1610743841, 2, (3, 0), (), "CampbellDataType", '{4E55A9C7-3A08-36EA-A47C-B698A2D3B24D}'),
		"CampbellInputFile": (1610743812, 2, (8, 0), (), "CampbellInputFile", None),
		"CampbellViewType": (1610743865, 2, (3, 0), (), "CampbellViewType", '{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}'),
		"CorrectionFactor": (1610743894, 2, (5, 0), (), "CorrectionFactor", None),
		"DecibelReferenceValue": (1610743892, 2, (5, 0), (), "DecibelReferenceValue", None),
		"DeltaFrequency": (1610743858, 2, (5, 0), (), "DeltaFrequency", None),
		"DeltaTime": (1610743819, 2, (3, 0), (), "DeltaTime", None),
		"Dt": (1610743821, 2, (5, 0), (), "Dt", None),
		"EndFrame": (1610743827, 2, (3, 0), (), "EndFrame", None),
		"EndRPM": (1610743852, 2, (5, 0), (), "EndRPM", None),
		"EndTime": (1610743847, 2, (5, 0), (), "EndTime", None),
		"FrameLength": (1610743855, 2, (5, 0), (), "FrameLength", None),
		"FrameNumber": (1610743829, 2, (3, 0), (), "FrameNumber", None),
		"FrameSize": (1610743831, 2, (3, 0), (), "FrameSize", None),
		"GraphOption": (1610743867, 2, (3, 0), (), "GraphOption", '{CD553711-F6DF-3222-AB54-18337C5AA2E2}'),
		"InterpolationType": (1610743839, 2, (3, 0), (), "InterpolationType", '{A5E96348-2158-376F-ADCA-5AD7E7CEF0B0}'),
		"IsOrderLineVisible": (1610743871, 2, (11, 0), (), "IsOrderLineVisible", None),
		"IsSwapAxis": (1610743869, 2, (11, 0), (), "IsSwapAxis", None),
		"MagnitudeType": (1610743863, 2, (3, 0), (), "MagnitudeType", '{78862260-3599-342E-B22D-EE54946796F6}'),
		"MaxFrame": (1610743845, 2, (3, 0), (), "MaxFrame", None),
		"MaxFreq": (1610743853, 2, (5, 0), (), "MaxFreq", None),
		"MaxOrder": (1610743854, 2, (3, 0), (), "MaxOrder", None),
		"OrderLineColor": (1610743875, 2, (9, 0), (), "OrderLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"OrderLineGap": (1610743882, 2, (5, 0), (), "OrderLineGap", None),
		"OrderLineMaxOrder": (1610743878, 2, (5, 0), (), "OrderLineMaxOrder", None),
		"OrderLineMinOrder": (1610743880, 2, (5, 0), (), "OrderLineMinOrder", None),
		"OrderLineThickness": (1610743873, 2, (4, 0), (), "OrderLineThickness", None),
		"OrderTextSize": (1610743876, 2, (5, 0), (), "OrderTextSize", None),
		"Overlap": (1610743856, 2, (5, 0), (), "Overlap", None),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"PulsePerRev": (1610743833, 2, (5, 0), (), "PulsePerRev", None),
		"RPMComputeType": (1610743837, 2, (3, 0), (), "RPMComputeType", '{13B875A6-DEE2-3EC4-9DD2-1CE22CC66487}'),
		"ResidualNumber": (1610743857, 2, (3, 0), (), "ResidualNumber", None),
		"Resolution": (1610743884, 2, (3, 0), (), "Resolution", None),
		"SamplingTime": (1610743850, 2, (5, 0), (), "SamplingTime", None),
		"SignalComponent": (1610743816, 2, (9, 0), (), "SignalComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"SignalOffset": (1610743859, 2, (3, 0), (), "SignalOffset", '{15E07B49-D53C-34E5-AF1B-C596ACD9746F}'),
		"StartFrame": (1610743825, 2, (3, 0), (), "StartFrame", None),
		"StartRPM": (1610743851, 2, (5, 0), (), "StartRPM", None),
		"StartTime": (1610743846, 2, (5, 0), (), "StartTime", None),
		"TachoComponent": (1610743815, 2, (9, 0), (), "TachoComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"TachometerType": (1610743817, 2, (3, 0), (), "TachometerType", '{E183000B-6C78-38A9-884A-FC1C8A80DF74}'),
		"TimeComponent": (1610743814, 2, (9, 0), (), "TimeComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"TimeZoneEndTime": (1610743849, 2, (5, 0), (), "TimeZoneEndTime", None),
		"TimeZoneStartTime": (1610743848, 2, (5, 0), (), "TimeZoneStartTime", None),
		"UseDecibelPlot": (1610743888, 2, (11, 0), (), "UseDecibelPlot", None),
		"UseInputFile": (1610743810, 2, (11, 0), (), "UseInputFile", None),
		"UseInterpolation": (1610743835, 2, (11, 0), (), "UseInterpolation", None),
		"UseRecommandedFrameSettings": (1610743843, 2, (11, 0), (), "UseRecommandedFrameSettings", None),
		"UseRecommandedTimeZone": (1610743823, 2, (11, 0), (), "UseRecommandedTimeZone", None),
		"WindowType": (1610743861, 2, (3, 0), (), "WindowType", '{7E83733E-DCF7-36FA-98F1-BA37423D3E5E}'),
	}
	_prop_map_put_ = {
		"ApplyWindowCorrectionFactor": ((1610743890, LCID, 4, 0),()),
		"CalculateAllOrders": ((1610743886, LCID, 4, 0),()),
		"CampbellDataType": ((1610743841, LCID, 4, 0),()),
		"CampbellInputFile": ((1610743812, LCID, 4, 0),()),
		"CampbellViewType": ((1610743865, LCID, 4, 0),()),
		"CorrectionFactor": ((1610743894, LCID, 4, 0),()),
		"DecibelReferenceValue": ((1610743892, LCID, 4, 0),()),
		"DeltaTime": ((1610743819, LCID, 4, 0),()),
		"Dt": ((1610743821, LCID, 4, 0),()),
		"EndFrame": ((1610743827, LCID, 4, 0),()),
		"FrameNumber": ((1610743829, LCID, 4, 0),()),
		"FrameSize": ((1610743831, LCID, 4, 0),()),
		"GraphOption": ((1610743867, LCID, 4, 0),()),
		"InterpolationType": ((1610743839, LCID, 4, 0),()),
		"IsOrderLineVisible": ((1610743871, LCID, 4, 0),()),
		"IsSwapAxis": ((1610743869, LCID, 4, 0),()),
		"MagnitudeType": ((1610743863, LCID, 4, 0),()),
		"OrderLineGap": ((1610743882, LCID, 4, 0),()),
		"OrderLineMaxOrder": ((1610743878, LCID, 4, 0),()),
		"OrderLineMinOrder": ((1610743880, LCID, 4, 0),()),
		"OrderLineThickness": ((1610743873, LCID, 4, 0),()),
		"OrderTextSize": ((1610743876, LCID, 4, 0),()),
		"PulsePerRev": ((1610743833, LCID, 4, 0),()),
		"RPMComputeType": ((1610743837, LCID, 4, 0),()),
		"Resolution": ((1610743884, LCID, 4, 0),()),
		"SignalOffset": ((1610743859, LCID, 4, 0),()),
		"StartFrame": ((1610743825, LCID, 4, 0),()),
		"TachometerType": ((1610743817, LCID, 4, 0),()),
		"UseDecibelPlot": ((1610743888, LCID, 4, 0),()),
		"UseInputFile": ((1610743810, LCID, 4, 0),()),
		"UseInterpolation": ((1610743835, LCID, 4, 0),()),
		"UseRecommandedFrameSettings": ((1610743843, LCID, 4, 0),()),
		"UseRecommandedTimeZone": ((1610743823, LCID, 4, 0),()),
		"WindowType": ((1610743861, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart(DispatchBaseClass):
	'''Defines main interface of the the Chart.'''
	CLSID = IID('{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Delete(self, varEntity):
		'''
		Deletes the object from the Chart.
		
		:param varEntity: IChartBase
		'''
		return self._oleobj_.InvokeTypes(1610743832, LCID, 1, (24, 0), ((9, 1),),varEntity
			)


	def ExportSeriesData(self, strFilepath, bIncludeHeader, iNumberOfSignificantDigit, bUseScientificNotation, arrChartSeries):
		'''
		Exports series data to file.
		
		:param strFilepath: str
		:param bIncludeHeader: bool
		:param iNumberOfSignificantDigit: int
		:param bUseScientificNotation: bool
		:param arrChartSeries: list[object]
		'''
		_arrChartSeries_type = True if arrChartSeries and isinstance(arrChartSeries[0], win32com.client.VARIANT) else False
		if not _arrChartSeries_type:
			arrChartSeries = [win32com.client.VARIANT(12, _data) for _data in arrChartSeries]

		ret = self._oleobj_.InvokeTypes(1610743834, LCID, 1, (24, 0), ((8, 1), (11, 1), (3, 1), (11, 1), (8204, 1)),strFilepath
			, bIncludeHeader, iNumberOfSignificantDigit, bUseScientificNotation, arrChartSeries)

		if not _arrChartSeries_type:
			arrChartSeries = [_data.value for _data in arrChartSeries]

		return ret


	def ExportToImageFile(self, strFilepath, enImageformat):
		'''
		Exports the Chart to image file.
		
		:param strFilepath: str
		:param enImageformat: ExportImageType
		'''
		return self._oleobj_.InvokeTypes(1610743833, LCID, 1, (24, 0), ((8, 1), (3, 1)),strFilepath
			, enImageformat)


	def Fit(self, enDirection):
		'''
		Zooms the Chart to the extents of the series data with the specific direction.
		
		:param enDirection: XyDirection
		'''
		return self._oleobj_.InvokeTypes(1610743831, LCID, 1, (24, 0), ((3, 1),),enDirection
			)


	def _get_AnnotationCollection(self):
		return self._ApplyTypes_(*(1610743821, 2, (9, 0), (), "AnnotationCollection", '{B89390C5-E030-404E-9B93-B9B2EB12D6A2}'))
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_ChartPalette(self):
		return self._ApplyTypes_(*(1610743828, 2, (9, 0), (), "ChartPalette", '{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_GridLinePanelStyle(self):
		return self._ApplyTypes_(*(1610743827, 2, (9, 0), (), "GridLinePanelStyle", '{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_ModifierLegend(self):
		return self._ApplyTypes_(*(1610743822, 2, (9, 0), (), "ModifierLegend", '{D6153141-938E-4E8A-B6E2-ED8EFE62E091}'))
	def _get_ModifierSeriesInfo(self):
		return self._ApplyTypes_(*(1610743825, 2, (9, 0), (), "ModifierSeriesInfo", '{C79751D8-4907-4B9E-8169-311B17858169}'))
	def _get_ModifierTimeLine(self):
		return self._ApplyTypes_(*(1610743824, 2, (9, 0), (), "ModifierTimeLine", '{7440FFE1-9009-44ED-90D1-6B7A9143AB66}'))
	def _get_ModifierTooltip(self):
		return self._ApplyTypes_(*(1610743823, 2, (9, 0), (), "ModifierTooltip", '{FD63AE8C-75EF-437B-AB41-0654C94D7F03}'))
	def _get_MouseDragAction(self):
		return self._ApplyTypes_(*(1610743816, 2, (3, 0), (), "MouseDragAction", '{F840B6EE-855A-39DB-A57E-C31F3633F549}'))
	def _get_MultipleAxisDrawOption(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "MultipleAxisDrawOption", '{C038E096-9B57-3022-9044-B201C0B61CF7}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Padding(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Padding", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'))
	def _get_SeriesCollection(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_TitleStyle(self):
		return self._ApplyTypes_(*(1610743826, 2, (9, 0), (), "TitleStyle", '{F779994A-D846-4F12-AE53-DD023F6973B9}'))
	def _get_XAxisCollection(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "XAxisCollection", '{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}'))
	def _get_YAxisCollection(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "YAxisCollection", '{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}'))

	def _set_MouseDragAction(self, value):
		if "MouseDragAction" in self.__dict__: self.__dict__["MouseDragAction"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_MultipleAxisDrawOption(self, value):
		if "MultipleAxisDrawOption" in self.__dict__: self.__dict__["MultipleAxisDrawOption"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))

	AnnotationCollection = property(_get_AnnotationCollection, None)
	'''
	Gets the collection of annotations.

	:type: recurdyn.Post.IChartAnnotationCollection
	'''
	Background = property(_get_Background, None)
	'''
	Gets or sets a brush that describes the background of the Chart.

	:type: recurdyn.Post.IColor
	'''
	ChartPalette = property(_get_ChartPalette, None)
	'''
	Gets ChartPalette of the Chart. The ChartPalette provides color set when series is drawn.

	:type: recurdyn.Post.IChartPalette
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	GridLinePanelStyle = property(_get_GridLinePanelStyle, None)
	'''
	Gets ChartStyleGridLinePanel of the Chart. The ChartStyleGridLinePanel provides properties of grid line panel style.

	:type: recurdyn.Post.IChartStyleGridLinePanel
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	ModifierLegend = property(_get_ModifierLegend, None)
	'''
	Gets the ChartModifierLegend of the Chart. The ChartModifierLegend provides behaviour of the Chart series legend.

	:type: recurdyn.Post.IChartModifierLegend
	'''
	ModifierSeriesInfo = property(_get_ModifierSeriesInfo, None)
	'''
	Gets ChartModifierSeriesInfo of the Chart. The ChartModifierSeriesInfo provides behavior of information about the selected series.

	:type: recurdyn.Post.IChartModifierSeriesInfo
	'''
	ModifierTimeLine = property(_get_ModifierTimeLine, None)
	'''
	Gets ChartModifierTimeLine of the Chart. The ChartModifierTimeLine provides behavior of timeline annotation on the Chart.

	:type: recurdyn.Post.IChartModifierTimeLine
	'''
	ModifierTooltip = property(_get_ModifierTooltip, None)
	'''
	Gets ChartModifierTooltipEx of the Chart. The ChartModifierTooltipEx provides behavior of the advanced Tooltip when the mouse rollover.

	:type: recurdyn.Post.IChartModifierTooltip
	'''
	MouseDragAction = property(_get_MouseDragAction, _set_MouseDragAction)
	'''
	Gets or sets a value that mouse drag action on the Chart.

	:type: recurdyn.Post.MouseDragAction
	'''
	MultipleAxisDrawOption = property(_get_MultipleAxisDrawOption, _set_MultipleAxisDrawOption)
	'''
	Gets or sets the value of MultipleAxisDrawOption. Determine the axis creation behavior when drawing a series.

	:type: recurdyn.Post.MultipleAxisDrawOption
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Padding = property(_get_Padding, None)
	'''
	Gets or sets the padding inside the Chart.

	:type: recurdyn.Post.IThickness
	'''
	SeriesCollection = property(_get_SeriesCollection, None)
	'''
	Gets the collection of Series.

	:type: recurdyn.Post.ISeriesCollection
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the name of the title. The title will be displayed on top of the Chart view.

	:type: str
	'''
	TitleStyle = property(_get_TitleStyle, None)
	'''
	Gets ChartStyleChartTitle of the Chart. The ChartStyleChartTitle provides properties of title style (Font, Color ...).

	:type: recurdyn.Post.IChartStyleTitle
	'''
	XAxisCollection = property(_get_XAxisCollection, None)
	'''
	Gets the collection of X-Axis.

	:type: recurdyn.Post.IAxisXCollection
	'''
	YAxisCollection = property(_get_YAxisCollection, None)
	'''
	Gets the collection of Y-Axis.

	:type: recurdyn.Post.IAxisYCollection
	'''

	_prop_map_set_function_ = {
		"_set_MouseDragAction": _set_MouseDragAction,
		"_set_MultipleAxisDrawOption": _set_MultipleAxisDrawOption,
		"_set_Name": _set_Name,
		"_set_Title": _set_Title,
	}
	_prop_map_get_ = {
		"AnnotationCollection": (1610743821, 2, (9, 0), (), "AnnotationCollection", '{B89390C5-E030-404E-9B93-B9B2EB12D6A2}'),
		"Background": (1610743815, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"ChartPalette": (1610743828, 2, (9, 0), (), "ChartPalette", '{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"GridLinePanelStyle": (1610743827, 2, (9, 0), (), "GridLinePanelStyle", '{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"ModifierLegend": (1610743822, 2, (9, 0), (), "ModifierLegend", '{D6153141-938E-4E8A-B6E2-ED8EFE62E091}'),
		"ModifierSeriesInfo": (1610743825, 2, (9, 0), (), "ModifierSeriesInfo", '{C79751D8-4907-4B9E-8169-311B17858169}'),
		"ModifierTimeLine": (1610743824, 2, (9, 0), (), "ModifierTimeLine", '{7440FFE1-9009-44ED-90D1-6B7A9143AB66}'),
		"ModifierTooltip": (1610743823, 2, (9, 0), (), "ModifierTooltip", '{FD63AE8C-75EF-437B-AB41-0654C94D7F03}'),
		"MouseDragAction": (1610743816, 2, (3, 0), (), "MouseDragAction", '{F840B6EE-855A-39DB-A57E-C31F3633F549}'),
		"MultipleAxisDrawOption": (1610743829, 2, (3, 0), (), "MultipleAxisDrawOption", '{C038E096-9B57-3022-9044-B201C0B61CF7}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Padding": (1610743814, 2, (9, 0), (), "Padding", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'),
		"SeriesCollection": (1610743820, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"TitleStyle": (1610743826, 2, (9, 0), (), "TitleStyle", '{F779994A-D846-4F12-AE53-DD023F6973B9}'),
		"XAxisCollection": (1610743818, 2, (9, 0), (), "XAxisCollection", '{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}'),
		"YAxisCollection": (1610743819, 2, (9, 0), (), "YAxisCollection", '{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}'),
	}
	_prop_map_put_ = {
		"MouseDragAction": ((1610743816, LCID, 4, 0),()),
		"MultipleAxisDrawOption": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3D(DispatchBaseClass):
	'''Defines main interface of the Chart3D.'''
	CLSID = IID('{919C04CC-90E5-409E-85F3-3256F29E6247}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Delete(self, varEntity):
		'''
		Deletes the object from the Chart3D. If the DataSeriesType is campbelldata, the series cannot be deleted.
		
		:param varEntity: IChartSeries3D
		'''
		return self._oleobj_.InvokeTypes(1610743842, LCID, 1, (24, 0), ((9, 1),),varEntity
			)


	def Fit(self):
		'''
		Zooms the Chart3D to the extents of the series data and camera fit.
		'''
		return self._oleobj_.InvokeTypes(1610743843, LCID, 1, (24, 0), (),)


	def Redraw(self):
		'''
		Redraws the all objects of the Chart3D. Use this function If the Chart3D is not visible or updated.
		'''
		return self._oleobj_.InvokeTypes(1610743844, LCID, 1, (24, 0), (),)


	def _get_AdditionalViewerType(self):
		return self._ApplyTypes_(*(1610743820, 2, (3, 0), (), "AdditionalViewerType", '{12D5CC46-4F73-34E2-8064-B2EDF9EC8602}'))
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_CampbellProperty(self):
		return self._ApplyTypes_(*(1610743835, 2, (9, 0), (), "CampbellProperty", '{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}'))
	def _get_ChartPalette(self):
		return self._ApplyTypes_(*(1610743841, 2, (9, 0), (), "ChartPalette", '{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}'))
	def _get_ContourLegend(self):
		return self._ApplyTypes_(*(1610743837, 2, (9, 0), (), "ContourLegend", '{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}'))
	def _get_CoordinateSystem(self):
		return self._ApplyTypes_(*(1610743822, 2, (3, 0), (), "CoordinateSystem", '{BDA5F1CC-EB77-3913-B364-5BCA4E43E35E}'))
	def _get_DataSeriesType(self):
		return self._ApplyTypes_(*(1610743819, 2, (3, 0), (), "DataSeriesType", '{25C31D8F-41CE-3251-B056-7A3E9C28F8E6}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsXyzGizmoVisible(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsXyzGizmoVisible", None))
	def _get_Modifier3DLegend(self):
		return self._ApplyTypes_(*(1610743836, 2, (9, 0), (), "Modifier3DLegend", '{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}'))
	def _get_Modifier3DSectionViewer(self):
		return self._ApplyTypes_(*(1610743839, 2, (9, 0), (), "Modifier3DSectionViewer", '{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}'))
	def _get_Modifier3DTooltip(self):
		return self._ApplyTypes_(*(1610743838, 2, (9, 0), (), "Modifier3DTooltip", '{61409795-1BB1-4C04-B851-10B44F02F5A5}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_SeriesCollection(self):
		return self._ApplyTypes_(*(1610743833, 2, (9, 0), (), "SeriesCollection", '{8EE0A50B-A095-4196-B3A2-189A36105476}'))
	def _get_SliceViewer(self):
		return self._ApplyTypes_(*(1610743840, 2, (9, 0), (), "SliceViewer", '{279362D2-44D2-4A28-A600-D889E108D5D8}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_TitleStyle(self):
		return self._ApplyTypes_(*(1610743834, 2, (9, 0), (), "TitleStyle", '{BB3F7878-1B92-4B36-B688-31107524DB25}'))
	def _get_ViewType(self):
		return self._ApplyTypes_(*(1610743817, 2, (3, 0), (), "ViewType", '{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}'))
	def _get_XAxis3D(self):
		return self._ApplyTypes_(*(1610743830, 2, (9, 0), (), "XAxis3D", '{726C8F68-8A81-4F1F-8D5E-3249898D875B}'))
	def _get_XyPlaneDrawLabelsMode(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "XyPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'))
	def _get_YAxis3D(self):
		return self._ApplyTypes_(*(1610743831, 2, (9, 0), (), "YAxis3D", '{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}'))
	def _get_ZAxis3D(self):
		return self._ApplyTypes_(*(1610743832, 2, (9, 0), (), "ZAxis3D", '{45B05150-78E3-4188-AA31-CC0DE518FF1F}'))
	def _get_ZxPlaneDrawLabelsMode(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "ZxPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'))
	def _get_ZyPlaneDrawLabelsMode(self):
		return self._ApplyTypes_(*(1610743826, 2, (3, 0), (), "ZyPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'))

	def _set_AdditionalViewerType(self, value):
		if "AdditionalViewerType" in self.__dict__: self.__dict__["AdditionalViewerType"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_CoordinateSystem(self, value):
		if "CoordinateSystem" in self.__dict__: self.__dict__["CoordinateSystem"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_IsXyzGizmoVisible(self, value):
		if "IsXyzGizmoVisible" in self.__dict__: self.__dict__["IsXyzGizmoVisible"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_ViewType(self, value):
		if "ViewType" in self.__dict__: self.__dict__["ViewType"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_XyPlaneDrawLabelsMode(self, value):
		if "XyPlaneDrawLabelsMode" in self.__dict__: self.__dict__["XyPlaneDrawLabelsMode"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_ZxPlaneDrawLabelsMode(self, value):
		if "ZxPlaneDrawLabelsMode" in self.__dict__: self.__dict__["ZxPlaneDrawLabelsMode"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_ZyPlaneDrawLabelsMode(self, value):
		if "ZyPlaneDrawLabelsMode" in self.__dict__: self.__dict__["ZyPlaneDrawLabelsMode"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))

	AdditionalViewerType = property(_get_AdditionalViewerType, _set_AdditionalViewerType)
	'''
	Gets or sets the additional viewer type.

	:type: recurdyn.Post.AdditionalViewerType
	'''
	Background = property(_get_Background, None)
	'''
	Gets or sets a brush that describes the background of the Chart3D.

	:type: recurdyn.Post.IColor
	'''
	CampbellProperty = property(_get_CampbellProperty, None)
	'''
	Gets Chart3DCampbellProperty that indicates the properties if the Chart3D data series is the campbelldata.

	:type: recurdyn.Post.IChart3DCampbellProperty
	'''
	ChartPalette = property(_get_ChartPalette, None)
	'''
	Gets ChartPalette of the Chart3D. The ChartPalette provides color set when series is drawn.

	:type: recurdyn.Post.IChartPalette
	'''
	ContourLegend = property(_get_ContourLegend, None)
	'''
	Gets Chart3DContourLegend of the Chart3D.

	:type: recurdyn.Post.IChart3DContourLegend
	'''
	CoordinateSystem = property(_get_CoordinateSystem, _set_CoordinateSystem)
	'''
	Gets or sets the coordinate system of the Chart3D.

	:type: recurdyn.Post.CoordinateSystem3D
	'''
	DataSeriesType = property(_get_DataSeriesType, None)
	'''
	Gets the type of the data series which is used in the Chart3D.

	:type: recurdyn.Post.Chart3DDataSeriesType
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsXyzGizmoVisible = property(_get_IsXyzGizmoVisible, _set_IsXyzGizmoVisible)
	'''
	Gets or sets a value indicating whether the XyzGizmo is visible.

	:type: bool
	'''
	Modifier3DLegend = property(_get_Modifier3DLegend, None)
	'''
	Gets ChartModifier3DLegend of the Chart3D. The ChartModifier3DLegend provides behaviour of the Chart3D series legend.

	:type: recurdyn.Post.IChartModifier3DLegend
	'''
	Modifier3DSectionViewer = property(_get_Modifier3DSectionViewer, None)
	'''
	Gets ChartModifier3DSectionViewer of the Chart3D. The ChartModifier3DSectionViewer provides additional charts that indicates section viewer if the Chart3D data series is the campbelldata.

	:type: recurdyn.Post.IChartModifier3DSectionViewer
	'''
	Modifier3DTooltip = property(_get_Modifier3DTooltip, None)
	'''
	Gets ChartModifier3DTooltip of the Chart3D. The ChartModifier3DTooltip provides the tooltip (series data information) at mouse position when mouse moving.

	:type: recurdyn.Post.IChartModifier3DTooltip
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	SeriesCollection = property(_get_SeriesCollection, None)
	'''
	Gets the collection of the series.

	:type: recurdyn.Post.ISeries3DCollection
	'''
	SliceViewer = property(_get_SliceViewer, None)
	'''
	Gets Chart3DSliceViewer of the Chart3D. The Chart3DSliceViewer provides additional charts that display for data slice.

	:type: recurdyn.Post.IChart3DSliceViewer
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the name of the title. The title will be displayed on top of the Chart3D.

	:type: str
	'''
	TitleStyle = property(_get_TitleStyle, None)
	'''
	Gets Chart3DStyleTitle of the Chart3D. The Chart3DStyleTitle provides properties of title style (Font, Color ...).

	:type: recurdyn.Post.IChart3DStyleTitle
	'''
	ViewType = property(_get_ViewType, _set_ViewType)
	'''
	Gets or sets the type of the Chart3D view. Determine the Chart3D view type is normal or orthogonal about y-axis.

	:type: recurdyn.Post.Chart3DViewType
	'''
	XAxis3D = property(_get_XAxis3D, None)
	'''
	Gets the X-Axis 3D.

	:type: recurdyn.Post.IChartAxisX3D
	'''
	XyPlaneDrawLabelsMode = property(_get_XyPlaneDrawLabelsMode, _set_XyPlaneDrawLabelsMode)
	'''
	Gets or sets the XY plane draw labels mode.

	:type: recurdyn.Post.AxisPlaneDrawLabelsMode
	'''
	YAxis3D = property(_get_YAxis3D, None)
	'''
	Gets the Y-Axis 3D.

	:type: recurdyn.Post.IChartAxisY3D
	'''
	ZAxis3D = property(_get_ZAxis3D, None)
	'''
	Gets the Z-Axis 3D.

	:type: recurdyn.Post.IChartAxisZ3D
	'''
	ZxPlaneDrawLabelsMode = property(_get_ZxPlaneDrawLabelsMode, _set_ZxPlaneDrawLabelsMode)
	'''
	Gets or sets the ZX plane draw labels mode.

	:type: recurdyn.Post.AxisPlaneDrawLabelsMode
	'''
	ZyPlaneDrawLabelsMode = property(_get_ZyPlaneDrawLabelsMode, _set_ZyPlaneDrawLabelsMode)
	'''
	Gets or sets the ZY plane draw labels mode.

	:type: recurdyn.Post.AxisPlaneDrawLabelsMode
	'''

	_prop_map_set_function_ = {
		"_set_AdditionalViewerType": _set_AdditionalViewerType,
		"_set_CoordinateSystem": _set_CoordinateSystem,
		"_set_IsXyzGizmoVisible": _set_IsXyzGizmoVisible,
		"_set_Name": _set_Name,
		"_set_Title": _set_Title,
		"_set_ViewType": _set_ViewType,
		"_set_XyPlaneDrawLabelsMode": _set_XyPlaneDrawLabelsMode,
		"_set_ZxPlaneDrawLabelsMode": _set_ZxPlaneDrawLabelsMode,
		"_set_ZyPlaneDrawLabelsMode": _set_ZyPlaneDrawLabelsMode,
	}
	_prop_map_get_ = {
		"AdditionalViewerType": (1610743820, 2, (3, 0), (), "AdditionalViewerType", '{12D5CC46-4F73-34E2-8064-B2EDF9EC8602}'),
		"Background": (1610743814, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"CampbellProperty": (1610743835, 2, (9, 0), (), "CampbellProperty", '{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}'),
		"ChartPalette": (1610743841, 2, (9, 0), (), "ChartPalette", '{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}'),
		"ContourLegend": (1610743837, 2, (9, 0), (), "ContourLegend", '{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}'),
		"CoordinateSystem": (1610743822, 2, (3, 0), (), "CoordinateSystem", '{BDA5F1CC-EB77-3913-B364-5BCA4E43E35E}'),
		"DataSeriesType": (1610743819, 2, (3, 0), (), "DataSeriesType", '{25C31D8F-41CE-3251-B056-7A3E9C28F8E6}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsXyzGizmoVisible": (1610743815, 2, (11, 0), (), "IsXyzGizmoVisible", None),
		"Modifier3DLegend": (1610743836, 2, (9, 0), (), "Modifier3DLegend", '{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}'),
		"Modifier3DSectionViewer": (1610743839, 2, (9, 0), (), "Modifier3DSectionViewer", '{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}'),
		"Modifier3DTooltip": (1610743838, 2, (9, 0), (), "Modifier3DTooltip", '{61409795-1BB1-4C04-B851-10B44F02F5A5}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"SeriesCollection": (1610743833, 2, (9, 0), (), "SeriesCollection", '{8EE0A50B-A095-4196-B3A2-189A36105476}'),
		"SliceViewer": (1610743840, 2, (9, 0), (), "SliceViewer", '{279362D2-44D2-4A28-A600-D889E108D5D8}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"TitleStyle": (1610743834, 2, (9, 0), (), "TitleStyle", '{BB3F7878-1B92-4B36-B688-31107524DB25}'),
		"ViewType": (1610743817, 2, (3, 0), (), "ViewType", '{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}'),
		"XAxis3D": (1610743830, 2, (9, 0), (), "XAxis3D", '{726C8F68-8A81-4F1F-8D5E-3249898D875B}'),
		"XyPlaneDrawLabelsMode": (1610743824, 2, (3, 0), (), "XyPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'),
		"YAxis3D": (1610743831, 2, (9, 0), (), "YAxis3D", '{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}'),
		"ZAxis3D": (1610743832, 2, (9, 0), (), "ZAxis3D", '{45B05150-78E3-4188-AA31-CC0DE518FF1F}'),
		"ZxPlaneDrawLabelsMode": (1610743828, 2, (3, 0), (), "ZxPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'),
		"ZyPlaneDrawLabelsMode": (1610743826, 2, (3, 0), (), "ZyPlaneDrawLabelsMode", '{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}'),
	}
	_prop_map_put_ = {
		"AdditionalViewerType": ((1610743820, LCID, 4, 0),()),
		"CoordinateSystem": ((1610743822, LCID, 4, 0),()),
		"IsXyzGizmoVisible": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
		"ViewType": ((1610743817, LCID, 4, 0),()),
		"XyPlaneDrawLabelsMode": ((1610743824, LCID, 4, 0),()),
		"ZxPlaneDrawLabelsMode": ((1610743828, LCID, 4, 0),()),
		"ZyPlaneDrawLabelsMode": ((1610743826, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DCampbellProperty(DispatchBaseClass):
	'''Defines interface of the Chart3DCampbellProperty.'''
	CLSID = IID('{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def RefreshOrderLines(self):
		'''
		Refreshes the order line annotations.
		'''
		return self._oleobj_.InvokeTypes(1610743856, LCID, 1, (24, 0), (),)


	def UpdateCampbellGraph(self):
		'''
		Updates the campbell graph. If the properties (Resolution, Gap...) are changed, this update function should be used.
		'''
		return self._oleobj_.InvokeTypes(1610743855, LCID, 1, (24, 0), (),)


	def _get_ApplyWindowCorrectionFactor(self):
		return self._ApplyTypes_(*(1610743849, 2, (11, 0), (), "ApplyWindowCorrectionFactor", None))
	def _get_CampbellInputFile(self):
		return self._ApplyTypes_(*(1610743813, 2, (8, 0), (), "CampbellInputFile", None))
	def _get_CorrectionFactor(self):
		return self._ApplyTypes_(*(1610743853, 2, (5, 0), (), "CorrectionFactor", None))
	def _get_DecibelReferenceValue(self):
		return self._ApplyTypes_(*(1610743851, 2, (5, 0), (), "DecibelReferenceValue", None))
	def _get_FrequencyData(self):
		return self._ApplyTypes_(*(1610743818, 2, (8197, 0), (), "FrequencyData", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_Gap(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "Gap", None))
	def _get_GraphOption(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "GraphOption", '{CD553711-F6DF-3222-AB54-18337C5AA2E2}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsOrderLineVisible(self):
		return self._ApplyTypes_(*(1610743838, 2, (11, 0), (), "IsOrderLineVisible", None))
	def _get_IsSwapAxis(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "IsSwapAxis", None))
	def _get_MaximumOrder(self):
		return self._ApplyTypes_(*(1610743834, 2, (5, 0), (), "MaximumOrder", None))
	def _get_MinimumOrder(self):
		return self._ApplyTypes_(*(1610743832, 2, (5, 0), (), "MinimumOrder", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_OrderData(self):
		return self._ApplyTypes_(*(1610743819, 2, (8197, 0), (), "OrderData", None))
	def _get_OrderLineColor(self):
		return self._ApplyTypes_(*(1610743844, 2, (9, 0), (), "OrderLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_OrderLineThickness(self):
		return self._ApplyTypes_(*(1610743842, 2, (4, 0), (), "OrderLineThickness", None))
	def _get_OrderTextSize(self):
		return self._ApplyTypes_(*(1610743845, 2, (5, 0), (), "OrderTextSize", None))
	def _get_PhaseData(self):
		return self._ApplyTypes_(*(1610743820, 2, (8197, 0), (), "PhaseData", None))
	def _get_RPMData(self):
		return self._ApplyTypes_(*(1610743817, 2, (8197, 0), (), "RPMData", None))
	def _get_RPMFrequencyData(self):
		return self._ApplyTypes_(*(1610743821, 2, (8197, 0), (), "RPMFrequencyData", None))
	def _get_RPMFrequencyPhaseData(self):
		return self._ApplyTypes_(*(1610743822, 2, (8197, 0), (), "RPMFrequencyPhaseData", None))
	def _get_RPMOrderPhaseData(self):
		return self._ApplyTypes_(*(1610743823, 2, (8197, 0), (), "RPMOrderPhaseData", None))
	def _get_Resolution(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "Resolution", None))
	def _get_ShowOrderNumber(self):
		return self._ApplyTypes_(*(1610743840, 2, (3, 0), (), "ShowOrderNumber", '{409874E3-739A-3E60-9D74-CF6DEF3CF0A7}'))
	def _get_SignalComponent(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "SignalComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_SurfaceMesh2DContourType(self):
		return self._ApplyTypes_(*(1610743836, 2, (3, 0), (), "SurfaceMesh2DContourType", '{1F838B39-95C4-3252-87A9-BF2486461400}'))
	def _get_TachoComponent(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "TachoComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_TimeComponent(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "TimeComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_UseDecibelPlot(self):
		return self._ApplyTypes_(*(1610743847, 2, (11, 0), (), "UseDecibelPlot", None))
	def _get_UseInputFile(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "UseInputFile", None))

	def _set_ApplyWindowCorrectionFactor(self, value):
		if "ApplyWindowCorrectionFactor" in self.__dict__: self.__dict__["ApplyWindowCorrectionFactor"] = value; return
		self._oleobj_.Invoke(*((1610743849, LCID, 4, 0) + (value,) + ()))
	def _set_CorrectionFactor(self, value):
		if "CorrectionFactor" in self.__dict__: self.__dict__["CorrectionFactor"] = value; return
		self._oleobj_.Invoke(*((1610743853, LCID, 4, 0) + (value,) + ()))
	def _set_DecibelReferenceValue(self, value):
		if "DecibelReferenceValue" in self.__dict__: self.__dict__["DecibelReferenceValue"] = value; return
		self._oleobj_.Invoke(*((1610743851, LCID, 4, 0) + (value,) + ()))
	def _set_Gap(self, value):
		if "Gap" in self.__dict__: self.__dict__["Gap"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_GraphOption(self, value):
		if "GraphOption" in self.__dict__: self.__dict__["GraphOption"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_IsOrderLineVisible(self, value):
		if "IsOrderLineVisible" in self.__dict__: self.__dict__["IsOrderLineVisible"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_IsSwapAxis(self, value):
		if "IsSwapAxis" in self.__dict__: self.__dict__["IsSwapAxis"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_MaximumOrder(self, value):
		if "MaximumOrder" in self.__dict__: self.__dict__["MaximumOrder"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_MinimumOrder(self, value):
		if "MinimumOrder" in self.__dict__: self.__dict__["MinimumOrder"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_OrderLineThickness(self, value):
		if "OrderLineThickness" in self.__dict__: self.__dict__["OrderLineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743842, LCID, 4, 0) + (value,) + ()))
	def _set_OrderTextSize(self, value):
		if "OrderTextSize" in self.__dict__: self.__dict__["OrderTextSize"] = value; return
		self._oleobj_.Invoke(*((1610743845, LCID, 4, 0) + (value,) + ()))
	def _set_Resolution(self, value):
		if "Resolution" in self.__dict__: self.__dict__["Resolution"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_ShowOrderNumber(self, value):
		if "ShowOrderNumber" in self.__dict__: self.__dict__["ShowOrderNumber"] = value; return
		self._oleobj_.Invoke(*((1610743840, LCID, 4, 0) + (value,) + ()))
	def _set_SurfaceMesh2DContourType(self, value):
		if "SurfaceMesh2DContourType" in self.__dict__: self.__dict__["SurfaceMesh2DContourType"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_UseDecibelPlot(self, value):
		if "UseDecibelPlot" in self.__dict__: self.__dict__["UseDecibelPlot"] = value; return
		self._oleobj_.Invoke(*((1610743847, LCID, 4, 0) + (value,) + ()))

	ApplyWindowCorrectionFactor = property(_get_ApplyWindowCorrectionFactor, _set_ApplyWindowCorrectionFactor)
	'''
	Gets or sets a value indicating whether the window correction factor is applied to the campbell diagram.

	:type: bool
	'''
	CampbellInputFile = property(_get_CampbellInputFile, None)
	'''
	Gets the path of campbell user-input file.

	:type: str
	'''
	CorrectionFactor = property(_get_CorrectionFactor, _set_CorrectionFactor)
	'''
	Gets or sets the correction factor.

	:type: float
	'''
	DecibelReferenceValue = property(_get_DecibelReferenceValue, _set_DecibelReferenceValue)
	'''
	Gets or sets the decibel reference value.

	:type: float
	'''
	FrequencyData = property(_get_FrequencyData, None)
	'''
	Gets the frequency data.

	:type: list[float]
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	Gap = property(_get_Gap, _set_Gap)
	'''
	Gets or sets the gap between order lines in the campbell diagram.

	:type: float
	'''
	GraphOption = property(_get_GraphOption, _set_GraphOption)
	'''
	Gets or sets the graph option.

	:type: recurdyn.Post.Chart3DCampbellGraphType
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsOrderLineVisible = property(_get_IsOrderLineVisible, _set_IsOrderLineVisible)
	'''
	Gets or sets a value indicating whether the campbell diagram show order lines.

	:type: bool
	'''
	IsSwapAxis = property(_get_IsSwapAxis, _set_IsSwapAxis)
	'''
	Gets or sets a value indicating whether the campbell diagram is swap axis (x-axis and z-axis).

	:type: bool
	'''
	MaximumOrder = property(_get_MaximumOrder, _set_MaximumOrder)
	'''
	Gets or sets the maximum order.

	:type: float
	'''
	MinimumOrder = property(_get_MinimumOrder, _set_MinimumOrder)
	'''
	Gets or sets the minimum order.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	OrderData = property(_get_OrderData, None)
	'''
	Gets the order data.

	:type: list[float]
	'''
	OrderLineColor = property(_get_OrderLineColor, None)
	'''
	Gets or sets the color of the order line.

	:type: recurdyn.Post.IColor
	'''
	OrderLineThickness = property(_get_OrderLineThickness, _set_OrderLineThickness)
	'''
	Gets or sets the order line thickness.

	:type: float
	'''
	OrderTextSize = property(_get_OrderTextSize, _set_OrderTextSize)
	'''
	Gets or sets the font size of the order text.

	:type: float
	'''
	PhaseData = property(_get_PhaseData, None)
	'''
	Gets the phase data.

	:type: list[float]
	'''
	RPMData = property(_get_RPMData, None)
	'''
	Gets the RPM data.

	:type: list[float]
	'''
	RPMFrequencyData = property(_get_RPMFrequencyData, None)
	'''
	Gets the RPM-frequency data.

	:type: list[float]
	'''
	RPMFrequencyPhaseData = property(_get_RPMFrequencyPhaseData, None)
	'''
	Gets the RPM-frequency phase data.

	:type: list[float]
	'''
	RPMOrderPhaseData = property(_get_RPMOrderPhaseData, None)
	'''
	Gets the RPM-order phase data.

	:type: list[float]
	'''
	Resolution = property(_get_Resolution, _set_Resolution)
	'''
	Gets or sets the resolution of the campbell diagram.

	:type: int
	'''
	ShowOrderNumber = property(_get_ShowOrderNumber, _set_ShowOrderNumber)
	'''
	Gets or set whether the order number is not displayed, or whether it is displayed inside or outside of the chart.

	:type: recurdyn.Post.ShowOrderNumberBy
	'''
	SignalComponent = property(_get_SignalComponent, None)
	'''
	Gets the signal component.

	:type: recurdyn.Post.IDataComponent
	'''
	SurfaceMesh2DContourType = property(_get_SurfaceMesh2DContourType, _set_SurfaceMesh2DContourType)
	'''
	Gets or sets the type of the additional 2-D surface mesh.

	:type: recurdyn.Post.SurfaceMesh2DContourType
	'''
	TachoComponent = property(_get_TachoComponent, None)
	'''
	Gets the tacho component.

	:type: recurdyn.Post.IDataComponent
	'''
	TimeComponent = property(_get_TimeComponent, None)
	'''
	Gets the time component.

	:type: recurdyn.Post.IDataComponent
	'''
	UseDecibelPlot = property(_get_UseDecibelPlot, _set_UseDecibelPlot)
	'''
	Gets or sets a value indicating whether the decibel plot is used. 

	:type: bool
	'''
	UseInputFile = property(_get_UseInputFile, None)
	'''
	Gets a value indicating whether the campbell data is user-input file.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_ApplyWindowCorrectionFactor": _set_ApplyWindowCorrectionFactor,
		"_set_CorrectionFactor": _set_CorrectionFactor,
		"_set_DecibelReferenceValue": _set_DecibelReferenceValue,
		"_set_Gap": _set_Gap,
		"_set_GraphOption": _set_GraphOption,
		"_set_IsOrderLineVisible": _set_IsOrderLineVisible,
		"_set_IsSwapAxis": _set_IsSwapAxis,
		"_set_MaximumOrder": _set_MaximumOrder,
		"_set_MinimumOrder": _set_MinimumOrder,
		"_set_Name": _set_Name,
		"_set_OrderLineThickness": _set_OrderLineThickness,
		"_set_OrderTextSize": _set_OrderTextSize,
		"_set_Resolution": _set_Resolution,
		"_set_ShowOrderNumber": _set_ShowOrderNumber,
		"_set_SurfaceMesh2DContourType": _set_SurfaceMesh2DContourType,
		"_set_UseDecibelPlot": _set_UseDecibelPlot,
	}
	_prop_map_get_ = {
		"ApplyWindowCorrectionFactor": (1610743849, 2, (11, 0), (), "ApplyWindowCorrectionFactor", None),
		"CampbellInputFile": (1610743813, 2, (8, 0), (), "CampbellInputFile", None),
		"CorrectionFactor": (1610743853, 2, (5, 0), (), "CorrectionFactor", None),
		"DecibelReferenceValue": (1610743851, 2, (5, 0), (), "DecibelReferenceValue", None),
		"FrequencyData": (1610743818, 2, (8197, 0), (), "FrequencyData", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"Gap": (1610743830, 2, (5, 0), (), "Gap", None),
		"GraphOption": (1610743824, 2, (3, 0), (), "GraphOption", '{CD553711-F6DF-3222-AB54-18337C5AA2E2}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsOrderLineVisible": (1610743838, 2, (11, 0), (), "IsOrderLineVisible", None),
		"IsSwapAxis": (1610743826, 2, (11, 0), (), "IsSwapAxis", None),
		"MaximumOrder": (1610743834, 2, (5, 0), (), "MaximumOrder", None),
		"MinimumOrder": (1610743832, 2, (5, 0), (), "MinimumOrder", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"OrderData": (1610743819, 2, (8197, 0), (), "OrderData", None),
		"OrderLineColor": (1610743844, 2, (9, 0), (), "OrderLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"OrderLineThickness": (1610743842, 2, (4, 0), (), "OrderLineThickness", None),
		"OrderTextSize": (1610743845, 2, (5, 0), (), "OrderTextSize", None),
		"PhaseData": (1610743820, 2, (8197, 0), (), "PhaseData", None),
		"RPMData": (1610743817, 2, (8197, 0), (), "RPMData", None),
		"RPMFrequencyData": (1610743821, 2, (8197, 0), (), "RPMFrequencyData", None),
		"RPMFrequencyPhaseData": (1610743822, 2, (8197, 0), (), "RPMFrequencyPhaseData", None),
		"RPMOrderPhaseData": (1610743823, 2, (8197, 0), (), "RPMOrderPhaseData", None),
		"Resolution": (1610743828, 2, (3, 0), (), "Resolution", None),
		"ShowOrderNumber": (1610743840, 2, (3, 0), (), "ShowOrderNumber", '{409874E3-739A-3E60-9D74-CF6DEF3CF0A7}'),
		"SignalComponent": (1610743816, 2, (9, 0), (), "SignalComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"SurfaceMesh2DContourType": (1610743836, 2, (3, 0), (), "SurfaceMesh2DContourType", '{1F838B39-95C4-3252-87A9-BF2486461400}'),
		"TachoComponent": (1610743815, 2, (9, 0), (), "TachoComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"TimeComponent": (1610743814, 2, (9, 0), (), "TimeComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"UseDecibelPlot": (1610743847, 2, (11, 0), (), "UseDecibelPlot", None),
		"UseInputFile": (1610743812, 2, (11, 0), (), "UseInputFile", None),
	}
	_prop_map_put_ = {
		"ApplyWindowCorrectionFactor": ((1610743849, LCID, 4, 0),()),
		"CorrectionFactor": ((1610743853, LCID, 4, 0),()),
		"DecibelReferenceValue": ((1610743851, LCID, 4, 0),()),
		"Gap": ((1610743830, LCID, 4, 0),()),
		"GraphOption": ((1610743824, LCID, 4, 0),()),
		"IsOrderLineVisible": ((1610743838, LCID, 4, 0),()),
		"IsSwapAxis": ((1610743826, LCID, 4, 0),()),
		"MaximumOrder": ((1610743834, LCID, 4, 0),()),
		"MinimumOrder": ((1610743832, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"OrderLineThickness": ((1610743842, LCID, 4, 0),()),
		"OrderTextSize": ((1610743845, LCID, 4, 0),()),
		"Resolution": ((1610743828, LCID, 4, 0),()),
		"ShowOrderNumber": ((1610743840, LCID, 4, 0),()),
		"SurfaceMesh2DContourType": ((1610743836, LCID, 4, 0),()),
		"UseDecibelPlot": ((1610743847, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DContourLegend(DispatchBaseClass):
	'''Defines interface of the Chart3DContourLegend.'''
	CLSID = IID('{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def InitializeBandLevel(self, iBandLevel):
		'''
		Get the colormap with the specific band level. The colormap is equally divided according to the specific band level.
		
		:param iBandLevel: int
		:rtype: list[object]
		'''
		return self._ApplyTypes_(1610743832, 1, (8204, 0), ((3, 1),), 'InitializeBandLevel', None,iBandLevel
			)


	def UpdateColorMapToSeries(self, arrLegendColor):
		'''
		Update the color map data to the surface mesh grid series.
		
		:param arrLegendColor: list[object]
		'''
		_arrLegendColor_type = True if arrLegendColor and isinstance(arrLegendColor[0], win32com.client.VARIANT) else False
		if not _arrLegendColor_type:
			arrLegendColor = [win32com.client.VARIANT(12, _data) for _data in arrLegendColor]

		ret = self._oleobj_.InvokeTypes(1610743831, LCID, 1, (24, 0), ((8204, 1),),arrLegendColor
			)

		if not _arrLegendColor_type:
			arrLegendColor = [_data.value for _data in arrLegendColor]

		return ret


	def UpdateLegendColorMap(self):
		'''
		Updates the legend color map.
		'''
		return self._oleobj_.InvokeTypes(1610743830, LCID, 1, (24, 0), (),)


	def _get_ColorMap(self):
		return self._ApplyTypes_(*(1610743816, 2, (8204, 0), (), "ColorMap", None))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743825, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743829, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743827, 2, (5, 0), (), "FontSize", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_IsStepped(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "IsStepped", None))
	def _get_LegendPosition(self):
		return self._ApplyTypes_(*(1610743814, 2, (3, 0), (), "LegendPosition", '{359DCDA9-97F2-3158-A5AC-3969E925497E}'))
	def _get_Maximum(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Maximum", None))
	def _get_Minimum(self):
		return self._ApplyTypes_(*(1610743824, 2, (5, 0), (), "Minimum", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormat(self):
		return self._ApplyTypes_(*(1610743819, 2, (8, 0), (), "NumberFormat", None))
	def _get_ShowMinMaxLabelsOnly(self):
		return self._ApplyTypes_(*(1610743821, 2, (11, 0), (), "ShowMinMaxLabelsOnly", None))

	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_IsStepped(self, value):
		if "IsStepped" in self.__dict__: self.__dict__["IsStepped"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_LegendPosition(self, value):
		if "LegendPosition" in self.__dict__: self.__dict__["LegendPosition"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormat(self, value):
		if "NumberFormat" in self.__dict__: self.__dict__["NumberFormat"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_ShowMinMaxLabelsOnly(self, value):
		if "ShowMinMaxLabelsOnly" in self.__dict__: self.__dict__["ShowMinMaxLabelsOnly"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))

	ColorMap = property(_get_ColorMap, None)
	'''
	Gets the color map for contour legend.

	:type: list[object]
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font of the axis tick text in the contour legend bar.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the font color of the axis tick text in the contour legend bar.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the font size of the axis tick text in the contour legend bar.

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether the contour legend is enabled.

	:type: bool
	'''
	IsStepped = property(_get_IsStepped, _set_IsStepped)
	'''
	Gets or sets a value indicating whether the contour legend is stepped.

	:type: bool
	'''
	LegendPosition = property(_get_LegendPosition, _set_LegendPosition)
	'''
	Gets or sets the contour legend position.

	:type: recurdyn.Post.ContourLegendPosition
	'''
	Maximum = property(_get_Maximum, None)
	'''
	Gets the maximum of the surface mesh series data.

	:type: float
	'''
	Minimum = property(_get_Minimum, None)
	'''
	Gets the minimum of the surface mesh series data.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormat = property(_get_NumberFormat, _set_NumberFormat)
	'''
	Gets or sets the number format of axis in the contour legend bar.

	:type: str
	'''
	ShowMinMaxLabelsOnly = property(_get_ShowMinMaxLabelsOnly, _set_ShowMinMaxLabelsOnly)
	'''
	Gets or sets a value indicating whether the contour legend bar axis shows only minimum and maximum labels.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_IsEnabled": _set_IsEnabled,
		"_set_IsStepped": _set_IsStepped,
		"_set_LegendPosition": _set_LegendPosition,
		"_set_Name": _set_Name,
		"_set_NumberFormat": _set_NumberFormat,
		"_set_ShowMinMaxLabelsOnly": _set_ShowMinMaxLabelsOnly,
	}
	_prop_map_get_ = {
		"ColorMap": (1610743816, 2, (8204, 0), (), "ColorMap", None),
		"Font": (1610743825, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743829, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743827, 2, (5, 0), (), "FontSize", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"IsStepped": (1610743817, 2, (11, 0), (), "IsStepped", None),
		"LegendPosition": (1610743814, 2, (3, 0), (), "LegendPosition", '{359DCDA9-97F2-3158-A5AC-3969E925497E}'),
		"Maximum": (1610743823, 2, (5, 0), (), "Maximum", None),
		"Minimum": (1610743824, 2, (5, 0), (), "Minimum", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormat": (1610743819, 2, (8, 0), (), "NumberFormat", None),
		"ShowMinMaxLabelsOnly": (1610743821, 2, (11, 0), (), "ShowMinMaxLabelsOnly", None),
	}
	_prop_map_put_ = {
		"Font": ((1610743825, LCID, 4, 0),()),
		"FontSize": ((1610743827, LCID, 4, 0),()),
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"IsStepped": ((1610743817, LCID, 4, 0),()),
		"LegendPosition": ((1610743814, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormat": ((1610743819, LCID, 4, 0),()),
		"ShowMinMaxLabelsOnly": ((1610743821, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DSliceViewer(DispatchBaseClass):
	'''Defines the interface for the slice viewer.'''
	CLSID = IID('{279362D2-44D2-4A28-A600-D889E108D5D8}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def InitializeStartEndFrequency(self):
		'''
		Sets the start, end and interval value automatically by the campbell data series.
		'''
		return self._oleobj_.InvokeTypes(1610743837, LCID, 1, (24, 0), (),)


	def UpdateSliceViewer(self):
		'''
		Updates the slice viewer.
		'''
		return self._oleobj_.InvokeTypes(1610743836, LCID, 1, (24, 0), (),)


	def _get_AxisColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "AxisColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_EndFrequency(self):
		return self._ApplyTypes_(*(1610743814, 2, (5, 0), (), "EndFrequency", None))
	def _get_FrequencyBandWidth(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "FrequencyBandWidth", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_Gap(self):
		return self._ApplyTypes_(*(1610743816, 2, (3, 0), (), "Gap", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_ShowSliceLines(self):
		return self._ApplyTypes_(*(1610743820, 2, (11, 0), (), "ShowSliceLines", None))
	def _get_SliceLineColor(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "SliceLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_SliceLineStyle(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "SliceLineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_SliceLineThickness(self):
		return self._ApplyTypes_(*(1610743822, 2, (5, 0), (), "SliceLineThickness", None))
	def _get_StartFrequency(self):
		return self._ApplyTypes_(*(1610743812, 2, (5, 0), (), "StartFrequency", None))
	def _get_UseVoldKalmanFilter(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "UseVoldKalmanFilter", None))
	def _get_VKFilterNumberOfPole(self):
		return self._ApplyTypes_(*(1610743834, 2, (3, 0), (), "VKFilterNumberOfPole", '{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}'))
	def _get_VKFilterWeightingFactor(self):
		return self._ApplyTypes_(*(1610743832, 2, (5, 0), (), "VKFilterWeightingFactor", None))
	def _get_VKInputType(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "VKInputType", '{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}'))

	def _set_EndFrequency(self, value):
		if "EndFrequency" in self.__dict__: self.__dict__["EndFrequency"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_FrequencyBandWidth(self, value):
		if "FrequencyBandWidth" in self.__dict__: self.__dict__["FrequencyBandWidth"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_Gap(self, value):
		if "Gap" in self.__dict__: self.__dict__["Gap"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_ShowSliceLines(self, value):
		if "ShowSliceLines" in self.__dict__: self.__dict__["ShowSliceLines"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_SliceLineStyle(self, value):
		if "SliceLineStyle" in self.__dict__: self.__dict__["SliceLineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_SliceLineThickness(self, value):
		if "SliceLineThickness" in self.__dict__: self.__dict__["SliceLineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_StartFrequency(self, value):
		if "StartFrequency" in self.__dict__: self.__dict__["StartFrequency"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseVoldKalmanFilter(self, value):
		if "UseVoldKalmanFilter" in self.__dict__: self.__dict__["UseVoldKalmanFilter"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_VKFilterNumberOfPole(self, value):
		if "VKFilterNumberOfPole" in self.__dict__: self.__dict__["VKFilterNumberOfPole"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_VKFilterWeightingFactor(self, value):
		if "VKFilterWeightingFactor" in self.__dict__: self.__dict__["VKFilterWeightingFactor"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_VKInputType(self, value):
		if "VKInputType" in self.__dict__: self.__dict__["VKInputType"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))

	AxisColor = property(_get_AxisColor, None)
	'''
	Gets or sets the axis color of 2D chart in the slice viewer.

	:type: recurdyn.Post.IColor
	'''
	EndFrequency = property(_get_EndFrequency, _set_EndFrequency)
	'''
	Gets or sets the start frequency.

	:type: float
	'''
	FrequencyBandWidth = property(_get_FrequencyBandWidth, _set_FrequencyBandWidth)
	'''
	Gets or sets the width of the frequency band for the VK-filter (Vold Kalman filter)

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	Gap = property(_get_Gap, _set_Gap)
	'''
	Gets or sets the interval between the start and end frequency.

	:type: int
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	ShowSliceLines = property(_get_ShowSliceLines, _set_ShowSliceLines)
	'''
	Gets or sets a value indicating whether the slice lines are visible.

	:type: bool
	'''
	SliceLineColor = property(_get_SliceLineColor, None)
	'''
	Gets or sets the slice line color when the additional viewer is the slice viewer.

	:type: recurdyn.Post.IColor
	'''
	SliceLineStyle = property(_get_SliceLineStyle, _set_SliceLineStyle)
	'''
	Gets or sets the slice line style when the additional viewer is the slice viewer.

	:type: recurdyn.Post.LineStyle
	'''
	SliceLineThickness = property(_get_SliceLineThickness, _set_SliceLineThickness)
	'''
	Gets or sets the slice line thickness when the additional viewer is the slice viewer.

	:type: float
	'''
	StartFrequency = property(_get_StartFrequency, _set_StartFrequency)
	'''
	Gets or sets the start frequency.

	:type: float
	'''
	UseVoldKalmanFilter = property(_get_UseVoldKalmanFilter, _set_UseVoldKalmanFilter)
	'''
	Gets or sets a value indicating whether the VK-filter (Vold Kalman filter) is used.

	:type: bool
	'''
	VKFilterNumberOfPole = property(_get_VKFilterNumberOfPole, _set_VKFilterNumberOfPole)
	'''
	ets or sets the number of pole for the VK-filter (Vold Kalman filter).

	:type: recurdyn.Post.VKFilterNumberOfPole
	'''
	VKFilterWeightingFactor = property(_get_VKFilterWeightingFactor, _set_VKFilterWeightingFactor)
	'''
	Gets or sets the weighting factor for the VK-filter (Vold Kalman filter).

	:type: float
	'''
	VKInputType = property(_get_VKInputType, _set_VKInputType)
	'''
	Gets or sets the weight type for the VK-filter (Vold Kalman filter).

	:type: recurdyn.Post.VKInputType
	'''

	_prop_map_set_function_ = {
		"_set_EndFrequency": _set_EndFrequency,
		"_set_FrequencyBandWidth": _set_FrequencyBandWidth,
		"_set_Gap": _set_Gap,
		"_set_Name": _set_Name,
		"_set_ShowSliceLines": _set_ShowSliceLines,
		"_set_SliceLineStyle": _set_SliceLineStyle,
		"_set_SliceLineThickness": _set_SliceLineThickness,
		"_set_StartFrequency": _set_StartFrequency,
		"_set_UseVoldKalmanFilter": _set_UseVoldKalmanFilter,
		"_set_VKFilterNumberOfPole": _set_VKFilterNumberOfPole,
		"_set_VKFilterWeightingFactor": _set_VKFilterWeightingFactor,
		"_set_VKInputType": _set_VKInputType,
	}
	_prop_map_get_ = {
		"AxisColor": (1610743818, 2, (9, 0), (), "AxisColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"EndFrequency": (1610743814, 2, (5, 0), (), "EndFrequency", None),
		"FrequencyBandWidth": (1610743830, 2, (5, 0), (), "FrequencyBandWidth", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"Gap": (1610743816, 2, (3, 0), (), "Gap", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"ShowSliceLines": (1610743820, 2, (11, 0), (), "ShowSliceLines", None),
		"SliceLineColor": (1610743819, 2, (9, 0), (), "SliceLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"SliceLineStyle": (1610743824, 2, (3, 0), (), "SliceLineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"SliceLineThickness": (1610743822, 2, (5, 0), (), "SliceLineThickness", None),
		"StartFrequency": (1610743812, 2, (5, 0), (), "StartFrequency", None),
		"UseVoldKalmanFilter": (1610743826, 2, (11, 0), (), "UseVoldKalmanFilter", None),
		"VKFilterNumberOfPole": (1610743834, 2, (3, 0), (), "VKFilterNumberOfPole", '{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}'),
		"VKFilterWeightingFactor": (1610743832, 2, (5, 0), (), "VKFilterWeightingFactor", None),
		"VKInputType": (1610743828, 2, (3, 0), (), "VKInputType", '{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}'),
	}
	_prop_map_put_ = {
		"EndFrequency": ((1610743814, LCID, 4, 0),()),
		"FrequencyBandWidth": ((1610743830, LCID, 4, 0),()),
		"Gap": ((1610743816, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"ShowSliceLines": ((1610743820, LCID, 4, 0),()),
		"SliceLineStyle": ((1610743824, LCID, 4, 0),()),
		"SliceLineThickness": ((1610743822, LCID, 4, 0),()),
		"StartFrequency": ((1610743812, LCID, 4, 0),()),
		"UseVoldKalmanFilter": ((1610743826, LCID, 4, 0),()),
		"VKFilterNumberOfPole": ((1610743834, LCID, 4, 0),()),
		"VKFilterWeightingFactor": ((1610743832, LCID, 4, 0),()),
		"VKInputType": ((1610743828, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleGridLine(DispatchBaseClass):
	'''Defines interface for the grid line style.'''
	CLSID = IID('{7470748B-68F6-3047-8F66-B114A4A9C26C}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawGridLines(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawGridLines", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "Thickness", None))

	def _set_DrawGridLines(self, value):
		if "DrawGridLines" in self.__dict__: self.__dict__["DrawGridLines"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	DrawGridLines = property(_get_DrawGridLines, _set_DrawGridLines)
	'''
	Gets or sets a value indicating whether draw grid lines.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawGridLines": _set_DrawGridLines,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawGridLines": (1610743812, 2, (11, 0), (), "DrawGridLines", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743815, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawGridLines": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleMajorGridLine(DispatchBaseClass):
	'''Defines the interface for the major grid line style.'''
	CLSID = IID('{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawGridLines(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawGridLines", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "Thickness", None))

	def _set_DrawGridLines(self, value):
		if "DrawGridLines" in self.__dict__: self.__dict__["DrawGridLines"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	DrawGridLines = property(_get_DrawGridLines, _set_DrawGridLines)
	'''
	Gets or sets a value indicating whether draw grid lines.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawGridLines": _set_DrawGridLines,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawGridLines": (1610743812, 2, (11, 0), (), "DrawGridLines", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743815, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawGridLines": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleMinorGridLine(DispatchBaseClass):
	'''Defines the interface for the minor grid line style.'''
	CLSID = IID('{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawGridLines(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawGridLines", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "Thickness", None))

	def _set_DrawGridLines(self, value):
		if "DrawGridLines" in self.__dict__: self.__dict__["DrawGridLines"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	DrawGridLines = property(_get_DrawGridLines, _set_DrawGridLines)
	'''
	Gets or sets a value indicating whether draw grid lines.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawGridLines": _set_DrawGridLines,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawGridLines": (1610743812, 2, (11, 0), (), "DrawGridLines", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743815, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawGridLines": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleTickLabel(DispatchBaseClass):
	'''Defines the interface for tick label style of axis.'''
	CLSID = IID('{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_DrawLabels(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawLabels", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "FontSize", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_DrawLabels(self, value):
		if "DrawLabels" in self.__dict__: self.__dict__["DrawLabels"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	DrawLabels = property(_get_DrawLabels, _set_DrawLabels)
	'''
	Gets or sets a value indicating whether draw labels.

	:type: bool
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the color of the font.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_DrawLabels": _set_DrawLabels,
		"_set_FontSize": _set_FontSize,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"DrawLabels": (1610743812, 2, (11, 0), (), "DrawLabels", None),
		"FontColor": (1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743815, 2, (5, 0), (), "FontSize", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"DrawLabels": ((1610743812, LCID, 4, 0),()),
		"FontSize": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleTickLine(DispatchBaseClass):
	'''Defines interface for the tick line style.'''
	CLSID = IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawTicks(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawTicks", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Length(self):
		return self._ApplyTypes_(*(1610743817, 2, (5, 0), (), "Length", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "Thickness", None))

	def _set_DrawTicks(self, value):
		if "DrawTicks" in self.__dict__: self.__dict__["DrawTicks"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Length(self, value):
		if "Length" in self.__dict__: self.__dict__["Length"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of tick line.

	:type: recurdyn.Post.IColor
	'''
	DrawTicks = property(_get_DrawTicks, _set_DrawTicks)
	'''
	Gets or sets a value indicating whether draw ticks.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Length = property(_get_Length, _set_Length)
	'''
	Gets or sets the length of the tick line.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of tick line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawTicks": _set_DrawTicks,
		"_set_Length": _set_Length,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawTicks": (1610743812, 2, (11, 0), (), "DrawTicks", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Length": (1610743817, 2, (5, 0), (), "Length", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743815, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawTicks": ((1610743812, LCID, 4, 0),()),
		"Length": ((1610743817, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChart3DStyleTitle(DispatchBaseClass):
	'''Defines interface for the Chart3DStyleTitle. This interface provides style of title.'''
	CLSID = IID('{BB3F7878-1B92-4B36-B688-31107524DB25}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743819, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HorizontalAlignment(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_HorizontalAlignment(self, value):
		if "HorizontalAlignment" in self.__dict__: self.__dict__["HorizontalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background.

	:type: recurdyn.Post.IColor
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the color of the font.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HorizontalAlignment = property(_get_HorizontalAlignment, _set_HorizontalAlignment)
	'''
	Gets or sets the horizontal alignment.

	:type: recurdyn.Post.HorizontalAlignmentEx
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_HorizontalAlignment": _set_HorizontalAlignment,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"Background": (1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"Font": (1610743819, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743815, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HorizontalAlignment": (1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Font": ((1610743819, LCID, 4, 0),()),
		"FontSize": ((1610743815, LCID, 4, 0),()),
		"FontStyle": ((1610743821, LCID, 4, 0),()),
		"FontWeight": ((1610743817, LCID, 4, 0),()),
		"HorizontalAlignment": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAnnotation(DispatchBaseClass):
	'''Defines interface of the base chart annotation.'''
	CLSID = IID('{1A536495-EBB2-3064-8F82-965701F9C9E6}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsVisible", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))

	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 8, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 8, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets the visible of the annotation.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the x-axis of the annotation.

	:type: recurdyn.Post.IChartAxisX
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the y-axis of the annotation.

	:type: recurdyn.Post.IChartAxisY
	'''

	_prop_map_set_function_ = {
		"_set_IsVisible": _set_IsVisible,
		"_set_Name": _set_Name,
		"_set_XAxis": _set_XAxis,
		"_set_YAxis": _set_YAxis,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsVisible": (1610743812, 2, (11, 0), (), "IsVisible", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"XAxis": (1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"YAxis": (1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
	}
	_prop_map_put_ = {
		"IsVisible": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"XAxis": ((1610743814, LCID, 8, 0),()),
		"YAxis": ((1610743816, LCID, 8, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAnnotationArrow(DispatchBaseClass):
	'''Defines interface of the line annotation.'''
	CLSID = IID('{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsVisible", None))
	def _get_LineColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "Thickness", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_XEndValue(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "XEndValue", None))
	def _get_XStartValue(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "XStartValue", None))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))
	def _get_YEndValue(self):
		return self._ApplyTypes_(*(1610743827, 2, (5, 0), (), "YEndValue", None))
	def _get_YStartValue(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "YStartValue", None))

	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 8, 0) + (value,) + ()))
	def _set_XEndValue(self, value):
		if "XEndValue" in self.__dict__: self.__dict__["XEndValue"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_XStartValue(self, value):
		if "XStartValue" in self.__dict__: self.__dict__["XStartValue"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 8, 0) + (value,) + ()))
	def _set_YEndValue(self, value):
		if "YEndValue" in self.__dict__: self.__dict__["YEndValue"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_YStartValue(self, value):
		if "YStartValue" in self.__dict__: self.__dict__["YStartValue"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets the visible of the annotation.

	:type: bool
	'''
	LineColor = property(_get_LineColor, None)
	'''
	Gets or sets the color of the line.

	:type: recurdyn.Post.IColor
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of the line.

	:type: float
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the x-axis of the annotation.

	:type: recurdyn.Post.IChartAxisX
	'''
	XEndValue = property(_get_XEndValue, _set_XEndValue)
	'''
	Gets or sets the x end value of the line.

	:type: float
	'''
	XStartValue = property(_get_XStartValue, _set_XStartValue)
	'''
	Gets or sets the x start value of the line.

	:type: float
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the y-axis of the annotation.

	:type: recurdyn.Post.IChartAxisY
	'''
	YEndValue = property(_get_YEndValue, _set_YEndValue)
	'''
	Gets or sets the y end value of the line.

	:type: float
	'''
	YStartValue = property(_get_YStartValue, _set_YStartValue)
	'''
	Gets or sets the y start value of the line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_IsVisible": _set_IsVisible,
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
		"_set_XAxis": _set_XAxis,
		"_set_XEndValue": _set_XEndValue,
		"_set_XStartValue": _set_XStartValue,
		"_set_YAxis": _set_YAxis,
		"_set_YEndValue": _set_YEndValue,
		"_set_YStartValue": _set_YStartValue,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsVisible": (1610743812, 2, (11, 0), (), "IsVisible", None),
		"LineColor": (1610743818, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineStyle": (1610743829, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743819, 2, (5, 0), (), "Thickness", None),
		"XAxis": (1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"XEndValue": (1610743823, 2, (5, 0), (), "XEndValue", None),
		"XStartValue": (1610743821, 2, (5, 0), (), "XStartValue", None),
		"YAxis": (1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
		"YEndValue": (1610743827, 2, (5, 0), (), "YEndValue", None),
		"YStartValue": (1610743825, 2, (5, 0), (), "YStartValue", None),
	}
	_prop_map_put_ = {
		"IsVisible": ((1610743812, LCID, 4, 0),()),
		"LineStyle": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743819, LCID, 4, 0),()),
		"XAxis": ((1610743814, LCID, 8, 0),()),
		"XEndValue": ((1610743823, LCID, 4, 0),()),
		"XStartValue": ((1610743821, LCID, 4, 0),()),
		"YAxis": ((1610743816, LCID, 8, 0),()),
		"YEndValue": ((1610743827, LCID, 4, 0),()),
		"YStartValue": ((1610743825, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAnnotationCollection(DispatchBaseClass):
	'''Defines interface for the annotation collection.'''
	CLSID = IID('{B89390C5-E030-404E-9B93-B9B2EB12D6A2}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the annotation by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAnnotation
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{1A536495-EBB2-3064-8F82-965701F9C9E6}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the annotation by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the annotation by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartAnnotation
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{1A536495-EBB2-3064-8F82-965701F9C9E6}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{1A536495-EBB2-3064-8F82-965701F9C9E6}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{1A536495-EBB2-3064-8F82-965701F9C9E6}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IChartAnnotationLine(DispatchBaseClass):
	'''Defines interface of the line annotation.'''
	CLSID = IID('{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsVisible", None))
	def _get_LineColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "Thickness", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_XEndValue(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "XEndValue", None))
	def _get_XStartValue(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "XStartValue", None))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))
	def _get_YEndValue(self):
		return self._ApplyTypes_(*(1610743827, 2, (5, 0), (), "YEndValue", None))
	def _get_YStartValue(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "YStartValue", None))

	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 8, 0) + (value,) + ()))
	def _set_XEndValue(self, value):
		if "XEndValue" in self.__dict__: self.__dict__["XEndValue"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_XStartValue(self, value):
		if "XStartValue" in self.__dict__: self.__dict__["XStartValue"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 8, 0) + (value,) + ()))
	def _set_YEndValue(self, value):
		if "YEndValue" in self.__dict__: self.__dict__["YEndValue"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_YStartValue(self, value):
		if "YStartValue" in self.__dict__: self.__dict__["YStartValue"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets the visible of the annotation.

	:type: bool
	'''
	LineColor = property(_get_LineColor, None)
	'''
	Gets or sets the color of the line.

	:type: recurdyn.Post.IColor
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of the line.

	:type: float
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the x-axis of the annotation.

	:type: recurdyn.Post.IChartAxisX
	'''
	XEndValue = property(_get_XEndValue, _set_XEndValue)
	'''
	Gets or sets the x end value of the line.

	:type: float
	'''
	XStartValue = property(_get_XStartValue, _set_XStartValue)
	'''
	Gets or sets the x start value of the line.

	:type: float
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the y-axis of the annotation.

	:type: recurdyn.Post.IChartAxisY
	'''
	YEndValue = property(_get_YEndValue, _set_YEndValue)
	'''
	Gets or sets the y end value of the line.

	:type: float
	'''
	YStartValue = property(_get_YStartValue, _set_YStartValue)
	'''
	Gets or sets the y start value of the line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_IsVisible": _set_IsVisible,
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
		"_set_XAxis": _set_XAxis,
		"_set_XEndValue": _set_XEndValue,
		"_set_XStartValue": _set_XStartValue,
		"_set_YAxis": _set_YAxis,
		"_set_YEndValue": _set_YEndValue,
		"_set_YStartValue": _set_YStartValue,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsVisible": (1610743812, 2, (11, 0), (), "IsVisible", None),
		"LineColor": (1610743818, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineStyle": (1610743829, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743819, 2, (5, 0), (), "Thickness", None),
		"XAxis": (1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"XEndValue": (1610743823, 2, (5, 0), (), "XEndValue", None),
		"XStartValue": (1610743821, 2, (5, 0), (), "XStartValue", None),
		"YAxis": (1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
		"YEndValue": (1610743827, 2, (5, 0), (), "YEndValue", None),
		"YStartValue": (1610743825, 2, (5, 0), (), "YStartValue", None),
	}
	_prop_map_put_ = {
		"IsVisible": ((1610743812, LCID, 4, 0),()),
		"LineStyle": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743819, LCID, 4, 0),()),
		"XAxis": ((1610743814, LCID, 8, 0),()),
		"XEndValue": ((1610743823, LCID, 4, 0),()),
		"XStartValue": ((1610743821, LCID, 4, 0),()),
		"YAxis": ((1610743816, LCID, 8, 0),()),
		"YEndValue": ((1610743827, LCID, 4, 0),()),
		"YStartValue": ((1610743825, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAnnotationText(DispatchBaseClass):
	'''Defines interface of the text annotation.'''
	CLSID = IID('{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743833, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743834, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderThickness(self):
		return self._ApplyTypes_(*(1610743835, 2, (5, 0), (), "BorderThickness", None))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743824, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743832, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743826, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743830, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsVisible", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Text(self):
		return self._ApplyTypes_(*(1610743818, 2, (8, 0), (), "Text", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_XValue(self):
		return self._ApplyTypes_(*(1610743820, 2, (5, 0), (), "XValue", None))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))
	def _get_YValue(self):
		return self._ApplyTypes_(*(1610743822, 2, (5, 0), (), "YValue", None))

	def _set_BorderThickness(self, value):
		if "BorderThickness" in self.__dict__: self.__dict__["BorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))
	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Text(self, value):
		if "Text" in self.__dict__: self.__dict__["Text"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 8, 0) + (value,) + ()))
	def _set_XValue(self, value):
		if "XValue" in self.__dict__: self.__dict__["XValue"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 8, 0) + (value,) + ()))
	def _set_YValue(self, value):
		if "YValue" in self.__dict__: self.__dict__["YValue"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background of the text.

	:type: recurdyn.Post.IColor
	'''
	BorderColor = property(_get_BorderColor, None)
	'''
	Gets or sets the border color of the annotation.

	:type: recurdyn.Post.IColor
	'''
	BorderThickness = property(_get_BorderThickness, _set_BorderThickness)
	'''
	Gets or sets the border thickness of the annotation.

	:type: float
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font of the text.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the font color of the text.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the font size of the text.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style of the text.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight of the text.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets the visible of the annotation.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Text = property(_get_Text, _set_Text)
	'''
	Gets or sets the text of annotation.

	:type: str
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the x-axis of the annotation.

	:type: recurdyn.Post.IChartAxisX
	'''
	XValue = property(_get_XValue, _set_XValue)
	'''
	Gets or sets the x value of the annotation.

	:type: float
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the y-axis of the annotation.

	:type: recurdyn.Post.IChartAxisY
	'''
	YValue = property(_get_YValue, _set_YValue)
	'''
	Gets or sets the y value of the annotation.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_BorderThickness": _set_BorderThickness,
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_IsVisible": _set_IsVisible,
		"_set_Name": _set_Name,
		"_set_Text": _set_Text,
		"_set_XAxis": _set_XAxis,
		"_set_XValue": _set_XValue,
		"_set_YAxis": _set_YAxis,
		"_set_YValue": _set_YValue,
	}
	_prop_map_get_ = {
		"Background": (1610743833, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderColor": (1610743834, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderThickness": (1610743835, 2, (5, 0), (), "BorderThickness", None),
		"Font": (1610743824, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743832, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743826, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743828, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743830, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsVisible": (1610743812, 2, (11, 0), (), "IsVisible", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Text": (1610743818, 2, (8, 0), (), "Text", None),
		"XAxis": (1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"XValue": (1610743820, 2, (5, 0), (), "XValue", None),
		"YAxis": (1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
		"YValue": (1610743822, 2, (5, 0), (), "YValue", None),
	}
	_prop_map_put_ = {
		"BorderThickness": ((1610743835, LCID, 4, 0),()),
		"Font": ((1610743824, LCID, 4, 0),()),
		"FontSize": ((1610743826, LCID, 4, 0),()),
		"FontStyle": ((1610743828, LCID, 4, 0),()),
		"FontWeight": ((1610743830, LCID, 4, 0),()),
		"IsVisible": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Text": ((1610743818, LCID, 4, 0),()),
		"XAxis": ((1610743814, LCID, 8, 0),()),
		"XValue": ((1610743820, LCID, 4, 0),()),
		"YAxis": ((1610743816, LCID, 8, 0),()),
		"YValue": ((1610743822, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAnnotationVerticalLine(DispatchBaseClass):
	'''Defines interface of the vertical line annotation.'''
	CLSID = IID('{BD40CFBC-C472-3CAD-B809-1B8301479DE2}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsVisible", None))
	def _get_LabelFontColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "LabelFontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineColor(self):
		return self._ApplyTypes_(*(1610743821, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineThickness(self):
		return self._ApplyTypes_(*(1610743822, 2, (5, 0), (), "LineThickness", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_ShowLabel(self):
		return self._ApplyTypes_(*(1610743824, 2, (11, 0), (), "ShowLabel", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_XValue(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "XValue", None))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))

	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_LineThickness(self, value):
		if "LineThickness" in self.__dict__: self.__dict__["LineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_ShowLabel(self, value):
		if "ShowLabel" in self.__dict__: self.__dict__["ShowLabel"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 8, 0) + (value,) + ()))
	def _set_XValue(self, value):
		if "XValue" in self.__dict__: self.__dict__["XValue"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 8, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets the visible of the annotation.

	:type: bool
	'''
	LabelFontColor = property(_get_LabelFontColor, None)
	'''
	Gets or sets the font color of the annotation label.

	:type: recurdyn.Post.IColor
	'''
	LineColor = property(_get_LineColor, None)
	'''
	Gets or sets the line color of the annotation.

	:type: recurdyn.Post.IColor
	'''
	LineThickness = property(_get_LineThickness, _set_LineThickness)
	'''
	Gets or sets the line thickness of the annotation.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	ShowLabel = property(_get_ShowLabel, _set_ShowLabel)
	'''
	Gets or sets the value that indicates whether the label is visible.

	:type: bool
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the x-axis of the annotation.

	:type: recurdyn.Post.IChartAxisX
	'''
	XValue = property(_get_XValue, _set_XValue)
	'''
	Gets or sets the x value of the annotation.

	:type: float
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the y-axis of the annotation.

	:type: recurdyn.Post.IChartAxisY
	'''

	_prop_map_set_function_ = {
		"_set_IsVisible": _set_IsVisible,
		"_set_LineThickness": _set_LineThickness,
		"_set_Name": _set_Name,
		"_set_ShowLabel": _set_ShowLabel,
		"_set_XAxis": _set_XAxis,
		"_set_XValue": _set_XValue,
		"_set_YAxis": _set_YAxis,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsVisible": (1610743812, 2, (11, 0), (), "IsVisible", None),
		"LabelFontColor": (1610743818, 2, (9, 0), (), "LabelFontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineColor": (1610743821, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineThickness": (1610743822, 2, (5, 0), (), "LineThickness", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"ShowLabel": (1610743824, 2, (11, 0), (), "ShowLabel", None),
		"XAxis": (1610743814, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"XValue": (1610743819, 2, (5, 0), (), "XValue", None),
		"YAxis": (1610743816, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
	}
	_prop_map_put_ = {
		"IsVisible": ((1610743812, LCID, 4, 0),()),
		"LineThickness": ((1610743822, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"ShowLabel": ((1610743824, LCID, 4, 0),()),
		"XAxis": ((1610743814, LCID, 8, 0),()),
		"XValue": ((1610743819, LCID, 4, 0),()),
		"YAxis": ((1610743816, LCID, 8, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxis3D(DispatchBaseClass):
	'''Defines interface of the Chart3D axis.'''
	CLSID = IID('{05AAE55E-A228-4690-929A-CC36280CB6F4}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, Min, Max):
		'''
		Sets the minimum and maximum of visual range.
		
		:param Min: float
		:param Max: float
		'''
		return self._oleobj_.InvokeTypes(1610743850, LCID, 1, (24, 0), ((5, 1), (5, 1)),Min
			, Max)


	def _get_AxisPlaneBackground(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743841, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743837, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_PlaneBorderColor(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_PlaneBorderThickness(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "PlaneBorderThickness", None))
	def _get_TickLabelAlignment(self):
		return self._ApplyTypes_(*(1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743835, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_PlaneBorderThickness(self, value):
		if "PlaneBorderThickness" in self.__dict__: self.__dict__["PlaneBorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_TickLabelAlignment(self, value):
		if "TickLabelAlignment" in self.__dict__: self.__dict__["TickLabelAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))

	AxisPlaneBackground = property(_get_AxisPlaneBackground, None)
	'''
	Gets or sets the axis plane background.

	:type: recurdyn.Post.IColor
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChart3DStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChart3DStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	PlaneBorderColor = property(_get_PlaneBorderColor, None)
	'''
	Gets or sets the color of the plane border.

	:type: recurdyn.Post.IColor
	'''
	PlaneBorderThickness = property(_get_PlaneBorderThickness, _set_PlaneBorderThickness)
	'''
	Gets or sets the plane border thickness.

	:type: float
	'''
	TickLabelAlignment = property(_get_TickLabelAlignment, _set_TickLabelAlignment)
	'''
	Gets or sets the tick label alignment.

	:type: recurdyn.Post.TextAlignment3D
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChart3DStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_PlaneBorderThickness": _set_PlaneBorderThickness,
		"_set_TickLabelAlignment": _set_TickLabelAlignment,
		"_set_Title": _set_Title,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisPlaneBackground": (1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"AxisType": (1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743816, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LogarithmicBase": (1610743841, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743831, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'),
		"MajorTickLineStyle": (1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"Max": (1610743823, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743837, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743825, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743833, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'),
		"MinorTickLineStyle": (1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"MinorsPerMajor": (1610743829, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743814, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"PlaneBorderColor": (1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"PlaneBorderThickness": (1610743821, 2, (5, 0), (), "PlaneBorderThickness", None),
		"TickLabelAlignment": (1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'),
		"TickLabelStyle": (1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"UseAutoTicks": (1610743835, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisType": ((1610743839, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743816, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743841, LCID, 4, 0),()),
		"MajorDelta": ((1610743831, LCID, 4, 0),()),
		"Max": ((1610743823, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743837, LCID, 4, 0),()),
		"Min": ((1610743825, LCID, 4, 0),()),
		"MinorDelta": ((1610743833, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743814, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743827, LCID, 4, 0),()),
		"PlaneBorderThickness": ((1610743821, LCID, 4, 0),()),
		"TickLabelAlignment": ((1610743843, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743835, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisBase(DispatchBaseClass):
	'''Defines interface of the Chart axis.'''
	CLSID = IID('{5A2D9BD6-130C-46BA-8682-0E7013235AEF}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743847, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def SetMinMaxWithAnimation(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range with animation effect.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743848, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def _get_AxisId(self):
		return self._ApplyTypes_(*(1610743820, 2, (8, 0), (), "AxisId", None))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743850, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743826, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743825, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743827, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "IsSelected", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743852, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743837, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743829, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743843, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743839, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743835, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743845, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743833, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_SeriesCollection(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743818, 2, (8, 0), (), "Title", None))
	def _get_TitleStyle(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'))
	def _get_Unit(self):
		return self._ApplyTypes_(*(1610743821, 2, (8, 0), (), "Unit", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743841, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743850, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743852, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743845, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_Unit(self, value):
		if "Unit" in self.__dict__: self.__dict__["Unit"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))

	AxisId = property(_get_AxisId, None)
	'''
	Gets the axis identifier.

	:type: str
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	BorderColor = property(_get_BorderColor, None)
	'''
	Gets the color of the border.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this axis is selected.

	:type: bool
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChartStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChartStyleMajorTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChartStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChartStyleMinorTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	SeriesCollection = property(_get_SeriesCollection, None)
	'''
	Gets the series collection related to this axis.

	:type: recurdyn.Post.ISeriesCollection
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChartStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	TitleStyle = property(_get_TitleStyle, None)
	'''
	Gets the title style.

	:type: recurdyn.Post.IChartStyleAxisTitle
	'''
	Unit = property(_get_Unit, _set_Unit)
	'''
	Gets or sets the unit of axis.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_IsSelected": _set_IsSelected,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_Title": _set_Title,
		"_set_Unit": _set_Unit,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisId": (1610743820, 2, (8, 0), (), "AxisId", None),
		"AxisType": (1610743850, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743826, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderColor": (1610743825, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743827, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743823, 2, (11, 0), (), "IsSelected", None),
		"LogarithmicBase": (1610743852, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743837, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'),
		"MajorTickLineStyle": (1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'),
		"Max": (1610743829, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743843, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743831, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743839, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'),
		"MinorTickLineStyle": (1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'),
		"MinorsPerMajor": (1610743835, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743845, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743833, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"SeriesCollection": (1610743849, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'),
		"TickLabelStyle": (1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'),
		"Title": (1610743818, 2, (8, 0), (), "Title", None),
		"TitleStyle": (1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'),
		"Unit": (1610743821, 2, (8, 0), (), "Unit", None),
		"UseAutoTicks": (1610743841, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisType": ((1610743850, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743827, LCID, 4, 0),()),
		"IsSelected": ((1610743823, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743852, LCID, 4, 0),()),
		"MajorDelta": ((1610743837, LCID, 4, 0),()),
		"Max": ((1610743829, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743843, LCID, 4, 0),()),
		"Min": ((1610743831, LCID, 4, 0),()),
		"MinorDelta": ((1610743839, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743835, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743845, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743833, LCID, 4, 0),()),
		"Title": ((1610743818, LCID, 4, 0),()),
		"Unit": ((1610743821, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743841, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisX(DispatchBaseClass):
	'''Defines interface for the X-Axis.'''
	CLSID = IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743846, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def SetMinMaxWithAnimation(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range with animation effect.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743847, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def _get_AxisAlignment(self):
		return self._ApplyTypes_(*(1610743853, 2, (3, 0), (), "AxisAlignment", '{4F387FCB-DA43-3B87-B972-3E158FBC0CCD}'))
	def _get_AxisId(self):
		return self._ApplyTypes_(*(1610743820, 2, (8, 0), (), "AxisId", None))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743849, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743825, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "IsSelected", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743851, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743836, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743828, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743842, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743838, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743834, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743844, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743832, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_SeriesCollection(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743818, 2, (8, 0), (), "Title", None))
	def _get_TitleStyle(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'))
	def _get_Unit(self):
		return self._ApplyTypes_(*(1610743821, 2, (8, 0), (), "Unit", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743840, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisAlignment(self, value):
		if "AxisAlignment" in self.__dict__: self.__dict__["AxisAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743853, LCID, 4, 0) + (value,) + ()))
	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743849, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743851, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743842, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743844, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_Unit(self, value):
		if "Unit" in self.__dict__: self.__dict__["Unit"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743840, LCID, 4, 0) + (value,) + ()))

	AxisAlignment = property(_get_AxisAlignment, _set_AxisAlignment)
	'''
	Gets or sets the X-Axis alignment.

	:type: recurdyn.Post.ChartXAxisAlignment
	'''
	AxisId = property(_get_AxisId, None)
	'''
	Gets the axis identifier.

	:type: str
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this axis is selected.

	:type: bool
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChartStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChartStyleMajorTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChartStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChartStyleMinorTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	SeriesCollection = property(_get_SeriesCollection, None)
	'''
	Gets the series collection related to this axis.

	:type: recurdyn.Post.ISeriesCollection
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChartStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	TitleStyle = property(_get_TitleStyle, None)
	'''
	Gets the title style.

	:type: recurdyn.Post.IChartStyleAxisTitle
	'''
	Unit = property(_get_Unit, _set_Unit)
	'''
	Gets or sets the unit of axis.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisAlignment": _set_AxisAlignment,
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_IsSelected": _set_IsSelected,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_Title": _set_Title,
		"_set_Unit": _set_Unit,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisAlignment": (1610743853, 2, (3, 0), (), "AxisAlignment", '{4F387FCB-DA43-3B87-B972-3E158FBC0CCD}'),
		"AxisId": (1610743820, 2, (8, 0), (), "AxisId", None),
		"AxisType": (1610743849, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743825, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743826, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743823, 2, (11, 0), (), "IsSelected", None),
		"LogarithmicBase": (1610743851, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743836, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'),
		"MajorTickLineStyle": (1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'),
		"Max": (1610743828, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743842, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743830, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743838, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'),
		"MinorTickLineStyle": (1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'),
		"MinorsPerMajor": (1610743834, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743844, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743832, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"SeriesCollection": (1610743848, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'),
		"TickLabelStyle": (1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'),
		"Title": (1610743818, 2, (8, 0), (), "Title", None),
		"TitleStyle": (1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'),
		"Unit": (1610743821, 2, (8, 0), (), "Unit", None),
		"UseAutoTicks": (1610743840, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisAlignment": ((1610743853, LCID, 4, 0),()),
		"AxisType": ((1610743849, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743826, LCID, 4, 0),()),
		"IsSelected": ((1610743823, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743851, LCID, 4, 0),()),
		"MajorDelta": ((1610743836, LCID, 4, 0),()),
		"Max": ((1610743828, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743842, LCID, 4, 0),()),
		"Min": ((1610743830, LCID, 4, 0),()),
		"MinorDelta": ((1610743838, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743834, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743844, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743832, LCID, 4, 0),()),
		"Title": ((1610743818, LCID, 4, 0),()),
		"Unit": ((1610743821, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743840, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisX3D(DispatchBaseClass):
	'''Defines interface of the Chart3D axis.'''
	CLSID = IID('{726C8F68-8A81-4F1F-8D5E-3249898D875B}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, Min, Max):
		'''
		Sets the minimum and maximum of visual range.
		
		:param Min: float
		:param Max: float
		'''
		return self._oleobj_.InvokeTypes(1610743850, LCID, 1, (24, 0), ((5, 1), (5, 1)),Min
			, Max)


	def _get_AxisPlaneBackground(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743841, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743837, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_PlaneBorderColor(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_PlaneBorderThickness(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "PlaneBorderThickness", None))
	def _get_TickLabelAlignment(self):
		return self._ApplyTypes_(*(1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743835, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_PlaneBorderThickness(self, value):
		if "PlaneBorderThickness" in self.__dict__: self.__dict__["PlaneBorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_TickLabelAlignment(self, value):
		if "TickLabelAlignment" in self.__dict__: self.__dict__["TickLabelAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))

	AxisPlaneBackground = property(_get_AxisPlaneBackground, None)
	'''
	Gets or sets the axis plane background.

	:type: recurdyn.Post.IColor
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChart3DStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChart3DStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	PlaneBorderColor = property(_get_PlaneBorderColor, None)
	'''
	Gets or sets the color of the plane border.

	:type: recurdyn.Post.IColor
	'''
	PlaneBorderThickness = property(_get_PlaneBorderThickness, _set_PlaneBorderThickness)
	'''
	Gets or sets the plane border thickness.

	:type: float
	'''
	TickLabelAlignment = property(_get_TickLabelAlignment, _set_TickLabelAlignment)
	'''
	Gets or sets the tick label alignment.

	:type: recurdyn.Post.TextAlignment3D
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChart3DStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_PlaneBorderThickness": _set_PlaneBorderThickness,
		"_set_TickLabelAlignment": _set_TickLabelAlignment,
		"_set_Title": _set_Title,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisPlaneBackground": (1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"AxisType": (1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743816, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LogarithmicBase": (1610743841, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743831, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'),
		"MajorTickLineStyle": (1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"Max": (1610743823, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743837, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743825, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743833, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'),
		"MinorTickLineStyle": (1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"MinorsPerMajor": (1610743829, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743814, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"PlaneBorderColor": (1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"PlaneBorderThickness": (1610743821, 2, (5, 0), (), "PlaneBorderThickness", None),
		"TickLabelAlignment": (1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'),
		"TickLabelStyle": (1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"UseAutoTicks": (1610743835, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisType": ((1610743839, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743816, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743841, LCID, 4, 0),()),
		"MajorDelta": ((1610743831, LCID, 4, 0),()),
		"Max": ((1610743823, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743837, LCID, 4, 0),()),
		"Min": ((1610743825, LCID, 4, 0),()),
		"MinorDelta": ((1610743833, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743814, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743827, LCID, 4, 0),()),
		"PlaneBorderThickness": ((1610743821, LCID, 4, 0),()),
		"TickLabelAlignment": ((1610743843, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743835, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisY(DispatchBaseClass):
	'''Defines interface for the Y-Axis.'''
	CLSID = IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743846, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def SetMinMaxWithAnimation(self, dMin, dMax):
		'''
		Sets the minimum and maximum of visual range with animation effect.
		
		:param dMin: float
		:param dMax: float
		'''
		return self._oleobj_.InvokeTypes(1610743847, LCID, 1, (24, 0), ((5, 1), (5, 1)),dMin
			, dMax)


	def _get_AxisAlignment(self):
		return self._ApplyTypes_(*(1610743853, 2, (3, 0), (), "AxisAlignment", '{D64833C6-8709-3D8C-A476-65EBC90BADCA}'))
	def _get_AxisId(self):
		return self._ApplyTypes_(*(1610743820, 2, (8, 0), (), "AxisId", None))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743849, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743825, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "IsSelected", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743851, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743836, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743828, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743842, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743838, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743834, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743844, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743832, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_SeriesCollection(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743818, 2, (8, 0), (), "Title", None))
	def _get_TitleStyle(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'))
	def _get_Unit(self):
		return self._ApplyTypes_(*(1610743821, 2, (8, 0), (), "Unit", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743840, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisAlignment(self, value):
		if "AxisAlignment" in self.__dict__: self.__dict__["AxisAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743853, LCID, 4, 0) + (value,) + ()))
	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743849, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743851, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743842, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743844, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_Unit(self, value):
		if "Unit" in self.__dict__: self.__dict__["Unit"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743840, LCID, 4, 0) + (value,) + ()))

	AxisAlignment = property(_get_AxisAlignment, _set_AxisAlignment)
	'''
	Gets or sets the Y-Axis alignment.

	:type: recurdyn.Post.ChartYAxisAlignment
	'''
	AxisId = property(_get_AxisId, None)
	'''
	Gets the axis identifier.

	:type: str
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this axis is selected.

	:type: bool
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChartStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChartStyleMajorTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChartStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChartStyleMinorTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	SeriesCollection = property(_get_SeriesCollection, None)
	'''
	Gets the series collection related to this axis.

	:type: recurdyn.Post.ISeriesCollection
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChartStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	TitleStyle = property(_get_TitleStyle, None)
	'''
	Gets the title style.

	:type: recurdyn.Post.IChartStyleAxisTitle
	'''
	Unit = property(_get_Unit, _set_Unit)
	'''
	Gets or sets the unit of axis.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisAlignment": _set_AxisAlignment,
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_IsSelected": _set_IsSelected,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_Title": _set_Title,
		"_set_Unit": _set_Unit,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisAlignment": (1610743853, 2, (3, 0), (), "AxisAlignment", '{D64833C6-8709-3D8C-A476-65EBC90BADCA}'),
		"AxisId": (1610743820, 2, (8, 0), (), "AxisId", None),
		"AxisType": (1610743849, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743825, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743826, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743823, 2, (11, 0), (), "IsSelected", None),
		"LogarithmicBase": (1610743851, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743836, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743816, 2, (9, 0), (), "MajorGridLineStyle", '{DE759D88-66E1-4764-86B0-96D98197A346}'),
		"MajorTickLineStyle": (1610743814, 2, (9, 0), (), "MajorTickLineStyle", '{0425D327-6C6A-4081-8DBB-337984399370}'),
		"Max": (1610743828, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743842, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743830, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743838, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743817, 2, (9, 0), (), "MinorGridLineStyle", '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}'),
		"MinorTickLineStyle": (1610743815, 2, (9, 0), (), "MinorTickLineStyle", '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}'),
		"MinorsPerMajor": (1610743834, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743844, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743832, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"SeriesCollection": (1610743848, 2, (9, 0), (), "SeriesCollection", '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}'),
		"TickLabelStyle": (1610743813, 2, (9, 0), (), "TickLabelStyle", '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}'),
		"Title": (1610743818, 2, (8, 0), (), "Title", None),
		"TitleStyle": (1610743812, 2, (9, 0), (), "TitleStyle", '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}'),
		"Unit": (1610743821, 2, (8, 0), (), "Unit", None),
		"UseAutoTicks": (1610743840, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisAlignment": ((1610743853, LCID, 4, 0),()),
		"AxisType": ((1610743849, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743826, LCID, 4, 0),()),
		"IsSelected": ((1610743823, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743851, LCID, 4, 0),()),
		"MajorDelta": ((1610743836, LCID, 4, 0),()),
		"Max": ((1610743828, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743842, LCID, 4, 0),()),
		"Min": ((1610743830, LCID, 4, 0),()),
		"MinorDelta": ((1610743838, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743834, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743844, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743832, LCID, 4, 0),()),
		"Title": ((1610743818, LCID, 4, 0),()),
		"Unit": ((1610743821, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743840, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisY3D(DispatchBaseClass):
	'''Defines interface of the Chart3D axis.'''
	CLSID = IID('{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, Min, Max):
		'''
		Sets the minimum and maximum of visual range.
		
		:param Min: float
		:param Max: float
		'''
		return self._oleobj_.InvokeTypes(1610743850, LCID, 1, (24, 0), ((5, 1), (5, 1)),Min
			, Max)


	def _get_AxisPlaneBackground(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743841, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743837, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_PlaneBorderColor(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_PlaneBorderThickness(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "PlaneBorderThickness", None))
	def _get_TickLabelAlignment(self):
		return self._ApplyTypes_(*(1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743835, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_PlaneBorderThickness(self, value):
		if "PlaneBorderThickness" in self.__dict__: self.__dict__["PlaneBorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_TickLabelAlignment(self, value):
		if "TickLabelAlignment" in self.__dict__: self.__dict__["TickLabelAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))

	AxisPlaneBackground = property(_get_AxisPlaneBackground, None)
	'''
	Gets or sets the axis plane background.

	:type: recurdyn.Post.IColor
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChart3DStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChart3DStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	PlaneBorderColor = property(_get_PlaneBorderColor, None)
	'''
	Gets or sets the color of the plane border.

	:type: recurdyn.Post.IColor
	'''
	PlaneBorderThickness = property(_get_PlaneBorderThickness, _set_PlaneBorderThickness)
	'''
	Gets or sets the plane border thickness.

	:type: float
	'''
	TickLabelAlignment = property(_get_TickLabelAlignment, _set_TickLabelAlignment)
	'''
	Gets or sets the tick label alignment.

	:type: recurdyn.Post.TextAlignment3D
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChart3DStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_PlaneBorderThickness": _set_PlaneBorderThickness,
		"_set_TickLabelAlignment": _set_TickLabelAlignment,
		"_set_Title": _set_Title,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisPlaneBackground": (1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"AxisType": (1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743816, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LogarithmicBase": (1610743841, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743831, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'),
		"MajorTickLineStyle": (1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"Max": (1610743823, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743837, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743825, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743833, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'),
		"MinorTickLineStyle": (1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"MinorsPerMajor": (1610743829, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743814, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"PlaneBorderColor": (1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"PlaneBorderThickness": (1610743821, 2, (5, 0), (), "PlaneBorderThickness", None),
		"TickLabelAlignment": (1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'),
		"TickLabelStyle": (1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"UseAutoTicks": (1610743835, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisType": ((1610743839, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743816, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743841, LCID, 4, 0),()),
		"MajorDelta": ((1610743831, LCID, 4, 0),()),
		"Max": ((1610743823, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743837, LCID, 4, 0),()),
		"Min": ((1610743825, LCID, 4, 0),()),
		"MinorDelta": ((1610743833, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743814, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743827, LCID, 4, 0),()),
		"PlaneBorderThickness": ((1610743821, LCID, 4, 0),()),
		"TickLabelAlignment": ((1610743843, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743835, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartAxisZ3D(DispatchBaseClass):
	'''Defines interface of the Chart3D axis.'''
	CLSID = IID('{45B05150-78E3-4188-AA31-CC0DE518FF1F}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetMinMax(self, Min, Max):
		'''
		Sets the minimum and maximum of visual range.
		
		:param Min: float
		:param Max: float
		'''
		return self._oleobj_.InvokeTypes(1610743850, LCID, 1, (24, 0), ((5, 1), (5, 1)),Min
			, Max)


	def _get_AxisPlaneBackground(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_AxisType(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'))
	def _get_BandsColor(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMajorBands(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "DrawMajorBands", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LogarithmicBase(self):
		return self._ApplyTypes_(*(1610743841, 2, (5, 0), (), "LogarithmicBase", None))
	def _get_MajorDelta(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "MajorDelta", None))
	def _get_MajorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'))
	def _get_MajorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Max", None))
	def _get_MaxAutoTicks(self):
		return self._ApplyTypes_(*(1610743837, 2, (3, 0), (), "MaxAutoTicks", None))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "Min", None))
	def _get_MinorDelta(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "MinorDelta", None))
	def _get_MinorGridLineStyle(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'))
	def _get_MinorTickLineStyle(self):
		return self._ApplyTypes_(*(1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'))
	def _get_MinorsPerMajor(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "MinorsPerMajor", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormatting(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "NumberFormatting", None))
	def _get_NumberOfMajorTicks(self):
		return self._ApplyTypes_(*(1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None))
	def _get_PlaneBorderColor(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_PlaneBorderThickness(self):
		return self._ApplyTypes_(*(1610743821, 2, (5, 0), (), "PlaneBorderThickness", None))
	def _get_TickLabelAlignment(self):
		return self._ApplyTypes_(*(1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'))
	def _get_TickLabelStyle(self):
		return self._ApplyTypes_(*(1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'))
	def _get_Title(self):
		return self._ApplyTypes_(*(1610743812, 2, (8, 0), (), "Title", None))
	def _get_UseAutoTicks(self):
		return self._ApplyTypes_(*(1610743835, 2, (11, 0), (), "UseAutoTicks", None))

	def _set_AxisType(self, value):
		if "AxisType" in self.__dict__: self.__dict__["AxisType"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMajorBands(self, value):
		if "DrawMajorBands" in self.__dict__: self.__dict__["DrawMajorBands"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_LogarithmicBase(self, value):
		if "LogarithmicBase" in self.__dict__: self.__dict__["LogarithmicBase"] = value; return
		self._oleobj_.Invoke(*((1610743841, LCID, 4, 0) + (value,) + ()))
	def _set_MajorDelta(self, value):
		if "MajorDelta" in self.__dict__: self.__dict__["MajorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_Max(self, value):
		if "Max" in self.__dict__: self.__dict__["Max"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_MaxAutoTicks(self, value):
		if "MaxAutoTicks" in self.__dict__: self.__dict__["MaxAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Min(self, value):
		if "Min" in self.__dict__: self.__dict__["Min"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_MinorDelta(self, value):
		if "MinorDelta" in self.__dict__: self.__dict__["MinorDelta"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_MinorsPerMajor(self, value):
		if "MinorsPerMajor" in self.__dict__: self.__dict__["MinorsPerMajor"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormatting(self, value):
		if "NumberFormatting" in self.__dict__: self.__dict__["NumberFormatting"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_NumberOfMajorTicks(self, value):
		if "NumberOfMajorTicks" in self.__dict__: self.__dict__["NumberOfMajorTicks"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_PlaneBorderThickness(self, value):
		if "PlaneBorderThickness" in self.__dict__: self.__dict__["PlaneBorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_TickLabelAlignment(self, value):
		if "TickLabelAlignment" in self.__dict__: self.__dict__["TickLabelAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_Title(self, value):
		if "Title" in self.__dict__: self.__dict__["Title"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_UseAutoTicks(self, value):
		if "UseAutoTicks" in self.__dict__: self.__dict__["UseAutoTicks"] = value; return
		self._oleobj_.Invoke(*((1610743835, LCID, 4, 0) + (value,) + ()))

	AxisPlaneBackground = property(_get_AxisPlaneBackground, None)
	'''
	Gets or sets the axis plane background.

	:type: recurdyn.Post.IColor
	'''
	AxisType = property(_get_AxisType, _set_AxisType)
	'''
	Gets or sets the type of the axis.

	:type: recurdyn.Post.AxisType
	'''
	BandsColor = property(_get_BandsColor, None)
	'''
	Gets or sets the color of the bands.

	:type: recurdyn.Post.IColor
	'''
	DrawMajorBands = property(_get_DrawMajorBands, _set_DrawMajorBands)
	'''
	Gets or sets a value indicating whether draw major bands.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LogarithmicBase = property(_get_LogarithmicBase, _set_LogarithmicBase)
	'''
	Gets or sets the value of logarithmic base.

	:type: float
	'''
	MajorDelta = property(_get_MajorDelta, _set_MajorDelta)
	'''
	Gets or sets the major delta.

	:type: float
	'''
	MajorGridLineStyle = property(_get_MajorGridLineStyle, None)
	'''
	Gets the major grid line style.

	:type: recurdyn.Post.IChart3DStyleMajorGridLine
	'''
	MajorTickLineStyle = property(_get_MajorTickLineStyle, None)
	'''
	Gets the major tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	Max = property(_get_Max, _set_Max)
	'''
	Determines the maximum of the axis visual range.

	:type: float
	'''
	MaxAutoTicks = property(_get_MaxAutoTicks, _set_MaxAutoTicks)
	'''
	Gets or sets the maximum automatic ticks.

	:type: int
	'''
	Min = property(_get_Min, _set_Min)
	'''
	Determines the minimum of the axis visual range.

	:type: float
	'''
	MinorDelta = property(_get_MinorDelta, _set_MinorDelta)
	'''
	Gets or sets the minor delta.

	:type: float
	'''
	MinorGridLineStyle = property(_get_MinorGridLineStyle, None)
	'''
	Gets the minor grid line style.

	:type: recurdyn.Post.IChart3DStyleMinorGridLine
	'''
	MinorTickLineStyle = property(_get_MinorTickLineStyle, None)
	'''
	Gets the minor tick line style.

	:type: recurdyn.Post.IChart3DStyleTickLine
	'''
	MinorsPerMajor = property(_get_MinorsPerMajor, _set_MinorsPerMajor)
	'''
	Gets or sets the number of minor delta ticks per major Tick.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormatting = property(_get_NumberFormatting, _set_NumberFormatting)
	'''
	Gets or sets the number formatting string for tick labels.

	:type: str
	'''
	NumberOfMajorTicks = property(_get_NumberOfMajorTicks, _set_NumberOfMajorTicks)
	'''
	Gets or sets the number of major ticks.

	:type: int
	'''
	PlaneBorderColor = property(_get_PlaneBorderColor, None)
	'''
	Gets or sets the color of the plane border.

	:type: recurdyn.Post.IColor
	'''
	PlaneBorderThickness = property(_get_PlaneBorderThickness, _set_PlaneBorderThickness)
	'''
	Gets or sets the plane border thickness.

	:type: float
	'''
	TickLabelAlignment = property(_get_TickLabelAlignment, _set_TickLabelAlignment)
	'''
	Gets or sets the tick label alignment.

	:type: recurdyn.Post.TextAlignment3D
	'''
	TickLabelStyle = property(_get_TickLabelStyle, None)
	'''
	Gets the tick label style.

	:type: recurdyn.Post.IChart3DStyleTickLabel
	'''
	Title = property(_get_Title, _set_Title)
	'''
	Gets or sets the axis title.

	:type: str
	'''
	UseAutoTicks = property(_get_UseAutoTicks, _set_UseAutoTicks)
	'''
	Gets or sets value that indicates whether calculate ticks automatically.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_AxisType": _set_AxisType,
		"_set_DrawMajorBands": _set_DrawMajorBands,
		"_set_LogarithmicBase": _set_LogarithmicBase,
		"_set_MajorDelta": _set_MajorDelta,
		"_set_Max": _set_Max,
		"_set_MaxAutoTicks": _set_MaxAutoTicks,
		"_set_Min": _set_Min,
		"_set_MinorDelta": _set_MinorDelta,
		"_set_MinorsPerMajor": _set_MinorsPerMajor,
		"_set_Name": _set_Name,
		"_set_NumberFormatting": _set_NumberFormatting,
		"_set_NumberOfMajorTicks": _set_NumberOfMajorTicks,
		"_set_PlaneBorderThickness": _set_PlaneBorderThickness,
		"_set_TickLabelAlignment": _set_TickLabelAlignment,
		"_set_Title": _set_Title,
		"_set_UseAutoTicks": _set_UseAutoTicks,
	}
	_prop_map_get_ = {
		"AxisPlaneBackground": (1610743819, 2, (9, 0), (), "AxisPlaneBackground", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"AxisType": (1610743839, 2, (3, 0), (), "AxisType", '{5EC7015B-22FC-389F-90AE-A4E0D209BE83}'),
		"BandsColor": (1610743818, 2, (9, 0), (), "BandsColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMajorBands": (1610743816, 2, (11, 0), (), "DrawMajorBands", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LogarithmicBase": (1610743841, 2, (5, 0), (), "LogarithmicBase", None),
		"MajorDelta": (1610743831, 2, (5, 0), (), "MajorDelta", None),
		"MajorGridLineStyle": (1610743848, 2, (9, 0), (), "MajorGridLineStyle", '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}'),
		"MajorTickLineStyle": (1610743846, 2, (9, 0), (), "MajorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"Max": (1610743823, 2, (5, 0), (), "Max", None),
		"MaxAutoTicks": (1610743837, 2, (3, 0), (), "MaxAutoTicks", None),
		"Min": (1610743825, 2, (5, 0), (), "Min", None),
		"MinorDelta": (1610743833, 2, (5, 0), (), "MinorDelta", None),
		"MinorGridLineStyle": (1610743849, 2, (9, 0), (), "MinorGridLineStyle", '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}'),
		"MinorTickLineStyle": (1610743847, 2, (9, 0), (), "MinorTickLineStyle", '{B7273930-1505-42EA-BE86-F7A752B288B1}'),
		"MinorsPerMajor": (1610743829, 2, (3, 0), (), "MinorsPerMajor", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormatting": (1610743814, 2, (8, 0), (), "NumberFormatting", None),
		"NumberOfMajorTicks": (1610743827, 2, (3, 0), (), "NumberOfMajorTicks", None),
		"PlaneBorderColor": (1610743820, 2, (9, 0), (), "PlaneBorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"PlaneBorderThickness": (1610743821, 2, (5, 0), (), "PlaneBorderThickness", None),
		"TickLabelAlignment": (1610743843, 2, (3, 0), (), "TickLabelAlignment", '{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}'),
		"TickLabelStyle": (1610743845, 2, (9, 0), (), "TickLabelStyle", '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}'),
		"Title": (1610743812, 2, (8, 0), (), "Title", None),
		"UseAutoTicks": (1610743835, 2, (11, 0), (), "UseAutoTicks", None),
	}
	_prop_map_put_ = {
		"AxisType": ((1610743839, LCID, 4, 0),()),
		"DrawMajorBands": ((1610743816, LCID, 4, 0),()),
		"LogarithmicBase": ((1610743841, LCID, 4, 0),()),
		"MajorDelta": ((1610743831, LCID, 4, 0),()),
		"Max": ((1610743823, LCID, 4, 0),()),
		"MaxAutoTicks": ((1610743837, LCID, 4, 0),()),
		"Min": ((1610743825, LCID, 4, 0),()),
		"MinorDelta": ((1610743833, LCID, 4, 0),()),
		"MinorsPerMajor": ((1610743829, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormatting": ((1610743814, LCID, 4, 0),()),
		"NumberOfMajorTicks": ((1610743827, LCID, 4, 0),()),
		"PlaneBorderThickness": ((1610743821, LCID, 4, 0),()),
		"TickLabelAlignment": ((1610743843, LCID, 4, 0),()),
		"Title": ((1610743812, LCID, 4, 0),()),
		"UseAutoTicks": ((1610743835, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartBase(DispatchBaseClass):
	'''The base interface of all of chart entity.'''
	CLSID = IID('{691044DE-CC8C-4822-8E2F-736529CFC5A4}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DCameraPan(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DCameraPan.'''
	CLSID = IID('{6F928B9F-DB66-471E-A357-3FFF3222D73D}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_MouseSensitivity(self):
		return self._ApplyTypes_(*(1610743814, 2, (19, 0), (), "MouseSensitivity", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_MouseSensitivity(self, value):
		if "MouseSensitivity" in self.__dict__: self.__dict__["MouseSensitivity"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	MouseSensitivity = property(_get_MouseSensitivity, _set_MouseSensitivity)
	'''
	Gets or sets the mouse sensitivity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_MouseSensitivity": _set_MouseSensitivity,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"MouseSensitivity": (1610743814, 2, (19, 0), (), "MouseSensitivity", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"MouseSensitivity": ((1610743814, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DDragPan(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DDragPan.'''
	CLSID = IID('{493AFDB2-652C-389F-980B-034FAF450513}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DDragZoom(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DDragZoom.'''
	CLSID = IID('{B9020FC8-4D93-4784-85AB-F806DEF45984}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DLegend(DispatchBaseClass):
	'''Defines interface of the ChartModifierLegend. This interface provides the properties of legend on the chart.'''
	CLSID = IID('{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743828, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743829, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderThickness(self):
		return self._ApplyTypes_(*(1610743830, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'))
	def _get_DisplayMode(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743834, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743831, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743832, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743838, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743836, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HorizontalAlignment(self):
		return self._ApplyTypes_(*(1610743818, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Orientation(self):
		return self._ApplyTypes_(*(1610743826, 2, (3, 0), (), "Orientation", '{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}'))
	def _get_Position(self):
		return self._ApplyTypes_(*(1610743822, 2, (3, 0), (), "Position", '{CE9EFAA5-A83D-377F-87BE-477B40B29073}'))
	def _get_ShowCheckBox(self):
		return self._ApplyTypes_(*(1610743814, 2, (11, 0), (), "ShowCheckBox", None))
	def _get_ShowLegend(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "ShowLegend", None))
	def _get_ShowSeries(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "ShowSeries", None))
	def _get_Transparency(self):
		return self._ApplyTypes_(*(1610743840, 2, (5, 0), (), "Transparency", None))
	def _get_VerticalAlignment(self):
		return self._ApplyTypes_(*(1610743820, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'))

	def _set_DisplayMode(self, value):
		if "DisplayMode" in self.__dict__: self.__dict__["DisplayMode"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_HorizontalAlignment(self, value):
		if "HorizontalAlignment" in self.__dict__: self.__dict__["HorizontalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Orientation(self, value):
		if "Orientation" in self.__dict__: self.__dict__["Orientation"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_Position(self, value):
		if "Position" in self.__dict__: self.__dict__["Position"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_ShowCheckBox(self, value):
		if "ShowCheckBox" in self.__dict__: self.__dict__["ShowCheckBox"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_ShowLegend(self, value):
		if "ShowLegend" in self.__dict__: self.__dict__["ShowLegend"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_ShowSeries(self, value):
		if "ShowSeries" in self.__dict__: self.__dict__["ShowSeries"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_Transparency(self, value):
		if "Transparency" in self.__dict__: self.__dict__["Transparency"] = value; return
		self._oleobj_.Invoke(*((1610743840, LCID, 4, 0) + (value,) + ()))
	def _set_VerticalAlignment(self, value):
		if "VerticalAlignment" in self.__dict__: self.__dict__["VerticalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background of legend box.

	:type: recurdyn.Post.IColor
	'''
	BorderColor = property(_get_BorderColor, None)
	'''
	Gets or sets the border color of legend box.

	:type: recurdyn.Post.IColor
	'''
	BorderThickness = property(_get_BorderThickness, None)
	'''
	Gets or sets the border thickness of legend box.

	:type: recurdyn.Post.IThickness
	'''
	DisplayMode = property(_get_DisplayMode, _set_DisplayMode)
	'''
	Gets or sets the source mode for displaying series in legend box.

	:type: recurdyn.Post.SourceMode
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font family.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the font color.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the font size.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HorizontalAlignment = property(_get_HorizontalAlignment, _set_HorizontalAlignment)
	'''
	Gets or sets the horizontal alignement of the legend box.

	:type: recurdyn.Post.HorizontalAlignmentEx
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Orientation = property(_get_Orientation, _set_Orientation)
	'''
	Gets or sets the orientation of legend contents. The horizontal and vertical can be set.

	:type: recurdyn.Post.OrientationEx
	'''
	Position = property(_get_Position, _set_Position)
	'''
	Gets or sets the position of the legend box.

	:type: recurdyn.Post.LegendPosition
	'''
	ShowCheckBox = property(_get_ShowCheckBox, _set_ShowCheckBox)
	'''
	Gets or sets a value to show check box in the legend box.

	:type: bool
	'''
	ShowLegend = property(_get_ShowLegend, _set_ShowLegend)
	'''
	Gets or sets a value to show legend box.

	:type: bool
	'''
	ShowSeries = property(_get_ShowSeries, _set_ShowSeries)
	'''
	Gets or sets a value to display the series in the legend box.

	:type: bool
	'''
	Transparency = property(_get_Transparency, _set_Transparency)
	'''
	Gets or sets the opacity of the legend box.

	:type: float
	'''
	VerticalAlignment = property(_get_VerticalAlignment, _set_VerticalAlignment)
	'''
	Gets or sets the vertical alignment of the legend box.

	:type: recurdyn.Post.VerticalAlignmentEx
	'''

	_prop_map_set_function_ = {
		"_set_DisplayMode": _set_DisplayMode,
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_HorizontalAlignment": _set_HorizontalAlignment,
		"_set_Name": _set_Name,
		"_set_Orientation": _set_Orientation,
		"_set_Position": _set_Position,
		"_set_ShowCheckBox": _set_ShowCheckBox,
		"_set_ShowLegend": _set_ShowLegend,
		"_set_ShowSeries": _set_ShowSeries,
		"_set_Transparency": _set_Transparency,
		"_set_VerticalAlignment": _set_VerticalAlignment,
	}
	_prop_map_get_ = {
		"Background": (1610743828, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderColor": (1610743829, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderThickness": (1610743830, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'),
		"DisplayMode": (1610743824, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'),
		"Font": (1610743834, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743831, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743832, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743838, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743836, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HorizontalAlignment": (1610743818, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Orientation": (1610743826, 2, (3, 0), (), "Orientation", '{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}'),
		"Position": (1610743822, 2, (3, 0), (), "Position", '{CE9EFAA5-A83D-377F-87BE-477B40B29073}'),
		"ShowCheckBox": (1610743814, 2, (11, 0), (), "ShowCheckBox", None),
		"ShowLegend": (1610743812, 2, (11, 0), (), "ShowLegend", None),
		"ShowSeries": (1610743816, 2, (11, 0), (), "ShowSeries", None),
		"Transparency": (1610743840, 2, (5, 0), (), "Transparency", None),
		"VerticalAlignment": (1610743820, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'),
	}
	_prop_map_put_ = {
		"DisplayMode": ((1610743824, LCID, 4, 0),()),
		"Font": ((1610743834, LCID, 4, 0),()),
		"FontSize": ((1610743832, LCID, 4, 0),()),
		"FontStyle": ((1610743838, LCID, 4, 0),()),
		"FontWeight": ((1610743836, LCID, 4, 0),()),
		"HorizontalAlignment": ((1610743818, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Orientation": ((1610743826, LCID, 4, 0),()),
		"Position": ((1610743822, LCID, 4, 0),()),
		"ShowCheckBox": ((1610743814, LCID, 4, 0),()),
		"ShowLegend": ((1610743812, LCID, 4, 0),()),
		"ShowSeries": ((1610743816, LCID, 4, 0),()),
		"Transparency": ((1610743840, LCID, 4, 0),()),
		"VerticalAlignment": ((1610743820, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DMouseWheelZoom(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DMouseWheelZoom.'''
	CLSID = IID('{A31648C6-27E6-484C-9DFC-237F19FC855B}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DOrbit(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DOrbit.'''
	CLSID = IID('{0683DAA1-7363-4E57-86B8-B1592C9E2BFD}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modfier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DSectionViewer(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DSectionViewer.'''
	CLSID = IID('{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def UpdateSectionViewer(self):
		'''
		Updates the section viewer.
		'''
		return self._oleobj_.InvokeTypes(1610743853, LCID, 1, (24, 0), (),)


	def _get_BottomChartPhaseXAxisTitle(self):
		return self._ApplyTypes_(*(1610743822, 2, (8, 0), (), "BottomChartPhaseXAxisTitle", None))
	def _get_BottomChartPhaseYAxisTitle(self):
		return self._ApplyTypes_(*(1610743824, 2, (8, 0), (), "BottomChartPhaseYAxisTitle", None))
	def _get_BottomChartXAxisTitle(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "BottomChartXAxisTitle", None))
	def _get_BottomChartYAxisTitle(self):
		return self._ApplyTypes_(*(1610743816, 2, (8, 0), (), "BottomChartYAxisTitle", None))
	def _get_FrequencyBandWidth(self):
		return self._ApplyTypes_(*(1610743847, 2, (5, 0), (), "FrequencyBandWidth", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_LineColor(self):
		return self._ApplyTypes_(*(1610743836, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743839, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_LineThickness(self):
		return self._ApplyTypes_(*(1610743837, 2, (5, 0), (), "LineThickness", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_RightChartPhaseXAxisTitle(self):
		return self._ApplyTypes_(*(1610743826, 2, (8, 0), (), "RightChartPhaseXAxisTitle", None))
	def _get_RightChartPhaseYAxisTitle(self):
		return self._ApplyTypes_(*(1610743828, 2, (8, 0), (), "RightChartPhaseYAxisTitle", None))
	def _get_RightChartXAxisTitle(self):
		return self._ApplyTypes_(*(1610743818, 2, (8, 0), (), "RightChartXAxisTitle", None))
	def _get_RightChartYAxisTitle(self):
		return self._ApplyTypes_(*(1610743820, 2, (8, 0), (), "RightChartYAxisTitle", None))
	def _get_SectionChartAxisColor(self):
		return self._ApplyTypes_(*(1610743842, 2, (9, 0), (), "SectionChartAxisColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_SectionChartCurveColor(self):
		return self._ApplyTypes_(*(1610743841, 2, (9, 0), (), "SectionChartCurveColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_ShowSectionLine(self):
		return self._ApplyTypes_(*(1610743834, 2, (11, 0), (), "ShowSectionLine", None))
	def _get_UseVoldKalmanFilter(self):
		return self._ApplyTypes_(*(1610743843, 2, (11, 0), (), "UseVoldKalmanFilter", None))
	def _get_VKFilterNumberOfPole(self):
		return self._ApplyTypes_(*(1610743851, 2, (3, 0), (), "VKFilterNumberOfPole", '{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}'))
	def _get_VKFilterWeightingFactor(self):
		return self._ApplyTypes_(*(1610743849, 2, (5, 0), (), "VKFilterWeightingFactor", None))
	def _get_VKInputType(self):
		return self._ApplyTypes_(*(1610743845, 2, (3, 0), (), "VKInputType", '{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}'))
	def _get_XValue(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "XValue", None))
	def _get_ZValue(self):
		return self._ApplyTypes_(*(1610743832, 2, (5, 0), (), "ZValue", None))

	def _set_BottomChartPhaseXAxisTitle(self, value):
		if "BottomChartPhaseXAxisTitle" in self.__dict__: self.__dict__["BottomChartPhaseXAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_BottomChartPhaseYAxisTitle(self, value):
		if "BottomChartPhaseYAxisTitle" in self.__dict__: self.__dict__["BottomChartPhaseYAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_BottomChartXAxisTitle(self, value):
		if "BottomChartXAxisTitle" in self.__dict__: self.__dict__["BottomChartXAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_BottomChartYAxisTitle(self, value):
		if "BottomChartYAxisTitle" in self.__dict__: self.__dict__["BottomChartYAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_FrequencyBandWidth(self, value):
		if "FrequencyBandWidth" in self.__dict__: self.__dict__["FrequencyBandWidth"] = value; return
		self._oleobj_.Invoke(*((1610743847, LCID, 4, 0) + (value,) + ()))
	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743839, LCID, 4, 0) + (value,) + ()))
	def _set_LineThickness(self, value):
		if "LineThickness" in self.__dict__: self.__dict__["LineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743837, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_RightChartPhaseXAxisTitle(self, value):
		if "RightChartPhaseXAxisTitle" in self.__dict__: self.__dict__["RightChartPhaseXAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_RightChartPhaseYAxisTitle(self, value):
		if "RightChartPhaseYAxisTitle" in self.__dict__: self.__dict__["RightChartPhaseYAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_RightChartXAxisTitle(self, value):
		if "RightChartXAxisTitle" in self.__dict__: self.__dict__["RightChartXAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_RightChartYAxisTitle(self, value):
		if "RightChartYAxisTitle" in self.__dict__: self.__dict__["RightChartYAxisTitle"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_ShowSectionLine(self, value):
		if "ShowSectionLine" in self.__dict__: self.__dict__["ShowSectionLine"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_UseVoldKalmanFilter(self, value):
		if "UseVoldKalmanFilter" in self.__dict__: self.__dict__["UseVoldKalmanFilter"] = value; return
		self._oleobj_.Invoke(*((1610743843, LCID, 4, 0) + (value,) + ()))
	def _set_VKFilterNumberOfPole(self, value):
		if "VKFilterNumberOfPole" in self.__dict__: self.__dict__["VKFilterNumberOfPole"] = value; return
		self._oleobj_.Invoke(*((1610743851, LCID, 4, 0) + (value,) + ()))
	def _set_VKFilterWeightingFactor(self, value):
		if "VKFilterWeightingFactor" in self.__dict__: self.__dict__["VKFilterWeightingFactor"] = value; return
		self._oleobj_.Invoke(*((1610743849, LCID, 4, 0) + (value,) + ()))
	def _set_VKInputType(self, value):
		if "VKInputType" in self.__dict__: self.__dict__["VKInputType"] = value; return
		self._oleobj_.Invoke(*((1610743845, LCID, 4, 0) + (value,) + ()))
	def _set_XValue(self, value):
		if "XValue" in self.__dict__: self.__dict__["XValue"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_ZValue(self, value):
		if "ZValue" in self.__dict__: self.__dict__["ZValue"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))

	BottomChartPhaseXAxisTitle = property(_get_BottomChartPhaseXAxisTitle, _set_BottomChartPhaseXAxisTitle)
	'''
	Gets or sets the y-axis title of the bottom (phase) chart.

	:type: str
	'''
	BottomChartPhaseYAxisTitle = property(_get_BottomChartPhaseYAxisTitle, _set_BottomChartPhaseYAxisTitle)
	'''
	Gets or sets the y-axis title of the bottom (phase) chart.

	:type: str
	'''
	BottomChartXAxisTitle = property(_get_BottomChartXAxisTitle, _set_BottomChartXAxisTitle)
	'''
	Gets or sets the x-axis title of the bottom chart.

	:type: str
	'''
	BottomChartYAxisTitle = property(_get_BottomChartYAxisTitle, _set_BottomChartYAxisTitle)
	'''
	Gets or sets the y-axis title of the bottom chart.

	:type: str
	'''
	FrequencyBandWidth = property(_get_FrequencyBandWidth, _set_FrequencyBandWidth)
	'''
	Gets or sets the width of the frequency band for the VK-filter (Vold Kalman filter)

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	LineColor = property(_get_LineColor, None)
	'''
	Gets or sets the color of the section line.

	:type: recurdyn.Post.IColor
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the style of the section line.

	:type: recurdyn.Post.LineStyle
	'''
	LineThickness = property(_get_LineThickness, _set_LineThickness)
	'''
	Gets or sets the thickness of the section line.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	RightChartPhaseXAxisTitle = property(_get_RightChartPhaseXAxisTitle, _set_RightChartPhaseXAxisTitle)
	'''
	Gets or sets the x-axis title of the right (phase) chart.

	:type: str
	'''
	RightChartPhaseYAxisTitle = property(_get_RightChartPhaseYAxisTitle, _set_RightChartPhaseYAxisTitle)
	'''
	Gets or sets the y-axis title of the right (phase) chart.

	:type: str
	'''
	RightChartXAxisTitle = property(_get_RightChartXAxisTitle, _set_RightChartXAxisTitle)
	'''
	Gets or sets the x-axis title of the right chart.

	:type: str
	'''
	RightChartYAxisTitle = property(_get_RightChartYAxisTitle, _set_RightChartYAxisTitle)
	'''
	Gets or sets the y-axis title of the bottom chart.

	:type: str
	'''
	SectionChartAxisColor = property(_get_SectionChartAxisColor, None)
	'''
	Gets or sets the color of the section chart axis.

	:type: recurdyn.Post.IColor
	'''
	SectionChartCurveColor = property(_get_SectionChartCurveColor, None)
	'''
	Gets or sets the color of the section chart curve.

	:type: recurdyn.Post.IColor
	'''
	ShowSectionLine = property(_get_ShowSectionLine, _set_ShowSectionLine)
	'''
	Gets or sets a value indicating whether the section line is visible.

	:type: bool
	'''
	UseVoldKalmanFilter = property(_get_UseVoldKalmanFilter, _set_UseVoldKalmanFilter)
	'''
	Gets or sets a value indicating whether the VK-filter (Vold Kalman filter) is used.

	:type: bool
	'''
	VKFilterNumberOfPole = property(_get_VKFilterNumberOfPole, _set_VKFilterNumberOfPole)
	'''
	Gets or sets the number of pole for the VK-filter (Vold Kalman filter).

	:type: recurdyn.Post.VKFilterNumberOfPole
	'''
	VKFilterWeightingFactor = property(_get_VKFilterWeightingFactor, _set_VKFilterWeightingFactor)
	'''
	Gets or sets the weighting factor for the VK-filter (Vold Kalman filter).

	:type: float
	'''
	VKInputType = property(_get_VKInputType, _set_VKInputType)
	'''
	Gets or sets the weight type for the VK-filter (Vold Kalman filter).

	:type: recurdyn.Post.VKInputType
	'''
	XValue = property(_get_XValue, _set_XValue)
	'''
	Gets or sets the x value for the section viewer data.

	:type: float
	'''
	ZValue = property(_get_ZValue, _set_ZValue)
	'''
	Gets or sets the z value for the section viewer data.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_BottomChartPhaseXAxisTitle": _set_BottomChartPhaseXAxisTitle,
		"_set_BottomChartPhaseYAxisTitle": _set_BottomChartPhaseYAxisTitle,
		"_set_BottomChartXAxisTitle": _set_BottomChartXAxisTitle,
		"_set_BottomChartYAxisTitle": _set_BottomChartYAxisTitle,
		"_set_FrequencyBandWidth": _set_FrequencyBandWidth,
		"_set_IsEnabled": _set_IsEnabled,
		"_set_LineStyle": _set_LineStyle,
		"_set_LineThickness": _set_LineThickness,
		"_set_Name": _set_Name,
		"_set_RightChartPhaseXAxisTitle": _set_RightChartPhaseXAxisTitle,
		"_set_RightChartPhaseYAxisTitle": _set_RightChartPhaseYAxisTitle,
		"_set_RightChartXAxisTitle": _set_RightChartXAxisTitle,
		"_set_RightChartYAxisTitle": _set_RightChartYAxisTitle,
		"_set_ShowSectionLine": _set_ShowSectionLine,
		"_set_UseVoldKalmanFilter": _set_UseVoldKalmanFilter,
		"_set_VKFilterNumberOfPole": _set_VKFilterNumberOfPole,
		"_set_VKFilterWeightingFactor": _set_VKFilterWeightingFactor,
		"_set_VKInputType": _set_VKInputType,
		"_set_XValue": _set_XValue,
		"_set_ZValue": _set_ZValue,
	}
	_prop_map_get_ = {
		"BottomChartPhaseXAxisTitle": (1610743822, 2, (8, 0), (), "BottomChartPhaseXAxisTitle", None),
		"BottomChartPhaseYAxisTitle": (1610743824, 2, (8, 0), (), "BottomChartPhaseYAxisTitle", None),
		"BottomChartXAxisTitle": (1610743814, 2, (8, 0), (), "BottomChartXAxisTitle", None),
		"BottomChartYAxisTitle": (1610743816, 2, (8, 0), (), "BottomChartYAxisTitle", None),
		"FrequencyBandWidth": (1610743847, 2, (5, 0), (), "FrequencyBandWidth", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"LineColor": (1610743836, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineStyle": (1610743839, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"LineThickness": (1610743837, 2, (5, 0), (), "LineThickness", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"RightChartPhaseXAxisTitle": (1610743826, 2, (8, 0), (), "RightChartPhaseXAxisTitle", None),
		"RightChartPhaseYAxisTitle": (1610743828, 2, (8, 0), (), "RightChartPhaseYAxisTitle", None),
		"RightChartXAxisTitle": (1610743818, 2, (8, 0), (), "RightChartXAxisTitle", None),
		"RightChartYAxisTitle": (1610743820, 2, (8, 0), (), "RightChartYAxisTitle", None),
		"SectionChartAxisColor": (1610743842, 2, (9, 0), (), "SectionChartAxisColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"SectionChartCurveColor": (1610743841, 2, (9, 0), (), "SectionChartCurveColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"ShowSectionLine": (1610743834, 2, (11, 0), (), "ShowSectionLine", None),
		"UseVoldKalmanFilter": (1610743843, 2, (11, 0), (), "UseVoldKalmanFilter", None),
		"VKFilterNumberOfPole": (1610743851, 2, (3, 0), (), "VKFilterNumberOfPole", '{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}'),
		"VKFilterWeightingFactor": (1610743849, 2, (5, 0), (), "VKFilterWeightingFactor", None),
		"VKInputType": (1610743845, 2, (3, 0), (), "VKInputType", '{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}'),
		"XValue": (1610743830, 2, (5, 0), (), "XValue", None),
		"ZValue": (1610743832, 2, (5, 0), (), "ZValue", None),
	}
	_prop_map_put_ = {
		"BottomChartPhaseXAxisTitle": ((1610743822, LCID, 4, 0),()),
		"BottomChartPhaseYAxisTitle": ((1610743824, LCID, 4, 0),()),
		"BottomChartXAxisTitle": ((1610743814, LCID, 4, 0),()),
		"BottomChartYAxisTitle": ((1610743816, LCID, 4, 0),()),
		"FrequencyBandWidth": ((1610743847, LCID, 4, 0),()),
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"LineStyle": ((1610743839, LCID, 4, 0),()),
		"LineThickness": ((1610743837, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"RightChartPhaseXAxisTitle": ((1610743826, LCID, 4, 0),()),
		"RightChartPhaseYAxisTitle": ((1610743828, LCID, 4, 0),()),
		"RightChartXAxisTitle": ((1610743818, LCID, 4, 0),()),
		"RightChartYAxisTitle": ((1610743820, LCID, 4, 0),()),
		"ShowSectionLine": ((1610743834, LCID, 4, 0),()),
		"UseVoldKalmanFilter": ((1610743843, LCID, 4, 0),()),
		"VKFilterNumberOfPole": ((1610743851, LCID, 4, 0),()),
		"VKFilterWeightingFactor": ((1610743849, LCID, 4, 0),()),
		"VKInputType": ((1610743845, LCID, 4, 0),()),
		"XValue": ((1610743830, LCID, 4, 0),()),
		"ZValue": ((1610743832, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DTooltip(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DTooltip.'''
	CLSID = IID('{61409795-1BB1-4C04-B851-10B44F02F5A5}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifier3DZoomExtents(DispatchBaseClass):
	'''Defines interface of the ChartModifier3DZoomExtents.'''
	CLSID = IID('{80F5408B-1C65-4C5D-A014-5B2B34D970A9}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifierLegend(DispatchBaseClass):
	'''Defines interface of the ChartModifierLegend. This interface provides the properties of legend on the chart.'''
	CLSID = IID('{D6153141-938E-4E8A-B6E2-ED8EFE62E091}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743828, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743829, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderThickness(self):
		return self._ApplyTypes_(*(1610743830, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'))
	def _get_DisplayMode(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743834, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743831, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743832, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743838, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743836, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HorizontalAlignment(self):
		return self._ApplyTypes_(*(1610743818, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Orientation(self):
		return self._ApplyTypes_(*(1610743826, 2, (3, 0), (), "Orientation", '{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}'))
	def _get_Position(self):
		return self._ApplyTypes_(*(1610743822, 2, (3, 0), (), "Position", '{CE9EFAA5-A83D-377F-87BE-477B40B29073}'))
	def _get_ShowCheckBox(self):
		return self._ApplyTypes_(*(1610743814, 2, (11, 0), (), "ShowCheckBox", None))
	def _get_ShowLegend(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "ShowLegend", None))
	def _get_ShowSeries(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "ShowSeries", None))
	def _get_Transparency(self):
		return self._ApplyTypes_(*(1610743840, 2, (5, 0), (), "Transparency", None))
	def _get_VerticalAlignment(self):
		return self._ApplyTypes_(*(1610743820, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'))

	def _set_DisplayMode(self, value):
		if "DisplayMode" in self.__dict__: self.__dict__["DisplayMode"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))
	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_HorizontalAlignment(self, value):
		if "HorizontalAlignment" in self.__dict__: self.__dict__["HorizontalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Orientation(self, value):
		if "Orientation" in self.__dict__: self.__dict__["Orientation"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_Position(self, value):
		if "Position" in self.__dict__: self.__dict__["Position"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_ShowCheckBox(self, value):
		if "ShowCheckBox" in self.__dict__: self.__dict__["ShowCheckBox"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_ShowLegend(self, value):
		if "ShowLegend" in self.__dict__: self.__dict__["ShowLegend"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_ShowSeries(self, value):
		if "ShowSeries" in self.__dict__: self.__dict__["ShowSeries"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_Transparency(self, value):
		if "Transparency" in self.__dict__: self.__dict__["Transparency"] = value; return
		self._oleobj_.Invoke(*((1610743840, LCID, 4, 0) + (value,) + ()))
	def _set_VerticalAlignment(self, value):
		if "VerticalAlignment" in self.__dict__: self.__dict__["VerticalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background of legend box.

	:type: recurdyn.Post.IColor
	'''
	BorderColor = property(_get_BorderColor, None)
	'''
	Gets or sets the border color of legend box.

	:type: recurdyn.Post.IColor
	'''
	BorderThickness = property(_get_BorderThickness, None)
	'''
	Gets or sets the border thickness of legend box.

	:type: recurdyn.Post.IThickness
	'''
	DisplayMode = property(_get_DisplayMode, _set_DisplayMode)
	'''
	Gets or sets the source mode for displaying series in legend box.

	:type: recurdyn.Post.SourceMode
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font family.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the font color.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the font size.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HorizontalAlignment = property(_get_HorizontalAlignment, _set_HorizontalAlignment)
	'''
	Gets or sets the horizontal alignement of the legend box.

	:type: recurdyn.Post.HorizontalAlignmentEx
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Orientation = property(_get_Orientation, _set_Orientation)
	'''
	Gets or sets the orientation of legend contents. The horizontal and vertical can be set.

	:type: recurdyn.Post.OrientationEx
	'''
	Position = property(_get_Position, _set_Position)
	'''
	Gets or sets the position of the legend box.

	:type: recurdyn.Post.LegendPosition
	'''
	ShowCheckBox = property(_get_ShowCheckBox, _set_ShowCheckBox)
	'''
	Gets or sets a value to show check box in the legend box.

	:type: bool
	'''
	ShowLegend = property(_get_ShowLegend, _set_ShowLegend)
	'''
	Gets or sets a value to show legend box.

	:type: bool
	'''
	ShowSeries = property(_get_ShowSeries, _set_ShowSeries)
	'''
	Gets or sets a value to display the series on the legend box.

	:type: bool
	'''
	Transparency = property(_get_Transparency, _set_Transparency)
	'''
	Gets or sets the opacity of the legend box.

	:type: float
	'''
	VerticalAlignment = property(_get_VerticalAlignment, _set_VerticalAlignment)
	'''
	Gets or sets the vertical alignment of the legend box.

	:type: recurdyn.Post.VerticalAlignmentEx
	'''

	_prop_map_set_function_ = {
		"_set_DisplayMode": _set_DisplayMode,
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_HorizontalAlignment": _set_HorizontalAlignment,
		"_set_Name": _set_Name,
		"_set_Orientation": _set_Orientation,
		"_set_Position": _set_Position,
		"_set_ShowCheckBox": _set_ShowCheckBox,
		"_set_ShowLegend": _set_ShowLegend,
		"_set_ShowSeries": _set_ShowSeries,
		"_set_Transparency": _set_Transparency,
		"_set_VerticalAlignment": _set_VerticalAlignment,
	}
	_prop_map_get_ = {
		"Background": (1610743828, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderColor": (1610743829, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderThickness": (1610743830, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'),
		"DisplayMode": (1610743824, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'),
		"Font": (1610743834, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743831, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743832, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743838, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743836, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HorizontalAlignment": (1610743818, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Orientation": (1610743826, 2, (3, 0), (), "Orientation", '{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}'),
		"Position": (1610743822, 2, (3, 0), (), "Position", '{CE9EFAA5-A83D-377F-87BE-477B40B29073}'),
		"ShowCheckBox": (1610743814, 2, (11, 0), (), "ShowCheckBox", None),
		"ShowLegend": (1610743812, 2, (11, 0), (), "ShowLegend", None),
		"ShowSeries": (1610743816, 2, (11, 0), (), "ShowSeries", None),
		"Transparency": (1610743840, 2, (5, 0), (), "Transparency", None),
		"VerticalAlignment": (1610743820, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'),
	}
	_prop_map_put_ = {
		"DisplayMode": ((1610743824, LCID, 4, 0),()),
		"Font": ((1610743834, LCID, 4, 0),()),
		"FontSize": ((1610743832, LCID, 4, 0),()),
		"FontStyle": ((1610743838, LCID, 4, 0),()),
		"FontWeight": ((1610743836, LCID, 4, 0),()),
		"HorizontalAlignment": ((1610743818, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Orientation": ((1610743826, LCID, 4, 0),()),
		"Position": ((1610743822, LCID, 4, 0),()),
		"ShowCheckBox": ((1610743814, LCID, 4, 0),()),
		"ShowLegend": ((1610743812, LCID, 4, 0),()),
		"ShowSeries": ((1610743816, LCID, 4, 0),()),
		"Transparency": ((1610743840, LCID, 4, 0),()),
		"VerticalAlignment": ((1610743820, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifierSeriesInfo(DispatchBaseClass):
	'''Defines interface of the ChartModifierSeriesInfo. The IChartModifierSeriesInfo provides series information on the Chart view. This modifier displays minimum and maximum value of series on the Chart view area.'''
	CLSID = IID('{C79751D8-4907-4B9E-8169-311B17858169}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def UpdateInflectionPoint(self):
		'''
		Updates the inflection point.
		'''
		return self._oleobj_.InvokeTypes(1610743864, LCID, 1, (24, 0), (),)


	def _get_DeltaX(self):
		return self._ApplyTypes_(*(1610743849, 2, (5, 0), (), "DeltaX", None))
	def _get_DeltaY(self):
		return self._ApplyTypes_(*(1610743850, 2, (5, 0), (), "DeltaY", None))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743814, 2, (8, 0), (), "Font", None))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743816, 2, (5, 0), (), "FontSize", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Index(self):
		return self._ApplyTypes_(*(1610743828, 2, (3, 0), (), "Index", None))
	def _get_IndexAtLocalMax(self):
		return self._ApplyTypes_(*(1610743845, 2, (3, 0), (), "IndexAtLocalMax", None))
	def _get_IndexAtLocalMin(self):
		return self._ApplyTypes_(*(1610743842, 2, (3, 0), (), "IndexAtLocalMin", None))
	def _get_IndexAtMax(self):
		return self._ApplyTypes_(*(1610743835, 2, (3, 0), (), "IndexAtMax", None))
	def _get_IndexAtMin(self):
		return self._ApplyTypes_(*(1610743832, 2, (3, 0), (), "IndexAtMin", None))
	def _get_InflectionPoints(self):
		return self._ApplyTypes_(*(1610743854, 2, (8201, 0), (), "InflectionPoints", '{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}'))
	def _get_InflectionTolerance(self):
		return self._ApplyTypes_(*(1610743856, 2, (5, 0), (), "InflectionTolerance", None))
	def _get_InflectionValues(self):
		return self._ApplyTypes_(*(1610743855, 2, (8201, 0), (), "InflectionValues", '{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}'))
	def _get_InspectionLineColor(self):
		return self._ApplyTypes_(*(1610743822, 2, (9, 0), (), "InspectionLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_InspectlineValueX1(self):
		return self._ApplyTypes_(*(1610743858, 2, (5, 0), (), "InspectlineValueX1", None))
	def _get_InspectlineValueX2(self):
		return self._ApplyTypes_(*(1610743860, 2, (5, 0), (), "InspectlineValueX2", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_IsInspectLocalArea(self):
		return self._ApplyTypes_(*(1610743862, 2, (11, 0), (), "IsInspectLocalArea", None))
	def _get_LocalAverage(self):
		return self._ApplyTypes_(*(1610743838, 2, (5, 0), (), "LocalAverage", None))
	def _get_LocalDeltaX(self):
		return self._ApplyTypes_(*(1610743846, 2, (5, 0), (), "LocalDeltaX", None))
	def _get_LocalDeltaY(self):
		return self._ApplyTypes_(*(1610743847, 2, (5, 0), (), "LocalDeltaY", None))
	def _get_LocalMax(self):
		return self._ApplyTypes_(*(1610743843, 2, (5, 0), (), "LocalMax", None))
	def _get_LocalMin(self):
		return self._ApplyTypes_(*(1610743840, 2, (5, 0), (), "LocalMin", None))
	def _get_LocalRMS(self):
		return self._ApplyTypes_(*(1610743839, 2, (5, 0), (), "LocalRMS", None))
	def _get_LocalSlope(self):
		return self._ApplyTypes_(*(1610743848, 2, (5, 0), (), "LocalSlope", None))
	def _get_MarkerSize(self):
		return self._ApplyTypes_(*(1610743818, 2, (5, 0), (), "MarkerSize", None))
	def _get_Max(self):
		return self._ApplyTypes_(*(1610743833, 2, (5, 0), (), "Max", None))
	def _get_MaxColor(self):
		return self._ApplyTypes_(*(1610743821, 2, (9, 0), (), "MaxColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_Min(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "Min", None))
	def _get_MinColor(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "MinColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_MinMaxVisibility(self):
		return self._ApplyTypes_(*(1610743823, 2, (17, 0), (), "MinMaxVisibility", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_ShowInflectionPoints(self):
		return self._ApplyTypes_(*(1610743852, 2, (11, 0), (), "ShowInflectionPoints", None))
	def _get_Slope(self):
		return self._ApplyTypes_(*(1610743851, 2, (5, 0), (), "Slope", None))
	def _get_TargetSeriesLegend(self):
		return self._ApplyTypes_(*(1610743825, 2, (8, 0), (), "TargetSeriesLegend", None))
	def _get_TotalAverage(self):
		return self._ApplyTypes_(*(1610743836, 2, (5, 0), (), "TotalAverage", None))
	def _get_TotalIndex(self):
		return self._ApplyTypes_(*(1610743829, 2, (3, 0), (), "TotalIndex", None))
	def _get_TotalRMS(self):
		return self._ApplyTypes_(*(1610743837, 2, (5, 0), (), "TotalRMS", None))
	def _get_XValue(self):
		return self._ApplyTypes_(*(1610743826, 2, (5, 0), (), "XValue", None))
	def _get_XValueAtLocalMax(self):
		return self._ApplyTypes_(*(1610743844, 2, (5, 0), (), "XValueAtLocalMax", None))
	def _get_XValueAtLocalMin(self):
		return self._ApplyTypes_(*(1610743841, 2, (5, 0), (), "XValueAtLocalMin", None))
	def _get_XValueAtMax(self):
		return self._ApplyTypes_(*(1610743834, 2, (5, 0), (), "XValueAtMax", None))
	def _get_XValueAtMin(self):
		return self._ApplyTypes_(*(1610743831, 2, (5, 0), (), "XValueAtMin", None))
	def _get_YValue(self):
		return self._ApplyTypes_(*(1610743827, 2, (5, 0), (), "YValue", None))

	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_InflectionTolerance(self, value):
		if "InflectionTolerance" in self.__dict__: self.__dict__["InflectionTolerance"] = value; return
		self._oleobj_.Invoke(*((1610743856, LCID, 4, 0) + (value,) + ()))
	def _set_InspectlineValueX1(self, value):
		if "InspectlineValueX1" in self.__dict__: self.__dict__["InspectlineValueX1"] = value; return
		self._oleobj_.Invoke(*((1610743858, LCID, 4, 0) + (value,) + ()))
	def _set_InspectlineValueX2(self, value):
		if "InspectlineValueX2" in self.__dict__: self.__dict__["InspectlineValueX2"] = value; return
		self._oleobj_.Invoke(*((1610743860, LCID, 4, 0) + (value,) + ()))
	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_IsInspectLocalArea(self, value):
		if "IsInspectLocalArea" in self.__dict__: self.__dict__["IsInspectLocalArea"] = value; return
		self._oleobj_.Invoke(*((1610743862, LCID, 4, 0) + (value,) + ()))
	def _set_MarkerSize(self, value):
		if "MarkerSize" in self.__dict__: self.__dict__["MarkerSize"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_MinMaxVisibility(self, value):
		if "MinMaxVisibility" in self.__dict__: self.__dict__["MinMaxVisibility"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_ShowInflectionPoints(self, value):
		if "ShowInflectionPoints" in self.__dict__: self.__dict__["ShowInflectionPoints"] = value; return
		self._oleobj_.Invoke(*((1610743852, LCID, 4, 0) + (value,) + ()))

	DeltaX = property(_get_DeltaX, None)
	'''
	Gets the delta x.

	:type: float
	'''
	DeltaY = property(_get_DeltaY, None)
	'''
	Gets the delta y.

	:type: float
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font.

	:type: str
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Index = property(_get_Index, None)
	'''
	Gets the index.

	:type: int
	'''
	IndexAtLocalMax = property(_get_IndexAtLocalMax, None)
	'''
	Gets the index at local maximum.

	:type: int
	'''
	IndexAtLocalMin = property(_get_IndexAtLocalMin, None)
	'''
	Gets the index at local minimum.

	:type: int
	'''
	IndexAtMax = property(_get_IndexAtMax, None)
	'''
	Gets the index at maximum.

	:type: int
	'''
	IndexAtMin = property(_get_IndexAtMin, None)
	'''
	Gets the index at minimum.

	:type: int
	'''
	InflectionPoints = property(_get_InflectionPoints, None)
	'''
	Gets the inflection points.

	:type: recurdyn.Post.IPoint
	'''
	InflectionTolerance = property(_get_InflectionTolerance, _set_InflectionTolerance)
	'''
	Gets or sets the inflection tolerance.

	:type: float
	'''
	InflectionValues = property(_get_InflectionValues, None)
	'''
	Gets the inflection values.

	:type: recurdyn.Post.IPoint
	'''
	InspectionLineColor = property(_get_InspectionLineColor, None)
	'''
	Gets or sets a color indicating the inspection lines.

	:type: recurdyn.Post.IColor
	'''
	InspectlineValueX1 = property(_get_InspectlineValueX1, _set_InspectlineValueX1)
	'''
	Gets or sets the inspectline value x1.

	:type: float
	'''
	InspectlineValueX2 = property(_get_InspectlineValueX2, _set_InspectlineValueX2)
	'''
	Gets or sets the inspectline value x2.

	:type: float
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	IsInspectLocalArea = property(_get_IsInspectLocalArea, _set_IsInspectLocalArea)
	'''
	Gets or sets a value indicating whether inspection area is local.

	:type: bool
	'''
	LocalAverage = property(_get_LocalAverage, None)
	'''
	Gets the local average.

	:type: float
	'''
	LocalDeltaX = property(_get_LocalDeltaX, None)
	'''
	Gets the local delta x.

	:type: float
	'''
	LocalDeltaY = property(_get_LocalDeltaY, None)
	'''
	Gets the local delta y.

	:type: float
	'''
	LocalMax = property(_get_LocalMax, None)
	'''
	Gets the local maximum.

	:type: float
	'''
	LocalMin = property(_get_LocalMin, None)
	'''
	Gets the local minimum.

	:type: float
	'''
	LocalRMS = property(_get_LocalRMS, None)
	'''
	Gets the local RMS.

	:type: float
	'''
	LocalSlope = property(_get_LocalSlope, None)
	'''
	Gets the local slope.

	:type: float
	'''
	MarkerSize = property(_get_MarkerSize, _set_MarkerSize)
	'''
	Gets or sets the size of the marker.

	:type: float
	'''
	Max = property(_get_Max, None)
	'''
	Determines the maximum of the parameters.

	:type: float
	'''
	MaxColor = property(_get_MaxColor, None)
	'''
	Gets or sets a color indicating whether maximum value of series.

	:type: recurdyn.Post.IColor
	'''
	Min = property(_get_Min, None)
	'''
	Gets the minimum of the selected series.

	:type: float
	'''
	MinColor = property(_get_MinColor, None)
	'''
	Gets or sets a color indicating whether minimum value of series.

	:type: recurdyn.Post.IColor
	'''
	MinMaxVisibility = property(_get_MinMaxVisibility, _set_MinMaxVisibility)
	'''
	Gets or sets the visibility of min/max tooltip.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	ShowInflectionPoints = property(_get_ShowInflectionPoints, _set_ShowInflectionPoints)
	'''
	Gets or sets a value indicating whether inflection points is shown.

	:type: bool
	'''
	Slope = property(_get_Slope, None)
	'''
	Gets the slope.

	:type: float
	'''
	TargetSeriesLegend = property(_get_TargetSeriesLegend, None)
	'''
	Gets the legend of target series.

	:type: str
	'''
	TotalAverage = property(_get_TotalAverage, None)
	'''
	Gets the total average.

	:type: float
	'''
	TotalIndex = property(_get_TotalIndex, None)
	'''
	Gets the total index of the selected series.

	:type: int
	'''
	TotalRMS = property(_get_TotalRMS, None)
	'''
	Gets the total RMS.

	:type: float
	'''
	XValue = property(_get_XValue, None)
	'''
	Gets the x value.

	:type: float
	'''
	XValueAtLocalMax = property(_get_XValueAtLocalMax, None)
	'''
	Gets the x value at local maximum.

	:type: float
	'''
	XValueAtLocalMin = property(_get_XValueAtLocalMin, None)
	'''
	Gets the x value at local minimum.

	:type: float
	'''
	XValueAtMax = property(_get_XValueAtMax, None)
	'''
	Gets the x value at maximum.

	:type: float
	'''
	XValueAtMin = property(_get_XValueAtMin, None)
	'''
	Gets the x value at minimum.

	:type: float
	'''
	YValue = property(_get_YValue, None)
	'''
	Gets the y value.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_InflectionTolerance": _set_InflectionTolerance,
		"_set_InspectlineValueX1": _set_InspectlineValueX1,
		"_set_InspectlineValueX2": _set_InspectlineValueX2,
		"_set_IsEnabled": _set_IsEnabled,
		"_set_IsInspectLocalArea": _set_IsInspectLocalArea,
		"_set_MarkerSize": _set_MarkerSize,
		"_set_MinMaxVisibility": _set_MinMaxVisibility,
		"_set_Name": _set_Name,
		"_set_ShowInflectionPoints": _set_ShowInflectionPoints,
	}
	_prop_map_get_ = {
		"DeltaX": (1610743849, 2, (5, 0), (), "DeltaX", None),
		"DeltaY": (1610743850, 2, (5, 0), (), "DeltaY", None),
		"Font": (1610743814, 2, (8, 0), (), "Font", None),
		"FontSize": (1610743816, 2, (5, 0), (), "FontSize", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Index": (1610743828, 2, (3, 0), (), "Index", None),
		"IndexAtLocalMax": (1610743845, 2, (3, 0), (), "IndexAtLocalMax", None),
		"IndexAtLocalMin": (1610743842, 2, (3, 0), (), "IndexAtLocalMin", None),
		"IndexAtMax": (1610743835, 2, (3, 0), (), "IndexAtMax", None),
		"IndexAtMin": (1610743832, 2, (3, 0), (), "IndexAtMin", None),
		"InflectionPoints": (1610743854, 2, (8201, 0), (), "InflectionPoints", '{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}'),
		"InflectionTolerance": (1610743856, 2, (5, 0), (), "InflectionTolerance", None),
		"InflectionValues": (1610743855, 2, (8201, 0), (), "InflectionValues", '{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}'),
		"InspectionLineColor": (1610743822, 2, (9, 0), (), "InspectionLineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"InspectlineValueX1": (1610743858, 2, (5, 0), (), "InspectlineValueX1", None),
		"InspectlineValueX2": (1610743860, 2, (5, 0), (), "InspectlineValueX2", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"IsInspectLocalArea": (1610743862, 2, (11, 0), (), "IsInspectLocalArea", None),
		"LocalAverage": (1610743838, 2, (5, 0), (), "LocalAverage", None),
		"LocalDeltaX": (1610743846, 2, (5, 0), (), "LocalDeltaX", None),
		"LocalDeltaY": (1610743847, 2, (5, 0), (), "LocalDeltaY", None),
		"LocalMax": (1610743843, 2, (5, 0), (), "LocalMax", None),
		"LocalMin": (1610743840, 2, (5, 0), (), "LocalMin", None),
		"LocalRMS": (1610743839, 2, (5, 0), (), "LocalRMS", None),
		"LocalSlope": (1610743848, 2, (5, 0), (), "LocalSlope", None),
		"MarkerSize": (1610743818, 2, (5, 0), (), "MarkerSize", None),
		"Max": (1610743833, 2, (5, 0), (), "Max", None),
		"MaxColor": (1610743821, 2, (9, 0), (), "MaxColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"Min": (1610743830, 2, (5, 0), (), "Min", None),
		"MinColor": (1610743820, 2, (9, 0), (), "MinColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"MinMaxVisibility": (1610743823, 2, (17, 0), (), "MinMaxVisibility", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"ShowInflectionPoints": (1610743852, 2, (11, 0), (), "ShowInflectionPoints", None),
		"Slope": (1610743851, 2, (5, 0), (), "Slope", None),
		"TargetSeriesLegend": (1610743825, 2, (8, 0), (), "TargetSeriesLegend", None),
		"TotalAverage": (1610743836, 2, (5, 0), (), "TotalAverage", None),
		"TotalIndex": (1610743829, 2, (3, 0), (), "TotalIndex", None),
		"TotalRMS": (1610743837, 2, (5, 0), (), "TotalRMS", None),
		"XValue": (1610743826, 2, (5, 0), (), "XValue", None),
		"XValueAtLocalMax": (1610743844, 2, (5, 0), (), "XValueAtLocalMax", None),
		"XValueAtLocalMin": (1610743841, 2, (5, 0), (), "XValueAtLocalMin", None),
		"XValueAtMax": (1610743834, 2, (5, 0), (), "XValueAtMax", None),
		"XValueAtMin": (1610743831, 2, (5, 0), (), "XValueAtMin", None),
		"YValue": (1610743827, 2, (5, 0), (), "YValue", None),
	}
	_prop_map_put_ = {
		"Font": ((1610743814, LCID, 4, 0),()),
		"FontSize": ((1610743816, LCID, 4, 0),()),
		"InflectionTolerance": ((1610743856, LCID, 4, 0),()),
		"InspectlineValueX1": ((1610743858, LCID, 4, 0),()),
		"InspectlineValueX2": ((1610743860, LCID, 4, 0),()),
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"IsInspectLocalArea": ((1610743862, LCID, 4, 0),()),
		"MarkerSize": ((1610743818, LCID, 4, 0),()),
		"MinMaxVisibility": ((1610743823, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"ShowInflectionPoints": ((1610743852, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifierTimeLine(DispatchBaseClass):
	'''Defines interface of the ChartModifierTimeLine. The IChartModifierTimeLine provides drawing of vertical slice based on collection of ChartTimeLineAnnotation. The vertical slice will be moved by playing animation.'''
	CLSID = IID('{7440FFE1-9009-44ED-90D1-6B7A9143AB66}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_ShowTooltip(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "ShowTooltip", None))
	def _get_TimeLineStyle(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "TimeLineStyle", '{496406A4-661D-4FA1-A778-FDA86C1C1DA4}'))
	def _get_TooltipEffect(self):
		return self._ApplyTypes_(*(1610743819, 2, (11, 0), (), "TooltipEffect", None))
	def _get_TooltipTransparency(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "TooltipTransparency", None))

	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_ShowTooltip(self, value):
		if "ShowTooltip" in self.__dict__: self.__dict__["ShowTooltip"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_TooltipEffect(self, value):
		if "TooltipEffect" in self.__dict__: self.__dict__["TooltipEffect"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_TooltipTransparency(self, value):
		if "TooltipTransparency" in self.__dict__: self.__dict__["TooltipTransparency"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	ShowTooltip = property(_get_ShowTooltip, _set_ShowTooltip)
	'''
	Gets or sets a value indicating whether show tooltip.

	:type: bool
	'''
	TimeLineStyle = property(_get_TimeLineStyle, None)
	'''
	Gets the time line style.

	:type: recurdyn.Post.IChartTimeLineAnnotationStyle
	'''
	TooltipEffect = property(_get_TooltipEffect, _set_TooltipEffect)
	'''
	Gets or sets a value indicating whether tooltip effect.

	:type: bool
	'''
	TooltipTransparency = property(_get_TooltipTransparency, _set_TooltipTransparency)
	'''
	Gets or sets the tooltip opacity.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
		"_set_ShowTooltip": _set_ShowTooltip,
		"_set_TooltipEffect": _set_TooltipEffect,
		"_set_TooltipTransparency": _set_TooltipTransparency,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"ShowTooltip": (1610743817, 2, (11, 0), (), "ShowTooltip", None),
		"TimeLineStyle": (1610743814, 2, (9, 0), (), "TimeLineStyle", '{496406A4-661D-4FA1-A778-FDA86C1C1DA4}'),
		"TooltipEffect": (1610743819, 2, (11, 0), (), "TooltipEffect", None),
		"TooltipTransparency": (1610743815, 2, (5, 0), (), "TooltipTransparency", None),
	}
	_prop_map_put_ = {
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"ShowTooltip": ((1610743817, LCID, 4, 0),()),
		"TooltipEffect": ((1610743819, LCID, 4, 0),()),
		"TooltipTransparency": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartModifierTooltip(DispatchBaseClass):
	'''Defines interface of ChartModifierTooltipEx.'''
	CLSID = IID('{FD63AE8C-75EF-437B-AB41-0654C94D7F03}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_DisplayMode(self):
		return self._ApplyTypes_(*(1610743822, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743814, 2, (5, 0), (), "FontSize", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsEnabled(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "IsEnabled", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_NumberFormat(self):
		return self._ApplyTypes_(*(1610743816, 2, (8, 0), (), "NumberFormat", None))
	def _get_ShowAxisLabels(self):
		return self._ApplyTypes_(*(1610743818, 2, (11, 0), (), "ShowAxisLabels", None))
	def _get_ShowEffect(self):
		return self._ApplyTypes_(*(1610743828, 2, (11, 0), (), "ShowEffect", None))
	def _get_ShowSeriesName(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "ShowSeriesName", None))
	def _get_ShowTooltip(self):
		return self._ApplyTypes_(*(1610743820, 2, (11, 0), (), "ShowTooltip", None))
	def _get_TooltipPlacement(self):
		return self._ApplyTypes_(*(1610743834, 2, (3, 0), (), "TooltipPlacement", '{50C2AC1A-FBF1-38FD-85ED-BD51382BAE52}'))
	def _get_TooltipStyle(self):
		return self._ApplyTypes_(*(1610743832, 2, (3, 0), (), "TooltipStyle", '{0F8CEAC8-36FC-3EE2-B93D-CAEFC25C483A}'))
	def _get_Transparency(self):
		return self._ApplyTypes_(*(1610743830, 2, (5, 0), (), "Transparency", None))
	def _get_UseInterpolation(self):
		return self._ApplyTypes_(*(1610743824, 2, (11, 0), (), "UseInterpolation", None))

	def _set_DisplayMode(self, value):
		if "DisplayMode" in self.__dict__: self.__dict__["DisplayMode"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_IsEnabled(self, value):
		if "IsEnabled" in self.__dict__: self.__dict__["IsEnabled"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_NumberFormat(self, value):
		if "NumberFormat" in self.__dict__: self.__dict__["NumberFormat"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_ShowAxisLabels(self, value):
		if "ShowAxisLabels" in self.__dict__: self.__dict__["ShowAxisLabels"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_ShowEffect(self, value):
		if "ShowEffect" in self.__dict__: self.__dict__["ShowEffect"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 4, 0) + (value,) + ()))
	def _set_ShowSeriesName(self, value):
		if "ShowSeriesName" in self.__dict__: self.__dict__["ShowSeriesName"] = value; return
		self._oleobj_.Invoke(*((1610743826, LCID, 4, 0) + (value,) + ()))
	def _set_ShowTooltip(self, value):
		if "ShowTooltip" in self.__dict__: self.__dict__["ShowTooltip"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_TooltipPlacement(self, value):
		if "TooltipPlacement" in self.__dict__: self.__dict__["TooltipPlacement"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_TooltipStyle(self, value):
		if "TooltipStyle" in self.__dict__: self.__dict__["TooltipStyle"] = value; return
		self._oleobj_.Invoke(*((1610743832, LCID, 4, 0) + (value,) + ()))
	def _set_Transparency(self, value):
		if "Transparency" in self.__dict__: self.__dict__["Transparency"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))
	def _set_UseInterpolation(self, value):
		if "UseInterpolation" in self.__dict__: self.__dict__["UseInterpolation"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))

	DisplayMode = property(_get_DisplayMode, _set_DisplayMode)
	'''
	Gets or sets type of series on this modifier is performed

	:type: recurdyn.Post.SourceMode
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the font size of tooltip.

	:type: float
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsEnabled = property(_get_IsEnabled, _set_IsEnabled)
	'''
	Gets or sets a value indicating whether this modifier is enabled.

	:type: bool
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	NumberFormat = property(_get_NumberFormat, _set_NumberFormat)
	'''
	Gets or sets the number format of the text in tooltip.

	:type: str
	'''
	ShowAxisLabels = property(_get_ShowAxisLabels, _set_ShowAxisLabels)
	'''
	Gets or sets a value indicating whether show axis labels.

	:type: bool
	'''
	ShowEffect = property(_get_ShowEffect, _set_ShowEffect)
	'''
	Gets or sets a value indicating whether show tooltip box effect.

	:type: bool
	'''
	ShowSeriesName = property(_get_ShowSeriesName, _set_ShowSeriesName)
	'''
	Gets or sets a value indicating whether show series names.

	:type: bool
	'''
	ShowTooltip = property(_get_ShowTooltip, _set_ShowTooltip)
	'''
	Gets or sets a value indicating whether show tooltip.

	:type: bool
	'''
	TooltipPlacement = property(_get_TooltipPlacement, _set_TooltipPlacement)
	'''
	Gets or sets the tooltip placement (Left, Right).

	:type: recurdyn.Post.TooltipPlacement
	'''
	TooltipStyle = property(_get_TooltipStyle, _set_TooltipStyle)
	'''
	Gets or sets the tooltip style. The styles of the tooltip are tooltip control and pop-up.

	:type: recurdyn.Post.TooltipStyle
	'''
	Transparency = property(_get_Transparency, _set_Transparency)
	'''
	Gets or sets the opacity for the tooltip box.

	:type: float
	'''
	UseInterpolation = property(_get_UseInterpolation, _set_UseInterpolation)
	'''
	Gets or sets whether the interaction should use interpolation

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_DisplayMode": _set_DisplayMode,
		"_set_FontSize": _set_FontSize,
		"_set_IsEnabled": _set_IsEnabled,
		"_set_Name": _set_Name,
		"_set_NumberFormat": _set_NumberFormat,
		"_set_ShowAxisLabels": _set_ShowAxisLabels,
		"_set_ShowEffect": _set_ShowEffect,
		"_set_ShowSeriesName": _set_ShowSeriesName,
		"_set_ShowTooltip": _set_ShowTooltip,
		"_set_TooltipPlacement": _set_TooltipPlacement,
		"_set_TooltipStyle": _set_TooltipStyle,
		"_set_Transparency": _set_Transparency,
		"_set_UseInterpolation": _set_UseInterpolation,
	}
	_prop_map_get_ = {
		"DisplayMode": (1610743822, 2, (3, 0), (), "DisplayMode", '{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}'),
		"FontSize": (1610743814, 2, (5, 0), (), "FontSize", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsEnabled": (1610743812, 2, (11, 0), (), "IsEnabled", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"NumberFormat": (1610743816, 2, (8, 0), (), "NumberFormat", None),
		"ShowAxisLabels": (1610743818, 2, (11, 0), (), "ShowAxisLabels", None),
		"ShowEffect": (1610743828, 2, (11, 0), (), "ShowEffect", None),
		"ShowSeriesName": (1610743826, 2, (11, 0), (), "ShowSeriesName", None),
		"ShowTooltip": (1610743820, 2, (11, 0), (), "ShowTooltip", None),
		"TooltipPlacement": (1610743834, 2, (3, 0), (), "TooltipPlacement", '{50C2AC1A-FBF1-38FD-85ED-BD51382BAE52}'),
		"TooltipStyle": (1610743832, 2, (3, 0), (), "TooltipStyle", '{0F8CEAC8-36FC-3EE2-B93D-CAEFC25C483A}'),
		"Transparency": (1610743830, 2, (5, 0), (), "Transparency", None),
		"UseInterpolation": (1610743824, 2, (11, 0), (), "UseInterpolation", None),
	}
	_prop_map_put_ = {
		"DisplayMode": ((1610743822, LCID, 4, 0),()),
		"FontSize": ((1610743814, LCID, 4, 0),()),
		"IsEnabled": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"NumberFormat": ((1610743816, LCID, 4, 0),()),
		"ShowAxisLabels": ((1610743818, LCID, 4, 0),()),
		"ShowEffect": ((1610743828, LCID, 4, 0),()),
		"ShowSeriesName": ((1610743826, LCID, 4, 0),()),
		"ShowTooltip": ((1610743820, LCID, 4, 0),()),
		"TooltipPlacement": ((1610743834, LCID, 4, 0),()),
		"TooltipStyle": ((1610743832, LCID, 4, 0),()),
		"Transparency": ((1610743830, LCID, 4, 0),()),
		"UseInterpolation": ((1610743824, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartPalette(DispatchBaseClass):
	'''The IChartPalette provides a palette indicating where the color of each series.'''
	CLSID = IID('{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_CurrentColor(self):
		return self._ApplyTypes_(*(1610743811, 2, (19, 0), (), "CurrentColor", None))
	def _get_CustomPalette(self):
		return self._ApplyTypes_(*(1610743813, 2, (8211, 0), (), "CustomPalette", None))
	def _get_Palette(self):
		return self._ApplyTypes_(*(1610743812, 2, (8211, 0), (), "Palette", None))
	def _get_PaletteCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (8211, 0), (), "PaletteCollection", None))
	def _get_PaletteColorSet(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "PaletteColorSet", '{348CB393-4BA9-3E8E-9E4C-07518B07A389}'))

	def _set_CustomPalette(self, value):
		if "CustomPalette" in self.__dict__: self.__dict__["CustomPalette"] = value; return
		variantValue = win32com.client.VARIANT(8211, value)
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (variantValue,) + ()))
	def _set_PaletteColorSet(self, value):
		if "PaletteColorSet" in self.__dict__: self.__dict__["PaletteColorSet"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	CurrentColor = property(_get_CurrentColor, None)
	'''
	Gets the color of the current in palette.

	:type: int
	'''
	CustomPalette = property(_get_CustomPalette, _set_CustomPalette)
	'''
	Gets or sets the custom color set.

	:type: list[int]
	'''
	Palette = property(_get_Palette, None)
	'''
	Gets the palette. This palette gets from the PaletteCollection which selected by the PaletteColorSet. If the PaletteColorSet sets to custom, this palette will get the color set from the CustomPalette property.

	:type: list[int]
	'''
	PaletteCollection = property(_get_PaletteCollection, None)
	'''
	Gets the palette collection.

	:type: list[int]
	'''
	PaletteColorSet = property(_get_PaletteColorSet, _set_PaletteColorSet)
	'''
	Gets or sets the palette color set.

	:type: recurdyn.Post.PaletteColorSetBy
	'''

	_prop_map_set_function_ = {
		"_set_CustomPalette": _set_CustomPalette,
		"_set_PaletteColorSet": _set_PaletteColorSet,
	}
	_prop_map_get_ = {
		"CurrentColor": (1610743811, 2, (19, 0), (), "CurrentColor", None),
		"CustomPalette": (1610743813, 2, (8211, 0), (), "CustomPalette", None),
		"Palette": (1610743812, 2, (8211, 0), (), "Palette", None),
		"PaletteCollection": (1610743810, 2, (8211, 0), (), "PaletteCollection", None),
		"PaletteColorSet": (1610743808, 2, (3, 0), (), "PaletteColorSet", '{348CB393-4BA9-3E8E-9E4C-07518B07A389}'),
	}
	_prop_map_put_ = {
		"CustomPalette": ((1610743813, LCID, 4, 0),()),
		"PaletteColorSet": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartPointMarker(DispatchBaseClass):
	'''Defines interface for the PointMarker'''
	CLSID = IID('{A57DEE8B-3147-4E83-A188-65C5A265F0D5}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderThickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "BorderThickness", None))
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_Height(self):
		return self._ApplyTypes_(*(1610743820, 2, (5, 0), (), "Height", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_MarkerType(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "MarkerType", '{CBCA3731-E91A-3899-BFD7-522BA7D53173}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Width(self):
		return self._ApplyTypes_(*(1610743818, 2, (5, 0), (), "Width", None))

	def _set_BorderThickness(self, value):
		if "BorderThickness" in self.__dict__: self.__dict__["BorderThickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Height(self, value):
		if "Height" in self.__dict__: self.__dict__["Height"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))
	def _set_MarkerType(self, value):
		if "MarkerType" in self.__dict__: self.__dict__["MarkerType"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Width(self, value):
		if "Width" in self.__dict__: self.__dict__["Width"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))

	BorderColor = property(_get_BorderColor, None)
	'''
	Gets or sets the color of the border.

	:type: recurdyn.Post.IColor
	'''
	BorderThickness = property(_get_BorderThickness, _set_BorderThickness)
	'''
	Gets or sets the border thickness.

	:type: float
	'''
	Color = property(_get_Color, None)
	'''
	Gets or sets the color inside point marker.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	Height = property(_get_Height, _set_Height)
	'''
	Gets or sets the height.

	:type: float
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	MarkerType = property(_get_MarkerType, _set_MarkerType)
	'''
	Gets or sets the type of the marker.

	:type: recurdyn.Post.PointMarkerType
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Width = property(_get_Width, _set_Width)
	'''
	Gets or sets the width.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_BorderThickness": _set_BorderThickness,
		"_set_Height": _set_Height,
		"_set_MarkerType": _set_MarkerType,
		"_set_Name": _set_Name,
		"_set_Width": _set_Width,
	}
	_prop_map_get_ = {
		"BorderColor": (1610743814, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderThickness": (1610743815, 2, (5, 0), (), "BorderThickness", None),
		"Color": (1610743817, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"Height": (1610743820, 2, (5, 0), (), "Height", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"MarkerType": (1610743812, 2, (3, 0), (), "MarkerType", '{CBCA3731-E91A-3899-BFD7-522BA7D53173}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Width": (1610743818, 2, (5, 0), (), "Width", None),
	}
	_prop_map_put_ = {
		"BorderThickness": ((1610743815, LCID, 4, 0),()),
		"Height": ((1610743820, LCID, 4, 0),()),
		"MarkerType": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Width": ((1610743818, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartPointMarker3D(DispatchBaseClass):
	'''Defines interface for the PointMarker'''
	CLSID = IID('{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_MarkerType(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "MarkerType", '{41D82DD8-FB9D-3D19-AE72-AC36231CB3A7}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Size(self):
		return self._ApplyTypes_(*(1610743815, 2, (4, 0), (), "Size", None))

	def _set_MarkerType(self, value):
		if "MarkerType" in self.__dict__: self.__dict__["MarkerType"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Size(self, value):
		if "Size" in self.__dict__: self.__dict__["Size"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color inside point marker.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	MarkerType = property(_get_MarkerType, _set_MarkerType)
	'''
	Gets or sets the type of the point marker.

	:type: recurdyn.Post.PointMarker3DType
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Size = property(_get_Size, _set_Size)
	'''
	Gets or sets the size of the point marker.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_MarkerType": _set_MarkerType,
		"_set_Name": _set_Name,
		"_set_Size": _set_Size,
	}
	_prop_map_get_ = {
		"Color": (1610743814, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"MarkerType": (1610743812, 2, (3, 0), (), "MarkerType", '{41D82DD8-FB9D-3D19-AE72-AC36231CB3A7}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Size": (1610743815, 2, (4, 0), (), "Size", None),
	}
	_prop_map_put_ = {
		"MarkerType": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Size": ((1610743815, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartSeries(DispatchBaseClass):
	'''Defines interface for the chart series.'''
	CLSID = IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetValue(self, arrXValue, arrYValue):
		'''
		Sets the value for this series.
		
		:param arrXValue: list[float]
		:param arrYValue: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743840, LCID, 1, (24, 0), ((8197, 1), (8197, 1)),arrXValue
			, arrYValue)


	def _get_Color(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743818, 2, (11, 0), (), "IsSelected", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743816, 2, (11, 0), (), "IsVisible", None))
	def _get_Legend(self):
		return self._ApplyTypes_(*(1610743834, 2, (8, 0), (), "Legend", None))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743814, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_PointMarker(self):
		return self._ApplyTypes_(*(1610743827, 2, (9, 0), (), "PointMarker", '{A57DEE8B-3147-4E83-A188-65C5A265F0D5}'))
	def _get_SamplingMode(self):
		return self._ApplyTypes_(*(1610743823, 2, (3, 0), (), "SamplingMode", '{DFEE2EAF-60F4-31EE-8F7F-9CCA2211EF08}'))
	def _get_SeriesInfo(self):
		return self._ApplyTypes_(*(1610743841, 2, (8, 0), (), "SeriesInfo", None))
	def _get_SeriesType(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "SeriesType", '{A2FD9CD9-AB13-3DFE-AA91-6D51A121B7E3}'))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "Thickness", None))
	def _get_XAxis(self):
		return self._ApplyTypes_(*(1610743828, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'))
	def _get_XValues(self):
		return self._ApplyTypes_(*(1610743832, 2, (8197, 0), (), "XValues", None))
	def _get_XValuesKey(self):
		return self._ApplyTypes_(*(1610743836, 2, (8, 0), (), "XValuesKey", None))
	def _get_YAxis(self):
		return self._ApplyTypes_(*(1610743830, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'))
	def _get_YValues(self):
		return self._ApplyTypes_(*(1610743833, 2, (8197, 0), (), "YValues", None))
	def _get_YValuesKey(self):
		return self._ApplyTypes_(*(1610743838, 2, (8, 0), (), "YValuesKey", None))
	def _get_ZeroLineY(self):
		return self._ApplyTypes_(*(1610743825, 2, (5, 0), (), "ZeroLineY", None))

	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743818, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743816, LCID, 4, 0) + (value,) + ()))
	def _set_Legend(self, value):
		if "Legend" in self.__dict__: self.__dict__["Legend"] = value; return
		self._oleobj_.Invoke(*((1610743834, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_SamplingMode(self, value):
		if "SamplingMode" in self.__dict__: self.__dict__["SamplingMode"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_SeriesType(self, value):
		if "SeriesType" in self.__dict__: self.__dict__["SeriesType"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_XAxis(self, value):
		if "XAxis" in self.__dict__: self.__dict__["XAxis"] = value; return
		self._oleobj_.Invoke(*((1610743828, LCID, 8, 0) + (value,) + ()))
	def _set_XValuesKey(self, value):
		if "XValuesKey" in self.__dict__: self.__dict__["XValuesKey"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))
	def _set_YAxis(self, value):
		if "YAxis" in self.__dict__: self.__dict__["YAxis"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 8, 0) + (value,) + ()))
	def _set_YValuesKey(self, value):
		if "YValuesKey" in self.__dict__: self.__dict__["YValuesKey"] = value; return
		self._oleobj_.Invoke(*((1610743838, LCID, 4, 0) + (value,) + ()))
	def _set_ZeroLineY(self, value):
		if "ZeroLineY" in self.__dict__: self.__dict__["ZeroLineY"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of series.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this series is selected.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this series is visible.

	:type: bool
	'''
	Legend = property(_get_Legend, _set_Legend)
	'''
	Gets or sets the legend of series. This Legend property will be displayed in legend box.

	:type: str
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the series line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	PointMarker = property(_get_PointMarker, None)
	'''
	Gets the point marker.

	:type: recurdyn.Post.IChartPointMarker
	'''
	SamplingMode = property(_get_SamplingMode, _set_SamplingMode)
	'''
	Gets or sets the sampling mode.

	:type: recurdyn.Post.SamplingMode
	'''
	SeriesInfo = property(_get_SeriesInfo, None)
	'''
	Gets the text of the y value key of the series.

	:type: str
	'''
	SeriesType = property(_get_SeriesType, _set_SeriesType)
	'''
	Gets or sets the type of the series.

	:type: recurdyn.Post.SeriesType
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of series.

	:type: int
	'''
	XAxis = property(_get_XAxis, _set_XAxis)
	'''
	Gets or sets the X-Axis. When change X-Axis of this series, set X-Axis (IChartAxisX).

	:type: recurdyn.Post.IChartAxisX
	'''
	XValues = property(_get_XValues, None)
	'''
	Gets the x values.

	:type: list[float]
	'''
	XValuesKey = property(_get_XValuesKey, _set_XValuesKey)
	'''
	Gets or sets the x values key. The XValuesKey will be used by the [Compare DataFile]. When comparing data, the same key will be found and used from database.

	:type: str
	'''
	YAxis = property(_get_YAxis, _set_YAxis)
	'''
	Gets or sets the Y-Axis. When change Y-Axis of this series, set Y-Axis (IChartAxisY).

	:type: recurdyn.Post.IChartAxisY
	'''
	YValues = property(_get_YValues, None)
	'''
	Gets the y values.

	:type: list[float]
	'''
	YValuesKey = property(_get_YValuesKey, _set_YValuesKey)
	'''
	Gets or sets the x values key. The XValuesKey will be used by the [Compare DataFile]. When comparing data, the same key will be found and used from database.

	:type: str
	'''
	ZeroLineY = property(_get_ZeroLineY, _set_ZeroLineY)
	'''
	Gets or sets the zero line value of bar and mountain series type.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
		"_set_Legend": _set_Legend,
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_SamplingMode": _set_SamplingMode,
		"_set_SeriesType": _set_SeriesType,
		"_set_Thickness": _set_Thickness,
		"_set_XAxis": _set_XAxis,
		"_set_XValuesKey": _set_XValuesKey,
		"_set_YAxis": _set_YAxis,
		"_set_YValuesKey": _set_YValuesKey,
		"_set_ZeroLineY": _set_ZeroLineY,
	}
	_prop_map_get_ = {
		"Color": (1610743820, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743818, 2, (11, 0), (), "IsSelected", None),
		"IsVisible": (1610743816, 2, (11, 0), (), "IsVisible", None),
		"Legend": (1610743834, 2, (8, 0), (), "Legend", None),
		"LineStyle": (1610743814, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"PointMarker": (1610743827, 2, (9, 0), (), "PointMarker", '{A57DEE8B-3147-4E83-A188-65C5A265F0D5}'),
		"SamplingMode": (1610743823, 2, (3, 0), (), "SamplingMode", '{DFEE2EAF-60F4-31EE-8F7F-9CCA2211EF08}'),
		"SeriesInfo": (1610743841, 2, (8, 0), (), "SeriesInfo", None),
		"SeriesType": (1610743812, 2, (3, 0), (), "SeriesType", '{A2FD9CD9-AB13-3DFE-AA91-6D51A121B7E3}'),
		"Thickness": (1610743821, 2, (3, 0), (), "Thickness", None),
		"XAxis": (1610743828, 2, (9, 0), (), "XAxis", '{2A620232-B413-4059-9E81-29A2CCA9EFEF}'),
		"XValues": (1610743832, 2, (8197, 0), (), "XValues", None),
		"XValuesKey": (1610743836, 2, (8, 0), (), "XValuesKey", None),
		"YAxis": (1610743830, 2, (9, 0), (), "YAxis", '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}'),
		"YValues": (1610743833, 2, (8197, 0), (), "YValues", None),
		"YValuesKey": (1610743838, 2, (8, 0), (), "YValuesKey", None),
		"ZeroLineY": (1610743825, 2, (5, 0), (), "ZeroLineY", None),
	}
	_prop_map_put_ = {
		"IsSelected": ((1610743818, LCID, 4, 0),()),
		"IsVisible": ((1610743816, LCID, 4, 0),()),
		"Legend": ((1610743834, LCID, 4, 0),()),
		"LineStyle": ((1610743814, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"SamplingMode": ((1610743823, LCID, 4, 0),()),
		"SeriesType": ((1610743812, LCID, 4, 0),()),
		"Thickness": ((1610743821, LCID, 4, 0),()),
		"XAxis": ((1610743828, LCID, 8, 0),()),
		"XValuesKey": ((1610743836, LCID, 4, 0),()),
		"YAxis": ((1610743830, LCID, 8, 0),()),
		"YValuesKey": ((1610743838, LCID, 4, 0),()),
		"ZeroLineY": ((1610743825, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartSeries3D(DispatchBaseClass):
	'''Defines interface of the Chart3D series.'''
	CLSID = IID('{26823D92-8950-47F5-BE7F-E27509032204}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743813, 2, (11, 0), (), "IsSelected", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsVisible", None))
	def _get_Legend(self):
		return self._ApplyTypes_(*(1610743817, 2, (8, 0), (), "Legend", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Legend(self, value):
		if "Legend" in self.__dict__: self.__dict__["Legend"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of the series.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this series is selected.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this series is visible.

	:type: bool
	'''
	Legend = property(_get_Legend, _set_Legend)
	'''
	Gets or sets the legend of the series.

	:type: str
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
		"_set_Legend": _set_Legend,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743813, 2, (11, 0), (), "IsSelected", None),
		"IsVisible": (1610743815, 2, (11, 0), (), "IsVisible", None),
		"Legend": (1610743817, 2, (8, 0), (), "Legend", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"IsSelected": ((1610743813, LCID, 4, 0),()),
		"IsVisible": ((1610743815, LCID, 4, 0),()),
		"Legend": ((1610743817, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartSeriesPointLine3D(DispatchBaseClass):
	'''Defines interface of the ChartSeriesPointLine3D.'''
	CLSID = IID('{4451598E-1CF9-495B-8225-3A6D5F12D4A4}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetValue(self, arrXValue, arrYValue, arrZValue):
		'''
		Sets the value of the series. The values should be same size.
		
		:param arrXValue: list[float]
		:param arrYValue: list[float]
		:param arrZValue: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743827, LCID, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1)),arrXValue
			, arrYValue, arrZValue)


	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsLineStrips(self):
		return self._ApplyTypes_(*(1610743822, 2, (11, 0), (), "IsLineStrips", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743813, 2, (11, 0), (), "IsSelected", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsVisible", None))
	def _get_Legend(self):
		return self._ApplyTypes_(*(1610743817, 2, (8, 0), (), "Legend", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_PointMarker(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "PointMarker", '{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}'))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743820, 2, (4, 0), (), "Thickness", None))
	def _get_XValues(self):
		return self._ApplyTypes_(*(1610743824, 2, (8197, 0), (), "XValues", None))
	def _get_YValues(self):
		return self._ApplyTypes_(*(1610743825, 2, (8197, 0), (), "YValues", None))
	def _get_ZValues(self):
		return self._ApplyTypes_(*(1610743826, 2, (8197, 0), (), "ZValues", None))

	def _set_IsLineStrips(self, value):
		if "IsLineStrips" in self.__dict__: self.__dict__["IsLineStrips"] = value; return
		self._oleobj_.Invoke(*((1610743822, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Legend(self, value):
		if "Legend" in self.__dict__: self.__dict__["Legend"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743820, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of the series.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsLineStrips = property(_get_IsLineStrips, _set_IsLineStrips)
	'''
	Gets or sets a value indicating whether the line strips of the series are used.

	:type: bool
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this series is selected.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this series is visible.

	:type: bool
	'''
	Legend = property(_get_Legend, _set_Legend)
	'''
	Gets or sets the legend of the series.

	:type: str
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	PointMarker = property(_get_PointMarker, None)
	'''
	Gets the point marker.

	:type: recurdyn.Post.IChartPointMarker3D
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of the point line series.

	:type: float
	'''
	XValues = property(_get_XValues, None)
	'''
	Gets the x values.

	:type: list[float]
	'''
	YValues = property(_get_YValues, None)
	'''
	Gets the y values.

	:type: list[float]
	'''
	ZValues = property(_get_ZValues, None)
	'''
	Gets the z values.

	:type: list[float]
	'''

	_prop_map_set_function_ = {
		"_set_IsLineStrips": _set_IsLineStrips,
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
		"_set_Legend": _set_Legend,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsLineStrips": (1610743822, 2, (11, 0), (), "IsLineStrips", None),
		"IsSelected": (1610743813, 2, (11, 0), (), "IsSelected", None),
		"IsVisible": (1610743815, 2, (11, 0), (), "IsVisible", None),
		"Legend": (1610743817, 2, (8, 0), (), "Legend", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"PointMarker": (1610743819, 2, (9, 0), (), "PointMarker", '{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}'),
		"Thickness": (1610743820, 2, (4, 0), (), "Thickness", None),
		"XValues": (1610743824, 2, (8197, 0), (), "XValues", None),
		"YValues": (1610743825, 2, (8197, 0), (), "YValues", None),
		"ZValues": (1610743826, 2, (8197, 0), (), "ZValues", None),
	}
	_prop_map_put_ = {
		"IsLineStrips": ((1610743822, LCID, 4, 0),()),
		"IsSelected": ((1610743813, LCID, 4, 0),()),
		"IsVisible": ((1610743815, LCID, 4, 0),()),
		"Legend": ((1610743817, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743820, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartSeriesSurfaceMesh3D(DispatchBaseClass):
	'''Defines interface of the ChartSeriesSurfaceMesh3D.'''
	CLSID = IID('{E7CBEAD9-7363-47CB-A31A-30B357E4DE00}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetValue(self, arrXSteppingValue, arrZSteppingValue, arrMeshGridDataValue):
		'''
		Sets the values.
		
		:param arrXSteppingValue: list[float]
		:param arrZSteppingValue: list[float]
		:param arrMeshGridDataValue: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743833, LCID, 1, (24, 0), ((8197, 1), (8197, 1), (8197, 1)),arrXSteppingValue
			, arrZSteppingValue, arrMeshGridDataValue)


	def _get_CellHardnessFactor(self):
		return self._ApplyTypes_(*(1610743827, 2, (4, 0), (), "CellHardnessFactor", None))
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawMeshAs(self):
		return self._ApplyTypes_(*(1610743819, 2, (3, 0), (), "DrawMeshAs", '{D42F05C9-303E-3BC4-88E8-277AFC5DD256}'))
	def _get_DrawSkirt(self):
		return self._ApplyTypes_(*(1610743831, 2, (11, 0), (), "DrawSkirt", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HeightScaleFactor(self):
		return self._ApplyTypes_(*(1610743821, 2, (4, 0), (), "HeightScaleFactor", None))
	def _get_Highlight(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "Highlight", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743813, 2, (11, 0), (), "IsSelected", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsVisible", None))
	def _get_Legend(self):
		return self._ApplyTypes_(*(1610743817, 2, (8, 0), (), "Legend", None))
	def _get_LightingFactor(self):
		return self._ApplyTypes_(*(1610743825, 2, (4, 0), (), "LightingFactor", None))
	def _get_Maximum(self):
		return self._ApplyTypes_(*(1610743835, 2, (5, 0), (), "Maximum", None))
	def _get_Minimum(self):
		return self._ApplyTypes_(*(1610743834, 2, (5, 0), (), "Minimum", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Shininess(self):
		return self._ApplyTypes_(*(1610743829, 2, (4, 0), (), "Shininess", None))
	def _get_YOffset(self):
		return self._ApplyTypes_(*(1610743836, 2, (4, 0), (), "YOffset", None))

	def _set_CellHardnessFactor(self, value):
		if "CellHardnessFactor" in self.__dict__: self.__dict__["CellHardnessFactor"] = value; return
		self._oleobj_.Invoke(*((1610743827, LCID, 4, 0) + (value,) + ()))
	def _set_DrawMeshAs(self, value):
		if "DrawMeshAs" in self.__dict__: self.__dict__["DrawMeshAs"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_DrawSkirt(self, value):
		if "DrawSkirt" in self.__dict__: self.__dict__["DrawSkirt"] = value; return
		self._oleobj_.Invoke(*((1610743831, LCID, 4, 0) + (value,) + ()))
	def _set_HeightScaleFactor(self, value):
		if "HeightScaleFactor" in self.__dict__: self.__dict__["HeightScaleFactor"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_Highlight(self, value):
		if "Highlight" in self.__dict__: self.__dict__["Highlight"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Legend(self, value):
		if "Legend" in self.__dict__: self.__dict__["Legend"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_LightingFactor(self, value):
		if "LightingFactor" in self.__dict__: self.__dict__["LightingFactor"] = value; return
		self._oleobj_.Invoke(*((1610743825, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Shininess(self, value):
		if "Shininess" in self.__dict__: self.__dict__["Shininess"] = value; return
		self._oleobj_.Invoke(*((1610743829, LCID, 4, 0) + (value,) + ()))
	def _set_YOffset(self, value):
		if "YOffset" in self.__dict__: self.__dict__["YOffset"] = value; return
		self._oleobj_.Invoke(*((1610743836, LCID, 4, 0) + (value,) + ()))

	CellHardnessFactor = property(_get_CellHardnessFactor, _set_CellHardnessFactor)
	'''
	Gets or sets the cell hardness factor.

	:type: float
	'''
	Color = property(_get_Color, None)
	'''
	Gets or sets the color of the series.

	:type: recurdyn.Post.IColor
	'''
	DrawMeshAs = property(_get_DrawMeshAs, _set_DrawMeshAs)
	'''
	Gets or sets the mesh type of the surface mesh series.

	:type: recurdyn.Post.DrawMeshAs
	'''
	DrawSkirt = property(_get_DrawSkirt, _set_DrawSkirt)
	'''
	Gets or sets a value indicating whether draw skirt of the surface mesh.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HeightScaleFactor = property(_get_HeightScaleFactor, _set_HeightScaleFactor)
	'''
	Gets or sets the height scale factor.

	:type: float
	'''
	Highlight = property(_get_Highlight, _set_Highlight)
	'''
	Gets or sets the highlight.

	:type: float
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this series is selected.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this series is visible.

	:type: bool
	'''
	Legend = property(_get_Legend, _set_Legend)
	'''
	Gets or sets the legend of the series.

	:type: str
	'''
	LightingFactor = property(_get_LightingFactor, _set_LightingFactor)
	'''
	Gets or sets the lighting factor.

	:type: float
	'''
	Maximum = property(_get_Maximum, None)
	'''
	Gets the maximum of the series.

	:type: float
	'''
	Minimum = property(_get_Minimum, None)
	'''
	Gets the minimum of the series.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Shininess = property(_get_Shininess, _set_Shininess)
	'''
	Gets or sets the shininess.

	:type: float
	'''
	YOffset = property(_get_YOffset, _set_YOffset)
	'''
	Gets or sets the y offset.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_CellHardnessFactor": _set_CellHardnessFactor,
		"_set_DrawMeshAs": _set_DrawMeshAs,
		"_set_DrawSkirt": _set_DrawSkirt,
		"_set_HeightScaleFactor": _set_HeightScaleFactor,
		"_set_Highlight": _set_Highlight,
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
		"_set_Legend": _set_Legend,
		"_set_LightingFactor": _set_LightingFactor,
		"_set_Name": _set_Name,
		"_set_Shininess": _set_Shininess,
		"_set_YOffset": _set_YOffset,
	}
	_prop_map_get_ = {
		"CellHardnessFactor": (1610743827, 2, (4, 0), (), "CellHardnessFactor", None),
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawMeshAs": (1610743819, 2, (3, 0), (), "DrawMeshAs", '{D42F05C9-303E-3BC4-88E8-277AFC5DD256}'),
		"DrawSkirt": (1610743831, 2, (11, 0), (), "DrawSkirt", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HeightScaleFactor": (1610743821, 2, (4, 0), (), "HeightScaleFactor", None),
		"Highlight": (1610743823, 2, (5, 0), (), "Highlight", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"IsSelected": (1610743813, 2, (11, 0), (), "IsSelected", None),
		"IsVisible": (1610743815, 2, (11, 0), (), "IsVisible", None),
		"Legend": (1610743817, 2, (8, 0), (), "Legend", None),
		"LightingFactor": (1610743825, 2, (4, 0), (), "LightingFactor", None),
		"Maximum": (1610743835, 2, (5, 0), (), "Maximum", None),
		"Minimum": (1610743834, 2, (5, 0), (), "Minimum", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Shininess": (1610743829, 2, (4, 0), (), "Shininess", None),
		"YOffset": (1610743836, 2, (4, 0), (), "YOffset", None),
	}
	_prop_map_put_ = {
		"CellHardnessFactor": ((1610743827, LCID, 4, 0),()),
		"DrawMeshAs": ((1610743819, LCID, 4, 0),()),
		"DrawSkirt": ((1610743831, LCID, 4, 0),()),
		"HeightScaleFactor": ((1610743821, LCID, 4, 0),()),
		"Highlight": ((1610743823, LCID, 4, 0),()),
		"IsSelected": ((1610743813, LCID, 4, 0),()),
		"IsVisible": ((1610743815, LCID, 4, 0),()),
		"Legend": ((1610743817, LCID, 4, 0),()),
		"LightingFactor": ((1610743825, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Shininess": ((1610743829, LCID, 4, 0),()),
		"YOffset": ((1610743836, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleAxisTitle(DispatchBaseClass):
	'''Defines interface for ChartStyleAxisTitle. This interface provides style of axis title.'''
	CLSID = IID('{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743819, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HorizontalAlignment(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_VerticalAlignment(self):
		return self._ApplyTypes_(*(1610743824, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'))

	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_HorizontalAlignment(self, value):
		if "HorizontalAlignment" in self.__dict__: self.__dict__["HorizontalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_VerticalAlignment(self, value):
		if "VerticalAlignment" in self.__dict__: self.__dict__["VerticalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743824, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background.

	:type: recurdyn.Post.IColor
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the color of the font.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HorizontalAlignment = property(_get_HorizontalAlignment, _set_HorizontalAlignment)
	'''
	Gets or sets the horizontal alignment.

	:type: recurdyn.Post.HorizontalAlignmentEx
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	VerticalAlignment = property(_get_VerticalAlignment, _set_VerticalAlignment)
	'''
	Gets or sets the vertical alignment.

	:type: recurdyn.Post.VerticalAlignmentEx
	'''

	_prop_map_set_function_ = {
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_HorizontalAlignment": _set_HorizontalAlignment,
		"_set_Name": _set_Name,
		"_set_VerticalAlignment": _set_VerticalAlignment,
	}
	_prop_map_get_ = {
		"Background": (1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"Font": (1610743819, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743815, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HorizontalAlignment": (1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"VerticalAlignment": (1610743824, 2, (3, 0), (), "VerticalAlignment", '{285AAC91-6B06-3C2A-9AA8-22B794E24920}'),
	}
	_prop_map_put_ = {
		"Font": ((1610743819, LCID, 4, 0),()),
		"FontSize": ((1610743815, LCID, 4, 0),()),
		"FontStyle": ((1610743821, LCID, 4, 0),()),
		"FontWeight": ((1610743817, LCID, 4, 0),()),
		"HorizontalAlignment": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"VerticalAlignment": ((1610743824, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleGridLine(DispatchBaseClass):
	'''Defines interface for the grid line style.'''
	CLSID = IID('{47706DC8-0B8C-451D-8960-49A877CB0B3D}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))

	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the grid line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LineStyle": (1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"LineStyle": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleGridLinePanel(DispatchBaseClass):
	'''This interface provides the style of grid line panel.'''
	CLSID = IID('{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderColor(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_BorderThickness(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background.

	:type: recurdyn.Post.IColor
	'''
	BorderColor = property(_get_BorderColor, None)
	'''
	Gets or sets the color of the border.

	:type: recurdyn.Post.IColor
	'''
	BorderThickness = property(_get_BorderThickness, None)
	'''
	Gets or sets the border thickness.

	:type: recurdyn.Post.IThickness
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Background": (1610743808, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderColor": (1610743809, 2, (9, 0), (), "BorderColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"BorderThickness": (1610743810, 2, (9, 0), (), "BorderThickness", '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleMajorGridLine(DispatchBaseClass):
	'''Defines the interface for the major grid line style.'''
	CLSID = IID('{DE759D88-66E1-4764-86B0-96D98197A346}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawGridLines(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "DrawGridLines", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))

	def _set_DrawGridLines(self, value):
		if "DrawGridLines" in self.__dict__: self.__dict__["DrawGridLines"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	DrawGridLines = property(_get_DrawGridLines, _set_DrawGridLines)
	'''
	Gets or sets a value indicating whether draw grid lines.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the grid line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawGridLines": _set_DrawGridLines,
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawGridLines": (1610743817, 2, (11, 0), (), "DrawGridLines", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LineStyle": (1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawGridLines": ((1610743817, LCID, 4, 0),()),
		"LineStyle": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleMajorTickLine(DispatchBaseClass):
	'''Defines the interface for the major tick line style.'''
	CLSID = IID('{0425D327-6C6A-4081-8DBB-337984399370}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawTicks(self):
		return self._ApplyTypes_(*(1610743821, 2, (11, 0), (), "DrawTicks", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Length(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "Length", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))
	def _get_XLength(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "XLength", None))
	def _get_YLength(self):
		return self._ApplyTypes_(*(1610743817, 2, (5, 0), (), "YLength", None))

	def _set_DrawTicks(self, value):
		if "DrawTicks" in self.__dict__: self.__dict__["DrawTicks"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_Length(self, value):
		if "Length" in self.__dict__: self.__dict__["Length"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_XLength(self, value):
		if "XLength" in self.__dict__: self.__dict__["XLength"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_YLength(self, value):
		if "YLength" in self.__dict__: self.__dict__["YLength"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of tick line.

	:type: recurdyn.Post.IColor
	'''
	DrawTicks = property(_get_DrawTicks, _set_DrawTicks)
	'''
	Gets or sets a value indicating whether draw ticks.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Length = property(_get_Length, _set_Length)
	'''
	Gets or sets the length.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of tick line.

	:type: float
	'''
	XLength = property(_get_XLength, _set_XLength)
	'''
	Gets or sets the length of the horizontal direction.

	:type: float
	'''
	YLength = property(_get_YLength, _set_YLength)
	'''
	Gets or sets the length of the vertical direction.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawTicks": _set_DrawTicks,
		"_set_Length": _set_Length,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
		"_set_XLength": _set_XLength,
		"_set_YLength": _set_YLength,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawTicks": (1610743821, 2, (11, 0), (), "DrawTicks", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Length": (1610743819, 2, (5, 0), (), "Length", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
		"XLength": (1610743815, 2, (5, 0), (), "XLength", None),
		"YLength": (1610743817, 2, (5, 0), (), "YLength", None),
	}
	_prop_map_put_ = {
		"DrawTicks": ((1610743821, LCID, 4, 0),()),
		"Length": ((1610743819, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
		"XLength": ((1610743815, LCID, 4, 0),()),
		"YLength": ((1610743817, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleMinorGridLine(DispatchBaseClass):
	'''Defines the interface for the minor grid line style.'''
	CLSID = IID('{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawGridLines(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "DrawGridLines", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LineStyle(self):
		return self._ApplyTypes_(*(1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))

	def _set_DrawGridLines(self, value):
		if "DrawGridLines" in self.__dict__: self.__dict__["DrawGridLines"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_LineStyle(self, value):
		if "LineStyle" in self.__dict__: self.__dict__["LineStyle"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of grid line.

	:type: recurdyn.Post.IColor
	'''
	DrawGridLines = property(_get_DrawGridLines, _set_DrawGridLines)
	'''
	Gets or sets a value indicating whether draw grid lines.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LineStyle = property(_get_LineStyle, _set_LineStyle)
	'''
	Gets or sets the grid line style.

	:type: recurdyn.Post.LineStyle
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of grid line.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawGridLines": _set_DrawGridLines,
		"_set_LineStyle": _set_LineStyle,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawGridLines": (1610743817, 2, (11, 0), (), "DrawGridLines", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LineStyle": (1610743815, 2, (3, 0), (), "LineStyle", '{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}'),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
	}
	_prop_map_put_ = {
		"DrawGridLines": ((1610743817, LCID, 4, 0),()),
		"LineStyle": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleMinorTickLine(DispatchBaseClass):
	'''Defines the interface for the minor tick line style.'''
	CLSID = IID('{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_DrawTicks(self):
		return self._ApplyTypes_(*(1610743821, 2, (11, 0), (), "DrawTicks", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Length(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "Length", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))
	def _get_XLength(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "XLength", None))
	def _get_YLength(self):
		return self._ApplyTypes_(*(1610743817, 2, (5, 0), (), "YLength", None))

	def _set_DrawTicks(self, value):
		if "DrawTicks" in self.__dict__: self.__dict__["DrawTicks"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_Length(self, value):
		if "Length" in self.__dict__: self.__dict__["Length"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_XLength(self, value):
		if "XLength" in self.__dict__: self.__dict__["XLength"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_YLength(self, value):
		if "YLength" in self.__dict__: self.__dict__["YLength"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of tick line.

	:type: recurdyn.Post.IColor
	'''
	DrawTicks = property(_get_DrawTicks, _set_DrawTicks)
	'''
	Gets or sets a value indicating whether draw ticks.

	:type: bool
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Length = property(_get_Length, _set_Length)
	'''
	Gets or sets the length.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of tick line.

	:type: float
	'''
	XLength = property(_get_XLength, _set_XLength)
	'''
	Gets or sets the length of the horizontal direction.

	:type: float
	'''
	YLength = property(_get_YLength, _set_YLength)
	'''
	Gets or sets the length of the vertical direction.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_DrawTicks": _set_DrawTicks,
		"_set_Length": _set_Length,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
		"_set_XLength": _set_XLength,
		"_set_YLength": _set_YLength,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"DrawTicks": (1610743821, 2, (11, 0), (), "DrawTicks", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Length": (1610743819, 2, (5, 0), (), "Length", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
		"XLength": (1610743815, 2, (5, 0), (), "XLength", None),
		"YLength": (1610743817, 2, (5, 0), (), "YLength", None),
	}
	_prop_map_put_ = {
		"DrawTicks": ((1610743821, LCID, 4, 0),()),
		"Length": ((1610743819, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
		"XLength": ((1610743815, LCID, 4, 0),()),
		"YLength": ((1610743817, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleTickLabel(DispatchBaseClass):
	'''Defines the interface for tick label style of axis.'''
	CLSID = IID('{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_DrawLabels(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "DrawLabels", None))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743817, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743819, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LabelAngle(self):
		return self._ApplyTypes_(*(1610743823, 2, (5, 0), (), "LabelAngle", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_DrawLabels(self, value):
		if "DrawLabels" in self.__dict__: self.__dict__["DrawLabels"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_LabelAngle(self, value):
		if "LabelAngle" in self.__dict__: self.__dict__["LabelAngle"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	DrawLabels = property(_get_DrawLabels, _set_DrawLabels)
	'''
	Gets or sets a value indicating whether draw labels.

	:type: bool
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the color of the font.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LabelAngle = property(_get_LabelAngle, _set_LabelAngle)
	'''
	Gets or sets the label angle.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_DrawLabels": _set_DrawLabels,
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_LabelAngle": _set_LabelAngle,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"DrawLabels": (1610743812, 2, (11, 0), (), "DrawLabels", None),
		"Font": (1610743817, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743815, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743819, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LabelAngle": (1610743823, 2, (5, 0), (), "LabelAngle", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"DrawLabels": ((1610743812, LCID, 4, 0),()),
		"Font": ((1610743817, LCID, 4, 0),()),
		"FontSize": ((1610743815, LCID, 4, 0),()),
		"FontStyle": ((1610743821, LCID, 4, 0),()),
		"FontWeight": ((1610743819, LCID, 4, 0),()),
		"LabelAngle": ((1610743823, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleTickLine(DispatchBaseClass):
	'''Defines interface for the tick line style.'''
	CLSID = IID('{96B447B4-B377-40F5-A14F-4334FE99C903}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Length(self):
		return self._ApplyTypes_(*(1610743819, 2, (5, 0), (), "Length", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_Thickness(self):
		return self._ApplyTypes_(*(1610743813, 2, (5, 0), (), "Thickness", None))
	def _get_XLength(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "XLength", None))
	def _get_YLength(self):
		return self._ApplyTypes_(*(1610743817, 2, (5, 0), (), "YLength", None))

	def _set_Length(self, value):
		if "Length" in self.__dict__: self.__dict__["Length"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Thickness(self, value):
		if "Thickness" in self.__dict__: self.__dict__["Thickness"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))
	def _set_XLength(self, value):
		if "XLength" in self.__dict__: self.__dict__["XLength"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_YLength(self, value):
		if "YLength" in self.__dict__: self.__dict__["YLength"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color of tick line.

	:type: recurdyn.Post.IColor
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Length = property(_get_Length, _set_Length)
	'''
	Gets or sets the length.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	Thickness = property(_get_Thickness, _set_Thickness)
	'''
	Gets or sets the thickness of tick line.

	:type: float
	'''
	XLength = property(_get_XLength, _set_XLength)
	'''
	Gets or sets the length of the horizontal direction.

	:type: float
	'''
	YLength = property(_get_YLength, _set_YLength)
	'''
	Gets or sets the length of the vertical direction.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_Length": _set_Length,
		"_set_Name": _set_Name,
		"_set_Thickness": _set_Thickness,
		"_set_XLength": _set_XLength,
		"_set_YLength": _set_YLength,
	}
	_prop_map_get_ = {
		"Color": (1610743812, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Length": (1610743819, 2, (5, 0), (), "Length", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"Thickness": (1610743813, 2, (5, 0), (), "Thickness", None),
		"XLength": (1610743815, 2, (5, 0), (), "XLength", None),
		"YLength": (1610743817, 2, (5, 0), (), "YLength", None),
	}
	_prop_map_put_ = {
		"Length": ((1610743819, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"Thickness": ((1610743813, LCID, 4, 0),()),
		"XLength": ((1610743815, LCID, 4, 0),()),
		"YLength": ((1610743817, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartStyleTitle(DispatchBaseClass):
	'''Defines interface for the ChartStyleTitle. This interface provides style of title (chart title, axis title)'''
	CLSID = IID('{F779994A-D846-4F12-AE53-DD023F6973B9}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Background(self):
		return self._ApplyTypes_(*(1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_Font(self):
		return self._ApplyTypes_(*(1610743819, 2, (8, 0), (), "Font", None))
	def _get_FontColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_FontSize(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "FontSize", None))
	def _get_FontStyle(self):
		return self._ApplyTypes_(*(1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'))
	def _get_FontWeight(self):
		return self._ApplyTypes_(*(1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_HorizontalAlignment(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Font(self, value):
		if "Font" in self.__dict__: self.__dict__["Font"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_FontSize(self, value):
		if "FontSize" in self.__dict__: self.__dict__["FontSize"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_FontStyle(self, value):
		if "FontStyle" in self.__dict__: self.__dict__["FontStyle"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_FontWeight(self, value):
		if "FontWeight" in self.__dict__: self.__dict__["FontWeight"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_HorizontalAlignment(self, value):
		if "HorizontalAlignment" in self.__dict__: self.__dict__["HorizontalAlignment"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Background = property(_get_Background, None)
	'''
	Gets or sets the background.

	:type: recurdyn.Post.IColor
	'''
	Font = property(_get_Font, _set_Font)
	'''
	Gets or sets the font.

	:type: str
	'''
	FontColor = property(_get_FontColor, None)
	'''
	Gets or sets the color of the font.

	:type: recurdyn.Post.IColor
	'''
	FontSize = property(_get_FontSize, _set_FontSize)
	'''
	Gets or sets the size of the font.

	:type: float
	'''
	FontStyle = property(_get_FontStyle, _set_FontStyle)
	'''
	Gets or sets the font style.

	:type: recurdyn.Post.FontStyleEx
	'''
	FontWeight = property(_get_FontWeight, _set_FontWeight)
	'''
	Gets or sets the font weight.

	:type: recurdyn.Post.FontWeightEx
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	HorizontalAlignment = property(_get_HorizontalAlignment, _set_HorizontalAlignment)
	'''
	Gets or sets the horizontal alignment.

	:type: recurdyn.Post.HorizontalAlignmentEx
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Font": _set_Font,
		"_set_FontSize": _set_FontSize,
		"_set_FontStyle": _set_FontStyle,
		"_set_FontWeight": _set_FontWeight,
		"_set_HorizontalAlignment": _set_HorizontalAlignment,
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"Background": (1610743823, 2, (9, 0), (), "Background", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"Font": (1610743819, 2, (8, 0), (), "Font", None),
		"FontColor": (1610743814, 2, (9, 0), (), "FontColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"FontSize": (1610743815, 2, (5, 0), (), "FontSize", None),
		"FontStyle": (1610743821, 2, (3, 0), (), "FontStyle", '{06576144-3110-3796-A302-671D3EA3748B}'),
		"FontWeight": (1610743817, 2, (3, 0), (), "FontWeight", '{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"HorizontalAlignment": (1610743812, 2, (3, 0), (), "HorizontalAlignment", '{234E2608-3F42-30FD-A53F-5A20FA71E473}'),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Font": ((1610743819, LCID, 4, 0),()),
		"FontSize": ((1610743815, LCID, 4, 0),()),
		"FontStyle": ((1610743821, LCID, 4, 0),()),
		"FontWeight": ((1610743817, LCID, 4, 0),()),
		"HorizontalAlignment": ((1610743812, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IChartTimeLineAnnotationStyle(DispatchBaseClass):
	'''Defines interface for ChartTimeLineAnnotationStyle. This interface provides style of vertical slice.'''
	CLSID = IID('{496406A4-661D-4FA1-A778-FDA86C1C1DA4}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_LineColor(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_LineThickness(self):
		return self._ApplyTypes_(*(1610743815, 2, (5, 0), (), "LineThickness", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))
	def _get_ShowLabel(self):
		return self._ApplyTypes_(*(1610743812, 2, (11, 0), (), "ShowLabel", None))

	def _set_LineThickness(self, value):
		if "LineThickness" in self.__dict__: self.__dict__["LineThickness"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_ShowLabel(self, value):
		if "ShowLabel" in self.__dict__: self.__dict__["ShowLabel"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	LineColor = property(_get_LineColor, None)
	'''
	Gets or sets the color of the line.

	:type: recurdyn.Post.IColor
	'''
	LineThickness = property(_get_LineThickness, _set_LineThickness)
	'''
	Gets or sets the line thickness.

	:type: float
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''
	ShowLabel = property(_get_ShowLabel, _set_ShowLabel)
	'''
	Gets or sets a value indicating whether show label.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_LineThickness": _set_LineThickness,
		"_set_Name": _set_Name,
		"_set_ShowLabel": _set_ShowLabel,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"LineColor": (1610743814, 2, (9, 0), (), "LineColor", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"LineThickness": (1610743815, 2, (5, 0), (), "LineThickness", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
		"ShowLabel": (1610743812, 2, (11, 0), (), "ShowLabel", None),
	}
	_prop_map_put_ = {
		"LineThickness": ((1610743815, LCID, 4, 0),()),
		"Name": ((1610743808, LCID, 4, 0),()),
		"ShowLabel": ((1610743812, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IColor(DispatchBaseClass):
	'''Defines interface for the color.'''
	CLSID = IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def FromARGB(self, uRGBAColor):
		'''
		Get the color from alpha, red, green, blue value.
		
		:param uRGBAColor: int
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((19, 1),),uRGBAColor
			)


	def FromBGR(self, uBGRColor):
		'''
		Sets the color from the blue, green, red value.
		
		:param uBGRColor: int
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), ((19, 1),),uBGRColor
			)


	def FromColor(self, varColor):
		'''
		Sets the color from the System.Drawing.Color.
		
		:param varColor: int
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), ((19, 1),),varColor
			)


	def ToUnit(self):
		'''
		Gets the unit value from this color.
		
		:rtype: int
		'''
		return self._oleobj_.InvokeTypes(1610743819, LCID, 1, (19, 0), (),)


	def _get_Alpha(self):
		return self._ApplyTypes_(*(1610743808, 2, (17, 0), (), "Alpha", None))
	def _get_Blue(self):
		return self._ApplyTypes_(*(1610743810, 2, (17, 0), (), "Blue", None))
	def _get_Green(self):
		return self._ApplyTypes_(*(1610743812, 2, (17, 0), (), "Green", None))
	def _get_Red(self):
		return self._ApplyTypes_(*(1610743814, 2, (17, 0), (), "Red", None))

	def _set_Alpha(self, value):
		if "Alpha" in self.__dict__: self.__dict__["Alpha"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Blue(self, value):
		if "Blue" in self.__dict__: self.__dict__["Blue"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))
	def _set_Green(self, value):
		if "Green" in self.__dict__: self.__dict__["Green"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Red(self, value):
		if "Red" in self.__dict__: self.__dict__["Red"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))

	Alpha = property(_get_Alpha, _set_Alpha)
	'''
	Gets or sets the value indicates alpha of color.

	:type: int
	'''
	Blue = property(_get_Blue, _set_Blue)
	'''
	Gets or sets the value indicates blue of color.

	:type: int
	'''
	Green = property(_get_Green, _set_Green)
	'''
	Gets or sets the value indicates green of color.

	:type: int
	'''
	Red = property(_get_Red, _set_Red)
	'''
	Gets or sets the value indicates red of color.

	:type: int
	'''

	_prop_map_set_function_ = {
		"_set_Alpha": _set_Alpha,
		"_set_Blue": _set_Blue,
		"_set_Green": _set_Green,
		"_set_Red": _set_Red,
	}
	_prop_map_get_ = {
		"Alpha": (1610743808, 2, (17, 0), (), "Alpha", None),
		"Blue": (1610743810, 2, (17, 0), (), "Blue", None),
		"Green": (1610743812, 2, (17, 0), (), "Green", None),
		"Red": (1610743814, 2, (17, 0), (), "Red", None),
	}
	_prop_map_put_ = {
		"Alpha": ((1610743808, LCID, 4, 0),()),
		"Blue": ((1610743810, LCID, 4, 0),()),
		"Green": ((1610743812, LCID, 4, 0),()),
		"Red": ((1610743814, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class ICommand(DispatchBaseClass):
	'''Defines interface for command.'''
	CLSID = IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Execute(self, varParameter):
		'''
		Execute this command with the specific parameter.
		
		:param varParameter: object
		'''
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), ((12, 1),),varParameter
			)


	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IControl(DispatchBaseClass):
	'''Defines interface for the UserControl.'''
	CLSID = IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_ViewModel(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ViewModel", '{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}'))
	def _get_Window(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "Window", '{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}'))

	ViewModel = property(_get_ViewModel, None)
	'''
	Gets the view model of this user control.

	:type: recurdyn.Post.IViewModel
	'''
	Window = property(_get_Window, None)
	'''
	Gets the pane window of this user control.

	:type: recurdyn.Post.IWindowPane
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ViewModel": (1610743809, 2, (9, 0), (), "ViewModel", '{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}'),
		"Window": (1610743808, 2, (9, 0), (), "Window", '{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDataComponent(DispatchBaseClass):
	'''Defines interface of DataComponent.'''
	CLSID = IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Index(self):
		return self._ApplyTypes_(*(1610743810, 2, (3, 0), (), "Index", None))
	def _get_Path(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Path", None))

	def _set_Index(self, value):
		if "Index" in self.__dict__: self.__dict__["Index"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))
	def _set_Path(self, value):
		if "Path" in self.__dict__: self.__dict__["Path"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Index = property(_get_Index, _set_Index)
	'''
	Gets or sets the index of the data file in the Datafile database.

	:type: int
	'''
	Path = property(_get_Path, _set_Path)
	'''
	Gets or sets the path that indicates the path of the Datafile database item.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Index": _set_Index,
		"_set_Path": _set_Path,
	}
	_prop_map_get_ = {
		"Index": (1610743810, 2, (3, 0), (), "Index", None),
		"Path": (1610743808, 2, (8, 0), (), "Path", None),
	}
	_prop_map_put_ = {
		"Index": ((1610743810, LCID, 4, 0),()),
		"Path": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDataFileDatabase(DispatchBaseClass):
	'''Defines interface for the DatabaseOperation.'''
	CLSID = IID('{979D321D-21DC-43D0-83BF-E1E7B75384F1}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def AddUserData(self, strName, arrValue):
		'''
		Adds the user-defined data.
		
		:param strName: str
		:param arrValue: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743823, LCID, 1, (24, 0), ((8, 1), (8197, 1)),strName
			, arrValue)


	def ChangeDataFileActiveModel(self, varRootItem):
		'''
		Changes the data file for active model with specific item.
		
		:param varRootItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743835, LCID, 1, (24, 0), ((9, 1),),varRootItem
			)


	def ChangeDataFileActivePlot(self, varRootItem):
		'''
		Changes the data file for active plot with specific item.
		
		:param varRootItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743836, LCID, 1, (24, 0), ((9, 1),),varRootItem
			)


	def CompareDataFileActiveModel(self, varRootItem):
		'''
		Compares the data file active model with specific item.
		
		:param varRootItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743837, LCID, 1, (24, 0), ((9, 1),),varRootItem
			)


	def CompareDataFileActiveModel_2(self, arrRootItem):
		'''
		Compares the data file for active model with the specific items.
		
		:param arrRootItem: list[object]
		'''
		_arrRootItem_type = True if arrRootItem and isinstance(arrRootItem[0], win32com.client.VARIANT) else False
		if not _arrRootItem_type:
			arrRootItem = [win32com.client.VARIANT(12, _data) for _data in arrRootItem]

		ret = self._oleobj_.InvokeTypes(1610743838, LCID, 1, (24, 0), ((8204, 1),),arrRootItem
			)

		if not _arrRootItem_type:
			arrRootItem = [_data.value for _data in arrRootItem]

		return ret


	def CompareDataFileActivePlot(self, arrRootItem):
		'''
		Compares the data file for active plot with the specific items.
		
		:param arrRootItem: list[object]
		'''
		_arrRootItem_type = True if arrRootItem and isinstance(arrRootItem[0], win32com.client.VARIANT) else False
		if not _arrRootItem_type:
			arrRootItem = [win32com.client.VARIANT(12, _data) for _data in arrRootItem]

		ret = self._oleobj_.InvokeTypes(1610743839, LCID, 1, (24, 0), ((8204, 1),),arrRootItem
			)

		if not _arrRootItem_type:
			arrRootItem = [_data.value for _data in arrRootItem]

		return ret


	def DrawSeries(self, varItem):
		'''
		Draws the series with the specific item. The X-Axis can be set by the function SetXAxis() in the DataFileDatabaseOperation.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def DrawSeriesWithKey(self, strKey, iIndex):
		'''
		Draws the series with the specific key. eg. Bodies/Body1/Pos_TM. The X-Axis can be set by the function SetXAxis() in the DataFileDatabaseOperation.
		
		:param strKey: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), ((8, 1), (3, 49)),strKey
			, iIndex)


	def DrawSeriesWithSeriesValueInfo(self, strSeriesName, varXInfo, varYInfo):
		'''
		Draws the series with the specific SeriesValueInfo. This function is usefull for user-defined data. Set the SeriesValueInfo with the name and data values and pass through as argument.
		
		:param strSeriesName: str
		:param varXInfo: _SeriesValueInfo
		:param varYInfo: _SeriesValueInfo
		'''
		return self._oleobj_.InvokeTypes(1610743819, LCID, 1, (24, 0), ((8, 1), (9, 1), (9, 1)),strSeriesName
			, varXInfo, varYInfo)


	def ExcludeSelectedItems(self):
		'''
		Excludes the selected items on the tree view.
		'''
		return self._oleobj_.InvokeTypes(1610743842, LCID, 1, (24, 0), (),)


	def ExpandAll(self):
		'''
		Expands all tree items.
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), (),)


	def ExpandItem(self, databaseItem):
		'''
		Expands the TreeView item with the specific item.
		
		:param databaseItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743812, LCID, 1, (24, 0), ((9, 1),),databaseItem
			)


	def ExportData(self, strFilepath, arrItem):
		'''
		Exports the data values to file.
		
		:param strFilepath: str
		:param arrItem: list[object]
		'''
		_arrItem_type = True if arrItem and isinstance(arrItem[0], win32com.client.VARIANT) else False
		if not _arrItem_type:
			arrItem = [win32com.client.VARIANT(12, _data) for _data in arrItem]

		ret = self._oleobj_.InvokeTypes(1610743830, LCID, 1, (24, 0), ((8, 1), (8204, 1)),strFilepath
			, arrItem)

		if not _arrItem_type:
			arrItem = [_data.value for _data in arrItem]

		return ret


	def GetDatabaseItem(self, strKey, iIndex):
		'''
		Gets the database item by specific key and index. The key that indicates path of database item in tree view. The index that indicates top node order in tree view.
		
		:param strKey: str
		:param iIndex: int
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(1610743826, LCID, 1, (9, 0), ((8, 1), (3, 49)),strKey
			, iIndex)
		if ret is not None:
			ret = Dispatch(ret, 'GetDatabaseItem', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def GetDatabaseItemWithFullPath(self, strFullPath):
		'''
		Gets the database item by specific path. The key that indicates full path of database item in tree view.
		
		:param strFullPath: str
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(1610743827, LCID, 1, (9, 0), ((8, 1),),strFullPath
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetDatabaseItemWithFullPath', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def GetImportedFilePathList(self):
		return self._ApplyTypes_(1610743828, 1, (8200, 0), (), 'GetImportedFilePathList', None,)


	def GetIndexOfDataFile(self, strFilepath):
		'''
		Gets the index of top node in tree view by specific file that is included in DataReader.
		
		:param strFilepath: str
		:rtype: int
		'''
		return self._oleobj_.InvokeTypes(1610743831, LCID, 1, (3, 0), ((8, 1),),strFilepath
			)


	def GetPlottableNameList(self, iIndex):
		return self._ApplyTypes_(1610743829, 1, (8200, 0), ((3, 1),), 'GetPlottableNameList', None,iIndex
			)


	def GetUnit(self, varItem):
		'''
		Gets the unit of the item.
		
		:param varItem: IDatabaseItem
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (8, 0), ((9, 1),),varItem
			)


	def GetValues(self, varItem):
		'''
		Gets the data values for specific item.
		
		:param varItem: IDatabaseItem
		:rtype: list[float]
		'''
		return self._ApplyTypes_(1610743821, 1, (8197, 0), ((9, 1),), 'GetValues', None,varItem
			)


	def GetXAxisPath(self, varItem):
		'''
		Gets the path of X-Axis of the parent reader that have specified item.
		
		:param varItem: IDatabaseItem
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743815, LCID, 1, (8, 0), ((9, 1),),varItem
			)


	def ImportDataFile(self, strFilepath):
		'''
		Imports the data file. Support format are txt, csv, rplt, vplt, chnk.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743840, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def IncludeAllItems(self):
		'''
		Includes all database items.
		'''
		return self._oleobj_.InvokeTypes(1610743843, LCID, 1, (24, 0), (),)


	def MultiDrawSeries(self, varItem):
		'''
		Draw all series which is the same component as a specific item in every data file. The X-Axis can be set by the function SetXAxis() in the DataFileDatabaseOperation.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743820, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def OpenPropertyGrid(self, varRootItem):
		'''
		Opens the property grid of top node in tree view. The DataFileReader property will be opened in the property grid.
		
		:param varRootItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743832, LCID, 1, (24, 0), ((9, 1),),varRootItem
			)


	def RegisterFileReader(self, strFileExtension, varReaderType):
		'''
		Registers the file reader for specific data format.
		
		:param strFileExtension: str
		'''
		return self._oleobj_.InvokeTypes(1610743814, LCID, 1, (24, 0), ((8, 1), (13, 1)),strFileExtension
			, varReaderType)


	def ReloadDatafiles(self):
		'''
		Reload data files if the components are changed.
		'''
		return self._oleobj_.InvokeTypes(1610743841, LCID, 1, (24, 0), (),)


	def RemoveAllDataItems(self):
		'''
		Removes all data items.
		'''
		return self._oleobj_.InvokeTypes(1610743825, LCID, 1, (24, 0), (),)


	def RemoveDataItem(self, varItem):
		'''
		Removes the data item.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743824, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def SetXAxis(self, varItem):
		'''
		Sets specific DatabaseItem to the X-Axis.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_DataItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_IsPreviewMode(self):
		return self._ApplyTypes_(*(1610743833, 2, (11, 0), (), "IsPreviewMode", None))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_SelectedItems(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "SelectedItems", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_ShowCheckBox(self):
		return self._ApplyTypes_(*(1610743844, 2, (11, 0), (), "ShowCheckBox", None))

	def _set_IsPreviewMode(self, value):
		if "IsPreviewMode" in self.__dict__: self.__dict__["IsPreviewMode"] = value; return
		self._oleobj_.Invoke(*((1610743833, LCID, 4, 0) + (value,) + ()))
	def _set_ShowCheckBox(self, value):
		if "ShowCheckBox" in self.__dict__: self.__dict__["ShowCheckBox"] = value; return
		self._oleobj_.Invoke(*((1610743844, LCID, 4, 0) + (value,) + ()))

	DataItemCollection = property(_get_DataItemCollection, None)
	'''
	Gets the database Items that indicates tree view items.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	IsPreviewMode = property(_get_IsPreviewMode, _set_IsPreviewMode)
	'''
	Gets or sets a value indicating whether preview mode is on or off.

	:type: bool
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	SelectedItems = property(_get_SelectedItems, None)
	'''
	Gets the selected items.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	ShowCheckBox = property(_get_ShowCheckBox, _set_ShowCheckBox)
	'''
	Shows the check box for the database item.

	:type: bool
	'''

	_prop_map_set_function_ = {
		"_set_IsPreviewMode": _set_IsPreviewMode,
		"_set_ShowCheckBox": _set_ShowCheckBox,
	}
	_prop_map_get_ = {
		"DataItemCollection": (1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"IsPreviewMode": (1610743833, 2, (11, 0), (), "IsPreviewMode", None),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"SelectedItems": (1610743813, 2, (9, 0), (), "SelectedItems", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"ShowCheckBox": (1610743844, 2, (11, 0), (), "ShowCheckBox", None),
	}
	_prop_map_put_ = {
		"IsPreviewMode": ((1610743833, LCID, 4, 0),()),
		"ShowCheckBox": ((1610743844, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDataFileDatabaseItem(DispatchBaseClass):
	'''Defines interface for the DataFileDatabaseItem.'''
	CLSID = IID('{51E9CB85-08CD-49C0-8374-B22EB0236624}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def CanDrawItem(self):
		'''
		Gets a value indicateing whether this item can be drawn.
		
		:rtype: bool
		'''
		return self._oleobj_.InvokeTypes(1610743827, LCID, 1, (11, 0), (),)


	def GetPath(self):
		'''
		Gets the path of this item. eg. Bodies/Body1/Pos_TM
		
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (8, 0), (),)


	def GetRoot(self):
		'''
		Gets the root item.
		
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(1610743821, LCID, 1, (9, 0), (),)
		if ret is not None:
			ret = Dispatch(ret, 'GetRoot', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def _get_Entity(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "Entity", None))
	def _get_Header(self):
		return self._ApplyTypes_(*(1610743811, 2, (8, 0), (), "Header", None))
	def _get_IsChecked(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "IsChecked", None))
	def _get_IsExpanded(self):
		return self._ApplyTypes_(*(1610743819, 2, (11, 0), (), "IsExpanded", None))
	def _get_IsRemovedByFilter(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "IsRemovedByFilter", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsSelected", None))
	def _get_IsUserData(self):
		return self._ApplyTypes_(*(1610743826, 2, (11, 0), (), "IsUserData", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743813, 2, (11, 0), (), "IsVisible", None))
	def _get_IsXAxis(self):
		return self._ApplyTypes_(*(1610743825, 2, (11, 0), (), "IsXAxis", None))
	def _get_Items(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Items", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_Parent(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "Parent", '{6F99EEE7-09F6-4708-8179-6DEA5376493F}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))
	def _set_IsChecked(self, value):
		if "IsChecked" in self.__dict__: self.__dict__["IsChecked"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_IsExpanded(self, value):
		if "IsExpanded" in self.__dict__: self.__dict__["IsExpanded"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_IsRemovedByFilter(self, value):
		if "IsRemovedByFilter" in self.__dict__: self.__dict__["IsRemovedByFilter"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	Entity = property(_get_Entity, None)
	'''
	Gets the entity that associated with this DatabaseItem.

	:type: object
	'''
	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header. The header displays the text of tree view item.

	:type: str
	'''
	IsChecked = property(_get_IsChecked, _set_IsChecked)
	'''
	Gets or sets this item is checked.

	:type: bool
	'''
	IsExpanded = property(_get_IsExpanded, _set_IsExpanded)
	'''
	Gets or sets a value indicating whether this item is expanded.

	:type: bool
	'''
	IsRemovedByFilter = property(_get_IsRemovedByFilter, _set_IsRemovedByFilter)
	'''
	Gets or sets a value indicating whether this item is removed by filter.

	:type: bool
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this item is selected.

	:type: bool
	'''
	IsUserData = property(_get_IsUserData, None)
	'''
	Gets a value indicating whether this item is user data.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this item is visible.

	:type: bool
	'''
	IsXAxis = property(_get_IsXAxis, None)
	'''
	Gets or sets a value indicating whether this item is X-Axis.

	:type: bool
	'''
	Items = property(_get_Items, None)
	'''
	Gets the DatabaseItems.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	Parent = property(_get_Parent, None)
	'''
	Gets the parent DatabaseItem.

	:type: recurdyn.Post.IDatabaseItem
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
		"_set_IsChecked": _set_IsChecked,
		"_set_IsExpanded": _set_IsExpanded,
		"_set_IsRemovedByFilter": _set_IsRemovedByFilter,
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
	}
	_prop_map_get_ = {
		"Entity": (1610743808, 2, (12, 0), (), "Entity", None),
		"Header": (1610743811, 2, (8, 0), (), "Header", None),
		"IsChecked": (1610743817, 2, (11, 0), (), "IsChecked", None),
		"IsExpanded": (1610743819, 2, (11, 0), (), "IsExpanded", None),
		"IsRemovedByFilter": (1610743823, 2, (11, 0), (), "IsRemovedByFilter", None),
		"IsSelected": (1610743815, 2, (11, 0), (), "IsSelected", None),
		"IsUserData": (1610743826, 2, (11, 0), (), "IsUserData", None),
		"IsVisible": (1610743813, 2, (11, 0), (), "IsVisible", None),
		"IsXAxis": (1610743825, 2, (11, 0), (), "IsXAxis", None),
		"Items": (1610743810, 2, (9, 0), (), "Items", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"Parent": (1610743809, 2, (9, 0), (), "Parent", '{6F99EEE7-09F6-4708-8179-6DEA5376493F}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743811, LCID, 4, 0),()),
		"IsChecked": ((1610743817, LCID, 4, 0),()),
		"IsExpanded": ((1610743819, LCID, 4, 0),()),
		"IsRemovedByFilter": ((1610743823, LCID, 4, 0),()),
		"IsSelected": ((1610743815, LCID, 4, 0),()),
		"IsVisible": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDatabase(DispatchBaseClass):
	'''Defines interface for the Database.'''
	CLSID = IID('{EB36D341-662E-4766-8874-AA7599565479}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ExpandAll(self):
		'''
		Expands all tree items.
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), (),)


	def ExpandItem(self, varDatabaseItem):
		'''
		Expands the TreeView item with the specific item.
		
		:param varDatabaseItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743812, LCID, 1, (24, 0), ((9, 1),),varDatabaseItem
			)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_DataItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))

	DataItemCollection = property(_get_DataItemCollection, None)
	'''
	Gets the database Items that indicates tree view items.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"DataItemCollection": (1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDatabaseItem(DispatchBaseClass):
	'''Defines interface for the DatabaseItem.'''
	CLSID = IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def GetPath(self):
		'''
		Gets the path of this item. eg. Bodies/Body1/Pos_TM
		
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (8, 0), (),)


	def GetRoot(self):
		'''
		Gets the root item.
		
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(1610743821, LCID, 1, (9, 0), (),)
		if ret is not None:
			ret = Dispatch(ret, 'GetRoot', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def _get_Entity(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "Entity", None))
	def _get_Header(self):
		return self._ApplyTypes_(*(1610743811, 2, (8, 0), (), "Header", None))
	def _get_IsChecked(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "IsChecked", None))
	def _get_IsExpanded(self):
		return self._ApplyTypes_(*(1610743819, 2, (11, 0), (), "IsExpanded", None))
	def _get_IsRemovedByFilter(self):
		return self._ApplyTypes_(*(1610743823, 2, (11, 0), (), "IsRemovedByFilter", None))
	def _get_IsSelected(self):
		return self._ApplyTypes_(*(1610743815, 2, (11, 0), (), "IsSelected", None))
	def _get_IsVisible(self):
		return self._ApplyTypes_(*(1610743813, 2, (11, 0), (), "IsVisible", None))
	def _get_Items(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Items", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_Parent(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "Parent", '{6F99EEE7-09F6-4708-8179-6DEA5376493F}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))
	def _set_IsChecked(self, value):
		if "IsChecked" in self.__dict__: self.__dict__["IsChecked"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_IsExpanded(self, value):
		if "IsExpanded" in self.__dict__: self.__dict__["IsExpanded"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))
	def _set_IsRemovedByFilter(self, value):
		if "IsRemovedByFilter" in self.__dict__: self.__dict__["IsRemovedByFilter"] = value; return
		self._oleobj_.Invoke(*((1610743823, LCID, 4, 0) + (value,) + ()))
	def _set_IsSelected(self, value):
		if "IsSelected" in self.__dict__: self.__dict__["IsSelected"] = value; return
		self._oleobj_.Invoke(*((1610743815, LCID, 4, 0) + (value,) + ()))
	def _set_IsVisible(self, value):
		if "IsVisible" in self.__dict__: self.__dict__["IsVisible"] = value; return
		self._oleobj_.Invoke(*((1610743813, LCID, 4, 0) + (value,) + ()))

	Entity = property(_get_Entity, None)
	'''
	Gets the entity that associated with this DatabaseItem.

	:type: object
	'''
	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header. The header displays the text of tree view item.

	:type: str
	'''
	IsChecked = property(_get_IsChecked, _set_IsChecked)
	'''
	Gets or sets this item is checked.

	:type: bool
	'''
	IsExpanded = property(_get_IsExpanded, _set_IsExpanded)
	'''
	Gets or sets a value indicating whether this item is expanded.

	:type: bool
	'''
	IsRemovedByFilter = property(_get_IsRemovedByFilter, _set_IsRemovedByFilter)
	'''
	Gets or sets a value indicating whether this item is removed by filter.

	:type: bool
	'''
	IsSelected = property(_get_IsSelected, _set_IsSelected)
	'''
	Gets or sets a value indicating whether this item is selected.

	:type: bool
	'''
	IsVisible = property(_get_IsVisible, _set_IsVisible)
	'''
	Gets or sets a value indicating whether this item is visible.

	:type: bool
	'''
	Items = property(_get_Items, None)
	'''
	Gets the DatabaseItems.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	Parent = property(_get_Parent, None)
	'''
	Gets the parent DatabaseItem.

	:type: recurdyn.Post.IDatabaseItem
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
		"_set_IsChecked": _set_IsChecked,
		"_set_IsExpanded": _set_IsExpanded,
		"_set_IsRemovedByFilter": _set_IsRemovedByFilter,
		"_set_IsSelected": _set_IsSelected,
		"_set_IsVisible": _set_IsVisible,
	}
	_prop_map_get_ = {
		"Entity": (1610743808, 2, (12, 0), (), "Entity", None),
		"Header": (1610743811, 2, (8, 0), (), "Header", None),
		"IsChecked": (1610743817, 2, (11, 0), (), "IsChecked", None),
		"IsExpanded": (1610743819, 2, (11, 0), (), "IsExpanded", None),
		"IsRemovedByFilter": (1610743823, 2, (11, 0), (), "IsRemovedByFilter", None),
		"IsSelected": (1610743815, 2, (11, 0), (), "IsSelected", None),
		"IsVisible": (1610743813, 2, (11, 0), (), "IsVisible", None),
		"Items": (1610743810, 2, (9, 0), (), "Items", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"Parent": (1610743809, 2, (9, 0), (), "Parent", '{6F99EEE7-09F6-4708-8179-6DEA5376493F}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743811, LCID, 4, 0),()),
		"IsChecked": ((1610743817, LCID, 4, 0),()),
		"IsExpanded": ((1610743819, LCID, 4, 0),()),
		"IsRemovedByFilter": ((1610743823, LCID, 4, 0),()),
		"IsSelected": ((1610743815, LCID, 4, 0),()),
		"IsVisible": ((1610743813, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IDatabaseItemCollection(DispatchBaseClass):
	'''Defines interface for the database item collection.'''
	CLSID = IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the database item by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def _get_Count(self):
		return self._ApplyTypes_(*(1610743810, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743810, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the database item by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IDatabaseItem
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{6F99EEE7-09F6-4708-8179-6DEA5376493F}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743810, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IDocumentCollection(DispatchBaseClass):
	'''Defines interface for the user control collection.'''
	CLSID = IID('{266467B4-9F50-45FF-BE2D-ADB933BE70DE}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the user control by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IControl
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{AAC98348-2902-49EA-BDBA-658775DB336E}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the user control by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the user control by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IControl
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{AAC98348-2902-49EA-BDBA-658775DB336E}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{AAC98348-2902-49EA-BDBA-658775DB336E}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{AAC98348-2902-49EA-BDBA-658775DB336E}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IDraw3DDatabase(DispatchBaseClass):
	'''Defines interface for the 3D draw database operation.'''
	CLSID = IID('{39230EEA-3374-400E-9489-2A7AEBB2E530}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def DrawSeries(self):
		'''
		Draw a series with the specific data components.
		'''
		return self._oleobj_.InvokeTypes(1610743813, LCID, 1, (24, 0), (),)


	def SetXComponent(self, strPath, iIndex):
		'''
		Sets X component for the Draw3DDatabaseOperation.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743814, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def SetYComponent(self, strPath, iIndex):
		'''
		Sets the Y component for the Draw3DDatabaseOperation.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743815, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def SetZComponent(self, strPath, iIndex):
		'''
		Sets the Z component for the Draw3DDatabaseOperation.
		
		:param strPath: str
		:param iIndex: int
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((8, 1), (3, 1)),strPath
			, iIndex)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_XComponent(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "XComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_YComponent(self):
		return self._ApplyTypes_(*(1610743811, 2, (9, 0), (), "YComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))
	def _get_ZComponent(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "ZComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'))

	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	XComponent = property(_get_XComponent, None)
	'''
	Gets or sets the component for x-axis.

	:type: recurdyn.Post.IDataComponent
	'''
	YComponent = property(_get_YComponent, None)
	'''
	Gets or sets the component for y-axis.

	:type: recurdyn.Post.IDataComponent
	'''
	ZComponent = property(_get_ZComponent, None)
	'''
	Gets or sets the component for z-axis.

	:type: recurdyn.Post.IDataComponent
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"XComponent": (1610743810, 2, (9, 0), (), "XComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"YComponent": (1610743811, 2, (9, 0), (), "YComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
		"ZComponent": (1610743812, 2, (9, 0), (), "ZComponent", '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntity(DispatchBaseClass):
	'''Defines the interface to manager entity.'''
	CLSID = IID('{E0C292B7-592C-4F26-B935-578E8229E9E7}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntityCollection(DispatchBaseClass):
	'''Defines interface for the entity collection.'''
	CLSID = IID('{05E42E73-072B-4DCB-9FFE-5412165947AF}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the entity by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IEntity
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{E0C292B7-592C-4F26-B935-578E8229E9E7}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the entity by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the entity by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IEntity
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{E0C292B7-592C-4F26-B935-578E8229E9E7}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{E0C292B7-592C-4F26-B935-578E8229E9E7}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{E0C292B7-592C-4F26-B935-578E8229E9E7}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IEntityDocument(DispatchBaseClass):
	'''Defines interface for the EntityDocument.'''
	CLSID = IID('{89E7C670-EDA4-4814-956B-C1B9B745B079}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_EntityManager(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "EntityManager", '{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	EntityManager = property(_get_EntityManager, None)
	'''
	Gets the EntityManager.

	:type: recurdyn.Post.IEntityManager
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"EntityManager": (1610743812, 2, (9, 0), (), "EntityManager", '{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntityManager(DispatchBaseClass):
	'''Defines the interface to manager entity creation, add, remove, collection.'''
	CLSID = IID('{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def GetNewEntityName(self, strKey):
		'''
		Returns a value that name of new entity.
		
		:param strKey: str
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743809, LCID, 1, (8, 0), ((8, 1),),strKey
			)


	def _get_Collection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Collection", '{05E42E73-072B-4DCB-9FFE-5412165947AF}'))
	def _get_LastEntityID(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "LastEntityID", None))

	Collection = property(_get_Collection, None)
	'''
	Gets the entity collection.

	:type: recurdyn.Post.IEntityCollection
	'''
	LastEntityID = property(_get_LastEntityID, None)
	'''
	Gets a value that indicates last entity id.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Collection": (1610743810, 2, (9, 0), (), "Collection", '{05E42E73-072B-4DCB-9FFE-5412165947AF}'),
		"LastEntityID": (1610743808, 2, (3, 0), (), "LastEntityID", None),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntityModel(DispatchBaseClass):
	'''Defines interface for the EntityModel.'''
	CLSID = IID('{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_EntityManager(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "EntityManager", '{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}'))
	def _get_FilePath(self):
		return self._ApplyTypes_(*(1610743813, 2, (8, 0), (), "FilePath", None))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	EntityManager = property(_get_EntityManager, None)
	'''
	Gets or sets the entity manager.

	:type: recurdyn.Post.IEntityManager
	'''
	FilePath = property(_get_FilePath, None)
	'''
	Gets the model path.

	:type: str
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"EntityManager": (1610743812, 2, (9, 0), (), "EntityManager", '{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}'),
		"FilePath": (1610743813, 2, (8, 0), (), "FilePath", None),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntityPlot(DispatchBaseClass):
	'''Defines interface for the EntityPlot.'''
	CLSID = IID('{02444C62-D19B-4934-9572-E6677E061882}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Chart(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Chart", '{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Chart = property(_get_Chart, None)
	'''
	Gets the Chart.

	:type: recurdyn.Post.IChart
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"Chart": (1610743812, 2, (9, 0), (), "Chart", '{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IEntityPlot3D(DispatchBaseClass):
	'''Defines interface of the EntityPlot3D.'''
	CLSID = IID('{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Chart3D(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Chart3D", '{919C04CC-90E5-409E-85F3-3256F29E6247}'))
	def _get_FullName(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "FullName", None))
	def _get_ID(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "ID", None))
	def _get_Name(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Name", None))

	def _set_Name(self, value):
		if "Name" in self.__dict__: self.__dict__["Name"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Chart3D = property(_get_Chart3D, None)
	'''
	Gets the Chart3D.

	:type: recurdyn.Post.IChart3D
	'''
	FullName = property(_get_FullName, None)
	'''
	Gets the full name of entity.

	:type: str
	'''
	ID = property(_get_ID, None)
	'''
	Gets the id of entity.

	:type: int
	'''
	Name = property(_get_Name, _set_Name)
	'''
	Gets or Sets the name of entity.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Name": _set_Name,
	}
	_prop_map_get_ = {
		"Chart3D": (1610743812, 2, (9, 0), (), "Chart3D", '{919C04CC-90E5-409E-85F3-3256F29E6247}'),
		"FullName": (1610743810, 2, (8, 0), (), "FullName", None),
		"ID": (1610743811, 2, (3, 0), (), "ID", None),
		"Name": (1610743808, 2, (8, 0), (), "Name", None),
	}
	_prop_map_put_ = {
		"Name": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class ILegendColor(DispatchBaseClass):
	'''Defines interface of the LegendColor.'''
	CLSID = IID('{19FB473A-3BE9-49D5-96D7-62F8496706B0}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Color(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'))
	def _get_EndValue(self):
		return self._ApplyTypes_(*(1610743811, 2, (5, 0), (), "EndValue", None))
	def _get_StartValue(self):
		return self._ApplyTypes_(*(1610743809, 2, (5, 0), (), "StartValue", None))

	def _set_StartValue(self, value):
		if "StartValue" in self.__dict__: self.__dict__["StartValue"] = value; return
		self._oleobj_.Invoke(*((1610743809, LCID, 4, 0) + (value,) + ()))

	Color = property(_get_Color, None)
	'''
	Gets or sets the color.

	:type: recurdyn.Post.IColor
	'''
	EndValue = property(_get_EndValue, None)
	'''
	Gets the end value.

	:type: float
	'''
	StartValue = property(_get_StartValue, _set_StartValue)
	'''
	Gets or sets the start value.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_StartValue": _set_StartValue,
	}
	_prop_map_get_ = {
		"Color": (1610743808, 2, (9, 0), (), "Color", '{5CD358A2-1CC0-46BF-B605-C48C52949E59}'),
		"EndValue": (1610743811, 2, (5, 0), (), "EndValue", None),
		"StartValue": (1610743809, 2, (5, 0), (), "StartValue", None),
	}
	_prop_map_put_ = {
		"StartValue": ((1610743809, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IMainDocument(DispatchBaseClass):
	'''Defines interface for the MainDocument.'''
	CLSID = IID('{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ApplySettings(self, strFilepath, varUserControl):
		'''
		Applies the settings to target user control from the specified file.
		
		:param strFilepath: str
		:param varUserControl: IControl
		'''
		return self._oleobj_.InvokeTypes(1610743831, LCID, 1, (24, 0), ((8, 1), (9, 1)),strFilepath
			, varUserControl)


	def ApplySettingsAll(self, strFilepath):
		'''
		Applies the settings to all models from the specified file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743832, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def CloseAllModelDocument(self):
		'''
		Closes all model document.
		'''
		return self._oleobj_.InvokeTypes(1610743826, LCID, 1, (24, 0), (),)


	def CloseModelDocument(self, varModelControl):
		'''
		Closes the model document.
		
		:param varModelControl: IControl
		'''
		return self._oleobj_.InvokeTypes(1610743825, LCID, 1, (24, 0), ((9, 1),),varModelControl
			)


	def ConvertToChunkFormat(self, strFilepath):
		'''
		Converts plot data file (.rplt...) to chunk format file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743828, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def CreateModel(self):
		'''
		Creates the model control.
		
		:rtype: recurdyn.Post.IModel
		'''
		ret = self._oleobj_.InvokeTypes(1610743835, LCID, 1, (9, 0), (),)
		if ret is not None:
			ret = Dispatch(ret, 'CreateModel', '{9D70138C-0DCA-4B63-951F-BCECB67522AE}')
		return ret

	def CreateModelWithPlot(self):
		'''
		Creates the model control with plot control.
		
		:rtype: recurdyn.Post.IModel
		'''
		ret = self._oleobj_.InvokeTypes(1610743834, LCID, 1, (9, 0), (),)
		if ret is not None:
			ret = Dispatch(ret, 'CreateModelWithPlot', '{9D70138C-0DCA-4B63-951F-BCECB67522AE}')
		return ret

	def CreatePlot(self, enPosition):
		'''
		Creates the plot control to the active model control.
		
		:param enPosition: Alignment
		:rtype: recurdyn.Post.IPlot
		'''
		ret = self._oleobj_.InvokeTypes(1610743836, LCID, 1, (9, 0), ((3, 1),),enPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'CreatePlot', '{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}')
		return ret

	def CreatePlot3D(self, enPosition):
		'''
		Creates the plot control to the active model control.
		
		:param enPosition: Alignment
		:rtype: recurdyn.Post.IPlot3D
		'''
		ret = self._oleobj_.InvokeTypes(1610743837, LCID, 1, (9, 0), ((3, 1),),enPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'CreatePlot3D', '{B7613ED0-4431-4A2B-829D-86D5A07B9C99}')
		return ret

	def ExportPlot(self, strFilepath):
		'''
		Exports the current active Plot.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743829, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def ImportDataFile(self, strFilepath):
		'''
		Imports the data file. Support format are txt, csv, rplt, vplt, chnk.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743827, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def OpenModel(self, strFilepath):
		'''
		Opens the model.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743824, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def ResetAllSettings(self):
		'''
		Resets all settings.
		'''
		return self._oleobj_.InvokeTypes(1610743833, LCID, 1, (24, 0), (),)


	def SaveModel(self, strFilepath):
		'''
		Saves the model to file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743823, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def SaveSettings(self, strFilepath):
		'''
		Saves the settings to file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743830, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def ShowTimeLine(self, bIsShown):
		return self._oleobj_.InvokeTypes(1610743838, LCID, 1, (24, 0), ((11, 1),),bIsShown
			)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_ActiveModel(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "ActiveModel", '{9D70138C-0DCA-4B63-951F-BCECB67522AE}'))
	def _get_ActivePlot(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "ActivePlot", '{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}'))
	def _get_ActivePlot3D(self):
		return self._ApplyTypes_(*(1610743821, 2, (9, 0), (), "ActivePlot3D", '{B7613ED0-4431-4A2B-829D-86D5A07B9C99}'))
	def _get_AnalysisFunctions(self):
		return self._ApplyTypes_(*(1610743839, 2, (9, 0), (), "AnalysisFunctions", '{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}'))
	def _get_CampbellDiagram(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "CampbellDiagram", '{2C300492-3E47-49C4-9B4A-CF44F434A0F5}'))
	def _get_Config(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Config", '{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}'))
	def _get_DataFileDatabase(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "DataFileDatabase", '{979D321D-21DC-43D0-83BF-E1E7B75384F1}'))
	def _get_Draw3DDatabase(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "Draw3DDatabase", '{39230EEA-3374-400E-9489-2A7AEBB2E530}'))
	def _get_ModelCollection(self):
		return self._ApplyTypes_(*(1610743822, 2, (9, 0), (), "ModelCollection", '{F30A1F02-5258-4FA0-A579-16829304270F}'))
	def _get_ModelDatabase(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "ModelDatabase", '{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}'))
	def _get_Output(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Output", '{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_RecentFiles(self):
		return self._ApplyTypes_(*(1610743818, 2, (8200, 0), (), "RecentFiles", None))
	def _get_Ribbon(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "Ribbon", '{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}'))
	def _get_ThemeManager(self):
		return self._ApplyTypes_(*(1610743811, 2, (9, 0), (), "ThemeManager", '{016C03D7-5933-4AE7-851D-87B1006287CA}'))

	ActiveModel = property(_get_ActiveModel, None)
	'''
	Gets the active model operation.

	:type: recurdyn.Post.IModel
	'''
	ActivePlot = property(_get_ActivePlot, None)
	'''
	Gets the active plot.

	:type: recurdyn.Post.IPlot
	'''
	ActivePlot3D = property(_get_ActivePlot3D, None)
	'''
	Gets the active plot3D.

	:type: recurdyn.Post.IPlot3D
	'''
	AnalysisFunctions = property(_get_AnalysisFunctions, None)
	CampbellDiagram = property(_get_CampbellDiagram, None)
	'''
	Gets the campbell diagram.

	:type: recurdyn.Post.ICampbellDiagram
	'''
	Config = property(_get_Config, None)
	'''
	Gets the configuration of application.

	:type: recurdyn.Post.IApplicationConfig
	'''
	DataFileDatabase = property(_get_DataFileDatabase, None)
	'''
	Gets the data file database.

	:type: recurdyn.Post.IDataFileDatabase
	'''
	Draw3DDatabase = property(_get_Draw3DDatabase, None)
	'''
	Gets the 3D draw database.

	:type: recurdyn.Post.IDraw3DDatabase
	'''
	ModelCollection = property(_get_ModelCollection, None)
	'''
	Gets the model control collection.

	:type: recurdyn.Post.IModelCollection
	'''
	ModelDatabase = property(_get_ModelDatabase, None)
	'''
	Gets the model database.

	:type: recurdyn.Post.IModelDatabase
	'''
	Output = property(_get_Output, None)
	'''
	Gets the output.

	:type: recurdyn.Post.IOutput
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	RecentFiles = property(_get_RecentFiles, None)
	'''
	Gets the recent used files.

	:type: list[str]
	'''
	Ribbon = property(_get_Ribbon, None)
	'''
	Gets the ribbon.

	:type: recurdyn.Post.IRibbon
	'''
	ThemeManager = property(_get_ThemeManager, None)
	'''
	Gets the theme manager. This ThemeManager provides variable UI styles.

	:type: recurdyn.Post.IThemeManager
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ActiveModel": (1610743819, 2, (9, 0), (), "ActiveModel", '{9D70138C-0DCA-4B63-951F-BCECB67522AE}'),
		"ActivePlot": (1610743820, 2, (9, 0), (), "ActivePlot", '{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}'),
		"ActivePlot3D": (1610743821, 2, (9, 0), (), "ActivePlot3D", '{B7613ED0-4431-4A2B-829D-86D5A07B9C99}'),
		"AnalysisFunctions": (1610743839, 2, (9, 0), (), "AnalysisFunctions", '{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}'),
		"CampbellDiagram": (1610743817, 2, (9, 0), (), "CampbellDiagram", '{2C300492-3E47-49C4-9B4A-CF44F434A0F5}'),
		"Config": (1610743810, 2, (9, 0), (), "Config", '{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}'),
		"DataFileDatabase": (1610743815, 2, (9, 0), (), "DataFileDatabase", '{979D321D-21DC-43D0-83BF-E1E7B75384F1}'),
		"Draw3DDatabase": (1610743814, 2, (9, 0), (), "Draw3DDatabase", '{39230EEA-3374-400E-9489-2A7AEBB2E530}'),
		"ModelCollection": (1610743822, 2, (9, 0), (), "ModelCollection", '{F30A1F02-5258-4FA0-A579-16829304270F}'),
		"ModelDatabase": (1610743813, 2, (9, 0), (), "ModelDatabase", '{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}'),
		"Output": (1610743812, 2, (9, 0), (), "Output", '{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"RecentFiles": (1610743818, 2, (8200, 0), (), "RecentFiles", None),
		"Ribbon": (1610743816, 2, (9, 0), (), "Ribbon", '{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}'),
		"ThemeManager": (1610743811, 2, (9, 0), (), "ThemeManager", '{016C03D7-5933-4AE7-851D-87B1006287CA}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IMainViewModel(DispatchBaseClass):
	'''Defines interface for the MainViewModel. This interface provides the funtion commands for the ribbon menu.'''
	CLSID = IID('{5841003A-8AD8-4788-B5E0-B979B7EEA37F}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Update(self):
		'''
		Updates this ViewModel. This function call the OnPropertyChanged for all of properties. Call this function if the control (UI) need for update.
		'''
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (24, 0), (),)


	def _get_AddYAxisCommand(self):
		return self._ApplyTypes_(*(1610743829, 2, (9, 0), (), "AddYAxisCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_AnimationMoveFrameCommand(self):
		return self._ApplyTypes_(*(1610743858, 2, (9, 0), (), "AnimationMoveFrameCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_AnimationPlayCommand(self):
		return self._ApplyTypes_(*(1610743857, 2, (9, 0), (), "AnimationPlayCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_AnimationStopCommand(self):
		return self._ApplyTypes_(*(1610743859, 2, (9, 0), (), "AnimationStopCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ApplySettingAllCommand(self):
		return self._ApplyTypes_(*(1610743842, 2, (9, 0), (), "ApplySettingAllCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ApplySettingToCurrentModelCommand(self):
		return self._ApplyTypes_(*(1610743843, 2, (9, 0), (), "ApplySettingToCurrentModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ApplySettingToCurrentPlotCommand(self):
		return self._ApplyTypes_(*(1610743844, 2, (9, 0), (), "ApplySettingToCurrentPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ChangeDataFileModelCommand(self):
		return self._ApplyTypes_(*(1610743862, 2, (9, 0), (), "ChangeDataFileModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ChangeDataFilePlotCommand(self):
		return self._ApplyTypes_(*(1610743863, 2, (9, 0), (), "ChangeDataFilePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_CloseActiveModelCommand(self):
		return self._ApplyTypes_(*(1610743817, 2, (9, 0), (), "CloseActiveModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_CloseAllModelCommand(self):
		return self._ApplyTypes_(*(1610743819, 2, (9, 0), (), "CloseAllModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_CloseModelCommand(self):
		return self._ApplyTypes_(*(1610743818, 2, (9, 0), (), "CloseModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ClosePlotCommand(self):
		return self._ApplyTypes_(*(1610743828, 2, (9, 0), (), "ClosePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_CompareDataFileModelCommand(self):
		return self._ApplyTypes_(*(1610743864, 2, (9, 0), (), "CompareDataFileModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_CompareDataFilePlotCommand(self):
		return self._ApplyTypes_(*(1610743865, 2, (9, 0), (), "CompareDataFilePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ExportDataToFileCommand(self):
		return self._ApplyTypes_(*(1610743824, 2, (9, 0), (), "ExportDataToFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ExportModelImageCommand(self):
		return self._ApplyTypes_(*(1610743826, 2, (9, 0), (), "ExportModelImageCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ExportUserControlImageCommand(self):
		return self._ApplyTypes_(*(1610743825, 2, (9, 0), (), "ExportUserControlImageCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ImportFileCommand(self):
		return self._ApplyTypes_(*(1610743823, 2, (9, 0), (), "ImportFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_MultipleAxisDrawOption(self):
		return self._ApplyTypes_(*(1610743830, 2, (3, 0), (), "MultipleAxisDrawOption", '{C038E096-9B57-3022-9044-B201C0B61CF7}'))
	def _get_NewModelCommand(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "NewModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_NewModelWithPlotCommand(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "NewModelWithPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_NewPlot3DCommand(self):
		return self._ApplyTypes_(*(1610743850, 2, (9, 0), (), "NewPlot3DCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_NewPlotCommand(self):
		return self._ApplyTypes_(*(1610743827, 2, (9, 0), (), "NewPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_OpenApplicationOptionsWindowCommand(self):
		return self._ApplyTypes_(*(1610743822, 2, (9, 0), (), "OpenApplicationOptionsWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_OpenDefaultSettingFolderCommand(self):
		return self._ApplyTypes_(*(1610743847, 2, (9, 0), (), "OpenDefaultSettingFolderCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_OpenHelpCommand(self):
		return self._ApplyTypes_(*(1610743821, 2, (9, 0), (), "OpenHelpCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_OpenModelCommand(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "OpenModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_Operation(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "Operation", '{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "ParentControl", None))
	def _get_PreviewModeCommand(self):
		return self._ApplyTypes_(*(1610743849, 2, (9, 0), (), "PreviewModeCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_RecentFiles(self):
		return self._ApplyTypes_(*(1610743811, 2, (8201, 0), (), "RecentFiles", '{C3C429F9-8590-3A01-B2B2-434837F3D16D}'))
	def _get_ResetAllSettingsCommand(self):
		return self._ApplyTypes_(*(1610743848, 2, (9, 0), (), "ResetAllSettingsCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_RunCSharpScriptCommand(self):
		return self._ApplyTypes_(*(1610743853, 2, (9, 0), (), "RunCSharpScriptCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_RunCSharpScriptFileCommand(self):
		return self._ApplyTypes_(*(1610743854, 2, (9, 0), (), "RunCSharpScriptFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_RunChunkFormatConverterCommand(self):
		return self._ApplyTypes_(*(1610743851, 2, (9, 0), (), "RunChunkFormatConverterCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_RunCommandCommand(self):
		return self._ApplyTypes_(*(1610743855, 2, (9, 0), (), "RunCommandCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_SaveAsCommand(self):
		return self._ApplyTypes_(*(1610743816, 2, (9, 0), (), "SaveAsCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_SaveAsDefaultSettingCommand(self):
		return self._ApplyTypes_(*(1610743846, 2, (9, 0), (), "SaveAsDefaultSettingCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_SaveModelCommand(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "SaveModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_SaveSettingCommand(self):
		return self._ApplyTypes_(*(1610743845, 2, (9, 0), (), "SaveSettingCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_SelectThemeCommand(self):
		return self._ApplyTypes_(*(1610743820, 2, (9, 0), (), "SelectThemeCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowAnimationControlPropertyCommand(self):
		return self._ApplyTypes_(*(1610743860, 2, (9, 0), (), "ShowAnimationControlPropertyCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowCampbellDiagramCommand(self):
		return self._ApplyTypes_(*(1610743856, 2, (9, 0), (), "ShowCampbellDiagramCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowDataEditorWindowCommand(self):
		return self._ApplyTypes_(*(1610743840, 2, (9, 0), (), "ShowDataEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowDataFileDatabaseWindowCommand(self):
		return self._ApplyTypes_(*(1610743834, 2, (9, 0), (), "ShowDataFileDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowDraw3DDatabaseWindowCommand(self):
		return self._ApplyTypes_(*(1610743841, 2, (9, 0), (), "ShowDraw3DDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowFunctionEditorWindowCommand(self):
		return self._ApplyTypes_(*(1610743852, 2, (9, 0), (), "ShowFunctionEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowModelDatabaseWindowCommand(self):
		return self._ApplyTypes_(*(1610743833, 2, (9, 0), (), "ShowModelDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowOutputWindowCommand(self):
		return self._ApplyTypes_(*(1610743838, 2, (9, 0), (), "ShowOutputWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowPropertyGridWindowCommand(self):
		return self._ApplyTypes_(*(1610743839, 2, (9, 0), (), "ShowPropertyGridWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowScriptConsoleWindowCommand(self):
		return self._ApplyTypes_(*(1610743837, 2, (9, 0), (), "ShowScriptConsoleWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowScriptDatabaseWindowCommand(self):
		return self._ApplyTypes_(*(1610743835, 2, (9, 0), (), "ShowScriptDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowScriptEditorWindowCommand(self):
		return self._ApplyTypes_(*(1610743836, 2, (9, 0), (), "ShowScriptEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowSeriesInfoWindowCommand(self):
		return self._ApplyTypes_(*(1610743832, 2, (9, 0), (), "ShowSeriesInfoWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))
	def _get_ShowTimeLineCommand(self):
		return self._ApplyTypes_(*(1610743861, 2, (9, 0), (), "ShowTimeLineCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'))

	def _set_MultipleAxisDrawOption(self, value):
		if "MultipleAxisDrawOption" in self.__dict__: self.__dict__["MultipleAxisDrawOption"] = value; return
		self._oleobj_.Invoke(*((1610743830, LCID, 4, 0) + (value,) + ()))

	AddYAxisCommand = property(_get_AddYAxisCommand, None)
	'''
	Gets the command to add the Y-Axis to the currently active Plot document.

	:type: recurdyn.Post.ICommand
	'''
	AnimationMoveFrameCommand = property(_get_AnimationMoveFrameCommand, None)
	'''
	Gets the command to move animation to the specific frame.

	:type: recurdyn.Post.ICommand
	'''
	AnimationPlayCommand = property(_get_AnimationPlayCommand, None)
	'''
	Gets the command to play all animations of the currently active model.

	:type: recurdyn.Post.ICommand
	'''
	AnimationStopCommand = property(_get_AnimationStopCommand, None)
	'''
	Gets the command to stop playing animation.

	:type: recurdyn.Post.ICommand
	'''
	ApplySettingAllCommand = property(_get_ApplySettingAllCommand, None)
	'''
	Gets the command to apply settings to all models.

	:type: recurdyn.Post.ICommand
	'''
	ApplySettingToCurrentModelCommand = property(_get_ApplySettingToCurrentModelCommand, None)
	'''
	Gets the command to apply settings to the currently active model.

	:type: recurdyn.Post.ICommand
	'''
	ApplySettingToCurrentPlotCommand = property(_get_ApplySettingToCurrentPlotCommand, None)
	'''
	Gets the command to apply settings to the currently active plot.

	:type: recurdyn.Post.ICommand
	'''
	ChangeDataFileModelCommand = property(_get_ChangeDataFileModelCommand, None)
	'''
	Gets the command to change data file for the currently active model.

	:type: recurdyn.Post.ICommand
	'''
	ChangeDataFilePlotCommand = property(_get_ChangeDataFilePlotCommand, None)
	'''
	Gets the command to change data file for the currently active plot.

	:type: recurdyn.Post.ICommand
	'''
	CloseActiveModelCommand = property(_get_CloseActiveModelCommand, None)
	'''
	Gets the command to close the current active model document.

	:type: recurdyn.Post.ICommand
	'''
	CloseAllModelCommand = property(_get_CloseAllModelCommand, None)
	'''
	Gets the command to close all model documents.

	:type: recurdyn.Post.ICommand
	'''
	CloseModelCommand = property(_get_CloseModelCommand, None)
	'''
	Gets the command to close the specific model document.

	:type: recurdyn.Post.ICommand
	'''
	ClosePlotCommand = property(_get_ClosePlotCommand, None)
	'''
	Gets the command to close the current active plot document.

	:type: recurdyn.Post.ICommand
	'''
	CompareDataFileModelCommand = property(_get_CompareDataFileModelCommand, None)
	'''
	Gets the command to compare data file for the currently active model.

	:type: recurdyn.Post.ICommand
	'''
	CompareDataFilePlotCommand = property(_get_CompareDataFilePlotCommand, None)
	'''
	Gets the command to compare data file for the currently active plot.

	:type: recurdyn.Post.ICommand
	'''
	ExportDataToFileCommand = property(_get_ExportDataToFileCommand, None)
	'''
	Gets the command to export the data to file.

	:type: recurdyn.Post.ICommand
	'''
	ExportModelImageCommand = property(_get_ExportModelImageCommand, None)
	'''
	Gets the command to export a snapshot of active model to image file.

	:type: recurdyn.Post.ICommand
	'''
	ExportUserControlImageCommand = property(_get_ExportUserControlImageCommand, None)
	'''
	Gets the command to export a snapshot of active user control to image file. The user control indicates such as plot, venice animation, media window.

	:type: recurdyn.Post.ICommand
	'''
	ImportFileCommand = property(_get_ImportFileCommand, None)
	'''
	Gets the command to import a file.

	:type: recurdyn.Post.ICommand
	'''
	MultipleAxisDrawOption = property(_get_MultipleAxisDrawOption, _set_MultipleAxisDrawOption)
	'''
	Gets or sets the value of MultipleAxisDrawOption. Determines the axis creation behavior when drawing a series.

	:type: recurdyn.Post.MultipleAxisDrawOption
	'''
	NewModelCommand = property(_get_NewModelCommand, None)
	'''
	Gets the command to create new model document.

	:type: recurdyn.Post.ICommand
	'''
	NewModelWithPlotCommand = property(_get_NewModelWithPlotCommand, None)
	'''
	Gets the command to create new model document with a plot document.

	:type: recurdyn.Post.ICommand
	'''
	NewPlot3DCommand = property(_get_NewPlot3DCommand, None)
	'''
	Gets the command to creates new plot3D document command.

	:type: recurdyn.Post.ICommand
	'''
	NewPlotCommand = property(_get_NewPlotCommand, None)
	'''
	Gets the command to create new plot document in active model.

	:type: recurdyn.Post.ICommand
	'''
	OpenApplicationOptionsWindowCommand = property(_get_OpenApplicationOptionsWindowCommand, None)
	'''
	Gets the command to open the application option window.

	:type: recurdyn.Post.ICommand
	'''
	OpenDefaultSettingFolderCommand = property(_get_OpenDefaultSettingFolderCommand, None)
	'''
	Gets the command to open the default directory where setting file is stored.

	:type: recurdyn.Post.ICommand
	'''
	OpenHelpCommand = property(_get_OpenHelpCommand, None)
	'''
	Gets the command to open the help document.

	:type: recurdyn.Post.ICommand
	'''
	OpenModelCommand = property(_get_OpenModelCommand, None)
	'''
	Gets the command to open model document.

	:type: recurdyn.Post.ICommand
	'''
	Operation = property(_get_Operation, None)
	'''
	Gets the Operation related to this ViewModel.

	:type: recurdyn.Post.IOperation
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: object
	'''
	PreviewModeCommand = property(_get_PreviewModeCommand, None)
	'''
	Gets the command that indicates whether the PreviewMode is used.

	:type: recurdyn.Post.ICommand
	'''
	RecentFiles = property(_get_RecentFiles, None)
	'''
	Gets the recently used model files.

	:type: _FileInfo
	'''
	ResetAllSettingsCommand = property(_get_ResetAllSettingsCommand, None)
	'''
	Gets the command to reset all settings to application based defaults.

	:type: recurdyn.Post.ICommand
	'''
	RunCSharpScriptCommand = property(_get_RunCSharpScriptCommand, None)
	'''
	Gets the command to run the CSharp (C#) scripts.

	:type: recurdyn.Post.ICommand
	'''
	RunCSharpScriptFileCommand = property(_get_RunCSharpScriptFileCommand, None)
	'''
	Gets the command to run the CSharp (C#) script flie.

	:type: recurdyn.Post.ICommand
	'''
	RunChunkFormatConverterCommand = property(_get_RunChunkFormatConverterCommand, None)
	'''
	Gets the command to run the ChunkFormatConvert function.

	:type: recurdyn.Post.ICommand
	'''
	RunCommandCommand = property(_get_RunCommandCommand, None)
	'''
	Gets the command to run commands that defined by this application.

	:type: recurdyn.Post.ICommand
	'''
	SaveAsCommand = property(_get_SaveAsCommand, None)
	'''
	Gets the command to save current active model document or active plot document.

	:type: recurdyn.Post.ICommand
	'''
	SaveAsDefaultSettingCommand = property(_get_SaveAsDefaultSettingCommand, None)
	'''
	Gets the command to save settings from the currently active plot.

	:type: recurdyn.Post.ICommand
	'''
	SaveModelCommand = property(_get_SaveModelCommand, None)
	'''
	Gets the command to save current active model document.

	:type: recurdyn.Post.ICommand
	'''
	SaveSettingCommand = property(_get_SaveSettingCommand, None)
	'''
	Gets the command to save settings from the currently active plot.

	:type: recurdyn.Post.ICommand
	'''
	SelectThemeCommand = property(_get_SelectThemeCommand, None)
	'''
	Gets the command to select a theme for the application.

	:type: recurdyn.Post.ICommand
	'''
	ShowAnimationControlPropertyCommand = property(_get_ShowAnimationControlPropertyCommand, None)
	'''
	Gets the command to show the PropertyGrid of animation control.

	:type: recurdyn.Post.ICommand
	'''
	ShowCampbellDiagramCommand = property(_get_ShowCampbellDiagramCommand, None)
	'''
	Gets the command to show the Campbell Diagram window.

	:type: recurdyn.Post.ICommand
	'''
	ShowDataEditorWindowCommand = property(_get_ShowDataEditorWindowCommand, None)
	'''
	Gets the command that indicates whether the DataEditor window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowDataFileDatabaseWindowCommand = property(_get_ShowDataFileDatabaseWindowCommand, None)
	'''
	Gets the command that indicates whether the DataFile database window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowDraw3DDatabaseWindowCommand = property(_get_ShowDraw3DDatabaseWindowCommand, None)
	'''
	Gets the command to show the 3D-Draw Database window.

	:type: recurdyn.Post.ICommand
	'''
	ShowFunctionEditorWindowCommand = property(_get_ShowFunctionEditorWindowCommand, None)
	'''
	Gets the command to show the FunctionEditor window.

	:type: recurdyn.Post.ICommand
	'''
	ShowModelDatabaseWindowCommand = property(_get_ShowModelDatabaseWindowCommand, None)
	'''
	Gets the command that indicates whether the Model database window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowOutputWindowCommand = property(_get_ShowOutputWindowCommand, None)
	'''
	Gets the command that indicates whether the Output window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowPropertyGridWindowCommand = property(_get_ShowPropertyGridWindowCommand, None)
	'''
	Gets the command that indicates whether the PropertyGrid window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowScriptConsoleWindowCommand = property(_get_ShowScriptConsoleWindowCommand, None)
	'''
	Gets the command that indicates whether the ScriptConsole database window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowScriptDatabaseWindowCommand = property(_get_ShowScriptDatabaseWindowCommand, None)
	'''
	Gets the command that indicates whether the Script database window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowScriptEditorWindowCommand = property(_get_ShowScriptEditorWindowCommand, None)
	'''
	Gets the command that indicates whether the ScriptEditor database window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowSeriesInfoWindowCommand = property(_get_ShowSeriesInfoWindowCommand, None)
	'''
	Gets the command that indicates whether the series information window is shown.

	:type: recurdyn.Post.ICommand
	'''
	ShowTimeLineCommand = property(_get_ShowTimeLineCommand, None)
	'''
	Gets the command that indicates whether the time line is shown.

	:type: recurdyn.Post.ICommand
	'''

	_prop_map_set_function_ = {
		"_set_MultipleAxisDrawOption": _set_MultipleAxisDrawOption,
	}
	_prop_map_get_ = {
		"AddYAxisCommand": (1610743829, 2, (9, 0), (), "AddYAxisCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"AnimationMoveFrameCommand": (1610743858, 2, (9, 0), (), "AnimationMoveFrameCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"AnimationPlayCommand": (1610743857, 2, (9, 0), (), "AnimationPlayCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"AnimationStopCommand": (1610743859, 2, (9, 0), (), "AnimationStopCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ApplySettingAllCommand": (1610743842, 2, (9, 0), (), "ApplySettingAllCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ApplySettingToCurrentModelCommand": (1610743843, 2, (9, 0), (), "ApplySettingToCurrentModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ApplySettingToCurrentPlotCommand": (1610743844, 2, (9, 0), (), "ApplySettingToCurrentPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ChangeDataFileModelCommand": (1610743862, 2, (9, 0), (), "ChangeDataFileModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ChangeDataFilePlotCommand": (1610743863, 2, (9, 0), (), "ChangeDataFilePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"CloseActiveModelCommand": (1610743817, 2, (9, 0), (), "CloseActiveModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"CloseAllModelCommand": (1610743819, 2, (9, 0), (), "CloseAllModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"CloseModelCommand": (1610743818, 2, (9, 0), (), "CloseModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ClosePlotCommand": (1610743828, 2, (9, 0), (), "ClosePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"CompareDataFileModelCommand": (1610743864, 2, (9, 0), (), "CompareDataFileModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"CompareDataFilePlotCommand": (1610743865, 2, (9, 0), (), "CompareDataFilePlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ExportDataToFileCommand": (1610743824, 2, (9, 0), (), "ExportDataToFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ExportModelImageCommand": (1610743826, 2, (9, 0), (), "ExportModelImageCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ExportUserControlImageCommand": (1610743825, 2, (9, 0), (), "ExportUserControlImageCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ImportFileCommand": (1610743823, 2, (9, 0), (), "ImportFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"MultipleAxisDrawOption": (1610743830, 2, (3, 0), (), "MultipleAxisDrawOption", '{C038E096-9B57-3022-9044-B201C0B61CF7}'),
		"NewModelCommand": (1610743812, 2, (9, 0), (), "NewModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"NewModelWithPlotCommand": (1610743813, 2, (9, 0), (), "NewModelWithPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"NewPlot3DCommand": (1610743850, 2, (9, 0), (), "NewPlot3DCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"NewPlotCommand": (1610743827, 2, (9, 0), (), "NewPlotCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"OpenApplicationOptionsWindowCommand": (1610743822, 2, (9, 0), (), "OpenApplicationOptionsWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"OpenDefaultSettingFolderCommand": (1610743847, 2, (9, 0), (), "OpenDefaultSettingFolderCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"OpenHelpCommand": (1610743821, 2, (9, 0), (), "OpenHelpCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"OpenModelCommand": (1610743814, 2, (9, 0), (), "OpenModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"Operation": (1610743809, 2, (9, 0), (), "Operation", '{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}'),
		"ParentControl": (1610743808, 2, (12, 0), (), "ParentControl", None),
		"PreviewModeCommand": (1610743849, 2, (9, 0), (), "PreviewModeCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"RecentFiles": (1610743811, 2, (8201, 0), (), "RecentFiles", '{C3C429F9-8590-3A01-B2B2-434837F3D16D}'),
		"ResetAllSettingsCommand": (1610743848, 2, (9, 0), (), "ResetAllSettingsCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"RunCSharpScriptCommand": (1610743853, 2, (9, 0), (), "RunCSharpScriptCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"RunCSharpScriptFileCommand": (1610743854, 2, (9, 0), (), "RunCSharpScriptFileCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"RunChunkFormatConverterCommand": (1610743851, 2, (9, 0), (), "RunChunkFormatConverterCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"RunCommandCommand": (1610743855, 2, (9, 0), (), "RunCommandCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"SaveAsCommand": (1610743816, 2, (9, 0), (), "SaveAsCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"SaveAsDefaultSettingCommand": (1610743846, 2, (9, 0), (), "SaveAsDefaultSettingCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"SaveModelCommand": (1610743815, 2, (9, 0), (), "SaveModelCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"SaveSettingCommand": (1610743845, 2, (9, 0), (), "SaveSettingCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"SelectThemeCommand": (1610743820, 2, (9, 0), (), "SelectThemeCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowAnimationControlPropertyCommand": (1610743860, 2, (9, 0), (), "ShowAnimationControlPropertyCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowCampbellDiagramCommand": (1610743856, 2, (9, 0), (), "ShowCampbellDiagramCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowDataEditorWindowCommand": (1610743840, 2, (9, 0), (), "ShowDataEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowDataFileDatabaseWindowCommand": (1610743834, 2, (9, 0), (), "ShowDataFileDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowDraw3DDatabaseWindowCommand": (1610743841, 2, (9, 0), (), "ShowDraw3DDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowFunctionEditorWindowCommand": (1610743852, 2, (9, 0), (), "ShowFunctionEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowModelDatabaseWindowCommand": (1610743833, 2, (9, 0), (), "ShowModelDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowOutputWindowCommand": (1610743838, 2, (9, 0), (), "ShowOutputWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowPropertyGridWindowCommand": (1610743839, 2, (9, 0), (), "ShowPropertyGridWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowScriptConsoleWindowCommand": (1610743837, 2, (9, 0), (), "ShowScriptConsoleWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowScriptDatabaseWindowCommand": (1610743835, 2, (9, 0), (), "ShowScriptDatabaseWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowScriptEditorWindowCommand": (1610743836, 2, (9, 0), (), "ShowScriptEditorWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowSeriesInfoWindowCommand": (1610743832, 2, (9, 0), (), "ShowSeriesInfoWindowCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
		"ShowTimeLineCommand": (1610743861, 2, (9, 0), (), "ShowTimeLineCommand", '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}'),
	}
	_prop_map_put_ = {
		"MultipleAxisDrawOption": ((1610743830, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IModel(DispatchBaseClass):
	'''Defines interface for the ModelOperation.'''
	CLSID = IID('{9D70138C-0DCA-4B63-951F-BCECB67522AE}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ChangeDataFile(self, strFilepath):
		'''
		Changes the data file for all Plots.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743821, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def CloseSubDocument(self, varSubDocument):
		'''
		Closes the sub user control (Plot, Animation Control...).
		
		:param varSubDocument: IControl
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((9, 1),),varSubDocument
			)


	def CompareDataFile(self, strFilepath):
		'''
		Compares the data file for all Plots.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def ExportImage(self, srtFilepath):
		'''
		Exports model image to file (.bmp, .png, .jpg).
		
		:param srtFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), ((8, 1),),srtFilepath
			)


	def GetSubDocumentByName(self, strEntityName):
		'''
		Gets the name of the UserControl by the Plot entity name.
		
		:param strEntityName: str
		:rtype: recurdyn.Post.IControl
		'''
		ret = self._oleobj_.InvokeTypes(1610743819, LCID, 1, (9, 0), ((8, 1),),strEntityName
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetSubDocumentByName', '{AAC98348-2902-49EA-BDBA-658775DB336E}')
		return ret

	def ImportMedia(self, strFilepath):
		'''
		Imports the media file(.avi, .mkv, .mp4).
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def UpdateHeader(self):
		'''
		Updates the header by the Model name.
		'''
		return self._oleobj_.InvokeTypes(1610743820, LCID, 1, (24, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_ActiveDocument(self):
		return self._ApplyTypes_(*(1610743815, 2, (9, 0), (), "ActiveDocument", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_Animation(self):
		return self._ApplyTypes_(*(1610743812, 2, (9, 0), (), "Animation", '{5812880C-C727-4800-8762-E3EA5CFD8797}'))
	def _get_Model(self):
		return self._ApplyTypes_(*(1610743813, 2, (9, 0), (), "Model", '{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_ShowPaneHeader(self):
		return self._ApplyTypes_(*(1610743810, 2, (11, 0), (), "ShowPaneHeader", None))
	def _get_SubDocumentCollection(self):
		return self._ApplyTypes_(*(1610743814, 2, (9, 0), (), "SubDocumentCollection", '{266467B4-9F50-45FF-BE2D-ADB933BE70DE}'))

	def _set_ShowPaneHeader(self, value):
		if "ShowPaneHeader" in self.__dict__: self.__dict__["ShowPaneHeader"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))

	ActiveDocument = property(_get_ActiveDocument, None)
	'''
	Gets the current actived UserControl.

	:type: recurdyn.Post.IControl
	'''
	Animation = property(_get_Animation, None)
	'''
	Gets the Animation Operation. This Operation provides animation control in this Model.

	:type: recurdyn.Post.IAnimation
	'''
	Model = property(_get_Model, None)
	'''
	Gets the model entity.

	:type: recurdyn.Post.IEntityModel
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	ShowPaneHeader = property(_get_ShowPaneHeader, _set_ShowPaneHeader)
	'''
	Gets or sets a value indicating whether shows the pane header of all child user controls.

	:type: bool
	'''
	SubDocumentCollection = property(_get_SubDocumentCollection, None)
	'''
	Gets the child document collection (Plot Control, Animation Control...).

	:type: recurdyn.Post.IDocumentCollection
	'''

	_prop_map_set_function_ = {
		"_set_ShowPaneHeader": _set_ShowPaneHeader,
	}
	_prop_map_get_ = {
		"ActiveDocument": (1610743815, 2, (9, 0), (), "ActiveDocument", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"Animation": (1610743812, 2, (9, 0), (), "Animation", '{5812880C-C727-4800-8762-E3EA5CFD8797}'),
		"Model": (1610743813, 2, (9, 0), (), "Model", '{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"ShowPaneHeader": (1610743810, 2, (11, 0), (), "ShowPaneHeader", None),
		"SubDocumentCollection": (1610743814, 2, (9, 0), (), "SubDocumentCollection", '{266467B4-9F50-45FF-BE2D-ADB933BE70DE}'),
	}
	_prop_map_put_ = {
		"ShowPaneHeader": ((1610743810, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IModelCollection(DispatchBaseClass):
	'''Defines interface for the model control collection.'''
	CLSID = IID('{F30A1F02-5258-4FA0-A579-16829304270F}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the model control by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IControl
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{AAC98348-2902-49EA-BDBA-658775DB336E}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the model control by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the model control by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IControl
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{AAC98348-2902-49EA-BDBA-658775DB336E}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{AAC98348-2902-49EA-BDBA-658775DB336E}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{AAC98348-2902-49EA-BDBA-658775DB336E}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IModelDatabase(DispatchBaseClass):
	'''Defines interface for the ModelDatabase.'''
	CLSID = IID('{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ActivateWindow(self, varItem):
		'''
		Activates the window that indicates the Model or Plot control which have the specific DatabaseItem. If the input parameter is an EntityPlot, the Plot window will be activated. If the input parameter is an EntityModel, the Model window will be activated. if the input parameter is a chart entity, the Plot window of the chart entity will be activated.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def ExpandAll(self):
		'''
		Expands all tree items.
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), (),)


	def ExpandItem(self, varDatabaseItem):
		'''
		Expands the TreeView item with the specific item.
		
		:param varDatabaseItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743812, LCID, 1, (24, 0), ((9, 1),),varDatabaseItem
			)


	def OpenPropertyGrid(self, varItem):
		'''
		Opens the properties with the specific DatabaseItem.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743814, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def OpenPropertyGrid_2(self, varItems):
		'''
		Opens the properties with the specific DatabaseItem. The input items should be the ChartSeries entities.
		
		:param varItems: list[object]
		'''
		_varItems_type = True if varItems and isinstance(varItems[0], win32com.client.VARIANT) else False
		if not _varItems_type:
			varItems = [win32com.client.VARIANT(12, _data) for _data in varItems]

		ret = self._oleobj_.InvokeTypes(1610743815, LCID, 1, (24, 0), ((8204, 1),),varItems
			)

		if not _varItems_type:
			varItems = [_data.value for _data in varItems]

		return ret


	def OpenPropertyGrid_3(self, varItem, bForceOpen):
		'''
		Opens the properties with the specific DatabaseItem and flag. If the isForceOpen parameter is false, the properties window will be opend only when the pane is shown.
		
		:param varItem: IDatabaseItem
		:param bForceOpen: bool
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((9, 1), (11, 1)),varItem
			, bForceOpen)


	def RemoveDatabaseItem(self, varItem):
		'''
		Removes the DatabaseItem.
		
		:param varItem: IDatabaseItem
		'''
		return self._oleobj_.InvokeTypes(1610743813, LCID, 1, (24, 0), ((9, 1),),varItem
			)


	def UpdateDatabaseItemCollection(self):
		'''
		Updates the database item collection including all sub-items if an EntityModel has been changed.
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_DataItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))

	DataItemCollection = property(_get_DataItemCollection, None)
	'''
	Gets the database Items that indicates tree view items.

	:type: recurdyn.Post.IDatabaseItemCollection
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"DataItemCollection": (1610743810, 2, (9, 0), (), "DataItemCollection", '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IOperation(DispatchBaseClass):
	'''Defines interface for IOperation.'''
	CLSID = IID('{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def UpdateView(self):
		'''
		Updates the view.
		'''
		return self._oleobj_.InvokeTypes(1610743809, LCID, 1, (24, 0), (),)


	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743808, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))

	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ParentControl": (1610743808, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IOutput(DispatchBaseClass):
	'''Defines interface for the OutputOperation.'''
	CLSID = IID('{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ActiveLogTab(self):
		'''
		Actives the log tab.
		'''
		return self._oleobj_.InvokeTypes(1610743831, LCID, 1, (24, 0), (),)


	def ActiveMessageTab(self):
		'''
		Actives the message tab.
		'''
		return self._oleobj_.InvokeTypes(1610743830, LCID, 1, (24, 0), (),)


	def ClearMessage(self):
		'''
		Clears all messages.
		'''
		return self._oleobj_.InvokeTypes(1610743823, LCID, 1, (24, 0), (),)


	def GetAllLog(self):
		'''
		Gets all log.
		
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743829, LCID, 1, (8, 0), (),)


	def GetLastLog(self):
		'''
		Gets the last log string.
		
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743827, LCID, 1, (8, 0), (),)


	def GetLastMessage(self):
		'''
		Gets the last message.
		
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (8, 0), (),)


	def GetLog(self, iIndex):
		'''
		Gets the log with speciafic index.
		
		:param iIndex: int
		:rtype: str
		'''
		return self._oleobj_.InvokeTypes(1610743828, LCID, 1, (8, 0), ((3, 1),),iIndex
			)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def WriteError(self, strMessage, strTargetSite):
		'''
		Writes the error message.
		
		:param strMessage: str
		:param strTargetSite: str
		'''
		return self._ApplyTypes_(1610743811, 1, (24, 32), ((8, 1), (8, 49)), 'WriteError', None,strMessage
			, strTargetSite)


	def WriteInfo(self, strMessage, strTargetSite):
		'''
		Writes the information message.
		
		:param strMessage: str
		:param strTargetSite: str
		'''
		return self._ApplyTypes_(1610743813, 1, (24, 32), ((8, 1), (8, 49)), 'WriteInfo', None,strMessage
			, strTargetSite)


	def WriteLine(self, enMessageType, strMessage, strTargetSite):
		'''
		Writes the message with the MessageType.
		
		:param enMessageType: MessageType
		:param strMessage: str
		:param strTargetSite: str
		'''
		return self._oleobj_.InvokeTypes(1610743814, LCID, 1, (24, 0), ((3, 1), (8, 1), (8, 1)),enMessageType
			, strMessage, strTargetSite)


	def WriteLineAsync(self, enMessageType, strMessage, strTargetSite):
		'''
		Writes the message with the MessageType asynchronous. The Output window can be updated immediately.
		
		:param enMessageType: MessageType
		:param strMessage: str
		:param strTargetSite: str
		'''
		return self._oleobj_.InvokeTypes(1610743815, LCID, 1, (24, 0), ((3, 1), (8, 1), (8, 1)),enMessageType
			, strMessage, strTargetSite)


	def WriteLog(self, strMessage):
		'''
		Writes the log.
		
		:param strMessage: str
		'''
		return self._oleobj_.InvokeTypes(1610743824, LCID, 1, (24, 0), ((8, 1),),strMessage
			)


	def WriteLogAsync(self, strMessage):
		'''
		Writes the log asynchronous. The Output window can be updated immediately.
		
		:param strMessage: str
		'''
		return self._oleobj_.InvokeTypes(1610743825, LCID, 1, (24, 0), ((8, 1),),strMessage
			)


	def WriteWarning(self, strMessage, strTargetSite):
		'''
		Writes the warning message.
		
		:param strMessage: str
		:param strTargetSite: str
		'''
		return self._ApplyTypes_(1610743812, 1, (24, 32), ((8, 1), (8, 49)), 'WriteWarning', None,strMessage
			, strTargetSite)


	def _get_FilterMessageError(self):
		return self._ApplyTypes_(*(1610743817, 2, (11, 0), (), "FilterMessageError", None))
	def _get_FilterMessageInfo(self):
		return self._ApplyTypes_(*(1610743821, 2, (11, 0), (), "FilterMessageInfo", None))
	def _get_FilterMessageWarning(self):
		return self._ApplyTypes_(*(1610743819, 2, (11, 0), (), "FilterMessageWarning", None))
	def _get_LogLineCount(self):
		return self._ApplyTypes_(*(1610743826, 2, (3, 0), (), "LogLineCount", None))
	def _get_OutputMessages(self):
		return self._ApplyTypes_(*(1610743810, 2, (8201, 0), (), "OutputMessages", '{BD9429A4-0453-4C97-8808-C67749DCB02A}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))

	def _set_FilterMessageError(self, value):
		if "FilterMessageError" in self.__dict__: self.__dict__["FilterMessageError"] = value; return
		self._oleobj_.Invoke(*((1610743817, LCID, 4, 0) + (value,) + ()))
	def _set_FilterMessageInfo(self, value):
		if "FilterMessageInfo" in self.__dict__: self.__dict__["FilterMessageInfo"] = value; return
		self._oleobj_.Invoke(*((1610743821, LCID, 4, 0) + (value,) + ()))
	def _set_FilterMessageWarning(self, value):
		if "FilterMessageWarning" in self.__dict__: self.__dict__["FilterMessageWarning"] = value; return
		self._oleobj_.Invoke(*((1610743819, LCID, 4, 0) + (value,) + ()))

	FilterMessageError = property(_get_FilterMessageError, _set_FilterMessageError)
	'''
	Gets or sets a value indicating whether error message is filtered.

	:type: bool
	'''
	FilterMessageInfo = property(_get_FilterMessageInfo, _set_FilterMessageInfo)
	'''
	Gets or sets a value indicating whether info message is filtered.

	:type: bool
	'''
	FilterMessageWarning = property(_get_FilterMessageWarning, _set_FilterMessageWarning)
	'''
	Gets or sets a value indicating whether warning message is filtered.

	:type: bool
	'''
	LogLineCount = property(_get_LogLineCount, None)
	'''
	Gets the number of lines.

	:type: int
	'''
	OutputMessages = property(_get_OutputMessages, None)
	'''
	Gets the output messages.

	:type: recurdyn.Post.IOutputMessage
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''

	_prop_map_set_function_ = {
		"_set_FilterMessageError": _set_FilterMessageError,
		"_set_FilterMessageInfo": _set_FilterMessageInfo,
		"_set_FilterMessageWarning": _set_FilterMessageWarning,
	}
	_prop_map_get_ = {
		"FilterMessageError": (1610743817, 2, (11, 0), (), "FilterMessageError", None),
		"FilterMessageInfo": (1610743821, 2, (11, 0), (), "FilterMessageInfo", None),
		"FilterMessageWarning": (1610743819, 2, (11, 0), (), "FilterMessageWarning", None),
		"LogLineCount": (1610743826, 2, (3, 0), (), "LogLineCount", None),
		"OutputMessages": (1610743810, 2, (8201, 0), (), "OutputMessages", '{BD9429A4-0453-4C97-8808-C67749DCB02A}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
	}
	_prop_map_put_ = {
		"FilterMessageError": ((1610743817, LCID, 4, 0),()),
		"FilterMessageInfo": ((1610743821, LCID, 4, 0),()),
		"FilterMessageWarning": ((1610743819, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IOutputMessage(DispatchBaseClass):
	'''Defines the interface for IOutputMessage.'''
	CLSID = IID('{BD9429A4-0453-4C97-8808-C67749DCB02A}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Description(self):
		return self._ApplyTypes_(*(1610743809, 2, (8, 0), (), "Description", None))
	def _get_MessageType(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "MessageType", '{9BAD78DA-C0B0-3BE4-A134-CC7BFDF4E0F6}'))
	def _get_TargetSite(self):
		return self._ApplyTypes_(*(1610743810, 2, (8, 0), (), "TargetSite", None))

	Description = property(_get_Description, None)
	'''
	Gets or sets the description.

	:type: str
	'''
	MessageType = property(_get_MessageType, None)
	'''
	Gets or sets the type of the message.

	:type: recurdyn.Post.MessageType
	'''
	TargetSite = property(_get_TargetSite, None)
	'''
	Gets or sets the target site where the message occured.

	:type: str
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Description": (1610743809, 2, (8, 0), (), "Description", None),
		"MessageType": (1610743808, 2, (3, 0), (), "MessageType", '{9BAD78DA-C0B0-3BE4-A134-CC7BFDF4E0F6}'),
		"TargetSite": (1610743810, 2, (8, 0), (), "TargetSite", None),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IPlot(DispatchBaseClass):
	'''Defines interface for the PlotOperation.'''
	CLSID = IID('{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def ApplySetting(self, strFilepath):
		'''
		Applies the settings to this Plot from the specified file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def CreateArrowAnnotation(self, arrStartPoint, arrEndPoint):
		ret = self._oleobj_.InvokeTypes(1610743829, LCID, 1, (9, 0), ((8197, 1), (8197, 1)),arrStartPoint
			, arrEndPoint)
		if ret is not None:
			ret = Dispatch(ret, 'CreateArrowAnnotation', '{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}')
		return ret

	def CreateLineAnnotation(self, arrStartPoint, arrEndPoint):
		'''
		Creates the line annotation.
		
		:param arrStartPoint: list[float]
		:param arrEndPoint: list[float]
		:rtype: recurdyn.Post.IChartAnnotationLine
		'''
		ret = self._oleobj_.InvokeTypes(1610743827, LCID, 1, (9, 0), ((8197, 1), (8197, 1)),arrStartPoint
			, arrEndPoint)
		if ret is not None:
			ret = Dispatch(ret, 'CreateLineAnnotation', '{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}')
		return ret

	def CreateSeries(self, strSeriesName, arrXValue, arrYValue, strXAxisUnit, strYAxisUnit):
		'''
		Creates the series with the data values and unit.
		
		:param strSeriesName: str
		:param arrXValue: list[float]
		:param arrYValue: list[float]
		:param strXAxisUnit: str
		:param strYAxisUnit: str
		:rtype: recurdyn.Post.IChartSeries
		'''
		ret = self._oleobj_.InvokeTypes(1610743815, LCID, 1, (9, 0), ((8, 1), (8197, 1), (8197, 1), (8, 1), (8, 1)),strSeriesName
			, arrXValue, arrYValue, strXAxisUnit, strYAxisUnit)
		if ret is not None:
			ret = Dispatch(ret, 'CreateSeries', '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
		return ret

	def CreateSeriesWithAxis(self, strSeriesName, arrXValue, arrYValue, varXAxis, varYAxis, bUseUnitLegend):
		'''
		Creates the series with the parameters.
		
		:param strSeriesName: str
		:param arrXValue: list[float]
		:param arrYValue: list[float]
		:param varXAxis: IChartAxisX
		:param varYAxis: IChartAxisY
		:param bUseUnitLegend: bool
		:rtype: recurdyn.Post.IChartSeries
		'''
		ret = self._oleobj_.InvokeTypes(1610743814, LCID, 1, (9, 0), ((8, 1), (8197, 1), (8197, 1), (9, 1), (9, 1), (11, 49)),strSeriesName
			, arrXValue, arrYValue, varXAxis, varYAxis, bUseUnitLegend
			)
		if ret is not None:
			ret = Dispatch(ret, 'CreateSeriesWithAxis', '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
		return ret

	def CreateTextAnnotation(self, dXValue, dYValue):
		'''
		Creates the text annotation.
		
		:param dXValue: float
		:param dYValue: float
		:rtype: recurdyn.Post.IChartAnnotationText
		'''
		ret = self._oleobj_.InvokeTypes(1610743826, LCID, 1, (9, 0), ((5, 1), (5, 1)),dXValue
			, dYValue)
		if ret is not None:
			ret = Dispatch(ret, 'CreateTextAnnotation', '{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}')
		return ret

	def CreateVerticalLineAnnotation(self, dXValue):
		'''
		Creates the vertical line annotation.
		
		:param dXValue: float
		:rtype: recurdyn.Post.IChartAnnotationVerticalLine
		'''
		ret = self._oleobj_.InvokeTypes(1610743828, LCID, 1, (9, 0), ((5, 1),),dXValue
			)
		if ret is not None:
			ret = Dispatch(ret, 'CreateVerticalLineAnnotation', '{BD40CFBC-C472-3CAD-B809-1B8301479DE2}')
		return ret

	def DeleteAll(self):
		'''
		Deletes all of chart entities (series, Axis).
		'''
		return self._oleobj_.InvokeTypes(1610743824, LCID, 1, (24, 0), (),)


	def DeleteSeries(self, varSeries):
		'''
		Deletes the specific series.
		
		:param varSeries: IChartSeries
		'''
		return self._oleobj_.InvokeTypes(1610743823, LCID, 1, (24, 0), ((9, 1),),varSeries
			)


	def ExportImage(self, strFilepath):
		'''
		Exports the chart image to file (.bmp, .png, .jpg).
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def ExportSeriesDataToFile(self, strFilepath, arrChartSeries):
		'''
		Exports the series data to file with the specific series.
		
		:param strFilepath: str
		:param arrChartSeries: list[object]
		'''
		_arrChartSeries_type = True if arrChartSeries and isinstance(arrChartSeries[0], win32com.client.VARIANT) else False
		if not _arrChartSeries_type:
			arrChartSeries = [win32com.client.VARIANT(12, _data) for _data in arrChartSeries]

		ret = self._oleobj_.InvokeTypes(1610743825, LCID, 1, (24, 0), ((8, 1), (8204, 1)),strFilepath
			, arrChartSeries)

		if not _arrChartSeries_type:
			arrChartSeries = [_data.value for _data in arrChartSeries]

		return ret


	def Fit(self):
		'''
		Zooms the Chart to the extents of the series data.
		'''
		return self._oleobj_.InvokeTypes(1610743820, LCID, 1, (24, 0), (),)


	def GetXAxis(self, strUnit):
		'''
		Gets the X-Axis by unit.
		
		:param strUnit: str
		:rtype: recurdyn.Post.IChartAxisX
		'''
		ret = self._oleobj_.InvokeTypes(1610743812, LCID, 1, (9, 0), ((8, 1),),strUnit
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetXAxis', '{2A620232-B413-4059-9E81-29A2CCA9EFEF}')
		return ret

	def GetYAxis(self, strUnit):
		'''
		Gets the Y-Axis by unit.
		
		:param strUnit: str
		:rtype: recurdyn.Post.IChartAxisY
		'''
		ret = self._oleobj_.InvokeTypes(1610743813, LCID, 1, (9, 0), ((8, 1),),strUnit
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetYAxis', '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')
		return ret

	def OpenPropertyGrid(self, varEntity, bForceOpen):
		'''
		Opens the properties window with the specific entity.
		
		:param varEntity: IEntity
		:param bForceOpen: bool
		'''
		return self._oleobj_.InvokeTypes(1610743819, LCID, 1, (24, 0), ((9, 1), (11, 1)),varEntity
			, bForceOpen)


	def ResetAllSettings(self):
		'''
		Resets all settings for this PlotOperation.
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), (),)


	def SaveSetting(self, strFilepath):
		'''
		Saves the settings to file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def UpdateHeader(self):
		'''
		Updates the header of pane in the ParentControl.
		'''
		return self._oleobj_.InvokeTypes(1610743821, LCID, 1, (24, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_Chart(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Chart", '{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_Plot(self):
		return self._ApplyTypes_(*(1610743811, 2, (9, 0), (), "Plot", '{02444C62-D19B-4934-9572-E6677E061882}'))

	Chart = property(_get_Chart, None)
	'''
	Gets the chart of this plot operation.

	:type: recurdyn.Post.IChart
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	Plot = property(_get_Plot, None)
	'''
	Gets the plot entity of this plot operation.

	:type: recurdyn.Post.IEntityPlot
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Chart": (1610743810, 2, (9, 0), (), "Chart", '{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"Plot": (1610743811, 2, (9, 0), (), "Plot", '{02444C62-D19B-4934-9572-E6677E061882}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IPlot3D(DispatchBaseClass):
	'''Defines interface for the Plot3DOperation.'''
	CLSID = IID('{B7613ED0-4431-4A2B-829D-86D5A07B9C99}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def CreatePointLineSeries3D(self, strLegend, arrXValue, arrYValue, arrZValues):
		'''
		Creates the point line series 3-D.
		
		:param strLegend: str
		:param arrXValue: list[float]
		:param arrYValue: list[float]
		:param arrZValues: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743813, LCID, 1, (24, 0), ((8, 1), (8197, 1), (8197, 1), (8197, 1)),strLegend
			, arrXValue, arrYValue, arrZValues)


	def CreatePointLineSeries3D_2(self, strLegend, varXInfo, varYInfo, varZInfo):
		'''
		Creates the point line series 3-D with the specific series value information.
		
		:param strLegend: str
		:param varXInfo: _SeriesValueInfo
		:param varYInfo: _SeriesValueInfo
		:param varZInfo: _SeriesValueInfo
		:rtype: recurdyn.Post.IChartSeries3D
		'''
		ret = self._oleobj_.InvokeTypes(1610743814, LCID, 1, (9, 0), ((8, 1), (9, 1), (9, 1), (9, 1)),strLegend
			, varXInfo, varYInfo, varZInfo)
		if ret is not None:
			ret = Dispatch(ret, 'CreatePointLineSeries3D_2', '{26823D92-8950-47F5-BE7F-E27509032204}')
		return ret

	def CreateSurfaceMeshDataSeries(self, strLegend, arrXSteppingValue, arrZSteppingValue, arrMeshGridDataValue):
		'''
		Creates the surface mesh data series.
		
		:param strLegend: str
		:param arrXSteppingValue: list[float]
		:param arrZSteppingValue: list[float]
		:param arrMeshGridDataValue: list[float]
		'''
		return self._oleobj_.InvokeTypes(1610743815, LCID, 1, (24, 0), ((8, 1), (8197, 1), (8197, 1), (8197, 1)),strLegend
			, arrXSteppingValue, arrZSteppingValue, arrMeshGridDataValue)


	def DeleteAll(self):
		'''
		Deletes all series.
		'''
		return self._oleobj_.InvokeTypes(1610743817, LCID, 1, (24, 0), (),)


	def DeleteSeries(self, varChartSeries):
		'''
		Deletes the series.
		
		:param varChartSeries: IChartSeries3D
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((9, 1),),varChartSeries
			)


	def ExportImage(self, strFilepath):
		'''
		Exports the chart image to file (.bmp, .png, .jpg).
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743819, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def Fit(self):
		'''
		Zooms the Chart3D to the extents of the series data and restore the camera location.
		'''
		return self._oleobj_.InvokeTypes(1610743818, LCID, 1, (24, 0), (),)


	def OpenPropertyGrid(self, varEntity, bForceOpen):
		'''
		Opens the properties window with the specific entity.
		
		:param varEntity: IEntity
		:param bForceOpen: bool
		'''
		return self._oleobj_.InvokeTypes(1610743820, LCID, 1, (24, 0), ((9, 1), (11, 1)),varEntity
			, bForceOpen)


	def ResetAllSettings(self):
		'''
		Resets all settings for this plot3D document.
		'''
		return self._oleobj_.InvokeTypes(1610743822, LCID, 1, (24, 0), (),)


	def SaveSetting(self, strFilepath):
		'''
		Saves the settings to file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743821, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def UpdateHeader(self):
		'''
		Updates the header of pane in the ParentControl.
		'''
		return self._oleobj_.InvokeTypes(1610743812, LCID, 1, (24, 0), (),)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_Chart3D(self):
		return self._ApplyTypes_(*(1610743811, 2, (9, 0), (), "Chart3D", '{919C04CC-90E5-409E-85F3-3256F29E6247}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_Plot3D(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "Plot3D", '{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}'))

	Chart3D = property(_get_Chart3D, None)
	'''
	Gets the Chart3D.

	:type: recurdyn.Post.IChart3D
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	Plot3D = property(_get_Plot3D, None)
	'''
	Gets the 3D Plot.

	:type: recurdyn.Post.IEntityPlot3D
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Chart3D": (1610743811, 2, (9, 0), (), "Chart3D", '{919C04CC-90E5-409E-85F3-3256F29E6247}'),
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"Plot3D": (1610743810, 2, (9, 0), (), "Plot3D", '{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IPoint(DispatchBaseClass):
	'''Defines interface for the point.'''
	CLSID = IID('{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_ToString(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "ToString", None))
	def _get_X(self):
		return self._ApplyTypes_(*(1610743808, 2, (5, 0), (), "X", None))
	def _get_Y(self):
		return self._ApplyTypes_(*(1610743809, 2, (5, 0), (), "Y", None))

	ToString = property(_get_ToString, None)
	'''
	Gets the text value of the point.

	:type: str
	'''
	X = property(_get_X, None)
	'''
	Gets the x value.

	:type: float
	'''
	Y = property(_get_Y, None)
	'''
	Gets the y value.

	:type: float
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ToString": (0, 2, (8, 0), (), "ToString", None),
		"X": (1610743808, 2, (5, 0), (), "X", None),
		"Y": (1610743809, 2, (5, 0), (), "Y", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "ToString", None))
	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IPostApplication(DispatchBaseClass):
	'''Defines interface for PostApplication.'''
	CLSID = IID('{20A0A71D-A66D-42C8-A4FE-E6DDFAC585AA}')
	coclass_clsid = IID('{51329F9B-A9DF-4F3A-8454-6B134A36D4AD}')

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_PostMainWindow(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "PostMainWindow", None))

	PostMainWindow = property(_get_PostMainWindow, None)
	'''
	Gets the RecurDyn Post Application.

	:type: object
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"PostMainWindow": (1610743808, 2, (12, 0), (), "PostMainWindow", None),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IPostMainWindow(DispatchBaseClass):
	'''Defines interface for MainWindow.'''
	CLSID = IID('{3D66119C-DB92-488B-ABDB-FAE557B7F672}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_ApplicationPath(self):
		return self._ApplyTypes_(*(1610743811, 2, (8, 0), (), "ApplicationPath", None))
	def _get_Identify(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "Identify", None))
	def _get_MainDocument(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "MainDocument", '{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}'))

	def _set_Identify(self, value):
		if "Identify" in self.__dict__: self.__dict__["Identify"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	ApplicationPath = property(_get_ApplicationPath, None)
	'''
	Gets the path of the Post application.

	:type: str
	'''
	Identify = property(_get_Identify, _set_Identify)
	MainDocument = property(_get_MainDocument, None)
	'''
	Gets the main document.

	:type: recurdyn.Post.IMainDocument
	'''

	_prop_map_set_function_ = {
		"_set_Identify": _set_Identify,
	}
	_prop_map_get_ = {
		"ApplicationPath": (1610743811, 2, (8, 0), (), "ApplicationPath", None),
		"Identify": (1610743808, 2, (3, 0), (), "Identify", None),
		"MainDocument": (1610743810, 2, (9, 0), (), "MainDocument", '{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}'),
	}
	_prop_map_put_ = {
		"Identify": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbon(DispatchBaseClass):
	'''Defines interface for the RibbonOperation.'''
	CLSID = IID('{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def CreateButton(self, varGroup, strHeader):
		'''
		Creates the RibbonItemButton with the specific.
		
		:param varGroup: IRibbonGroup
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonItemButton
		'''
		ret = self._oleobj_.InvokeTypes(1610743813, LCID, 1, (9, 0), ((9, 1), (8, 1)),varGroup
			, strHeader)
		if ret is not None:
			ret = Dispatch(ret, 'CreateButton', '{744BA570-CF70-4112-81E7-94C995D8B794}')
		return ret

	def CreateGroup(self, varTab, strHeader):
		'''
		Creates the RibbonGroup and adds the group to the specific RibbonTab.
		
		:param varTab: IRibbonTab
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonGroup
		'''
		ret = self._oleobj_.InvokeTypes(1610743812, LCID, 1, (9, 0), ((9, 1), (8, 1)),varTab
			, strHeader)
		if ret is not None:
			ret = Dispatch(ret, 'CreateGroup', '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
		return ret

	def CreateTab(self, strHeader):
		'''
		Creates the RibbonTab with the specific header text.
		
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonTab
		'''
		ret = self._oleobj_.InvokeTypes(1610743811, LCID, 1, (9, 0), ((8, 1),),strHeader
			)
		if ret is not None:
			ret = Dispatch(ret, 'CreateTab', '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
		return ret

	def GetEntity(self, strHeader):
		'''
		Gets the entity that indicates the IRibbonTab by the specific header.
		
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonTab
		'''
		ret = self._oleobj_.InvokeTypes(1610743814, LCID, 1, (9, 0), ((8, 1),),strHeader
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetEntity', '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
		return ret

	def SetTooltip(self, strHeader, strDescription, varRibbonItem):
		'''
		Sets the tooltip on the specific ribbon item.
		
		:param strHeader: str
		:param strDescription: str
		:param varRibbonItem: IRibbonEntity
		'''
		return self._oleobj_.InvokeTypes(1610743815, LCID, 1, (24, 0), ((8, 1), (8, 1), (9, 1)),strHeader
			, strDescription, varRibbonItem)


	def UpdateView(self):
		return self._oleobj_.InvokeTypes(1610743808, LCID, 1, (24, 0), (),)


	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'))
	def _get_RibbonView(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "RibbonView", '{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}'))

	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: recurdyn.Post.IControl
	'''
	RibbonView = property(_get_RibbonView, None)
	'''
	Gets the IRibbonView.

	:type: recurdyn.Post.IRibbonView
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ParentControl": (1610743809, 2, (9, 0), (), "ParentControl", '{AAC98348-2902-49EA-BDBA-658775DB336E}'),
		"RibbonView": (1610743810, 2, (9, 0), (), "RibbonView", '{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}'),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonEntity(DispatchBaseClass):
	'''Defines interface for the RibbonEntity.'''
	CLSID = IID('{70A3F82F-9CB6-4E52-9B6A-A156BA8638F8}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonGroup(DispatchBaseClass):
	'''Defines interface for the RibbonGroup.'''
	CLSID = IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def GetEntity(self, strHeader):
		'''
		Gets the entity that indicates the IRibbonItemButton by the specific header.
		
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonItemButton
		'''
		ret = self._oleobj_.InvokeTypes(1610743812, LCID, 1, (9, 0), ((8, 1),),strHeader
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetEntity', '{744BA570-CF70-4112-81E7-94C995D8B794}')
		return ret

	def RemoveEntity(self, Header):
		'''
		Removes the entity from this RibbonGroup.
		
		:param Header: str
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), ((8, 1),),Header
			)


	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))
	def _get_ItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "ItemCollection", '{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''
	ItemCollection = property(_get_ItemCollection, None)
	'''
	Gets the collection of the RibbonItem.

	:type: recurdyn.Post.IRibbonItemCollection
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
		"ItemCollection": (1610743810, 2, (9, 0), (), "ItemCollection", '{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonGroupCollection(DispatchBaseClass):
	'''Defines interface for the ribbon group collection.'''
	CLSID = IID('{2A4B5914-A9AD-45D8-9A93-E0A82336455D}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the ribbon group by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonGroup
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the ribbon group by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the ribbon group by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonGroup
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IRibbonItem(DispatchBaseClass):
	'''Defines interface for the RibbonItem.'''
	CLSID = IID('{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetCommand(self, varCommand, varParameter):
		'''
		Sets the command with the specific command and parameter. The parameter should be a name of function.
		
		:param varCommand: ICommand
		:param varParameter: object
		'''
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (24, 0), ((9, 1), (12, 1)),varCommand
			, varParameter)


	def SetScriptCommand(self, strScript):
		'''
		Sets the script to the ribbon item.
		
		:param strScript: str
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), ((8, 1),),strScript
			)


	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonItemButton(DispatchBaseClass):
	'''Defines interface for the RibbonItemButton.'''
	CLSID = IID('{744BA570-CF70-4112-81E7-94C995D8B794}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetCommand(self, varCommand, varParameter):
		'''
		Sets the command with the specific command and parameter. The parameter should be a name of function.
		
		:param varCommand: ICommand
		:param varParameter: object
		'''
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (24, 0), ((9, 1), (12, 1)),varCommand
			, varParameter)


	def SetImage(self, strFilepath):
		'''
		Sets the image for this button from the specific file.
		
		:param strFilepath: str
		'''
		return self._oleobj_.InvokeTypes(1610743814, LCID, 1, (24, 0), ((8, 1),),strFilepath
			)


	def SetScriptCommand(self, strScript):
		'''
		Sets the script to the ribbon item.
		
		:param strScript: str
		'''
		return self._oleobj_.InvokeTypes(1610743811, LCID, 1, (24, 0), ((8, 1),),strScript
			)


	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))
	def _get_Size(self):
		return self._ApplyTypes_(*(1610743812, 2, (3, 0), (), "Size", '{39E394EC-0CFF-3999-B924-D473A918632F}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_Size(self, value):
		if "Size" in self.__dict__: self.__dict__["Size"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''
	Size = property(_get_Size, _set_Size)
	'''
	Gets or sets the size of this button.

	:type: recurdyn.Post.RibbonButtonSize
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
		"_set_Size": _set_Size,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
		"Size": (1610743812, 2, (3, 0), (), "Size", '{39E394EC-0CFF-3999-B924-D473A918632F}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
		"Size": ((1610743812, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonItemCollection(DispatchBaseClass):
	'''Defines interface for the ribbon item collection.'''
	CLSID = IID('{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the ribbon item by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonItem
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the ribbon item by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the ribbon item by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonItem
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IRibbonTab(DispatchBaseClass):
	'''Defines interface for the RibbonTab.'''
	CLSID = IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def GetEntity(self, strHeader):
		'''
		Gets the entity that indicates the IRibbonGroup by the specific header.
		
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonGroup
		'''
		ret = self._oleobj_.InvokeTypes(1610743811, LCID, 1, (9, 0), ((8, 1),),strHeader
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetEntity', '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')
		return ret

	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))
	def _get_ItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "ItemCollection", '{2A4B5914-A9AD-45D8-9A93-E0A82336455D}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''
	ItemCollection = property(_get_ItemCollection, None)
	'''
	Gets the RibbonGroup collection.

	:type: recurdyn.Post.IRibbonGroupCollection
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
		"ItemCollection": (1610743810, 2, (9, 0), (), "ItemCollection", '{2A4B5914-A9AD-45D8-9A93-E0A82336455D}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IRibbonTabCollection(DispatchBaseClass):
	'''Defines interface for the ribbon tab collection.'''
	CLSID = IID('{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the ribbon tab by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonTab
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the ribbon tab by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the ribbon tab by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IRibbonTab
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IRibbonView(DispatchBaseClass):
	'''Defines interface for the RibbonView.'''
	CLSID = IID('{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def GetEntity(self, strHeader):
		'''
		Gets the RibbonTab by header.
		
		:param strHeader: str
		:rtype: recurdyn.Post.IRibbonTab
		'''
		ret = self._oleobj_.InvokeTypes(1610743811, LCID, 1, (9, 0), ((8, 1),),strHeader
			)
		if ret is not None:
			ret = Dispatch(ret, 'GetEntity', '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')
		return ret

	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))
	def _get_ItemCollection(self):
		return self._ApplyTypes_(*(1610743810, 2, (9, 0), (), "ItemCollection", '{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header text.

	:type: str
	'''
	ItemCollection = property(_get_ItemCollection, None)
	'''
	Gets the collection of IRibbonTab.

	:type: recurdyn.Post.IRibbonTabCollection
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
		"ItemCollection": (1610743810, 2, (9, 0), (), "ItemCollection", '{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class ISeries3DCollection(DispatchBaseClass):
	'''Defines interface for the chart series 3D collection.'''
	CLSID = IID('{8EE0A50B-A095-4196-B3A2-189A36105476}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the chart series 3D by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartSeries3D
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{26823D92-8950-47F5-BE7F-E27509032204}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the chart series 3D by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the chart series 3D by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartSeries3D
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{26823D92-8950-47F5-BE7F-E27509032204}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{26823D92-8950-47F5-BE7F-E27509032204}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{26823D92-8950-47F5-BE7F-E27509032204}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class ISeriesCollection(DispatchBaseClass):
	'''Defines interface for the chart series collection.'''
	CLSID = IID('{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Item(self, iPosition):
		'''
		Gets the chart series by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartSeries
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, 'Item', '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
		return ret

	def SetItem(self, iPosition, arg1):
		'''
		Gets the chart series by the index.
		
		:param iPosition: int
		'''
		return self._oleobj_.InvokeTypes(0, LCID, 8, (24, 0), ((3, 1), (9, 1)),iPosition
			, arg1)


	def _get_Count(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))

	Count = property(_get_Count, None)
	'''
	Gets the count of collection.

	:type: int
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Count": (1610743811, 2, (3, 0), (), "Count", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self, iPosition):
		'''
		Gets the chart series by the index.
		
		:param iPosition: int
		:rtype: recurdyn.Post.IChartSeries
		'''
		ret = self._oleobj_.InvokeTypes(0, LCID, 2, (9, 0), ((3, 1),),iPosition
			)
		if ret is not None:
			ret = Dispatch(ret, '__call__', '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
		return ret

	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,1,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
	def __getitem__(self, key):
		return self._get_good_object_(self._oleobj_.Invoke(*(0, LCID, 2, 1, key)), "Item", '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')
	#This class has Count() property - allow len(ob) to provide this
	def __len__(self):
		return self._ApplyTypes_(*(1610743811, 2, (3, 0), (), "Count", None))
	#This class has a __len__ - this is needed so 'if object:' always returns TRUE.
	def __nonzero__(self):
		return True

class IThemeManager(DispatchBaseClass):
	'''Defines interface for the ThemeManger.'''
	CLSID = IID('{016C03D7-5933-4AE7-851D-87B1006287CA}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def _get_CurrentTheme(self):
		return self._ApplyTypes_(*(1610743808, 2, (3, 0), (), "CurrentTheme", '{32ABD87B-E6FB-3474-A716-C321EDC7E202}'))

	def _set_CurrentTheme(self, value):
		if "CurrentTheme" in self.__dict__: self.__dict__["CurrentTheme"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	CurrentTheme = property(_get_CurrentTheme, _set_CurrentTheme)
	'''
	Gets or sets the current Theme.

	:type: recurdyn.Post.ThemeType
	'''

	_prop_map_set_function_ = {
		"_set_CurrentTheme": _set_CurrentTheme,
	}
	_prop_map_get_ = {
		"CurrentTheme": (1610743808, 2, (3, 0), (), "CurrentTheme", '{32ABD87B-E6FB-3474-A716-C321EDC7E202}'),
	}
	_prop_map_put_ = {
		"CurrentTheme": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IThickness(DispatchBaseClass):
	'''Defines interface for the thickness.'''
	CLSID = IID('{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def SetAll(self, dValue):
		'''
		Sets all side values of thickness with the specific value.
		
		:param dValue: float
		'''
		return self._oleobj_.InvokeTypes(1610743816, LCID, 1, (24, 0), ((5, 1),),dValue
			)


	def _get_Bottom(self):
		return self._ApplyTypes_(*(1610743810, 2, (5, 0), (), "Bottom", None))
	def _get_Left(self):
		return self._ApplyTypes_(*(1610743812, 2, (5, 0), (), "Left", None))
	def _get_Right(self):
		return self._ApplyTypes_(*(1610743814, 2, (5, 0), (), "Right", None))
	def _get_Top(self):
		return self._ApplyTypes_(*(1610743808, 2, (5, 0), (), "Top", None))

	def _set_Bottom(self, value):
		if "Bottom" in self.__dict__: self.__dict__["Bottom"] = value; return
		self._oleobj_.Invoke(*((1610743810, LCID, 4, 0) + (value,) + ()))
	def _set_Left(self, value):
		if "Left" in self.__dict__: self.__dict__["Left"] = value; return
		self._oleobj_.Invoke(*((1610743812, LCID, 4, 0) + (value,) + ()))
	def _set_Right(self, value):
		if "Right" in self.__dict__: self.__dict__["Right"] = value; return
		self._oleobj_.Invoke(*((1610743814, LCID, 4, 0) + (value,) + ()))
	def _set_Top(self, value):
		if "Top" in self.__dict__: self.__dict__["Top"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))

	Bottom = property(_get_Bottom, _set_Bottom)
	'''
	Gets or sets the bottom value of the thickness.

	:type: float
	'''
	Left = property(_get_Left, _set_Left)
	'''
	Gets or sets the left value of the thickness.

	:type: float
	'''
	Right = property(_get_Right, _set_Right)
	'''
	Gets or sets the right value of the thickness.

	:type: float
	'''
	Top = property(_get_Top, _set_Top)
	'''
	Gets or sets the top value of the thickness.

	:type: float
	'''

	_prop_map_set_function_ = {
		"_set_Bottom": _set_Bottom,
		"_set_Left": _set_Left,
		"_set_Right": _set_Right,
		"_set_Top": _set_Top,
	}
	_prop_map_get_ = {
		"Bottom": (1610743810, 2, (5, 0), (), "Bottom", None),
		"Left": (1610743812, 2, (5, 0), (), "Left", None),
		"Right": (1610743814, 2, (5, 0), (), "Right", None),
		"Top": (1610743808, 2, (5, 0), (), "Top", None),
	}
	_prop_map_put_ = {
		"Bottom": ((1610743810, LCID, 4, 0),()),
		"Left": ((1610743812, LCID, 4, 0),()),
		"Right": ((1610743814, LCID, 4, 0),()),
		"Top": ((1610743808, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IViewModel(DispatchBaseClass):
	'''Defines interface for the ViewModelBase'''
	CLSID = IID('{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Update(self):
		'''
		Updates this ViewModel. This function call the OnPropertyChanged for all of properties. Call this function if the control (UI) need for update.
		'''
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (24, 0), (),)


	def _get_Operation(self):
		return self._ApplyTypes_(*(1610743809, 2, (9, 0), (), "Operation", '{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}'))
	def _get_ParentControl(self):
		return self._ApplyTypes_(*(1610743808, 2, (12, 0), (), "ParentControl", None))

	Operation = property(_get_Operation, None)
	'''
	Gets the Operation related to this ViewModel.

	:type: recurdyn.Post.IOperation
	'''
	ParentControl = property(_get_ParentControl, None)
	'''
	Gets the parent control.

	:type: object
	'''

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"Operation": (1610743809, 2, (9, 0), (), "Operation", '{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}'),
		"ParentControl": (1610743808, 2, (12, 0), (), "ParentControl", None),
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class IWindowPane(DispatchBaseClass):
	'''Defines interface for the WindowPane'''
	CLSID = IID('{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}')
	coclass_clsid = None

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Activate(self):
		'''
		Activates this pane.
		'''
		return self._oleobj_.InvokeTypes(1610743813, LCID, 1, (24, 0), (),)


	def ShowHeader(self, bShow):
		'''
		Shows the header of pane.
		
		:param bShow: bool
		'''
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (24, 0), ((11, 1),),bShow
			)


	def _get_Header(self):
		return self._ApplyTypes_(*(1610743808, 2, (8, 0), (), "Header", None))
	def _get_IsHidden(self):
		return self._ApplyTypes_(*(1610743811, 2, (11, 0), (), "IsHidden", None))
	def _get_PaneType(self):
		return self._ApplyTypes_(*(1610743814, 2, (3, 0), (), "PaneType", '{56F664E1-712E-325B-B9F2-15A4E19FF7EC}'))

	def _set_Header(self, value):
		if "Header" in self.__dict__: self.__dict__["Header"] = value; return
		self._oleobj_.Invoke(*((1610743808, LCID, 4, 0) + (value,) + ()))
	def _set_IsHidden(self, value):
		if "IsHidden" in self.__dict__: self.__dict__["IsHidden"] = value; return
		self._oleobj_.Invoke(*((1610743811, LCID, 4, 0) + (value,) + ()))

	Header = property(_get_Header, _set_Header)
	'''
	Gets or sets the header of pane.

	:type: str
	'''
	IsHidden = property(_get_IsHidden, _set_IsHidden)
	'''
	Gets or sets a value indicating whether this pane is hidden.

	:type: bool
	'''
	PaneType = property(_get_PaneType, None)
	'''
	Gets the type of the document.

	:type: recurdyn.Post.PaneType
	'''

	_prop_map_set_function_ = {
		"_set_Header": _set_Header,
		"_set_IsHidden": _set_IsHidden,
	}
	_prop_map_get_ = {
		"Header": (1610743808, 2, (8, 0), (), "Header", None),
		"IsHidden": (1610743811, 2, (11, 0), (), "IsHidden", None),
		"PaneType": (1610743814, 2, (3, 0), (), "PaneType", '{56F664E1-712E-325B-B9F2-15A4E19FF7EC}'),
	}
	_prop_map_put_ = {
		"Header": ((1610743808, LCID, 4, 0),()),
		"IsHidden": ((1610743811, LCID, 4, 0),()),
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class _LocalizedDescriptionAttribute(DispatchBaseClass):
	CLSID = IID('{E3CB556E-651D-377D-A93F-548466BD073C}')
	coclass_clsid = IID('{135595B2-CAC1-3B08-9EB7-9AE2C8504622}')

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class _Object(DispatchBaseClass):
	CLSID = IID('{65074F7F-63C0-304E-AF0A-D51741CB4A8D}')
	coclass_clsid = IID('{1CF20174-B95E-4E02-B03A-9B2523451570}')

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	def Equals(self, obj):
		return self._oleobj_.InvokeTypes(1610743809, LCID, 1, (11, 0), ((12, 1),),obj
			)


	def GetHashCode(self):
		return self._oleobj_.InvokeTypes(1610743810, LCID, 1, (3, 0), (),)


	def GetType(self):
		ret = self._oleobj_.InvokeTypes(1610743811, LCID, 1, (13, 0), (),)
		if ret is not None:
			# See if this IUnknown is really an IDispatch
			try:
				ret = ret.QueryInterface(pythoncom.IID_IDispatch)
			except pythoncom.error:
				return ret
			ret = Dispatch(ret, 'GetType', '{BCA8B44D-AAD6-3A86-8AB7-03349F4F2DA2}')
		return ret

	def _get_ToString(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "ToString", None))

	ToString = property(_get_ToString, None)

	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
		"ToString": (0, 2, (8, 0), (), "ToString", None),
	}
	_prop_map_put_ = {
	}
	def __call__(self):
		return self._ApplyTypes_(*(0, 2, (8, 0), (), "ToString", None))
	def __str__(self, *args):
		return str(self.__call__(*args))
	def __int__(self, *args):
		return int(self.__call__(*args))
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

class _SeriesValueInfo(DispatchBaseClass):
	'''Defines information for the series value. This SeriesValueInfo is used in draw series functions.'''
	CLSID = IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')
	coclass_clsid = IID('{1CF20174-B95E-4E02-B03A-9B2523451570}')

	def __setattr__(self, attr, value):
		if '_set_'+attr in dir(self):
			try:
				self._prop_map_set_function_['_set_'+attr](self, value)
			except:
				super().__setattr__(attr, value)
		else:
			super().__setattr__(attr, value)
	_prop_map_set_function_ = {
	}
	_prop_map_get_ = {
	}
	_prop_map_put_ = {
	}
	def __iter__(self):
		"Return a Python iterator for this object"
		try:
			ob = self._oleobj_.InvokeTypes(-4,LCID,3,(13, 10),())
		except pythoncom.error:
			raise TypeError("This object does not support enumeration")
		return win32com.client.util.Iterator(ob, None)

from win32com.client import CoClassBaseClass
class LocalizedDescriptionAttribute(CoClassBaseClass): # A CoClass
	CLSID = IID('{135595B2-CAC1-3B08-9EB7-9AE2C8504622}')
	coclass_sources = [
	]
	coclass_interfaces = [
		_LocalizedDescriptionAttribute,
		_Object,
	]
	default_interface = _LocalizedDescriptionAttribute

# This CoClass is known by the name 'RecurDynPost.Application'
class PostApplication(CoClassBaseClass): # A CoClass
	CLSID = IID('{51329F9B-A9DF-4F3A-8454-6B134A36D4AD}')
	coclass_sources = [
	]
	coclass_interfaces = [
		_Object,
		IPostApplication,
	]
	default_interface = IPostApplication

class SeriesValueInfo(CoClassBaseClass): # A CoClass
	# Defines information for the series value. This SeriesValueInfo is used in draw series functions.
	CLSID = IID('{1CF20174-B95E-4E02-B03A-9B2523451570}')
	coclass_sources = [
	]
	coclass_interfaces = [
		_SeriesValueInfo,
		_Object,
	]
	default_interface = _SeriesValueInfo

IAnalysisFunctions_vtables_dispatch_ = 1
IAnalysisFunctions_vtables_ = [
	(( 'FFTMagnitude' , 'arrCurveXData' , 'arrCurveYData' , 'enWindowType' , 'iNumberofPoint' , 
			 'dMin' , 'dMax' , 'arrResultXData' , 'arrResultYData' , ), 1610743808, (1610743808, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (3, 1, None, "IID('{AA69047F-5841-3E57-8783-A74DDBE14CF1}')") , (3, 1, None, None) , (5, 1, None, None) , 
			 (5, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'FFTPhase' , 'arrCurveXData' , 'arrCurveYData' , 'enWindowType' , 'iNumberofPoint' , 
			 'dMin' , 'dMax' , 'arrResultXData' , 'arrResultYData' , ), 1610743809, (1610743809, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (3, 1, None, "IID('{AA69047F-5841-3E57-8783-A74DDBE14CF1}')") , (3, 1, None, None) , (5, 1, None, None) , 
			 (5, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FFTPSD' , 'arrCurveXData' , 'arrCurveYData' , 'enWindowType' , 'iNumberofPoint' , 
			 'dMin' , 'dMax' , 'enPSDType' , 'arrResultXData' , 'arrResultYData' , 
			 ), 1610743810, (1610743810, (), [ (8197, 1, None, None) , (8197, 1, None, None) , (3, 1, None, "IID('{AA69047F-5841-3E57-8783-A74DDBE14CF1}')") , (3, 1, None, None) , 
			 (5, 1, None, None) , (5, 1, None, None) , (3, 1, None, "IID('{E243774C-0F9B-3818-8840-8391A3F09BBF}')") , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'FilterButterWorth' , 'arrCurveXData' , 'arrCurveYData' , 'enButterWorthOption' , 'iOrder' , 
			 'iCutoff' , 'dLowCutoff' , 'dHigtCutoff' , 'arrResultXData' , 'arrResultYData' , 
			 ), 1610743811, (1610743811, (), [ (8197, 1, None, None) , (8197, 1, None, None) , (3, 1, None, "IID('{32C3AB26-ACCA-3810-9E37-5E6B2173B265}')") , (3, 1, None, None) , 
			 (3, 1, None, None) , (5, 1, None, None) , (5, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'FilterTransferFunction' , 'arrCurveXData' , 'arrCurveYData' , 'dNumerator' , 'dDenominator' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743812, (1610743812, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathAbsolute' , 'arrCurveXData' , 'arrCurveYData' , 'arrResultXData' , 'arrResultYData' , 
			 ), 1610743813, (1610743813, (), [ (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathDivide' , 'arrCurve1XData' , 'arrCurve1YData' , 'arrCurve2XData' , 'arrCurve2YData' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743814, (1610743814, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathMultiply' , 'arrCurve1XData' , 'arrCurve1YData' , 'arrCurve2XData' , 'arrCurve2YData' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743815, (1610743815, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathScale' , 'arrCurveXData' , 'arrCurveYData' , 'dScaleX' , 'dScaleY' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743816, (1610743816, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (5, 1, None, None) , (5, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathSubtract' , 'arrCurve1XData' , 'arrCurve1YData' , 'arrCurve2XData' , 'arrCurve2YData' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743817, (1610743817, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathSum' , 'arrCurve1XData' , 'arrCurve1YData' , 'arrCurve2XData' , 'arrCurve2YData' , 
			 'arrResultXData' , 'arrResultYData' , ), 1610743818, (1610743818, (), [ (8197, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'SimpleMathTranslate' , 'arrCurveXData' , 'arrCurveYData' , 'enTranslateType' , 'dTransX' , 
			 'dTransY' , 'arrCurveAlignXData' , 'arrCurveAlignYData' , 'arrResultXData' , 'arrResultYData' , 
			 ), 1610743819, (1610743819, (), [ (8197, 1, None, None) , (8197, 1, None, None) , (3, 1, None, "IID('{AA3D4477-0F2A-3AB2-8EA0-9ED1924769A2}')") , (5, 1, None, None) , 
			 (5, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , (24581, 2, None, None) , (24581, 2, None, None) , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
]

IAnimation_vtables_dispatch_ = 1
IAnimation_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Model' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'PlayType' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, "IID('{04B148FE-B33A-33B2-9E24-767C75B8D748}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'PlayType' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (3, 1, None, "IID('{04B148FE-B33A-33B2-9E24-767C75B8D748}')") , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Status' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16387, 10, None, "IID('{4D37E22E-070C-3D14-83A7-A084CF15805A}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'UseCustomFrame' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'UseCustomFrame' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'StartFrame' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'StartFrame' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'EndFrame' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'EndFrame' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'MaxFrame' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'CurrentFrame' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'CurrentFrame' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'FrameStep' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'FrameStep' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Delay' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Delay' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'Play' , ), 1610743827, (1610743827, (), [ ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Pause' , ), 1610743828, (1610743828, (), [ ], 1 , 1 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Stop' , ), 1610743829, (1610743829, (), [ ], 1 , 1 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'UpdateMaxFrame' , ), 1610743830, (1610743830, (), [ ], 1 , 1 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'PrepareAnimation' , ), 1610743831, (1610743831, (), [ ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
]

IAnimationFrame_vtables_dispatch_ = 1
IAnimationFrame_vtables_ = [
	(( 'Entity' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Status' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, "IID('{4D37E22E-070C-3D14-83A7-A084CF15805A}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Status' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (3, 1, None, "IID('{4D37E22E-070C-3D14-83A7-A084CF15805A}')") , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'MaxFrame' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'MaxFrame' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'CurrentFrame' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'CurrentFrame' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IApplicationConfig_vtables_dispatch_ = 1
IApplicationConfig_vtables_ = [
	(( 'ApplicationOptions' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{A3B76163-68FC-447A-99F3-DF40B08DFE1C}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
]

IApplicationOptions_vtables_dispatch_ = 1
IApplicationOptions_vtables_ = [
	(( 'ApplicationOptionsChart' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ApplicationOptionsExportSeriesData' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{926F0F68-9177-47F4-B0C3-788CBD50A011}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ApplicationOptionsDataEditor' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{17603DE0-C898-401A-A841-F9CB908F5525}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'NewModelWhenStarting' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'NewModelWhenStarting' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfRecentFiles' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfRecentFiles' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'MaximumFilteredCount' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'MaximumFilteredCount' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenError' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenError' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenWarning' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenWarning' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenInformation' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ActivateOutputWhenInformation' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Export' , 'strFilepath' , ), 1610743823, (1610743823, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Import' , 'strFilepath' , ), 1610743824, (1610743824, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'RestoreOptions' , ), 1610743825, (1610743825, (), [ ], 1 , 1 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
]

IApplicationOptionsChart_vtables_dispatch_ = 1
IApplicationOptionsChart_vtables_ = [
	(( 'SelectedSeriesThickness' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'SelectedSeriesThickness' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'AutoFit' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'AutoFit' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoDecimalPointsForAxisTickLabel' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoDecimalPointsForAxisTickLabel' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'SelectZoomXAxisOnly' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'SelectZoomXAxisOnly' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SelectZoomFitYAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'SelectZoomFitYAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseWheelAction' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseWheelAction' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseDragPanAction' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseDragPanAction' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragPanActionFitYAxis' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragPanActionFitYAxis' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseDoubleClickFit' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'EnableMouseDoubleClickFit' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'XyDirection' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16387, 10, None, "IID('{D9E129D4-E0BB-38D7-B8A3-23CE1FB45903}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'XyDirection' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (3, 1, None, "IID('{D9E129D4-E0BB-38D7-B8A3-23CE1FB45903}')") , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragAction' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, "IID('{F840B6EE-855A-39DB-A57E-C31F3633F549}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragAction' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, "IID('{F840B6EE-855A-39DB-A57E-C31F3633F549}')") , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'PreviewModeMouseAction' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16387, 10, None, "IID('{CA169CFB-510D-307A-B1D6-44EAD1BF1A3C}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'PreviewModeMouseAction' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (3, 1, None, "IID('{CA169CFB-510D-307A-B1D6-44EAD1BF1A3C}')") , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
]

IApplicationOptionsDataEditor_vtables_dispatch_ = 1
IApplicationOptionsDataEditor_vtables_ = [
	(( 'NumberOfSignificantDigit' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfSignificantDigit' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
]

IApplicationOptionsExportSeriesData_vtables_dispatch_ = 1
IApplicationOptionsExportSeriesData_vtables_ = [
	(( 'IncludeTitleHeader' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'IncludeTitleHeader' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'UseScientificNotation' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'UseScientificNotation' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfSignificantDigit' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfSignificantDigit' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IAxisXCollection_vtables_dispatch_ = 1
IAxisXCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IAxisYCollection_vtables_dispatch_ = 1
IAxisYCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

ICampbellDiagram_vtables_dispatch_ = 1
ICampbellDiagram_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'UseInputFile' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'UseInputFile' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'CampbellInputFile' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'CampbellInputFile' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'TimeComponent' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'TachoComponent' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SignalComponent' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'TachometerType' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16387, 10, None, "IID('{E183000B-6C78-38A9-884A-FC1C8A80DF74}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'TachometerType' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (3, 1, None, "IID('{E183000B-6C78-38A9-884A-FC1C8A80DF74}')") , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'DeltaTime' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'DeltaTime' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Dt' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Dt' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'UseRecommandedTimeZone' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'UseRecommandedTimeZone' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'StartFrame' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'StartFrame' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'EndFrame' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'EndFrame' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'FrameNumber' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'FrameNumber' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'FrameSize' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'FrameSize' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'PulsePerRev' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'PulsePerRev' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'UseInterpolation' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UseInterpolation' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'RPMComputeType' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16387, 10, None, "IID('{13B875A6-DEE2-3EC4-9DD2-1CE22CC66487}')") , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'RPMComputeType' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, "IID('{13B875A6-DEE2-3EC4-9DD2-1CE22CC66487}')") , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'InterpolationType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{A5E96348-2158-376F-ADCA-5AD7E7CEF0B0}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'InterpolationType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{A5E96348-2158-376F-ADCA-5AD7E7CEF0B0}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'CampbellDataType' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16387, 10, None, "IID('{4E55A9C7-3A08-36EA-A47C-B698A2D3B24D}')") , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'CampbellDataType' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (3, 1, None, "IID('{4E55A9C7-3A08-36EA-A47C-B698A2D3B24D}')") , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'UseRecommandedFrameSettings' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'UseRecommandedFrameSettings' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'MaxFrame' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'StartTime' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'EndTime' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'TimeZoneStartTime' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'TimeZoneEndTime' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'SamplingTime' , 'pRetVal' , ), 1610743850, (1610743850, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'StartRPM' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'EndRPM' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'MaxFreq' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'MaxOrder' , 'pRetVal' , ), 1610743854, (1610743854, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
	(( 'FrameLength' , 'pRetVal' , ), 1610743855, (1610743855, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 432 , (3, 0, None, None) , 0 , )),
	(( 'Overlap' , 'pRetVal' , ), 1610743856, (1610743856, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 440 , (3, 0, None, None) , 0 , )),
	(( 'ResidualNumber' , 'pRetVal' , ), 1610743857, (1610743857, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 448 , (3, 0, None, None) , 0 , )),
	(( 'DeltaFrequency' , 'pRetVal' , ), 1610743858, (1610743858, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 456 , (3, 0, None, None) , 0 , )),
	(( 'SignalOffset' , 'pRetVal' , ), 1610743859, (1610743859, (), [ (16387, 10, None, "IID('{15E07B49-D53C-34E5-AF1B-C596ACD9746F}')") , ], 1 , 2 , 4 , 0 , 464 , (3, 0, None, None) , 0 , )),
	(( 'SignalOffset' , 'pRetVal' , ), 1610743859, (1610743859, (), [ (3, 1, None, "IID('{15E07B49-D53C-34E5-AF1B-C596ACD9746F}')") , ], 1 , 4 , 4 , 0 , 472 , (3, 0, None, None) , 0 , )),
	(( 'WindowType' , 'pRetVal' , ), 1610743861, (1610743861, (), [ (16387, 10, None, "IID('{7E83733E-DCF7-36FA-98F1-BA37423D3E5E}')") , ], 1 , 2 , 4 , 0 , 480 , (3, 0, None, None) , 0 , )),
	(( 'WindowType' , 'pRetVal' , ), 1610743861, (1610743861, (), [ (3, 1, None, "IID('{7E83733E-DCF7-36FA-98F1-BA37423D3E5E}')") , ], 1 , 4 , 4 , 0 , 488 , (3, 0, None, None) , 0 , )),
	(( 'MagnitudeType' , 'pRetVal' , ), 1610743863, (1610743863, (), [ (16387, 10, None, "IID('{78862260-3599-342E-B22D-EE54946796F6}')") , ], 1 , 2 , 4 , 0 , 496 , (3, 0, None, None) , 0 , )),
	(( 'MagnitudeType' , 'pRetVal' , ), 1610743863, (1610743863, (), [ (3, 1, None, "IID('{78862260-3599-342E-B22D-EE54946796F6}')") , ], 1 , 4 , 4 , 0 , 504 , (3, 0, None, None) , 0 , )),
	(( 'CampbellViewType' , 'pRetVal' , ), 1610743865, (1610743865, (), [ (16387, 10, None, "IID('{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}')") , ], 1 , 2 , 4 , 0 , 512 , (3, 0, None, None) , 0 , )),
	(( 'CampbellViewType' , 'pRetVal' , ), 1610743865, (1610743865, (), [ (3, 1, None, "IID('{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}')") , ], 1 , 4 , 4 , 0 , 520 , (3, 0, None, None) , 0 , )),
	(( 'GraphOption' , 'pRetVal' , ), 1610743867, (1610743867, (), [ (16387, 10, None, "IID('{CD553711-F6DF-3222-AB54-18337C5AA2E2}')") , ], 1 , 2 , 4 , 0 , 528 , (3, 0, None, None) , 0 , )),
	(( 'GraphOption' , 'pRetVal' , ), 1610743867, (1610743867, (), [ (3, 1, None, "IID('{CD553711-F6DF-3222-AB54-18337C5AA2E2}')") , ], 1 , 4 , 4 , 0 , 536 , (3, 0, None, None) , 0 , )),
	(( 'IsSwapAxis' , 'pRetVal' , ), 1610743869, (1610743869, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 544 , (3, 0, None, None) , 0 , )),
	(( 'IsSwapAxis' , 'pRetVal' , ), 1610743869, (1610743869, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 552 , (3, 0, None, None) , 0 , )),
	(( 'IsOrderLineVisible' , 'pRetVal' , ), 1610743871, (1610743871, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 560 , (3, 0, None, None) , 0 , )),
	(( 'IsOrderLineVisible' , 'pRetVal' , ), 1610743871, (1610743871, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 568 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineThickness' , 'pRetVal' , ), 1610743873, (1610743873, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 576 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineThickness' , 'pRetVal' , ), 1610743873, (1610743873, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 584 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineColor' , 'pRetVal' , ), 1610743875, (1610743875, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 592 , (3, 0, None, None) , 0 , )),
	(( 'OrderTextSize' , 'pRetVal' , ), 1610743876, (1610743876, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 600 , (3, 0, None, None) , 0 , )),
	(( 'OrderTextSize' , 'pRetVal' , ), 1610743876, (1610743876, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 608 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineMaxOrder' , 'pRetVal' , ), 1610743878, (1610743878, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 616 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineMaxOrder' , 'pRetVal' , ), 1610743878, (1610743878, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 624 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineMinOrder' , 'pRetVal' , ), 1610743880, (1610743880, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 632 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineMinOrder' , 'pRetVal' , ), 1610743880, (1610743880, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 640 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineGap' , 'pRetVal' , ), 1610743882, (1610743882, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 648 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineGap' , 'pRetVal' , ), 1610743882, (1610743882, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 656 , (3, 0, None, None) , 0 , )),
	(( 'Resolution' , 'pRetVal' , ), 1610743884, (1610743884, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 664 , (3, 0, None, None) , 0 , )),
	(( 'Resolution' , 'pRetVal' , ), 1610743884, (1610743884, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 672 , (3, 0, None, None) , 0 , )),
	(( 'CalculateAllOrders' , 'pRetVal' , ), 1610743886, (1610743886, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 680 , (3, 0, None, None) , 0 , )),
	(( 'CalculateAllOrders' , 'pRetVal' , ), 1610743886, (1610743886, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 688 , (3, 0, None, None) , 0 , )),
	(( 'UseDecibelPlot' , 'pRetVal' , ), 1610743888, (1610743888, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 696 , (3, 0, None, None) , 0 , )),
	(( 'UseDecibelPlot' , 'pRetVal' , ), 1610743888, (1610743888, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 704 , (3, 0, None, None) , 0 , )),
	(( 'ApplyWindowCorrectionFactor' , 'pRetVal' , ), 1610743890, (1610743890, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 712 , (3, 0, None, None) , 0 , )),
	(( 'ApplyWindowCorrectionFactor' , 'pRetVal' , ), 1610743890, (1610743890, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 720 , (3, 0, None, None) , 0 , )),
	(( 'DecibelReferenceValue' , 'pRetVal' , ), 1610743892, (1610743892, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 728 , (3, 0, None, None) , 0 , )),
	(( 'DecibelReferenceValue' , 'pRetVal' , ), 1610743892, (1610743892, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 736 , (3, 0, None, None) , 0 , )),
	(( 'CorrectionFactor' , 'pRetVal' , ), 1610743894, (1610743894, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 744 , (3, 0, None, None) , 0 , )),
	(( 'CorrectionFactor' , 'pRetVal' , ), 1610743894, (1610743894, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 752 , (3, 0, None, None) , 0 , )),
	(( 'UpdateSignalData' , 'pRetVal' , ), 1610743896, (1610743896, (), [ (16387, 10, None, None) , ], 1 , 1 , 4 , 0 , 760 , (3, 0, None, None) , 0 , )),
	(( 'UpdateFrameSettings' , 'pRetVal' , ), 1610743897, (1610743897, (), [ (16387, 10, None, None) , ], 1 , 1 , 4 , 0 , 768 , (3, 0, None, None) , 0 , )),
	(( 'CampbellDataCalculate' , 'pRetVal' , ), 1610743898, (1610743898, (), [ (16387, 10, None, None) , ], 1 , 1 , 4 , 0 , 776 , (3, 0, None, None) , 0 , )),
	(( 'DrawCampbellDiagram' , ), 1610743899, (1610743899, (), [ ], 1 , 1 , 4 , 0 , 784 , (3, 0, None, None) , 0 , )),
	(( 'GetCampbellProperties' , ), 1610743900, (1610743900, (), [ ], 1 , 1 , 4 , 0 , 792 , (3, 0, None, None) , 0 , )),
	(( 'DrawCampbellSignalInfor' , 'enCampbellDataType' , ), 1610743901, (1610743901, (), [ (3, 1, None, "IID('{4E55A9C7-3A08-36EA-A47C-B698A2D3B24D}')") , ], 1 , 1 , 4 , 0 , 800 , (3, 0, None, None) , 0 , )),
	(( 'SetTimeComponent' , 'strPath' , 'iIndex' , ), 1610743902, (1610743902, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 808 , (3, 0, None, None) , 0 , )),
	(( 'SetTachoComponent' , 'strPath' , 'iIndex' , ), 1610743903, (1610743903, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 816 , (3, 0, None, None) , 0 , )),
	(( 'SetSignalComponent' , 'strPath' , 'iIndex' , ), 1610743904, (1610743904, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 824 , (3, 0, None, None) , 0 , )),
]

IChart_vtables_dispatch_ = 1
IChart_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Padding' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragAction' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16387, 10, None, "IID('{F840B6EE-855A-39DB-A57E-C31F3633F549}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'MouseDragAction' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (3, 1, None, "IID('{F840B6EE-855A-39DB-A57E-C31F3633F549}')") , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'XAxisCollection' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'YAxisCollection' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'SeriesCollection' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'AnnotationCollection' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{B89390C5-E030-404E-9B93-B9B2EB12D6A2}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ModifierLegend' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16393, 10, None, "IID('{D6153141-938E-4E8A-B6E2-ED8EFE62E091}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'ModifierTooltip' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16393, 10, None, "IID('{FD63AE8C-75EF-437B-AB41-0654C94D7F03}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'ModifierTimeLine' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16393, 10, None, "IID('{7440FFE1-9009-44ED-90D1-6B7A9143AB66}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'ModifierSeriesInfo' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16393, 10, None, "IID('{C79751D8-4907-4B9E-8169-311B17858169}')") , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'TitleStyle' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16393, 10, None, "IID('{F779994A-D846-4F12-AE53-DD023F6973B9}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'GridLinePanelStyle' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16393, 10, None, "IID('{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}')") , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'ChartPalette' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16393, 10, None, "IID('{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MultipleAxisDrawOption' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, "IID('{C038E096-9B57-3022-9044-B201C0B61CF7}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MultipleAxisDrawOption' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, "IID('{C038E096-9B57-3022-9044-B201C0B61CF7}')") , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Fit' , 'enDirection' , ), 1610743831, (1610743831, (), [ (3, 1, None, "IID('{D9E129D4-E0BB-38D7-B8A3-23CE1FB45903}')") , ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'Delete' , 'varEntity' , ), 1610743832, (1610743832, (), [ (9, 1, None, "IID('{691044DE-CC8C-4822-8E2F-736529CFC5A4}')") , ], 1 , 1 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'ExportToImageFile' , 'strFilepath' , 'enImageformat' , ), 1610743833, (1610743833, (), [ (8, 1, None, None) , 
			 (3, 1, None, "IID('{95C04992-D95A-3144-BB6F-137D882A0076}')") , ], 1 , 1 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'ExportSeriesData' , 'strFilepath' , 'bIncludeHeader' , 'iNumberOfSignificantDigit' , 'bUseScientificNotation' , 
			 'arrChartSeries' , ), 1610743834, (1610743834, (), [ (8, 1, None, None) , (11, 1, None, None) , (3, 1, None, None) , 
			 (11, 1, None, None) , (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
]

IChart3D_vtables_dispatch_ = 1
IChart3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsXyzGizmoVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsXyzGizmoVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ViewType' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16387, 10, None, "IID('{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ViewType' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (3, 1, None, "IID('{F1360ED5-68CA-3159-AF66-AEBD1E073CE0}')") , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'DataSeriesType' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16387, 10, None, "IID('{25C31D8F-41CE-3251-B056-7A3E9C28F8E6}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'AdditionalViewerType' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16387, 10, None, "IID('{12D5CC46-4F73-34E2-8064-B2EDF9EC8602}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'AdditionalViewerType' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (3, 1, None, "IID('{12D5CC46-4F73-34E2-8064-B2EDF9EC8602}')") , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'CoordinateSystem' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16387, 10, None, "IID('{BDA5F1CC-EB77-3913-B364-5BCA4E43E35E}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'CoordinateSystem' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (3, 1, None, "IID('{BDA5F1CC-EB77-3913-B364-5BCA4E43E35E}')") , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'XyPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'XyPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'ZyPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16387, 10, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'ZyPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (3, 1, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'ZxPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'ZxPlaneDrawLabelsMode' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, "IID('{AA825E9D-B252-3DF4-8688-DAA4E3C5F130}')") , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'XAxis3D' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16393, 10, None, "IID('{726C8F68-8A81-4F1F-8D5E-3249898D875B}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'YAxis3D' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16393, 10, None, "IID('{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}')") , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'ZAxis3D' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16393, 10, None, "IID('{45B05150-78E3-4188-AA31-CC0DE518FF1F}')") , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'SeriesCollection' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16393, 10, None, "IID('{8EE0A50B-A095-4196-B3A2-189A36105476}')") , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'TitleStyle' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16393, 10, None, "IID('{BB3F7878-1B92-4B36-B688-31107524DB25}')") , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'CampbellProperty' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16393, 10, None, "IID('{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}')") , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'Modifier3DLegend' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16393, 10, None, "IID('{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'ContourLegend' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16393, 10, None, "IID('{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}')") , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'Modifier3DTooltip' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16393, 10, None, "IID('{61409795-1BB1-4C04-B851-10B44F02F5A5}')") , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'Modifier3DSectionViewer' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16393, 10, None, "IID('{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'SliceViewer' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16393, 10, None, "IID('{279362D2-44D2-4A28-A600-D889E108D5D8}')") , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'ChartPalette' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16393, 10, None, "IID('{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}')") , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'Delete' , 'varEntity' , ), 1610743842, (1610743842, (), [ (9, 1, None, "IID('{26823D92-8950-47F5-BE7F-E27509032204}')") , ], 1 , 1 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'Fit' , ), 1610743843, (1610743843, (), [ ], 1 , 1 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'Redraw' , ), 1610743844, (1610743844, (), [ ], 1 , 1 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
]

IChart3DCampbellProperty_vtables_dispatch_ = 1
IChart3DCampbellProperty_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'UseInputFile' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'CampbellInputFile' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'TimeComponent' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'TachoComponent' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SignalComponent' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'RPMData' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FrequencyData' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'OrderData' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'PhaseData' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'RPMFrequencyData' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'RPMFrequencyPhaseData' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'RPMOrderPhaseData' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'GraphOption' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{CD553711-F6DF-3222-AB54-18337C5AA2E2}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'GraphOption' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{CD553711-F6DF-3222-AB54-18337C5AA2E2}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'IsSwapAxis' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'IsSwapAxis' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Resolution' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Resolution' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Gap' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Gap' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'MinimumOrder' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'MinimumOrder' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MaximumOrder' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'MaximumOrder' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'SurfaceMesh2DContourType' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16387, 10, None, "IID('{1F838B39-95C4-3252-87A9-BF2486461400}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'SurfaceMesh2DContourType' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (3, 1, None, "IID('{1F838B39-95C4-3252-87A9-BF2486461400}')") , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'IsOrderLineVisible' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'IsOrderLineVisible' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'ShowOrderNumber' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16387, 10, None, "IID('{409874E3-739A-3E60-9D74-CF6DEF3CF0A7}')") , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'ShowOrderNumber' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (3, 1, None, "IID('{409874E3-739A-3E60-9D74-CF6DEF3CF0A7}')") , ], 1 , 4 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineThickness' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineThickness' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'OrderLineColor' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'OrderTextSize' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'OrderTextSize' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'UseDecibelPlot' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'UseDecibelPlot' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'ApplyWindowCorrectionFactor' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'ApplyWindowCorrectionFactor' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'DecibelReferenceValue' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'DecibelReferenceValue' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'CorrectionFactor' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'CorrectionFactor' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
	(( 'UpdateCampbellGraph' , ), 1610743855, (1610743855, (), [ ], 1 , 1 , 4 , 0 , 432 , (3, 0, None, None) , 0 , )),
	(( 'RefreshOrderLines' , ), 1610743856, (1610743856, (), [ ], 1 , 1 , 4 , 0 , 440 , (3, 0, None, None) , 0 , )),
]

IChart3DContourLegend_vtables_dispatch_ = 1
IChart3DContourLegend_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'LegendPosition' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16387, 10, None, "IID('{359DCDA9-97F2-3158-A5AC-3969E925497E}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LegendPosition' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (3, 1, None, "IID('{359DCDA9-97F2-3158-A5AC-3969E925497E}')") , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'ColorMap' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (24588, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'IsStepped' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'IsStepped' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormat' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormat' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ShowMinMaxLabelsOnly' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ShowMinMaxLabelsOnly' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Maximum' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Minimum' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'UpdateLegendColorMap' , ), 1610743830, (1610743830, (), [ ], 1 , 1 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'UpdateColorMapToSeries' , 'arrLegendColor' , ), 1610743831, (1610743831, (), [ (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'InitializeBandLevel' , 'iBandLevel' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (3, 1, None, None) , 
			 (24588, 10, None, None) , ], 1 , 1 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
]

IChart3DSliceViewer_vtables_dispatch_ = 1
IChart3DSliceViewer_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'StartFrequency' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'StartFrequency' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'EndFrequency' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'EndFrequency' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Gap' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Gap' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'AxisColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'SliceLineColor' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'ShowSliceLines' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ShowSliceLines' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'SliceLineThickness' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'SliceLineThickness' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'SliceLineStyle' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'SliceLineStyle' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'UseVoldKalmanFilter' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'UseVoldKalmanFilter' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'VKInputType' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, "IID('{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'VKInputType' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, "IID('{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}')") , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'FrequencyBandWidth' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'FrequencyBandWidth' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterWeightingFactor' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterWeightingFactor' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterNumberOfPole' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16387, 10, None, "IID('{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}')") , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterNumberOfPole' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (3, 1, None, "IID('{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}')") , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UpdateSliceViewer' , ), 1610743836, (1610743836, (), [ ], 1 , 1 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'InitializeStartEndFrequency' , ), 1610743837, (1610743837, (), [ ], 1 , 1 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleGridLine_vtables_dispatch_ = 1
IChart3DStyleGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleMajorGridLine_vtables_dispatch_ = 1
IChart3DStyleMajorGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleMinorGridLine_vtables_dispatch_ = 1
IChart3DStyleMinorGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleTickLabel_vtables_dispatch_ = 1
IChart3DStyleTickLabel_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawLabels' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawLabels' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleTickLine_vtables_dispatch_ = 1
IChart3DStyleTickLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
]

IChart3DStyleTitle_vtables_dispatch_ = 1
IChart3DStyleTitle_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
]

IChartAnnotation_vtables_dispatch_ = 1
IChartAnnotation_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
]

IChartAnnotationArrow_vtables_dispatch_ = 1
IChartAnnotationArrow_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'LineColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'XStartValue' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'XStartValue' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'XEndValue' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'XEndValue' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'YStartValue' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'YStartValue' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'YEndValue' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'YEndValue' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
]

IChartAnnotationCollection_vtables_dispatch_ = 1
IChartAnnotationCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{1A536495-EBB2-3064-8F82-965701F9C9E6}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{1A536495-EBB2-3064-8F82-965701F9C9E6}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IChartAnnotationLine_vtables_dispatch_ = 1
IChartAnnotationLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'LineColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'XStartValue' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'XStartValue' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'XEndValue' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'XEndValue' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'YStartValue' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'YStartValue' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'YEndValue' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'YEndValue' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
]

IChartAnnotationText_vtables_dispatch_ = 1
IChartAnnotationText_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Text' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Text' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'YValue' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'YValue' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
]

IChartAnnotationVerticalLine_vtables_dispatch_ = 1
IChartAnnotationVerticalLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'LabelFontColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'LineColor' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'ShowLabel' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'ShowLabel' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
]

IChartAxis3D_vtables_dispatch_ = 1
IChartAxis3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'AxisPlaneBackground' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderColor' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16387, 10, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (3, 1, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16393, 10, None, "IID('{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'Min' , 'Max' , ), 1610743850, (1610743850, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
]

IChartAxisBase_vtables_dispatch_ = 1
IChartAxisBase_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'TitleStyle' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{0425D327-6C6A-4081-8DBB-337984399370}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{DE759D88-66E1-4764-86B0-96D98197A346}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'AxisId' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'dMin' , 'dMax' , ), 1610743847, (1610743847, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMaxWithAnimation' , 'dMin' , 'dMax' , ), 1610743848, (1610743848, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'SeriesCollection' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743850, (1610743850, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743850, (1610743850, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
]

IChartAxisX_vtables_dispatch_ = 1
IChartAxisX_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'TitleStyle' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{0425D327-6C6A-4081-8DBB-337984399370}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{DE759D88-66E1-4764-86B0-96D98197A346}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'AxisId' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'dMin' , 'dMax' , ), 1610743846, (1610743846, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMaxWithAnimation' , 'dMin' , 'dMax' , ), 1610743847, (1610743847, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'SeriesCollection' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'AxisAlignment' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (16387, 10, None, "IID('{4F387FCB-DA43-3B87-B972-3E158FBC0CCD}')") , ], 1 , 2 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'AxisAlignment' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (3, 1, None, "IID('{4F387FCB-DA43-3B87-B972-3E158FBC0CCD}')") , ], 1 , 4 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
]

IChartAxisX3D_vtables_dispatch_ = 1
IChartAxisX3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'AxisPlaneBackground' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderColor' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16387, 10, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (3, 1, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16393, 10, None, "IID('{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'Min' , 'Max' , ), 1610743850, (1610743850, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
]

IChartAxisY_vtables_dispatch_ = 1
IChartAxisY_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'TitleStyle' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{0425D327-6C6A-4081-8DBB-337984399370}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{DE759D88-66E1-4764-86B0-96D98197A346}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'AxisId' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Unit' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'dMin' , 'dMax' , ), 1610743846, (1610743846, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMaxWithAnimation' , 'dMin' , 'dMax' , ), 1610743847, (1610743847, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'SeriesCollection' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'AxisAlignment' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (16387, 10, None, "IID('{D64833C6-8709-3D8C-A476-65EBC90BADCA}')") , ], 1 , 2 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'AxisAlignment' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (3, 1, None, "IID('{D64833C6-8709-3D8C-A476-65EBC90BADCA}')") , ], 1 , 4 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
]

IChartAxisY3D_vtables_dispatch_ = 1
IChartAxisY3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'AxisPlaneBackground' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderColor' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16387, 10, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (3, 1, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16393, 10, None, "IID('{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'Min' , 'Max' , ), 1610743850, (1610743850, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
]

IChartAxisZ3D_vtables_dispatch_ = 1
IChartAxisZ3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Title' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormatting' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawMajorBands' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'BandsColor' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'AxisPlaneBackground' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderColor' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'PlaneBorderThickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'NumberOfMajorTicks' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MinorsPerMajor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'MajorDelta' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'MinorDelta' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'UseAutoTicks' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'MaxAutoTicks' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'AxisType' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{5EC7015B-22FC-389F-90AE-A4E0D209BE83}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'LogarithmicBase' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16387, 10, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelAlignment' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (3, 1, None, "IID('{7D851246-32DD-3CD2-8FF6-11A4B9C76DE9}')") , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'TickLabelStyle' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16393, 10, None, "IID('{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'MajorTickLineStyle' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'MinorTickLineStyle' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16393, 10, None, "IID('{B7273930-1505-42EA-BE86-F7A752B288B1}')") , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'MajorGridLineStyle' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'MinorGridLineStyle' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'SetMinMax' , 'Min' , 'Max' , ), 1610743850, (1610743850, (), [ (5, 1, None, None) , 
			 (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
]

IChartBase_vtables_dispatch_ = 1
IChartBase_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DCameraPan_vtables_dispatch_ = 1
IChartModifier3DCameraPan_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'MouseSensitivity' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16403, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'MouseSensitivity' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (19, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DDragPan_vtables_dispatch_ = 1
IChartModifier3DDragPan_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DDragZoom_vtables_dispatch_ = 1
IChartModifier3DDragZoom_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DLegend_vtables_dispatch_ = 1
IChartModifier3DLegend_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ShowLegend' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'ShowLegend' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeries' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeries' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16387, 10, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (3, 1, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16387, 10, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (3, 1, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Position' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16387, 10, None, "IID('{CE9EFAA5-A83D-377F-87BE-477B40B29073}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Position' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (3, 1, None, "IID('{CE9EFAA5-A83D-377F-87BE-477B40B29073}')") , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Orientation' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16387, 10, None, "IID('{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'Orientation' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (3, 1, None, "IID('{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}')") , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16393, 10, None, "IID('{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DMouseWheelZoom_vtables_dispatch_ = 1
IChartModifier3DMouseWheelZoom_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DOrbit_vtables_dispatch_ = 1
IChartModifier3DOrbit_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DSectionViewer_vtables_dispatch_ = 1
IChartModifier3DSectionViewer_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartXAxisTitle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartXAxisTitle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartYAxisTitle' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartYAxisTitle' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'RightChartXAxisTitle' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'RightChartXAxisTitle' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'RightChartYAxisTitle' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'RightChartYAxisTitle' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartPhaseXAxisTitle' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartPhaseXAxisTitle' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartPhaseYAxisTitle' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'BottomChartPhaseYAxisTitle' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'RightChartPhaseXAxisTitle' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'RightChartPhaseXAxisTitle' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'RightChartPhaseYAxisTitle' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'RightChartPhaseYAxisTitle' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'ZValue' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'ZValue' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'ShowSectionLine' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'ShowSectionLine' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'LineColor' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'SectionChartCurveColor' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'SectionChartAxisColor' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'UseVoldKalmanFilter' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'UseVoldKalmanFilter' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'VKInputType' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16387, 10, None, "IID('{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'VKInputType' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (3, 1, None, "IID('{877D4FC1-17ED-3E6D-9BD9-FC721561A2B3}')") , ], 1 , 4 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'FrequencyBandWidth' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'FrequencyBandWidth' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterWeightingFactor' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterWeightingFactor' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterNumberOfPole' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16387, 10, None, "IID('{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}')") , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'VKFilterNumberOfPole' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (3, 1, None, "IID('{D564116C-1F9B-3CFF-8805-A9E4781A4DBF}')") , ], 1 , 4 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'UpdateSectionViewer' , ), 1610743853, (1610743853, (), [ ], 1 , 1 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DTooltip_vtables_dispatch_ = 1
IChartModifier3DTooltip_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifier3DZoomExtents_vtables_dispatch_ = 1
IChartModifier3DZoomExtents_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IChartModifierLegend_vtables_dispatch_ = 1
IChartModifierLegend_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ShowLegend' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'ShowLegend' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeries' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeries' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16387, 10, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (3, 1, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16387, 10, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (3, 1, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Position' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16387, 10, None, "IID('{CE9EFAA5-A83D-377F-87BE-477B40B29073}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Position' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (3, 1, None, "IID('{CE9EFAA5-A83D-377F-87BE-477B40B29073}')") , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'Orientation' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16387, 10, None, "IID('{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'Orientation' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (3, 1, None, "IID('{4DAF42F0-AAC0-3627-805B-C2DA4E888C5A}')") , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16393, 10, None, "IID('{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
]

IChartModifierSeriesInfo_vtables_dispatch_ = 1
IChartModifierSeriesInfo_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'MarkerSize' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'MarkerSize' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'MinColor' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'MaxColor' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'InspectionLineColor' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'MinMaxVisibility' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16401, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'MinMaxVisibility' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (17, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'TargetSeriesLegend' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'XValue' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'YValue' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'Index' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'TotalIndex' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Min' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'XValueAtMin' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'IndexAtMin' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'Max' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'XValueAtMax' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'IndexAtMax' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'TotalAverage' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'TotalRMS' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'LocalAverage' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'LocalRMS' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'LocalMin' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'XValueAtLocalMin' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'IndexAtLocalMin' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'LocalMax' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'XValueAtLocalMax' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'IndexAtLocalMax' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'LocalDeltaX' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'LocalDeltaY' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'LocalSlope' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'DeltaX' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'DeltaY' , 'pRetVal' , ), 1610743850, (1610743850, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'Slope' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'ShowInflectionPoints' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'ShowInflectionPoints' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'InflectionPoints' , 'pRetVal' , ), 1610743854, (1610743854, (), [ (24585, 10, None, "IID('{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}')") , ], 1 , 2 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
	(( 'InflectionValues' , 'pRetVal' , ), 1610743855, (1610743855, (), [ (24585, 10, None, "IID('{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}')") , ], 1 , 2 , 4 , 0 , 432 , (3, 0, None, None) , 0 , )),
	(( 'InflectionTolerance' , 'pRetVal' , ), 1610743856, (1610743856, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 440 , (3, 0, None, None) , 0 , )),
	(( 'InflectionTolerance' , 'pRetVal' , ), 1610743856, (1610743856, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 448 , (3, 0, None, None) , 0 , )),
	(( 'InspectlineValueX1' , 'pRetVal' , ), 1610743858, (1610743858, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 456 , (3, 0, None, None) , 0 , )),
	(( 'InspectlineValueX1' , 'pRetVal' , ), 1610743858, (1610743858, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 464 , (3, 0, None, None) , 0 , )),
	(( 'InspectlineValueX2' , 'pRetVal' , ), 1610743860, (1610743860, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 472 , (3, 0, None, None) , 0 , )),
	(( 'InspectlineValueX2' , 'pRetVal' , ), 1610743860, (1610743860, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 480 , (3, 0, None, None) , 0 , )),
	(( 'IsInspectLocalArea' , 'pRetVal' , ), 1610743862, (1610743862, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 488 , (3, 0, None, None) , 0 , )),
	(( 'IsInspectLocalArea' , 'pRetVal' , ), 1610743862, (1610743862, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 496 , (3, 0, None, None) , 0 , )),
	(( 'UpdateInflectionPoint' , ), 1610743864, (1610743864, (), [ ], 1 , 1 , 4 , 0 , 504 , (3, 0, None, None) , 0 , )),
]

IChartModifierTimeLine_vtables_dispatch_ = 1
IChartModifierTimeLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'TimeLineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{496406A4-661D-4FA1-A778-FDA86C1C1DA4}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'TooltipTransparency' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'TooltipTransparency' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ShowTooltip' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ShowTooltip' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'TooltipEffect' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'TooltipEffect' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
]

IChartModifierTooltip_vtables_dispatch_ = 1
IChartModifierTooltip_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsEnabled' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormat' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'NumberFormat' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ShowAxisLabels' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'ShowAxisLabels' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'ShowTooltip' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ShowTooltip' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16387, 10, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'DisplayMode' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (3, 1, None, "IID('{80F9BAAD-1438-32E3-8686-2B06A7E5FF71}')") , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'UseInterpolation' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'UseInterpolation' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeriesName' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeriesName' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'ShowEffect' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'ShowEffect' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'Transparency' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'TooltipStyle' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16387, 10, None, "IID('{0F8CEAC8-36FC-3EE2-B93D-CAEFC25C483A}')") , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'TooltipStyle' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (3, 1, None, "IID('{0F8CEAC8-36FC-3EE2-B93D-CAEFC25C483A}')") , ], 1 , 4 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'TooltipPlacement' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16387, 10, None, "IID('{50C2AC1A-FBF1-38FD-85ED-BD51382BAE52}')") , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'TooltipPlacement' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (3, 1, None, "IID('{50C2AC1A-FBF1-38FD-85ED-BD51382BAE52}')") , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
]

IChartPalette_vtables_dispatch_ = 1
IChartPalette_vtables_ = [
	(( 'PaletteColorSet' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, "IID('{348CB393-4BA9-3E8E-9E4C-07518B07A389}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'PaletteColorSet' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (3, 1, None, "IID('{348CB393-4BA9-3E8E-9E4C-07518B07A389}')") , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'PaletteCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (24595, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'CurrentColor' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16403, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Palette' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (24595, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'CustomPalette' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (24595, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'CustomPalette' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (8211, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
]

IChartPointMarker_vtables_dispatch_ = 1
IChartPointMarker_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'MarkerType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{CBCA3731-E91A-3899-BFD7-522BA7D53173}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'MarkerType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{CBCA3731-E91A-3899-BFD7-522BA7D53173}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Width' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Width' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Height' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Height' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
]

IChartPointMarker3D_vtables_dispatch_ = 1
IChartPointMarker3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'MarkerType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{41D82DD8-FB9D-3D19-AE72-AC36231CB3A7}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'MarkerType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{41D82DD8-FB9D-3D19-AE72-AC36231CB3A7}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Size' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Size' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChartSeries_vtables_dispatch_ = 1
IChartSeries_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'SeriesType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{A2FD9CD9-AB13-3DFE-AA91-6D51A121B7E3}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'SeriesType' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{A2FD9CD9-AB13-3DFE-AA91-6D51A121B7E3}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'SamplingMode' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16387, 10, None, "IID('{DFEE2EAF-60F4-31EE-8F7F-9CCA2211EF08}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'SamplingMode' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (3, 1, None, "IID('{DFEE2EAF-60F4-31EE-8F7F-9CCA2211EF08}')") , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'ZeroLineY' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'ZeroLineY' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'PointMarker' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16393, 10, None, "IID('{A57DEE8B-3147-4E83-A188-65C5A265F0D5}')") , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'XAxis' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 8 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'YAxis' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 8 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'XValues' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'YValues' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'XValuesKey' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'XValuesKey' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'YValuesKey' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'YValuesKey' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'SetValue' , 'arrXValue' , 'arrYValue' , ), 1610743840, (1610743840, (), [ (8197, 1, None, None) , 
			 (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'SeriesInfo' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
]

IChartSeries3D_vtables_dispatch_ = 1
IChartSeries3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
]

IChartSeriesPointLine3D_vtables_dispatch_ = 1
IChartSeriesPointLine3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'PointMarker' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'IsLineStrips' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsLineStrips' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'XValues' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'YValues' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'ZValues' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (24581, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'SetValue' , 'arrXValue' , 'arrYValue' , 'arrZValue' , ), 1610743827, (1610743827, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
]

IChartSeriesSurfaceMesh3D_vtables_dispatch_ = 1
IChartSeriesSurfaceMesh3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Legend' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'DrawMeshAs' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16387, 10, None, "IID('{D42F05C9-303E-3BC4-88E8-277AFC5DD256}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'DrawMeshAs' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (3, 1, None, "IID('{D42F05C9-303E-3BC4-88E8-277AFC5DD256}')") , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'HeightScaleFactor' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'HeightScaleFactor' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Highlight' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'Highlight' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'LightingFactor' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'LightingFactor' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'CellHardnessFactor' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'CellHardnessFactor' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'Shininess' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'Shininess' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'DrawSkirt' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'DrawSkirt' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'SetValue' , 'arrXSteppingValue' , 'arrZSteppingValue' , 'arrMeshGridDataValue' , ), 1610743833, (1610743833, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'Minimum' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'Maximum' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'YOffset' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16388, 10, None, None) , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'YOffset' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (4, 1, None, None) , ], 1 , 4 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
]

IChartStyleAxisTitle_vtables_dispatch_ = 1
IChartStyleAxisTitle_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16387, 10, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'VerticalAlignment' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (3, 1, None, "IID('{285AAC91-6B06-3C2A-9AA8-22B794E24920}')") , ], 1 , 4 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
]

IChartStyleGridLine_vtables_dispatch_ = 1
IChartStyleGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IChartStyleGridLinePanel_vtables_dispatch_ = 1
IChartStyleGridLinePanel_vtables_ = [
	(( 'Background' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'BorderColor' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'BorderThickness' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IChartStyleMajorGridLine_vtables_dispatch_ = 1
IChartStyleMajorGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
]

IChartStyleMajorTickLine_vtables_dispatch_ = 1
IChartStyleMajorTickLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
]

IChartStyleMinorGridLine_vtables_dispatch_ = 1
IChartStyleMinorGridLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16387, 10, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'LineStyle' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (3, 1, None, "IID('{8AC03905-DCB6-3E8B-A8C5-F7F26746A847}')") , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'DrawGridLines' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
]

IChartStyleMinorTickLine_vtables_dispatch_ = 1
IChartStyleMinorTickLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'DrawTicks' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
]

IChartStyleTickLabel_vtables_dispatch_ = 1
IChartStyleTickLabel_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'DrawLabels' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawLabels' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'LabelAngle' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'LabelAngle' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
]

IChartStyleTickLine_vtables_dispatch_ = 1
IChartStyleTickLine_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Color' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Thickness' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'XLength' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'YLength' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Length' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
]

IChartStyleTitle_vtables_dispatch_ = 1
IChartStyleTitle_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'HorizontalAlignment' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{234E2608-3F42-30FD-A53F-5A20FA71E473}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'FontColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FontSize' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16387, 10, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FontWeight' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (3, 1, None, "IID('{D449496E-2B7D-3E60-BA9D-07D60DCEAAD5}')") , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Font' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16387, 10, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'FontStyle' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (3, 1, None, "IID('{06576144-3110-3796-A302-671D3EA3748B}')") , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'Background' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
]

IChartTimeLineAnnotationStyle_vtables_dispatch_ = 1
IChartTimeLineAnnotationStyle_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ShowLabel' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'ShowLabel' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'LineColor' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'LineThickness' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IColor_vtables_dispatch_ = 1
IColor_vtables_ = [
	(( 'Alpha' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16401, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Alpha' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (17, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Blue' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16401, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Blue' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (17, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Green' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16401, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Green' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (17, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Red' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16401, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Red' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (17, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'FromARGB' , 'uRGBAColor' , ), 1610743816, (1610743816, (), [ (19, 1, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FromColor' , 'varColor' , ), 1610743817, (1610743817, (), [ (19, 1, None, None) , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FromBGR' , 'uBGRColor' , ), 1610743818, (1610743818, (), [ (19, 1, None, None) , ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'ToUnit' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16403, 10, None, None) , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
]

ICommand_vtables_dispatch_ = 1
ICommand_vtables_ = [
	(( 'Execute' , 'varParameter' , ), 1610743808, (1610743808, (), [ (12, 1, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
]

IControl_vtables_dispatch_ = 1
IControl_vtables_ = [
	(( 'Window' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ViewModel' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
]

IDataComponent_vtables_dispatch_ = 1
IDataComponent_vtables_ = [
	(( 'Path' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Path' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Index' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Index' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IDataFileDatabase_vtables_dispatch_ = 1
IDataFileDatabase_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'DataItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ExpandAll' , ), 1610743811, (1610743811, (), [ ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ExpandItem' , 'databaseItem' , ), 1610743812, (1610743812, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'SelectedItems' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'RegisterFileReader' , 'strFileExtension' , 'varReaderType' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , 
			 (13, 1, None, "IID('{BCA8B44D-AAD6-3A86-8AB7-03349F4F2DA2}')") , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'GetXAxisPath' , 'varItem' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , 
			 (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SetXAxis' , 'varItem' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DrawSeries' , 'varItem' , ), 1610743817, (1610743817, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'DrawSeriesWithKey' , 'strKey' , 'iIndex' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , 
			 (3, 49, '0', None) , ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'DrawSeriesWithSeriesValueInfo' , 'strSeriesName' , 'varXInfo' , 'varYInfo' , ), 1610743819, (1610743819, (), [ 
			 (8, 1, None, None) , (9, 1, None, "IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')") , (9, 1, None, "IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')") , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'MultiDrawSeries' , 'varItem' , ), 1610743820, (1610743820, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'GetValues' , 'varItem' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , 
			 (24581, 10, None, None) , ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'GetUnit' , 'varItem' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , 
			 (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'AddUserData' , 'strName' , 'arrValue' , ), 1610743823, (1610743823, (), [ (8, 1, None, None) , 
			 (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'RemoveDataItem' , 'varItem' , ), 1610743824, (1610743824, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'RemoveAllDataItems' , ), 1610743825, (1610743825, (), [ ], 1 , 1 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'GetDatabaseItem' , 'strKey' , 'iIndex' , 'pRetVal' , ), 1610743826, (1610743826, (), [ 
			 (8, 1, None, None) , (3, 49, '0', None) , (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'GetDatabaseItemWithFullPath' , 'strFullPath' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'GetImportedFilePathList' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (24584, 10, None, None) , ], 1 , 1 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'GetPlottableNameList' , 'iIndex' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (3, 1, None, None) , 
			 (24584, 10, None, None) , ], 1 , 1 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'ExportData' , 'strFilepath' , 'arrItem' , ), 1610743830, (1610743830, (), [ (8, 1, None, None) , 
			 (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'GetIndexOfDataFile' , 'strFilepath' , 'pRetVal' , ), 1610743831, (1610743831, (), [ (8, 1, None, None) , 
			 (16387, 10, None, None) , ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid' , 'varRootItem' , ), 1610743832, (1610743832, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'IsPreviewMode' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'IsPreviewMode' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'ChangeDataFileActiveModel' , 'varRootItem' , ), 1610743835, (1610743835, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'ChangeDataFileActivePlot' , 'varRootItem' , ), 1610743836, (1610743836, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFileActiveModel' , 'varRootItem' , ), 1610743837, (1610743837, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFileActiveModel_2' , 'arrRootItem' , ), 1610743838, (1610743838, (), [ (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFileActivePlot' , 'arrRootItem' , ), 1610743839, (1610743839, (), [ (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'ImportDataFile' , 'strFilepath' , ), 1610743840, (1610743840, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'ReloadDatafiles' , ), 1610743841, (1610743841, (), [ ], 1 , 1 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'ExcludeSelectedItems' , ), 1610743842, (1610743842, (), [ ], 1 , 1 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'IncludeAllItems' , ), 1610743843, (1610743843, (), [ ], 1 , 1 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'ShowCheckBox' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
]

IDataFileDatabaseItem_vtables_dispatch_ = 1
IDataFileDatabaseItem_vtables_ = [
	(( 'Entity' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Parent' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Items' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'IsChecked' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'IsChecked' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'IsExpanded' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'IsExpanded' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'GetRoot' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'GetPath' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsRemovedByFilter' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'IsRemovedByFilter' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'IsXAxis' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'IsUserData' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'CanDrawItem' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16395, 10, None, None) , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
]

IDatabase_vtables_dispatch_ = 1
IDatabase_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'DataItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ExpandAll' , ), 1610743811, (1610743811, (), [ ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ExpandItem' , 'varDatabaseItem' , ), 1610743812, (1610743812, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
]

IDatabaseItem_vtables_dispatch_ = 1
IDatabaseItem_vtables_ = [
	(( 'Entity' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Parent' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Items' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'IsVisible' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'IsSelected' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'IsChecked' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'IsChecked' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'IsExpanded' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'IsExpanded' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'GetRoot' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'GetPath' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'IsRemovedByFilter' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'IsRemovedByFilter' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
]

IDatabaseItemCollection_vtables_dispatch_ = 1
IDatabaseItemCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IDocumentCollection_vtables_dispatch_ = 1
IDocumentCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IDraw3DDatabase_vtables_dispatch_ = 1
IDraw3DDatabase_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'XComponent' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'YComponent' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ZComponent' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'DrawSeries' , ), 1610743813, (1610743813, (), [ ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'SetXComponent' , 'strPath' , 'iIndex' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'SetYComponent' , 'strPath' , 'iIndex' , ), 1610743815, (1610743815, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SetZComponent' , 'strPath' , 'iIndex' , ), 1610743816, (1610743816, (), [ (8, 1, None, None) , 
			 (3, 1, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IEntity_vtables_dispatch_ = 1
IEntity_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IEntityCollection_vtables_dispatch_ = 1
IEntityCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{E0C292B7-592C-4F26-B935-578E8229E9E7}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{E0C292B7-592C-4F26-B935-578E8229E9E7}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IEntityDocument_vtables_dispatch_ = 1
IEntityDocument_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'EntityManager' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
]

IEntityManager_vtables_dispatch_ = 1
IEntityManager_vtables_ = [
	(( 'LastEntityID' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'GetNewEntityName' , 'strKey' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (8, 1, None, None) , 
			 (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Collection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{05E42E73-072B-4DCB-9FFE-5412165947AF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IEntityModel_vtables_dispatch_ = 1
IEntityModel_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'EntityManager' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'FilePath' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
]

IEntityPlot_vtables_dispatch_ = 1
IEntityPlot_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Chart' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
]

IEntityPlot3D_vtables_dispatch_ = 1
IEntityPlot3D_vtables_ = [
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Name' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'FullName' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ID' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Chart3D' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{919C04CC-90E5-409E-85F3-3256F29E6247}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
]

ILegendColor_vtables_dispatch_ = 1
ILegendColor_vtables_ = [
	(( 'Color' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{5CD358A2-1CC0-46BF-B605-C48C52949E59}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'StartValue' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'StartValue' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'EndValue' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IMainDocument_vtables_dispatch_ = 1
IMainDocument_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Config' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ThemeManager' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16393, 10, None, "IID('{016C03D7-5933-4AE7-851D-87B1006287CA}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Output' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'ModelDatabase' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Draw3DDatabase' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{39230EEA-3374-400E-9489-2A7AEBB2E530}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'DataFileDatabase' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{979D321D-21DC-43D0-83BF-E1E7B75384F1}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'Ribbon' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'CampbellDiagram' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{2C300492-3E47-49C4-9B4A-CF44F434A0F5}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'RecentFiles' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (24584, 10, None, None) , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'ActiveModel' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{9D70138C-0DCA-4B63-951F-BCECB67522AE}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'ActivePlot' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ActivePlot3D' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{B7613ED0-4431-4A2B-829D-86D5A07B9C99}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ModelCollection' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16393, 10, None, "IID('{F30A1F02-5258-4FA0-A579-16829304270F}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'SaveModel' , 'strFilepath' , ), 1610743823, (1610743823, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'OpenModel' , 'strFilepath' , ), 1610743824, (1610743824, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'CloseModelDocument' , 'varModelControl' , ), 1610743825, (1610743825, (), [ (9, 1, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 1 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'CloseAllModelDocument' , ), 1610743826, (1610743826, (), [ ], 1 , 1 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'ImportDataFile' , 'strFilepath' , ), 1610743827, (1610743827, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'ConvertToChunkFormat' , 'strFilepath' , ), 1610743828, (1610743828, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'ExportPlot' , 'strFilepath' , ), 1610743829, (1610743829, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'SaveSettings' , 'strFilepath' , ), 1610743830, (1610743830, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'ApplySettings' , 'strFilepath' , 'varUserControl' , ), 1610743831, (1610743831, (), [ (8, 1, None, None) , 
			 (9, 1, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'ApplySettingsAll' , 'strFilepath' , ), 1610743832, (1610743832, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'ResetAllSettings' , ), 1610743833, (1610743833, (), [ ], 1 , 1 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'CreateModelWithPlot' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16393, 10, None, "IID('{9D70138C-0DCA-4B63-951F-BCECB67522AE}')") , ], 1 , 1 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'CreateModel' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16393, 10, None, "IID('{9D70138C-0DCA-4B63-951F-BCECB67522AE}')") , ], 1 , 1 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'CreatePlot' , 'enPosition' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (3, 1, None, "IID('{171A8921-2808-3ABE-ABA2-39149AD7BCA6}')") , 
			 (16393, 10, None, "IID('{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}')") , ], 1 , 1 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'CreatePlot3D' , 'enPosition' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (3, 1, None, "IID('{171A8921-2808-3ABE-ABA2-39149AD7BCA6}')") , 
			 (16393, 10, None, "IID('{B7613ED0-4431-4A2B-829D-86D5A07B9C99}')") , ], 1 , 1 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'ShowTimeLine' , 'bIsShown' , ), 1610743838, (1610743838, (), [ (11, 1, None, None) , ], 1 , 1 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'AnalysisFunctions' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16393, 10, None, "IID('{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
]

IMainViewModel_vtables_dispatch_ = 1
IMainViewModel_vtables_ = [
	(( 'ParentControl' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Operation' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Update' , ), 1610743810, (1610743810, (), [ ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'RecentFiles' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (24585, 10, None, "IID('{C3C429F9-8590-3A01-B2B2-434837F3D16D}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'NewModelCommand' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'NewModelWithPlotCommand' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'OpenModelCommand' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'SaveModelCommand' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SaveAsCommand' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'CloseActiveModelCommand' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'CloseModelCommand' , 'pRetVal' , ), 1610743818, (1610743818, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'CloseAllModelCommand' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'SelectThemeCommand' , 'pRetVal' , ), 1610743820, (1610743820, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'OpenHelpCommand' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'OpenApplicationOptionsWindowCommand' , 'pRetVal' , ), 1610743822, (1610743822, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'ImportFileCommand' , 'pRetVal' , ), 1610743823, (1610743823, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'ExportDataToFileCommand' , 'pRetVal' , ), 1610743824, (1610743824, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'ExportUserControlImageCommand' , 'pRetVal' , ), 1610743825, (1610743825, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'ExportModelImageCommand' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'NewPlotCommand' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'ClosePlotCommand' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'AddYAxisCommand' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'MultipleAxisDrawOption' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (16387, 10, None, "IID('{C038E096-9B57-3022-9044-B201C0B61CF7}')") , ], 1 , 2 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'MultipleAxisDrawOption' , 'pRetVal' , ), 1610743830, (1610743830, (), [ (3, 1, None, "IID('{C038E096-9B57-3022-9044-B201C0B61CF7}')") , ], 1 , 4 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
	(( 'ShowSeriesInfoWindowCommand' , 'pRetVal' , ), 1610743832, (1610743832, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 248 , (3, 0, None, None) , 0 , )),
	(( 'ShowModelDatabaseWindowCommand' , 'pRetVal' , ), 1610743833, (1610743833, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 256 , (3, 0, None, None) , 0 , )),
	(( 'ShowDataFileDatabaseWindowCommand' , 'pRetVal' , ), 1610743834, (1610743834, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 264 , (3, 0, None, None) , 0 , )),
	(( 'ShowScriptDatabaseWindowCommand' , 'pRetVal' , ), 1610743835, (1610743835, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 272 , (3, 0, None, None) , 0 , )),
	(( 'ShowScriptEditorWindowCommand' , 'pRetVal' , ), 1610743836, (1610743836, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 280 , (3, 0, None, None) , 0 , )),
	(( 'ShowScriptConsoleWindowCommand' , 'pRetVal' , ), 1610743837, (1610743837, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 288 , (3, 0, None, None) , 0 , )),
	(( 'ShowOutputWindowCommand' , 'pRetVal' , ), 1610743838, (1610743838, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 296 , (3, 0, None, None) , 0 , )),
	(( 'ShowPropertyGridWindowCommand' , 'pRetVal' , ), 1610743839, (1610743839, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 304 , (3, 0, None, None) , 0 , )),
	(( 'ShowDataEditorWindowCommand' , 'pRetVal' , ), 1610743840, (1610743840, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 312 , (3, 0, None, None) , 0 , )),
	(( 'ShowDraw3DDatabaseWindowCommand' , 'pRetVal' , ), 1610743841, (1610743841, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 320 , (3, 0, None, None) , 0 , )),
	(( 'ApplySettingAllCommand' , 'pRetVal' , ), 1610743842, (1610743842, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 328 , (3, 0, None, None) , 0 , )),
	(( 'ApplySettingToCurrentModelCommand' , 'pRetVal' , ), 1610743843, (1610743843, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 336 , (3, 0, None, None) , 0 , )),
	(( 'ApplySettingToCurrentPlotCommand' , 'pRetVal' , ), 1610743844, (1610743844, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 344 , (3, 0, None, None) , 0 , )),
	(( 'SaveSettingCommand' , 'pRetVal' , ), 1610743845, (1610743845, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 352 , (3, 0, None, None) , 0 , )),
	(( 'SaveAsDefaultSettingCommand' , 'pRetVal' , ), 1610743846, (1610743846, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 360 , (3, 0, None, None) , 0 , )),
	(( 'OpenDefaultSettingFolderCommand' , 'pRetVal' , ), 1610743847, (1610743847, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 368 , (3, 0, None, None) , 0 , )),
	(( 'ResetAllSettingsCommand' , 'pRetVal' , ), 1610743848, (1610743848, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 376 , (3, 0, None, None) , 0 , )),
	(( 'PreviewModeCommand' , 'pRetVal' , ), 1610743849, (1610743849, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 384 , (3, 0, None, None) , 0 , )),
	(( 'NewPlot3DCommand' , 'pRetVal' , ), 1610743850, (1610743850, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 392 , (3, 0, None, None) , 0 , )),
	(( 'RunChunkFormatConverterCommand' , 'pRetVal' , ), 1610743851, (1610743851, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 400 , (3, 0, None, None) , 0 , )),
	(( 'ShowFunctionEditorWindowCommand' , 'pRetVal' , ), 1610743852, (1610743852, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 408 , (3, 0, None, None) , 0 , )),
	(( 'RunCSharpScriptCommand' , 'pRetVal' , ), 1610743853, (1610743853, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 416 , (3, 0, None, None) , 0 , )),
	(( 'RunCSharpScriptFileCommand' , 'pRetVal' , ), 1610743854, (1610743854, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 424 , (3, 0, None, None) , 0 , )),
	(( 'RunCommandCommand' , 'pRetVal' , ), 1610743855, (1610743855, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 432 , (3, 0, None, None) , 0 , )),
	(( 'ShowCampbellDiagramCommand' , 'pRetVal' , ), 1610743856, (1610743856, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 440 , (3, 0, None, None) , 0 , )),
	(( 'AnimationPlayCommand' , 'pRetVal' , ), 1610743857, (1610743857, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 448 , (3, 0, None, None) , 0 , )),
	(( 'AnimationMoveFrameCommand' , 'pRetVal' , ), 1610743858, (1610743858, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 456 , (3, 0, None, None) , 0 , )),
	(( 'AnimationStopCommand' , 'pRetVal' , ), 1610743859, (1610743859, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 464 , (3, 0, None, None) , 0 , )),
	(( 'ShowAnimationControlPropertyCommand' , 'pRetVal' , ), 1610743860, (1610743860, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 472 , (3, 0, None, None) , 0 , )),
	(( 'ShowTimeLineCommand' , 'pRetVal' , ), 1610743861, (1610743861, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 480 , (3, 0, None, None) , 0 , )),
	(( 'ChangeDataFileModelCommand' , 'pRetVal' , ), 1610743862, (1610743862, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 488 , (3, 0, None, None) , 0 , )),
	(( 'ChangeDataFilePlotCommand' , 'pRetVal' , ), 1610743863, (1610743863, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 496 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFileModelCommand' , 'pRetVal' , ), 1610743864, (1610743864, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 504 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFilePlotCommand' , 'pRetVal' , ), 1610743865, (1610743865, (), [ (16393, 10, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , ], 1 , 2 , 4 , 0 , 512 , (3, 0, None, None) , 0 , )),
]

IModel_vtables_dispatch_ = 1
IModel_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ShowPaneHeader' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ShowPaneHeader' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Animation' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16393, 10, None, "IID('{5812880C-C727-4800-8762-E3EA5CFD8797}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Model' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (16393, 10, None, "IID('{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}')") , ], 1 , 2 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'SubDocumentCollection' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16393, 10, None, "IID('{266467B4-9F50-45FF-BE2D-ADB933BE70DE}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'ActiveDocument' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'CloseSubDocument' , 'varSubDocument' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ImportMedia' , 'strFilepath' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ExportImage' , 'srtFilepath' , ), 1610743818, (1610743818, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'GetSubDocumentByName' , 'strEntityName' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'UpdateHeader' , ), 1610743820, (1610743820, (), [ ], 1 , 1 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'ChangeDataFile' , 'strFilepath' , ), 1610743821, (1610743821, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'CompareDataFile' , 'strFilepath' , ), 1610743822, (1610743822, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
]

IModelCollection_vtables_dispatch_ = 1
IModelCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IModelDatabase_vtables_dispatch_ = 1
IModelDatabase_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'DataItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ExpandAll' , ), 1610743811, (1610743811, (), [ ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'ExpandItem' , 'varDatabaseItem' , ), 1610743812, (1610743812, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'RemoveDatabaseItem' , 'varItem' , ), 1610743813, (1610743813, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid' , 'varItem' , ), 1610743814, (1610743814, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid_2' , 'varItems' , ), 1610743815, (1610743815, (), [ (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid_3' , 'varItem' , 'bForceOpen' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , 
			 (11, 1, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ActivateWindow' , 'varItem' , ), 1610743817, (1610743817, (), [ (9, 1, None, "IID('{6F99EEE7-09F6-4708-8179-6DEA5376493F}')") , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'UpdateDatabaseItemCollection' , ), 1610743818, (1610743818, (), [ ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
]

IOperation_vtables_dispatch_ = 1
IOperation_vtables_ = [
	(( 'ParentControl' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'UpdateView' , ), 1610743809, (1610743809, (), [ ], 1 , 1 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
]

IOutput_vtables_dispatch_ = 1
IOutput_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'OutputMessages' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (24585, 10, None, "IID('{BD9429A4-0453-4C97-8808-C67749DCB02A}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'WriteError' , 'strMessage' , 'strTargetSite' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , 
			 (8, 49, "''", None) , ], 1 , 1 , 4 , 0 , 80 , (3, 32, None, None) , 0 , )),
	(( 'WriteWarning' , 'strMessage' , 'strTargetSite' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , 
			 (8, 49, "''", None) , ], 1 , 1 , 4 , 0 , 88 , (3, 32, None, None) , 0 , )),
	(( 'WriteInfo' , 'strMessage' , 'strTargetSite' , ), 1610743813, (1610743813, (), [ (8, 1, None, None) , 
			 (8, 49, "''", None) , ], 1 , 1 , 4 , 0 , 96 , (3, 32, None, None) , 0 , )),
	(( 'WriteLine' , 'enMessageType' , 'strMessage' , 'strTargetSite' , ), 1610743814, (1610743814, (), [ 
			 (3, 1, None, "IID('{9BAD78DA-C0B0-3BE4-A134-CC7BFDF4E0F6}')") , (8, 1, None, None) , (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'WriteLineAsync' , 'enMessageType' , 'strMessage' , 'strTargetSite' , ), 1610743815, (1610743815, (), [ 
			 (3, 1, None, "IID('{9BAD78DA-C0B0-3BE4-A134-CC7BFDF4E0F6}')") , (8, 1, None, None) , (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'GetLastMessage' , 'pRetVal' , ), 1610743816, (1610743816, (), [ (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageError' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageError' , 'pRetVal' , ), 1610743817, (1610743817, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageWarning' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageWarning' , 'pRetVal' , ), 1610743819, (1610743819, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageInfo' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'FilterMessageInfo' , 'pRetVal' , ), 1610743821, (1610743821, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'ClearMessage' , ), 1610743823, (1610743823, (), [ ], 1 , 1 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'WriteLog' , 'strMessage' , ), 1610743824, (1610743824, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'WriteLogAsync' , 'strMessage' , ), 1610743825, (1610743825, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'LogLineCount' , 'pRetVal' , ), 1610743826, (1610743826, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'GetLastLog' , 'pRetVal' , ), 1610743827, (1610743827, (), [ (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'GetLog' , 'iIndex' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (3, 1, None, None) , 
			 (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'GetAllLog' , 'pRetVal' , ), 1610743829, (1610743829, (), [ (16392, 10, None, None) , ], 1 , 1 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
	(( 'ActiveMessageTab' , ), 1610743830, (1610743830, (), [ ], 1 , 1 , 4 , 0 , 232 , (3, 0, None, None) , 0 , )),
	(( 'ActiveLogTab' , ), 1610743831, (1610743831, (), [ ], 1 , 1 , 4 , 0 , 240 , (3, 0, None, None) , 0 , )),
]

IOutputMessage_vtables_dispatch_ = 1
IOutputMessage_vtables_ = [
	(( 'MessageType' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, "IID('{9BAD78DA-C0B0-3BE4-A134-CC7BFDF4E0F6}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Description' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'TargetSite' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IPlot_vtables_dispatch_ = 1
IPlot_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Chart' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Plot' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16393, 10, None, "IID('{02444C62-D19B-4934-9572-E6677E061882}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'GetXAxis' , 'strUnit' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'GetYAxis' , 'strUnit' , 'pRetVal' , ), 1610743813, (1610743813, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'CreateSeriesWithAxis' , 'strSeriesName' , 'arrXValue' , 'arrYValue' , 'varXAxis' , 
			 'varYAxis' , 'bUseUnitLegend' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , 
			 (8197, 1, None, None) , (8197, 1, None, None) , (9, 1, None, "IID('{2A620232-B413-4059-9E81-29A2CCA9EFEF}')") , (9, 1, None, "IID('{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}')") , (11, 49, 'True', None) , 
			 (16393, 10, None, "IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')") , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'CreateSeries' , 'strSeriesName' , 'arrXValue' , 'arrYValue' , 'strXAxisUnit' , 
			 'strYAxisUnit' , 'pRetVal' , ), 1610743815, (1610743815, (), [ (8, 1, None, None) , (8197, 1, None, None) , 
			 (8197, 1, None, None) , (8, 1, None, None) , (8, 1, None, None) , (16393, 10, None, "IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')") , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SaveSetting' , 'strFilepath' , ), 1610743816, (1610743816, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'ApplySetting' , 'strFilepath' , ), 1610743817, (1610743817, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'ResetAllSettings' , ), 1610743818, (1610743818, (), [ ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid' , 'varEntity' , 'bForceOpen' , ), 1610743819, (1610743819, (), [ (9, 1, None, "IID('{E0C292B7-592C-4F26-B935-578E8229E9E7}')") , 
			 (11, 1, None, None) , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'Fit' , ), 1610743820, (1610743820, (), [ ], 1 , 1 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'UpdateHeader' , ), 1610743821, (1610743821, (), [ ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ExportImage' , 'strFilepath' , ), 1610743822, (1610743822, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
	(( 'DeleteSeries' , 'varSeries' , ), 1610743823, (1610743823, (), [ (9, 1, None, "IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')") , ], 1 , 1 , 4 , 0 , 176 , (3, 0, None, None) , 0 , )),
	(( 'DeleteAll' , ), 1610743824, (1610743824, (), [ ], 1 , 1 , 4 , 0 , 184 , (3, 0, None, None) , 0 , )),
	(( 'ExportSeriesDataToFile' , 'strFilepath' , 'arrChartSeries' , ), 1610743825, (1610743825, (), [ (8, 1, None, None) , 
			 (8204, 1, None, None) , ], 1 , 1 , 4 , 0 , 192 , (3, 0, None, None) , 0 , )),
	(( 'CreateTextAnnotation' , 'dXValue' , 'dYValue' , 'pRetVal' , ), 1610743826, (1610743826, (), [ 
			 (5, 1, None, None) , (5, 1, None, None) , (16393, 10, None, "IID('{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}')") , ], 1 , 1 , 4 , 0 , 200 , (3, 0, None, None) , 0 , )),
	(( 'CreateLineAnnotation' , 'arrStartPoint' , 'arrEndPoint' , 'pRetVal' , ), 1610743827, (1610743827, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (16393, 10, None, "IID('{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}')") , ], 1 , 1 , 4 , 0 , 208 , (3, 0, None, None) , 0 , )),
	(( 'CreateVerticalLineAnnotation' , 'dXValue' , 'pRetVal' , ), 1610743828, (1610743828, (), [ (5, 1, None, None) , 
			 (16393, 10, None, "IID('{BD40CFBC-C472-3CAD-B809-1B8301479DE2}')") , ], 1 , 1 , 4 , 0 , 216 , (3, 0, None, None) , 0 , )),
	(( 'CreateArrowAnnotation' , 'arrStartPoint' , 'arrEndPoint' , 'pRetVal' , ), 1610743829, (1610743829, (), [ 
			 (8197, 1, None, None) , (8197, 1, None, None) , (16393, 10, None, "IID('{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}')") , ], 1 , 1 , 4 , 0 , 224 , (3, 0, None, None) , 0 , )),
]

IPlot3D_vtables_dispatch_ = 1
IPlot3D_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Plot3D' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Chart3D' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16393, 10, None, "IID('{919C04CC-90E5-409E-85F3-3256F29E6247}')") , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'UpdateHeader' , ), 1610743812, (1610743812, (), [ ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'CreatePointLineSeries3D' , 'strLegend' , 'arrXValue' , 'arrYValue' , 'arrZValues' , 
			 ), 1610743813, (1610743813, (), [ (8, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'CreatePointLineSeries3D_2' , 'strLegend' , 'varXInfo' , 'varYInfo' , 'varZInfo' , 
			 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , (9, 1, None, "IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')") , (9, 1, None, "IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')") , 
			 (9, 1, None, "IID('{A52D09DE-44DC-32AF-8AED-55A7F571791A}')") , (16393, 10, None, "IID('{26823D92-8950-47F5-BE7F-E27509032204}')") , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'CreateSurfaceMeshDataSeries' , 'strLegend' , 'arrXSteppingValue' , 'arrZSteppingValue' , 'arrMeshGridDataValue' , 
			 ), 1610743815, (1610743815, (), [ (8, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , (8197, 1, None, None) , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'DeleteSeries' , 'varChartSeries' , ), 1610743816, (1610743816, (), [ (9, 1, None, "IID('{26823D92-8950-47F5-BE7F-E27509032204}')") , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
	(( 'DeleteAll' , ), 1610743817, (1610743817, (), [ ], 1 , 1 , 4 , 0 , 128 , (3, 0, None, None) , 0 , )),
	(( 'Fit' , ), 1610743818, (1610743818, (), [ ], 1 , 1 , 4 , 0 , 136 , (3, 0, None, None) , 0 , )),
	(( 'ExportImage' , 'strFilepath' , ), 1610743819, (1610743819, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 144 , (3, 0, None, None) , 0 , )),
	(( 'OpenPropertyGrid' , 'varEntity' , 'bForceOpen' , ), 1610743820, (1610743820, (), [ (9, 1, None, "IID('{E0C292B7-592C-4F26-B935-578E8229E9E7}')") , 
			 (11, 1, None, None) , ], 1 , 1 , 4 , 0 , 152 , (3, 0, None, None) , 0 , )),
	(( 'SaveSetting' , 'strFilepath' , ), 1610743821, (1610743821, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 160 , (3, 0, None, None) , 0 , )),
	(( 'ResetAllSettings' , ), 1610743822, (1610743822, (), [ ], 1 , 1 , 4 , 0 , 168 , (3, 0, None, None) , 0 , )),
]

IPoint_vtables_dispatch_ = 1
IPoint_vtables_ = [
	(( 'X' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Y' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ToString' , 'pRetVal' , ), 0, (0, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IPostApplication_vtables_dispatch_ = 1
IPostApplication_vtables_ = [
	(( 'PostMainWindow' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
]

IPostMainWindow_vtables_dispatch_ = 1
IPostMainWindow_vtables_ = [
	(( 'Identify' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Identify' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (3, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'MainDocument' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'ApplicationPath' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbon_vtables_dispatch_ = 1
IRibbon_vtables_ = [
	(( 'UpdateView' , ), 1610743808, (1610743808, (), [ ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'ParentControl' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{AAC98348-2902-49EA-BDBA-658775DB336E}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'RibbonView' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'CreateTab' , 'strHeader' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'CreateGroup' , 'varTab' , 'strHeader' , 'pRetVal' , ), 1610743812, (1610743812, (), [ 
			 (9, 1, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , (8, 1, None, None) , (16393, 10, None, "IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'CreateButton' , 'varGroup' , 'strHeader' , 'pRetVal' , ), 1610743813, (1610743813, (), [ 
			 (9, 1, None, "IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')") , (8, 1, None, None) , (16393, 10, None, "IID('{744BA570-CF70-4112-81E7-94C995D8B794}')") , ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'GetEntity' , 'strHeader' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'SetTooltip' , 'strHeader' , 'strDescription' , 'varRibbonItem' , ), 1610743815, (1610743815, (), [ 
			 (8, 1, None, None) , (8, 1, None, None) , (9, 1, None, "IID('{70A3F82F-9CB6-4E52-9B6A-A156BA8638F8}')") , ], 1 , 1 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
]

IRibbonEntity_vtables_dispatch_ = 1
IRibbonEntity_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
]

IRibbonGroup_vtables_dispatch_ = 1
IRibbonGroup_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'RemoveEntity' , 'Header' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'GetEntity' , 'strHeader' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{744BA570-CF70-4112-81E7-94C995D8B794}')") , ], 1 , 1 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
]

IRibbonGroupCollection_vtables_dispatch_ = 1
IRibbonGroupCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbonItem_vtables_dispatch_ = 1
IRibbonItem_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'SetCommand' , 'varCommand' , 'varParameter' , ), 1610743810, (1610743810, (), [ (9, 1, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , 
			 (12, 1, None, None) , ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'SetScriptCommand' , 'strScript' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbonItemButton_vtables_dispatch_ = 1
IRibbonItemButton_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'SetCommand' , 'varCommand' , 'varParameter' , ), 1610743810, (1610743810, (), [ (9, 1, None, "IID('{90C7864A-3C47-4CC4-A222-09DB17E49E0A}')") , 
			 (12, 1, None, None) , ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'SetScriptCommand' , 'strScript' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Size' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16387, 10, None, "IID('{39E394EC-0CFF-3999-B924-D473A918632F}')") , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Size' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (3, 1, None, "IID('{39E394EC-0CFF-3999-B924-D473A918632F}')") , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'SetImage' , 'strFilepath' , ), 1610743814, (1610743814, (), [ (8, 1, None, None) , ], 1 , 1 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
]

IRibbonItemCollection_vtables_dispatch_ = 1
IRibbonItemCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbonTab_vtables_dispatch_ = 1
IRibbonTab_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{2A4B5914-A9AD-45D8-9A93-E0A82336455D}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'GetEntity' , 'strHeader' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{05021BB3-BD7E-4402-B4F2-1F98B95E5336}')") , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbonTabCollection_vtables_dispatch_ = 1
IRibbonTabCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IRibbonView_vtables_dispatch_ = 1
IRibbonView_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ItemCollection' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16393, 10, None, "IID('{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}')") , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'GetEntity' , 'strHeader' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (8, 1, None, None) , 
			 (16393, 10, None, "IID('{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}')") , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

ISeries3DCollection_vtables_dispatch_ = 1
ISeries3DCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{26823D92-8950-47F5-BE7F-E27509032204}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{26823D92-8950-47F5-BE7F-E27509032204}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

ISeriesCollection_vtables_dispatch_ = 1
ISeriesCollection_vtables_ = [
	(( 'GetEnumerator' , 'pRetVal' , ), -4, (-4, (), [ (16397, 10, None, None) , ], 1 , 1 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (16393, 10, None, "IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Item' , 'iPosition' , 'pRetVal' , ), 0, (0, (), [ (3, 1, None, None) , 
			 (9, 1, None, "IID('{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}')") , ], 1 , 8 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Count' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16387, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

IThemeManager_vtables_dispatch_ = 1
IThemeManager_vtables_ = [
	(( 'CurrentTheme' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16387, 10, None, "IID('{32ABD87B-E6FB-3474-A716-C321EDC7E202}')") , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'CurrentTheme' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (3, 1, None, "IID('{32ABD87B-E6FB-3474-A716-C321EDC7E202}')") , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
]

IThickness_vtables_dispatch_ = 1
IThickness_vtables_ = [
	(( 'Top' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Top' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Bottom' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'Bottom' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'Left' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Left' , 'pRetVal' , ), 1610743812, (1610743812, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'Right' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16389, 10, None, None) , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
	(( 'Right' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (5, 1, None, None) , ], 1 , 4 , 4 , 0 , 112 , (3, 0, None, None) , 0 , )),
	(( 'SetAll' , 'dValue' , ), 1610743816, (1610743816, (), [ (5, 1, None, None) , ], 1 , 1 , 4 , 0 , 120 , (3, 0, None, None) , 0 , )),
]

IViewModel_vtables_dispatch_ = 1
IViewModel_vtables_ = [
	(( 'ParentControl' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16396, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Operation' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (16393, 10, None, "IID('{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}')") , ], 1 , 2 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'Update' , ), 1610743810, (1610743810, (), [ ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
]

IWindowPane_vtables_dispatch_ = 1
IWindowPane_vtables_ = [
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Header' , 'pRetVal' , ), 1610743808, (1610743808, (), [ (8, 1, None, None) , ], 1 , 4 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'ShowHeader' , 'bShow' , ), 1610743810, (1610743810, (), [ (11, 1, None, None) , ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'IsHidden' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16395, 10, None, None) , ], 1 , 2 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
	(( 'IsHidden' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (11, 1, None, None) , ], 1 , 4 , 4 , 0 , 88 , (3, 0, None, None) , 0 , )),
	(( 'Activate' , ), 1610743813, (1610743813, (), [ ], 1 , 1 , 4 , 0 , 96 , (3, 0, None, None) , 0 , )),
	(( 'PaneType' , 'pRetVal' , ), 1610743814, (1610743814, (), [ (16387, 10, None, "IID('{56F664E1-712E-325B-B9F2-15A4E19FF7EC}')") , ], 1 , 2 , 4 , 0 , 104 , (3, 0, None, None) , 0 , )),
]

_LocalizedDescriptionAttribute_vtables_dispatch_ = 1
_LocalizedDescriptionAttribute_vtables_ = [
]

_Object_vtables_dispatch_ = 1
_Object_vtables_ = [
	(( 'ToString' , 'pRetVal' , ), 0, (0, (), [ (16392, 10, None, None) , ], 1 , 2 , 4 , 0 , 56 , (3, 0, None, None) , 0 , )),
	(( 'Equals' , 'obj' , 'pRetVal' , ), 1610743809, (1610743809, (), [ (12, 1, None, None) , 
			 (16395, 10, None, None) , ], 1 , 1 , 4 , 0 , 64 , (3, 0, None, None) , 0 , )),
	(( 'GetHashCode' , 'pRetVal' , ), 1610743810, (1610743810, (), [ (16387, 10, None, None) , ], 1 , 1 , 4 , 0 , 72 , (3, 0, None, None) , 0 , )),
	(( 'GetType' , 'pRetVal' , ), 1610743811, (1610743811, (), [ (16397, 10, None, "IID('{BCA8B44D-AAD6-3A86-8AB7-03349F4F2DA2}')") , ], 1 , 1 , 4 , 0 , 80 , (3, 0, None, None) , 0 , )),
]

_SeriesValueInfo_vtables_dispatch_ = 1
_SeriesValueInfo_vtables_ = [
]

RecordMap = {
}

CLSIDToClassMap = {
	'{3D66119C-DB92-488B-ABDB-FAE557B7F672}' : IPostMainWindow,
	'{20A0A71D-A66D-42C8-A4FE-E6DDFAC585AA}' : IPostApplication,
	'{926F0F68-9177-47F4-B0C3-788CBD50A011}' : IApplicationOptionsExportSeriesData,
	'{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}' : IApplicationOptionsChart,
	'{17603DE0-C898-401A-A841-F9CB908F5525}' : IApplicationOptionsDataEditor,
	'{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}' : IAnalysisFunctions,
	'{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}' : IApplicationConfig,
	'{A3B76163-68FC-447A-99F3-DF40B08DFE1C}' : IApplicationOptions,
	'{BD9429A4-0453-4C97-8808-C67749DCB02A}' : IOutputMessage,
	'{016C03D7-5933-4AE7-851D-87B1006287CA}' : IThemeManager,
	'{5812880C-C727-4800-8762-E3EA5CFD8797}' : IAnimation,
	'{2C300492-3E47-49C4-9B4A-CF44F434A0F5}' : ICampbellDiagram,
	'{EB36D341-662E-4766-8874-AA7599565479}' : IDatabase,
	'{39230EEA-3374-400E-9489-2A7AEBB2E530}' : IDraw3DDatabase,
	'{979D321D-21DC-43D0-83BF-E1E7B75384F1}' : IDataFileDatabase,
	'{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}' : IMainDocument,
	'{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}' : IModelDatabase,
	'{9D70138C-0DCA-4B63-951F-BCECB67522AE}' : IModel,
	'{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}' : IOutput,
	'{B7613ED0-4431-4A2B-829D-86D5A07B9C99}' : IPlot3D,
	'{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}' : IPlot,
	'{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}' : IRibbon,
	'{744BA570-CF70-4112-81E7-94C995D8B794}' : IRibbonItemButton,
	'{70A3F82F-9CB6-4E52-9B6A-A156BA8638F8}' : IRibbonEntity,
	'{05021BB3-BD7E-4402-B4F2-1F98B95E5336}' : IRibbonGroup,
	'{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}' : IRibbonItem,
	'{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}' : IRibbonTab,
	'{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}' : IRibbonView,
	'{5841003A-8AD8-4788-B5E0-B979B7EEA37F}' : IMainViewModel,
	'{65074F7F-63C0-304E-AF0A-D51741CB4A8D}' : _Object,
	'{51329F9B-A9DF-4F3A-8454-6B134A36D4AD}' : PostApplication,
	'{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}' : IAxisXCollection,
	'{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}' : IAxisYCollection,
	'{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}' : ISeriesCollection,
	'{8EE0A50B-A095-4196-B3A2-189A36105476}' : ISeries3DCollection,
	'{F30A1F02-5258-4FA0-A579-16829304270F}' : IModelCollection,
	'{05E42E73-072B-4DCB-9FFE-5412165947AF}' : IEntityCollection,
	'{266467B4-9F50-45FF-BE2D-ADB933BE70DE}' : IDocumentCollection,
	'{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}' : IDatabaseItemCollection,
	'{2A4B5914-A9AD-45D8-9A93-E0A82336455D}' : IRibbonGroupCollection,
	'{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}' : IRibbonItemCollection,
	'{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}' : IRibbonTabCollection,
	'{B89390C5-E030-404E-9B93-B9B2EB12D6A2}' : IChartAnnotationCollection,
	'{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}' : IThickness,
	'{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}' : IPoint,
	'{5CD358A2-1CC0-46BF-B605-C48C52949E59}' : IColor,
	'{90C7864A-3C47-4CC4-A222-09DB17E49E0A}' : ICommand,
	'{6F928B9F-DB66-471E-A357-3FFF3222D73D}' : IChartModifier3DCameraPan,
	'{493AFDB2-652C-389F-980B-034FAF450513}' : IChartModifier3DDragPan,
	'{B9020FC8-4D93-4784-85AB-F806DEF45984}' : IChartModifier3DDragZoom,
	'{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}' : IChartModifier3DLegend,
	'{A31648C6-27E6-484C-9DFC-237F19FC855B}' : IChartModifier3DMouseWheelZoom,
	'{0683DAA1-7363-4E57-86B8-B1592C9E2BFD}' : IChartModifier3DOrbit,
	'{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}' : IChartModifier3DSectionViewer,
	'{61409795-1BB1-4C04-B851-10B44F02F5A5}' : IChartModifier3DTooltip,
	'{80F5408B-1C65-4C5D-A014-5B2B34D970A9}' : IChartModifier3DZoomExtents,
	'{279362D2-44D2-4A28-A600-D889E108D5D8}' : IChart3DSliceViewer,
	'{919C04CC-90E5-409E-85F3-3256F29E6247}' : IChart3D,
	'{45B05150-78E3-4188-AA31-CC0DE518FF1F}' : IChartAxisZ3D,
	'{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}' : IChartAxisY3D,
	'{726C8F68-8A81-4F1F-8D5E-3249898D875B}' : IChartAxisX3D,
	'{05AAE55E-A228-4690-929A-CC36280CB6F4}' : IChartAxis3D,
	'{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}' : IChart3DCampbellProperty,
	'{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}' : IChart3DContourLegend,
	'{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}' : IChart3DStyleMajorGridLine,
	'{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}' : IChart3DStyleMinorGridLine,
	'{7470748B-68F6-3047-8F66-B114A4A9C26C}' : IChart3DStyleGridLine,
	'{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}' : IChart3DStyleTickLabel,
	'{B7273930-1505-42EA-BE86-F7A752B288B1}' : IChart3DStyleTickLine,
	'{BB3F7878-1B92-4B36-B688-31107524DB25}' : IChart3DStyleTitle,
	'{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}' : IChartPointMarker3D,
	'{26823D92-8950-47F5-BE7F-E27509032204}' : IChartSeries3D,
	'{4451598E-1CF9-495B-8225-3A6D5F12D4A4}' : IChartSeriesPointLine3D,
	'{E7CBEAD9-7363-47CB-A31A-30B357E4DE00}' : IChartSeriesSurfaceMesh3D,
	'{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}' : IEntityPlot3D,
	'{19FB473A-3BE9-49D5-96D7-62F8496706B0}' : ILegendColor,
	'{D6153141-938E-4E8A-B6E2-ED8EFE62E091}' : IChartModifierLegend,
	'{C79751D8-4907-4B9E-8169-311B17858169}' : IChartModifierSeriesInfo,
	'{7440FFE1-9009-44ED-90D1-6B7A9143AB66}' : IChartModifierTimeLine,
	'{FD63AE8C-75EF-437B-AB41-0654C94D7F03}' : IChartModifierTooltip,
	'{E3CB556E-651D-377D-A93F-548466BD073C}' : _LocalizedDescriptionAttribute,
	'{135595B2-CAC1-3B08-9EB7-9AE2C8504622}' : LocalizedDescriptionAttribute,
	'{49D0E38C-E5C3-4BFF-9478-E033FD4A4B53}' : IAnimationFrame,
	'{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}' : IChart,
	'{1A536495-EBB2-3064-8F82-965701F9C9E6}' : IChartAnnotation,
	'{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}' : IChartAnnotationArrow,
	'{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}' : IChartAnnotationLine,
	'{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}' : IChartAnnotationText,
	'{BD40CFBC-C472-3CAD-B809-1B8301479DE2}' : IChartAnnotationVerticalLine,
	'{5A2D9BD6-130C-46BA-8682-0E7013235AEF}' : IChartAxisBase,
	'{2A620232-B413-4059-9E81-29A2CCA9EFEF}' : IChartAxisX,
	'{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}' : IChartAxisY,
	'{691044DE-CC8C-4822-8E2F-736529CFC5A4}' : IChartBase,
	'{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}' : IChartPalette,
	'{A57DEE8B-3147-4E83-A188-65C5A265F0D5}' : IChartPointMarker,
	'{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}' : IChartSeries,
	'{47706DC8-0B8C-451D-8960-49A877CB0B3D}' : IChartStyleGridLine,
	'{DE759D88-66E1-4764-86B0-96D98197A346}' : IChartStyleMajorGridLine,
	'{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}' : IChartStyleMinorGridLine,
	'{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}' : IChartStyleGridLinePanel,
	'{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}' : IChartStyleTickLabel,
	'{96B447B4-B377-40F5-A14F-4334FE99C903}' : IChartStyleTickLine,
	'{0425D327-6C6A-4081-8DBB-337984399370}' : IChartStyleMajorTickLine,
	'{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}' : IChartStyleMinorTickLine,
	'{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}' : IChartStyleAxisTitle,
	'{F779994A-D846-4F12-AE53-DD023F6973B9}' : IChartStyleTitle,
	'{496406A4-661D-4FA1-A778-FDA86C1C1DA4}' : IChartTimeLineAnnotationStyle,
	'{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}' : IDataComponent,
	'{E0C292B7-592C-4F26-B935-578E8229E9E7}' : IEntity,
	'{89E7C670-EDA4-4814-956B-C1B9B745B079}' : IEntityDocument,
	'{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}' : IEntityManager,
	'{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}' : IEntityModel,
	'{02444C62-D19B-4934-9572-E6677E061882}' : IEntityPlot,
	'{A52D09DE-44DC-32AF-8AED-55A7F571791A}' : _SeriesValueInfo,
	'{1CF20174-B95E-4E02-B03A-9B2523451570}' : SeriesValueInfo,
	'{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}' : IOperation,
	'{AAC98348-2902-49EA-BDBA-658775DB336E}' : IControl,
	'{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}' : IViewModel,
	'{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}' : IWindowPane,
	'{6F99EEE7-09F6-4708-8179-6DEA5376493F}' : IDatabaseItem,
	'{51E9CB85-08CD-49C0-8374-B22EB0236624}' : IDataFileDatabaseItem,
}
CLSIDToPackageMap = {}
win32com.client.CLSIDToClass.RegisterCLSIDsFromDict( CLSIDToClassMap )
VTablesToPackageMap = {}
VTablesToClassMap = {
	'{3D66119C-DB92-488B-ABDB-FAE557B7F672}' : 'IPostMainWindow',
	'{20A0A71D-A66D-42C8-A4FE-E6DDFAC585AA}' : 'IPostApplication',
	'{926F0F68-9177-47F4-B0C3-788CBD50A011}' : 'IApplicationOptionsExportSeriesData',
	'{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}' : 'IApplicationOptionsChart',
	'{17603DE0-C898-401A-A841-F9CB908F5525}' : 'IApplicationOptionsDataEditor',
	'{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}' : 'IAnalysisFunctions',
	'{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}' : 'IApplicationConfig',
	'{A3B76163-68FC-447A-99F3-DF40B08DFE1C}' : 'IApplicationOptions',
	'{BD9429A4-0453-4C97-8808-C67749DCB02A}' : 'IOutputMessage',
	'{016C03D7-5933-4AE7-851D-87B1006287CA}' : 'IThemeManager',
	'{5812880C-C727-4800-8762-E3EA5CFD8797}' : 'IAnimation',
	'{2C300492-3E47-49C4-9B4A-CF44F434A0F5}' : 'ICampbellDiagram',
	'{EB36D341-662E-4766-8874-AA7599565479}' : 'IDatabase',
	'{39230EEA-3374-400E-9489-2A7AEBB2E530}' : 'IDraw3DDatabase',
	'{979D321D-21DC-43D0-83BF-E1E7B75384F1}' : 'IDataFileDatabase',
	'{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}' : 'IMainDocument',
	'{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}' : 'IModelDatabase',
	'{9D70138C-0DCA-4B63-951F-BCECB67522AE}' : 'IModel',
	'{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}' : 'IOutput',
	'{B7613ED0-4431-4A2B-829D-86D5A07B9C99}' : 'IPlot3D',
	'{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}' : 'IPlot',
	'{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}' : 'IRibbon',
	'{744BA570-CF70-4112-81E7-94C995D8B794}' : 'IRibbonItemButton',
	'{70A3F82F-9CB6-4E52-9B6A-A156BA8638F8}' : 'IRibbonEntity',
	'{05021BB3-BD7E-4402-B4F2-1F98B95E5336}' : 'IRibbonGroup',
	'{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}' : 'IRibbonItem',
	'{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}' : 'IRibbonTab',
	'{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}' : 'IRibbonView',
	'{5841003A-8AD8-4788-B5E0-B979B7EEA37F}' : 'IMainViewModel',
	'{65074F7F-63C0-304E-AF0A-D51741CB4A8D}' : '_Object',
	'{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}' : 'IAxisXCollection',
	'{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}' : 'IAxisYCollection',
	'{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}' : 'ISeriesCollection',
	'{8EE0A50B-A095-4196-B3A2-189A36105476}' : 'ISeries3DCollection',
	'{F30A1F02-5258-4FA0-A579-16829304270F}' : 'IModelCollection',
	'{05E42E73-072B-4DCB-9FFE-5412165947AF}' : 'IEntityCollection',
	'{266467B4-9F50-45FF-BE2D-ADB933BE70DE}' : 'IDocumentCollection',
	'{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}' : 'IDatabaseItemCollection',
	'{2A4B5914-A9AD-45D8-9A93-E0A82336455D}' : 'IRibbonGroupCollection',
	'{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}' : 'IRibbonItemCollection',
	'{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}' : 'IRibbonTabCollection',
	'{B89390C5-E030-404E-9B93-B9B2EB12D6A2}' : 'IChartAnnotationCollection',
	'{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}' : 'IThickness',
	'{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}' : 'IPoint',
	'{5CD358A2-1CC0-46BF-B605-C48C52949E59}' : 'IColor',
	'{90C7864A-3C47-4CC4-A222-09DB17E49E0A}' : 'ICommand',
	'{6F928B9F-DB66-471E-A357-3FFF3222D73D}' : 'IChartModifier3DCameraPan',
	'{493AFDB2-652C-389F-980B-034FAF450513}' : 'IChartModifier3DDragPan',
	'{B9020FC8-4D93-4784-85AB-F806DEF45984}' : 'IChartModifier3DDragZoom',
	'{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}' : 'IChartModifier3DLegend',
	'{A31648C6-27E6-484C-9DFC-237F19FC855B}' : 'IChartModifier3DMouseWheelZoom',
	'{0683DAA1-7363-4E57-86B8-B1592C9E2BFD}' : 'IChartModifier3DOrbit',
	'{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}' : 'IChartModifier3DSectionViewer',
	'{61409795-1BB1-4C04-B851-10B44F02F5A5}' : 'IChartModifier3DTooltip',
	'{80F5408B-1C65-4C5D-A014-5B2B34D970A9}' : 'IChartModifier3DZoomExtents',
	'{279362D2-44D2-4A28-A600-D889E108D5D8}' : 'IChart3DSliceViewer',
	'{919C04CC-90E5-409E-85F3-3256F29E6247}' : 'IChart3D',
	'{45B05150-78E3-4188-AA31-CC0DE518FF1F}' : 'IChartAxisZ3D',
	'{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}' : 'IChartAxisY3D',
	'{726C8F68-8A81-4F1F-8D5E-3249898D875B}' : 'IChartAxisX3D',
	'{05AAE55E-A228-4690-929A-CC36280CB6F4}' : 'IChartAxis3D',
	'{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}' : 'IChart3DCampbellProperty',
	'{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}' : 'IChart3DContourLegend',
	'{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}' : 'IChart3DStyleMajorGridLine',
	'{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}' : 'IChart3DStyleMinorGridLine',
	'{7470748B-68F6-3047-8F66-B114A4A9C26C}' : 'IChart3DStyleGridLine',
	'{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}' : 'IChart3DStyleTickLabel',
	'{B7273930-1505-42EA-BE86-F7A752B288B1}' : 'IChart3DStyleTickLine',
	'{BB3F7878-1B92-4B36-B688-31107524DB25}' : 'IChart3DStyleTitle',
	'{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}' : 'IChartPointMarker3D',
	'{26823D92-8950-47F5-BE7F-E27509032204}' : 'IChartSeries3D',
	'{4451598E-1CF9-495B-8225-3A6D5F12D4A4}' : 'IChartSeriesPointLine3D',
	'{E7CBEAD9-7363-47CB-A31A-30B357E4DE00}' : 'IChartSeriesSurfaceMesh3D',
	'{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}' : 'IEntityPlot3D',
	'{19FB473A-3BE9-49D5-96D7-62F8496706B0}' : 'ILegendColor',
	'{D6153141-938E-4E8A-B6E2-ED8EFE62E091}' : 'IChartModifierLegend',
	'{C79751D8-4907-4B9E-8169-311B17858169}' : 'IChartModifierSeriesInfo',
	'{7440FFE1-9009-44ED-90D1-6B7A9143AB66}' : 'IChartModifierTimeLine',
	'{FD63AE8C-75EF-437B-AB41-0654C94D7F03}' : 'IChartModifierTooltip',
	'{E3CB556E-651D-377D-A93F-548466BD073C}' : '_LocalizedDescriptionAttribute',
	'{49D0E38C-E5C3-4BFF-9478-E033FD4A4B53}' : 'IAnimationFrame',
	'{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}' : 'IChart',
	'{1A536495-EBB2-3064-8F82-965701F9C9E6}' : 'IChartAnnotation',
	'{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}' : 'IChartAnnotationArrow',
	'{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}' : 'IChartAnnotationLine',
	'{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}' : 'IChartAnnotationText',
	'{BD40CFBC-C472-3CAD-B809-1B8301479DE2}' : 'IChartAnnotationVerticalLine',
	'{5A2D9BD6-130C-46BA-8682-0E7013235AEF}' : 'IChartAxisBase',
	'{2A620232-B413-4059-9E81-29A2CCA9EFEF}' : 'IChartAxisX',
	'{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}' : 'IChartAxisY',
	'{691044DE-CC8C-4822-8E2F-736529CFC5A4}' : 'IChartBase',
	'{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}' : 'IChartPalette',
	'{A57DEE8B-3147-4E83-A188-65C5A265F0D5}' : 'IChartPointMarker',
	'{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}' : 'IChartSeries',
	'{47706DC8-0B8C-451D-8960-49A877CB0B3D}' : 'IChartStyleGridLine',
	'{DE759D88-66E1-4764-86B0-96D98197A346}' : 'IChartStyleMajorGridLine',
	'{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}' : 'IChartStyleMinorGridLine',
	'{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}' : 'IChartStyleGridLinePanel',
	'{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}' : 'IChartStyleTickLabel',
	'{96B447B4-B377-40F5-A14F-4334FE99C903}' : 'IChartStyleTickLine',
	'{0425D327-6C6A-4081-8DBB-337984399370}' : 'IChartStyleMajorTickLine',
	'{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}' : 'IChartStyleMinorTickLine',
	'{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}' : 'IChartStyleAxisTitle',
	'{F779994A-D846-4F12-AE53-DD023F6973B9}' : 'IChartStyleTitle',
	'{496406A4-661D-4FA1-A778-FDA86C1C1DA4}' : 'IChartTimeLineAnnotationStyle',
	'{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}' : 'IDataComponent',
	'{E0C292B7-592C-4F26-B935-578E8229E9E7}' : 'IEntity',
	'{89E7C670-EDA4-4814-956B-C1B9B745B079}' : 'IEntityDocument',
	'{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}' : 'IEntityManager',
	'{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}' : 'IEntityModel',
	'{02444C62-D19B-4934-9572-E6677E061882}' : 'IEntityPlot',
	'{A52D09DE-44DC-32AF-8AED-55A7F571791A}' : '_SeriesValueInfo',
	'{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}' : 'IOperation',
	'{AAC98348-2902-49EA-BDBA-658775DB336E}' : 'IControl',
	'{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}' : 'IViewModel',
	'{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}' : 'IWindowPane',
	'{6F99EEE7-09F6-4708-8179-6DEA5376493F}' : 'IDatabaseItem',
	'{51E9CB85-08CD-49C0-8374-B22EB0236624}' : 'IDataFileDatabaseItem',
}


NamesToIIDMap = {
	'IPostMainWindow' : '{3D66119C-DB92-488B-ABDB-FAE557B7F672}',
	'IPostApplication' : '{20A0A71D-A66D-42C8-A4FE-E6DDFAC585AA}',
	'IApplicationOptionsExportSeriesData' : '{926F0F68-9177-47F4-B0C3-788CBD50A011}',
	'IApplicationOptionsChart' : '{90D8961A-8F34-4B5D-8C38-02DEAF22ECC1}',
	'IApplicationOptionsDataEditor' : '{17603DE0-C898-401A-A841-F9CB908F5525}',
	'IAnalysisFunctions' : '{6A662309-D8B8-4F1D-9C09-CCAFF8BF10BD}',
	'IApplicationConfig' : '{73F68636-A03A-4BEB-BBA9-FFF279CDC7F2}',
	'IApplicationOptions' : '{A3B76163-68FC-447A-99F3-DF40B08DFE1C}',
	'IOutputMessage' : '{BD9429A4-0453-4C97-8808-C67749DCB02A}',
	'IThemeManager' : '{016C03D7-5933-4AE7-851D-87B1006287CA}',
	'IAnimation' : '{5812880C-C727-4800-8762-E3EA5CFD8797}',
	'ICampbellDiagram' : '{2C300492-3E47-49C4-9B4A-CF44F434A0F5}',
	'IDatabase' : '{EB36D341-662E-4766-8874-AA7599565479}',
	'IDraw3DDatabase' : '{39230EEA-3374-400E-9489-2A7AEBB2E530}',
	'IDataFileDatabase' : '{979D321D-21DC-43D0-83BF-E1E7B75384F1}',
	'IMainDocument' : '{9F360814-5FAD-4441-AD27-CDC9EDCBB76B}',
	'IModelDatabase' : '{06DDDC96-25DB-4EFE-8179-AC5ED6B8C2C9}',
	'IModel' : '{9D70138C-0DCA-4B63-951F-BCECB67522AE}',
	'IOutput' : '{CC99C747-A097-4BF2-9FE5-EB3C82C2B315}',
	'IPlot3D' : '{B7613ED0-4431-4A2B-829D-86D5A07B9C99}',
	'IPlot' : '{5795FF28-30F9-4430-9716-7BDDD1D2DBE0}',
	'IRibbon' : '{CCA4EFE4-E481-4802-8D20-2D02FBC83EBD}',
	'IRibbonItemButton' : '{744BA570-CF70-4112-81E7-94C995D8B794}',
	'IRibbonEntity' : '{70A3F82F-9CB6-4E52-9B6A-A156BA8638F8}',
	'IRibbonGroup' : '{05021BB3-BD7E-4402-B4F2-1F98B95E5336}',
	'IRibbonItem' : '{FD58AF2F-BAC3-4C2D-A695-5B70AAF46939}',
	'IRibbonTab' : '{9A1D6643-7CFE-4260-830A-1DBB153ED5EC}',
	'IRibbonView' : '{E40581BC-D8B1-4BE0-8AB5-822F52529BC9}',
	'IMainViewModel' : '{5841003A-8AD8-4788-B5E0-B979B7EEA37F}',
	'_Object' : '{65074F7F-63C0-304E-AF0A-D51741CB4A8D}',
	'IAxisXCollection' : '{7D56BCA5-44F2-4877-AEAE-6EAC83FC70E6}',
	'IAxisYCollection' : '{F0EEF561-2A8A-41BC-AFCE-CD8354E08559}',
	'ISeriesCollection' : '{6B389D90-E029-4A50-80D5-9A21C4DFDFFC}',
	'ISeries3DCollection' : '{8EE0A50B-A095-4196-B3A2-189A36105476}',
	'IModelCollection' : '{F30A1F02-5258-4FA0-A579-16829304270F}',
	'IEntityCollection' : '{05E42E73-072B-4DCB-9FFE-5412165947AF}',
	'IDocumentCollection' : '{266467B4-9F50-45FF-BE2D-ADB933BE70DE}',
	'IDatabaseItemCollection' : '{E3B0E9EB-5A5C-43C5-A7FB-CA1097579FAF}',
	'IRibbonGroupCollection' : '{2A4B5914-A9AD-45D8-9A93-E0A82336455D}',
	'IRibbonItemCollection' : '{06826E3C-DEE9-44CE-BCED-E8C8A8FD2158}',
	'IRibbonTabCollection' : '{1AEADB36-FB47-43D7-9255-9C3CD2C9D870}',
	'IChartAnnotationCollection' : '{B89390C5-E030-404E-9B93-B9B2EB12D6A2}',
	'IThickness' : '{C92F00FB-C7EE-407B-A1ED-C80AD296EB20}',
	'IPoint' : '{C5CEC8C0-6EAD-46C2-B94D-39832E69FA2C}',
	'IColor' : '{5CD358A2-1CC0-46BF-B605-C48C52949E59}',
	'ICommand' : '{90C7864A-3C47-4CC4-A222-09DB17E49E0A}',
	'IChartModifier3DCameraPan' : '{6F928B9F-DB66-471E-A357-3FFF3222D73D}',
	'IChartModifier3DDragPan' : '{493AFDB2-652C-389F-980B-034FAF450513}',
	'IChartModifier3DDragZoom' : '{B9020FC8-4D93-4784-85AB-F806DEF45984}',
	'IChartModifier3DLegend' : '{A5B870C2-5EE9-4A2C-A164-17193DBAA5A2}',
	'IChartModifier3DMouseWheelZoom' : '{A31648C6-27E6-484C-9DFC-237F19FC855B}',
	'IChartModifier3DOrbit' : '{0683DAA1-7363-4E57-86B8-B1592C9E2BFD}',
	'IChartModifier3DSectionViewer' : '{46DA3C1D-B6B0-4FFD-8BEF-83B56DA02E7E}',
	'IChartModifier3DTooltip' : '{61409795-1BB1-4C04-B851-10B44F02F5A5}',
	'IChartModifier3DZoomExtents' : '{80F5408B-1C65-4C5D-A014-5B2B34D970A9}',
	'IChart3DSliceViewer' : '{279362D2-44D2-4A28-A600-D889E108D5D8}',
	'IChart3D' : '{919C04CC-90E5-409E-85F3-3256F29E6247}',
	'IChartAxisZ3D' : '{45B05150-78E3-4188-AA31-CC0DE518FF1F}',
	'IChartAxisY3D' : '{A8DB29AE-0E02-4E4B-BD64-850FBE5A7B82}',
	'IChartAxisX3D' : '{726C8F68-8A81-4F1F-8D5E-3249898D875B}',
	'IChartAxis3D' : '{05AAE55E-A228-4690-929A-CC36280CB6F4}',
	'IChart3DCampbellProperty' : '{CBEA29CE-DEC3-4BE3-B643-482F44CB3170}',
	'IChart3DContourLegend' : '{CE5DF32B-3393-4AD1-9A82-563CCDCF261B}',
	'IChart3DStyleMajorGridLine' : '{F58603E9-2A54-49C1-B1CC-3C50AD1907FA}',
	'IChart3DStyleMinorGridLine' : '{DD54A59B-9639-35EC-9A5B-BFC56197BB4F}',
	'IChart3DStyleGridLine' : '{7470748B-68F6-3047-8F66-B114A4A9C26C}',
	'IChart3DStyleTickLabel' : '{43DB9B46-47E2-49D4-897F-9C7A28E0B8DD}',
	'IChart3DStyleTickLine' : '{B7273930-1505-42EA-BE86-F7A752B288B1}',
	'IChart3DStyleTitle' : '{BB3F7878-1B92-4B36-B688-31107524DB25}',
	'IChartPointMarker3D' : '{6E5915A8-94E0-4D95-BC23-89FD057EE1DD}',
	'IChartSeries3D' : '{26823D92-8950-47F5-BE7F-E27509032204}',
	'IChartSeriesPointLine3D' : '{4451598E-1CF9-495B-8225-3A6D5F12D4A4}',
	'IChartSeriesSurfaceMesh3D' : '{E7CBEAD9-7363-47CB-A31A-30B357E4DE00}',
	'IEntityPlot3D' : '{E3ABC223-D22D-4CFD-8961-45C2EC89EF70}',
	'ILegendColor' : '{19FB473A-3BE9-49D5-96D7-62F8496706B0}',
	'IChartModifierLegend' : '{D6153141-938E-4E8A-B6E2-ED8EFE62E091}',
	'IChartModifierSeriesInfo' : '{C79751D8-4907-4B9E-8169-311B17858169}',
	'IChartModifierTimeLine' : '{7440FFE1-9009-44ED-90D1-6B7A9143AB66}',
	'IChartModifierTooltip' : '{FD63AE8C-75EF-437B-AB41-0654C94D7F03}',
	'_LocalizedDescriptionAttribute' : '{E3CB556E-651D-377D-A93F-548466BD073C}',
	'IAnimationFrame' : '{49D0E38C-E5C3-4BFF-9478-E033FD4A4B53}',
	'IChart' : '{34617DA7-D0B4-4F35-8FC7-EC46CB8C669E}',
	'IChartAnnotation' : '{1A536495-EBB2-3064-8F82-965701F9C9E6}',
	'IChartAnnotationArrow' : '{30BE7FEF-077E-3FCE-B04A-4AD51121F32C}',
	'IChartAnnotationLine' : '{E9AF3CC1-C0A5-30AA-AF4E-55FBA8B16CDC}',
	'IChartAnnotationText' : '{1D84921F-8E33-3F3B-AA18-8125DD3FC0D3}',
	'IChartAnnotationVerticalLine' : '{BD40CFBC-C472-3CAD-B809-1B8301479DE2}',
	'IChartAxisBase' : '{5A2D9BD6-130C-46BA-8682-0E7013235AEF}',
	'IChartAxisX' : '{2A620232-B413-4059-9E81-29A2CCA9EFEF}',
	'IChartAxisY' : '{87BCC87E-1B14-4ABB-B9FF-B9DF8A808DC7}',
	'IChartBase' : '{691044DE-CC8C-4822-8E2F-736529CFC5A4}',
	'IChartPalette' : '{6AA40D7C-95DF-4381-B3CD-4588D1D3C84E}',
	'IChartPointMarker' : '{A57DEE8B-3147-4E83-A188-65C5A265F0D5}',
	'IChartSeries' : '{FF8D46C1-F639-41F6-AB1C-C28B471D3BE1}',
	'IChartStyleGridLine' : '{47706DC8-0B8C-451D-8960-49A877CB0B3D}',
	'IChartStyleMajorGridLine' : '{DE759D88-66E1-4764-86B0-96D98197A346}',
	'IChartStyleMinorGridLine' : '{7EA666D2-F00C-4C50-92E7-3DBCCB3EB6D7}',
	'IChartStyleGridLinePanel' : '{D9BF4E72-7F00-43A0-84A1-200EDAD13C71}',
	'IChartStyleTickLabel' : '{98C9EDE1-AD97-4E82-8AB2-1CB2B4D8C737}',
	'IChartStyleTickLine' : '{96B447B4-B377-40F5-A14F-4334FE99C903}',
	'IChartStyleMajorTickLine' : '{0425D327-6C6A-4081-8DBB-337984399370}',
	'IChartStyleMinorTickLine' : '{EC115BE3-60B5-455B-B57C-67A3A0A1EAB4}',
	'IChartStyleAxisTitle' : '{1C89A72D-8ED3-466D-A7C8-E8C29FC5D343}',
	'IChartStyleTitle' : '{F779994A-D846-4F12-AE53-DD023F6973B9}',
	'IChartTimeLineAnnotationStyle' : '{496406A4-661D-4FA1-A778-FDA86C1C1DA4}',
	'IDataComponent' : '{E78ED5D5-B65B-46A6-9E9B-4B010D8C00E5}',
	'IEntity' : '{E0C292B7-592C-4F26-B935-578E8229E9E7}',
	'IEntityDocument' : '{89E7C670-EDA4-4814-956B-C1B9B745B079}',
	'IEntityManager' : '{DAD27545-EA9C-4F9D-B84F-4F066CA2C94E}',
	'IEntityModel' : '{EE1CCDB0-8A25-4B01-8CE5-82A0064DCADC}',
	'IEntityPlot' : '{02444C62-D19B-4934-9572-E6677E061882}',
	'_SeriesValueInfo' : '{A52D09DE-44DC-32AF-8AED-55A7F571791A}',
	'IOperation' : '{87B5D361-DD3F-4EAF-992D-EB5B1B2F42A5}',
	'IControl' : '{AAC98348-2902-49EA-BDBA-658775DB336E}',
	'IViewModel' : '{3CF4931D-92BA-490B-A6B6-11FC4A7E67D0}',
	'IWindowPane' : '{A1DFDDD2-066D-4163-8A08-C1A20C9BEA78}',
	'IDatabaseItem' : '{6F99EEE7-09F6-4708-8179-6DEA5376493F}',
	'IDataFileDatabaseItem' : '{51E9CB85-08CD-49C0-8374-B22EB0236624}',
}


