import time
import serial

__version__ = "0.0.3"


class SenseairS8:
    
    def __init__(self, port="/dev/ttyS0", baudrate=9600, timeout=.5):
        self.ser = serial.Serial(port, baudrate=baudrate, timeout=timeout)
        self.ser.flushInput()
    
    def co2(self):
        try:
            self.ser.flushInput()
            self.ser.write(b"\xFE\x44\x00\x08\x02\x9F\x25")
            time.sleep(1)
            response = self.ser.read(7)

            high = response[3]
            low = response[4]
            co2 = (high*256) + low
        except Exception as e:
            co2 = None
            print(e)
        
        return co2
