# coding: utf-8

# -----------------------------------------------------------------------------------
# <copyright company="Aspose">
#   Copyright (c) 2018 Aspose.Slides for Cloud
# </copyright>
# <summary>
#   Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
# </summary>
# -----------------------------------------------------------------------------------

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from asposeslidescloud.apis.api_base import ApiBase
from asposeslidescloud.api_client import ApiClient

class SlidesApi(ApiBase):

    def __init__(self, configuration = None, app_sid = None, app_key = None):
        super(SlidesApi, self).__init__(configuration, app_sid, app_key)

    def align_shapes(self, name, slide_index, alignment_type, align_to_slide = None, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, alignment_type, align_to_slide, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param alignment_type Alignment type that will be applied to the shapes.
        :param align_to_slide If true, shapes will be aligned relative to the slide edges.
        :param shapes Shapes indexes.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.align_shapes_with_http_info(name, slide_index, alignment_type, align_to_slide, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.align_shapes_with_http_info(name, slide_index, alignment_type, align_to_slide, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def align_shapes_with_http_info(self, name, slide_index, alignment_type, align_to_slide = None, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Changes the placement of selected shapes on the slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.align_shapes_with_http_info(name, slide_index, alignment_type, align_to_slide, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param alignment_type Alignment type that will be applied to the shapes.
        :param align_to_slide If true, shapes will be aligned relative to the slide edges.
        :param shapes Shapes indexes.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method align_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `align_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `align_shapes`")  # noqa: E501
        # verify the required parameter 'alignment_type' is set
        if not alignment_type:
            raise ValueError("Missing the required parameter `request.alignment_type` when calling `align_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['alignmentType'] = alignment_type  # noqa: E501

        query_params = []
        if align_to_slide:
            query_params.append(('alignToSlide', align_to_slide))  # noqa: E501
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/align/{alignmentType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def align_special_slide_shapes(self, name, slide_index, slide_type, alignment_type, align_to_slide = None, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Changes the placement of selected shapes on the master slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, alignment_type, align_to_slide, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param alignment_type Alignment type that will be applied to the shapes.
        :param align_to_slide If true, shapes will be aligned relative to the slide edges.
        :param shapes Shapes indexes.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.align_special_slide_shapes_with_http_info(name, slide_index, slide_type, alignment_type, align_to_slide, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.align_special_slide_shapes_with_http_info(name, slide_index, slide_type, alignment_type, align_to_slide, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def align_special_slide_shapes_with_http_info(self, name, slide_index, slide_type, alignment_type, align_to_slide = None, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Changes the placement of selected shapes on the master slide. Aligns shapes to the margins or the edge of the slide or aligns them relative to each other.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.align_special_slide_shapes_with_http_info(name, slide_index, slide_type, alignment_type, align_to_slide, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param alignment_type Alignment type that will be applied to the shapes.
        :param align_to_slide If true, shapes will be aligned relative to the slide edges.
        :param shapes Shapes indexes.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method align_special_slide_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `align_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `align_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `align_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'alignment_type' is set
        if not alignment_type:
            raise ValueError("Missing the required parameter `request.alignment_type` when calling `align_special_slide_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['alignmentType'] = alignment_type  # noqa: E501

        query_params = []
        if align_to_slide:
            query_params.append(('alignToSlide', align_to_slide))  # noqa: E501
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/align/{alignmentType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert(self, document, format, password = None, storage = None, fonts_folder = None, slides = None, options = None, **kwargs):  # noqa: E501
        """Convert presentation from request content to format specified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, format, password, storage, fonts_folder, slides, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be converted. If not specified, all slides are converted by default.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.convert_with_http_info(document, format, password, storage, fonts_folder, slides, options, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_with_http_info(document, format, password, storage, fonts_folder, slides, options, **kwargs)  # noqa: E501
            return data

    def convert_with_http_info(self, document, format, password = None, storage = None, fonts_folder = None, slides = None, options = None, **kwargs):  # noqa: E501
        """Convert presentation from request content to format specified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.convert_with_http_info(document, format, password, storage, fonts_folder, slides, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be converted. If not specified, all slides are converted by default.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `convert`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `convert`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['format'] = format  # noqa: E501

        query_params = []
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501
        if slides:
            query_params.append(('slides', slides))  # noqa: E501
            collection_formats['slides'] = ''  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/convert/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def convert_and_save(self, document, format, out_path, password = None, storage = None, fonts_folder = None, slides = None, options = None, **kwargs):  # noqa: E501
        """Convert presentation from request content to format specified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, format, out_path, password, storage, fonts_folder, slides, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format.
        :param out_path Path to save result.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be converted. If not specified, all slides are converted by default.
        :param options Export options.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.convert_and_save_with_http_info(document, format, out_path, password, storage, fonts_folder, slides, options, **kwargs)  # noqa: E501
        else:
            (data) = self.convert_and_save_with_http_info(document, format, out_path, password, storage, fonts_folder, slides, options, **kwargs)  # noqa: E501
            return data

    def convert_and_save_with_http_info(self, document, format, out_path, password = None, storage = None, fonts_folder = None, slides = None, options = None, **kwargs):  # noqa: E501
        """Convert presentation from request content to format specified.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.convert_and_save_with_http_info(document, format, out_path, password, storage, fonts_folder, slides, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format.
        :param out_path Path to save result.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be converted. If not specified, all slides are converted by default.
        :param options Export options.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method convert_and_save" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `convert_and_save`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `convert_and_save`")  # noqa: E501
        # verify the required parameter 'out_path' is set
        if not out_path:
            raise ValueError("Missing the required parameter `request.out_path` when calling `convert_and_save`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['format'] = format  # noqa: E501

        query_params = []
        if out_path:
            query_params.append(('outPath', out_path))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501
        if slides:
            query_params.append(('slides', slides))  # noqa: E501
            collection_formats['slides'] = ''  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/convert/{format}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_file(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Copy file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(src_path, dest_path, src_storage_name, dest_storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source file path e.g. '/folder/file.ext'
        :param dest_path Destination file path
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :param version_id File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.copy_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, **kwargs)  # noqa: E501
            return data

    def copy_file_with_http_info(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Copy file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.copy_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source file path e.g. '/folder/file.ext'
        :param dest_path Destination file path
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :param version_id File version ID to copy
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if not src_path:
            raise ValueError("Missing the required parameter `request.src_path` when calling `copy_file`")  # noqa: E501
        # verify the required parameter 'dest_path' is set
        if not dest_path:
            raise ValueError("Missing the required parameter `request.dest_path` when calling `copy_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['srcPath'] = src_path  # noqa: E501

        query_params = []
        if dest_path:
            query_params.append(('destPath', dest_path))  # noqa: E501
        if src_storage_name:
            query_params.append(('srcStorageName', src_storage_name))  # noqa: E501
        if dest_storage_name:
            query_params.append(('destStorageName', dest_storage_name))  # noqa: E501
        if version_id:
            query_params.append(('versionId', version_id))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/file/copy/{srcPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_folder(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, **kwargs):  # noqa: E501
        """Copy folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(src_path, dest_path, src_storage_name, dest_storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source folder path e.g. '/src'
        :param dest_path Destination folder path e.g. '/dst'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.copy_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, **kwargs)  # noqa: E501
            return data

    def copy_folder_with_http_info(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, **kwargs):  # noqa: E501
        """Copy folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.copy_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source folder path e.g. '/src'
        :param dest_path Destination folder path e.g. '/dst'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if not src_path:
            raise ValueError("Missing the required parameter `request.src_path` when calling `copy_folder`")  # noqa: E501
        # verify the required parameter 'dest_path' is set
        if not dest_path:
            raise ValueError("Missing the required parameter `request.dest_path` when calling `copy_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['srcPath'] = src_path  # noqa: E501

        query_params = []
        if dest_path:
            query_params.append(('destPath', dest_path))  # noqa: E501
        if src_storage_name:
            query_params.append(('srcStorageName', src_storage_name))  # noqa: E501
        if dest_storage_name:
            query_params.append(('destStorageName', dest_storage_name))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/folder/copy/{srcPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_layout_slide(self, name, clone_from, clone_from_position, clone_from_password = None, clone_from_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy layoutSlide from source presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param clone_from Name of the document to clone layoutSlide from.
        :param clone_from_position Position of cloned layout slide.
        :param clone_from_password Password for the document to clone layoutSlide from.
        :param clone_from_storage Storage of the document to clone layoutSlide from.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.copy_layout_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_layout_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def copy_layout_slide_with_http_info(self, name, clone_from, clone_from_position, clone_from_password = None, clone_from_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy layoutSlide from source presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.copy_layout_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param clone_from Name of the document to clone layoutSlide from.
        :param clone_from_position Position of cloned layout slide.
        :param clone_from_password Password for the document to clone layoutSlide from.
        :param clone_from_storage Storage of the document to clone layoutSlide from.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_layout_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `copy_layout_slide`")  # noqa: E501
        # verify the required parameter 'clone_from' is set
        if not clone_from:
            raise ValueError("Missing the required parameter `request.clone_from` when calling `copy_layout_slide`")  # noqa: E501
        # verify the required parameter 'clone_from_position' is set
        if not clone_from_position:
            raise ValueError("Missing the required parameter `request.clone_from_position` when calling `copy_layout_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if clone_from:
            query_params.append(('cloneFrom', clone_from))  # noqa: E501
        if clone_from_position:
            query_params.append(('cloneFromPosition', clone_from_position))  # noqa: E501
        if clone_from_storage:
            query_params.append(('cloneFromStorage', clone_from_storage))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if clone_from_password:
            header_params['cloneFromPassword'] = clone_from_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/layoutSlides', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='LayoutSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_master_slide(self, name, clone_from, clone_from_position, clone_from_password = None, clone_from_storage = None, apply_to_all = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy masterSlide from source presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, apply_to_all, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param clone_from Name of the document to clone masterSlide from.
        :param clone_from_position Position of cloned master slide.
        :param clone_from_password Password for the document to clone masterSlide from.
        :param clone_from_storage Storage of the document to clone masterSlide from.
        :param apply_to_all True to apply cloned master slide to every existing slide.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.copy_master_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, apply_to_all, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_master_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, apply_to_all, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def copy_master_slide_with_http_info(self, name, clone_from, clone_from_position, clone_from_password = None, clone_from_storage = None, apply_to_all = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy masterSlide from source presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.copy_master_slide_with_http_info(name, clone_from, clone_from_position, clone_from_password, clone_from_storage, apply_to_all, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param clone_from Name of the document to clone masterSlide from.
        :param clone_from_position Position of cloned master slide.
        :param clone_from_password Password for the document to clone masterSlide from.
        :param clone_from_storage Storage of the document to clone masterSlide from.
        :param apply_to_all True to apply cloned master slide to every existing slide.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_master_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `copy_master_slide`")  # noqa: E501
        # verify the required parameter 'clone_from' is set
        if not clone_from:
            raise ValueError("Missing the required parameter `request.clone_from` when calling `copy_master_slide`")  # noqa: E501
        # verify the required parameter 'clone_from_position' is set
        if not clone_from_position:
            raise ValueError("Missing the required parameter `request.clone_from_position` when calling `copy_master_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if clone_from:
            query_params.append(('cloneFrom', clone_from))  # noqa: E501
        if clone_from_position:
            query_params.append(('cloneFromPosition', clone_from_position))  # noqa: E501
        if clone_from_storage:
            query_params.append(('cloneFromStorage', clone_from_storage))  # noqa: E501
        if apply_to_all:
            query_params.append(('applyToAll', apply_to_all))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if clone_from_password:
            header_params['cloneFromPassword'] = clone_from_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/masterSlides', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='MasterSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_slide(self, name, slide_to_copy, position = None, source = None, source_password = None, source_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy a slide from the current or another presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_to_copy, position, source, source_password, source_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_to_copy The index of the slide to be copied from the source presentation.
        :param position The target position at which to copy the slide. Copy to the end by default.
        :param source Name of the document to copy a slide from.
        :param source_password Password for the document to copy a slide from.
        :param source_storage Template storage name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.copy_slide_with_http_info(name, slide_to_copy, position, source, source_password, source_storage, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_slide_with_http_info(name, slide_to_copy, position, source, source_password, source_storage, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def copy_slide_with_http_info(self, name, slide_to_copy, position = None, source = None, source_password = None, source_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Copy a slide from the current or another presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.copy_slide_with_http_info(name, slide_to_copy, position, source, source_password, source_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_to_copy The index of the slide to be copied from the source presentation.
        :param position The target position at which to copy the slide. Copy to the end by default.
        :param source Name of the document to copy a slide from.
        :param source_password Password for the document to copy a slide from.
        :param source_storage Template storage name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `copy_slide`")  # noqa: E501
        # verify the required parameter 'slide_to_copy' is set
        if not slide_to_copy:
            raise ValueError("Missing the required parameter `request.slide_to_copy` when calling `copy_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if slide_to_copy:
            query_params.append(('slideToCopy', slide_to_copy))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if source:
            query_params.append(('source', source))  # noqa: E501
        if source_storage:
            query_params.append(('sourceStorage', source_storage))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if source_password:
            header_params['sourcePassword'] = source_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/copy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_animation_effect(self, name, slide_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an effect to slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_animation_effect_with_http_info(name, slide_index, effect, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_animation_effect_with_http_info(name, slide_index, effect, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_animation_effect_with_http_info(self, name, slide_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an effect to slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_animation_effect_with_http_info(name, slide_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_animation_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_animation_effect`")  # noqa: E501
        # verify the required parameter 'effect' is set
        if not effect:
            raise ValueError("Missing the required parameter `request.effect` when calling `create_animation_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if effect:
            body_params = effect

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/mainSequence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_animation_interactive_sequence(self, name, slide_index, sequence, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Set slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, sequence, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence Animation sequence DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_animation_interactive_sequence_with_http_info(name, slide_index, sequence, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_animation_interactive_sequence_with_http_info(name, slide_index, sequence, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_animation_interactive_sequence_with_http_info(self, name, slide_index, sequence, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Set slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_animation_interactive_sequence_with_http_info(name, slide_index, sequence, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence Animation sequence DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_animation_interactive_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'sequence' is set
        if not sequence:
            raise ValueError("Missing the required parameter `request.sequence` when calling `create_animation_interactive_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if sequence:
            body_params = sequence

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_animation_interactive_sequence_effect(self, name, slide_index, sequence_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an animation effect to a slide interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, sequence_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index The position of the interactive sequence.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_animation_interactive_sequence_effect_with_http_info(self, name, slide_index, sequence_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an animation effect to a slide interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index The position of the interactive sequence.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_animation_interactive_sequence_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `create_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'effect' is set
        if not effect:
            raise ValueError("Missing the required parameter `request.effect` when calling `create_animation_interactive_sequence_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if effect:
            body_params = effect

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_chart_category(self, name, slide_index, shape_index, category, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new category to a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, category, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param category Category DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_chart_category_with_http_info(name, slide_index, shape_index, category, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_chart_category_with_http_info(name, slide_index, shape_index, category, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_chart_category_with_http_info(self, name, slide_index, shape_index, category, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new category to a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_chart_category_with_http_info(name, slide_index, shape_index, category, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param category Category DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_chart_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_chart_category`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_chart_category`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_chart_category`")  # noqa: E501
        # verify the required parameter 'category' is set
        if not category:
            raise ValueError("Missing the required parameter `request.category` when calling `create_chart_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if category:
            body_params = category

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_chart_data_point(self, name, slide_index, shape_index, series_index, data_point, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new data point to a chart series.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, series_index, data_point, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param series_index Series index.
        :param data_point Data point DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, data_point, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, data_point, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_chart_data_point_with_http_info(self, name, slide_index, shape_index, series_index, data_point, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new data point to a chart series.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, data_point, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param series_index Series index.
        :param data_point Data point DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_chart_data_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_chart_data_point`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_chart_data_point`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_chart_data_point`")  # noqa: E501
        # verify the required parameter 'series_index' is set
        if not series_index:
            raise ValueError("Missing the required parameter `request.series_index` when calling `create_chart_data_point`")  # noqa: E501
        # verify the required parameter 'data_point' is set
        if not data_point:
            raise ValueError("Missing the required parameter `request.data_point` when calling `create_chart_data_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['seriesIndex'] = series_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if data_point:
            body_params = data_point

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_chart_series(self, name, slide_index, shape_index, series, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new series to a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, series, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index (must be a chart).
        :param series Series DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_chart_series_with_http_info(name, slide_index, shape_index, series, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_chart_series_with_http_info(name, slide_index, shape_index, series, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_chart_series_with_http_info(self, name, slide_index, shape_index, series, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add a new series to a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_chart_series_with_http_info(name, slide_index, shape_index, series, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index (must be a chart).
        :param series Series DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_chart_series" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_chart_series`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_chart_series`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_chart_series`")  # noqa: E501
        # verify the required parameter 'series' is set
        if not series:
            raise ValueError("Missing the required parameter `request.series` when calling `create_chart_series`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if series:
            body_params = series

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_comment(self, name, slide_index, dto, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds the comment on the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, dto, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto Comment DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_comment_with_http_info(name, slide_index, dto, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_comment_with_http_info(name, slide_index, dto, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_comment_with_http_info(self, name, slide_index, dto, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds the comment on the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_comment_with_http_info(name, slide_index, dto, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto Comment DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_comment" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_comment`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_comment`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_comment`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideComments',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_comment_online(self, document, slide_index, dto, password = None, **kwargs):  # noqa: E501
        """Adds the comment on the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, dto, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param dto Comment DTO.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_comment_online_with_http_info(document, slide_index, dto, password, **kwargs)  # noqa: E501
        else:
            (data) = self.create_comment_online_with_http_info(document, slide_index, dto, password, **kwargs)  # noqa: E501
            return data

    def create_comment_online_with_http_info(self, document, slide_index, dto, password = None, **kwargs):  # noqa: E501
        """Adds the comment on the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_comment_online_with_http_info(document, slide_index, dto, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param dto Comment DTO.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_comment_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `create_comment_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_comment_online`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_comment_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/comments', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_folder(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Create the folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path to create e.g. 'folder_1/folder_2/'
        :param storage_name Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_folder_with_http_info(path, storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.create_folder_with_http_info(path, storage_name, **kwargs)  # noqa: E501
            return data

    def create_folder_with_http_info(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Create the folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_folder_with_http_info(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path to create e.g. 'folder_1/folder_2/'
        :param storage_name Storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/folder/{path}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_image_watermark(self, name, image = None, picture_frame = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, image, picture_frame, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param image Image data.
        :param picture_frame PictureFrame DTO
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_image_watermark_with_http_info(name, image, picture_frame, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_image_watermark_with_http_info(name, image, picture_frame, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_image_watermark_with_http_info(self, name, image = None, picture_frame = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_image_watermark_with_http_info(name, image, picture_frame, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param image Image data.
        :param picture_frame PictureFrame DTO
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image_watermark" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_image_watermark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if image:
            param_files['image'] = image  # noqa: E501

        body_params = None
        if picture_frame:
            body_params = picture_frame

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/watermark/image', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_image_watermark_online(self, document, image = None, picture_frame = None, password = None, **kwargs):  # noqa: E501
        """Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, image, picture_frame, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param image Image data.
        :param picture_frame PictureFrame DTO.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_image_watermark_online_with_http_info(document, image, picture_frame, password, **kwargs)  # noqa: E501
        else:
            (data) = self.create_image_watermark_online_with_http_info(document, image, picture_frame, password, **kwargs)  # noqa: E501
            return data

    def create_image_watermark_online_with_http_info(self, document, image = None, picture_frame = None, password = None, **kwargs):  # noqa: E501
        """Adds an image watermark to each slide of the presentation.  Image can be provided as a part of the form or withing PictureFrame DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_image_watermark_online_with_http_info(document, image, picture_frame, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param image Image data.
        :param picture_frame PictureFrame DTO.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_image_watermark_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `create_image_watermark_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501
        if image:
            param_files['image'] = image  # noqa: E501

        body_params = None
        if picture_frame:
            body_params = picture_frame

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/watermark/image', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_notes_slide(self, name, slide_index, dto, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add new notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, dto, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto A NotesSlide object with notes slide data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_notes_slide_with_http_info(name, slide_index, dto, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_notes_slide_with_http_info(name, slide_index, dto, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_notes_slide_with_http_info(self, name, slide_index, dto, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add new notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_notes_slide_with_http_info(name, slide_index, dto, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto A NotesSlide object with notes slide data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_notes_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_notes_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_notes_slide`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_notes_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/notesSlide', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='NotesSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_paragraph(self, name, slide_index, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_paragraph_with_http_info(name, slide_index, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_paragraph_with_http_info(name, slide_index, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_paragraph_with_http_info(self, name, slide_index, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_paragraph_with_http_info(name, slide_index, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_paragraph`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_portion(self, name, slide_index, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_portion_with_http_info(name, slide_index, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_portion_with_http_info(name, slide_index, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_portion_with_http_info(self, name, slide_index, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_portion_with_http_info(name, slide_index, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `create_portion`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_presentation(self, name, data = None, input_password = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, data, input_password, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param data Document input data.
        :param input_password The password for input document.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_presentation_with_http_info(name, data, input_password, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_presentation_with_http_info(name, data, input_password, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_presentation_with_http_info(self, name, data = None, input_password = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_presentation_with_http_info(name, data, input_password, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param data Document input data.
        :param input_password The password for input document.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_presentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_presentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if input_password:
            header_params['inputPassword'] = input_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if data:
            param_files['data'] = data  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_presentation_from_source(self, name, source_path = None, source_password = None, source_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation from an existing source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, source_path, source_password, source_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param source_path Template file path.
        :param source_password Template file password.
        :param source_storage Template storage name.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_presentation_from_source_with_http_info(name, source_path, source_password, source_storage, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_presentation_from_source_with_http_info(name, source_path, source_password, source_storage, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_presentation_from_source_with_http_info(self, name, source_path = None, source_password = None, source_storage = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation from an existing source.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_presentation_from_source_with_http_info(name, source_path, source_password, source_storage, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param source_path Template file path.
        :param source_password Template file password.
        :param source_storage Template storage name.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_presentation_from_source" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_presentation_from_source`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if source_path:
            query_params.append(('sourcePath', source_path))  # noqa: E501
        if source_storage:
            query_params.append(('sourceStorage', source_storage))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if source_password:
            header_params['sourcePassword'] = source_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/fromSource', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_presentation_from_template(self, name, template_path, data = None, template_password = None, template_storage = None, is_image_data_embedded = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, template_path, data, template_password, template_storage, is_image_data_embedded, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param template_path Template file path.
        :param data Document input data.
        :param template_password Template file password.
        :param template_storage Template storage name.
        :param is_image_data_embedded True if image data is embedded.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_presentation_from_template_with_http_info(name, template_path, data, template_password, template_storage, is_image_data_embedded, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_presentation_from_template_with_http_info(name, template_path, data, template_password, template_storage, is_image_data_embedded, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_presentation_from_template_with_http_info(self, name, template_path, data = None, template_password = None, template_storage = None, is_image_data_embedded = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_presentation_from_template_with_http_info(name, template_path, data, template_password, template_storage, is_image_data_embedded, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param template_path Template file path.
        :param data Document input data.
        :param template_password Template file password.
        :param template_storage Template storage name.
        :param is_image_data_embedded True if image data is embedded.
        :param password The document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_presentation_from_template" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_presentation_from_template`")  # noqa: E501
        # verify the required parameter 'template_path' is set
        if not template_path:
            raise ValueError("Missing the required parameter `request.template_path` when calling `create_presentation_from_template`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if template_path:
            query_params.append(('templatePath', template_path))  # noqa: E501
        if template_storage:
            query_params.append(('templateStorage', template_storage))  # noqa: E501
        if is_image_data_embedded:
            query_params.append(('isImageDataEmbedded', is_image_data_embedded))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if template_password:
            header_params['templatePassword'] = template_password  # noqa: E501
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if data:
            body_params = data

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/fromTemplate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_section(self, name, section_name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a section starting at a specified slide index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, section_name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param section_name Section name.
        :param slide_index Slide index (one-based).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_section_with_http_info(name, section_name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_section_with_http_info(name, section_name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_section_with_http_info(self, name, section_name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a section starting at a specified slide index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_section_with_http_info(name, section_name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param section_name Section name.
        :param slide_index Slide index (one-based).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_section`")  # noqa: E501
        # verify the required parameter 'section_name' is set
        if not section_name:
            raise ValueError("Missing the required parameter `request.section_name` when calling `create_section`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_section`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if section_name:
            query_params.append(('sectionName', section_name))  # noqa: E501
        if slide_index:
            query_params.append(('slideIndex', slide_index))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/sections', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Sections',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_shape(self, name, slide_index, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_shape_with_http_info(name, slide_index, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_shape_with_http_info(name, slide_index, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_shape_with_http_info(self, name, slide_index, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_shape_with_http_info(name, slide_index, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if shape_to_clone:
            query_params.append(('shapeToClone', shape_to_clone))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_slide(self, name, layout_alias = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, layout_alias, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param layout_alias Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index
        :param position The target position at which to create the slide. Add to the end by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_slide_with_http_info(name, layout_alias, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_slide_with_http_info(name, layout_alias, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_slide_with_http_info(self, name, layout_alias = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_slide_with_http_info(name, layout_alias, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param layout_alias Alias of layout slide for new slide. Alias may be the type of layout, name of layout slide or index
        :param position The target position at which to create the slide. Add to the end by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if layout_alias:
            query_params.append(('layoutAlias', layout_alias))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_animation_effect(self, name, slide_index, slide_type, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an effect to special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_animation_effect_with_http_info(self, name, slide_index, slide_type, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an effect to special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_animation_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'effect' is set
        if not effect:
            raise ValueError("Missing the required parameter `request.effect` when calling `create_special_slide_animation_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if effect:
            body_params = effect

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_animation_interactive_sequence(self, name, slide_index, slide_type, sequence, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Set special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, sequence, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence Animation sequence DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_animation_interactive_sequence_with_http_info(self, name, slide_index, slide_type, sequence, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Set special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence Animation sequence DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_animation_interactive_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'sequence' is set
        if not sequence:
            raise ValueError("Missing the required parameter `request.sequence` when calling `create_special_slide_animation_interactive_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if sequence:
            body_params = sequence

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_animation_interactive_sequence_effect(self, name, slide_index, slide_type, sequence_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an animation effect to a special slide (master, layout, notes) interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, sequence_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index The position of the interactive sequence.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_animation_interactive_sequence_effect_with_http_info(self, name, slide_index, slide_type, sequence_index, effect, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Add an animation effect to a special slide (master, layout, notes) interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index The position of the interactive sequence.
        :param effect Animation effect DTO.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_animation_interactive_sequence_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `create_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'effect' is set
        if not effect:
            raise ValueError("Missing the required parameter `request.effect` when calling `create_special_slide_animation_interactive_sequence_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if effect:
            body_params = effect

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_paragraph(self, name, slide_index, slide_type, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_paragraph_with_http_info(self, name, slide_index, slide_type, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_special_slide_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_portion(self, name, slide_index, slide_type, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_portion_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `create_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_special_slide_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_shape(self, name, slide_index, slide_type, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_shape_with_http_info(name, slide_index, slide_type, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_shape_with_http_info(name, slide_index, slide_type, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_shape_with_http_info(self, name, slide_index, slide_type, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_shape_with_http_info(name, slide_index, slide_type, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if shape_to_clone:
            query_params.append(('shapeToClone', shape_to_clone))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_subshape(self, name, slide_index, slide_type, path, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_subshape_with_http_info(self, name, slide_index, slide_type, path, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_special_slide_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if shape_to_clone:
            query_params.append(('shapeToClone', shape_to_clone))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_subshape_paragraph(self, name, slide_index, slide_type, path, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_subshape_paragraph_with_http_info(self, name, slide_index, slide_type, path, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_special_slide_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_special_slide_subshape_portion(self, name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_special_slide_subshape_portion_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_special_slide_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `create_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_special_slide_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subshape(self, name, slide_index, path, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_subshape_with_http_info(name, slide_index, path, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subshape_with_http_info(name, slide_index, path, dto, shape_to_clone, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_subshape_with_http_info(self, name, slide_index, path, dto = None, shape_to_clone = None, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create new shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_subshape_with_http_info(name, slide_index, path, dto, shape_to_clone, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param dto Shape DTO.
        :param shape_to_clone Optional index for clone shape instead of adding a new one.
        :param position Position of the new shape in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if shape_to_clone:
            query_params.append(('shapeToClone', shape_to_clone))  # noqa: E501
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subshape_paragraph(self, name, slide_index, path, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_subshape_paragraph_with_http_info(self, name, slide_index, path, shape_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param dto Paragraph DTO.
        :param position Position of the new paragraph in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_subshape_portion(self, name, slide_index, path, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, dto, position, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_subshape_portion_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, dto, position = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Creates new portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, dto, position, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param dto Portion DTO.
        :param position Position of the new portion in the list. Default is at the end of the list.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `create_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `create_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `create_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `create_subshape_portion`")  # noqa: E501
        # verify the required parameter 'dto' is set
        if not dto:
            raise ValueError("Missing the required parameter `request.dto` when calling `create_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if position:
            query_params.append(('position', position))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if dto:
            body_params = dto

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_watermark(self, name, shape = None, font_height = None, text = None, font_name = None, font_color = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, shape, font_height, text, font_name, font_color, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param shape Shape DTO
        :param font_height Watermark font height.
        :param text Watermark text.
        :param font_name Watermark font name.
        :param font_color Watermark font color.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_watermark_with_http_info(name, shape, font_height, text, font_name, font_color, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.create_watermark_with_http_info(name, shape, font_height, text, font_name, font_color, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def create_watermark_with_http_info(self, name, shape = None, font_height = None, text = None, font_name = None, font_color = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_watermark_with_http_info(name, shape, font_height, text, font_name, font_color, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param shape Shape DTO
        :param font_height Watermark font height.
        :param text Watermark text.
        :param font_name Watermark font name.
        :param font_color Watermark font color.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_watermark" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `create_watermark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if font_height:
            query_params.append(('fontHeight', font_height))  # noqa: E501
        if text:
            query_params.append(('text', text))  # noqa: E501
        if font_name:
            query_params.append(('fontName', font_name))  # noqa: E501
        if font_color:
            query_params.append(('fontColor', font_color))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if shape:
            body_params = shape

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/watermark', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_watermark_online(self, document, shape = None, font_height = None, text = None, font_name = None, font_color = None, password = None, **kwargs):  # noqa: E501
        """Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, shape, font_height, text, font_name, font_color, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param shape Shape DTO
        :param font_height Watermark font height.
        :param text Watermark text.
        :param font_name Watermark font name.
        :param font_color Watermark font color.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.create_watermark_online_with_http_info(document, shape, font_height, text, font_name, font_color, password, **kwargs)  # noqa: E501
        else:
            (data) = self.create_watermark_online_with_http_info(document, shape, font_height, text, font_name, font_color, password, **kwargs)  # noqa: E501
            return data

    def create_watermark_online_with_http_info(self, document, shape = None, font_height = None, text = None, font_name = None, font_color = None, password = None, **kwargs):  # noqa: E501
        """Adds a text watermark to each slide of the presentation. Text watermark can be setup via method arguments or withing Shape DTO for detailed customization. Both options are applicable simultaneously.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.create_watermark_online_with_http_info(document, shape, font_height, text, font_name, font_color, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param shape Shape DTO
        :param font_height Watermark font height.
        :param text Watermark text.
        :param font_name Watermark font name.
        :param font_color Watermark font color.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_watermark_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `create_watermark_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if font_height:
            query_params.append(('fontHeight', font_height))  # noqa: E501
        if text:
            query_params.append(('text', text))  # noqa: E501
        if font_name:
            query_params.append(('fontName', font_name))  # noqa: E501
        if font_color:
            query_params.append(('fontColor', font_color))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if shape:
            body_params = shape

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/watermark', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove animation from a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove animation from a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation_effect(self, name, slide_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_effect_with_http_info(name, slide_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_effect_with_http_info(name, slide_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_effect_with_http_info(self, name, slide_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_effect_with_http_info(name, slide_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation_effect`")  # noqa: E501
        # verify the required parameter 'effect_index' is set
        if not effect_index:
            raise ValueError("Missing the required parameter `request.effect_index` when calling `delete_animation_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['effectIndex'] = effect_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/mainSequence/{effectIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation_interactive_sequence(self, name, slide_index, sequence_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an interactive sequence from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, sequence_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index The index of an interactive sequence to be deleted.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_interactive_sequence_with_http_info(name, slide_index, sequence_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_interactive_sequence_with_http_info(name, slide_index, sequence_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_interactive_sequence_with_http_info(self, name, slide_index, sequence_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an interactive sequence from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_interactive_sequence_with_http_info(name, slide_index, sequence_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index The index of an interactive sequence to be deleted.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation_interactive_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `delete_animation_interactive_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation_interactive_sequence_effect(self, name, slide_index, sequence_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from slide animation interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, sequence_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index Interactive sequence index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_interactive_sequence_effect_with_http_info(self, name, slide_index, sequence_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from slide animation interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_interactive_sequence_effect_with_http_info(name, slide_index, sequence_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param sequence_index Interactive sequence index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation_interactive_sequence_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `delete_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'effect_index' is set
        if not effect_index:
            raise ValueError("Missing the required parameter `request.effect_index` when calling `delete_animation_interactive_sequence_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501
        path_params['effectIndex'] = effect_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation_interactive_sequences(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear all interactive sequences from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_interactive_sequences_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_interactive_sequences_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_interactive_sequences_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear all interactive sequences from slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_interactive_sequences_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation_interactive_sequences" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation_interactive_sequences`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation_interactive_sequences`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/interactiveSequences', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_animation_main_sequence(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear main sequence in slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_animation_main_sequence_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_animation_main_sequence_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_animation_main_sequence_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear main sequence in slide animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_animation_main_sequence_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_animation_main_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_animation_main_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_animation_main_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation/mainSequence', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_background(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove background from a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideBackground
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_background_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_background_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_background_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove background from a slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_background_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideBackground
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_background" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_background`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_background`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/background', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideBackground',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_chart_category(self, name, slide_index, shape_index, category_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a category from a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, category_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param category_index Category index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_chart_category_with_http_info(name, slide_index, shape_index, category_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_chart_category_with_http_info(name, slide_index, shape_index, category_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_chart_category_with_http_info(self, name, slide_index, shape_index, category_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a category from a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_chart_category_with_http_info(name, slide_index, shape_index, category_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param category_index Category index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chart_category" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_chart_category`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_chart_category`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_chart_category`")  # noqa: E501
        # verify the required parameter 'category_index' is set
        if not category_index:
            raise ValueError("Missing the required parameter `request.category_index` when calling `delete_chart_category`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['categoryIndex'] = category_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/categories/{categoryIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_chart_data_point(self, name, slide_index, shape_index, series_index, point_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a data point from a chart series.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, series_index, point_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param series_index Series index.
        :param point_index Data point index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, point_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, point_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_chart_data_point_with_http_info(self, name, slide_index, shape_index, series_index, point_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a data point from a chart series.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_chart_data_point_with_http_info(name, slide_index, shape_index, series_index, point_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param series_index Series index.
        :param point_index Data point index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chart_data_point" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_chart_data_point`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_chart_data_point`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_chart_data_point`")  # noqa: E501
        # verify the required parameter 'series_index' is set
        if not series_index:
            raise ValueError("Missing the required parameter `request.series_index` when calling `delete_chart_data_point`")  # noqa: E501
        # verify the required parameter 'point_index' is set
        if not point_index:
            raise ValueError("Missing the required parameter `request.point_index` when calling `delete_chart_data_point`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['seriesIndex'] = series_index  # noqa: E501
        path_params['pointIndex'] = point_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}/dataPoints/{pointIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_chart_series(self, name, slide_index, shape_index, series_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a series from a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, series_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index (must be a chart).
        :param series_index Series index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_chart_series_with_http_info(name, slide_index, shape_index, series_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_chart_series_with_http_info(name, slide_index, shape_index, series_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_chart_series_with_http_info(self, name, slide_index, shape_index, series_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a series from a chart.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_chart_series_with_http_info(name, slide_index, shape_index, series_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index (must be a chart).
        :param series_index Series index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Chart
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chart_series" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_chart_series`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_chart_series`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_chart_series`")  # noqa: E501
        # verify the required parameter 'series_index' is set
        if not series_index:
            raise ValueError("Missing the required parameter `request.series_index` when calling `delete_chart_series`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['seriesIndex'] = series_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/series/{seriesIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Chart',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_comments(self, name, author = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, author, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param author Author of comments.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_comments_with_http_info(name, author, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_comments_with_http_info(name, author, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_comments_with_http_info(self, name, author = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_comments_with_http_info(name, author, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param author Author of comments.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if author:
            query_params.append(('author', author))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/comments', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_comments_online(self, document, author = None, password = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, author, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param author Author of comments.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_comments_online_with_http_info(document, author, password, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_comments_online_with_http_info(document, author, password, **kwargs)  # noqa: E501
            return data

    def delete_comments_online_with_http_info(self, document, author = None, password = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the presentation. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_comments_online_with_http_info(document, author, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param author Author of comments.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_comments_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `delete_comments_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if author:
            query_params.append(('author', author))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/comments/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_document_properties(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clean document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_document_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_document_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_document_properties_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clean document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_document_properties_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_document_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/documentproperties', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='DocumentProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_document_property(self, name, property_name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete document property.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, property_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param property_name The property name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_document_property_with_http_info(name, property_name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_document_property_with_http_info(name, property_name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_document_property_with_http_info(self, name, property_name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete document property.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_document_property_with_http_info(name, property_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param property_name The property name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_document_property`")  # noqa: E501
        # verify the required parameter 'property_name' is set
        if not property_name:
            raise ValueError("Missing the required parameter `request.property_name` when calling `delete_document_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['propertyName'] = property_name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/documentproperties/{propertyName}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='DocumentProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_file(self, path, storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/folder/file.ext'
        :param storage_name Storage name
        :param version_id File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_file_with_http_info(path, storage_name, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_file_with_http_info(path, storage_name, version_id, **kwargs)  # noqa: E501
            return data

    def delete_file_with_http_info(self, path, storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Delete file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_file_with_http_info(path, storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/folder/file.ext'
        :param storage_name Storage name
        :param version_id File version ID to delete
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501
        if version_id:
            query_params.append(('versionId', version_id))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/file/{path}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_folder(self, path, storage_name = None, recursive = None, **kwargs):  # noqa: E501
        """Delete folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, recursive, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path e.g. '/folder'
        :param storage_name Storage name
        :param recursive Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_folder_with_http_info(path, storage_name, recursive, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_folder_with_http_info(path, storage_name, recursive, **kwargs)  # noqa: E501
            return data

    def delete_folder_with_http_info(self, path, storage_name = None, recursive = None, **kwargs):  # noqa: E501
        """Delete folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_folder_with_http_info(path, storage_name, recursive, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path e.g. '/folder'
        :param storage_name Storage name
        :param recursive Enable to delete folders, subfolders and files
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_folder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501
        if recursive:
            query_params.append(('recursive', recursive))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/folder/{path}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_notes_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_notes_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_notes_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_notes_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_notes_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_notes_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_notes_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_notes_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/notesSlide', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_paragraph(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_paragraph_with_http_info(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_paragraphs(self, name, slide_index, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_paragraphs_with_http_info(name, slide_index, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_paragraphs_with_http_info(name, slide_index, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_paragraphs_with_http_info(self, name, slide_index, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_paragraphs_with_http_info(name, slide_index, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if paragraphs:
            query_params.append(('paragraphs', paragraphs))  # noqa: E501
            collection_formats['paragraphs'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portion(self, name, slide_index, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_portion_with_http_info(self, name, slide_index, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `delete_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_portions(self, name, slide_index, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_portions_with_http_info(name, slide_index, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_portions_with_http_info(name, slide_index, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_portions_with_http_info(self, name, slide_index, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_portions_with_http_info(name, slide_index, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if portions:
            query_params.append(('portions', portions))  # noqa: E501
            collection_formats['portions'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_protection(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Resets all presentation protection settings.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Presentation password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ProtectionProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_protection_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_protection_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_protection_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Resets all presentation protection settings.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_protection_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Presentation password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ProtectionProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_protection" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_protection`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/protection', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ProtectionProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_protection_online(self, document, password, **kwargs):  # noqa: E501
        """Resets all presentation protection settings.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param password Presentation password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_protection_online_with_http_info(document, password, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_protection_online_with_http_info(document, password, **kwargs)  # noqa: E501
            return data

    def delete_protection_online_with_http_info(self, document, password, **kwargs):  # noqa: E501
        """Resets all presentation protection settings.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_protection_online_with_http_info(document, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param password Presentation password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_protection_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `delete_protection_online`")  # noqa: E501
        # verify the required parameter 'password' is set
        if not password:
            raise ValueError("Missing the required parameter `request.password` when calling `delete_protection_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/protection/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_section(self, name, section_index, with_slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a presentation section.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, section_index, with_slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param section_index Section index.
        :param with_slides True to delete the slides related to the deleted section; move them to the remaining sections otherwise.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_section_with_http_info(name, section_index, with_slides, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_section_with_http_info(name, section_index, with_slides, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_section_with_http_info(self, name, section_index, with_slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a presentation section.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_section_with_http_info(name, section_index, with_slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param section_index Section index.
        :param with_slides True to delete the slides related to the deleted section; move them to the remaining sections otherwise.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_section" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_section`")  # noqa: E501
        # verify the required parameter 'section_index' is set
        if not section_index:
            raise ValueError("Missing the required parameter `request.section_index` when calling `delete_section`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['sectionIndex'] = section_index  # noqa: E501

        query_params = []
        if with_slides:
            query_params.append(('withSlides', with_slides))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/sections/{sectionIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Sections',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_sections(self, name, sections = None, with_slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete presentation sections.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, sections, with_slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param sections The indices of the sections to be deleted; delete all by default.
        :param with_slides True to delete the slides related to the deleted sections; move them to the remaining sections otherwise.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_sections_with_http_info(name, sections, with_slides, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_sections_with_http_info(name, sections, with_slides, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_sections_with_http_info(self, name, sections = None, with_slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete presentation sections.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_sections_with_http_info(name, sections, with_slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param sections The indices of the sections to be deleted; delete all by default.
        :param with_slides True to delete the slides related to the deleted sections; move them to the remaining sections otherwise.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_sections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if sections:
            query_params.append(('sections', sections))  # noqa: E501
            collection_formats['sections'] = ''  # noqa: E501
        if with_slides:
            query_params.append(('withSlides', with_slides))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/sections', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Sections',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shape(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_shape_with_http_info(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_shapes(self, name, slide_index, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_shapes_with_http_info(name, slide_index, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_shapes_with_http_info(name, slide_index, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_shapes_with_http_info(self, name, slide_index, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_shapes_with_http_info(name, slide_index, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a presentation slide by index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete a presentation slide by index.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_slide_comments(self, name, slide_index, author = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, author, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param author Author of comments.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_slide_comments_with_http_info(name, slide_index, author, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_slide_comments_with_http_info(name, slide_index, author, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_slide_comments_with_http_info(self, name, slide_index, author = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_slide_comments_with_http_info(name, slide_index, author, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param author Author of comments.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_slide_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_slide_comments`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_slide_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if author:
            query_params.append(('author', author))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/comments', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideComments',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_slide_comments_online(self, document, slide_index, author = None, password = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.                # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, author, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index 
        :param author Author of comments.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_slide_comments_online_with_http_info(document, slide_index, author, password, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_slide_comments_online_with_http_info(document, slide_index, author, password, **kwargs)  # noqa: E501
            return data

    def delete_slide_comments_online_with_http_info(self, document, slide_index, author = None, password = None, **kwargs):  # noqa: E501
        """Removes comments of the specified author from the slide. If author value is not provided all comments will be removed.                # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_slide_comments_online_with_http_info(document, slide_index, author, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index 
        :param author Author of comments.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_slide_comments_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `delete_slide_comments_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_slide_comments_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if author:
            query_params.append(('author', author))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/comments/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_slides(self, name, slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete presentation slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slides The indices of the slides to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_slides_with_http_info(name, slides, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_slides_with_http_info(name, slides, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_slides_with_http_info(self, name, slides = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Delete presentation slides.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_slides_with_http_info(name, slides, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slides The indices of the slides to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if slides:
            query_params.append(('slides', slides))  # noqa: E501
            collection_formats['slides'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove animation from a special slide (master, layout, notes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_with_http_info(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove animation from a special slide (master, layout, notes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_with_http_info(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation_effect(self, name, slide_index, slide_type, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_effect_with_http_info(self, name, slide_index, slide_type, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_effect_with_http_info(name, slide_index, slide_type, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation_effect`")  # noqa: E501
        # verify the required parameter 'effect_index' is set
        if not effect_index:
            raise ValueError("Missing the required parameter `request.effect_index` when calling `delete_special_slide_animation_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['effectIndex'] = effect_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence/{effectIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation_interactive_sequence(self, name, slide_index, slide_type, sequence_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an interactive sequence from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, sequence_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index The index of an interactive sequence to be deleted.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_interactive_sequence_with_http_info(self, name, slide_index, slide_type, sequence_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an interactive sequence from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_interactive_sequence_with_http_info(name, slide_index, slide_type, sequence_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index The index of an interactive sequence to be deleted.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation_interactive_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation_interactive_sequence`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `delete_special_slide_animation_interactive_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation_interactive_sequence_effect(self, name, slide_index, slide_type, sequence_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from special slide (master, layout, notes) animation interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, sequence_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index Interactive sequence index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_interactive_sequence_effect_with_http_info(self, name, slide_index, slide_type, sequence_index, effect_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove an effect from special slide (master, layout, notes) animation interactive sequence.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_interactive_sequence_effect_with_http_info(name, slide_index, slide_type, sequence_index, effect_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param sequence_index Interactive sequence index.
        :param effect_index Index of the effect to be removed.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation_interactive_sequence_effect" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'sequence_index' is set
        if not sequence_index:
            raise ValueError("Missing the required parameter `request.sequence_index` when calling `delete_special_slide_animation_interactive_sequence_effect`")  # noqa: E501
        # verify the required parameter 'effect_index' is set
        if not effect_index:
            raise ValueError("Missing the required parameter `request.effect_index` when calling `delete_special_slide_animation_interactive_sequence_effect`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['sequenceIndex'] = sequence_index  # noqa: E501
        path_params['effectIndex'] = effect_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences/{sequenceIndex}/{effectIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation_interactive_sequences(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear all interactive sequences from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_interactive_sequences_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_interactive_sequences_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_interactive_sequences_with_http_info(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear all interactive sequences from special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_interactive_sequences_with_http_info(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation_interactive_sequences" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation_interactive_sequences`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation_interactive_sequences`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation_interactive_sequences`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/interactiveSequences', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_animation_main_sequence(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear main sequence in special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_animation_main_sequence_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_animation_main_sequence_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_animation_main_sequence_with_http_info(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Clear main sequence in special slide (master, layout, notes) animation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_animation_main_sequence_with_http_info(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_animation_main_sequence" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_animation_main_sequence`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_animation_main_sequence`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_animation_main_sequence`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation/mainSequence', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_paragraph(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_paragraph_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_paragraphs(self, name, slide_index, slide_type, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_paragraphs_with_http_info(self, name, slide_index, slide_type, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if paragraphs:
            query_params.append(('paragraphs', paragraphs))  # noqa: E501
            collection_formats['paragraphs'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_portion(self, name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_portion_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `delete_special_slide_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_portions(self, name, slide_index, slide_type, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_portions_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if portions:
            query_params.append(('portions', portions))  # noqa: E501
            collection_formats['portions'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_shape(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_shape_with_http_info(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_shapes(self, name, slide_index, slide_type, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_shapes_with_http_info(name, slide_index, slide_type, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_shapes_with_http_info(name, slide_index, slide_type, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_shapes_with_http_info(self, name, slide_index, slide_type, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_shapes_with_http_info(name, slide_index, slide_type, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshape(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshape_with_http_info(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshape_paragraph(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshape_paragraph_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshape_paragraphs(self, name, slide_index, slide_type, path, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshape_paragraphs_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshape_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_subshape_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if paragraphs:
            query_params.append(('paragraphs', paragraphs))  # noqa: E501
            collection_formats['paragraphs'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshape_portion(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshape_portion_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `delete_special_slide_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshape_portions(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshape_portions_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshape_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_special_slide_subshape_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if portions:
            query_params.append(('portions', portions))  # noqa: E501
            collection_formats['portions'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_special_slide_subshapes(self, name, slide_index, slide_type, path, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_special_slide_subshapes_with_http_info(self, name, slide_index, slide_type, path, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_special_slide_subshapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `delete_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_special_slide_subshapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshape(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshape_with_http_info(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a shape (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshape_paragraph(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshape_paragraph_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a paragraph (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshape_paragraphs(self, name, slide_index, path, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, paragraphs, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshape_paragraphs_with_http_info(self, name, slide_index, path, shape_index, paragraphs = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of paragraphs (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, paragraphs, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraphs The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshape_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_subshape_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if paragraphs:
            query_params.append(('paragraphs', paragraphs))  # noqa: E501
            collection_formats['paragraphs'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshape_portion(self, name, slide_index, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshape_portion_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a portion (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_subshape_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `delete_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshape_portions(self, name, slide_index, path, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, portions, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshape_portions_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, portions = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of portions (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, portions, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portions The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshape_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshape_portions`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshape_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `delete_subshape_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `delete_subshape_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if portions:
            query_params.append(('portions', portions))  # noqa: E501
            collection_formats['portions'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_subshapes(self, name, slide_index, path, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_subshapes_with_http_info(name, slide_index, path, shapes, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_subshapes_with_http_info(name, slide_index, path, shapes, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_subshapes_with_http_info(self, name, slide_index, path, shapes = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Remove a range of shapes (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_subshapes_with_http_info(name, slide_index, path, shapes, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shapes The indices of the shapes to be deleted; delete all by default.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_subshapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `delete_subshapes`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `delete_subshapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if shapes:
            query_params.append(('shapes', shapes))  # noqa: E501
            collection_formats['shapes'] = ''  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_watermark(self, name, shape_name = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes shapes with name \&quot;watermark\&quot; from the presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, shape_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param shape_name Name of the watermark shape. If null, default value \"watermark\"is used.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_watermark_with_http_info(name, shape_name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_watermark_with_http_info(name, shape_name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def delete_watermark_with_http_info(self, name, shape_name = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Removes shapes with name \&quot;watermark\&quot; from the presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_watermark_with_http_info(name, shape_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param shape_name Name of the watermark shape. If null, default value \"watermark\"is used.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_watermark" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `delete_watermark`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if shape_name:
            query_params.append(('shapeName', shape_name))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/watermark/delete', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_watermark_online(self, document, shape_name = None, password = None, **kwargs):  # noqa: E501
        """Removes shapes with name \&quot;watermark\&quot; from the presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, shape_name, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param shape_name Name of the watermark shape. If null, default value \"watermark\"is used.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.delete_watermark_online_with_http_info(document, shape_name, password, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_watermark_online_with_http_info(document, shape_name, password, **kwargs)  # noqa: E501
            return data

    def delete_watermark_online_with_http_info(self, document, shape_name = None, password = None, **kwargs):  # noqa: E501
        """Removes shapes with name \&quot;watermark\&quot; from the presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.delete_watermark_online_with_http_info(document, shape_name, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param shape_name Name of the watermark shape. If null, default value \"watermark\"is used.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_watermark_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `delete_watermark_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if shape_name:
            query_params.append(('shapeName', shape_name))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/watermark/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_file(self, path, storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/folder/file.ext'
        :param storage_name Storage name
        :param version_id File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_file_with_http_info(path, storage_name, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.download_file_with_http_info(path, storage_name, version_id, **kwargs)  # noqa: E501
            return data

    def download_file_with_http_info(self, path, storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Download file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_file_with_http_info(path, storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/folder/file.ext'
        :param storage_name Storage name
        :param version_id File version ID to download
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `download_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501
        if version_id:
            query_params.append(('versionId', version_id))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/file/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_image(self, name, index, format, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get image in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, index, format, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param index Image index.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_image_with_http_info(name, index, format, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.download_image_with_http_info(name, index, format, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def download_image_with_http_info(self, name, index, format, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get image in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_image_with_http_info(name, index, format, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param index Image index.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_image" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_image`")  # noqa: E501
        # verify the required parameter 'index' is set
        if not index:
            raise ValueError("Missing the required parameter `request.index` when calling `download_image`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_image`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['index'] = index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/images/{index}/{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_image_default_format(self, name, index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get image binary data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param index Image index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_image_default_format_with_http_info(name, index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.download_image_default_format_with_http_info(name, index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def download_image_default_format_with_http_info(self, name, index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get image binary data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_image_default_format_with_http_info(name, index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param index Image index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_image_default_format" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_image_default_format`")  # noqa: E501
        # verify the required parameter 'index' is set
        if not index:
            raise ValueError("Missing the required parameter `request.index` when calling `download_image_default_format`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['index'] = index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/images/{index}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_image_default_format_online(self, document, index, password = None, **kwargs):  # noqa: E501
        """Get image binary data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, index, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param index Image index.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_image_default_format_online_with_http_info(document, index, password, **kwargs)  # noqa: E501
        else:
            (data) = self.download_image_default_format_online_with_http_info(document, index, password, **kwargs)  # noqa: E501
            return data

    def download_image_default_format_online_with_http_info(self, document, index, password = None, **kwargs):  # noqa: E501
        """Get image binary data.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_image_default_format_online_with_http_info(document, index, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param index Image index.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_image_default_format_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_image_default_format_online`")  # noqa: E501
        # verify the required parameter 'index' is set
        if not index:
            raise ValueError("Missing the required parameter `request.index` when calling `download_image_default_format_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['index'] = index  # noqa: E501

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/images/{index}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_image_online(self, document, index, format, password = None, **kwargs):  # noqa: E501
        """Get image in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, index, format, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param index Image index.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_image_online_with_http_info(document, index, format, password, **kwargs)  # noqa: E501
        else:
            (data) = self.download_image_online_with_http_info(document, index, format, password, **kwargs)  # noqa: E501
            return data

    def download_image_online_with_http_info(self, document, index, format, password = None, **kwargs):  # noqa: E501
        """Get image in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_image_online_with_http_info(document, index, format, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param index Image index.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_image_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_image_online`")  # noqa: E501
        # verify the required parameter 'index' is set
        if not index:
            raise ValueError("Missing the required parameter `request.index` when calling `download_image_online`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_image_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['index'] = index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/images/{index}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_images(self, name, format, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get all presentation images in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, format, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name 
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_images_with_http_info(name, format, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.download_images_with_http_info(name, format, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def download_images_with_http_info(self, name, format, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get all presentation images in specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_images_with_http_info(name, format, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name 
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_images`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/images/download/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_images_default_format(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get all presentation images.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name 
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_images_default_format_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.download_images_default_format_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def download_images_default_format_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get all presentation images.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_images_default_format_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name 
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_images_default_format" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_images_default_format`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/images/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_images_default_format_online(self, document, password = None, **kwargs):  # noqa: E501
        """Get all presentation images.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_images_default_format_online_with_http_info(document, password, **kwargs)  # noqa: E501
        else:
            (data) = self.download_images_default_format_online_with_http_info(document, password, **kwargs)  # noqa: E501
            return data

    def download_images_default_format_online_with_http_info(self, document, password = None, **kwargs):  # noqa: E501
        """Get all presentation images.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_images_default_format_online_with_http_info(document, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_images_default_format_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_images_default_format_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/images/download', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_images_online(self, document, format, password = None, **kwargs):  # noqa: E501
        """Get all presentation images in specified format.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, format, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_images_online_with_http_info(document, format, password, **kwargs)  # noqa: E501
        else:
            (data) = self.download_images_online_with_http_info(document, format, password, **kwargs)  # noqa: E501
            return data

    def download_images_online_with_http_info(self, document, format, password = None, **kwargs):  # noqa: E501
        """Get all presentation images in specified format.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_images_online_with_http_info(document, format, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param format Export format (png, jpg, gif).
        :param password Document password.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_images_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_images_online`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_images_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['format'] = format  # noqa: E501

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/images/download/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_notes_slide(self, name, slide_index, format, width = None, height = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Convert notes slide to the specified image format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, format, width, height, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width.
        :param height Output file height.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_notes_slide_with_http_info(name, slide_index, format, width, height, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_notes_slide_with_http_info(name, slide_index, format, width, height, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_notes_slide_with_http_info(self, name, slide_index, format, width = None, height = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Convert notes slide to the specified image format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_notes_slide_with_http_info(name, slide_index, format, width, height, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width.
        :param height Output file height.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_notes_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_notes_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_notes_slide`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_notes_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if width:
            query_params.append(('width', width))  # noqa: E501
        if height:
            query_params.append(('height', height))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/notesSlide/{format}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_notes_slide_online(self, document, slide_index, format, width = None, height = None, password = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Convert notes slide to the specified image format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, format, width, height, password, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width.
        :param height Output file height.
        :param password Document password.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_notes_slide_online_with_http_info(document, slide_index, format, width, height, password, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_notes_slide_online_with_http_info(document, slide_index, format, width, height, password, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_notes_slide_online_with_http_info(self, document, slide_index, format, width = None, height = None, password = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Convert notes slide to the specified image format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_notes_slide_online_with_http_info(document, slide_index, format, width, height, password, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width.
        :param height Output file height.
        :param password Document password.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_notes_slide_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_notes_slide_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_notes_slide_online`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_notes_slide_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if width:
            query_params.append(('width', width))  # noqa: E501
        if height:
            query_params.append(('height', height))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/notesSlide/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_presentation(self, name, format, options = None, password = None, folder = None, storage = None, fonts_folder = None, slides = None, **kwargs):  # noqa: E501
        """Save a presentation to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, format, options, password, folder, storage, fonts_folder, slides, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param format Export format.
        :param options Export options.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be saved. If not specified, all slides are saved by default.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_presentation_with_http_info(name, format, options, password, folder, storage, fonts_folder, slides, **kwargs)  # noqa: E501
        else:
            (data) = self.download_presentation_with_http_info(name, format, options, password, folder, storage, fonts_folder, slides, **kwargs)  # noqa: E501
            return data

    def download_presentation_with_http_info(self, name, format, options = None, password = None, folder = None, storage = None, fonts_folder = None, slides = None, **kwargs):  # noqa: E501
        """Save a presentation to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_presentation_with_http_info(name, format, options, password, folder, storage, fonts_folder, slides, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param format Export format.
        :param options Export options.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Custom fonts folder.
        :param slides The indices of the slides to be saved. If not specified, all slides are saved by default.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_presentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_presentation`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_presentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501
        if slides:
            query_params.append(('slides', slides))  # noqa: E501
            collection_formats['slides'] = ''  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_shape(self, name, slide_index, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Slide index.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_shape_with_http_info(name, slide_index, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_shape_with_http_info(name, slide_index, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_shape_with_http_info(self, name, slide_index, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_shape_with_http_info(name, slide_index, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Slide index.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `download_shape`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if scale_x:
            query_params.append(('scaleX', scale_x))  # noqa: E501
        if scale_y:
            query_params.append(('scaleY', scale_y))  # noqa: E501
        if bounds:
            query_params.append(('bounds', bounds))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_shape_online(self, document, slide_index, shape_index, format, scale_x = None, scale_y = None, bounds = None, password = None, storage = None, fonts_folder = None, options = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, shape_index, format, scale_x, scale_y, bounds, password, storage, fonts_folder, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Fonts folder.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_shape_online_with_http_info(document, slide_index, shape_index, format, scale_x, scale_y, bounds, password, storage, fonts_folder, options, **kwargs)  # noqa: E501
        else:
            (data) = self.download_shape_online_with_http_info(document, slide_index, shape_index, format, scale_x, scale_y, bounds, password, storage, fonts_folder, options, **kwargs)  # noqa: E501
            return data

    def download_shape_online_with_http_info(self, document, slide_index, shape_index, format, scale_x = None, scale_y = None, bounds = None, password = None, storage = None, fonts_folder = None, options = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_shape_online_with_http_info(document, slide_index, shape_index, format, scale_x, scale_y, bounds, password, storage, fonts_folder, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Fonts folder.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_shape_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_shape_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_shape_online`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `download_shape_online`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_shape_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if scale_x:
            query_params.append(('scaleX', scale_x))  # noqa: E501
        if scale_y:
            query_params.append(('scaleY', scale_y))  # noqa: E501
        if bounds:
            query_params.append(('bounds', bounds))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/shapes/{shapeIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_slide(self, name, slide_index, format, options = None, width = None, height = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Save a slide to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, format, options, width, height, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param format Output file format.
        :param options Export options.
        :param width Output file width; 0 to not adjust the size. Default is 0.
        :param height Output file height; 0 to not adjust the size. Default is 0.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_slide_with_http_info(name, slide_index, format, options, width, height, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_slide_with_http_info(name, slide_index, format, options, width, height, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_slide_with_http_info(self, name, slide_index, format, options = None, width = None, height = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Save a slide to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_slide_with_http_info(name, slide_index, format, options, width, height, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param format Output file format.
        :param options Export options.
        :param width Output file width; 0 to not adjust the size. Default is 0.
        :param height Output file height; 0 to not adjust the size. Default is 0.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_slide`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if width:
            query_params.append(('width', width))  # noqa: E501
        if height:
            query_params.append(('height', height))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_slide_online(self, document, slide_index, format, width = None, height = None, password = None, storage = None, fonts_folder = None, options = None, **kwargs):  # noqa: E501
        """Save a slide to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, format, width, height, password, storage, fonts_folder, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width; 0 to not adjust the size. Default is 0.
        :param height Output file height; 0 to not adjust the size. Default is 0.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_slide_online_with_http_info(document, slide_index, format, width, height, password, storage, fonts_folder, options, **kwargs)  # noqa: E501
        else:
            (data) = self.download_slide_online_with_http_info(document, slide_index, format, width, height, password, storage, fonts_folder, options, **kwargs)  # noqa: E501
            return data

    def download_slide_online_with_http_info(self, document, slide_index, format, width = None, height = None, password = None, storage = None, fonts_folder = None, options = None, **kwargs):  # noqa: E501
        """Save a slide to a specified format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_slide_online_with_http_info(document, slide_index, format, width, height, password, storage, fonts_folder, options, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param format Output file format.
        :param width Output file width; 0 to not adjust the size. Default is 0.
        :param height Output file height; 0 to not adjust the size. Default is 0.
        :param password Document password.
        :param storage Document storage.
        :param fonts_folder Storage folder containing custom fonts to be used with the document.
        :param options Export options.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_slide_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `download_slide_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_slide_online`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_slide_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if width:
            query_params.append(('width', width))  # noqa: E501
        if height:
            query_params.append(('height', height))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_special_slide_shape(self, name, slide_index, slide_type, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options Export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_special_slide_shape_with_http_info(self, name, slide_index, slide_type, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options Export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_special_slide_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `download_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `download_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_special_slide_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if scale_x:
            query_params.append(('scaleX', scale_x))  # noqa: E501
        if scale_y:
            query_params.append(('scaleY', scale_y))  # noqa: E501
        if bounds:
            query_params.append(('bounds', bounds))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_special_slide_subshape(self, name, slide_index, slide_type, path, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_special_slide_subshape_with_http_info(self, name, slide_index, slide_type, path, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_special_slide_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `download_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `download_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `download_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_special_slide_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if scale_x:
            query_params.append(('scaleX', scale_x))  # noqa: E501
        if scale_y:
            query_params.append(('scaleY', scale_y))  # noqa: E501
        if bounds:
            query_params.append(('bounds', bounds))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def download_subshape(self, name, slide_index, path, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.download_subshape_with_http_info(name, slide_index, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
        else:
            (data) = self.download_subshape_with_http_info(name, slide_index, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, **kwargs)  # noqa: E501
            return data

    def download_subshape_with_http_info(self, name, slide_index, path, shape_index, format, options = None, scale_x = None, scale_y = None, bounds = None, password = None, folder = None, storage = None, fonts_folder = None, **kwargs):  # noqa: E501
        """Render shape to specified picture format (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.download_subshape_with_http_info(name, slide_index, path, shape_index, format, options, scale_x, scale_y, bounds, password, folder, storage, fonts_folder, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Presentation name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Index of shape starting from 1
        :param format Export picture format.
        :param options export options
        :param scale_x X scale ratio.
        :param scale_y Y scale ratio.
        :param bounds Shape thumbnail bounds type.
        :param password Document password.
        :param folder Presentation folder.
        :param storage Presentation storage.
        :param fonts_folder Fonts folder.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method download_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `download_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `download_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `download_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `download_subshape`")  # noqa: E501
        # verify the required parameter 'format' is set
        if not format:
            raise ValueError("Missing the required parameter `request.format` when calling `download_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['format'] = format  # noqa: E501

        query_params = []
        if scale_x:
            query_params.append(('scaleX', scale_x))  # noqa: E501
        if scale_y:
            query_params.append(('scaleY', scale_y))  # noqa: E501
        if bounds:
            query_params.append(('bounds', bounds))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501
        if fonts_folder:
            query_params.append(('fontsFolder', fonts_folder))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if options:
            body_params = options

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/{format}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_animation(self, name, slide_index, shape_index = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide animation effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index. If specified, only effects related to that shape are returned.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_animation_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_animation_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_animation_with_http_info(self, name, slide_index, shape_index = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide animation effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_animation_with_http_info(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index. If specified, only effects related to that shape are returned.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_animation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_animation`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_animation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if shape_index:
            query_params.append(('shapeIndex', shape_index))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/animation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_api_info(self, **kwargs):  # noqa: E501
        """Get API info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :return: ApiInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_api_info_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_api_info_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_api_info_with_http_info(self, **kwargs):  # noqa: E501
        """Get API info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_api_info_with_http_info(is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :return: ApiInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_api_info" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/info', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ApiInfo',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_background(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide background info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideBackground
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_background_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_background_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_background_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide background info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_background_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideBackground
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_background" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_background`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_background`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/background', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideBackground',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_color_scheme(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme color scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ColorScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_color_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_color_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_color_scheme_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme color scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_color_scheme_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ColorScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_color_scheme" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_color_scheme`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_color_scheme`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/theme/colorScheme', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ColorScheme',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_disc_usage(self, storage_name = None, **kwargs):  # noqa: E501
        """Get disc usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param storage_name Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_disc_usage_with_http_info(storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_disc_usage_with_http_info(storage_name, **kwargs)  # noqa: E501
            return data

    def get_disc_usage_with_http_info(self, storage_name = None, **kwargs):  # noqa: E501
        """Get disc usage  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_disc_usage_with_http_info(storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param storage_name Storage name
        :return: DiscUsage
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_disc_usage" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/disc', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='DiscUsage',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document_properties(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_document_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_document_properties_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_document_properties_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_document_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/documentproperties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='DocumentProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_document_property(self, name, property_name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document property.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, property_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param property_name The property name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_document_property_with_http_info(name, property_name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_document_property_with_http_info(name, property_name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_document_property_with_http_info(self, name, property_name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document property.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_document_property_with_http_info(name, property_name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param property_name The property name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: DocumentProperty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_document_property" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_document_property`")  # noqa: E501
        # verify the required parameter 'property_name' is set
        if not property_name:
            raise ValueError("Missing the required parameter `request.property_name` when calling `get_document_property`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['propertyName'] = property_name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/documentproperties/{propertyName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='DocumentProperty',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_file_versions(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Get file versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/file.ext'
        :param storage_name Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_file_versions_with_http_info(path, storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_versions_with_http_info(path, storage_name, **kwargs)  # noqa: E501
            return data

    def get_file_versions_with_http_info(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Get file versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_file_versions_with_http_info(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path File path e.g. '/file.ext'
        :param storage_name Storage name
        :return: FileVersions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file_versions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_file_versions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/version/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='FileVersions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_files_list(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Get all files and folders within a folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path e.g. '/folder'
        :param storage_name Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_files_list_with_http_info(path, storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_files_list_with_http_info(path, storage_name, **kwargs)  # noqa: E501
            return data

    def get_files_list_with_http_info(self, path, storage_name = None, **kwargs):  # noqa: E501
        """Get all files and folders within a folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_files_list_with_http_info(path, storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param path Folder path e.g. '/folder'
        :param storage_name Storage name
        :return: FilesList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_files_list" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_files_list`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['path'] = path  # noqa: E501

        query_params = []
        if storage_name:
            query_params.append(('storageName', storage_name))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/folder/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='FilesList',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_font_scheme(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme font scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: FontScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_font_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_font_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_font_scheme_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme font scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_font_scheme_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: FontScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_font_scheme" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_font_scheme`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_font_scheme`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/theme/fontScheme', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='FontScheme',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_format_scheme(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme format scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: FormatScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_format_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_format_scheme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_format_scheme_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme format scheme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_format_scheme_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: FormatScheme
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_format_scheme" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_format_scheme`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_format_scheme`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/theme/formatScheme', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='FormatScheme',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_layout_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation layoutSlide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_layout_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_layout_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_layout_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation layoutSlide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_layout_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_layout_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_layout_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_layout_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/layoutSlides/{slideIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='LayoutSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_layout_slides(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation layoutSlides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_layout_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_layout_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_layout_slides_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation layoutSlides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_layout_slides_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: LayoutSlides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_layout_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_layout_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/layoutSlides', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='LayoutSlides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_master_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation masterSlide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_master_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_master_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_master_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation masterSlide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_master_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_master_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_master_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_master_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/masterSlides/{slideIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='MasterSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_master_slides(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation masterSlides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_master_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_master_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_master_slides_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation masterSlides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_master_slides_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: MasterSlides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_master_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_master_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/masterSlides', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='MasterSlides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notes_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read notes slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_notes_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notes_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_notes_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read notes slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_notes_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notes_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_notes_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_notes_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/notesSlide', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='NotesSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notes_slide_header_footer(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get header/footer info for the notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlideHeaderFooter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_notes_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notes_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_notes_slide_header_footer_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get header/footer info for the notes slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_notes_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: NotesSlideHeaderFooter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notes_slide_header_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_notes_slide_header_footer`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_notes_slide_header_footer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/notesSlide/headerFooter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='NotesSlideHeaderFooter',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_notes_slide_online(self, document, slide_index, password = None, **kwargs):  # noqa: E501
        """Read notes slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(document, slide_index, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param password Document password.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_notes_slide_online_with_http_info(document, slide_index, password, **kwargs)  # noqa: E501
        else:
            (data) = self.get_notes_slide_online_with_http_info(document, slide_index, password, **kwargs)  # noqa: E501
            return data

    def get_notes_slide_online_with_http_info(self, document, slide_index, password = None, **kwargs):  # noqa: E501
        """Read notes slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_notes_slide_online_with_http_info(document, slide_index, password, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param document Document data.
        :param slide_index Slide index.
        :param password Document password.
        :return: NotesSlide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_notes_slide_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'document' is set
        if not document:
            raise ValueError("Missing the required parameter `request.document` when calling `get_notes_slide_online`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_notes_slide_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if document:
            param_files['document'] = document  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/slides/{slideIndex}/notesSlide', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='NotesSlide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_paragraph(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_paragraph_with_http_info(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_paragraph_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_paragraphs(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_paragraphs_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_paragraphs_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_paragraphs_with_http_info(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_paragraphs_with_http_info(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_placeholder(self, name, slide_index, placeholder_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide placeholder info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, placeholder_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param placeholder_index Placeholder index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Placeholder
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_placeholder_with_http_info(name, slide_index, placeholder_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_placeholder_with_http_info(name, slide_index, placeholder_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_placeholder_with_http_info(self, name, slide_index, placeholder_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide placeholder info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_placeholder_with_http_info(name, slide_index, placeholder_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param placeholder_index Placeholder index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Placeholder
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_placeholder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_placeholder`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_placeholder`")  # noqa: E501
        # verify the required parameter 'placeholder_index' is set
        if not placeholder_index:
            raise ValueError("Missing the required parameter `request.placeholder_index` when calling `get_placeholder`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['placeholderIndex'] = placeholder_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/placeholders/{placeholderIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Placeholder',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_placeholders(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide placeholders info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Placeholders
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_placeholders_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_placeholders_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_placeholders_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide placeholders info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_placeholders_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Placeholders
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_placeholders" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_placeholders`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_placeholders`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/placeholders', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Placeholders',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portion(self, name, slide_index, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_portion_with_http_info(self, name, slide_index, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_portion_with_http_info(name, slide_index, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `get_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_portions(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_portions_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_portions_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_portions_with_http_info(self, name, slide_index, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_portions_with_http_info(name, slide_index, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_presentation(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_presentation_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_presentation_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_presentation_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_presentation_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_presentation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_presentation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_presentation_images(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation images info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_presentation_images_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_presentation_images_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_presentation_images_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation images info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_presentation_images_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_presentation_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_presentation_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/images', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Images',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_presentation_text_items(self, name, with_empty = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Extract presentation text items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, with_empty, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param with_empty True to incude empty items.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: TextItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_presentation_text_items_with_http_info(name, with_empty, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_presentation_text_items_with_http_info(name, with_empty, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_presentation_text_items_with_http_info(self, name, with_empty = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Extract presentation text items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_presentation_text_items_with_http_info(name, with_empty, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param with_empty True to incude empty items.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: TextItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_presentation_text_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_presentation_text_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if with_empty:
            query_params.append(('withEmpty', with_empty))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/textItems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='TextItems',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_protection_properties(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation protection properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ProtectionProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_protection_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_protection_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_protection_properties_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation protection properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_protection_properties_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ProtectionProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_protection_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_protection_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/protection', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ProtectionProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_sections(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation sections info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_sections_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_sections_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_sections_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation sections info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_sections_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Sections
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_sections" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_sections`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/sections', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Sections',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shape(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shape info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_shape_with_http_info(self, name, slide_index, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shape info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_shape_with_http_info(name, slide_index, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{shapeIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_shapes(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_shapes_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_shapes_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_shapes_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_shapes_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_slide`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slide',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide_comments(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide comments.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_comments_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_comments_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_comments_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide comments.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_comments_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideComments
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide_comments" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide_comments`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_slide_comments`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/comments', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideComments',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide_header_footer(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get footer info for the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index The position of the slide to be reordered.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: HeaderFooter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_header_footer_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Get footer info for the slide.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_header_footer_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index The position of the slide to be reordered.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: HeaderFooter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide_header_footer" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide_header_footer`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_slide_header_footer`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/headerFooter', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='HeaderFooter',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide_images(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide images info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_images_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_images_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_images_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide images info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_images_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Images
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide_images" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide_images`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_slide_images`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/images', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Images',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide_properties(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_properties_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slide properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_properties_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slideProperties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slide_text_items(self, name, slide_index, with_empty = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Extract slide text items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, with_empty, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param with_empty True to include empty items.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: TextItems
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slide_text_items_with_http_info(name, slide_index, with_empty, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slide_text_items_with_http_info(name, slide_index, with_empty, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slide_text_items_with_http_info(self, name, slide_index, with_empty = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Extract slide text items.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slide_text_items_with_http_info(name, slide_index, with_empty, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param with_empty True to include empty items.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: TextItems
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slide_text_items" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slide_text_items`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_slide_text_items`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if with_empty:
            query_params.append(('withEmpty', with_empty))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/textItems', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='TextItems',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_slides(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_slides_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_slides_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation slides info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_slides_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Slides
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_slides" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_slides`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Slides',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_animation(self, name, slide_index, slide_type, shape_index = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide (master, layout, notes) animation effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index. If specified, only effects related to that shape are returned.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_animation_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_animation_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_animation_with_http_info(self, name, slide_index, slide_type, shape_index = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide (master, layout, notes) animation effects.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_animation_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index. If specified, only effects related to that shape are returned.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: SlideAnimation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_animation" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_animation`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_animation`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_animation`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if shape_index:
            query_params.append(('shapeIndex', shape_index))  # noqa: E501
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/animation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='SlideAnimation',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_paragraph(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_paragraph_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_paragraph_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_paragraphs(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special shape paragraphs info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_paragraphs_with_http_info(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special shape paragraphs info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_paragraphs_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_portion(self, name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_portion_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_portion_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `get_special_slide_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_portions(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_portions_with_http_info(self, name, slide_index, slide_type, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_portions_with_http_info(name, slide_index, slide_type, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_shape(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shape info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_shape_with_http_info(self, name, slide_index, slide_type, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shape info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_shape_with_http_info(name, slide_index, slide_type, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_shape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_shape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_shape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{shapeIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_shapes(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_shapes_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_shapes_with_http_info(name, slide_index, slide_type, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_shapes_with_http_info(self, name, slide_index, slide_type, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_shapes_with_http_info(name, slide_index, slide_type, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_shapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_shapes`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_shapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshape(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shape info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshape_with_http_info(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shape info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshape_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshape_paragraph(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshape_paragraph_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshape_paragraph_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshape_paragraphs(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshape_paragraphs_with_http_info(self, name, slide_index, slide_type, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshape_paragraphs_with_http_info(name, slide_index, slide_type, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshape_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_subshape_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshape_portion(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshape_portion_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshape_portion_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_subshape_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `get_special_slide_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshape_portions(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshape_portions_with_http_info(self, name, slide_index, slide_type, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshape_portions_with_http_info(name, slide_index, slide_type, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshape_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_special_slide_subshape_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_special_slide_subshape_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_special_slide_subshapes(self, name, slide_index, slide_type, path, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, slide_type, path, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path (for smart art and group shapes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_special_slide_subshapes_with_http_info(self, name, slide_index, slide_type, path, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read special slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_special_slide_subshapes_with_http_info(name, slide_index, slide_type, path, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Parent slide index.
        :param slide_type Slide type (master, layout or notes).
        :param path Shape path (for smart art and group shapes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_special_slide_subshapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_type' is set
        if not slide_type:
            raise ValueError("Missing the required parameter `request.slide_type` when calling `get_special_slide_subshapes`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_special_slide_subshapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['slideType'] = slide_type  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/{slideType}/shapes/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshape(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shape info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshape_with_http_info(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shape info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshape_with_http_info(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ShapeBase
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshape" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshape`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshape`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshape`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_subshape`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ShapeBase',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshape_paragraph(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshape_paragraph_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraph info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshape_paragraph_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraph
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshape_paragraph" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_subshape_paragraph`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_subshape_paragraph`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraph',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshape_paragraphs(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshape_paragraphs_with_http_info(self, name, slide_index, path, shape_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read shape paragraphs info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshape_paragraphs_with_http_info(name, slide_index, path, shape_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Paragraphs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshape_paragraphs" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshape_paragraphs`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_subshape_paragraphs`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Paragraphs',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshape_portion(self, name, slide_index, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshape_portion_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, portion_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portion info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshape_portion_with_http_info(name, slide_index, path, shape_index, paragraph_index, portion_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param portion_index Portion index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshape_portion" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshape_portion`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshape_portion`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshape_portion`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_subshape_portion`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_subshape_portion`")  # noqa: E501
        # verify the required parameter 'portion_index' is set
        if not portion_index:
            raise ValueError("Missing the required parameter `request.portion_index` when calling `get_subshape_portion`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501
        path_params['portionIndex'] = portion_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions/{portionIndex}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portion',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshape_portions(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshape_portions_with_http_info(self, name, slide_index, path, shape_index, paragraph_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read paragraph portions info (for smart art and group shapes).  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshape_portions_with_http_info(name, slide_index, path, shape_index, paragraph_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path.
        :param shape_index Shape index.
        :param paragraph_index Paragraph index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Portions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshape_portions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshape_portions`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshape_portions`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshape_portions`")  # noqa: E501
        # verify the required parameter 'shape_index' is set
        if not shape_index:
            raise ValueError("Missing the required parameter `request.shape_index` when calling `get_subshape_portions`")  # noqa: E501
        # verify the required parameter 'paragraph_index' is set
        if not paragraph_index:
            raise ValueError("Missing the required parameter `request.paragraph_index` when calling `get_subshape_portions`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501
        path_params['shapeIndex'] = shape_index  # noqa: E501
        path_params['paragraphIndex'] = paragraph_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}/{shapeIndex}/paragraphs/{paragraphIndex}/portions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Portions',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_subshapes(self, name, slide_index, path, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, path, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path (for smart art and group shapes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_subshapes_with_http_info(name, slide_index, path, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_subshapes_with_http_info(name, slide_index, path, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_subshapes_with_http_info(self, name, slide_index, path, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide shapes info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_subshapes_with_http_info(name, slide_index, path, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param path Shape path (for smart art and group shapes).
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Shapes
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_subshapes" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_subshapes`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_subshapes`")  # noqa: E501
        # verify the required parameter 'path' is set
        if not path:
            raise ValueError("Missing the required parameter `request.path` when calling `get_subshapes`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501
        path_params['path'] = path  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/shapes/{path}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Shapes',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_theme(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Theme
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_theme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_theme_with_http_info(name, slide_index, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_theme_with_http_info(self, name, slide_index, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read slide theme info.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_theme_with_http_info(name, slide_index, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param slide_index Slide index.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Theme
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_theme" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_theme`")  # noqa: E501
        # verify the required parameter 'slide_index' is set
        if not slide_index:
            raise ValueError("Missing the required parameter `request.slide_index` when calling `get_theme`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501
        path_params['slideIndex'] = slide_index  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/slides/{slideIndex}/theme', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Theme',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_view_properties(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ViewProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.get_view_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.get_view_properties_with_http_info(name, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def get_view_properties_with_http_info(self, name, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Read presentation document properties.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.get_view_properties_with_http_info(name, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: ViewProperties
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_view_properties" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `get_view_properties`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/viewProperties', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='ViewProperties',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_from_html(self, name, html = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create presentation document from html.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, html, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param html HTML data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.import_from_html_with_http_info(name, html, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.import_from_html_with_http_info(name, html, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def import_from_html_with_http_info(self, name, html = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create presentation document from html.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.import_from_html_with_http_info(name, html, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param html HTML data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_from_html" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `import_from_html`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if html:
            body_params = html

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/fromHtml', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def import_from_pdf(self, name, pdf = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create presentation document from pdf or append pdf to an existing presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, pdf, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param pdf PDF data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.import_from_pdf_with_http_info(name, pdf, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.import_from_pdf_with_http_info(name, pdf, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def import_from_pdf_with_http_info(self, name, pdf = None, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Create presentation document from pdf or append pdf to an existing presentation.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.import_from_pdf_with_http_info(name, pdf, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param pdf PDF data.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method import_from_pdf" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `import_from_pdf`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}
        if pdf:
            param_files['pdf'] = pdf  # noqa: E501

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/fromPdf', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def merge(self, name, request, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Merge the presentation with other presentations specified in the request parameter.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(name, request, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param request PresentationsMergeRequest with a list of presentations to merge.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.merge_with_http_info(name, request, password, folder, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.merge_with_http_info(name, request, password, folder, storage, **kwargs)  # noqa: E501
            return data

    def merge_with_http_info(self, name, request, password = None, folder = None, storage = None, **kwargs):  # noqa: E501
        """Merge the presentation with other presentations specified in the request parameter.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.merge_with_http_info(name, request, password, folder, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param name Document name.
        :param request PresentationsMergeRequest with a list of presentations to merge.
        :param password Document password.
        :param folder Document folder.
        :param storage Document storage.
        :return: Document
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'name' is set
        if not name:
            raise ValueError("Missing the required parameter `request.name` when calling `merge`")  # noqa: E501
        # verify the required parameter 'request' is set
        if not request:
            raise ValueError("Missing the required parameter `request.request` when calling `merge`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['name'] = name  # noqa: E501

        query_params = []
        if folder:
            query_params.append(('folder', folder))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}
        if password:
            header_params['password'] = password  # noqa: E501

        form_params = []
        param_files = {}

        body_params = None
        if request:
            body_params = request

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/{name}/merge', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='Document',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def merge_and_save_online(self, out_path, files = None, request = None, storage = None, **kwargs):  # noqa: E501
        """Merges presentations or some of their slides specified in the request parameter. Result will be save in the storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(out_path, files, request, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param out_path Path to save result.
        :param files Files to merge
        :param request Merge request.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.merge_and_save_online_with_http_info(out_path, files, request, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.merge_and_save_online_with_http_info(out_path, files, request, storage, **kwargs)  # noqa: E501
            return data

    def merge_and_save_online_with_http_info(self, out_path, files = None, request = None, storage = None, **kwargs):  # noqa: E501
        """Merges presentations or some of their slides specified in the request parameter. Result will be save in the storage.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.merge_and_save_online_with_http_info(out_path, files, request, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param out_path Path to save result.
        :param files Files to merge
        :param request Merge request.
        :param storage Document storage.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_and_save_online" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'out_path' is set
        if not out_path:
            raise ValueError("Missing the required parameter `request.out_path` when calling `merge_and_save_online`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if out_path:
            query_params.append(('outPath', out_path))  # noqa: E501
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}
        param_files = files

        body_params = None
        if request:
            body_params = request

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/merge', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def merge_online(self, files = None, request = None, storage = None, **kwargs):  # noqa: E501
        """Merges presentations or some of their slides specified in the request parameter. Returns result file in the response.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(files, request, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param files Files to merge
        :param request Merge request.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.merge_online_with_http_info(files, request, storage, **kwargs)  # noqa: E501
        else:
            (data) = self.merge_online_with_http_info(files, request, storage, **kwargs)  # noqa: E501
            return data

    def merge_online_with_http_info(self, files = None, request = None, storage = None, **kwargs):  # noqa: E501
        """Merges presentations or some of their slides specified in the request parameter. Returns result file in the response.   # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.merge_online_with_http_info(files, request, storage, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param files Files to merge
        :param request Merge request.
        :param storage Document storage.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method merge_online" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if storage:
            query_params.append(('storage', storage))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}
        param_files = files

        body_params = None
        if request:
            body_params = request

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['multipart/form-data'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/merge', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_file(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Move file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(src_path, dest_path, src_storage_name, dest_storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source file path e.g. '/src.ext'
        :param dest_path Destination file path e.g. '/dest.ext'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :param version_id File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.move_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.move_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, **kwargs)  # noqa: E501
            return data

    def move_file_with_http_info(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, version_id = None, **kwargs):  # noqa: E501
        """Move file  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.move_file_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, version_id, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Source file path e.g. '/src.ext'
        :param dest_path Destination file path e.g. '/dest.ext'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :param version_id File version ID to move
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if not src_path:
            raise ValueError("Missing the required parameter `request.src_path` when calling `move_file`")  # noqa: E501
        # verify the required parameter 'dest_path' is set
        if not dest_path:
            raise ValueError("Missing the required parameter `request.dest_path` when calling `move_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        path_params['srcPath'] = src_path  # noqa: E501

        query_params = []
        if dest_path:
            query_params.append(('destPath', dest_path))  # noqa: E501
        if src_storage_name:
            query_params.append(('srcStorageName', src_storage_name))  # noqa: E501
        if dest_storage_name:
            query_params.append(('destStorageName', dest_storage_name))  # noqa: E501
        if version_id:
            query_params.append(('versionId', version_id))  # noqa: E501

        header_params = {}

        form_params = []
        param_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['JWT']  # noqa: E501

        return self.api_client.call_api(
            '/slides/storage/file/move/{srcPath}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=param_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            is_async=params.get('is_async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def move_folder(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, **kwargs):  # noqa: E501
        """Move folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.(src_path, dest_path, src_storage_name, dest_storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Folder path to move e.g. '/folder'
        :param dest_path Destination folder path to move to e.g '/dst'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('is_async'):
            return self.move_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, **kwargs)  # noqa: E501
        else:
            (data) = self.move_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, **kwargs)  # noqa: E501
            return data

    def move_folder_with_http_info(self, src_path, dest_path, src_storage_name = None, dest_storage_name = None, **kwargs):  # noqa: E501
        """Move folder  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass is_async=True
        >>> thread = api.move_folder_with_http_info(src_path, dest_path, src_storage_name, dest_storage_name, is_async=True)
        >>> result = thread.get()

        :param is_async bool
        :param src_path Folder path to move e.g. '/folder'
        :param dest_path Destination folder path to move to e.g '/dst'
        :param src_storage_name Source storage name
        :param dest_storage_name Destination storage name
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('is_async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method move_folder" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'src_path' is set
        if not src_path:
            r