# coding: utf-8

# -----------------------------------------------------------------------------------
# <copyright company="Aspose">
#   Copyright (c) 2018 Aspose.Slides for Cloud
# </copyright>
# <summary>
#   Permission is hereby granted, free of charge, to any person obtaining a copy
#  of this software and associated documentation files (the "Software"), to deal
#  in the Software without restriction, including without limitation the rights
#  to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#  copies of the Software, and to permit persons to whom the Software is
#  furnished to do so, subject to the following conditions:
#
#  The above copyright notice and this permission notice shall be included in all
#  copies or substantial portions of the Software.
#
#  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#  AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#  OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#  SOFTWARE.
# </summary>
# -----------------------------------------------------------------------------------

import pprint
import re  # noqa: F401

import six


class SlideComment(object):


    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'author': 'str',
        'text': 'str',
        'created_time': 'str',
        'child_comments': 'list[SlideComment]'
    }

    attribute_map = {
        'author': 'author',
        'text': 'text',
        'created_time': 'createdTime',
        'child_comments': 'childComments'
    }

    type_determiners = {
    }

    def __init__(self, author=None, text=None, created_time=None, child_comments=None):  # noqa: E501
        """SlideComment - a model defined in Swagger"""  # noqa: E501

        self._author = None
        self._text = None
        self._created_time = None
        self._child_comments = None

        if author is not None:
            self.author = author
        if text is not None:
            self.text = text
        if created_time is not None:
            self.created_time = created_time
        if child_comments is not None:
            self.child_comments = child_comments

    @property
    def author(self):
        """Gets the author of this SlideComment.  # noqa: E501

        Author.  # noqa: E501

        :return: The author of this SlideComment.  # noqa: E501
        :rtype: str
        """
        return self._author

    @author.setter
    def author(self, author):
        """Sets the author of this SlideComment.

        Author.  # noqa: E501

        :param author: The author of this SlideComment.  # noqa: E501
        :type: str
        """
        self._author = author

    @property
    def text(self):
        """Gets the text of this SlideComment.  # noqa: E501

        Text.  # noqa: E501

        :return: The text of this SlideComment.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this SlideComment.

        Text.  # noqa: E501

        :param text: The text of this SlideComment.  # noqa: E501
        :type: str
        """
        self._text = text

    @property
    def created_time(self):
        """Gets the created_time of this SlideComment.  # noqa: E501

        Creation time.  # noqa: E501

        :return: The created_time of this SlideComment.  # noqa: E501
        :rtype: str
        """
        return self._created_time

    @created_time.setter
    def created_time(self, created_time):
        """Sets the created_time of this SlideComment.

        Creation time.  # noqa: E501

        :param created_time: The created_time of this SlideComment.  # noqa: E501
        :type: str
        """
        self._created_time = created_time

    @property
    def child_comments(self):
        """Gets the child_comments of this SlideComment.  # noqa: E501

        Child comments.  # noqa: E501

        :return: The child_comments of this SlideComment.  # noqa: E501
        :rtype: list[SlideComment]
        """
        return self._child_comments

    @child_comments.setter
    def child_comments(self, child_comments):
        """Sets the child_comments of this SlideComment.

        Child comments.  # noqa: E501

        :param child_comments: The child_comments of this SlideComment.  # noqa: E501
        :type: list[SlideComment]
        """
        self._child_comments = child_comments

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, SlideComment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
