"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Elasticbeanstalk = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const shared_1 = require("../shared");
/**
 * Statement provider for service [elasticbeanstalk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticbeanstalk.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Elasticbeanstalk extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [elasticbeanstalk](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awselasticbeanstalk.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'elasticbeanstalk';
        this.accessLevelList = {
            Write: [
                'AbortEnvironmentUpdate',
                'ApplyEnvironmentManagedAction',
                'AssociateEnvironmentOperationsRole',
                'ComposeEnvironments',
                'CreateApplication',
                'CreateApplicationVersion',
                'CreateConfigurationTemplate',
                'CreateEnvironment',
                'CreatePlatformVersion',
                'CreateStorageLocation',
                'DeleteApplication',
                'DeleteApplicationVersion',
                'DeleteConfigurationTemplate',
                'DeleteEnvironmentConfiguration',
                'DeletePlatformVersion',
                'DisassociateEnvironmentOperationsRole',
                'PutInstanceStatistics',
                'RebuildEnvironment',
                'RestartAppServer',
                'SwapEnvironmentCNAMEs',
                'TerminateEnvironment',
                'UpdateApplication',
                'UpdateApplicationResourceLifecycle',
                'UpdateApplicationVersion',
                'UpdateConfigurationTemplate',
                'UpdateEnvironment'
            ],
            Tagging: [
                'AddTags',
                'RemoveTags',
                'UpdateTagsForResource'
            ],
            Read: [
                'CheckDNSAvailability',
                'DescribeAccountAttributes',
                'DescribeConfigurationOptions',
                'DescribeConfigurationSettings',
                'DescribeEnvironmentHealth',
                'DescribeEnvironmentManagedActionHistory',
                'DescribeEnvironmentManagedActions',
                'DescribeEnvironmentResources',
                'DescribeEvents',
                'DescribeInstancesHealth',
                'DescribePlatformVersion',
                'ListTagsForResource',
                'RequestEnvironmentInfo',
                'RetrieveEnvironmentInfo',
                'ValidateConfigurationSettings'
            ],
            List: [
                'DescribeApplicationVersions',
                'DescribeApplications',
                'DescribeEnvironments',
                'ListAvailableSolutionStacks',
                'ListPlatformBranches',
                'ListPlatformVersions'
            ]
        };
    }
    /**
     * Grants permission to cancel in-progress environment configuration update or application version deployment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_AbortEnvironmentUpdate.html
     */
    toAbortEnvironmentUpdate() {
        return this.to('AbortEnvironmentUpdate');
    }
    /**
     * Grants permission to add tags to an Elastic Beanstalk resource and to update tag values
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     */
    toAddTags() {
        return this.to('AddTags');
    }
    /**
     * Grants permission to apply a scheduled managed action immediately
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ApplyEnvironmentManagedAction.html
     */
    toApplyEnvironmentManagedAction() {
        return this.to('ApplyEnvironmentManagedAction');
    }
    /**
     * Grants permission to associate an operations role with an environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_AssociateEnvironmentOperationsRole.html
     */
    toAssociateEnvironmentOperationsRole() {
        return this.to('AssociateEnvironmentOperationsRole');
    }
    /**
     * Grants permission to check CNAME availability
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CheckDNSAvailability.html
     */
    toCheckDNSAvailability() {
        return this.to('CheckDNSAvailability');
    }
    /**
     * Grants permission to create or update a group of environments, each running a separate component of a single application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ComposeEnvironments.html
     */
    toComposeEnvironments() {
        return this.to('ComposeEnvironments');
    }
    /**
     * Grants permission to create a new application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateApplication.html
     */
    toCreateApplication() {
        return this.to('CreateApplication');
    }
    /**
     * Grants permission to create an application version for an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateApplicationVersion.html
     */
    toCreateApplicationVersion() {
        return this.to('CreateApplicationVersion');
    }
    /**
     * Grants permission to create a configuration template
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplication()
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromEnvironment()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateConfigurationTemplate.html
     */
    toCreateConfigurationTemplate() {
        return this.to('CreateConfigurationTemplate');
    }
    /**
     * Grants permission to launch an environment for an application
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateEnvironment.html
     */
    toCreateEnvironment() {
        return this.to('CreateEnvironment');
    }
    /**
     * Grants permission to create a new version of a custom platform
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreatePlatformVersion.html
     */
    toCreatePlatformVersion() {
        return this.to('CreatePlatformVersion');
    }
    /**
     * Grants permission to create the Amazon S3 storage location for the account
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_CreateStorageLocation.html
     */
    toCreateStorageLocation() {
        return this.to('CreateStorageLocation');
    }
    /**
     * Grants permission to delete an application along with all associated versions and configurations
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteApplication.html
     */
    toDeleteApplication() {
        return this.to('DeleteApplication');
    }
    /**
     * Grants permission to delete an application version from an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteApplicationVersion.html
     */
    toDeleteApplicationVersion() {
        return this.to('DeleteApplicationVersion');
    }
    /**
     * Grants permission to delete a configuration template
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteConfigurationTemplate.html
     */
    toDeleteConfigurationTemplate() {
        return this.to('DeleteConfigurationTemplate');
    }
    /**
     * Grants permission to delete the draft configuration associated with the running environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeleteEnvironmentConfiguration.html
     */
    toDeleteEnvironmentConfiguration() {
        return this.to('DeleteEnvironmentConfiguration');
    }
    /**
     * Grants permission to delete a version of a custom platform
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DeletePlatformVersion.html
     */
    toDeletePlatformVersion() {
        return this.to('DeletePlatformVersion');
    }
    /**
     * Grants permission to retrieve a list of account attributes, including resource quotas
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeAccountAttributes.html
     */
    toDescribeAccountAttributes() {
        return this.to('DescribeAccountAttributes');
    }
    /**
     * Grants permission to retrieve a list of application versions stored in an AWS Elastic Beanstalk storage bucket
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeApplicationVersions.html
     */
    toDescribeApplicationVersions() {
        return this.to('DescribeApplicationVersions');
    }
    /**
     * Grants permission to retrieve the descriptions of existing applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeApplications.html
     */
    toDescribeApplications() {
        return this.to('DescribeApplications');
    }
    /**
     * Grants permission to retrieve descriptions of environment configuration options
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeConfigurationOptions.html
     */
    toDescribeConfigurationOptions() {
        return this.to('DescribeConfigurationOptions');
    }
    /**
     * Grants permission to retrieve a description of the settings for a configuration set
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeConfigurationSettings.html
     */
    toDescribeConfigurationSettings() {
        return this.to('DescribeConfigurationSettings');
    }
    /**
     * Grants permission to retrieve information about the overall health of an environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentHealth.html
     */
    toDescribeEnvironmentHealth() {
        return this.to('DescribeEnvironmentHealth');
    }
    /**
     * Grants permission to retrieve a list of an environment's completed and failed managed actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentManagedActionHistory.html
     */
    toDescribeEnvironmentManagedActionHistory() {
        return this.to('DescribeEnvironmentManagedActionHistory');
    }
    /**
     * Grants permission to retrieve a list of an environment's upcoming and in-progress managed actions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentManagedActions.html
     */
    toDescribeEnvironmentManagedActions() {
        return this.to('DescribeEnvironmentManagedActions');
    }
    /**
     * Grants permission to retrieve a list of AWS resources for an environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironmentResources.html
     */
    toDescribeEnvironmentResources() {
        return this.to('DescribeEnvironmentResources');
    }
    /**
     * Grants permission to retrieve descriptions for existing environments
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEnvironments.html
     */
    toDescribeEnvironments() {
        return this.to('DescribeEnvironments');
    }
    /**
     * Grants permission to retrieve a list of event descriptions matching a set of criteria
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeEvents.html
     */
    toDescribeEvents() {
        return this.to('DescribeEvents');
    }
    /**
     * Grants permission to retrieve more detailed information about the health of environment instances
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribeInstancesHealth.html
     */
    toDescribeInstancesHealth() {
        return this.to('DescribeInstancesHealth');
    }
    /**
     * Grants permission to retrieve a description of a platform version
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DescribePlatformVersion.html
     */
    toDescribePlatformVersion() {
        return this.to('DescribePlatformVersion');
    }
    /**
     * Grants permission to disassociate an operations role with an environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_DisassociateEnvironmentOperationsRole.html
     */
    toDisassociateEnvironmentOperationsRole() {
        return this.to('DisassociateEnvironmentOperationsRole');
    }
    /**
     * Grants permission to retrieve a list of the available solution stack names
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html
     */
    toListAvailableSolutionStacks() {
        return this.to('ListAvailableSolutionStacks');
    }
    /**
     * Grants permission to retrieve a list of the available platform branches
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListPlatformBranches.html
     */
    toListPlatformBranches() {
        return this.to('ListPlatformBranches');
    }
    /**
     * Grants permission to retrieve a list of the available platforms
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListPlatformVersions.html
     */
    toListPlatformVersions() {
        return this.to('ListPlatformVersions');
    }
    /**
     * Grants permission to retrieve a list of tags of an Elastic Beanstalk resource
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListTagsForResource.html
     */
    toListTagsForResource() {
        return this.to('ListTagsForResource');
    }
    /**
     * Grants permission to submit instance statistics for enhanced health
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html#health-enhanced-authz
     */
    toPutInstanceStatistics() {
        return this.to('PutInstanceStatistics');
    }
    /**
     * Grants permission to delete and recreate all of the AWS resources for an environment and to force a restart
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RebuildEnvironment.html
     */
    toRebuildEnvironment() {
        return this.to('RebuildEnvironment');
    }
    /**
     * Grants permission to remove tags from an Elastic Beanstalk resource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     */
    toRemoveTags() {
        return this.to('RemoveTags');
    }
    /**
     * Grants permission to initiate a request to compile information of the deployed environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RequestEnvironmentInfo.html
     */
    toRequestEnvironmentInfo() {
        return this.to('RequestEnvironmentInfo');
    }
    /**
     * Grants permission to request an environment to restart the application container server running on each Amazon EC2 instance
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RestartAppServer.html
     */
    toRestartAppServer() {
        return this.to('RestartAppServer');
    }
    /**
     * Grants permission to retrieve the compiled information from a RequestEnvironmentInfo request
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_RetrieveEnvironmentInfo.html
     */
    toRetrieveEnvironmentInfo() {
        return this.to('RetrieveEnvironmentInfo');
    }
    /**
     * Grants permission to swap the CNAMEs of two environments
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromEnvironment()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_SwapEnvironmentCNAMEs.html
     */
    toSwapEnvironmentCNAMEs() {
        return this.to('SwapEnvironmentCNAMEs');
    }
    /**
     * Grants permission to terminate an environment
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_TerminateEnvironment.html
     */
    toTerminateEnvironment() {
        return this.to('TerminateEnvironment');
    }
    /**
     * Grants permission to update an application with specified properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplication.html
     */
    toUpdateApplication() {
        return this.to('UpdateApplication');
    }
    /**
     * Grants permission to update the application version lifecycle policy associated with the application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplicationResourceLifecycle.html
     */
    toUpdateApplicationResourceLifecycle() {
        return this.to('UpdateApplicationResourceLifecycle');
    }
    /**
     * Grants permission to update an application version with specified properties
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateApplicationVersion.html
     */
    toUpdateApplicationVersion() {
        return this.to('UpdateApplicationVersion');
    }
    /**
     * Grants permission to update a configuration template with specified properties or configuration option values
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplication()
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromEnvironment()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateConfigurationTemplate.html
     */
    toUpdateConfigurationTemplate() {
        return this.to('UpdateConfigurationTemplate');
    }
    /**
     * Grants permission to update an environment
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFromApplicationVersion()
     * - .ifFromConfigurationTemplate()
     * - .ifFromSolutionStack()
     * - .ifFromPlatform()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateEnvironment.html
     */
    toUpdateEnvironment() {
        return this.to('UpdateEnvironment');
    }
    /**
     * Grants permission to add tags to an Elastic Beanstalk resource, remove tags, and to update tag values
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_UpdateTagsForResource.html
     */
    toUpdateTagsForResource() {
        return this.to('UpdateTagsForResource');
    }
    /**
     * Grants permission to check the validity of a set of configuration settings for a configuration template or an environment
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ValidateConfigurationSettings.html
     */
    toValidateConfigurationSettings() {
        return this.to('ValidateConfigurationSettings');
    }
    /**
     * Adds a resource of type application to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onApplication(applicationName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}:${account || '*'}:application/${applicationName}`);
    }
    /**
     * Adds a resource of type applicationversion to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param versionLabel - Identifier for the versionLabel.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInApplication()
     */
    onApplicationversion(applicationName, versionLabel, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}:${account || '*'}:applicationversion/${applicationName}/${versionLabel}`);
    }
    /**
     * Adds a resource of type configurationtemplate to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param templateName - Identifier for the templateName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInApplication()
     */
    onConfigurationtemplate(applicationName, templateName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}:${account || '*'}:configurationtemplate/${applicationName}/${templateName}`);
    }
    /**
     * Adds a resource of type environment to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param applicationName - Identifier for the applicationName.
     * @param environmentName - Identifier for the environmentName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     * - .ifInApplication()
     */
    onEnvironment(applicationName, environmentName, account, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}:${account || '*'}:environment/${applicationName}/${environmentName}`);
    }
    /**
     * Adds a resource of type solutionstack to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param solutionStackName - Identifier for the solutionStackName.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onSolutionstack(solutionStackName, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}::solutionstack/${solutionStackName}`);
    }
    /**
     * Adds a resource of type platform to the statement
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.arn.html
     *
     * @param platformNameWithVersion - Identifier for the platformNameWithVersion.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onPlatform(platformNameWithVersion, region, partition) {
        return this.on(`arn:${partition || 'aws'}:elasticbeanstalk:${region || '*'}::platform/${platformNameWithVersion}`);
    }
    /**
     * Filters access by an application as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toUpdateConfigurationTemplate()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromApplication(value, operator) {
        return this.if(`FromApplication`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by an application version as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromApplicationVersion(value, operator) {
        return this.if(`FromApplicationVersion`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by a configuration template as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromConfigurationTemplate(value, operator) {
        return this.if(`FromConfigurationTemplate`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by an environment as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toSwapEnvironmentCNAMEs()
     * - .toUpdateConfigurationTemplate()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromEnvironment(value, operator) {
        return this.if(`FromEnvironment`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by a platform as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromPlatform(value, operator) {
        return this.if(`FromPlatform`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by a solution stack as a dependency or a constraint on an input parameter
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifFromSolutionStack(value, operator) {
        return this.if(`FromSolutionStack`, value, operator || 'ArnLike');
    }
    /**
     * Filters access by the application that contains the resource that the action operates on
     *
     * https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.policies.actions.html#AWSHowTo.iam.policies.conditions
     *
     * Applies to actions:
     * - .toAbortEnvironmentUpdate()
     * - .toApplyEnvironmentManagedAction()
     * - .toComposeEnvironments()
     * - .toCreateApplicationVersion()
     * - .toCreateConfigurationTemplate()
     * - .toCreateEnvironment()
     * - .toDeleteApplicationVersion()
     * - .toDeleteConfigurationTemplate()
     * - .toDeleteEnvironmentConfiguration()
     * - .toDescribeApplicationVersions()
     * - .toDescribeConfigurationOptions()
     * - .toDescribeConfigurationSettings()
     * - .toDescribeEnvironmentManagedActionHistory()
     * - .toDescribeEnvironmentManagedActions()
     * - .toDescribeEnvironmentResources()
     * - .toDescribeEnvironments()
     * - .toDescribeEvents()
     * - .toRebuildEnvironment()
     * - .toRequestEnvironmentInfo()
     * - .toRestartAppServer()
     * - .toRetrieveEnvironmentInfo()
     * - .toSwapEnvironmentCNAMEs()
     * - .toTerminateEnvironment()
     * - .toUpdateApplicationVersion()
     * - .toUpdateConfigurationTemplate()
     * - .toUpdateEnvironment()
     * - .toValidateConfigurationSettings()
     *
     * Applies to resource types:
     * - applicationversion
     * - configurationtemplate
     * - environment
     *
     * @param value The value(s) to check
     * @param operator Works with [arn operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_ARN). **Default:** `ArnLike`
     */
    ifInApplication(value, operator) {
        return this.if(`InApplication`, value, operator || 'ArnLike');
    }
}
exports.Elasticbeanstalk = Elasticbeanstalk;
_a = JSII_RTTI_SYMBOL_1;
Elasticbeanstalk[_a] = { fqn: "iam-floyd.Elasticbeanstalk", version: "0.329.0" };
//# sourceMappingURL=data:application/json;base64,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