import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Metadata settings that are supplied to this version to enable beta runtime features.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#beta_settings AppEngineFlexibleAppVersion#beta_settings}
     *
     * @stability stable
     */
    readonly betaSettings?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Duration that static files should be cached by web proxies and browsers.
     *
     * Only applicable if the corresponding StaticFilesHandler does not specify its own expiration time.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#default_expiration AppEngineFlexibleAppVersion#default_expiration}
     *
     * @stability stable
     */
    readonly defaultExpiration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#delete_service_on_destroy AppEngineFlexibleAppVersion#delete_service_on_destroy}.
     *
     * @stability stable
     */
    readonly deleteServiceOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * Environment variables available to the application.
     *
     * As these are not returned in the API request, Terraform will not detect any changes made outside of the Terraform config.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#env_variables AppEngineFlexibleAppVersion#env_variables}
     *
     * @stability stable
     */
    readonly envVariables?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * A list of the types of messages that this application is able to receive.
     *
     * Possible values: ["INBOUND_SERVICE_MAIL", "INBOUND_SERVICE_MAIL_BOUNCE", "INBOUND_SERVICE_XMPP_ERROR", "INBOUND_SERVICE_XMPP_MESSAGE", "INBOUND_SERVICE_XMPP_SUBSCRIBE", "INBOUND_SERVICE_XMPP_PRESENCE", "INBOUND_SERVICE_CHANNEL_PRESENCE", "INBOUND_SERVICE_WARMUP"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#inbound_services AppEngineFlexibleAppVersion#inbound_services}
     *
     * @stability stable
     */
    readonly inboundServices?: string[];
    /**
     * Instance class that is used to run this version.
     *
     * Valid values are
     * AutomaticScaling: F1, F2, F4, F4_1G
     * ManualScaling: B1, B2, B4, B8, B4_1G
     * Defaults to F1 for AutomaticScaling and B1 for ManualScaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instance_class AppEngineFlexibleAppVersion#instance_class}
     *
     * @stability stable
     */
    readonly instanceClass?: string;
    /**
     * Files that match this pattern will not be built into this version. Only applicable for Go runtimes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#nobuild_files_regex AppEngineFlexibleAppVersion#nobuild_files_regex}
     *
     * @stability stable
     */
    readonly nobuildFilesRegex?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#noop_on_destroy AppEngineFlexibleAppVersion#noop_on_destroy}.
     *
     * @stability stable
     */
    readonly noopOnDestroy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#project AppEngineFlexibleAppVersion#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * Desired runtime. Example python27.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime AppEngineFlexibleAppVersion#runtime}
     *
     * @stability stable
     */
    readonly runtime: string;
    /**
     * The version of the API in the given runtime environment. Please see the app.yaml reference for valid values at https://cloud.google.com/appengine/docs/standard//config/appref.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_api_version AppEngineFlexibleAppVersion#runtime_api_version}
     *
     * @stability stable
     */
    readonly runtimeApiVersion?: string;
    /**
     * The channel of the runtime to use. Only available for some runtimes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_channel AppEngineFlexibleAppVersion#runtime_channel}
     *
     * @stability stable
     */
    readonly runtimeChannel?: string;
    /**
     * The path or name of the app's main executable.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#runtime_main_executable_path AppEngineFlexibleAppVersion#runtime_main_executable_path}
     *
     * @stability stable
     */
    readonly runtimeMainExecutablePath?: string;
    /**
     * AppEngine service resource. Can contain numbers, letters, and hyphens.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#service AppEngineFlexibleAppVersion#service}
     *
     * @stability stable
     */
    readonly service: string;
    /**
     * Current serving status of this version.
     *
     * Only the versions with a SERVING status create instances and can be billed. Default value: "SERVING" Possible values: ["SERVING", "STOPPED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#serving_status AppEngineFlexibleAppVersion#serving_status}
     *
     * @stability stable
     */
    readonly servingStatus?: string;
    /**
     * Relative name of the version within the service.
     *
     * For example, 'v1'. Version names can contain only lowercase letters, numbers, or hyphens.
     * Reserved names,"default", "latest", and any name with the prefix "ah-".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#version_id AppEngineFlexibleAppVersion#version_id}
     *
     * @stability stable
     */
    readonly versionId?: string;
    /**
     * api_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#api_config AppEngineFlexibleAppVersion#api_config}
     *
     * @stability stable
     */
    readonly apiConfig?: AppEngineFlexibleAppVersionApiConfig;
    /**
     * automatic_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#automatic_scaling AppEngineFlexibleAppVersion#automatic_scaling}
     *
     * @stability stable
     */
    readonly automaticScaling?: AppEngineFlexibleAppVersionAutomaticScaling;
    /**
     * deployment block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#deployment AppEngineFlexibleAppVersion#deployment}
     *
     * @stability stable
     */
    readonly deployment?: AppEngineFlexibleAppVersionDeployment;
    /**
     * endpoints_api_service block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#endpoints_api_service AppEngineFlexibleAppVersion#endpoints_api_service}
     *
     * @stability stable
     */
    readonly endpointsApiService?: AppEngineFlexibleAppVersionEndpointsApiService;
    /**
     * entrypoint block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#entrypoint AppEngineFlexibleAppVersion#entrypoint}
     *
     * @stability stable
     */
    readonly entrypoint?: AppEngineFlexibleAppVersionEntrypoint;
    /**
     * handlers block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#handlers AppEngineFlexibleAppVersion#handlers}
     *
     * @stability stable
     */
    readonly handlers?: AppEngineFlexibleAppVersionHandlers[];
    /**
     * liveness_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#liveness_check AppEngineFlexibleAppVersion#liveness_check}
     *
     * @stability stable
     */
    readonly livenessCheck: AppEngineFlexibleAppVersionLivenessCheck;
    /**
     * manual_scaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#manual_scaling AppEngineFlexibleAppVersion#manual_scaling}
     *
     * @stability stable
     */
    readonly manualScaling?: AppEngineFlexibleAppVersionManualScaling;
    /**
     * network block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#network AppEngineFlexibleAppVersion#network}
     *
     * @stability stable
     */
    readonly network?: AppEngineFlexibleAppVersionNetwork;
    /**
     * readiness_check block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#readiness_check AppEngineFlexibleAppVersion#readiness_check}
     *
     * @stability stable
     */
    readonly readinessCheck: AppEngineFlexibleAppVersionReadinessCheck;
    /**
     * resources block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#resources AppEngineFlexibleAppVersion#resources}
     *
     * @stability stable
     */
    readonly resources?: AppEngineFlexibleAppVersionResources;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeouts AppEngineFlexibleAppVersion#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AppEngineFlexibleAppVersionTimeouts;
    /**
     * vpc_access_connector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#vpc_access_connector AppEngineFlexibleAppVersion#vpc_access_connector}
     *
     * @stability stable
     */
    readonly vpcAccessConnector?: AppEngineFlexibleAppVersionVpcAccessConnector;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionApiConfig {
    /**
     * Action to take when users access resources that require authentication. Default value: "AUTH_FAIL_ACTION_REDIRECT" Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
     *
     * @stability stable
     */
    readonly authFailAction?: string;
    /**
     * Level of login required to access this resource. Default value: "LOGIN_OPTIONAL" Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#login AppEngineFlexibleAppVersion#login}
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * Path to the script from the application root directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script AppEngineFlexibleAppVersion#script}
     *
     * @stability stable
     */
    readonly script: string;
    /**
     * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#security_level AppEngineFlexibleAppVersion#security_level}
     *
     * @stability stable
     */
    readonly securityLevel?: string;
    /**
     * URL to serve the endpoint at.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#url AppEngineFlexibleAppVersion#url}
     *
     * @stability stable
     */
    readonly url?: string;
}
export declare function appEngineFlexibleAppVersionApiConfigToTerraform(struct?: AppEngineFlexibleAppVersionApiConfigOutputReference | AppEngineFlexibleAppVersionApiConfig): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionApiConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionApiConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionApiConfig | undefined);
    private _authFailAction?;
    /**
     * @stability stable
     */
    get authFailAction(): string;
    /**
     * @stability stable
     */
    set authFailAction(value: string);
    /**
     * @stability stable
     */
    resetAuthFailAction(): void;
    /**
     * @stability stable
     */
    get authFailActionInput(): string | undefined;
    private _login?;
    /**
     * @stability stable
     */
    get login(): string;
    /**
     * @stability stable
     */
    set login(value: string);
    /**
     * @stability stable
     */
    resetLogin(): void;
    /**
     * @stability stable
     */
    get loginInput(): string | undefined;
    private _script?;
    /**
     * @stability stable
     */
    get script(): string;
    /**
     * @stability stable
     */
    set script(value: string);
    /**
     * @stability stable
     */
    get scriptInput(): string | undefined;
    private _securityLevel?;
    /**
     * @stability stable
     */
    get securityLevel(): string;
    /**
     * @stability stable
     */
    set securityLevel(value: string);
    /**
     * @stability stable
     */
    resetSecurityLevel(): void;
    /**
     * @stability stable
     */
    get securityLevelInput(): string | undefined;
    private _url?;
    /**
     * @stability stable
     */
    get url(): string;
    /**
     * @stability stable
     */
    set url(value: string);
    /**
     * @stability stable
     */
    resetUrl(): void;
    /**
     * @stability stable
     */
    get urlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization {
    /**
     * Period of time over which CPU utilization is calculated.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#aggregation_window_length AppEngineFlexibleAppVersion#aggregation_window_length}
     *
     * @stability stable
     */
    readonly aggregationWindowLength?: string;
    /**
     * Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_utilization AppEngineFlexibleAppVersion#target_utilization}
     *
     * @stability stable
     */
    readonly targetUtilization: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingCpuUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined);
    private _aggregationWindowLength?;
    /**
     * @stability stable
     */
    get aggregationWindowLength(): string;
    /**
     * @stability stable
     */
    set aggregationWindowLength(value: string);
    /**
     * @stability stable
     */
    resetAggregationWindowLength(): void;
    /**
     * @stability stable
     */
    get aggregationWindowLengthInput(): string | undefined;
    private _targetUtilization?;
    /**
     * @stability stable
     */
    get targetUtilization(): number;
    /**
     * @stability stable
     */
    set targetUtilization(value: number);
    /**
     * @stability stable
     */
    get targetUtilizationInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization {
    /**
     * Target bytes read per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_read_bytes_per_second AppEngineFlexibleAppVersion#target_read_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetReadBytesPerSecond?: number;
    /**
     * Target ops read per seconds.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_read_ops_per_second AppEngineFlexibleAppVersion#target_read_ops_per_second}
     *
     * @stability stable
     */
    readonly targetReadOpsPerSecond?: number;
    /**
     * Target bytes written per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_write_bytes_per_second AppEngineFlexibleAppVersion#target_write_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetWriteBytesPerSecond?: number;
    /**
     * Target ops written per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_write_ops_per_second AppEngineFlexibleAppVersion#target_write_ops_per_second}
     *
     * @stability stable
     */
    readonly targetWriteOpsPerSecond?: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingDiskUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined);
    private _targetReadBytesPerSecond?;
    /**
     * @stability stable
     */
    get targetReadBytesPerSecond(): number;
    /**
     * @stability stable
     */
    set targetReadBytesPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetReadBytesPerSecond(): void;
    /**
     * @stability stable
     */
    get targetReadBytesPerSecondInput(): number | undefined;
    private _targetReadOpsPerSecond?;
    /**
     * @stability stable
     */
    get targetReadOpsPerSecond(): number;
    /**
     * @stability stable
     */
    set targetReadOpsPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetReadOpsPerSecond(): void;
    /**
     * @stability stable
     */
    get targetReadOpsPerSecondInput(): number | undefined;
    private _targetWriteBytesPerSecond?;
    /**
     * @stability stable
     */
    get targetWriteBytesPerSecond(): number;
    /**
     * @stability stable
     */
    set targetWriteBytesPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetWriteBytesPerSecond(): void;
    /**
     * @stability stable
     */
    get targetWriteBytesPerSecondInput(): number | undefined;
    private _targetWriteOpsPerSecond?;
    /**
     * @stability stable
     */
    get targetWriteOpsPerSecond(): number;
    /**
     * @stability stable
     */
    set targetWriteOpsPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetWriteOpsPerSecond(): void;
    /**
     * @stability stable
     */
    get targetWriteOpsPerSecondInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization {
    /**
     * Target bytes received per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_received_bytes_per_second AppEngineFlexibleAppVersion#target_received_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetReceivedBytesPerSecond?: number;
    /**
     * Target packets received per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_received_packets_per_second AppEngineFlexibleAppVersion#target_received_packets_per_second}
     *
     * @stability stable
     */
    readonly targetReceivedPacketsPerSecond?: number;
    /**
     * Target bytes sent per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_sent_bytes_per_second AppEngineFlexibleAppVersion#target_sent_bytes_per_second}
     *
     * @stability stable
     */
    readonly targetSentBytesPerSecond?: number;
    /**
     * Target packets sent per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_sent_packets_per_second AppEngineFlexibleAppVersion#target_sent_packets_per_second}
     *
     * @stability stable
     */
    readonly targetSentPacketsPerSecond?: number;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined);
    private _targetReceivedBytesPerSecond?;
    /**
     * @stability stable
     */
    get targetReceivedBytesPerSecond(): number;
    /**
     * @stability stable
     */
    set targetReceivedBytesPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetReceivedBytesPerSecond(): void;
    /**
     * @stability stable
     */
    get targetReceivedBytesPerSecondInput(): number | undefined;
    private _targetReceivedPacketsPerSecond?;
    /**
     * @stability stable
     */
    get targetReceivedPacketsPerSecond(): number;
    /**
     * @stability stable
     */
    set targetReceivedPacketsPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetReceivedPacketsPerSecond(): void;
    /**
     * @stability stable
     */
    get targetReceivedPacketsPerSecondInput(): number | undefined;
    private _targetSentBytesPerSecond?;
    /**
     * @stability stable
     */
    get targetSentBytesPerSecond(): number;
    /**
     * @stability stable
     */
    set targetSentBytesPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetSentBytesPerSecond(): void;
    /**
     * @stability stable
     */
    get targetSentBytesPerSecondInput(): number | undefined;
    private _targetSentPacketsPerSecond?;
    /**
     * @stability stable
     */
    get targetSentPacketsPerSecond(): number;
    /**
     * @stability stable
     */
    set targetSentPacketsPerSecond(value: number);
    /**
     * @stability stable
     */
    resetTargetSentPacketsPerSecond(): void;
    /**
     * @stability stable
     */
    get targetSentPacketsPerSecondInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization {
    /**
     * Target number of concurrent requests.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_concurrent_requests AppEngineFlexibleAppVersion#target_concurrent_requests}
     *
     * @stability stable
     */
    readonly targetConcurrentRequests?: number;
    /**
     * Target requests per second.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#target_request_count_per_second AppEngineFlexibleAppVersion#target_request_count_per_second}
     *
     * @stability stable
     */
    readonly targetRequestCountPerSecond?: string;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingRequestUtilizationToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference | AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined);
    private _targetConcurrentRequests?;
    /**
     * @stability stable
     */
    get targetConcurrentRequests(): number;
    /**
     * @stability stable
     */
    set targetConcurrentRequests(value: number);
    /**
     * @stability stable
     */
    resetTargetConcurrentRequests(): void;
    /**
     * @stability stable
     */
    get targetConcurrentRequestsInput(): number | undefined;
    private _targetRequestCountPerSecond?;
    /**
     * @stability stable
     */
    get targetRequestCountPerSecond(): string;
    /**
     * @stability stable
     */
    set targetRequestCountPerSecond(value: string);
    /**
     * @stability stable
     */
    resetTargetRequestCountPerSecond(): void;
    /**
     * @stability stable
     */
    get targetRequestCountPerSecondInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionAutomaticScaling {
    /**
     * The time period that the Autoscaler should wait before it starts collecting information from a new instance.
     *
     * This prevents the autoscaler from collecting information when the instance is initializing,
     * during which the collected usage would not be reliable. Default: 120s
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cool_down_period AppEngineFlexibleAppVersion#cool_down_period}
     *
     * @stability stable
     */
    readonly coolDownPeriod?: string;
    /**
     * Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
     *
     * Defaults to a runtime-specific value.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_concurrent_requests AppEngineFlexibleAppVersion#max_concurrent_requests}
     *
     * @stability stable
     */
    readonly maxConcurrentRequests?: number;
    /**
     * Maximum number of idle instances that should be maintained for this version.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_idle_instances AppEngineFlexibleAppVersion#max_idle_instances}
     *
     * @stability stable
     */
    readonly maxIdleInstances?: number;
    /**
     * Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_pending_latency AppEngineFlexibleAppVersion#max_pending_latency}
     *
     * @stability stable
     */
    readonly maxPendingLatency?: string;
    /**
     * Maximum number of instances that should be started to handle requests for this version. Default: 20.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#max_total_instances AppEngineFlexibleAppVersion#max_total_instances}
     *
     * @stability stable
     */
    readonly maxTotalInstances?: number;
    /**
     * Minimum number of idle instances that should be maintained for this version.
     *
     * Only applicable for the default version of a service.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_idle_instances AppEngineFlexibleAppVersion#min_idle_instances}
     *
     * @stability stable
     */
    readonly minIdleInstances?: number;
    /**
     * Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_pending_latency AppEngineFlexibleAppVersion#min_pending_latency}
     *
     * @stability stable
     */
    readonly minPendingLatency?: string;
    /**
     * Minimum number of running instances that should be maintained for this version. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#min_total_instances AppEngineFlexibleAppVersion#min_total_instances}
     *
     * @stability stable
     */
    readonly minTotalInstances?: number;
    /**
     * cpu_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cpu_utilization AppEngineFlexibleAppVersion#cpu_utilization}
     *
     * @stability stable
     */
    readonly cpuUtilization: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization;
    /**
     * disk_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disk_utilization AppEngineFlexibleAppVersion#disk_utilization}
     *
     * @stability stable
     */
    readonly diskUtilization?: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization;
    /**
     * network_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#network_utilization AppEngineFlexibleAppVersion#network_utilization}
     *
     * @stability stable
     */
    readonly networkUtilization?: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization;
    /**
     * request_utilization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#request_utilization AppEngineFlexibleAppVersion#request_utilization}
     *
     * @stability stable
     */
    readonly requestUtilization?: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization;
}
export declare function appEngineFlexibleAppVersionAutomaticScalingToTerraform(struct?: AppEngineFlexibleAppVersionAutomaticScalingOutputReference | AppEngineFlexibleAppVersionAutomaticScaling): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionAutomaticScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionAutomaticScaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionAutomaticScaling | undefined);
    private _coolDownPeriod?;
    /**
     * @stability stable
     */
    get coolDownPeriod(): string;
    /**
     * @stability stable
     */
    set coolDownPeriod(value: string);
    /**
     * @stability stable
     */
    resetCoolDownPeriod(): void;
    /**
     * @stability stable
     */
    get coolDownPeriodInput(): string | undefined;
    private _maxConcurrentRequests?;
    /**
     * @stability stable
     */
    get maxConcurrentRequests(): number;
    /**
     * @stability stable
     */
    set maxConcurrentRequests(value: number);
    /**
     * @stability stable
     */
    resetMaxConcurrentRequests(): void;
    /**
     * @stability stable
     */
    get maxConcurrentRequestsInput(): number | undefined;
    private _maxIdleInstances?;
    /**
     * @stability stable
     */
    get maxIdleInstances(): number;
    /**
     * @stability stable
     */
    set maxIdleInstances(value: number);
    /**
     * @stability stable
     */
    resetMaxIdleInstances(): void;
    /**
     * @stability stable
     */
    get maxIdleInstancesInput(): number | undefined;
    private _maxPendingLatency?;
    /**
     * @stability stable
     */
    get maxPendingLatency(): string;
    /**
     * @stability stable
     */
    set maxPendingLatency(value: string);
    /**
     * @stability stable
     */
    resetMaxPendingLatency(): void;
    /**
     * @stability stable
     */
    get maxPendingLatencyInput(): string | undefined;
    private _maxTotalInstances?;
    /**
     * @stability stable
     */
    get maxTotalInstances(): number;
    /**
     * @stability stable
     */
    set maxTotalInstances(value: number);
    /**
     * @stability stable
     */
    resetMaxTotalInstances(): void;
    /**
     * @stability stable
     */
    get maxTotalInstancesInput(): number | undefined;
    private _minIdleInstances?;
    /**
     * @stability stable
     */
    get minIdleInstances(): number;
    /**
     * @stability stable
     */
    set minIdleInstances(value: number);
    /**
     * @stability stable
     */
    resetMinIdleInstances(): void;
    /**
     * @stability stable
     */
    get minIdleInstancesInput(): number | undefined;
    private _minPendingLatency?;
    /**
     * @stability stable
     */
    get minPendingLatency(): string;
    /**
     * @stability stable
     */
    set minPendingLatency(value: string);
    /**
     * @stability stable
     */
    resetMinPendingLatency(): void;
    /**
     * @stability stable
     */
    get minPendingLatencyInput(): string | undefined;
    private _minTotalInstances?;
    /**
     * @stability stable
     */
    get minTotalInstances(): number;
    /**
     * @stability stable
     */
    set minTotalInstances(value: number);
    /**
     * @stability stable
     */
    resetMinTotalInstances(): void;
    /**
     * @stability stable
     */
    get minTotalInstancesInput(): number | undefined;
    private _cpuUtilization;
    /**
     * @stability stable
     */
    get cpuUtilization(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilizationOutputReference;
    /**
     * @stability stable
     */
    putCpuUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization): void;
    /**
     * @stability stable
     */
    get cpuUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingCpuUtilization | undefined;
    private _diskUtilization;
    /**
     * @stability stable
     */
    get diskUtilization(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilizationOutputReference;
    /**
     * @stability stable
     */
    putDiskUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization): void;
    /**
     * @stability stable
     */
    resetDiskUtilization(): void;
    /**
     * @stability stable
     */
    get diskUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingDiskUtilization | undefined;
    private _networkUtilization;
    /**
     * @stability stable
     */
    get networkUtilization(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilizationOutputReference;
    /**
     * @stability stable
     */
    putNetworkUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization): void;
    /**
     * @stability stable
     */
    resetNetworkUtilization(): void;
    /**
     * @stability stable
     */
    get networkUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingNetworkUtilization | undefined;
    private _requestUtilization;
    /**
     * @stability stable
     */
    get requestUtilization(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilizationOutputReference;
    /**
     * @stability stable
     */
    putRequestUtilization(value: AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization): void;
    /**
     * @stability stable
     */
    resetRequestUtilization(): void;
    /**
     * @stability stable
     */
    get requestUtilizationInput(): AppEngineFlexibleAppVersionAutomaticScalingRequestUtilization | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentCloudBuildOptions {
    /**
     * Path to the yaml file used in deployment, used to determine runtime configuration details.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#app_yaml_path AppEngineFlexibleAppVersion#app_yaml_path}
     *
     * @stability stable
     */
    readonly appYamlPath: string;
    /**
     * The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cloud_build_timeout AppEngineFlexibleAppVersion#cloud_build_timeout}
     *
     * @stability stable
     */
    readonly cloudBuildTimeout?: string;
}
export declare function appEngineFlexibleAppVersionDeploymentCloudBuildOptionsToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference | AppEngineFlexibleAppVersionDeploymentCloudBuildOptions): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined);
    private _appYamlPath?;
    /**
     * @stability stable
     */
    get appYamlPath(): string;
    /**
     * @stability stable
     */
    set appYamlPath(value: string);
    /**
     * @stability stable
     */
    get appYamlPathInput(): string | undefined;
    private _cloudBuildTimeout?;
    /**
     * @stability stable
     */
    get cloudBuildTimeout(): string;
    /**
     * @stability stable
     */
    set cloudBuildTimeout(value: string);
    /**
     * @stability stable
     */
    resetCloudBuildTimeout(): void;
    /**
     * @stability stable
     */
    get cloudBuildTimeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentContainer {
    /**
     * URI to the hosted container image in Google Container Registry.
     *
     * The URI must be fully qualified and include a tag or digest.
     * Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#image AppEngineFlexibleAppVersion#image}
     *
     * @stability stable
     */
    readonly image: string;
}
export declare function appEngineFlexibleAppVersionDeploymentContainerToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentContainerOutputReference | AppEngineFlexibleAppVersionDeploymentContainer): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionDeploymentContainerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionDeploymentContainer | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentContainer | undefined);
    private _image?;
    /**
     * @stability stable
     */
    get image(): string;
    /**
     * @stability stable
     */
    set image(value: string);
    /**
     * @stability stable
     */
    get imageInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentFiles {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * SHA1 checksum of the file.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#sha1_sum AppEngineFlexibleAppVersion#sha1_sum}
     *
     * @stability stable
     */
    readonly sha1Sum?: string;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#source_url AppEngineFlexibleAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
export declare function appEngineFlexibleAppVersionDeploymentFilesToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentFiles): any;
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeploymentZip {
    /**
     * files count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#files_count AppEngineFlexibleAppVersion#files_count}
     *
     * @stability stable
     */
    readonly filesCount?: number;
    /**
     * Source URL.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#source_url AppEngineFlexibleAppVersion#source_url}
     *
     * @stability stable
     */
    readonly sourceUrl: string;
}
export declare function appEngineFlexibleAppVersionDeploymentZipToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentZipOutputReference | AppEngineFlexibleAppVersionDeploymentZip): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionDeploymentZipOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionDeploymentZip | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionDeploymentZip | undefined);
    private _filesCount?;
    /**
     * @stability stable
     */
    get filesCount(): number;
    /**
     * @stability stable
     */
    set filesCount(value: number);
    /**
     * @stability stable
     */
    resetFilesCount(): void;
    /**
     * @stability stable
     */
    get filesCountInput(): number | undefined;
    private _sourceUrl?;
    /**
     * @stability stable
     */
    get sourceUrl(): string;
    /**
     * @stability stable
     */
    set sourceUrl(value: string);
    /**
     * @stability stable
     */
    get sourceUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionDeployment {
    /**
     * cloud_build_options block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cloud_build_options AppEngineFlexibleAppVersion#cloud_build_options}
     *
     * @stability stable
     */
    readonly cloudBuildOptions?: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions;
    /**
     * container block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#container AppEngineFlexibleAppVersion#container}
     *
     * @stability stable
     */
    readonly container?: AppEngineFlexibleAppVersionDeploymentContainer;
    /**
     * files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#files AppEngineFlexibleAppVersion#files}
     *
     * @stability stable
     */
    readonly files?: AppEngineFlexibleAppVersionDeploymentFiles[];
    /**
     * zip block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#zip AppEngineFlexibleAppVersion#zip}
     *
     * @stability stable
     */
    readonly zip?: AppEngineFlexibleAppVersionDeploymentZip;
}
export declare function appEngineFlexibleAppVersionDeploymentToTerraform(struct?: AppEngineFlexibleAppVersionDeploymentOutputReference | AppEngineFlexibleAppVersionDeployment): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionDeploymentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionDeployment | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionDeployment | undefined);
    private _cloudBuildOptions;
    /**
     * @stability stable
     */
    get cloudBuildOptions(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptionsOutputReference;
    /**
     * @stability stable
     */
    putCloudBuildOptions(value: AppEngineFlexibleAppVersionDeploymentCloudBuildOptions): void;
    /**
     * @stability stable
     */
    resetCloudBuildOptions(): void;
    /**
     * @stability stable
     */
    get cloudBuildOptionsInput(): AppEngineFlexibleAppVersionDeploymentCloudBuildOptions | undefined;
    private _container;
    /**
     * @stability stable
     */
    get container(): AppEngineFlexibleAppVersionDeploymentContainerOutputReference;
    /**
     * @stability stable
     */
    putContainer(value: AppEngineFlexibleAppVersionDeploymentContainer): void;
    /**
     * @stability stable
     */
    resetContainer(): void;
    /**
     * @stability stable
     */
    get containerInput(): AppEngineFlexibleAppVersionDeploymentContainer | undefined;
    private _files?;
    /**
     * @stability stable
     */
    get files(): AppEngineFlexibleAppVersionDeploymentFiles[];
    /**
     * @stability stable
     */
    set files(value: AppEngineFlexibleAppVersionDeploymentFiles[]);
    /**
     * @stability stable
     */
    resetFiles(): void;
    /**
     * @stability stable
     */
    get filesInput(): AppEngineFlexibleAppVersionDeploymentFiles[] | undefined;
    private _zip;
    /**
     * @stability stable
     */
    get zip(): AppEngineFlexibleAppVersionDeploymentZipOutputReference;
    /**
     * @stability stable
     */
    putZip(value: AppEngineFlexibleAppVersionDeploymentZip): void;
    /**
     * @stability stable
     */
    resetZip(): void;
    /**
     * @stability stable
     */
    get zipInput(): AppEngineFlexibleAppVersionDeploymentZip | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionEndpointsApiService {
    /**
     * Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
     *
     * By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
     * When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
     * and is required in this case.
     *
     * Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
     * the configuration ID. In this case, configId must be omitted.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#config_id AppEngineFlexibleAppVersion#config_id}
     *
     * @stability stable
     */
    readonly configId?: string;
    /**
     * Enable or disable trace sampling. By default, this is set to false for enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disable_trace_sampling AppEngineFlexibleAppVersion#disable_trace_sampling}
     *
     * @stability stable
     */
    readonly disableTraceSampling?: boolean | cdktf.IResolvable;
    /**
     * Endpoints service name which is the name of the "service" resource in the Service Management API. For example "myapi.endpoints.myproject.cloud.goog".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Endpoints rollout strategy.
     *
     * If FIXED, configId must be specified. If MANAGED, configId must be omitted. Default value: "FIXED" Possible values: ["FIXED", "MANAGED"]
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#rollout_strategy AppEngineFlexibleAppVersion#rollout_strategy}
     *
     * @stability stable
     */
    readonly rolloutStrategy?: string;
}
export declare function appEngineFlexibleAppVersionEndpointsApiServiceToTerraform(struct?: AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference | AppEngineFlexibleAppVersionEndpointsApiService): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionEndpointsApiService | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionEndpointsApiService | undefined);
    private _configId?;
    /**
     * @stability stable
     */
    get configId(): string;
    /**
     * @stability stable
     */
    set configId(value: string);
    /**
     * @stability stable
     */
    resetConfigId(): void;
    /**
     * @stability stable
     */
    get configIdInput(): string | undefined;
    private _disableTraceSampling?;
    /**
     * @stability stable
     */
    get disableTraceSampling(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disableTraceSampling(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisableTraceSampling(): void;
    /**
     * @stability stable
     */
    get disableTraceSamplingInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _rolloutStrategy?;
    /**
     * @stability stable
     */
    get rolloutStrategy(): string;
    /**
     * @stability stable
     */
    set rolloutStrategy(value: string);
    /**
     * @stability stable
     */
    resetRolloutStrategy(): void;
    /**
     * @stability stable
     */
    get rolloutStrategyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionEntrypoint {
    /**
     * The format should be a shell command that can be fed to bash -c.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#shell AppEngineFlexibleAppVersion#shell}
     *
     * @stability stable
     */
    readonly shell: string;
}
export declare function appEngineFlexibleAppVersionEntrypointToTerraform(struct?: AppEngineFlexibleAppVersionEntrypointOutputReference | AppEngineFlexibleAppVersionEntrypoint): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionEntrypointOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionEntrypoint | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionEntrypoint | undefined);
    private _shell?;
    /**
     * @stability stable
     */
    get shell(): string;
    /**
     * @stability stable
     */
    set shell(value: string);
    /**
     * @stability stable
     */
    get shellInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlersScript {
    /**
     * Path to the script from the application root directory.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script_path AppEngineFlexibleAppVersion#script_path}
     *
     * @stability stable
     */
    readonly scriptPath: string;
}
export declare function appEngineFlexibleAppVersionHandlersScriptToTerraform(struct?: AppEngineFlexibleAppVersionHandlersScriptOutputReference | AppEngineFlexibleAppVersionHandlersScript): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionHandlersScriptOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionHandlersScript | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionHandlersScript | undefined);
    private _scriptPath?;
    /**
     * @stability stable
     */
    get scriptPath(): string;
    /**
     * @stability stable
     */
    set scriptPath(value: string);
    /**
     * @stability stable
     */
    get scriptPathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlersStaticFiles {
    /**
     * Whether files should also be uploaded as code data.
     *
     * By default, files declared in static file handlers are
     * uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
     * uploads are charged against both your code and static data storage resource quotas.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#application_readable AppEngineFlexibleAppVersion#application_readable}
     *
     * @stability stable
     */
    readonly applicationReadable?: boolean | cdktf.IResolvable;
    /**
     * Time a static file served by this handler should be cached by web proxies and browsers.
     *
     * A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
     * Default is '0s'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#expiration AppEngineFlexibleAppVersion#expiration}
     *
     * @stability stable
     */
    readonly expiration?: string;
    /**
     * HTTP headers to use for all responses from these URLs. An object containing a list of "key:value" value pairs.".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#http_headers AppEngineFlexibleAppVersion#http_headers}
     *
     * @stability stable
     */
    readonly httpHeaders?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * MIME type used to serve all files served by this handler.
     *
     * Defaults to file-specific MIME types, which are derived from each file's filename extension.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#mime_type AppEngineFlexibleAppVersion#mime_type}
     *
     * @stability stable
     */
    readonly mimeType?: string;
    /**
     * Path to the static files matched by the URL pattern, from the application root directory.
     *
     * The path can refer to text matched in groupings in the URL pattern.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Whether this handler should match the request if the file referenced by the handler does not exist.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#require_matching_file AppEngineFlexibleAppVersion#require_matching_file}
     *
     * @stability stable
     */
    readonly requireMatchingFile?: boolean | cdktf.IResolvable;
    /**
     * Regular expression that matches the file paths for all files that should be referenced by this handler.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#upload_path_regex AppEngineFlexibleAppVersion#upload_path_regex}
     *
     * @stability stable
     */
    readonly uploadPathRegex?: string;
}
export declare function appEngineFlexibleAppVersionHandlersStaticFilesToTerraform(struct?: AppEngineFlexibleAppVersionHandlersStaticFilesOutputReference | AppEngineFlexibleAppVersionHandlersStaticFiles): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionHandlersStaticFilesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionHandlersStaticFiles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionHandlersStaticFiles | undefined);
    private _applicationReadable?;
    /**
     * @stability stable
     */
    get applicationReadable(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set applicationReadable(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetApplicationReadable(): void;
    /**
     * @stability stable
     */
    get applicationReadableInput(): boolean | cdktf.IResolvable | undefined;
    private _expiration?;
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    set expiration(value: string);
    /**
     * @stability stable
     */
    resetExpiration(): void;
    /**
     * @stability stable
     */
    get expirationInput(): string | undefined;
    private _httpHeaders?;
    /**
     * @stability stable
     */
    get httpHeaders(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set httpHeaders(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetHttpHeaders(): void;
    /**
     * @stability stable
     */
    get httpHeadersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _mimeType?;
    /**
     * @stability stable
     */
    get mimeType(): string;
    /**
     * @stability stable
     */
    set mimeType(value: string);
    /**
     * @stability stable
     */
    resetMimeType(): void;
    /**
     * @stability stable
     */
    get mimeTypeInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _requireMatchingFile?;
    /**
     * @stability stable
     */
    get requireMatchingFile(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set requireMatchingFile(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRequireMatchingFile(): void;
    /**
     * @stability stable
     */
    get requireMatchingFileInput(): boolean | cdktf.IResolvable | undefined;
    private _uploadPathRegex?;
    /**
     * @stability stable
     */
    get uploadPathRegex(): string;
    /**
     * @stability stable
     */
    set uploadPathRegex(value: string);
    /**
     * @stability stable
     */
    resetUploadPathRegex(): void;
    /**
     * @stability stable
     */
    get uploadPathRegexInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionHandlers {
    /**
     * Actions to take when the user is not logged in. Possible values: ["AUTH_FAIL_ACTION_REDIRECT", "AUTH_FAIL_ACTION_UNAUTHORIZED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#auth_fail_action AppEngineFlexibleAppVersion#auth_fail_action}
     *
     * @stability stable
     */
    readonly authFailAction?: string;
    /**
     * Methods to restrict access to a URL based on login status. Possible values: ["LOGIN_OPTIONAL", "LOGIN_ADMIN", "LOGIN_REQUIRED"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#login AppEngineFlexibleAppVersion#login}
     *
     * @stability stable
     */
    readonly login?: string;
    /**
     * 30x code to use when performing redirects for the secure field. Possible values: ["REDIRECT_HTTP_RESPONSE_CODE_301", "REDIRECT_HTTP_RESPONSE_CODE_302", "REDIRECT_HTTP_RESPONSE_CODE_303", "REDIRECT_HTTP_RESPONSE_CODE_307"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#redirect_http_response_code AppEngineFlexibleAppVersion#redirect_http_response_code}
     *
     * @stability stable
     */
    readonly redirectHttpResponseCode?: string;
    /**
     * Security (HTTPS) enforcement for this URL. Possible values: ["SECURE_DEFAULT", "SECURE_NEVER", "SECURE_OPTIONAL", "SECURE_ALWAYS"].
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#security_level AppEngineFlexibleAppVersion#security_level}
     *
     * @stability stable
     */
    readonly securityLevel?: string;
    /**
     * URL prefix.
     *
     * Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
     * All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#url_regex AppEngineFlexibleAppVersion#url_regex}
     *
     * @stability stable
     */
    readonly urlRegex?: string;
    /**
     * script block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#script AppEngineFlexibleAppVersion#script}
     *
     * @stability stable
     */
    readonly script?: AppEngineFlexibleAppVersionHandlersScript;
    /**
     * static_files block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#static_files AppEngineFlexibleAppVersion#static_files}
     *
     * @stability stable
     */
    readonly staticFiles?: AppEngineFlexibleAppVersionHandlersStaticFiles;
}
export declare function appEngineFlexibleAppVersionHandlersToTerraform(struct?: AppEngineFlexibleAppVersionHandlers): any;
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionLivenessCheck {
    /**
     * Interval between health checks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#check_interval AppEngineFlexibleAppVersion#check_interval}
     *
     * @stability stable
     */
    readonly checkInterval?: string;
    /**
     * Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#host AppEngineFlexibleAppVersion#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The initial delay before starting to execute the checks. Default: "300s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#initial_delay AppEngineFlexibleAppVersion#initial_delay}
     *
     * @stability stable
     */
    readonly initialDelay?: string;
    /**
     * The request path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Number of consecutive successful checks required before considering the VM healthy. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#success_threshold AppEngineFlexibleAppVersion#success_threshold}
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Time before the check is considered failed. Default: "4s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeout AppEngineFlexibleAppVersion#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
}
export declare function appEngineFlexibleAppVersionLivenessCheckToTerraform(struct?: AppEngineFlexibleAppVersionLivenessCheckOutputReference | AppEngineFlexibleAppVersionLivenessCheck): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionLivenessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionLivenessCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionLivenessCheck | undefined);
    private _checkInterval?;
    /**
     * @stability stable
     */
    get checkInterval(): string;
    /**
     * @stability stable
     */
    set checkInterval(value: string);
    /**
     * @stability stable
     */
    resetCheckInterval(): void;
    /**
     * @stability stable
     */
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    /**
     * @stability stable
     */
    get failureThreshold(): number;
    /**
     * @stability stable
     */
    set failureThreshold(value: number);
    /**
     * @stability stable
     */
    resetFailureThreshold(): void;
    /**
     * @stability stable
     */
    get failureThresholdInput(): number | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _initialDelay?;
    /**
     * @stability stable
     */
    get initialDelay(): string;
    /**
     * @stability stable
     */
    set initialDelay(value: string);
    /**
     * @stability stable
     */
    resetInitialDelay(): void;
    /**
     * @stability stable
     */
    get initialDelayInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _successThreshold?;
    /**
     * @stability stable
     */
    get successThreshold(): number;
    /**
     * @stability stable
     */
    set successThreshold(value: number);
    /**
     * @stability stable
     */
    resetSuccessThreshold(): void;
    /**
     * @stability stable
     */
    get successThresholdInput(): number | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionManualScaling {
    /**
     * Number of instances to assign to the service at the start.
     *
     * *Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
     * Modules API set_num_instances() you must use 'lifecycle.ignore_changes = ["manual_scaling"[0].instances]' to prevent drift detection.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instances AppEngineFlexibleAppVersion#instances}
     *
     * @stability stable
     */
    readonly instances: number;
}
export declare function appEngineFlexibleAppVersionManualScalingToTerraform(struct?: AppEngineFlexibleAppVersionManualScalingOutputReference | AppEngineFlexibleAppVersionManualScaling): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionManualScalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionManualScaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionManualScaling | undefined);
    private _instances?;
    /**
     * @stability stable
     */
    get instances(): number;
    /**
     * @stability stable
     */
    set instances(value: number);
    /**
     * @stability stable
     */
    get instancesInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionNetwork {
    /**
     * List of ports, or port pairs, to forward from the virtual machine to the application container.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#forwarded_ports AppEngineFlexibleAppVersion#forwarded_ports}
     *
     * @stability stable
     */
    readonly forwardedPorts?: string[];
    /**
     * Tag to apply to the instance during creation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#instance_tag AppEngineFlexibleAppVersion#instance_tag}
     *
     * @stability stable
     */
    readonly instanceTag?: string;
    /**
     * Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Enable session affinity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#session_affinity AppEngineFlexibleAppVersion#session_affinity}
     *
     * @stability stable
     */
    readonly sessionAffinity?: boolean | cdktf.IResolvable;
    /**
     * Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
     *
     * If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
     * If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
     * If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
     * If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#subnetwork AppEngineFlexibleAppVersion#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
}
export declare function appEngineFlexibleAppVersionNetworkToTerraform(struct?: AppEngineFlexibleAppVersionNetworkOutputReference | AppEngineFlexibleAppVersionNetwork): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionNetworkOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionNetwork | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionNetwork | undefined);
    private _forwardedPorts?;
    /**
     * @stability stable
     */
    get forwardedPorts(): string[];
    /**
     * @stability stable
     */
    set forwardedPorts(value: string[]);
    /**
     * @stability stable
     */
    resetForwardedPorts(): void;
    /**
     * @stability stable
     */
    get forwardedPortsInput(): string[] | undefined;
    private _instanceTag?;
    /**
     * @stability stable
     */
    get instanceTag(): string;
    /**
     * @stability stable
     */
    set instanceTag(value: string);
    /**
     * @stability stable
     */
    resetInstanceTag(): void;
    /**
     * @stability stable
     */
    get instanceTagInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _sessionAffinity?;
    /**
     * @stability stable
     */
    get sessionAffinity(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set sessionAffinity(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSessionAffinity(): void;
    /**
     * @stability stable
     */
    get sessionAffinityInput(): boolean | cdktf.IResolvable | undefined;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionReadinessCheck {
    /**
     * A maximum time limit on application initialization, measured from moment the application successfully replies to a healthcheck until it is ready to serve traffic.
     *
     * Default: "300s"
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#app_start_timeout AppEngineFlexibleAppVersion#app_start_timeout}
     *
     * @stability stable
     */
    readonly appStartTimeout?: string;
    /**
     * Interval between health checks.  Default: "5s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#check_interval AppEngineFlexibleAppVersion#check_interval}
     *
     * @stability stable
     */
    readonly checkInterval?: string;
    /**
     * Number of consecutive failed checks required before removing traffic. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#failure_threshold AppEngineFlexibleAppVersion#failure_threshold}
     *
     * @stability stable
     */
    readonly failureThreshold?: number;
    /**
     * Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#host AppEngineFlexibleAppVersion#host}
     *
     * @stability stable
     */
    readonly host?: string;
    /**
     * The request path.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#path AppEngineFlexibleAppVersion#path}
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Number of consecutive successful checks required before receiving traffic. Default: 2.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#success_threshold AppEngineFlexibleAppVersion#success_threshold}
     *
     * @stability stable
     */
    readonly successThreshold?: number;
    /**
     * Time before the check is considered failed. Default: "4s".
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#timeout AppEngineFlexibleAppVersion#timeout}
     *
     * @stability stable
     */
    readonly timeout?: string;
}
export declare function appEngineFlexibleAppVersionReadinessCheckToTerraform(struct?: AppEngineFlexibleAppVersionReadinessCheckOutputReference | AppEngineFlexibleAppVersionReadinessCheck): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionReadinessCheckOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionReadinessCheck | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionReadinessCheck | undefined);
    private _appStartTimeout?;
    /**
     * @stability stable
     */
    get appStartTimeout(): string;
    /**
     * @stability stable
     */
    set appStartTimeout(value: string);
    /**
     * @stability stable
     */
    resetAppStartTimeout(): void;
    /**
     * @stability stable
     */
    get appStartTimeoutInput(): string | undefined;
    private _checkInterval?;
    /**
     * @stability stable
     */
    get checkInterval(): string;
    /**
     * @stability stable
     */
    set checkInterval(value: string);
    /**
     * @stability stable
     */
    resetCheckInterval(): void;
    /**
     * @stability stable
     */
    get checkIntervalInput(): string | undefined;
    private _failureThreshold?;
    /**
     * @stability stable
     */
    get failureThreshold(): number;
    /**
     * @stability stable
     */
    set failureThreshold(value: number);
    /**
     * @stability stable
     */
    resetFailureThreshold(): void;
    /**
     * @stability stable
     */
    get failureThresholdInput(): number | undefined;
    private _host?;
    /**
     * @stability stable
     */
    get host(): string;
    /**
     * @stability stable
     */
    set host(value: string);
    /**
     * @stability stable
     */
    resetHost(): void;
    /**
     * @stability stable
     */
    get hostInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _successThreshold?;
    /**
     * @stability stable
     */
    get successThreshold(): number;
    /**
     * @stability stable
     */
    set successThreshold(value: number);
    /**
     * @stability stable
     */
    resetSuccessThreshold(): void;
    /**
     * @stability stable
     */
    get successThresholdInput(): number | undefined;
    private _timeout?;
    /**
     * @stability stable
     */
    get timeout(): string;
    /**
     * @stability stable
     */
    set timeout(value: string);
    /**
     * @stability stable
     */
    resetTimeout(): void;
    /**
     * @stability stable
     */
    get timeoutInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionResourcesVolumes {
    /**
     * Unique name for the volume.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Volume size in gigabytes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#size_gb AppEngineFlexibleAppVersion#size_gb}
     *
     * @stability stable
     */
    readonly sizeGb: number;
    /**
     * Underlying volume type, e.g. 'tmpfs'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#volume_type AppEngineFlexibleAppVersion#volume_type}
     *
     * @stability stable
     */
    readonly volumeType: string;
}
export declare function appEngineFlexibleAppVersionResourcesVolumesToTerraform(struct?: AppEngineFlexibleAppVersionResourcesVolumes): any;
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionResources {
    /**
     * Number of CPU cores needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#cpu AppEngineFlexibleAppVersion#cpu}
     *
     * @stability stable
     */
    readonly cpu?: number;
    /**
     * Disk size (GB) needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#disk_gb AppEngineFlexibleAppVersion#disk_gb}
     *
     * @stability stable
     */
    readonly diskGb?: number;
    /**
     * Memory (GB) needed.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#memory_gb AppEngineFlexibleAppVersion#memory_gb}
     *
     * @stability stable
     */
    readonly memoryGb?: number;
    /**
     * volumes block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#volumes AppEngineFlexibleAppVersion#volumes}
     *
     * @stability stable
     */
    readonly volumes?: AppEngineFlexibleAppVersionResourcesVolumes[];
}
export declare function appEngineFlexibleAppVersionResourcesToTerraform(struct?: AppEngineFlexibleAppVersionResourcesOutputReference | AppEngineFlexibleAppVersionResources): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionResourcesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionResources | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionResources | undefined);
    private _cpu?;
    /**
     * @stability stable
     */
    get cpu(): number;
    /**
     * @stability stable
     */
    set cpu(value: number);
    /**
     * @stability stable
     */
    resetCpu(): void;
    /**
     * @stability stable
     */
    get cpuInput(): number | undefined;
    private _diskGb?;
    /**
     * @stability stable
     */
    get diskGb(): number;
    /**
     * @stability stable
     */
    set diskGb(value: number);
    /**
     * @stability stable
     */
    resetDiskGb(): void;
    /**
     * @stability stable
     */
    get diskGbInput(): number | undefined;
    private _memoryGb?;
    /**
     * @stability stable
     */
    get memoryGb(): number;
    /**
     * @stability stable
     */
    set memoryGb(value: number);
    /**
     * @stability stable
     */
    resetMemoryGb(): void;
    /**
     * @stability stable
     */
    get memoryGbInput(): number | undefined;
    private _volumes?;
    /**
     * @stability stable
     */
    get volumes(): AppEngineFlexibleAppVersionResourcesVolumes[];
    /**
     * @stability stable
     */
    set volumes(value: AppEngineFlexibleAppVersionResourcesVolumes[]);
    /**
     * @stability stable
     */
    resetVolumes(): void;
    /**
     * @stability stable
     */
    get volumesInput(): AppEngineFlexibleAppVersionResourcesVolumes[] | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#create AppEngineFlexibleAppVersion#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#delete AppEngineFlexibleAppVersion#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#update AppEngineFlexibleAppVersion#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function appEngineFlexibleAppVersionTimeoutsToTerraform(struct?: AppEngineFlexibleAppVersionTimeoutsOutputReference | AppEngineFlexibleAppVersionTimeouts): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface AppEngineFlexibleAppVersionVpcAccessConnector {
    /**
     * Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version#name AppEngineFlexibleAppVersion#name}
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function appEngineFlexibleAppVersionVpcAccessConnectorToTerraform(struct?: AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference | AppEngineFlexibleAppVersionVpcAccessConnector): any;
/**
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AppEngineFlexibleAppVersionVpcAccessConnector | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version google_app_engine_flexible_app_version}.
 *
 * @stability stable
 */
export declare class AppEngineFlexibleAppVersion extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/app_engine_flexible_app_version google_app_engine_flexible_app_version} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AppEngineFlexibleAppVersionConfig);
    private _betaSettings?;
    /**
     * @stability stable
     */
    get betaSettings(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set betaSettings(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBetaSettings(): void;
    /**
     * @stability stable
     */
    get betaSettingsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _defaultExpiration?;
    /**
     * @stability stable
     */
    get defaultExpiration(): string;
    /**
     * @stability stable
     */
    set defaultExpiration(value: string);
    /**
     * @stability stable
     */
    resetDefaultExpiration(): void;
    /**
     * @stability stable
     */
    get defaultExpirationInput(): string | undefined;
    private _deleteServiceOnDestroy?;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set deleteServiceOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDeleteServiceOnDestroy(): void;
    /**
     * @stability stable
     */
    get deleteServiceOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _envVariables?;
    /**
     * @stability stable
     */
    get envVariables(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set envVariables(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnvVariables(): void;
    /**
     * @stability stable
     */
    get envVariablesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundServices?;
    /**
     * @stability stable
     */
    get inboundServices(): string[];
    /**
     * @stability stable
     */
    set inboundServices(value: string[]);
    /**
     * @stability stable
     */
    resetInboundServices(): void;
    /**
     * @stability stable
     */
    get inboundServicesInput(): string[] | undefined;
    private _instanceClass?;
    /**
     * @stability stable
     */
    get instanceClass(): string;
    /**
     * @stability stable
     */
    set instanceClass(value: string);
    /**
     * @stability stable
     */
    resetInstanceClass(): void;
    /**
     * @stability stable
     */
    get instanceClassInput(): string | undefined;
    /**
     * @stability stable
     */
    get name(): string;
    private _nobuildFilesRegex?;
    /**
     * @stability stable
     */
    get nobuildFilesRegex(): string;
    /**
     * @stability stable
     */
    set nobuildFilesRegex(value: string);
    /**
     * @stability stable
     */
    resetNobuildFilesRegex(): void;
    /**
     * @stability stable
     */
    get nobuildFilesRegexInput(): string | undefined;
    private _noopOnDestroy?;
    /**
     * @stability stable
     */
    get noopOnDestroy(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set noopOnDestroy(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetNoopOnDestroy(): void;
    /**
     * @stability stable
     */
    get noopOnDestroyInput(): boolean | cdktf.IResolvable | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _runtime?;
    /**
     * @stability stable
     */
    get runtime(): string;
    /**
     * @stability stable
     */
    set runtime(value: string);
    /**
     * @stability stable
     */
    get runtimeInput(): string | undefined;
    private _runtimeApiVersion?;
    /**
     * @stability stable
     */
    get runtimeApiVersion(): string;
    /**
     * @stability stable
     */
    set runtimeApiVersion(value: string);
    /**
     * @stability stable
     */
    resetRuntimeApiVersion(): void;
    /**
     * @stability stable
     */
    get runtimeApiVersionInput(): string | undefined;
    private _runtimeChannel?;
    /**
     * @stability stable
     */
    get runtimeChannel(): string;
    /**
     * @stability stable
     */
    set runtimeChannel(value: string);
    /**
     * @stability stable
     */
    resetRuntimeChannel(): void;
    /**
     * @stability stable
     */
    get runtimeChannelInput(): string | undefined;
    private _runtimeMainExecutablePath?;
    /**
     * @stability stable
     */
    get runtimeMainExecutablePath(): string;
    /**
     * @stability stable
     */
    set runtimeMainExecutablePath(value: string);
    /**
     * @stability stable
     */
    resetRuntimeMainExecutablePath(): void;
    /**
     * @stability stable
     */
    get runtimeMainExecutablePathInput(): string | undefined;
    private _service?;
    /**
     * @stability stable
     */
    get service(): string;
    /**
     * @stability stable
     */
    set service(value: string);
    /**
     * @stability stable
     */
    get serviceInput(): string | undefined;
    private _servingStatus?;
    /**
     * @stability stable
     */
    get servingStatus(): string;
    /**
     * @stability stable
     */
    set servingStatus(value: string);
    /**
     * @stability stable
     */
    resetServingStatus(): void;
    /**
     * @stability stable
     */
    get servingStatusInput(): string | undefined;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    set versionId(value: string);
    /**
     * @stability stable
     */
    resetVersionId(): void;
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    private _apiConfig;
    /**
     * @stability stable
     */
    get apiConfig(): AppEngineFlexibleAppVersionApiConfigOutputReference;
    /**
     * @stability stable
     */
    putApiConfig(value: AppEngineFlexibleAppVersionApiConfig): void;
    /**
     * @stability stable
     */
    resetApiConfig(): void;
    /**
     * @stability stable
     */
    get apiConfigInput(): AppEngineFlexibleAppVersionApiConfig | undefined;
    private _automaticScaling;
    /**
     * @stability stable
     */
    get automaticScaling(): AppEngineFlexibleAppVersionAutomaticScalingOutputReference;
    /**
     * @stability stable
     */
    putAutomaticScaling(value: AppEngineFlexibleAppVersionAutomaticScaling): void;
    /**
     * @stability stable
     */
    resetAutomaticScaling(): void;
    /**
     * @stability stable
     */
    get automaticScalingInput(): AppEngineFlexibleAppVersionAutomaticScaling | undefined;
    private _deployment;
    /**
     * @stability stable
     */
    get deployment(): AppEngineFlexibleAppVersionDeploymentOutputReference;
    /**
     * @stability stable
     */
    putDeployment(value: AppEngineFlexibleAppVersionDeployment): void;
    /**
     * @stability stable
     */
    resetDeployment(): void;
    /**
     * @stability stable
     */
    get deploymentInput(): AppEngineFlexibleAppVersionDeployment | undefined;
    private _endpointsApiService;
    /**
     * @stability stable
     */
    get endpointsApiService(): AppEngineFlexibleAppVersionEndpointsApiServiceOutputReference;
    /**
     * @stability stable
     */
    putEndpointsApiService(value: AppEngineFlexibleAppVersionEndpointsApiService): void;
    /**
     * @stability stable
     */
    resetEndpointsApiService(): void;
    /**
     * @stability stable
     */
    get endpointsApiServiceInput(): AppEngineFlexibleAppVersionEndpointsApiService | undefined;
    private _entrypoint;
    /**
     * @stability stable
     */
    get entrypoint(): AppEngineFlexibleAppVersionEntrypointOutputReference;
    /**
     * @stability stable
     */
    putEntrypoint(value: AppEngineFlexibleAppVersionEntrypoint): void;
    /**
     * @stability stable
     */
    resetEntrypoint(): void;
    /**
     * @stability stable
     */
    get entrypointInput(): AppEngineFlexibleAppVersionEntrypoint | undefined;
    private _handlers?;
    /**
     * @stability stable
     */
    get handlers(): AppEngineFlexibleAppVersionHandlers[];
    /**
     * @stability stable
     */
    set handlers(value: AppEngineFlexibleAppVersionHandlers[]);
    /**
     * @stability stable
     */
    resetHandlers(): void;
    /**
     * @stability stable
     */
    get handlersInput(): AppEngineFlexibleAppVersionHandlers[] | undefined;
    private _livenessCheck;
    /**
     * @stability stable
     */
    get livenessCheck(): AppEngineFlexibleAppVersionLivenessCheckOutputReference;
    /**
     * @stability stable
     */
    putLivenessCheck(value: AppEngineFlexibleAppVersionLivenessCheck): void;
    /**
     * @stability stable
     */
    get livenessCheckInput(): AppEngineFlexibleAppVersionLivenessCheck | undefined;
    private _manualScaling;
    /**
     * @stability stable
     */
    get manualScaling(): AppEngineFlexibleAppVersionManualScalingOutputReference;
    /**
     * @stability stable
     */
    putManualScaling(value: AppEngineFlexibleAppVersionManualScaling): void;
    /**
     * @stability stable
     */
    resetManualScaling(): void;
    /**
     * @stability stable
     */
    get manualScalingInput(): AppEngineFlexibleAppVersionManualScaling | undefined;
    private _network;
    /**
     * @stability stable
     */
    get network(): AppEngineFlexibleAppVersionNetworkOutputReference;
    /**
     * @stability stable
     */
    putNetwork(value: AppEngineFlexibleAppVersionNetwork): void;
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): AppEngineFlexibleAppVersionNetwork | undefined;
    private _readinessCheck;
    /**
     * @stability stable
     */
    get readinessCheck(): AppEngineFlexibleAppVersionReadinessCheckOutputReference;
    /**
     * @stability stable
     */
    putReadinessCheck(value: AppEngineFlexibleAppVersionReadinessCheck): void;
    /**
     * @stability stable
     */
    get readinessCheckInput(): AppEngineFlexibleAppVersionReadinessCheck | undefined;
    private _resources;
    /**
     * @stability stable
     */
    get resources(): AppEngineFlexibleAppVersionResourcesOutputReference;
    /**
     * @stability stable
     */
    putResources(value: AppEngineFlexibleAppVersionResources): void;
    /**
     * @stability stable
     */
    resetResources(): void;
    /**
     * @stability stable
     */
    get resourcesInput(): AppEngineFlexibleAppVersionResources | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AppEngineFlexibleAppVersionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AppEngineFlexibleAppVersionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AppEngineFlexibleAppVersionTimeouts | undefined;
    private _vpcAccessConnector;
    /**
     * @stability stable
     */
    get vpcAccessConnector(): AppEngineFlexibleAppVersionVpcAccessConnectorOutputReference;
    /**
     * @stability stable
     */
    putVpcAccessConnector(value: AppEngineFlexibleAppVersionVpcAccessConnector): void;
    /**
     * @stability stable
     */
    resetVpcAccessConnector(): void;
    /**
     * @stability stable
     */
    get vpcAccessConnectorInput(): AppEngineFlexibleAppVersionVpcAccessConnector | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
