import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyRuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * The Action to perform when the client connection triggers the rule.
     *
     * Can currently be either "allow" or "deny()" where valid values for status are 403, 404, and 502.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#action ComputeFirewallPolicyRule#action}
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * An optional description for this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#description ComputeFirewallPolicyRule#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * The direction in which this rule applies. Possible values: INGRESS, EGRESS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#direction ComputeFirewallPolicyRule#direction}
     *
     * @stability stable
     */
    readonly direction: string;
    /**
     * Denotes whether the firewall policy rule is disabled.
     *
     * When set to true, the firewall policy rule is not enforced and traffic behaves as if it did not exist. If this is unspecified, the firewall policy rule will be enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#disabled ComputeFirewallPolicyRule#disabled}
     *
     * @stability stable
     */
    readonly disabled?: boolean | cdktf.IResolvable;
    /**
     * Denotes whether to enable logging for a particular rule.
     *
     * If logging is enabled, logs will be exported to the configured export destination in Stackdriver. Logs may be exported to BigQuery or Pub/Sub. Note: you cannot enable logging on "goto_next" rules.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#enable_logging ComputeFirewallPolicyRule#enable_logging}
     *
     * @stability stable
     */
    readonly enableLogging?: boolean | cdktf.IResolvable;
    /**
     * The firewall policy of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#firewall_policy ComputeFirewallPolicyRule#firewall_policy}
     *
     * @stability stable
     */
    readonly firewallPolicy: string;
    /**
     * An integer indicating the priority of a rule in the list.
     *
     * The priority must be a positive value between 0 and 2147483647. Rules are evaluated from highest to lowest priority where 0 is the highest priority and 2147483647 is the lowest prority.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#priority ComputeFirewallPolicyRule#priority}
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * A list of network resource URLs to which this rule applies.
     *
     * This field allows you to control which network's VMs get this rule. If this field is left blank, all VMs within the organization will receive the rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#target_resources ComputeFirewallPolicyRule#target_resources}
     *
     * @stability stable
     */
    readonly targetResources?: string[];
    /**
     * A list of service accounts indicating the sets of instances that are applied with this rule.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#target_service_accounts ComputeFirewallPolicyRule#target_service_accounts}
     *
     * @stability stable
     */
    readonly targetServiceAccounts?: string[];
    /**
     * match block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#match ComputeFirewallPolicyRule#match}
     *
     * @stability stable
     */
    readonly match: ComputeFirewallPolicyRuleMatch;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#timeouts ComputeFirewallPolicyRule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeFirewallPolicyRuleTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyRuleMatchLayer4Configs {
    /**
     * The IP protocol to which this rule applies.
     *
     * The protocol type is required when creating a firewall rule. This value can either be one of the following well known protocol strings (`tcp`, `udp`, `icmp`, `esp`, `ah`, `ipip`, `sctp`), or the IP protocol number.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#ip_protocol ComputeFirewallPolicyRule#ip_protocol}
     *
     * @stability stable
     */
    readonly ipProtocol: string;
    /**
     * An optional list of ports to which this rule applies.
     *
     * This field is only applicable for UDP or TCP protocol. Each entry must be either an integer or a range. If not specified, this rule applies to connections through any port. Example inputs include: ``.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#ports ComputeFirewallPolicyRule#ports}
     *
     * @stability stable
     */
    readonly ports?: string[];
}
export declare function computeFirewallPolicyRuleMatchLayer4ConfigsToTerraform(struct?: ComputeFirewallPolicyRuleMatchLayer4Configs): any;
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyRuleMatch {
    /**
     * CIDR IP address range. Maximum number of destination CIDR IP ranges allowed is 256.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#dest_ip_ranges ComputeFirewallPolicyRule#dest_ip_ranges}
     *
     * @stability stable
     */
    readonly destIpRanges?: string[];
    /**
     * CIDR IP address range. Maximum number of source CIDR IP ranges allowed is 256.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#src_ip_ranges ComputeFirewallPolicyRule#src_ip_ranges}
     *
     * @stability stable
     */
    readonly srcIpRanges?: string[];
    /**
     * layer4_configs block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#layer4_configs ComputeFirewallPolicyRule#layer4_configs}
     *
     * @stability stable
     */
    readonly layer4Configs: ComputeFirewallPolicyRuleMatchLayer4Configs[];
}
export declare function computeFirewallPolicyRuleMatchToTerraform(struct?: ComputeFirewallPolicyRuleMatchOutputReference | ComputeFirewallPolicyRuleMatch): any;
/**
 * @stability stable
 */
export declare class ComputeFirewallPolicyRuleMatchOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeFirewallPolicyRuleMatch | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeFirewallPolicyRuleMatch | undefined);
    private _destIpRanges?;
    /**
     * @stability stable
     */
    get destIpRanges(): string[];
    /**
     * @stability stable
     */
    set destIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetDestIpRanges(): void;
    /**
     * @stability stable
     */
    get destIpRangesInput(): string[] | undefined;
    private _srcIpRanges?;
    /**
     * @stability stable
     */
    get srcIpRanges(): string[];
    /**
     * @stability stable
     */
    set srcIpRanges(value: string[]);
    /**
     * @stability stable
     */
    resetSrcIpRanges(): void;
    /**
     * @stability stable
     */
    get srcIpRangesInput(): string[] | undefined;
    private _layer4Configs?;
    /**
     * @stability stable
     */
    get layer4Configs(): ComputeFirewallPolicyRuleMatchLayer4Configs[];
    /**
     * @stability stable
     */
    set layer4Configs(value: ComputeFirewallPolicyRuleMatchLayer4Configs[]);
    /**
     * @stability stable
     */
    get layer4ConfigsInput(): ComputeFirewallPolicyRuleMatchLayer4Configs[] | undefined;
}
/**
 * @stability stable
 */
export interface ComputeFirewallPolicyRuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#create ComputeFirewallPolicyRule#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#delete ComputeFirewallPolicyRule#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule#update ComputeFirewallPolicyRule#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeFirewallPolicyRuleTimeoutsToTerraform(struct?: ComputeFirewallPolicyRuleTimeoutsOutputReference | ComputeFirewallPolicyRuleTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeFirewallPolicyRuleTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeFirewallPolicyRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeFirewallPolicyRuleTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule google_compute_firewall_policy_rule}.
 *
 * @stability stable
 */
export declare class ComputeFirewallPolicyRule extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_firewall_policy_rule google_compute_firewall_policy_rule} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeFirewallPolicyRuleConfig);
    private _action?;
    /**
     * @stability stable
     */
    get action(): string;
    /**
     * @stability stable
     */
    set action(value: string);
    /**
     * @stability stable
     */
    get actionInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _direction?;
    /**
     * @stability stable
     */
    get direction(): string;
    /**
     * @stability stable
     */
    set direction(value: string);
    /**
     * @stability stable
     */
    get directionInput(): string | undefined;
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDisabled(): void;
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLogging?;
    /**
     * @stability stable
     */
    get enableLogging(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableLogging(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableLogging(): void;
    /**
     * @stability stable
     */
    get enableLoggingInput(): boolean | cdktf.IResolvable | undefined;
    private _firewallPolicy?;
    /**
     * @stability stable
     */
    get firewallPolicy(): string;
    /**
     * @stability stable
     */
    set firewallPolicy(value: string);
    /**
     * @stability stable
     */
    get firewallPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kind(): string;
    private _priority?;
    /**
     * @stability stable
     */
    get priority(): number;
    /**
     * @stability stable
     */
    set priority(value: number);
    /**
     * @stability stable
     */
    get priorityInput(): number | undefined;
    /**
     * @stability stable
     */
    get ruleTupleCount(): number;
    private _targetResources?;
    /**
     * @stability stable
     */
    get targetResources(): string[];
    /**
     * @stability stable
     */
    set targetResources(value: string[]);
    /**
     * @stability stable
     */
    resetTargetResources(): void;
    /**
     * @stability stable
     */
    get targetResourcesInput(): string[] | undefined;
    private _targetServiceAccounts?;
    /**
     * @stability stable
     */
    get targetServiceAccounts(): string[];
    /**
     * @stability stable
     */
    set targetServiceAccounts(value: string[]);
    /**
     * @stability stable
     */
    resetTargetServiceAccounts(): void;
    /**
     * @stability stable
     */
    get targetServiceAccountsInput(): string[] | undefined;
    private _match;
    /**
     * @stability stable
     */
    get match(): ComputeFirewallPolicyRuleMatchOutputReference;
    /**
     * @stability stable
     */
    putMatch(value: ComputeFirewallPolicyRuleMatch): void;
    /**
     * @stability stable
     */
    get matchInput(): ComputeFirewallPolicyRuleMatch | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeFirewallPolicyRuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeFirewallPolicyRuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeFirewallPolicyRuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
