import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringRoutesConfigConfig extends cdktf.TerraformMetaArguments {
    /**
     * Whether to export the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#export_custom_routes ComputeNetworkPeeringRoutesConfig#export_custom_routes}
     *
     * @stability stable
     */
    readonly exportCustomRoutes: boolean | cdktf.IResolvable;
    /**
     * Whether to import the custom routes to the peer network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#import_custom_routes ComputeNetworkPeeringRoutesConfig#import_custom_routes}
     *
     * @stability stable
     */
    readonly importCustomRoutes: boolean | cdktf.IResolvable;
    /**
     * The name of the primary network for the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#network ComputeNetworkPeeringRoutesConfig#network}
     *
     * @stability stable
     */
    readonly network: string;
    /**
     * Name of the peering.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#peering ComputeNetworkPeeringRoutesConfig#peering}
     *
     * @stability stable
     */
    readonly peering: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#project ComputeNetworkPeeringRoutesConfig#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#timeouts ComputeNetworkPeeringRoutesConfig#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeNetworkPeeringRoutesConfigTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeNetworkPeeringRoutesConfigTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#create ComputeNetworkPeeringRoutesConfig#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#delete ComputeNetworkPeeringRoutesConfig#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config#update ComputeNetworkPeeringRoutesConfig#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeNetworkPeeringRoutesConfigTimeoutsToTerraform(struct?: ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference | ComputeNetworkPeeringRoutesConfigTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeNetworkPeeringRoutesConfigTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config google_compute_network_peering_routes_config}.
 *
 * @stability stable
 */
export declare class ComputeNetworkPeeringRoutesConfig extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_network_peering_routes_config google_compute_network_peering_routes_config} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeNetworkPeeringRoutesConfigConfig);
    private _exportCustomRoutes?;
    /**
     * @stability stable
     */
    get exportCustomRoutes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set exportCustomRoutes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get exportCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _importCustomRoutes?;
    /**
     * @stability stable
     */
    get importCustomRoutes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set importCustomRoutes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get importCustomRoutesInput(): boolean | cdktf.IResolvable | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _peering?;
    /**
     * @stability stable
     */
    get peering(): string;
    /**
     * @stability stable
     */
    set peering(value: string);
    /**
     * @stability stable
     */
    get peeringInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeNetworkPeeringRoutesConfigTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeNetworkPeeringRoutesConfigTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeNetworkPeeringRoutesConfigTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
