import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ComputeRegionDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * An optional description of this resource. Provide this property when you create the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#description ComputeRegionDisk#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Labels to apply to this disk.  A list of key->value pairs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#labels ComputeRegionDisk#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Name of the resource.
     *
     * Provided by the client when the resource is
     * created. The name must be 1-63 characters long, and comply with
     * RFC1035. Specifically, the name must be 1-63 characters long and match
     * the regular expression '[a-z]([-a-z0-9]*[a-z0-9])?' which means the
     * first character must be a lowercase letter, and all following
     * characters must be a dash, lowercase letter, or digit, except the last
     * character, which cannot be a dash.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#name ComputeRegionDisk#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Physical block size of the persistent disk, in bytes.
     *
     * If not present
     * in a request, a default value is used. Currently supported sizes
     * are 4096 and 16384, other sizes may be added in the future.
     * If an unsupported value is requested, the error message will list
     * the supported values for the caller's project.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#physical_block_size_bytes ComputeRegionDisk#physical_block_size_bytes}
     *
     * @stability stable
     */
    readonly physicalBlockSizeBytes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#project ComputeRegionDisk#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * A reference to the region where the disk resides.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#region ComputeRegionDisk#region}
     *
     * @stability stable
     */
    readonly region?: string;
    /**
     * URLs of the zones where the disk should be replicated to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#replica_zones ComputeRegionDisk#replica_zones}
     *
     * @stability stable
     */
    readonly replicaZones: string[];
    /**
     * Size of the persistent disk, specified in GB.
     *
     * You can specify this
     * field when creating a persistent disk using the sourceImage or
     * sourceSnapshot parameter, or specify it alone to create an empty
     * persistent disk.
     *
     * If you specify this field along with sourceImage or sourceSnapshot,
     * the value of sizeGb must not be less than the size of the sourceImage
     * or the size of the snapshot.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#size ComputeRegionDisk#size}
     *
     * @stability stable
     */
    readonly size?: number;
    /**
     * The source snapshot used to create this disk.
     *
     * You can provide this as
     * a partial or full URL to the resource. For example, the following are
     * valid values:
     *
     * 'https://www.googleapis.com/compute/v1/projects/project/global/snapshots/snapshot'
     * 'projects/project/global/snapshots/snapshot'
     * 'global/snapshots/snapshot'
     * 'snapshot'
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#snapshot ComputeRegionDisk#snapshot}
     *
     * @stability stable
     */
    readonly snapshot?: string;
    /**
     * URL of the disk type resource describing which disk type to use to create the disk.
     *
     * Provide this when creating the disk.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#type ComputeRegionDisk#type}
     *
     * @stability stable
     */
    readonly type?: string;
    /**
     * disk_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#disk_encryption_key ComputeRegionDisk#disk_encryption_key}
     *
     * @stability stable
     */
    readonly diskEncryptionKey?: ComputeRegionDiskDiskEncryptionKey;
    /**
     * source_snapshot_encryption_key block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#source_snapshot_encryption_key ComputeRegionDisk#source_snapshot_encryption_key}
     *
     * @stability stable
     */
    readonly sourceSnapshotEncryptionKey?: ComputeRegionDiskSourceSnapshotEncryptionKey;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#timeouts ComputeRegionDisk#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ComputeRegionDiskTimeouts;
}
/**
 * @stability stable
 */
export interface ComputeRegionDiskDiskEncryptionKey {
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#raw_key ComputeRegionDisk#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
export declare function computeRegionDiskDiskEncryptionKeyToTerraform(struct?: ComputeRegionDiskDiskEncryptionKeyOutputReference | ComputeRegionDiskDiskEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ComputeRegionDiskDiskEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionDiskDiskEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionDiskDiskEncryptionKey | undefined);
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string;
    /**
     * @stability stable
     */
    set rawKey(value: string);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionDiskSourceSnapshotEncryptionKey {
    /**
     * Specifies a 256-bit customer-supplied encryption key, encoded in RFC 4648 base64 to either encrypt or decrypt this resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#raw_key ComputeRegionDisk#raw_key}
     *
     * @stability stable
     */
    readonly rawKey?: string;
}
export declare function computeRegionDiskSourceSnapshotEncryptionKeyToTerraform(struct?: ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference | ComputeRegionDiskSourceSnapshotEncryptionKey): any;
/**
 * @stability stable
 */
export declare class ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionDiskSourceSnapshotEncryptionKey | undefined);
    private _rawKey?;
    /**
     * @stability stable
     */
    get rawKey(): string;
    /**
     * @stability stable
     */
    set rawKey(value: string);
    /**
     * @stability stable
     */
    resetRawKey(): void;
    /**
     * @stability stable
     */
    get rawKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ComputeRegionDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#create ComputeRegionDisk#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#delete ComputeRegionDisk#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk#update ComputeRegionDisk#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function computeRegionDiskTimeoutsToTerraform(struct?: ComputeRegionDiskTimeoutsOutputReference | ComputeRegionDiskTimeouts): any;
/**
 * @stability stable
 */
export declare class ComputeRegionDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ComputeRegionDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ComputeRegionDiskTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk google_compute_region_disk}.
 *
 * @stability stable
 */
export declare class ComputeRegionDisk extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/compute_region_disk google_compute_region_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ComputeRegionDiskConfig);
    /**
     * @stability stable
     */
    get creationTimestamp(): string;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get lastAttachTimestamp(): string;
    /**
     * @stability stable
     */
    get lastDetachTimestamp(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _physicalBlockSizeBytes?;
    /**
     * @stability stable
     */
    get physicalBlockSizeBytes(): number;
    /**
     * @stability stable
     */
    set physicalBlockSizeBytes(value: number);
    /**
     * @stability stable
     */
    resetPhysicalBlockSizeBytes(): void;
    /**
     * @stability stable
     */
    get physicalBlockSizeBytesInput(): number | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _region?;
    /**
     * @stability stable
     */
    get region(): string;
    /**
     * @stability stable
     */
    set region(value: string);
    /**
     * @stability stable
     */
    resetRegion(): void;
    /**
     * @stability stable
     */
    get regionInput(): string | undefined;
    private _replicaZones?;
    /**
     * @stability stable
     */
    get replicaZones(): string[];
    /**
     * @stability stable
     */
    set replicaZones(value: string[]);
    /**
     * @stability stable
     */
    get replicaZonesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    private _size?;
    /**
     * @stability stable
     */
    get size(): number;
    /**
     * @stability stable
     */
    set size(value: number);
    /**
     * @stability stable
     */
    resetSize(): void;
    /**
     * @stability stable
     */
    get sizeInput(): number | undefined;
    private _snapshot?;
    /**
     * @stability stable
     */
    get snapshot(): string;
    /**
     * @stability stable
     */
    set snapshot(value: string);
    /**
     * @stability stable
     */
    resetSnapshot(): void;
    /**
     * @stability stable
     */
    get snapshotInput(): string | undefined;
    /**
     * @stability stable
     */
    get sourceSnapshotId(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    resetType(): void;
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get users(): string[];
    private _diskEncryptionKey;
    /**
     * @stability stable
     */
    get diskEncryptionKey(): ComputeRegionDiskDiskEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putDiskEncryptionKey(value: ComputeRegionDiskDiskEncryptionKey): void;
    /**
     * @stability stable
     */
    resetDiskEncryptionKey(): void;
    /**
     * @stability stable
     */
    get diskEncryptionKeyInput(): ComputeRegionDiskDiskEncryptionKey | undefined;
    private _sourceSnapshotEncryptionKey;
    /**
     * @stability stable
     */
    get sourceSnapshotEncryptionKey(): ComputeRegionDiskSourceSnapshotEncryptionKeyOutputReference;
    /**
     * @stability stable
     */
    putSourceSnapshotEncryptionKey(value: ComputeRegionDiskSourceSnapshotEncryptionKey): void;
    /**
     * @stability stable
     */
    resetSourceSnapshotEncryptionKey(): void;
    /**
     * @stability stable
     */
    get sourceSnapshotEncryptionKeyInput(): ComputeRegionDiskSourceSnapshotEncryptionKey | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ComputeRegionDiskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ComputeRegionDiskTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ComputeRegionDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
