import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * The IP address range of the Kubernetes pods in this cluster in CIDR notation (e.g. 10.96.0.0/14). Leave blank to have one automatically chosen or specify a /14 block in 10.0.0.0/8. This field will only work for routes-based clusters, where ip_allocation_policy is not defined.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr ContainerCluster#cluster_ipv4_cidr}
     *
     * @stability stable
     */
    readonly clusterIpv4Cidr?: string;
    /**
     * The desired datapath provider for this cluster. By default, uses the IPTables-based kube-proxy implementation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#datapath_provider ContainerCluster#datapath_provider}
     *
     * @stability stable
     */
    readonly datapathProvider?: string;
    /**
     * The default maximum number of pods per node in this cluster.
     *
     * This doesn't work on "routes-based" clusters, clusters that don't have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_max_pods_per_node ContainerCluster#default_max_pods_per_node}
     *
     * @stability stable
     */
    readonly defaultMaxPodsPerNode?: number;
    /**
     * Description of the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#description ContainerCluster#description}
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Enable Autopilot for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_autopilot ContainerCluster#enable_autopilot}
     *
     * @stability stable
     */
    readonly enableAutopilot?: boolean | cdktf.IResolvable;
    /**
     * Enable Binary Authorization for this cluster. If enabled, all container images will be validated by Google Binary Authorization.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_binary_authorization ContainerCluster#enable_binary_authorization}
     *
     * @stability stable
     */
    readonly enableBinaryAuthorization?: boolean | cdktf.IResolvable;
    /**
     * Whether Intra-node visibility is enabled for this cluster.
     *
     * This makes same node pod to pod traffic visible for VPC network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_intranode_visibility ContainerCluster#enable_intranode_visibility}
     *
     * @stability stable
     */
    readonly enableIntranodeVisibility?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable Kubernetes Alpha features for this cluster.
     *
     * Note that when this option is enabled, the cluster cannot be upgraded and will be automatically deleted after 30 days.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_kubernetes_alpha ContainerCluster#enable_kubernetes_alpha}
     *
     * @stability stable
     */
    readonly enableKubernetesAlpha?: boolean | cdktf.IResolvable;
    /**
     * Whether the ABAC authorizer is enabled for this cluster.
     *
     * When enabled, identities in the system, including service accounts, nodes, and controllers, will have statically granted permissions beyond those provided by the RBAC configuration or IAM. Defaults to false.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_legacy_abac ContainerCluster#enable_legacy_abac}
     *
     * @stability stable
     */
    readonly enableLegacyAbac?: boolean | cdktf.IResolvable;
    /**
     * Enable Shielded Nodes features on all nodes in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_shielded_nodes ContainerCluster#enable_shielded_nodes}
     *
     * @stability stable
     */
    readonly enableShieldedNodes?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable Cloud TPU resources in this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_tpu ContainerCluster#enable_tpu}
     *
     * @stability stable
     */
    readonly enableTpu?: boolean | cdktf.IResolvable;
    /**
     * The number of nodes to create in this cluster's default node pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Must be set if node_pool is not set. If you're using google_container_node_pool objects with no default node pool, you'll need to set this to a value of at least 1, alongside setting remove_default_node_pool to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The location (region or zone) in which the cluster master will be created, as well as the default node location.
     *
     * If you specify a zone (such as us-central1-a), the cluster will be a zonal cluster with a single cluster master. If you specify a region (such as us-west1), the cluster will be a regional cluster with multiple masters spread across zones in the region, and with default node locations in those zones as well.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#location ContainerCluster#location}
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * The logging service that the cluster should write logs to.
     *
     * Available options include logging.googleapis.com(Legacy Stackdriver), logging.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Logging), and none. Defaults to logging.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_service ContainerCluster#logging_service}
     *
     * @stability stable
     */
    readonly loggingService?: string;
    /**
     * The minimum version of the master.
     *
     * GKE will auto-update the master to new versions, so this does not guarantee the current master version--use the read-only master_version field to obtain that. If unset, the cluster's version will be set by GKE to the version of the most recent official release (which is not necessarily the latest version).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_master_version ContainerCluster#min_master_version}
     *
     * @stability stable
     */
    readonly minMasterVersion?: string;
    /**
     * The monitoring service that the cluster should write metrics to.
     *
     * Automatically send metrics from pods in the cluster to the Google Cloud Monitoring API. VM metrics will be collected by Google Compute Engine regardless of this setting Available options include monitoring.googleapis.com(Legacy Stackdriver), monitoring.googleapis.com/kubernetes(Stackdriver Kubernetes Engine Monitoring), and none. Defaults to monitoring.googleapis.com/kubernetes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_service ContainerCluster#monitoring_service}
     *
     * @stability stable
     */
    readonly monitoringService?: string;
    /**
     * The name of the cluster, unique within the project and location.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * The name or self_link of the Google Compute Engine network to which the cluster is connected.
     *
     * For Shared VPC, set this to the self link of the shared network.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network ContainerCluster#network}
     *
     * @stability stable
     */
    readonly network?: string;
    /**
     * Determines whether alias IPs or routes will be used for pod IPs in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#networking_mode ContainerCluster#networking_mode}
     *
     * @stability stable
     */
    readonly networkingMode?: string;
    /**
     * The list of zones in which the cluster's nodes are located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If this is specified for a zonal cluster, omit the cluster's zone.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version on the nodes.
     *
     * Must either be unset or set to the same value as min_master_version on create. Defaults to the default version set by GKE which is not necessarily the latest version. This only affects nodes in the default node pool. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way. To update nodes in other node pools, use the version attribute on the node pool.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_version ContainerCluster#node_version}
     *
     * @stability stable
     */
    readonly nodeVersion?: string;
    /**
     * The desired state of IPv6 connectivity to Google Services.
     *
     * By default, no private IPv6 access to or from Google Services (all access will be via IPv4).
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_ipv6_google_access ContainerCluster#private_ipv6_google_access}
     *
     * @stability stable
     */
    readonly privateIpv6GoogleAccess?: string;
    /**
     * The ID of the project in which the resource belongs.
     *
     * If it is not provided, the provider project is used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#project ContainerCluster#project}
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * If true, deletes the default node pool upon cluster creation.
     *
     * If you're using google_container_node_pool resources with no default node pool, this should be set to true, alongside setting initial_node_count to at least 1.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#remove_default_node_pool ContainerCluster#remove_default_node_pool}
     *
     * @stability stable
     */
    readonly removeDefaultNodePool?: boolean | cdktf.IResolvable;
    /**
     * The GCE resource labels (a map of key/value pairs) to be applied to the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_labels ContainerCluster#resource_labels}
     *
     * @stability stable
     */
    readonly resourceLabels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The name or self_link of the Google Compute Engine subnetwork in which the cluster's instances are launched.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#subnetwork ContainerCluster#subnetwork}
     *
     * @stability stable
     */
    readonly subnetwork?: string;
    /**
     * addons_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#addons_config ContainerCluster#addons_config}
     *
     * @stability stable
     */
    readonly addonsConfig?: ContainerClusterAddonsConfig;
    /**
     * authenticator_groups_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#authenticator_groups_config ContainerCluster#authenticator_groups_config}
     *
     * @stability stable
     */
    readonly authenticatorGroupsConfig?: ContainerClusterAuthenticatorGroupsConfig;
    /**
     * cluster_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_autoscaling ContainerCluster#cluster_autoscaling}
     *
     * @stability stable
     */
    readonly clusterAutoscaling?: ContainerClusterClusterAutoscaling;
    /**
     * database_encryption block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#database_encryption ContainerCluster#database_encryption}
     *
     * @stability stable
     */
    readonly databaseEncryption?: ContainerClusterDatabaseEncryption;
    /**
     * default_snat_status block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#default_snat_status ContainerCluster#default_snat_status}
     *
     * @stability stable
     */
    readonly defaultSnatStatus?: ContainerClusterDefaultSnatStatus;
    /**
     * ip_allocation_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#ip_allocation_policy ContainerCluster#ip_allocation_policy}
     *
     * @stability stable
     */
    readonly ipAllocationPolicy?: ContainerClusterIpAllocationPolicy;
    /**
     * logging_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#logging_config ContainerCluster#logging_config}
     *
     * @stability stable
     */
    readonly loggingConfig?: ContainerClusterLoggingConfig;
    /**
     * maintenance_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_policy ContainerCluster#maintenance_policy}
     *
     * @stability stable
     */
    readonly maintenancePolicy?: ContainerClusterMaintenancePolicy;
    /**
     * master_auth block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_auth ContainerCluster#master_auth}
     *
     * @stability stable
     */
    readonly masterAuth?: ContainerClusterMasterAuth;
    /**
     * master_authorized_networks_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_authorized_networks_config ContainerCluster#master_authorized_networks_config}
     *
     * @stability stable
     */
    readonly masterAuthorizedNetworksConfig?: ContainerClusterMasterAuthorizedNetworksConfig;
    /**
     * monitoring_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#monitoring_config ContainerCluster#monitoring_config}
     *
     * @stability stable
     */
    readonly monitoringConfig?: ContainerClusterMonitoringConfig;
    /**
     * network_policy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy ContainerCluster#network_policy}
     *
     * @stability stable
     */
    readonly networkPolicy?: ContainerClusterNetworkPolicy;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerClusterNodeConfig;
    /**
     * node_pool block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_pool ContainerCluster#node_pool}
     *
     * @stability stable
     */
    readonly nodePool?: ContainerClusterNodePool[];
    /**
     * pod_security_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#pod_security_policy_config ContainerCluster#pod_security_policy_config}
     *
     * @stability stable
     */
    readonly podSecurityPolicyConfig?: ContainerClusterPodSecurityPolicyConfig;
    /**
     * private_cluster_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#private_cluster_config ContainerCluster#private_cluster_config}
     *
     * @stability stable
     */
    readonly privateClusterConfig?: ContainerClusterPrivateClusterConfig;
    /**
     * release_channel block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#release_channel ContainerCluster#release_channel}
     *
     * @stability stable
     */
    readonly releaseChannel?: ContainerClusterReleaseChannel;
    /**
     * resource_usage_export_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_usage_export_config ContainerCluster#resource_usage_export_config}
     *
     * @stability stable
     */
    readonly resourceUsageExportConfig?: ContainerClusterResourceUsageExportConfig;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#timeouts ContainerCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerClusterTimeouts;
    /**
     * vertical_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#vertical_pod_autoscaling ContainerCluster#vertical_pod_autoscaling}
     *
     * @stability stable
     */
    readonly verticalPodAutoscaling?: ContainerClusterVerticalPodAutoscaling;
    /**
     * workload_identity_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_identity_config ContainerCluster#workload_identity_config}
     *
     * @stability stable
     */
    readonly workloadIdentityConfig?: ContainerClusterWorkloadIdentityConfig;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigCloudrunConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#load_balancer_type ContainerCluster#load_balancer_type}.
     *
     * @stability stable
     */
    readonly loadBalancerType?: string;
}
export declare function containerClusterAddonsConfigCloudrunConfigToTerraform(struct?: ContainerClusterAddonsConfigCloudrunConfigOutputReference | ContainerClusterAddonsConfigCloudrunConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAddonsConfigCloudrunConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAddonsConfigCloudrunConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAddonsConfigCloudrunConfig | undefined);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
    private _loadBalancerType?;
    /**
     * @stability stable
     */
    get loadBalancerType(): string;
    /**
     * @stability stable
     */
    set loadBalancerType(value: string);
    /**
     * @stability stable
     */
    resetLoadBalancerType(): void;
    /**
     * @stability stable
     */
    get loadBalancerTypeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigHorizontalPodAutoscaling {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigHorizontalPodAutoscalingToTerraform(struct?: ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference | ContainerClusterAddonsConfigHorizontalPodAutoscaling): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigHttpLoadBalancing {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigHttpLoadBalancingToTerraform(struct?: ContainerClusterAddonsConfigHttpLoadBalancingOutputReference | ContainerClusterAddonsConfigHttpLoadBalancing): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAddonsConfigHttpLoadBalancingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAddonsConfigHttpLoadBalancing | undefined);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfigNetworkPolicyConfig {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}.
     *
     * @stability stable
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterAddonsConfigNetworkPolicyConfigToTerraform(struct?: ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference | ContainerClusterAddonsConfigNetworkPolicyConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAddonsConfigNetworkPolicyConfig | undefined);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterAddonsConfig {
    /**
     * cloudrun_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cloudrun_config ContainerCluster#cloudrun_config}
     *
     * @stability stable
     */
    readonly cloudrunConfig?: ContainerClusterAddonsConfigCloudrunConfig;
    /**
     * horizontal_pod_autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#horizontal_pod_autoscaling ContainerCluster#horizontal_pod_autoscaling}
     *
     * @stability stable
     */
    readonly horizontalPodAutoscaling?: ContainerClusterAddonsConfigHorizontalPodAutoscaling;
    /**
     * http_load_balancing block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#http_load_balancing ContainerCluster#http_load_balancing}
     *
     * @stability stable
     */
    readonly httpLoadBalancing?: ContainerClusterAddonsConfigHttpLoadBalancing;
    /**
     * network_policy_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#network_policy_config ContainerCluster#network_policy_config}
     *
     * @stability stable
     */
    readonly networkPolicyConfig?: ContainerClusterAddonsConfigNetworkPolicyConfig;
}
export declare function containerClusterAddonsConfigToTerraform(struct?: ContainerClusterAddonsConfigOutputReference | ContainerClusterAddonsConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAddonsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAddonsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAddonsConfig | undefined);
    private _cloudrunConfig;
    /**
     * @stability stable
     */
    get cloudrunConfig(): ContainerClusterAddonsConfigCloudrunConfigOutputReference;
    /**
     * @stability stable
     */
    putCloudrunConfig(value: ContainerClusterAddonsConfigCloudrunConfig): void;
    /**
     * @stability stable
     */
    resetCloudrunConfig(): void;
    /**
     * @stability stable
     */
    get cloudrunConfigInput(): ContainerClusterAddonsConfigCloudrunConfig | undefined;
    private _horizontalPodAutoscaling;
    /**
     * @stability stable
     */
    get horizontalPodAutoscaling(): ContainerClusterAddonsConfigHorizontalPodAutoscalingOutputReference;
    /**
     * @stability stable
     */
    putHorizontalPodAutoscaling(value: ContainerClusterAddonsConfigHorizontalPodAutoscaling): void;
    /**
     * @stability stable
     */
    resetHorizontalPodAutoscaling(): void;
    /**
     * @stability stable
     */
    get horizontalPodAutoscalingInput(): ContainerClusterAddonsConfigHorizontalPodAutoscaling | undefined;
    private _httpLoadBalancing;
    /**
     * @stability stable
     */
    get httpLoadBalancing(): ContainerClusterAddonsConfigHttpLoadBalancingOutputReference;
    /**
     * @stability stable
     */
    putHttpLoadBalancing(value: ContainerClusterAddonsConfigHttpLoadBalancing): void;
    /**
     * @stability stable
     */
    resetHttpLoadBalancing(): void;
    /**
     * @stability stable
     */
    get httpLoadBalancingInput(): ContainerClusterAddonsConfigHttpLoadBalancing | undefined;
    private _networkPolicyConfig;
    /**
     * @stability stable
     */
    get networkPolicyConfig(): ContainerClusterAddonsConfigNetworkPolicyConfigOutputReference;
    /**
     * @stability stable
     */
    putNetworkPolicyConfig(value: ContainerClusterAddonsConfigNetworkPolicyConfig): void;
    /**
     * @stability stable
     */
    resetNetworkPolicyConfig(): void;
    /**
     * @stability stable
     */
    get networkPolicyConfigInput(): ContainerClusterAddonsConfigNetworkPolicyConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterAuthenticatorGroupsConfig {
    /**
     * The name of the RBAC security group for use with Google security groups in Kubernetes RBAC.
     *
     * Group name must be in format gke-security-groups@yourdomain.com.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#security_group ContainerCluster#security_group}
     *
     * @stability stable
     */
    readonly securityGroup: string;
}
export declare function containerClusterAuthenticatorGroupsConfigToTerraform(struct?: ContainerClusterAuthenticatorGroupsConfigOutputReference | ContainerClusterAuthenticatorGroupsConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterAuthenticatorGroupsConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterAuthenticatorGroupsConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterAuthenticatorGroupsConfig | undefined);
    private _securityGroup?;
    /**
     * @stability stable
     */
    get securityGroup(): string;
    /**
     * @stability stable
     */
    set securityGroup(value: string);
    /**
     * @stability stable
     */
    get securityGroupInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscalingAutoProvisioningDefaults {
    /**
     * Scopes that are used by NAP when creating node pools.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
}
export declare function containerClusterClusterAutoscalingAutoProvisioningDefaultsToTerraform(struct?: ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference | ContainerClusterClusterAutoscalingAutoProvisioningDefaults): any;
/**
 * @stability stable
 */
export declare class ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined);
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscalingResourceLimits {
    /**
     * Maximum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maximum ContainerCluster#maximum}
     *
     * @stability stable
     */
    readonly maximum?: number;
    /**
     * Minimum amount of the resource in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#minimum ContainerCluster#minimum}
     *
     * @stability stable
     */
    readonly minimum?: number;
    /**
     * The type of the resource.
     *
     * For example, cpu and memory. See the guide to using Node Auto-Provisioning for a list of types.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_type ContainerCluster#resource_type}
     *
     * @stability stable
     */
    readonly resourceType: string;
}
export declare function containerClusterClusterAutoscalingResourceLimitsToTerraform(struct?: ContainerClusterClusterAutoscalingResourceLimits): any;
/**
 * @stability stable
 */
export interface ContainerClusterClusterAutoscaling {
    /**
     * Whether node auto-provisioning is enabled. Resource limits for cpu and memory must be defined to enable node auto-provisioning.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * auto_provisioning_defaults block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_provisioning_defaults ContainerCluster#auto_provisioning_defaults}
     *
     * @stability stable
     */
    readonly autoProvisioningDefaults?: ContainerClusterClusterAutoscalingAutoProvisioningDefaults;
    /**
     * resource_limits block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#resource_limits ContainerCluster#resource_limits}
     *
     * @stability stable
     */
    readonly resourceLimits?: ContainerClusterClusterAutoscalingResourceLimits[];
}
export declare function containerClusterClusterAutoscalingToTerraform(struct?: ContainerClusterClusterAutoscalingOutputReference | ContainerClusterClusterAutoscaling): any;
/**
 * @stability stable
 */
export declare class ContainerClusterClusterAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterClusterAutoscaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterClusterAutoscaling | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _autoProvisioningDefaults;
    /**
     * @stability stable
     */
    get autoProvisioningDefaults(): ContainerClusterClusterAutoscalingAutoProvisioningDefaultsOutputReference;
    /**
     * @stability stable
     */
    putAutoProvisioningDefaults(value: ContainerClusterClusterAutoscalingAutoProvisioningDefaults): void;
    /**
     * @stability stable
     */
    resetAutoProvisioningDefaults(): void;
    /**
     * @stability stable
     */
    get autoProvisioningDefaultsInput(): ContainerClusterClusterAutoscalingAutoProvisioningDefaults | undefined;
    private _resourceLimits?;
    /**
     * @stability stable
     */
    get resourceLimits(): ContainerClusterClusterAutoscalingResourceLimits[];
    /**
     * @stability stable
     */
    set resourceLimits(value: ContainerClusterClusterAutoscalingResourceLimits[]);
    /**
     * @stability stable
     */
    resetResourceLimits(): void;
    /**
     * @stability stable
     */
    get resourceLimitsInput(): ContainerClusterClusterAutoscalingResourceLimits[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterDatabaseEncryption {
    /**
     * The key to use to encrypt/decrypt secrets.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key_name ContainerCluster#key_name}
     *
     * @stability stable
     */
    readonly keyName?: string;
    /**
     * ENCRYPTED or DECRYPTED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#state ContainerCluster#state}
     *
     * @stability stable
     */
    readonly state: string;
}
export declare function containerClusterDatabaseEncryptionToTerraform(struct?: ContainerClusterDatabaseEncryptionOutputReference | ContainerClusterDatabaseEncryption): any;
/**
 * @stability stable
 */
export declare class ContainerClusterDatabaseEncryptionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterDatabaseEncryption | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterDatabaseEncryption | undefined);
    private _keyName?;
    /**
     * @stability stable
     */
    get keyName(): string;
    /**
     * @stability stable
     */
    set keyName(value: string);
    /**
     * @stability stable
     */
    resetKeyName(): void;
    /**
     * @stability stable
     */
    get keyNameInput(): string | undefined;
    private _state?;
    /**
     * @stability stable
     */
    get state(): string;
    /**
     * @stability stable
     */
    set state(value: string);
    /**
     * @stability stable
     */
    get stateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterDefaultSnatStatus {
    /**
     * When disabled is set to false, default IP masquerade rules will be applied to the nodes to prevent sNAT on cluster internal traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disabled ContainerCluster#disabled}
     *
     * @stability stable
     */
    readonly disabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterDefaultSnatStatusToTerraform(struct?: ContainerClusterDefaultSnatStatusOutputReference | ContainerClusterDefaultSnatStatus): any;
/**
 * @stability stable
 */
export declare class ContainerClusterDefaultSnatStatusOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterDefaultSnatStatus | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterDefaultSnatStatus | undefined);
    private _disabled?;
    /**
     * @stability stable
     */
    get disabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set disabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get disabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterIpAllocationPolicy {
    /**
     * The IP address range for the cluster pod IPs.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_ipv4_cidr_block ContainerCluster#cluster_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly clusterIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for pod IP addresses.
     *
     * Alternatively, cluster_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cluster_secondary_range_name ContainerCluster#cluster_secondary_range_name}
     *
     * @stability stable
     */
    readonly clusterSecondaryRangeName?: string;
    /**
     * The IP address range of the services IPs in this cluster.
     *
     * Set to blank to have a range chosen with the default size. Set to /netmask (e.g. /14) to have a range chosen with a specific netmask. Set to a CIDR notation (e.g. 10.96.0.0/14) from the RFC-1918 private networks (e.g. 10.0.0.0/8, 172.16.0.0/12, 192.168.0.0/16) to pick a specific range to use.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_ipv4_cidr_block ContainerCluster#services_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly servicesIpv4CidrBlock?: string;
    /**
     * The name of the existing secondary range in the cluster's subnetwork to use for service ClusterIPs.
     *
     * Alternatively, services_ipv4_cidr_block can be used to automatically create a GKE-managed one.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#services_secondary_range_name ContainerCluster#services_secondary_range_name}
     *
     * @stability stable
     */
    readonly servicesSecondaryRangeName?: string;
}
export declare function containerClusterIpAllocationPolicyToTerraform(struct?: ContainerClusterIpAllocationPolicyOutputReference | ContainerClusterIpAllocationPolicy): any;
/**
 * @stability stable
 */
export declare class ContainerClusterIpAllocationPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterIpAllocationPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterIpAllocationPolicy | undefined);
    private _clusterIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get clusterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set clusterIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetClusterIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get clusterIpv4CidrBlockInput(): string | undefined;
    private _clusterSecondaryRangeName?;
    /**
     * @stability stable
     */
    get clusterSecondaryRangeName(): string;
    /**
     * @stability stable
     */
    set clusterSecondaryRangeName(value: string);
    /**
     * @stability stable
     */
    resetClusterSecondaryRangeName(): void;
    /**
     * @stability stable
     */
    get clusterSecondaryRangeNameInput(): string | undefined;
    private _servicesIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get servicesIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set servicesIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetServicesIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get servicesIpv4CidrBlockInput(): string | undefined;
    private _servicesSecondaryRangeName?;
    /**
     * @stability stable
     */
    get servicesSecondaryRangeName(): string;
    /**
     * @stability stable
     */
    set servicesSecondaryRangeName(value: string);
    /**
     * @stability stable
     */
    resetServicesSecondaryRangeName(): void;
    /**
     * @stability stable
     */
    get servicesSecondaryRangeNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterLoggingConfig {
    /**
     * GKE components exposing logs. Valid values include SYSTEM_COMPONENTS and WORKLOADS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}
     *
     * @stability stable
     */
    readonly enableComponents: string[];
}
export declare function containerClusterLoggingConfigToTerraform(struct?: ContainerClusterLoggingConfigOutputReference | ContainerClusterLoggingConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterLoggingConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterLoggingConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterLoggingConfig | undefined);
    private _enableComponents?;
    /**
     * @stability stable
     */
    get enableComponents(): string[];
    /**
     * @stability stable
     */
    set enableComponents(value: string[]);
    /**
     * @stability stable
     */
    get enableComponentsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyDailyMaintenanceWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function containerClusterMaintenancePolicyDailyMaintenanceWindowToTerraform(struct?: ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference | ContainerClusterMaintenancePolicyDailyMaintenanceWindow): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined);
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyMaintenanceExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}.
     *
     * @stability stable
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#exclusion_name ContainerCluster#exclusion_name}.
     *
     * @stability stable
     */
    readonly exclusionName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function containerClusterMaintenancePolicyMaintenanceExclusionToTerraform(struct?: ContainerClusterMaintenancePolicyMaintenanceExclusion): any;
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicyRecurringWindow {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#end_time ContainerCluster#end_time}.
     *
     * @stability stable
     */
    readonly endTime: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurrence ContainerCluster#recurrence}.
     *
     * @stability stable
     */
    readonly recurrence: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#start_time ContainerCluster#start_time}.
     *
     * @stability stable
     */
    readonly startTime: string;
}
export declare function containerClusterMaintenancePolicyRecurringWindowToTerraform(struct?: ContainerClusterMaintenancePolicyRecurringWindowOutputReference | ContainerClusterMaintenancePolicyRecurringWindow): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMaintenancePolicyRecurringWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMaintenancePolicyRecurringWindow | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMaintenancePolicyRecurringWindow | undefined);
    private _endTime?;
    /**
     * @stability stable
     */
    get endTime(): string;
    /**
     * @stability stable
     */
    set endTime(value: string);
    /**
     * @stability stable
     */
    get endTimeInput(): string | undefined;
    private _recurrence?;
    /**
     * @stability stable
     */
    get recurrence(): string;
    /**
     * @stability stable
     */
    set recurrence(value: string);
    /**
     * @stability stable
     */
    get recurrenceInput(): string | undefined;
    private _startTime?;
    /**
     * @stability stable
     */
    get startTime(): string;
    /**
     * @stability stable
     */
    set startTime(value: string);
    /**
     * @stability stable
     */
    get startTimeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMaintenancePolicy {
    /**
     * daily_maintenance_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#daily_maintenance_window ContainerCluster#daily_maintenance_window}
     *
     * @stability stable
     */
    readonly dailyMaintenanceWindow?: ContainerClusterMaintenancePolicyDailyMaintenanceWindow;
    /**
     * maintenance_exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#maintenance_exclusion ContainerCluster#maintenance_exclusion}
     *
     * @stability stable
     */
    readonly maintenanceExclusion?: ContainerClusterMaintenancePolicyMaintenanceExclusion[];
    /**
     * recurring_window block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#recurring_window ContainerCluster#recurring_window}
     *
     * @stability stable
     */
    readonly recurringWindow?: ContainerClusterMaintenancePolicyRecurringWindow;
}
export declare function containerClusterMaintenancePolicyToTerraform(struct?: ContainerClusterMaintenancePolicyOutputReference | ContainerClusterMaintenancePolicy): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMaintenancePolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMaintenancePolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMaintenancePolicy | undefined);
    private _dailyMaintenanceWindow;
    /**
     * @stability stable
     */
    get dailyMaintenanceWindow(): ContainerClusterMaintenancePolicyDailyMaintenanceWindowOutputReference;
    /**
     * @stability stable
     */
    putDailyMaintenanceWindow(value: ContainerClusterMaintenancePolicyDailyMaintenanceWindow): void;
    /**
     * @stability stable
     */
    resetDailyMaintenanceWindow(): void;
    /**
     * @stability stable
     */
    get dailyMaintenanceWindowInput(): ContainerClusterMaintenancePolicyDailyMaintenanceWindow | undefined;
    private _maintenanceExclusion?;
    /**
     * @stability stable
     */
    get maintenanceExclusion(): ContainerClusterMaintenancePolicyMaintenanceExclusion[];
    /**
     * @stability stable
     */
    set maintenanceExclusion(value: ContainerClusterMaintenancePolicyMaintenanceExclusion[]);
    /**
     * @stability stable
     */
    resetMaintenanceExclusion(): void;
    /**
     * @stability stable
     */
    get maintenanceExclusionInput(): ContainerClusterMaintenancePolicyMaintenanceExclusion[] | undefined;
    private _recurringWindow;
    /**
     * @stability stable
     */
    get recurringWindow(): ContainerClusterMaintenancePolicyRecurringWindowOutputReference;
    /**
     * @stability stable
     */
    putRecurringWindow(value: ContainerClusterMaintenancePolicyRecurringWindow): void;
    /**
     * @stability stable
     */
    resetRecurringWindow(): void;
    /**
     * @stability stable
     */
    get recurringWindowInput(): ContainerClusterMaintenancePolicyRecurringWindow | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthClientCertificateConfig {
    /**
     * Whether client certificate authorization is enabled for this cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#issue_client_certificate ContainerCluster#issue_client_certificate}
     *
     * @stability stable
     */
    readonly issueClientCertificate: boolean | cdktf.IResolvable;
}
export declare function containerClusterMasterAuthClientCertificateConfigToTerraform(struct?: ContainerClusterMasterAuthClientCertificateConfigOutputReference | ContainerClusterMasterAuthClientCertificateConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMasterAuthClientCertificateConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMasterAuthClientCertificateConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMasterAuthClientCertificateConfig | undefined);
    private _issueClientCertificate?;
    /**
     * @stability stable
     */
    get issueClientCertificate(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set issueClientCertificate(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get issueClientCertificateInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuth {
    /**
     * The password to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#password ContainerCluster#password}
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * The username to use for HTTP basic authentication when accessing the Kubernetes master endpoint.
     *
     * If not present basic auth will be disabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#username ContainerCluster#username}
     *
     * @stability stable
     */
    readonly username?: string;
    /**
     * client_certificate_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#client_certificate_config ContainerCluster#client_certificate_config}
     *
     * @stability stable
     */
    readonly clientCertificateConfig?: ContainerClusterMasterAuthClientCertificateConfig;
}
export declare function containerClusterMasterAuthToTerraform(struct?: ContainerClusterMasterAuthOutputReference | ContainerClusterMasterAuth): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMasterAuthOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMasterAuth | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMasterAuth | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    resetUsername(): void;
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _clientCertificateConfig;
    /**
     * @stability stable
     */
    get clientCertificateConfig(): ContainerClusterMasterAuthClientCertificateConfigOutputReference;
    /**
     * @stability stable
     */
    putClientCertificateConfig(value: ContainerClusterMasterAuthClientCertificateConfig): void;
    /**
     * @stability stable
     */
    resetClientCertificateConfig(): void;
    /**
     * @stability stable
     */
    get clientCertificateConfigInput(): ContainerClusterMasterAuthClientCertificateConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks {
    /**
     * External network that can access Kubernetes master through HTTPS. Must be specified in CIDR notation.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_block ContainerCluster#cidr_block}
     *
     * @stability stable
     */
    readonly cidrBlock: string;
    /**
     * Field for users to identify CIDR blocks.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#display_name ContainerCluster#display_name}
     *
     * @stability stable
     */
    readonly displayName?: string;
}
export declare function containerClusterMasterAuthorizedNetworksConfigCidrBlocksToTerraform(struct?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks): any;
/**
 * @stability stable
 */
export interface ContainerClusterMasterAuthorizedNetworksConfig {
    /**
     * cidr_blocks block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#cidr_blocks ContainerCluster#cidr_blocks}
     *
     * @stability stable
     */
    readonly cidrBlocks?: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[];
}
export declare function containerClusterMasterAuthorizedNetworksConfigToTerraform(struct?: ContainerClusterMasterAuthorizedNetworksConfigOutputReference | ContainerClusterMasterAuthorizedNetworksConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMasterAuthorizedNetworksConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMasterAuthorizedNetworksConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMasterAuthorizedNetworksConfig | undefined);
    private _cidrBlocks?;
    /**
     * @stability stable
     */
    get cidrBlocks(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[];
    /**
     * @stability stable
     */
    set cidrBlocks(value: ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[]);
    /**
     * @stability stable
     */
    resetCidrBlocks(): void;
    /**
     * @stability stable
     */
    get cidrBlocksInput(): ContainerClusterMasterAuthorizedNetworksConfigCidrBlocks[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterMonitoringConfig {
    /**
     * GKE components exposing metrics. Valid values include SYSTEM_COMPONENTS.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_components ContainerCluster#enable_components}
     *
     * @stability stable
     */
    readonly enableComponents: string[];
}
export declare function containerClusterMonitoringConfigToTerraform(struct?: ContainerClusterMonitoringConfigOutputReference | ContainerClusterMonitoringConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterMonitoringConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterMonitoringConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterMonitoringConfig | undefined);
    private _enableComponents?;
    /**
     * @stability stable
     */
    get enableComponents(): string[];
    /**
     * @stability stable
     */
    set enableComponents(value: string[]);
    /**
     * @stability stable
     */
    get enableComponentsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNetworkPolicy {
    /**
     * Whether network policy is enabled on the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
    /**
     * The selected network policy provider. Defaults to PROVIDER_UNSPECIFIED.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#provider ContainerCluster#provider}
     *
     * @stability stable
     */
    readonly provider?: string;
}
export declare function containerClusterNetworkPolicyToTerraform(struct?: ContainerClusterNetworkPolicyOutputReference | ContainerClusterNetworkPolicy): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNetworkPolicy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNetworkPolicy | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _provider?;
    /**
     * @stability stable
     */
    get provider(): string;
    /**
     * @stability stable
     */
    set provider(value: string);
    /**
     * @stability stable
     */
    resetProvider(): void;
    /**
     * @stability stable
     */
    get providerInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}.
     *
     * @stability stable
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function containerClusterNodeConfigGuestAcceleratorToTerraform(struct?: ContainerClusterNodeConfigGuestAccelerator): any;
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function containerClusterNodeConfigTaintToTerraform(struct?: ContainerClusterNodeConfigTaint): any;
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodeConfigShieldedInstanceConfigToTerraform(struct?: ContainerClusterNodeConfigShieldedInstanceConfigOutputReference | ContainerClusterNodeConfigShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_metadata ContainerCluster#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata?: string;
}
export declare function containerClusterNodeConfigWorkloadMetadataConfigToTerraform(struct?: ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference | ContainerClusterNodeConfigWorkloadMetadataConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    /**
     * @stability stable
     */
    get nodeMetadata(): string;
    /**
     * @stability stable
     */
    set nodeMetadata(value: string);
    /**
     * @stability stable
     */
    resetNodeMetadata(): void;
    /**
     * @stability stable
     */
    get nodeMetadataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerClusterNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerClusterNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerClusterNodeConfigWorkloadMetadataConfig;
}
export declare function containerClusterNodeConfigToTerraform(struct?: ContainerClusterNodeConfigOutputReference | ContainerClusterNodeConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodeConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodeConfig | undefined);
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    set diskType(value: string);
    /**
     * @stability stable
     */
    resetDiskType(): void;
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ContainerClusterNodeConfigGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ContainerClusterNodeConfigGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ContainerClusterNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    set imageType(value: string);
    /**
     * @stability stable
     */
    resetImageType(): void;
    /**
     * @stability stable
     */
    get imageTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    /**
     * @stability stable
     */
    get localSsdCount(): number;
    /**
     * @stability stable
     */
    set localSsdCount(value: number);
    /**
     * @stability stable
     */
    resetLocalSsdCount(): void;
    /**
     * @stability stable
     */
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _taint?;
    /**
     * @stability stable
     */
    get taint(): ContainerClusterNodeConfigTaint[];
    /**
     * @stability stable
     */
    set taint(value: ContainerClusterNodeConfigTaint[]);
    /**
     * @stability stable
     */
    resetTaint(): void;
    /**
     * @stability stable
     */
    get taintInput(): ContainerClusterNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ContainerClusterNodeConfigShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ContainerClusterNodeConfigShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ContainerClusterNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    /**
     * @stability stable
     */
    get workloadMetadataConfig(): ContainerClusterNodeConfigWorkloadMetadataConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkloadMetadataConfig(value: ContainerClusterNodeConfigWorkloadMetadataConfig): void;
    /**
     * @stability stable
     */
    resetWorkloadMetadataConfig(): void;
    /**
     * @stability stable
     */
    get workloadMetadataConfigInput(): ContainerClusterNodeConfigWorkloadMetadataConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolAutoscaling {
    /**
     * Maximum number of nodes in the NodePool. Must be >= min_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_node_count ContainerCluster#max_node_count}
     *
     * @stability stable
     */
    readonly maxNodeCount: number;
    /**
     * Minimum number of nodes in the NodePool. Must be >=0 and <= max_node_count.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_node_count ContainerCluster#min_node_count}
     *
     * @stability stable
     */
    readonly minNodeCount: number;
}
export declare function containerClusterNodePoolAutoscalingToTerraform(struct?: ContainerClusterNodePoolAutoscalingOutputReference | ContainerClusterNodePoolAutoscaling): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolAutoscaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolAutoscaling | undefined);
    private _maxNodeCount?;
    /**
     * @stability stable
     */
    get maxNodeCount(): number;
    /**
     * @stability stable
     */
    set maxNodeCount(value: number);
    /**
     * @stability stable
     */
    get maxNodeCountInput(): number | undefined;
    private _minNodeCount?;
    /**
     * @stability stable
     */
    get minNodeCount(): number;
    /**
     * @stability stable
     */
    set minNodeCount(value: number);
    /**
     * @stability stable
     */
    get minNodeCountInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolManagement {
    /**
     * Whether the nodes will be automatically repaired.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_repair ContainerCluster#auto_repair}
     *
     * @stability stable
     */
    readonly autoRepair?: boolean | cdktf.IResolvable;
    /**
     * Whether the nodes will be automatically upgraded.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#auto_upgrade ContainerCluster#auto_upgrade}
     *
     * @stability stable
     */
    readonly autoUpgrade?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolManagementToTerraform(struct?: ContainerClusterNodePoolManagementOutputReference | ContainerClusterNodePoolManagement): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolManagementOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolManagement | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolManagement | undefined);
    private _autoRepair?;
    /**
     * @stability stable
     */
    get autoRepair(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoRepair(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoRepair(): void;
    /**
     * @stability stable
     */
    get autoRepairInput(): boolean | cdktf.IResolvable | undefined;
    private _autoUpgrade?;
    /**
     * @stability stable
     */
    get autoUpgrade(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set autoUpgrade(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAutoUpgrade(): void;
    /**
     * @stability stable
     */
    get autoUpgradeInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigGuestAccelerator {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#count ContainerCluster#count}.
     *
     * @stability stable
     */
    readonly count?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#gpu_partition_size ContainerCluster#gpu_partition_size}.
     *
     * @stability stable
     */
    readonly gpuPartitionSize?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#type ContainerCluster#type}.
     *
     * @stability stable
     */
    readonly type?: string;
}
export declare function containerClusterNodePoolNodeConfigGuestAcceleratorToTerraform(struct?: ContainerClusterNodePoolNodeConfigGuestAccelerator): any;
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigTaint {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#effect ContainerCluster#effect}.
     *
     * @stability stable
     */
    readonly effect?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#key ContainerCluster#key}.
     *
     * @stability stable
     */
    readonly key?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#value ContainerCluster#value}.
     *
     * @stability stable
     */
    readonly value?: string;
}
export declare function containerClusterNodePoolNodeConfigTaintToTerraform(struct?: ContainerClusterNodePoolNodeConfigTaint): any;
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigShieldedInstanceConfig {
    /**
     * Defines whether the instance has integrity monitoring enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_integrity_monitoring ContainerCluster#enable_integrity_monitoring}
     *
     * @stability stable
     */
    readonly enableIntegrityMonitoring?: boolean | cdktf.IResolvable;
    /**
     * Defines whether the instance has Secure Boot enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_secure_boot ContainerCluster#enable_secure_boot}
     *
     * @stability stable
     */
    readonly enableSecureBoot?: boolean | cdktf.IResolvable;
}
export declare function containerClusterNodePoolNodeConfigShieldedInstanceConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference | ContainerClusterNodePoolNodeConfigShieldedInstanceConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined);
    private _enableIntegrityMonitoring?;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoring(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntegrityMonitoring(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntegrityMonitoring(): void;
    /**
     * @stability stable
     */
    get enableIntegrityMonitoringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableSecureBoot?;
    /**
     * @stability stable
     */
    get enableSecureBoot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableSecureBoot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableSecureBoot(): void;
    /**
     * @stability stable
     */
    get enableSecureBootInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig {
    /**
     * Mode is the configuration for how to expose metadata to workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#mode ContainerCluster#mode}
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * NodeMetadata is the configuration for how to expose metadata to the workloads running on the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_metadata ContainerCluster#node_metadata}
     *
     * @stability stable
     */
    readonly nodeMetadata?: string;
}
export declare function containerClusterNodePoolNodeConfigWorkloadMetadataConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference | ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined);
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _nodeMetadata?;
    /**
     * @stability stable
     */
    get nodeMetadata(): string;
    /**
     * @stability stable
     */
    set nodeMetadata(value: string);
    /**
     * @stability stable
     */
    resetNodeMetadata(): void;
    /**
     * @stability stable
     */
    get nodeMetadataInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolNodeConfig {
    /**
     * Size of the disk attached to each node, specified in GB. The smallest allowed disk size is 10GB.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_size_gb ContainerCluster#disk_size_gb}
     *
     * @stability stable
     */
    readonly diskSizeGb?: number;
    /**
     * Type of the disk attached to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#disk_type ContainerCluster#disk_type}
     *
     * @stability stable
     */
    readonly diskType?: string;
    /**
     * List of the type and count of accelerator cards attached to the instance.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#guest_accelerator ContainerCluster#guest_accelerator}
     *
     * @stability stable
     */
    readonly guestAccelerator?: ContainerClusterNodePoolNodeConfigGuestAccelerator[];
    /**
     * The image type to use for this node.
     *
     * Note that for a given image type, the latest version of it will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#image_type ContainerCluster#image_type}
     *
     * @stability stable
     */
    readonly imageType?: string;
    /**
     * The map of Kubernetes labels (key/value pairs) to be applied to each node.
     *
     * These will added in addition to any default label(s) that Kubernetes may apply to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#labels ContainerCluster#labels}
     *
     * @stability stable
     */
    readonly labels?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * The number of local SSD disks to be attached to the node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#local_ssd_count ContainerCluster#local_ssd_count}
     *
     * @stability stable
     */
    readonly localSsdCount?: number;
    /**
     * The name of a Google Compute Engine machine type.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#machine_type ContainerCluster#machine_type}
     *
     * @stability stable
     */
    readonly machineType?: string;
    /**
     * The metadata key/value pairs assigned to instances in the cluster.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#metadata ContainerCluster#metadata}
     *
     * @stability stable
     */
    readonly metadata?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Minimum CPU platform to be used by this instance.
     *
     * The instance may be scheduled on the specified or newer CPU platform.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#min_cpu_platform ContainerCluster#min_cpu_platform}
     *
     * @stability stable
     */
    readonly minCpuPlatform?: string;
    /**
     * The set of Google API scopes to be made available on all of the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#oauth_scopes ContainerCluster#oauth_scopes}
     *
     * @stability stable
     */
    readonly oauthScopes?: string[];
    /**
     * Whether the nodes are created as preemptible VM instances.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#preemptible ContainerCluster#preemptible}
     *
     * @stability stable
     */
    readonly preemptible?: boolean | cdktf.IResolvable;
    /**
     * The Google Cloud Platform Service Account to be used by the node VMs.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#service_account ContainerCluster#service_account}
     *
     * @stability stable
     */
    readonly serviceAccount?: string;
    /**
     * The list of instance tags applied to all nodes.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#tags ContainerCluster#tags}
     *
     * @stability stable
     */
    readonly tags?: string[];
    /**
     * List of Kubernetes taints to be applied to each node.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#taint ContainerCluster#taint}
     *
     * @stability stable
     */
    readonly taint?: ContainerClusterNodePoolNodeConfigTaint[];
    /**
     * shielded_instance_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#shielded_instance_config ContainerCluster#shielded_instance_config}
     *
     * @stability stable
     */
    readonly shieldedInstanceConfig?: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig;
    /**
     * workload_metadata_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_metadata_config ContainerCluster#workload_metadata_config}
     *
     * @stability stable
     */
    readonly workloadMetadataConfig?: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig;
}
export declare function containerClusterNodePoolNodeConfigToTerraform(struct?: ContainerClusterNodePoolNodeConfigOutputReference | ContainerClusterNodePoolNodeConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolNodeConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolNodeConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolNodeConfig | undefined);
    private _diskSizeGb?;
    /**
     * @stability stable
     */
    get diskSizeGb(): number;
    /**
     * @stability stable
     */
    set diskSizeGb(value: number);
    /**
     * @stability stable
     */
    resetDiskSizeGb(): void;
    /**
     * @stability stable
     */
    get diskSizeGbInput(): number | undefined;
    private _diskType?;
    /**
     * @stability stable
     */
    get diskType(): string;
    /**
     * @stability stable
     */
    set diskType(value: string);
    /**
     * @stability stable
     */
    resetDiskType(): void;
    /**
     * @stability stable
     */
    get diskTypeInput(): string | undefined;
    private _guestAccelerator?;
    /**
     * @stability stable
     */
    get guestAccelerator(): ContainerClusterNodePoolNodeConfigGuestAccelerator[];
    /**
     * @stability stable
     */
    set guestAccelerator(value: ContainerClusterNodePoolNodeConfigGuestAccelerator[]);
    /**
     * @stability stable
     */
    resetGuestAccelerator(): void;
    /**
     * @stability stable
     */
    get guestAcceleratorInput(): ContainerClusterNodePoolNodeConfigGuestAccelerator[] | undefined;
    private _imageType?;
    /**
     * @stability stable
     */
    get imageType(): string;
    /**
     * @stability stable
     */
    set imageType(value: string);
    /**
     * @stability stable
     */
    resetImageType(): void;
    /**
     * @stability stable
     */
    get imageTypeInput(): string | undefined;
    private _labels?;
    /**
     * @stability stable
     */
    get labels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set labels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetLabels(): void;
    /**
     * @stability stable
     */
    get labelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _localSsdCount?;
    /**
     * @stability stable
     */
    get localSsdCount(): number;
    /**
     * @stability stable
     */
    set localSsdCount(value: number);
    /**
     * @stability stable
     */
    resetLocalSsdCount(): void;
    /**
     * @stability stable
     */
    get localSsdCountInput(): number | undefined;
    private _machineType?;
    /**
     * @stability stable
     */
    get machineType(): string;
    /**
     * @stability stable
     */
    set machineType(value: string);
    /**
     * @stability stable
     */
    resetMachineType(): void;
    /**
     * @stability stable
     */
    get machineTypeInput(): string | undefined;
    private _metadata?;
    /**
     * @stability stable
     */
    get metadata(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set metadata(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetMetadata(): void;
    /**
     * @stability stable
     */
    get metadataInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _minCpuPlatform?;
    /**
     * @stability stable
     */
    get minCpuPlatform(): string;
    /**
     * @stability stable
     */
    set minCpuPlatform(value: string);
    /**
     * @stability stable
     */
    resetMinCpuPlatform(): void;
    /**
     * @stability stable
     */
    get minCpuPlatformInput(): string | undefined;
    private _oauthScopes?;
    /**
     * @stability stable
     */
    get oauthScopes(): string[];
    /**
     * @stability stable
     */
    set oauthScopes(value: string[]);
    /**
     * @stability stable
     */
    resetOauthScopes(): void;
    /**
     * @stability stable
     */
    get oauthScopesInput(): string[] | undefined;
    private _preemptible?;
    /**
     * @stability stable
     */
    get preemptible(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set preemptible(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPreemptible(): void;
    /**
     * @stability stable
     */
    get preemptibleInput(): boolean | cdktf.IResolvable | undefined;
    private _serviceAccount?;
    /**
     * @stability stable
     */
    get serviceAccount(): string;
    /**
     * @stability stable
     */
    set serviceAccount(value: string);
    /**
     * @stability stable
     */
    resetServiceAccount(): void;
    /**
     * @stability stable
     */
    get serviceAccountInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): string[];
    /**
     * @stability stable
     */
    set tags(value: string[]);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): string[] | undefined;
    private _taint?;
    /**
     * @stability stable
     */
    get taint(): ContainerClusterNodePoolNodeConfigTaint[];
    /**
     * @stability stable
     */
    set taint(value: ContainerClusterNodePoolNodeConfigTaint[]);
    /**
     * @stability stable
     */
    resetTaint(): void;
    /**
     * @stability stable
     */
    get taintInput(): ContainerClusterNodePoolNodeConfigTaint[] | undefined;
    private _shieldedInstanceConfig;
    /**
     * @stability stable
     */
    get shieldedInstanceConfig(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfigOutputReference;
    /**
     * @stability stable
     */
    putShieldedInstanceConfig(value: ContainerClusterNodePoolNodeConfigShieldedInstanceConfig): void;
    /**
     * @stability stable
     */
    resetShieldedInstanceConfig(): void;
    /**
     * @stability stable
     */
    get shieldedInstanceConfigInput(): ContainerClusterNodePoolNodeConfigShieldedInstanceConfig | undefined;
    private _workloadMetadataConfig;
    /**
     * @stability stable
     */
    get workloadMetadataConfig(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkloadMetadataConfig(value: ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig): void;
    /**
     * @stability stable
     */
    resetWorkloadMetadataConfig(): void;
    /**
     * @stability stable
     */
    get workloadMetadataConfigInput(): ContainerClusterNodePoolNodeConfigWorkloadMetadataConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePoolUpgradeSettings {
    /**
     * The number of additional nodes that can be added to the node pool during an upgrade.
     *
     * Increasing max_surge raises the number of nodes that can be upgraded simultaneously. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_surge ContainerCluster#max_surge}
     *
     * @stability stable
     */
    readonly maxSurge: number;
    /**
     * The number of nodes that can be simultaneously unavailable during an upgrade.
     *
     * Increasing max_unavailable raises the number of nodes that can be upgraded in parallel. Can be set to 0 or greater.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_unavailable ContainerCluster#max_unavailable}
     *
     * @stability stable
     */
    readonly maxUnavailable: number;
}
export declare function containerClusterNodePoolUpgradeSettingsToTerraform(struct?: ContainerClusterNodePoolUpgradeSettingsOutputReference | ContainerClusterNodePoolUpgradeSettings): any;
/**
 * @stability stable
 */
export declare class ContainerClusterNodePoolUpgradeSettingsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterNodePoolUpgradeSettings | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterNodePoolUpgradeSettings | undefined);
    private _maxSurge?;
    /**
     * @stability stable
     */
    get maxSurge(): number;
    /**
     * @stability stable
     */
    set maxSurge(value: number);
    /**
     * @stability stable
     */
    get maxSurgeInput(): number | undefined;
    private _maxUnavailable?;
    /**
     * @stability stable
     */
    get maxUnavailable(): number;
    /**
     * @stability stable
     */
    set maxUnavailable(value: number);
    /**
     * @stability stable
     */
    get maxUnavailableInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterNodePool {
    /**
     * The initial number of nodes for the pool.
     *
     * In regional or multi-zonal clusters, this is the number of nodes per zone. Changing this will force recreation of the resource.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#initial_node_count ContainerCluster#initial_node_count}
     *
     * @stability stable
     */
    readonly initialNodeCount?: number;
    /**
     * The maximum number of pods per node in this node pool.
     *
     * Note that this does not work on node pools which are "route-based" - that is, node pools belonging to clusters that do not have IP Aliasing enabled.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#max_pods_per_node ContainerCluster#max_pods_per_node}
     *
     * @stability stable
     */
    readonly maxPodsPerNode?: number;
    /**
     * The name of the node pool. If left blank, Terraform will auto-generate a unique name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name ContainerCluster#name}
     *
     * @stability stable
     */
    readonly name?: string;
    /**
     * Creates a unique name for the node pool beginning with the specified prefix. Conflicts with name.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#name_prefix ContainerCluster#name_prefix}
     *
     * @stability stable
     */
    readonly namePrefix?: string;
    /**
     * The number of nodes per instance group.
     *
     * This field can be used to update the number of nodes per instance group but should not be used alongside autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_count ContainerCluster#node_count}
     *
     * @stability stable
     */
    readonly nodeCount?: number;
    /**
     * The list of zones in which the node pool's nodes should be located.
     *
     * Nodes must be in the region of their regional cluster or in the same region as their cluster's zone for zonal clusters. If unspecified, the cluster-level node_locations will be used.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_locations ContainerCluster#node_locations}
     *
     * @stability stable
     */
    readonly nodeLocations?: string[];
    /**
     * The Kubernetes version for the nodes in this pool.
     *
     * Note that if this field and auto_upgrade are both specified, they will fight each other for what the node version should be, so setting both is highly discouraged. While a fuzzy version can be specified, it's recommended that you specify explicit versions as Terraform will see spurious diffs when fuzzy versions are used. See the google_container_engine_versions data source's version_prefix field to approximate fuzzy versions in a Terraform-compatible way.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#version ContainerCluster#version}
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * autoscaling block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#autoscaling ContainerCluster#autoscaling}
     *
     * @stability stable
     */
    readonly autoscaling?: ContainerClusterNodePoolAutoscaling;
    /**
     * management block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#management ContainerCluster#management}
     *
     * @stability stable
     */
    readonly management?: ContainerClusterNodePoolManagement;
    /**
     * node_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#node_config ContainerCluster#node_config}
     *
     * @stability stable
     */
    readonly nodeConfig?: ContainerClusterNodePoolNodeConfig;
    /**
     * upgrade_settings block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#upgrade_settings ContainerCluster#upgrade_settings}
     *
     * @stability stable
     */
    readonly upgradeSettings?: ContainerClusterNodePoolUpgradeSettings;
}
export declare function containerClusterNodePoolToTerraform(struct?: ContainerClusterNodePool): any;
/**
 * @stability stable
 */
export interface ContainerClusterPodSecurityPolicyConfig {
    /**
     * Enable the PodSecurityPolicy controller for this cluster. If enabled, pods must be valid under a PodSecurityPolicy to be created.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterPodSecurityPolicyConfigToTerraform(struct?: ContainerClusterPodSecurityPolicyConfigOutputReference | ContainerClusterPodSecurityPolicyConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterPodSecurityPolicyConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterPodSecurityPolicyConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterPodSecurityPolicyConfig | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig {
    /**
     * Whether the cluster master is accessible globally or not.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterPrivateClusterConfigMasterGlobalAccessConfigToTerraform(struct?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference | ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterPrivateClusterConfig {
    /**
     * Enables the private cluster feature, creating a private endpoint on the cluster.
     *
     * In a private cluster, nodes only have RFC 1918 private addresses and communicate with the master's private endpoint via private networking.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_endpoint ContainerCluster#enable_private_endpoint}
     *
     * @stability stable
     */
    readonly enablePrivateEndpoint: boolean | cdktf.IResolvable;
    /**
     * When true, the cluster's private endpoint is used as the cluster endpoint and access through the public endpoint is disabled.
     *
     * When false, either endpoint can be used. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_private_nodes ContainerCluster#enable_private_nodes}
     *
     * @stability stable
     */
    readonly enablePrivateNodes?: boolean | cdktf.IResolvable;
    /**
     * The IP range in CIDR notation to use for the hosted master network.
     *
     * This range will be used for assigning private IP addresses to the cluster master(s) and the ILB VIP. This range must not overlap with any other ranges in use within the cluster's network, and it must be a /28 subnet. See Private Cluster Limitations for more details. This field only applies to private clusters, when enable_private_nodes is true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_ipv4_cidr_block ContainerCluster#master_ipv4_cidr_block}
     *
     * @stability stable
     */
    readonly masterIpv4CidrBlock?: string;
    /**
     * master_global_access_config block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#master_global_access_config ContainerCluster#master_global_access_config}
     *
     * @stability stable
     */
    readonly masterGlobalAccessConfig?: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig;
}
export declare function containerClusterPrivateClusterConfigToTerraform(struct?: ContainerClusterPrivateClusterConfigOutputReference | ContainerClusterPrivateClusterConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterPrivateClusterConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterPrivateClusterConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterPrivateClusterConfig | undefined);
    private _enablePrivateEndpoint?;
    /**
     * @stability stable
     */
    get enablePrivateEndpoint(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePrivateEndpoint(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enablePrivateEndpointInput(): boolean | cdktf.IResolvable | undefined;
    private _enablePrivateNodes?;
    /**
     * @stability stable
     */
    get enablePrivateNodes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePrivateNodes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePrivateNodes(): void;
    /**
     * @stability stable
     */
    get enablePrivateNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _masterIpv4CidrBlock?;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlock(): string;
    /**
     * @stability stable
     */
    set masterIpv4CidrBlock(value: string);
    /**
     * @stability stable
     */
    resetMasterIpv4CidrBlock(): void;
    /**
     * @stability stable
     */
    get masterIpv4CidrBlockInput(): string | undefined;
    private _masterGlobalAccessConfig;
    /**
     * @stability stable
     */
    get masterGlobalAccessConfig(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfigOutputReference;
    /**
     * @stability stable
     */
    putMasterGlobalAccessConfig(value: ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig): void;
    /**
     * @stability stable
     */
    resetMasterGlobalAccessConfig(): void;
    /**
     * @stability stable
     */
    get masterGlobalAccessConfigInput(): ContainerClusterPrivateClusterConfigMasterGlobalAccessConfig | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterReleaseChannel {
    /**
     * The selected release channel.
     *
     * Accepted values are:
     * UNSPECIFIED: Not set.
     * RAPID: Weekly upgrade cadence; Early testers and developers who requires new features.
     * REGULAR: Multiple per month upgrade cadence; Production users who need features not yet offered in the Stable channel.
     * STABLE: Every few months upgrade cadence; Production users who need stability above all else, and for whom frequent upgrades are too risky.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#channel ContainerCluster#channel}
     *
     * @stability stable
     */
    readonly channel: string;
}
export declare function containerClusterReleaseChannelToTerraform(struct?: ContainerClusterReleaseChannelOutputReference | ContainerClusterReleaseChannel): any;
/**
 * @stability stable
 */
export declare class ContainerClusterReleaseChannelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterReleaseChannel | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterReleaseChannel | undefined);
    private _channel?;
    /**
     * @stability stable
     */
    get channel(): string;
    /**
     * @stability stable
     */
    set channel(value: string);
    /**
     * @stability stable
     */
    get channelInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterResourceUsageExportConfigBigqueryDestination {
    /**
     * The ID of a BigQuery Dataset.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#dataset_id ContainerCluster#dataset_id}
     *
     * @stability stable
     */
    readonly datasetId: string;
}
export declare function containerClusterResourceUsageExportConfigBigqueryDestinationToTerraform(struct?: ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference | ContainerClusterResourceUsageExportConfigBigqueryDestination): any;
/**
 * @stability stable
 */
export declare class ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined);
    private _datasetId?;
    /**
     * @stability stable
     */
    get datasetId(): string;
    /**
     * @stability stable
     */
    set datasetId(value: string);
    /**
     * @stability stable
     */
    get datasetIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterResourceUsageExportConfig {
    /**
     * Whether to enable network egress metering for this cluster.
     *
     * If enabled, a daemonset will be created in the cluster to meter network egress traffic.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_network_egress_metering ContainerCluster#enable_network_egress_metering}
     *
     * @stability stable
     */
    readonly enableNetworkEgressMetering?: boolean | cdktf.IResolvable;
    /**
     * Whether to enable resource consumption metering on this cluster.
     *
     * When enabled, a table will be created in the resource export BigQuery dataset to store resource consumption data. The resulting table can be joined with the resource usage table or with BigQuery billing export. Defaults to true.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enable_resource_consumption_metering ContainerCluster#enable_resource_consumption_metering}
     *
     * @stability stable
     */
    readonly enableResourceConsumptionMetering?: boolean | cdktf.IResolvable;
    /**
     * bigquery_destination block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#bigquery_destination ContainerCluster#bigquery_destination}
     *
     * @stability stable
     */
    readonly bigqueryDestination: ContainerClusterResourceUsageExportConfigBigqueryDestination;
}
export declare function containerClusterResourceUsageExportConfigToTerraform(struct?: ContainerClusterResourceUsageExportConfigOutputReference | ContainerClusterResourceUsageExportConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterResourceUsageExportConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterResourceUsageExportConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterResourceUsageExportConfig | undefined);
    private _enableNetworkEgressMetering?;
    /**
     * @stability stable
     */
    get enableNetworkEgressMetering(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableNetworkEgressMetering(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableNetworkEgressMetering(): void;
    /**
     * @stability stable
     */
    get enableNetworkEgressMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _enableResourceConsumptionMetering?;
    /**
     * @stability stable
     */
    get enableResourceConsumptionMetering(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableResourceConsumptionMetering(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableResourceConsumptionMetering(): void;
    /**
     * @stability stable
     */
    get enableResourceConsumptionMeteringInput(): boolean | cdktf.IResolvable | undefined;
    private _bigqueryDestination;
    /**
     * @stability stable
     */
    get bigqueryDestination(): ContainerClusterResourceUsageExportConfigBigqueryDestinationOutputReference;
    /**
     * @stability stable
     */
    putBigqueryDestination(value: ContainerClusterResourceUsageExportConfigBigqueryDestination): void;
    /**
     * @stability stable
     */
    get bigqueryDestinationInput(): ContainerClusterResourceUsageExportConfigBigqueryDestination | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#create ContainerCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#delete ContainerCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#read ContainerCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#update ContainerCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function containerClusterTimeoutsToTerraform(struct?: ContainerClusterTimeoutsOutputReference | ContainerClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class ContainerClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterVerticalPodAutoscaling {
    /**
     * Enables vertical pod autoscaling.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#enabled ContainerCluster#enabled}
     *
     * @stability stable
     */
    readonly enabled: boolean | cdktf.IResolvable;
}
export declare function containerClusterVerticalPodAutoscalingToTerraform(struct?: ContainerClusterVerticalPodAutoscalingOutputReference | ContainerClusterVerticalPodAutoscaling): any;
/**
 * @stability stable
 */
export declare class ContainerClusterVerticalPodAutoscalingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterVerticalPodAutoscaling | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterVerticalPodAutoscaling | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
}
/**
 * @stability stable
 */
export interface ContainerClusterWorkloadIdentityConfig {
    /**
     * Enables workload identity.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#identity_namespace ContainerCluster#identity_namespace}
     *
     * @stability stable
     */
    readonly identityNamespace?: string;
    /**
     * The workload pool to attach all Kubernetes service accounts to.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/container_cluster#workload_pool ContainerCluster#workload_pool}
     *
     * @stability stable
     */
    readonly workloadPool?: string;
}
export declare function containerClusterWorkloadIdentityConfigToTerraform(struct?: ContainerClusterWorkloadIdentityConfigOutputReference | ContainerClusterWorkloadIdentityConfig): any;
/**
 * @stability stable
 */
export declare class ContainerClusterWorkloadIdentityConfigOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerClusterWorkloadIdentityConfig | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerClusterWorkloadIdentityConfig | undefined);
    private _identityNamespace?;
    /**
     * @stability stable
     */
    get identityNamespace(): string;
    /**
     * @stability stable
     */
    set identityNamespace(value: string);
    /**
     * @stability stable
     */
    resetIdentityNamespace(): void;
    /**
     * @stability stable
     */
    get identityNamespaceInput(): string | undefined;
    private _workloadPool?;
    /**
     * @stability stable
     */
    get workloadPool(): string;
    /**
     * @stability stable
     */
    set workloadPool(value: string);
    /**
     * @stability stable
     */
    resetWorkloadPool(): void;
    /**
     * @stability stable
     */
    get workloadPoolInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/container_cluster google_container_cluster}.
 *
 * @stability stable
 */
export declare class ContainerCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/container_cluster google_container_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerClusterConfig);
    private _clusterIpv4Cidr?;
    /**
     * @stability stable
     */
    get clusterIpv4Cidr(): string;
    /**
     * @stability stable
     */
    set clusterIpv4Cidr(value: string);
    /**
     * @stability stable
     */
    resetClusterIpv4Cidr(): void;
    /**
     * @stability stable
     */
    get clusterIpv4CidrInput(): string | undefined;
    private _datapathProvider?;
    /**
     * @stability stable
     */
    get datapathProvider(): string;
    /**
     * @stability stable
     */
    set datapathProvider(value: string);
    /**
     * @stability stable
     */
    resetDatapathProvider(): void;
    /**
     * @stability stable
     */
    get datapathProviderInput(): string | undefined;
    private _defaultMaxPodsPerNode?;
    /**
     * @stability stable
     */
    get defaultMaxPodsPerNode(): number;
    /**
     * @stability stable
     */
    set defaultMaxPodsPerNode(value: number);
    /**
     * @stability stable
     */
    resetDefaultMaxPodsPerNode(): void;
    /**
     * @stability stable
     */
    get defaultMaxPodsPerNodeInput(): number | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _enableAutopilot?;
    /**
     * @stability stable
     */
    get enableAutopilot(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableAutopilot(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableAutopilot(): void;
    /**
     * @stability stable
     */
    get enableAutopilotInput(): boolean | cdktf.IResolvable | undefined;
    private _enableBinaryAuthorization?;
    /**
     * @stability stable
     */
    get enableBinaryAuthorization(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableBinaryAuthorization(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableBinaryAuthorization(): void;
    /**
     * @stability stable
     */
    get enableBinaryAuthorizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableIntranodeVisibility?;
    /**
     * @stability stable
     */
    get enableIntranodeVisibility(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableIntranodeVisibility(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableIntranodeVisibility(): void;
    /**
     * @stability stable
     */
    get enableIntranodeVisibilityInput(): boolean | cdktf.IResolvable | undefined;
    private _enableKubernetesAlpha?;
    /**
     * @stability stable
     */
    get enableKubernetesAlpha(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableKubernetesAlpha(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableKubernetesAlpha(): void;
    /**
     * @stability stable
     */
    get enableKubernetesAlphaInput(): boolean | cdktf.IResolvable | undefined;
    private _enableLegacyAbac?;
    /**
     * @stability stable
     */
    get enableLegacyAbac(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableLegacyAbac(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableLegacyAbac(): void;
    /**
     * @stability stable
     */
    get enableLegacyAbacInput(): boolean | cdktf.IResolvable | undefined;
    private _enableShieldedNodes?;
    /**
     * @stability stable
     */
    get enableShieldedNodes(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableShieldedNodes(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableShieldedNodes(): void;
    /**
     * @stability stable
     */
    get enableShieldedNodesInput(): boolean | cdktf.IResolvable | undefined;
    private _enableTpu?;
    /**
     * @stability stable
     */
    get enableTpu(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enableTpu(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnableTpu(): void;
    /**
     * @stability stable
     */
    get enableTpuInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _initialNodeCount?;
    /**
     * @stability stable
     */
    get initialNodeCount(): number;
    /**
     * @stability stable
     */
    set initialNodeCount(value: number);
    /**
     * @stability stable
     */
    resetInitialNodeCount(): void;
    /**
     * @stability stable
     */
    get initialNodeCountInput(): number | undefined;
    /**
     * @stability stable
     */
    get instanceGroupUrls(): string[];
    /**
     * @stability stable
     */
    get labelFingerprint(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    resetLocation(): void;
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _loggingService?;
    /**
     * @stability stable
     */
    get loggingService(): string;
    /**
     * @stability stable
     */
    set loggingService(value: string);
    /**
     * @stability stable
     */
    resetLoggingService(): void;
    /**
     * @stability stable
     */
    get loggingServiceInput(): string | undefined;
    /**
     * @stability stable
     */
    get masterVersion(): string;
    private _minMasterVersion?;
    /**
     * @stability stable
     */
    get minMasterVersion(): string;
    /**
     * @stability stable
     */
    set minMasterVersion(value: string);
    /**
     * @stability stable
     */
    resetMinMasterVersion(): void;
    /**
     * @stability stable
     */
    get minMasterVersionInput(): string | undefined;
    private _monitoringService?;
    /**
     * @stability stable
     */
    get monitoringService(): string;
    /**
     * @stability stable
     */
    set monitoringService(value: string);
    /**
     * @stability stable
     */
    resetMonitoringService(): void;
    /**
     * @stability stable
     */
    get monitoringServiceInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _network?;
    /**
     * @stability stable
     */
    get network(): string;
    /**
     * @stability stable
     */
    set network(value: string);
    /**
     * @stability stable
     */
    resetNetwork(): void;
    /**
     * @stability stable
     */
    get networkInput(): string | undefined;
    private _networkingMode?;
    /**
     * @stability stable
     */
    get networkingMode(): string;
    /**
     * @stability stable
     */
    set networkingMode(value: string);
    /**
     * @stability stable
     */
    resetNetworkingMode(): void;
    /**
     * @stability stable
     */
    get networkingModeInput(): string | undefined;
    private _nodeLocations?;
    /**
     * @stability stable
     */
    get nodeLocations(): string[];
    /**
     * @stability stable
     */
    set nodeLocations(value: string[]);
    /**
     * @stability stable
     */
    resetNodeLocations(): void;
    /**
     * @stability stable
     */
    get nodeLocationsInput(): string[] | undefined;
    private _nodeVersion?;
    /**
     * @stability stable
     */
    get nodeVersion(): string;
    /**
     * @stability stable
     */
    set nodeVersion(value: string);
    /**
     * @stability stable
     */
    resetNodeVersion(): void;
    /**
     * @stability stable
     */
    get nodeVersionInput(): string | undefined;
    /**
     * @stability stable
     */
    get operation(): string;
    private _privateIpv6GoogleAccess?;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccess(): string;
    /**
     * @stability stable
     */
    set privateIpv6GoogleAccess(value: string);
    /**
     * @stability stable
     */
    resetPrivateIpv6GoogleAccess(): void;
    /**
     * @stability stable
     */
    get privateIpv6GoogleAccessInput(): string | undefined;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _removeDefaultNodePool?;
    /**
     * @stability stable
     */
    get removeDefaultNodePool(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set removeDefaultNodePool(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetRemoveDefaultNodePool(): void;
    /**
     * @stability stable
     */
    get removeDefaultNodePoolInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceLabels?;
    /**
     * @stability stable
     */
    get resourceLabels(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set resourceLabels(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetResourceLabels(): void;
    /**
     * @stability stable
     */
    get resourceLabelsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    /**
     * @stability stable
     */
    get selfLink(): string;
    /**
     * @stability stable
     */
    get servicesIpv4Cidr(): string;
    private _subnetwork?;
    /**
     * @stability stable
     */
    get subnetwork(): string;
    /**
     * @stability stable
     */
    set subnetwork(value: string);
    /**
     * @stability stable
     */
    resetSubnetwork(): void;
    /**
     * @stability stable
     */
    get subnetworkInput(): string | undefined;
    /**
     * @stability stable
     */
    get tpuIpv4CidrBlock(): string;
    private _addonsConfig;
    /**
     * @stability stable
     */
    get addonsConfig(): ContainerClusterAddonsConfigOutputReference;
    /**
     * @stability stable
     */
    putAddonsConfig(value: ContainerClusterAddonsConfig): void;
    /**
     * @stability stable
     */
    resetAddonsConfig(): void;
    /**
     * @stability stable
     */
    get addonsConfigInput(): ContainerClusterAddonsConfig | undefined;
    private _authenticatorGroupsConfig;
    /**
     * @stability stable
     */
    get authenticatorGroupsConfig(): ContainerClusterAuthenticatorGroupsConfigOutputReference;
    /**
     * @stability stable
     */
    putAuthenticatorGroupsConfig(value: ContainerClusterAuthenticatorGroupsConfig): void;
    /**
     * @stability stable
     */
    resetAuthenticatorGroupsConfig(): void;
    /**
     * @stability stable
     */
    get authenticatorGroupsConfigInput(): ContainerClusterAuthenticatorGroupsConfig | undefined;
    private _clusterAutoscaling;
    /**
     * @stability stable
     */
    get clusterAutoscaling(): ContainerClusterClusterAutoscalingOutputReference;
    /**
     * @stability stable
     */
    putClusterAutoscaling(value: ContainerClusterClusterAutoscaling): void;
    /**
     * @stability stable
     */
    resetClusterAutoscaling(): void;
    /**
     * @stability stable
     */
    get clusterAutoscalingInput(): ContainerClusterClusterAutoscaling | undefined;
    private _databaseEncryption;
    /**
     * @stability stable
     */
    get databaseEncryption(): ContainerClusterDatabaseEncryptionOutputReference;
    /**
     * @stability stable
     */
    putDatabaseEncryption(value: ContainerClusterDatabaseEncryption): void;
    /**
     * @stability stable
     */
    resetDatabaseEncryption(): void;
    /**
     * @stability stable
     */
    get databaseEncryptionInput(): ContainerClusterDatabaseEncryption | undefined;
    private _defaultSnatStatus;
    /**
     * @stability stable
     */
    get defaultSnatStatus(): ContainerClusterDefaultSnatStatusOutputReference;
    /**
     * @stability stable
     */
    putDefaultSnatStatus(value: ContainerClusterDefaultSnatStatus): void;
    /**
     * @stability stable
     */
    resetDefaultSnatStatus(): void;
    /**
     * @stability stable
     */
    get defaultSnatStatusInput(): ContainerClusterDefaultSnatStatus | undefined;
    private _ipAllocationPolicy;
    /**
     * @stability stable
     */
    get ipAllocationPolicy(): ContainerClusterIpAllocationPolicyOutputReference;
    /**
     * @stability stable
     */
    putIpAllocationPolicy(value: ContainerClusterIpAllocationPolicy): void;
    /**
     * @stability stable
     */
    resetIpAllocationPolicy(): void;
    /**
     * @stability stable
     */
    get ipAllocationPolicyInput(): ContainerClusterIpAllocationPolicy | undefined;
    private _loggingConfig;
    /**
     * @stability stable
     */
    get loggingConfig(): ContainerClusterLoggingConfigOutputReference;
    /**
     * @stability stable
     */
    putLoggingConfig(value: ContainerClusterLoggingConfig): void;
    /**
     * @stability stable
     */
    resetLoggingConfig(): void;
    /**
     * @stability stable
     */
    get loggingConfigInput(): ContainerClusterLoggingConfig | undefined;
    private _maintenancePolicy;
    /**
     * @stability stable
     */
    get maintenancePolicy(): ContainerClusterMaintenancePolicyOutputReference;
    /**
     * @stability stable
     */
    putMaintenancePolicy(value: ContainerClusterMaintenancePolicy): void;
    /**
     * @stability stable
     */
    resetMaintenancePolicy(): void;
    /**
     * @stability stable
     */
    get maintenancePolicyInput(): ContainerClusterMaintenancePolicy | undefined;
    private _masterAuth;
    /**
     * @stability stable
     */
    get masterAuth(): ContainerClusterMasterAuthOutputReference;
    /**
     * @stability stable
     */
    putMasterAuth(value: ContainerClusterMasterAuth): void;
    /**
     * @stability stable
     */
    resetMasterAuth(): void;
    /**
     * @stability stable
     */
    get masterAuthInput(): ContainerClusterMasterAuth | undefined;
    private _masterAuthorizedNetworksConfig;
    /**
     * @stability stable
     */
    get masterAuthorizedNetworksConfig(): ContainerClusterMasterAuthorizedNetworksConfigOutputReference;
    /**
     * @stability stable
     */
    putMasterAuthorizedNetworksConfig(value: ContainerClusterMasterAuthorizedNetworksConfig): void;
    /**
     * @stability stable
     */
    resetMasterAuthorizedNetworksConfig(): void;
    /**
     * @stability stable
     */
    get masterAuthorizedNetworksConfigInput(): ContainerClusterMasterAuthorizedNetworksConfig | undefined;
    private _monitoringConfig;
    /**
     * @stability stable
     */
    get monitoringConfig(): ContainerClusterMonitoringConfigOutputReference;
    /**
     * @stability stable
     */
    putMonitoringConfig(value: ContainerClusterMonitoringConfig): void;
    /**
     * @stability stable
     */
    resetMonitoringConfig(): void;
    /**
     * @stability stable
     */
    get monitoringConfigInput(): ContainerClusterMonitoringConfig | undefined;
    private _networkPolicy;
    /**
     * @stability stable
     */
    get networkPolicy(): ContainerClusterNetworkPolicyOutputReference;
    /**
     * @stability stable
     */
    putNetworkPolicy(value: ContainerClusterNetworkPolicy): void;
    /**
     * @stability stable
     */
    resetNetworkPolicy(): void;
    /**
     * @stability stable
     */
    get networkPolicyInput(): ContainerClusterNetworkPolicy | undefined;
    private _nodeConfig;
    /**
     * @stability stable
     */
    get nodeConfig(): ContainerClusterNodeConfigOutputReference;
    /**
     * @stability stable
     */
    putNodeConfig(value: ContainerClusterNodeConfig): void;
    /**
     * @stability stable
     */
    resetNodeConfig(): void;
    /**
     * @stability stable
     */
    get nodeConfigInput(): ContainerClusterNodeConfig | undefined;
    private _nodePool?;
    /**
     * @stability stable
     */
    get nodePool(): ContainerClusterNodePool[];
    /**
     * @stability stable
     */
    set nodePool(value: ContainerClusterNodePool[]);
    /**
     * @stability stable
     */
    resetNodePool(): void;
    /**
     * @stability stable
     */
    get nodePoolInput(): ContainerClusterNodePool[] | undefined;
    private _podSecurityPolicyConfig;
    /**
     * @stability stable
     */
    get podSecurityPolicyConfig(): ContainerClusterPodSecurityPolicyConfigOutputReference;
    /**
     * @stability stable
     */
    putPodSecurityPolicyConfig(value: ContainerClusterPodSecurityPolicyConfig): void;
    /**
     * @stability stable
     */
    resetPodSecurityPolicyConfig(): void;
    /**
     * @stability stable
     */
    get podSecurityPolicyConfigInput(): ContainerClusterPodSecurityPolicyConfig | undefined;
    private _privateClusterConfig;
    /**
     * @stability stable
     */
    get privateClusterConfig(): ContainerClusterPrivateClusterConfigOutputReference;
    /**
     * @stability stable
     */
    putPrivateClusterConfig(value: ContainerClusterPrivateClusterConfig): void;
    /**
     * @stability stable
     */
    resetPrivateClusterConfig(): void;
    /**
     * @stability stable
     */
    get privateClusterConfigInput(): ContainerClusterPrivateClusterConfig | undefined;
    private _releaseChannel;
    /**
     * @stability stable
     */
    get releaseChannel(): ContainerClusterReleaseChannelOutputReference;
    /**
     * @stability stable
     */
    putReleaseChannel(value: ContainerClusterReleaseChannel): void;
    /**
     * @stability stable
     */
    resetReleaseChannel(): void;
    /**
     * @stability stable
     */
    get releaseChannelInput(): ContainerClusterReleaseChannel | undefined;
    private _resourceUsageExportConfig;
    /**
     * @stability stable
     */
    get resourceUsageExportConfig(): ContainerClusterResourceUsageExportConfigOutputReference;
    /**
     * @stability stable
     */
    putResourceUsageExportConfig(value: ContainerClusterResourceUsageExportConfig): void;
    /**
     * @stability stable
     */
    resetResourceUsageExportConfig(): void;
    /**
     * @stability stable
     */
    get resourceUsageExportConfigInput(): ContainerClusterResourceUsageExportConfig | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ContainerClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerClusterTimeouts | undefined;
    private _verticalPodAutoscaling;
    /**
     * @stability stable
     */
    get verticalPodAutoscaling(): ContainerClusterVerticalPodAutoscalingOutputReference;
    /**
     * @stability stable
     */
    putVerticalPodAutoscaling(value: ContainerClusterVerticalPodAutoscaling): void;
    /**
     * @stability stable
     */
    resetVerticalPodAutoscaling(): void;
    /**
     * @stability stable
     */
    get verticalPodAutoscalingInput(): ContainerClusterVerticalPodAutoscaling | undefined;
    private _workloadIdentityConfig;
    /**
     * @stability stable
     */
    get workloadIdentityConfig(): ContainerClusterWorkloadIdentityConfigOutputReference;
    /**
     * @stability stable
     */
    putWorkloadIdentityConfig(value: ContainerClusterWorkloadIdentityConfig): void;
    /**
     * @stability stable
     */
    resetWorkloadIdentityConfig(): void;
    /**
     * @stability stable
     */
    get workloadIdentityConfigInput(): ContainerClusterWorkloadIdentityConfig | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
