import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleCloudIdentityGroupsConfig extends cdktf.TerraformMetaArguments {
    /**
     * The resource name of the entity under which this Group resides in the Cloud Identity resource hierarchy.
     *
     * Must be of the form identitysources/{identity_source_id} for external-identity-mapped
     * groups or customers/{customer_id} for Google Groups.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups#parent DataGoogleCloudIdentityGroups#parent}
     *
     * @stability stable
     */
    readonly parent: string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupsGroupsGroupKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get namespace(): string;
}
/**
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroupsGroups extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get createTime(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get groupKey(): any;
    /**
     * @stability stable
     */
    get initialGroupConfig(): string;
    /**
     * @stability stable
     */
    get labels(): any;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    get updateTime(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups google_cloud_identity_groups}.
 *
 * @stability stable
 */
export declare class DataGoogleCloudIdentityGroups extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/cloud_identity_groups google_cloud_identity_groups} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleCloudIdentityGroupsConfig);
    /**
     * @stability stable
     */
    groups(index: string): DataGoogleCloudIdentityGroupsGroups;
    /**
     * @stability stable
     */
    get id(): string;
    private _parent?;
    /**
     * @stability stable
     */
    get parent(): string;
    /**
     * @stability stable
     */
    set parent(value: string);
    /**
     * @stability stable
     */
    get parentInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
