import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleIamTestablePermissionsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions#custom_support_level DataGoogleIamTestablePermissions#custom_support_level}.
     *
     * @stability stable
     */
    readonly customSupportLevel?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions#full_resource_name DataGoogleIamTestablePermissions#full_resource_name}.
     *
     * @stability stable
     */
    readonly fullResourceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions#stages DataGoogleIamTestablePermissions#stages}.
     *
     * @stability stable
     */
    readonly stages?: string[];
}
/**
 * @stability stable
 */
export declare class DataGoogleIamTestablePermissionsPermissions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get apiDisabled(): any;
    /**
     * @stability stable
     */
    get customSupportLevel(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get stage(): string;
    /**
     * @stability stable
     */
    get title(): string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions google_iam_testable_permissions}.
 *
 * @stability stable
 */
export declare class DataGoogleIamTestablePermissions extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/iam_testable_permissions google_iam_testable_permissions} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleIamTestablePermissionsConfig);
    private _customSupportLevel?;
    /**
     * @stability stable
     */
    get customSupportLevel(): string;
    /**
     * @stability stable
     */
    set customSupportLevel(value: string);
    /**
     * @stability stable
     */
    resetCustomSupportLevel(): void;
    /**
     * @stability stable
     */
    get customSupportLevelInput(): string | undefined;
    private _fullResourceName?;
    /**
     * @stability stable
     */
    get fullResourceName(): string;
    /**
     * @stability stable
     */
    set fullResourceName(value: string);
    /**
     * @stability stable
     */
    get fullResourceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    permissions(index: string): DataGoogleIamTestablePermissionsPermissions;
    private _stages?;
    /**
     * @stability stable
     */
    get stages(): string[];
    /**
     * @stability stable
     */
    set stages(value: string[]);
    /**
     * @stability stable
     */
    resetStages(): void;
    /**
     * @stability stable
     */
    get stagesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
