import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataGoogleServiceAccountAccessTokenConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token#delegates DataGoogleServiceAccountAccessToken#delegates}.
     *
     * @stability stable
     */
    readonly delegates?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token#lifetime DataGoogleServiceAccountAccessToken#lifetime}.
     *
     * @stability stable
     */
    readonly lifetime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token#scopes DataGoogleServiceAccountAccessToken#scopes}.
     *
     * @stability stable
     */
    readonly scopes: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token#target_service_account DataGoogleServiceAccountAccessToken#target_service_account}.
     *
     * @stability stable
     */
    readonly targetServiceAccount: string;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token google_service_account_access_token}.
 *
 * @stability stable
 */
export declare class DataGoogleServiceAccountAccessToken extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/d/service_account_access_token google_service_account_access_token} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataGoogleServiceAccountAccessTokenConfig);
    /**
     * @stability stable
     */
    get accessToken(): string;
    private _delegates?;
    /**
     * @stability stable
     */
    get delegates(): string[];
    /**
     * @stability stable
     */
    set delegates(value: string[]);
    /**
     * @stability stable
     */
    resetDelegates(): void;
    /**
     * @stability stable
     */
    get delegatesInput(): string[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _lifetime?;
    /**
     * @stability stable
     */
    get lifetime(): string;
    /**
     * @stability stable
     */
    set lifetime(value: string);
    /**
     * @stability stable
     */
    resetLifetime(): void;
    /**
     * @stability stable
     */
    get lifetimeInput(): string | undefined;
    private _scopes?;
    /**
     * @stability stable
     */
    get scopes(): string[];
    /**
     * @stability stable
     */
    set scopes(value: string[]);
    /**
     * @stability stable
     */
    get scopesInput(): string[] | undefined;
    private _targetServiceAccount?;
    /**
     * @stability stable
     */
    get targetServiceAccount(): string;
    /**
     * @stability stable
     */
    set targetServiceAccount(value: string);
    /**
     * @stability stable
     */
    get targetServiceAccountInput(): string | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
