import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface GameServicesGameServerDeploymentRolloutConfig extends cdktf.TerraformMetaArguments {
    /**
     * This field points to the game server config that is applied by default to all realms and clusters. For example,.
     *
     * 'projects/my-project/locations/global/gameServerDeployments/my-game/configs/my-config'.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#default_game_server_config GameServicesGameServerDeploymentRollout#default_game_server_config}
     *
     * @stability stable
     */
    readonly defaultGameServerConfig: string;
    /**
     * The deployment to rollout the new config to. Only 1 rollout must be associated with each deployment.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#deployment_id GameServicesGameServerDeploymentRollout#deployment_id}
     *
     * @stability stable
     */
    readonly deploymentId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#project GameServicesGameServerDeploymentRollout#project}.
     *
     * @stability stable
     */
    readonly project?: string;
    /**
     * game_server_config_overrides block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#game_server_config_overrides GameServicesGameServerDeploymentRollout#game_server_config_overrides}
     *
     * @stability stable
     */
    readonly gameServerConfigOverrides?: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#timeouts GameServicesGameServerDeploymentRollout#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: GameServicesGameServerDeploymentRolloutTimeouts;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector {
    /**
     * List of realms to match against.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#realms GameServicesGameServerDeploymentRollout#realms}
     *
     * @stability stable
     */
    readonly realms?: string[];
}
export declare function gameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorToTerraform(struct?: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference | GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector): any;
/**
 * @stability stable
 */
export declare class GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelectorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector | undefined);
    private _realms?;
    /**
     * @stability stable
     */
    get realms(): string[];
    /**
     * @stability stable
     */
    set realms(value: string[]);
    /**
     * @stability stable
     */
    resetRealms(): void;
    /**
     * @stability stable
     */
    get realmsInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface GameServicesGameServerDeploymentRolloutGameServerConfigOverrides {
    /**
     * Version of the configuration.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#config_version GameServicesGameServerDeploymentRollout#config_version}
     *
     * @stability stable
     */
    readonly configVersion?: string;
    /**
     * realms_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#realms_selector GameServicesGameServerDeploymentRollout#realms_selector}
     *
     * @stability stable
     */
    readonly realmsSelector?: GameServicesGameServerDeploymentRolloutGameServerConfigOverridesRealmsSelector;
}
export declare function gameServicesGameServerDeploymentRolloutGameServerConfigOverridesToTerraform(struct?: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides): any;
/**
 * @stability stable
 */
export interface GameServicesGameServerDeploymentRolloutTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#create GameServicesGameServerDeploymentRollout#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#delete GameServicesGameServerDeploymentRollout#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout#update GameServicesGameServerDeploymentRollout#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function gameServicesGameServerDeploymentRolloutTimeoutsToTerraform(struct?: GameServicesGameServerDeploymentRolloutTimeoutsOutputReference | GameServicesGameServerDeploymentRolloutTimeouts): any;
/**
 * @stability stable
 */
export declare class GameServicesGameServerDeploymentRolloutTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): GameServicesGameServerDeploymentRolloutTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: GameServicesGameServerDeploymentRolloutTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout}.
 *
 * @stability stable
 */
export declare class GameServicesGameServerDeploymentRollout extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/google/r/game_services_game_server_deployment_rollout google_game_services_game_server_deployment_rollout} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: GameServicesGameServerDeploymentRolloutConfig);
    private _defaultGameServerConfig?;
    /**
     * @stability stable
     */
    get defaultGameServerConfig(): string;
    /**
     * @stability stable
     */
    set defaultGameServerConfig(value: string);
    /**
     * @stability stable
     */
    get defaultGameServerConfigInput(): string | undefined;
    private _deploymentId?;
    /**
     * @stability stable
     */
    get deploymentId(): string;
    /**
     * @stability stable
     */
    set deploymentId(value: string);
    /**
     * @stability stable
     */
    get deploymentIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get name(): string;
    private _project?;
    /**
     * @stability stable
     */
    get project(): string;
    /**
     * @stability stable
     */
    set project(value: string);
    /**
     * @stability stable
     */
    resetProject(): void;
    /**
     * @stability stable
     */
    get projectInput(): string | undefined;
    private _gameServerConfigOverrides?;
    /**
     * @stability stable
     */
    get gameServerConfigOverrides(): GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[];
    /**
     * @stability stable
     */
    set gameServerConfigOverrides(value: GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[]);
    /**
     * @stability stable
     */
    resetGameServerConfigOverrides(): void;
    /**
     * @stability stable
     */
    get gameServerConfigOverridesInput(): GameServicesGameServerDeploymentRolloutGameServerConfigOverrides[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): GameServicesGameServerDeploymentRolloutTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: GameServicesGameServerDeploymentRolloutTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): GameServicesGameServerDeploymentRolloutTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
